/* tune_fft
 * tune_main.c
 */

/* fft-based filter */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "tune_fft.h"

unsigned char inbuf[FFTBUFSIZ],outbuf[FFTBUFSIZ];


#define ABS(x)	(((x)>=0.0)?(x):-(x))


extern fixed re[FFTBUFSIZ],im[FFTBUFSIZ];


int main(int argc,char *argv[])
{
FILE *in;
int f,max,maxpos,siz;
double rate;

if(argc!=2)
  {
  printf("usage: tunesam sample\n");
  exit(1);
  }

if((in=fopen(argv[1],"rb"))==NULL)
  {
  fprintf(stderr,"Couldn't open sample file.\n");
  exit(1);
  }

fftinit();
memset(inbuf,128,FFTBUFSIZ);
while((siz=fread(inbuf,1,FFTBUFSIZ,in))>0)
  {
  inbuf2re(inbuf);
  fft();
  freq2outbuf(outbuf);
  
  /* check here */
  max=0; maxpos=1;
  for(f=1;f<FFTBUFSIZ/2;f++)
    if(max<outbuf[f]) max=outbuf[f],maxpos=f;
  
  /* maxpos is (effectively) a function of note freq. and sample rate.
   * we assume the frequency should be a C, and deduce the sample rate.
   * strictly, freq=(maxpos*sample_rate)/FFTBUFSIZ.
   * rearranged, sample_rate=(freq*FFTBUFSIZ)/maxpos.
   */
  
  rate=(261.63*FFTBUFSIZ)/(double)maxpos;
  printf("%5.2f\n",rate);
  
  memset(inbuf,128,FFTBUFSIZ);
  }

fclose(in);
exit(0);
}
