
dnl ------------------------------
dnl SADP configuration macros
dnl ------------------------------

AC_DEFUN(SADP_CPU_TYPE, 
[
dnl Check processor type...
AC_MSG_CHECKING([compiler flags])

CFLAGS="-O2 "
AC_CHECK_HEADERS(linux/autoconf.h) 

if test "${ac_cv_header_linux_autoconf_h}" = yes; then
AC_TRY_RUN([
 #include <stdio.h>
 #include <linux/autoconf.h>
 int main(void)
 {
  	FILE *f;
  
  	f = fopen(".cpu_id", "w+");
  	if (f==NULL) exit(1);
  
  	fprintf(f, "-O2 ");
  
 #if defined(CONFIG_M386)
	fprintf(f, "-m386");
 #elif defined(CONFIG_M486)
	fprintf(f, "-m486");
 #elif defined(CONFIG_M586) || defined(CONFIG_M586TSC) || defined(CONFIG_M686)
	fprintf(f, "-m486 -malign-loops=2 -malign-jumps=2 -malign-functions=2"); 
 #elif defined(CONFIG_EV4) || defined(CONFIG_EV5) || defined(CONFIG_EV6)
         fprintf(f, "-fno-strength-reduce -mno-fp-regs -ffixed-8"); 
 #endif
          fclose(f);
          exit(0);
  }
  ], CFLAGS=`cat .cpu_id`; rm -f .cpu_id, CFLAGS="-O2", CFLAGS="-O2") 
  
  AC_MSG_RESULT($CFLAGS)
  
fi
])

AC_DEFUN(SADP_CHECK_ALSA_VERSION, 
[
dnl Check ALSA version...
AC_MSG_CHECKING([ALSA driver version])

AC_TRY_RUN([
 #include <stdio.h>
 #include <linux/asound.h>
 int main(void)
 {
  	FILE *f;
  
  	f = fopen(".alsa_version", "w+");
  	if (f==NULL) exit(1);
  

#if defined(SND_PCM_IOCTL_CAPTURE_INFO)
  	fprintf(f, "4");
#elif defined(SND_PCM_IOCTL_CHANNEL_INFO)
  	fprintf(f, "5");
#else
  	fprintf(f, "0");
#endif

      fclose(f);
      exit(0);
  }
  ], have_alsa=`cat .alsa_version`; rm -f .alsa_version, have_alsa=0, have_alsa=0 ) 

if test  ${have_alsa} = 0; then 
    AC_MSG_RESULT([unknown])
else
    AC_MSG_RESULT("${have_alsa}")
fi
  
])
