#include <sys/types.h>
#include "sadp_config.h"

#define MAX_VOLUME  100
#define MAX_BALANCE 100

#define SADP_VERSION  0x30105
#define TIME_DISPLAY_MODES 4

#define INTERLACE_MIN 0
#define INTERLACE_MAX 5
#define GAIN_MIN -8
#define GAIN_MAX 8
#define VSCALE_MIN -5
#define VSCALE_MAX 5

#define PREFSET_NAME_SIZE 51
#define OWNER_NAME_SIZE 41

#define DEV_NODEV (-1)
#define DEV_EXPLICIT (-2)


#if !HAVE_TIME
typedef  long time_t;
time_t time(time_t *);
#endif

typedef enum
{
/* ---- The following 17 buttons are used in main window   ---- */
/* ---- and  covered by OperNotation and BtnInfo           ---- */
   OPER_PREV, OPER_BACK,  OPER_FWD,  OPER_NEXT,
   OPER_PLAY, OPER_PAUSE, OPER_QUIT,
   OPER_STOP, OPER_NEXT5, OPER_PREV5,
   OPER_MIXERPREV, OPER_MIXERNEXT,
   OPER_STOPQUIT, OPER_HELP, OPER_REFRESH, OPER_SUSPEND,
   OPER_SAVEO,

/* ---- The following 3 buttons are used in help mode only ---- */
/* ---- and covered by OperNotation but not BtnInfo        ---- */
   OPER_PLAYBACK, OPER_HELPPREV, OPER_HELPNEXT,

/* ---- The following 6 buttons have variable appearence   ---- */
/* ---- and covered by BtnInfo, but not OperNotation       ---- */
   OPER_TIMEDISPLAY, OPER_AUTOPLAY, OPER_LOOPPLAY,
   OPER_PLAYMODE,    OPER_INPUT,    OPER_CHANGESLOT,

/* ---- The following commands are used as buttons         ---- */
/* ---- in XForms mode only                                ---- */
   OPER_FIRSTTRACK, OPER_LASTTRACK, OPER_FOCUS,

/* ---- The following are commands that do not correspond  ---- */
/* ---- to any button                                      ---- */
   OPER_PLAYFROM, OPER_PLAYFROMALIGNED,
   OPER_SPECIAL,   OPER_NONE

} OPERATION;


#define CBUTTONS   17     /* Common buttons */
#define HBUTTONS    3     /* OperNotation only */
#define UBUTTONS    6     /* BtnInfo only */
#define XFBUTTONS   4     /* XForms only */

typedef enum
{  PLTF_CURSES, PLTF_XFORMS } PLATFORM;

typedef enum
{  PLAY_NORMAL, PLAY_LIST, PLAY_RANDOM, PLAY_INTRO, PLAY_SINGLE}
			PLAY_MODE_TYPE;
/* PLAY_LOOP, PLAY_REPEAT, */
typedef enum
{  ACCESS_UNDEF, ACCESS_PLAY, ACCESS_STOP,
   ACCESS_EJECT, ACCESS_LOAD, ACCESS_POSITION }
			ACCESS_TYPE;

typedef enum
{    DM_ELAPSED,   DM_REMAINED,
     DM_PROGRESS,    DM_PROGREM }
     TIME_DISPLAY_MODE_TYPE;

typedef enum
{   SDM_MODULUS = 1,
    SDM_REAL = 2,
    SDM_IMAG = 3,
    SDM_COMB = 4
} SPECTR_DISPLAY_MODE;

typedef enum
{   CDTYPE_SCSI, 
    CDTYPE_SCSI_EMU,	
    CDTYPE_ATAPI,
    CDTYPE_OTHER,
    CDTYPE_UNKNOWN
} CDTYPE;


typedef struct
{  double r;
   double i;
} CPLX;

typedef struct
{	u_long  start;
	char    name[DATA_NAME_SIZE];
	char    artist[DATA_NAME_SIZE];
	char    extra[EXTRA_NAME_SIZE];
	u_char  audio, skip;
} TRACK_INFO;

typedef struct
{	short	  playlist_size, skiplist_size;
	u_char *playlist, *skiplist;	
	char	  name[PREFSET_NAME_SIZE];	  
	char	  owner[OWNER_NAME_SIZE];	  
	char    written;
} PREFSET_INFO;

/* Hopefully we should not have an overflow in this case. */
#define time_diff(to, from)  (((to).tv_sec - (from).tv_sec) * 1000000l + \
				      ((to).tv_usec - (from).tv_usec) )
/* incr must NOT be negative here */
#define time_plus(tv, incr)   (tv).tv_usec += incr; \
			      (tv).tv_sec += (tv).tv_usec/1000000l; \
			      (tv).tv_usec %= 1000000l  
		
int  process_arguments(int argc, char **argv);

/* Screen interface functions */
PLATFORM get_platform(void);
int screen_initialize(int argc, char *argv[]);
void screen_deinitialize(void);
int foreground_processing(void);
OPERATION  get_action(void);
void show_status_message(const char *status, short ind);
void show_cd_time(void);
void draw_volume(unsigned char volumel, unsigned char volumer);
void show_volume(void);
void show_mixer_input(void);
void show_mixer_device(void);
void show_mode(OPERATION mode);
void clear_cd_time(void);
void draw_spectrum(void);
void draw_wave(void);
void redraw_screen(void);
void refresh_output(void);
void set_suspend_mode(short NewMode);
void  draw_mwnd_bottom(void);
void  print_epilogue(void);
u_short get_kbd_shift(void);

/*  cdaudio functions  */
int cdaudio_initialize(void);
int cdaudio_deinitialize(void);
int cdaudio_start(void);
char *cdaudio_get_track_name(u_char track);
char *cdaudio_get_track_artist(u_char track);
char *cdaudio_get_track_extra(u_char track);
int  cdaudio_get_track_skip(u_char track);

int cdaudio_operate(OPERATION oper);
int check_cd(void);
int cd_playtrack(int track, int force);
int cd_lockdoor(int flag);
void time_to_msf(u_long timemsf,
                    u_char *min, u_char *sec, u_char *frm);
short cd_check_multisession(void);
short cd_setvolume(u_char vol_left, u_char vol_right);
void  cd_accept_play_mode(void);
short cd_getvolume(void);
void cd_shuflist_create(void);
const u_char *cd_get_mcn(void);
int select_slot(int disc_no);

/* Sound functions */
int sound_initialize(void);
void sound_terminate(void);
int sound_start(void);
int audio_reinitialize(void);
void sound_process(void);
void audio_stop(void);
void mixer_setvolume(u_int new_volume, u_int new_balance);
void mixer_changevolume(int volume_inc, int balance_inc);
void mixer_toggleinput(void);
short mixer_set_device_volume(short device,
				 u_int new_volume, u_int new_balance);
int mixer_get_volumes(u_int *volumes, u_int *balances);
int mixer_accept_next_device(void);
int mixer_accept_prev_device(void);
void  accept_focus(void);
void ft_process(CPLX *spectrum, CPLX signal[], int f);
int requery_mixer(void);



/* Info functions */
#define INFO_LINE_SIZE  30

int  prepare_info_page(void);
void update_info_page(void);
void release_info_page(void);
int get_audio_name(const char *file_name, const char *pattern,
				  const char *section_name,
				  char  *device_name,
	                          short *node_no,
    		                  char  *logical_name_start,
				  char  *logical_name_end);
int get_cpu_type(char *line, const char *sign, char *retval);
short get_cpu_data(char *cputype, char *cpumodel, double *cpuclock, double *mips);

int get_sound_version(char *type_return, char *version_return,
			                       char *alsa_emu_return);
int  get_alsa_sound_version(char  *type_return,
				    char  *version_return);


short get_os_data(char *ostype, char *osversion);
char *get_sadp_version(void);

/* Data Base maintenance */
#define  read_local_db()   scdb_find()
void save_local_db(void);
char *generate_cdindex(void);
void  scdb_initialize(void);
void  scdb_terminate(void);
short scdb_find(void);
short scdb_write(void);
const char *get_owner_name(void);
void  clear_disc_tracks(void);


/* Preference sets */
short  cd_set_track_skipability(short track, short flag);
short  cd_track_skipability(short track);
PREFSET_INFO *cd_create_prefset(const char *name);
void  cd_accept_prefset(short number);
void  cd_prepare_save_prefsets(void);
void  cd_select_default_prefset(void);
	  
short  cd_insert_playlist_line(short pos, u_short track);
short  cd_delete_playlist_line(short pos);

/* Settings saving */
char *get_full_fname(const char *shortname);
void save_settings(void);
short ask_save_question(const char *message);
void show_error_message(const char *message);
void launch_message(const char *message);

/* RCDDB support */
void rcddb_initialize (void);
void rcddb_terminate (void);
void rcddb_initargs(void);
int process_cddb_line(char *line, int remote_flag);
unsigned long  get_cddb_discid(void);

/* Extended functions */
void init_features(int cdr_fd);
void deinit_features(void);

/* Common functions */
void trim(char *line);
char *strtokm(char *line, const char *delim);
const char *get_full_track_name(short track_number);
char *get_current_artist(short track_number);
void stupid_beep(void);
char *string_substitute(const char *source,
     const char *pattern, const char *subst);


#if  defined(CD_EXTENSION_SUPPORT)
short process_cdtext(void);
#endif

#if  defined(CD_EXTRA_SUPPORT)
short process_cdextra(void);
#endif

int  ProcessDeviceName(const char *option,
     const char *type, const char *prefix,
     char *dev_name,  int *dev_no);

