/*  =========================================================
    SING - ALONG DISK PLAYER.  (C) 1999, Michael Glickman
    ----------------------------------------------------------
    This module implements interface to CDDB and FreeDB.
    Some functions in this file originate from CDDB HOWTO,
    and used here after minor optimization and adaptation.
    ========================================================= */

#include <sys/types.h>
#include <linux/cdrom.h>

#include "sad.h"


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "sadp_rcddb.h"

extern u_long cddb_disc_id;
extern u_char dtrack_first, dtrack_last;
extern TRACK_INFO  *trk_info;     
extern char  disc_name[DATA_NAME_SIZE], disc_artist[DATA_NAME_SIZE];
extern char  disc_extra[EXTRA_NAME_SIZE];
extern char  *AppName, AppVersion[];
extern u_long disc_revision;
extern short cd_multi_artist;

extern void write_split_text(FILE *f, char *header,
                        char *text, int part_len);

#ifndef P_tmpdir
#define P_tmpdir "/tmp"
#endif

#if defined(RCDDB_SUPPORT) || defined(DEFAULT_XMCD_PATH)

static int  tot_trks;
static u_long  tot_duration; 

#if defined(DEFAULT_XMCD_PATH)
/* ================= Local playlist ========== */

#define MAX_XMCD_PLIST_SIZE 500
extern short  cd_playlist_size;
extern u_char *cd_playlist;
extern u_char track_first,  track_last;



/* N.B. We assume no spaces between track numbers ! */
PREFSET_INFO *process_cddb_plist(const char *txtlist)
{	int  pl_size;
	PREFSET_INFO  *pi;	
	u_char  *plist;	
	u_int cur_track;
	char  *txtlist_sep;
	const char  *txtlist_end;


	if (cd_playlist) free(cd_playlist);
	cd_playlist_size = 0;

	plist = malloc(MAX_XMCD_PLIST_SIZE * sizeof(u_char));
	if (!plist) return NULL;
	txtlist_end = txtlist + strlen(txtlist);
	pl_size = 0;
	

	while (pl_size < MAX_XMCD_PLIST_SIZE && txtlist < txtlist_end)
	{ 
	     cur_track = (u_int) strtol(txtlist, &txtlist_sep, 0);
	     if (txtlist_sep > txtlist &&
               cur_track >= track_first &&
		   cur_track <= track_last)
			plist[pl_size++] = cur_track;
		txtlist = txtlist_sep+1;
	}

	if (pl_size < MAX_XMCD_PLIST_SIZE)
	{   plist = realloc(plist, pl_size * sizeof(u_char));
	    if (!plist) return NULL;
	}


	pi = cd_create_prefset("xmcd port");
	if (!pi) 
	{  free(plist); return NULL; }

	pi->playlist = plist;
	pi->playlist_size = pl_size;	


	return pi;

}
#endif
/*===============================================*/
/* Process line and replaces it by message       */
/* remote_flag = 1 - remote access               */
/*	 	     0 - local access                */
/*-----------------------------------------------*/
/* Returns: 0 - no message, 1-message ready      */
/* Return flag is ignored for local access       */
/*===============================================*/
int process_cddb_line(char *line, int remote_flag)
	/* Process cddb line */ 
{
	 char *name, *artist;
	 u_int trk_no;
	 u_int  len;

	 if (*line == '#') return 0;	/* Comment */
       
       if (memcmp(line, "DTITLE", 6)==0)
       {	artist = strtokm(line+7, "/\r\n");
		name = strtokm(NULL, "\r\n");
		if (name) trim(name);	  
		if (name == NULL || strlen(name)==0) 
		{ name = artist; artist = ""; 
		  cd_multi_artist = 1;
		}

		strncpy(disc_name, name, DATA_NAME_SIZE);      	
		strncpy(disc_artist, artist, DATA_NAME_SIZE);  
		
		if (remote_flag)
			sprintf(line, "Title: %s", name);   	
		return 1;
       }	  
	 else
       if (memcmp(line, "TTITLE", 6)==0)
       {	name = strtokm(line+6, "=\r\n");
		trk_no = atoi(name);       
		artist = "";
		name = strtokm(NULL, "\r\n");
		if (name == NULL) name = "";
		else    
		if (cd_multi_artist)
		{ 
	         /* Trying old style */
	  	   name = strtokm(name, "<");
		   artist = strtokm(NULL, "<>");

	 	   if (artist == NULL || strlen(artist) == 0) 
	 	    /* New style */
	     	   {  artist = strtokm(name, "/");	
	        	name = strtokm(NULL, "");
	       	if (name == NULL || strlen(name)==0) 
	  	      { name = artist; artist = ""; }
	     	   }		
		}

		trim(name); trim(artist);

		if (strlen(name) > 0)	     	  	      
			strncpy(trk_info[trk_no].name, name, DATA_NAME_SIZE);      	

		strncpy(trk_info[trk_no].artist, artist, DATA_NAME_SIZE);  

/*	  sprintf(line, "Track %u: %s", trk_no+dtrack_first, name);   	
            return 1 */
       }
	 else
       if (memcmp(line, "EXTD", 4)==0)
       {
		name = line+5;
		len = strlen(disc_extra);
		if (len < EXTRA_NAME_SIZE)
		{ strtokm(name, "\r\n");
           	  strncpy(disc_extra+len, name, EXTRA_NAME_SIZE-len);
		}
       } 
	 else
       if (memcmp(line, "EXTT", 4)==0)
       {	name = strtokm(line+4, "=\r\n");
 		trk_no = atoi(name);       
		len = strlen(trk_info[trk_no].extra);
		if (len < EXTRA_NAME_SIZE)
		{ name = strtokm(NULL, "\r\n");	
		  if (name == NULL) name = "";
		  strncpy(trk_info[trk_no].extra+len, name, EXTRA_NAME_SIZE-len);
		}

       }
#if defined(DEFAULT_XMCD_PATH)
	 else
	 if (remote_flag==0 && memcmp(line, "PLAYORDER", 9) == 0)
	 {   name = strtokm(line+10, "\r\n");
	     trim(name);	
	     if (strlen(name) > 0)  process_cddb_plist(name);
	 }
#endif
 	 return 0;

}

/* This code remained practically unchanged from cddb_howto */ 
static int cddb_sum(int n)
{
	int	ret;

	ret = 0;
	/* Take sum of all decimal digits */
	while (n > 0) 
	{  ret += (n % 10);  n /= 10; }

	return (ret);
}


/* Another code, originated from cddb_howto */ 
/* Really dumb, but don't blame me for that */
unsigned long get_cddb_discid(void)
{
	int	i, total;
	TRACK_INFO *ti;	

	tot_trks = dtrack_last - dtrack_first + 1;

	ti = trk_info;
	tot_duration = (int) (ti->start /CD_FRAMES);


      ti = trk_info;
	i = total = 0;

	while (i < tot_trks)
	{
	    total += cddb_sum((int)(ti->start / CD_FRAMES));
  	    ti++; i++;
	}
	
	tot_duration = (int) (ti->start/CD_FRAMES) - tot_duration;

	return  (total % 0xff) << 24 | tot_duration << 8 | tot_trks;

}

#endif


#if defined(RCDDB_SUPPORT)

char *get_cddb_query(void)
{	char  *query; 
	TRACK_INFO *ti;	
	int   i;

	query = malloc(61+11*tot_trks); 
	if (query == NULL) return NULL;

        sprintf(query,  "cddb query %08lx %d",
	                        cddb_disc_id, tot_trks);  

        ti = trk_info;
	for (i = 0; i < tot_trks; i++)
	{  
	    sprintf(query, "%s %lu", query, ti->start);
  	    ti++;
	}	    

	sprintf(query, "%s %lu", query, tot_duration);
	
	return query;
}
/*==========================================================*/
/*   Creates a temporary xmcd-style file.                   */
/*   Returns file name and length                           */ 
/*==========================================================*/
short  make_xmcd_file(char **file_name_ptr, long *file_length)
{
    FILE *f;
    int	i;
    long tot_duration;
    TRACK_INFO *ti;	
    static const char *blank_line = "#\n";
    char buf[121];
    char *file_name;
    char *tmp_dir;
    int   tot_trks; 
    
    *file_length = 0;
   

    tmp_dir =  getenv("TMPDIR");
    if (tmp_dir == NULL) tmp_dir = P_tmpdir;
    	
    *file_name_ptr = file_name = malloc(strlen(tmp_dir) + 21);
    if (file_name  == NULL) return 0;   
    sprintf(file_name, "%s/cddb%x.tmp", tmp_dir, getpid());
    f = fopen(file_name, "w");
    if (!f) return 0;

    
    /* Create Header */
    fprintf (f, "# xmcd CD database file generated with %s %s\n", AppName, AppVersion);
    fprintf (f, blank_line);
    fprintf (f, "# Track frame offsets:\n");


    tot_trks = dtrack_last - dtrack_first + 1; 

    ti = trk_info;
/*    tot_duration = (int) (ti->start /CD_FRAMES); */

    i = 0;

    while (i < tot_trks)
    {
	fprintf(f, "#       %ld\n", ti->start);
	ti++;	i++;
    }
	
    tot_duration = (int) (ti->start/CD_FRAMES); /* - tot_duration; */
    fprintf (f, blank_line);
    fprintf(f, "# Disc length: %ld seconds\n", tot_duration);
    fprintf (f, blank_line);

    fprintf(f, "# Revision: %lu\n", disc_revision);

    fprintf(f, "# Submitted via: %s %s - (C) 1998,1999 Michael Glickman \n", AppName, AppVersion);
    fprintf(f, "#     sadp site: http://www.alphalink.com.au/~michg/ace/sadp\n");		
    fprintf (f, blank_line);
    
    /* Finished with comments - write the real stuff */
    fprintf(f, "DISCID=%lx\n", cddb_disc_id);

    strcpy(buf, disc_artist);
    trim(buf);

    if (strlen(buf) > 0)     
        fprintf(f, "DTITLE=%s/%s\n", buf, disc_name); 
    else
        fprintf(f, "DTITLE=%s\n", disc_name);

    i = 0;
    ti = trk_info;

    while (i < tot_trks)
    {
	strcpy(buf, ti->artist);
	trim(buf);
	
	if (strlen(buf) > 0)
	    fprintf(f, "TTITLE%d=%s/%s\n", i, buf, ti->name);
	else
	    fprintf(f, "TTITLE%d=%s\n", i, ti->name);
		    
	ti++;	i++;
    }

    write_split_text(f, "EXTD=", disc_extra, 66); 

    i = 0;
    ti = trk_info;

    while (i < tot_trks)
    {
	  sprintf(buf, "EXTT%d=", i);
        write_split_text(f, buf, ti->extra, 66); 
        ti++; i++;
    }

    fprintf(f, "PLAYORDER=\n");
    *file_length = ftell(f);
    fclose(f);
    return 1;
    
}            
#endif

