/*  =========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com       
    ----------------------------------------------------------
    Functions, contained in this module are copied from cdindex
    program, available from www.cdindex.org.
    All original references and copyright notices are retained.    
    ========================================================= */
#define _GNU_SOURCE
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include "sad.h"
#include "sadp_rcddb.h"

#ifndef P_tmpdir
#define P_tmpdir "/tmp"
#endif

extern unsigned char dtrack_first, dtrack_last;
extern short cd_multi_artist;
extern char  disc_name[61], disc_artist[61];
extern TRACK_INFO  *trk_info;
extern u_long dtime_total;
extern char   *cdix_index;
extern char   *cdix_query;
extern char  *AppName, AppVersion[];
#ifdef RCDDB_SUPPORT

/* __________________________________________________________________________
    make_xml_file
    -------------
    Ceates temporary CD-INDEX compatible XML file
    Returns: file name and file length as references.
    20-Aug-99                         M. G.
  _________________________________________________________________________*/

/* This is just a preamble */
static void  write_xml_record(FILE *f, const char *keyword,
                              const char *content, const char *alternative,
			      int offset )
{   char cont[DATA_NAME_SIZE];

    strncpy(cont, content, DATA_NAME_SIZE);
    trim(cont);
    if (alternative && (*cont == '\0'))
    {   strncpy(cont, alternative, DATA_NAME_SIZE);
        trim(cont);
    }	

    convert_str_sequence(cont, "&", "&amp;");
    convert_str_sequence(cont, "<", "&lt;");
    convert_str_sequence(cont, ">", "&gt;");
    convert_str_sequence(cont, "  ", " &nbsp;"); 
    while (--offset>=0) fputc(' ', f);
    fprintf(f, "<%s>%s</%s>\n", keyword, cont, keyword);
}    

/* A new part of preamble: convert HTML-style char-s to real-life ones */
/* 23-Jan-00  for sadp 2.2.1 */ 
void  convert_str_sequence(char *text, const char *ptrn, const char *subst)
{	char *psep, *target = NULL;
	const char *psource;
	char *ptarget;
	int lptrn, lsubst, lchunk;

	/* Presumably, pattern is not found */
	psep = strstr(text, ptrn);
	if (psep == NULL) return;

	lptrn = strlen(ptrn);
	lsubst = strlen(subst);

	psource = text;
	/* Assuming to more that (DATA_NAME_SIZE) occurencies of pattern */
	if (lptrn < lsubst)
	{	ptarget = target =
	 	      malloc(strlen(text) + DATA_NAME_SIZE*(lsubst-lptrn));
		if (ptarget == NULL) return;
	}
	else
		ptarget = text;


	do
	{	lchunk = psep-psource;
		memcpy(ptarget, psource, lchunk);
	  	ptarget += lchunk;
		memcpy(ptarget, subst, lsubst);		
		ptarget += lsubst;
		psource = psep + lptrn;
		psep = strstr(psource, ptrn);
	} while (psep != NULL);

	/* And the last chunk */
	strcpy(ptarget, psource);

	if (target) 
	{  strncpy(text, target, DATA_NAME_SIZE);
	   free(target);
	}
}

/* Here comes the real stuff */
short  make_xml_file(char **file_name_ptr, long *file_length)
{
    /* The following lines are cloned from make_xmcd_file in sadp_cddb.c */ 
    FILE *f;
    int	i, j;
    char *ptr;
    char *file_name, *tmp_dir;

    time_t time_created;
    
    *file_length = 0;

//    *file_name_ptr = file_name = tempnam(NULL, "cdi");
//    if (file_name  == NULL) return 0;   

    tmp_dir =  getenv("TMPDIR");
    if (tmp_dir == NULL) tmp_dir = P_tmpdir;

    *file_name_ptr = file_name = malloc(strlen(tmp_dir) + 21);
    if (file_name  == NULL) return 0;
    sprintf(file_name, "%s/cdi%x.tmp", tmp_dir, getpid());

    f = fopen(file_name, "w");
    if (!f) return 0;

    
    /* Now we start cloning sample xml file */
    fprintf(f, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
    fprintf(f, "<!DOCTYPE CDInfo SYSTEM \"http://www.cdindex.org/dtd/CDInfo.dtd\">\n");
    time (&time_created);
    ptr = ctime(&time_created);
    strtokm(ptr, "\r\n");
 //   fprintf(f, "<!CREATED \"%s\"  WITH \"%s %s\">\n", ptr, AppName, AppVersion);
    fprintf (f, "\n");
    
    /* CD Info */
    fprintf(f, "<CDInfo>\n\n");
    write_xml_record(f, "Title", disc_name, NULL, 3);
    fprintf(f, "   <NumTracks>%d</NumTracks>\n\n", dtrack_last-dtrack_first+1);

    /* Id Info */
    fprintf(f, "   <IdInfo>\n");
    fprintf(f, "      <DiskId>\n");
    fprintf(f, "         <Id>%s</Id>\n", cdix_index);
    fprintf(f, "         <TOC First=\"%d\" Last=\"%d\">\n", dtrack_first, dtrack_last);
    fprintf(f, "            <Offset Num=\"0\">%lu</Offset>\n", dtime_total);

    for (i=dtrack_first; i<=dtrack_last; i++)
    fprintf(f, "            <Offset Num=\"%d\">%lu</Offset>\n", i,
                                          trk_info[i-dtrack_first].start);
    fprintf(f, "         </TOC>\n");
    fprintf(f, "      </DiskId>\n");
    fprintf(f, "   </IdInfo>\n\n");

    
    if (cd_multi_artist)
    {
       fprintf(f, "   <MultipleArtistCD>\n");
       for (i=dtrack_first; i<=dtrack_last; i++)
       { 
         fprintf (f, "      <Track Num=\"%d\">\n", i);
	 j = i-dtrack_first;
         write_xml_record(f, "Artist", trk_info[j].artist, disc_artist, 9);
         write_xml_record(f, "Name", trk_info[j].name, NULL, 9);
         fprintf (f, "      </Track>\n");
       }	 
       fprintf(f, "   </MultipleArtistCD>\n\n");
    }
    else
    {   /* Single Artist CD */
       fprintf(f, "   <SingleArtistCD>\n");
       write_xml_record(f, "Artist", disc_artist, NULL, 6);

       for (i=dtrack_first; i<=dtrack_last; i++)
       { fprintf (f, "      <Track Num=\"%d\">\n", i);
         write_xml_record(f, "Name",
	                      trk_info[i-dtrack_first].name, NULL, 9);
         fprintf (f, "      </Track>\n");
       }	 
			      
       fprintf(f, "   </SingleArtistCD>\n\n");
    }
    	    
    fprintf(f, "</CDInfo>\n\n");
    
    *file_length = ftell(f);
    
    fclose(f);
    return 1;
}

char *get_cdindex_query(void)
{
    unsigned int   ntracks;
    char *query;
    TRACK_INFO  *ti;
    short	i;
    
    ntracks = dtrack_last - dtrack_first + 1;

    /* 10 digits and plus per each track and 50 char for other rubbish */ 
    query = malloc(11*ntracks+50); 
    if (query == NULL) return NULL;

    sprintf (query, "tracks=%d&toc=%d+%d+%lu",
         ntracks, dtrack_first, dtrack_last, dtime_total);

    ti = trk_info;
    for(i = dtrack_first; i <= dtrack_last; i++)
    { 
        sprintf(query, "%s+%lu", query,  ti->start);
	ti++;	     
    }
    
    return query;
}

#endif    /* RCDDB_SUPPORT */


/*___________________________________________________________________________

   CD Index - The Internet CD Index

   Copyright (C) 1998 Robert Kaye

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   $Id: cdindex.cpp,v 1.5 1999/06/30 14:22:56 marc Exp $
   _________________________________________________________________________*/

char *generate_cdindex(void)
{
    char    temp[9]; 
    SHA_INFO       sha;
    short    i;	
    static char digest[20];
    unsigned long  size;
    unsigned long  track_time;

    sha_init(&sha);

   /* Before we ran the hash on the binary data, but now to make
      sure people on both types of endian systems create the same
     keys, we convert the data to hex-ASCII first. :-)   */

   sprintf(temp, "%02X", dtrack_first);
   sha_update(&sha, (unsigned char *)temp, strlen(temp));

   sprintf(temp, "%02X", dtrack_last);
   sha_update(&sha, (unsigned char *)temp, strlen(temp));

   for(i = 0; i < 100; i++)
   {
       if (i==0) track_time = dtime_total;
       else 
       if (i>=dtrack_first && i<=dtrack_last)
             track_time = trk_info[i-dtrack_first].start;
       else track_time = 0;		 
       sprintf(temp, "%08lX", track_time);
       sha_update(&sha, (unsigned char *)temp, strlen(temp));
   }

   sha_final(digest, &sha);

   /* No worries, Robert. This will put trailing zero. A.C.E. */ 
   return rfc822_binary(digest, 20, &size);

}  

const char *get_owner_name(void)
{   
    SHA_INFO       sha;
    char *username;
    char digest[20];
    unsigned long  size;

    sha_init(&sha);
    username = cuserid(NULL);

    sha_update(&sha, (unsigned char *)username, strlen(username));
    sha_final(digest, &sha);

    return rfc822_binary(digest, 20, &size);
}

/*
 * Program:	RFC-822 routines (originally from SMTP)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	27 July 1988
 * Last Edited  10 September 1998
 *
 * Sponsorship:	The original version of this work was developed in the
 *		Symbolic Systems Resources Group of the Knowledge Systems
 *		Laboratory at Stanford University in 1987-88, and was funded
 *		by the Biomedical Research Technology Program of the National
 *		Institutes of Health under grant number RR-00785.
 *
 * Original version Copyright 1988 by The Leland Stanford Junior University
 * Copyright 1998 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington or The
 * Leland Stanford Junior University not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission.  This software is made available "as is", and
 * THE UNIVERSITY OF WASHINGTON AND THE LELAND STANFORD JUNIOR UNIVERSITY
 * DISCLAIM ALL WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE,
 * INCLUDING WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE UNIVERSITY OF
 * WASHINGTON OR THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


// NOTE: This is not true RFC822 anymore. The use of the characters
// '/', '+', and '=' is no bueno when the ID will be used as part of a URL.
// '.', '_', and '-' have been used instead

/* Convert binary contents to BASE64
 * Accepts: source
 *	    length of source
 *	    pointer to return destination length
 * Returns: destination as BASE64
 */

unsigned char *rfc822_binary (void *src,unsigned long srcl,unsigned long *len)
{
  unsigned char *ret,*d;
  unsigned char *s = (unsigned char *) src;
  char *v = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._";
  unsigned long i = ((srcl + 2) / 3) * 4;
  *len = i += 2 * ((i / 60) + 1);
  d = ret = (unsigned char *) malloc ((size_t) ++i);
  for (i = 0; srcl; s += 3) {	/* process tuplets */
    *d++ = v[s[0] >> 2];	/* byte 1: high 6 bits (1) */
				/* byte 2: low 2 bits (1), high 4 bits (2) */
    *d++ = v[((s[0] << 4) + (--srcl ? (s[1] >> 4) : 0)) & 0x3f];
				/* byte 3: low 4 bits (2), high 2 bits (3) */
    *d++ = srcl ? v[((s[1] << 2) + (--srcl ? (s[2] >> 6) : 0)) & 0x3f] : '-';
				/* byte 4: low 6 bits (3) */
    *d++ = srcl ? v[s[2] & 0x3f] : '-';
    if (srcl) srcl--;		/* count third character if processed */
    if ((++i) == 15) {		/* output 60 characters? */
      i = 0;			/* restart line break count, insert CRLF */
      *d++ = '\015'; *d++ = '\012';
    }
  }
  *d = '\0';			/* tie off string */

  return ret;			/* return the resulting string */
}


/* NIST Secure Hash Algorithm */

/* heavily modified by Uwe Hollerbach <uh@alumni.caltech edu> */
/* from Peter C. Gutmann's implementation as found in */
/* Applied Cryptography by Bruce Schneier */
/* Further modifications to include the "UNRAVEL" stuff, below */

/* This code is in the public domain */


/* UNRAVEL should be fastest & biggest */
/* UNROLL_LOOPS should be just as big, but slightly slower */
/* both undefined should be smallest and slowest */

/*
   This code is supposed to accept "endianity" from <features.h>.
   When 64bit long integers are used, SIZEOF_LONG will be set by
   configure, or you need to change definition in sadp_autoconf.h
   or sadp_stdconf.h, whichever is applicable.
   I am pretty sick of Windows-style LONG and CHAR. Here they are
   replaced by BSD-style 'u_long' and 'u_char'. These are practically
   the only changes made in the code.                   A.C.E. 
*/


#define UNRAVEL
/* #define UNROLL_LOOPS */

/* SHA f()-functions */

#define f1(x,y,z)	((x & y) | (~x & z))
#define f2(x,y,z)	(x ^ y ^ z)
#define f3(x,y,z)	((x & y) | (x & z) | (y & z))
#define f4(x,y,z)	(x ^ y ^ z)

/* SHA constants */

#define CONST1		0x5a827999L
#define CONST2		0x6ed9eba1L
#define CONST3		0x8f1bbcdcL
#define CONST4		0xca62c1d6L

/* truncate to 32 bits -- should be a null op on 32-bit machines */

#define T32(x)	((x) & 0xffffffffL)

/* 32-bit rotate */

#define R32(x,n)	T32(((x << n) | (x >> (32 - n))))

/* the generic case, for when the overall rotation is not unraveled */

#define FG(n)	\
    T = T32(R32(A,5) + f##n(B,C,D) + E + *WP++ + CONST##n);	\
    E = D; D = C; C = R32(B,30); B = A; A = T

/* specific cases, for when the overall rotation is unraveled */

#define FA(n)	\
    T = T32(R32(A,5) + f##n(B,C,D) + E + *WP++ + CONST##n); B = R32(B,30)

#define FB(n)	\
    E = T32(R32(T,5) + f##n(A,B,C) + D + *WP++ + CONST##n); A = R32(A,30)

#define FC(n)	\
    D = T32(R32(E,5) + f##n(T,A,B) + C + *WP++ + CONST##n); T = R32(T,30)

#define FD(n)	\
    C = T32(R32(D,5) + f##n(E,T,A) + B + *WP++ + CONST##n); E = R32(E,30)

#define FE(n)	\
    B = T32(R32(C,5) + f##n(D,E,T) + A + *WP++ + CONST##n); D = R32(D,30)

#define FT(n)	\
    A = T32(R32(B,5) + f##n(C,D,E) + T + *WP++ + CONST##n); C = R32(C,30)

/* do SHA transformation */

static void sha_transform(SHA_INFO *sha_info)
{
    int i;
    u_char *dp;
    u_long T, A, B, C, D, E, W[80], *WP;

    dp = sha_info->data;

/*
the following makes sure that at least one code block below is
traversed or an error is reported, without the necessity for nested
preprocessor if/else/endif blocks, which are a great pain in the
nether regions of the anatomy...
*/
#undef SWAP_DONE

#if (SHA_BYTE_ORDER == 1234)
#define SWAP_DONE
    for (i = 0; i < 16; ++i) {
	T = *((u_long *) dp);
	dp += 4;
	W[i] =  ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
    }
#endif /* SHA_BYTE_ORDER == 1234 */

#if (SHA_BYTE_ORDER == 4321)
#define SWAP_DONE
    for (i = 0; i < 16; ++i) {
	T = *((u_long *) dp);
	dp += 4;
	W[i] = T32(T);
    }
#endif /* SHA_BYTE_ORDER == 4321 */

#if (SHA_BYTE_ORDER == 12345678)
#define SWAP_DONE
    for (i = 0; i < 16; i += 2) {
	T = *((u_long *) dp);
	dp += 8;
	W[i] =  ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
	T >>= 32;
	W[i+1] = ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		 ((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
    }
#endif /* SHA_BYTE_ORDER == 12345678 */

#if (SHA_BYTE_ORDER == 87654321)
#define SWAP_DONE
    for (i = 0; i < 16; i += 2) {
	T = *((u_long *) dp);
	dp += 8;
	W[i] = T32(T >> 32);
	W[i+1] = T32(T);
    }
#endif /* SHA_BYTE_ORDER == 87654321 */

#ifndef SWAP_DONE
#error Unknown byte order -- you need to add code here
#endif /* SWAP_DONE */

    for (i = 16; i < 80; ++i) {
	W[i] = W[i-3] ^ W[i-8] ^ W[i-14] ^ W[i-16];
#if (SHA_VERSION == 1)
	W[i] = R32(W[i], 1);
#endif /* SHA_VERSION */
    }
    A = sha_info->digest[0];
    B = sha_info->digest[1];
    C = sha_info->digest[2];
    D = sha_info->digest[3];
    E = sha_info->digest[4];
    WP = W;
#ifdef UNRAVEL
    FA(1); FB(1); FC(1); FD(1); FE(1); FT(1); FA(1); FB(1); FC(1); FD(1);
    FE(1); FT(1); FA(1); FB(1); FC(1); FD(1); FE(1); FT(1); FA(1); FB(1);
    FC(2); FD(2); FE(2); FT(2); FA(2); FB(2); FC(2); FD(2); FE(2); FT(2);
    FA(2); FB(2); FC(2); FD(2); FE(2); FT(2); FA(2); FB(2); FC(2); FD(2);
    FE(3); FT(3); FA(3); FB(3); FC(3); FD(3); FE(3); FT(3); FA(3); FB(3);
    FC(3); FD(3); FE(3); FT(3); FA(3); FB(3); FC(3); FD(3); FE(3); FT(3);
    FA(4); FB(4); FC(4); FD(4); FE(4); FT(4); FA(4); FB(4); FC(4); FD(4);
    FE(4); FT(4); FA(4); FB(4); FC(4); FD(4); FE(4); FT(4); FA(4); FB(4);
    sha_info->digest[0] = T32(sha_info->digest[0] + E);
    sha_info->digest[1] = T32(sha_info->digest[1] + T);
    sha_info->digest[2] = T32(sha_info->digest[2] + A);
    sha_info->digest[3] = T32(sha_info->digest[3] + B);
    sha_info->digest[4] = T32(sha_info->digest[4] + C);
#else /* !UNRAVEL */
#ifdef UNROLL_LOOPS
    FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1);
    FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1);
    FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2);
    FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2);
    FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3);
    FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3);
    FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4);
    FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4);
#else /* !UNROLL_LOOPS */
    for (i =  0; i < 20; ++i) { FG(1); }
    for (i = 20; i < 40; ++i) { FG(2); }
    for (i = 40; i < 60; ++i) { FG(3); }
    for (i = 60; i < 80; ++i) { FG(4); }
#endif /* !UNROLL_LOOPS */
    sha_info->digest[0] = T32(sha_info->digest[0] + A);
    sha_info->digest[1] = T32(sha_info->digest[1] + B);
    sha_info->digest[2] = T32(sha_info->digest[2] + C);
    sha_info->digest[3] = T32(sha_info->digest[3] + D);
    sha_info->digest[4] = T32(sha_info->digest[4] + E);
#endif /* !UNRAVEL */
}

/* initialize the SHA digest */

void sha_init(SHA_INFO *sha_info)
{
    sha_info->digest[0] = 0x67452301L;
    sha_info->digest[1] = 0xefcdab89L;
    sha_info->digest[2] = 0x98badcfeL;
    sha_info->digest[3] = 0x10325476L;
    sha_info->digest[4] = 0xc3d2e1f0L;
    sha_info->count_lo = 0L;
    sha_info->count_hi = 0L;
    sha_info->local = 0;
}

/* update the SHA digest */

void sha_update(SHA_INFO *sha_info, u_char *buffer, int count)
{
    int i;
    u_long clo;

    clo = T32(sha_info->count_lo + ((u_long) count << 3));
    if (clo < sha_info->count_lo) {
	++sha_info->count_hi;
    }
    sha_info->count_lo = clo;
    sha_info->count_hi += (u_long) count >> 29;
    if (sha_info->local) {
	i = SHA_BLOCKSIZE - sha_info->local;
	if (i > count) {
	    i = count;
	}
	memcpy(((u_char *) sha_info->data) + sha_info->local, buffer, i);
	count -= i;
	buffer += i;
	sha_info->local += i;
	if (sha_info->local == SHA_BLOCKSIZE) {
	    sha_transform(sha_info);
	} else {
	    return;
	}
    }
    while (count >= SHA_BLOCKSIZE) {
	memcpy(sha_info->data, buffer, SHA_BLOCKSIZE);
	buffer += SHA_BLOCKSIZE;
	count -= SHA_BLOCKSIZE;
	sha_transform(sha_info);
    }
    memcpy(sha_info->data, buffer, count);
    sha_info->local = count;
}

/* finish computing the SHA digest */

void sha_final(unsigned char digest[20], SHA_INFO *sha_info)
{
    int count;
    u_long lo_bit_count, hi_bit_count;

    lo_bit_count = sha_info->count_lo;
    hi_bit_count = sha_info->count_hi;
    count = (int) ((lo_bit_count >> 3) & 0x3f);
    ((u_char *) sha_info->data)[count++] = 0x80;
    if (count > SHA_BLOCKSIZE - 8) {
	memset(((u_char *) sha_info->data) + count, 0, SHA_BLOCKSIZE - count);
	sha_transform(sha_info);
	memset((u_char *) sha_info->data, 0, SHA_BLOCKSIZE - 8);
    } else {
	memset(((u_char *) sha_info->data) + count, 0,
	    SHA_BLOCKSIZE - 8 - count);
    }
    sha_info->data[56] = (unsigned char) ((hi_bit_count >> 24) & 0xff);
    sha_info->data[57] = (unsigned char) ((hi_bit_count >> 16) & 0xff);
    sha_info->data[58] = (unsigned char) ((hi_bit_count >>  8) & 0xff);
    sha_info->data[59] = (unsigned char) ((hi_bit_count >>  0) & 0xff);
    sha_info->data[60] = (unsigned char) ((lo_bit_count >> 24) & 0xff);
    sha_info->data[61] = (unsigned char) ((lo_bit_count >> 16) & 0xff);
    sha_info->data[62] = (unsigned char) ((lo_bit_count >>  8) & 0xff);
    sha_info->data[63] = (unsigned char) ((lo_bit_count >>  0) & 0xff);
    sha_transform(sha_info);
    digest[ 0] = (unsigned char) ((sha_info->digest[0] >> 24) & 0xff);
    digest[ 1] = (unsigned char) ((sha_info->digest[0] >> 16) & 0xff);
    digest[ 2] = (unsigned char) ((sha_info->digest[0] >>  8) & 0xff);
    digest[ 3] = (unsigned char) ((sha_info->digest[0]      ) & 0xff);
    digest[ 4] = (unsigned char) ((sha_info->digest[1] >> 24) & 0xff);
    digest[ 5] = (unsigned char) ((sha_info->digest[1] >> 16) & 0xff);
    digest[ 6] = (unsigned char) ((sha_info->digest[1] >>  8) & 0xff);
    digest[ 7] = (unsigned char) ((sha_info->digest[1]      ) & 0xff);
    digest[ 8] = (unsigned char) ((sha_info->digest[2] >> 24) & 0xff);
    digest[ 9] = (unsigned char) ((sha_info->digest[2] >> 16) & 0xff);
    digest[10] = (unsigned char) ((sha_info->digest[2] >>  8) & 0xff);
    digest[11] = (unsigned char) ((sha_info->digest[2]      ) & 0xff);
    digest[12] = (unsigned char) ((sha_info->digest[3] >> 24) & 0xff);
    digest[13] = (unsigned char) ((sha_info->digest[3] >> 16) & 0xff);
    digest[14] = (unsigned char) ((sha_info->digest[3] >>  8) & 0xff);
    digest[15] = (unsigned char) ((sha_info->digest[3]      ) & 0xff);
    digest[16] = (unsigned char) ((sha_info->digest[4] >> 24) & 0xff);
    digest[17] = (unsigned char) ((sha_info->digest[4] >> 16) & 0xff);
    digest[18] = (unsigned char) ((sha_info->digest[4] >>  8) & 0xff);
    digest[19] = (unsigned char) ((sha_info->digest[4]      ) & 0xff);
}


