/*  ==========================================================
    SING - ALONG DISK PLAYER.  (C) 1998, Michael Glickman
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
	    See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software.

		Author strongly advices against using this code, or
		a part of it, in an application designed to run  on
		any Microsoft(tm) platfrom.
    ========================================================= */


#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <pwd.h>

#include "sad.h"

#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif

#define VERSION_CODE(maj,min,rel)  (((maj) << 16) | ((min) << 8) | (rel))
int	osversion_code = 0;  


extern PREFSET_INFO  *cd_prefsets;
extern PREFSET_INFO  *cd_current_prefset;

extern char  disc_name[DATA_NAME_SIZE];
extern char  disc_artist[DATA_NAME_SIZE];
extern char  disc_extra[DATA_NAME_SIZE];
extern char  OwnerName[OWNER_NAME_SIZE];

extern short	cd_prefset_count;
extern short	cd_multi_artist;
extern short 	cur_plist_size, cur_plist_pos;
extern short	cd_playlist_size;
extern u_char	*cd_playlist;
extern u_char	*cur_plist;
extern u_char	dtrack_first, dtrack_last;
extern u_char	track_first, track_last;
extern short	DataChanged;


extern TRACK_INFO  *trk_info;
extern PLAY_MODE_TYPE  PlayMode;


extern short	FourInterlace, FourWndRes;
extern u_char CDDeviceType, CDNodeNumber;
extern char CDDeviceName[];


#if !HAVE_TIME
time_t time(long *t)
{	struct timeval tmv;

   	gettimeofday(&tmv, NULL)
	if (t) *t = tmv.tv_sec;

	return tmv.tv_sec;
}
#endif


char *get_sadp_version(void)
{   
    static char result[11];
    sprintf(result, "%d.%d.%d",
             SADP_VERSION >> 16,
            (SADP_VERSION >> 8) & 255, SADP_VERSION & 255);
	    
    return result;	    
}

int get_cpu_type(char *line, const char *sign, char *retval)
{
   char *ptr;

   if (retval && strncmp(line, sign, strlen(sign)) == 0)
   {  ptr = strchr(line, ':');
      if (ptr)
      {  if (*++ptr == ' ') ptr++;
         strcpy(retval, ptr);
         strtokm(retval, "\n\r\t");
         return 1;
      }
   }

   return 0;
}



short get_cpu_data(char *cputype, char *cpumodel, double *cpuspeed, double *mips)
{
    FILE *f;
    char buf[20];
    char line[121];

    if (cputype) strcpy(cputype, "");
    if (cpumodel) strcpy(cpumodel, "");
    *mips = 0;
    if (cpuspeed) *cpuspeed = 0;

    f = fopen("/proc/cpuinfo", "r");
    if (!f)
#if HAVE_SYS_UTSNAME_H
    { 
        struct utsname utsn;
        if (!cputype || uname(&utsn)) return 0;
        strncpy(cputype, utsn.machine, 11); 
        if (strncmp(cputype, "i586", 4) == 0)
            strcpy (cputype, "Pentium");
	else
	if (strncmp(cputype, "i686", 3) == 0)
            strcpy (cputype, "Pent Pro");
	return 1;	
    }	
#else
        return 0;
#endif	

    while (fgets(line, 120, f) != NULL)
    {
        if (get_cpu_type(line, "cpu\t\t", cputype))
        {    if (strncmp(cputype, "586", 3) == 0)
    		strcpy (cputype, "Pentium");
	    else
	    if (strncmp(cputype, "686", 3) == 0)
    	        strcpy (cputype, "Pent Pro");
        }			
        else
        if (!get_cpu_type(line, "model\t", cpumodel) &&
            !get_cpu_type(line, "model name\t", cpumodel) &&
            cpuspeed && get_cpu_type(line, "cpu MHz\t", buf))
                   *cpuspeed = strtod(buf, NULL);
        else
        if (get_cpu_type(line, "bogomips\t", buf))
                   *mips = strtod(buf, NULL);

    }

    fclose(f);
    return 1;
}

short get_os_data(char *ostype, char *osversion)
{
    int major=0, minor=0, release=0;

#if HAVE_SYS_UTSNAME_H
    struct utsname utsn;

    strcpy(ostype, "");	    
    strcpy(osversion, "");	    

    if (uname(&utsn)) return 0;
    strncpy(ostype, utsn.sysname, 41); 
    strncpy(osversion, utsn.release, 41); 

#else
    FILE *f;
    char *rv;

    strcpy(ostype, "");	    
    strcpy(osversion, "");	    

    f = fopen("/proc/sys/kernel/ostype", "r");
    if (!f) return 0;
    rv = fgets(ostype, 40, f);
    fclose(f);
    if (rv == NULL) return 0;
    ostype[40] = '\0';
    strtokm(ostype, "r\n");

    f = fopen("/proc/sys/kernel/osrelease", "r");
    if (!f) return 0;
    rv = fgets(osversion, 40, f);
    fclose(f);
    if (rv == NULL) return 0;
    osversion[40] = '\0';
    strtokm(osversion, "r\n");
#endif    

    if (strlen(osversion) > 0)
	 sscanf(osversion, "%d.%d.%d", &major, &minor, &release);	
	  
    osversion_code = VERSION_CODE(major, minor, release);	

    return 1;
}



/* ===============================================================

	               PREFSET PROCESSING

   =============================================================== */
static short validate_skipability(TRACK_INFO *ti_current)
{
      int count;
      TRACK_INFO *ti;
      
      /* Must have at least one playable track */
      
      ti = trk_info;
      count = dtrack_last - dtrack_first + 1;
      while (--count >= 0)
      {  if (ti != ti_current && 
              ti->audio && !(ti->skip)) break;
         ti++;
      }		 
      
      return (count >= 0);

}

static void realise_skiplist(void)
{
      int  count;
      TRACK_INFO  *ti;
      u_char *sl;
      
      
      count = dtrack_last-dtrack_first+1;
      ti = trk_info;
      while (--count >= 0)
      {  ti->skip = ti->audio ? 0: 1;
         ti++;
      }	           
      
      sl = cd_current_prefset->skiplist;
      if (sl == NULL) goto NoProblems;
      
      count = cd_current_prefset->skiplist_size;      
      while(--count >= 0)
      { 
        ti = trk_info + (*sl++ - dtrack_first);
	if (count > 0 || validate_skipability(ti))
	           ti->skip = 1;
      }	 

          

/*      free(cd_current_prefset->skiplist);
      cd_current_prefset->skiplist = NULL; */

NoProblems:
      cd_shuflist_create();
}

static void cd_consolidate_skiplist(void)
{
      u_char *skiplist, *pos;
      short  skiplist_size, track;
      TRACK_INFO  *ti;

	
      if (!cd_current_prefset) return;
      
      skiplist = cd_current_prefset->skiplist;
      if (skiplist) free(skiplist);
      cd_current_prefset->skiplist_size = 0;
      
      skiplist = malloc((dtrack_last-dtrack_first+1)*sizeof(u_char));
      if (skiplist == NULL) return;
      
      ti = trk_info; pos = skiplist;
      for (track = dtrack_first; track<= dtrack_last; track++)
      { if (ti->audio && ti->skip) *pos++ = track; ti++; }
      
      skiplist_size =  pos - skiplist;
      
      if (skiplist_size > 0)
           skiplist = realloc(skiplist, skiplist_size*sizeof(u_char));
      else
      {	  free(skiplist);
          skiplist = NULL;
      }	  		  

      if (skiplist_size == 0 || skiplist)
      {  cd_current_prefset->skiplist =  skiplist;
         cd_current_prefset->skiplist_size = skiplist_size;
      }	 
      

}



short cd_set_track_skipability(short track, short flag)
{
      TRACK_INFO  *ti;
      
      ti = trk_info + (track - dtrack_first);

	if (flag < 0) flag = ti->skip ^ 1;

      if (ti->skip != flag && 
              (flag == 0 || validate_skipability(ti))
	 )
      {             
          ti->skip = flag;
          cd_shuflist_create();
          DataChanged = 1;
	  return 1;
      }	  
      
      return 0;
}

short  cd_track_skipability(short track)
{
      TRACK_INFO  *ti;

      if (track <track_first || track > track_last) return 0;      
      ti = trk_info + (track - dtrack_first);
      return ti->skip;
}

PREFSET_INFO *cd_create_prefset(const char *name)
{
	PREFSET_INFO *pi;
	int  prefset_no = -1;


	if (cd_current_prefset)
	     prefset_no = cd_current_prefset - cd_prefsets;
		    
	    
	cd_prefset_count++;
	pi = realloc(cd_prefsets,
                     cd_prefset_count * sizeof(PREFSET_INFO));
	if (!pi) return pi;

	cd_prefsets = pi;
	pi = cd_prefsets+cd_prefset_count-1;
	
	if (name == NULL) name = "*** Untitled ***";
	strncpy(pi->name, name, PREFSET_NAME_SIZE);

	pi->playlist_size = pi->skiplist_size = 0;	
	pi->playlist = pi->skiplist = NULL;
	strcpy(pi->owner, OwnerName);
	pi->written = 0;

	if (prefset_no >= 0)
	    cd_current_prefset = cd_prefsets + prefset_no;


	return pi;
}

static void  cd_accept_prefset_by_reference(PREFSET_INFO *pi)
{

    if (cd_current_prefset) cd_consolidate_skiplist();

    cd_current_prefset = pi;
    cd_playlist = cd_current_prefset->playlist;
    cd_playlist_size = cd_current_prefset->playlist_size;
    if (PlayMode == PLAY_LIST)
    {  cur_plist_size = cd_playlist_size;
       cur_plist = cd_playlist;
       cur_plist_pos = 0;
    }

    realise_skiplist();
    
}

void  cd_accept_prefset(short prefset_number)
{
    if (prefset_number >= 0 && prefset_number < cd_prefset_count)
       cd_accept_prefset_by_reference(cd_prefsets + prefset_number);
}


void  cd_select_default_prefset(void)
{   	
    short i;
    PREFSET_INFO *pi = cd_prefsets;
    
    for (i=0; i<cd_prefset_count && strcmp(pi->owner, OwnerName);
                            i++, pi++);
    
    if (i>=cd_prefset_count) pi = cd_prefsets;
    cd_accept_prefset_by_reference(pi);
}

/* Get read of preference sets with empty play lists */
static void  cd_clean_prefsets(void)
{
    int i;
    PREFSET_INFO *ps, *pt, *pc;
    
    pt = ps = cd_prefsets;   
    pc = NULL; 	
    for (i=0; i<cd_prefset_count; i++)
    {	
	if (i==(cd_prefset_count-1) ||
	       ps->playlist_size > 0)
        {  if (pt != ps)
	        memcpy(pt, ps, sizeof(PREFSET_INFO));
           if (ps == cd_current_prefset) pc = pt;
           pt++;
        }	   
	         	   
	ps++;
    }	       	       

    /* I prefer not to play with realloc here */
    cd_prefset_count = pt-cd_prefsets;

    if (cd_current_prefset != pc)
    {   cd_current_prefset = NULL;

        if (pc == NULL) 
	    cd_select_default_prefset();
        else
	    cd_accept_prefset_by_reference(pc);
    }	    
    
}

void  cd_prepare_save_prefsets(void)
{
    if (cd_current_prefset) cd_consolidate_skiplist();
    cd_clean_prefsets();
}

short  cd_insert_playlist_line(short pos, u_short track)
{	u_char *new_plist;
	int    npos;

	if (!cd_current_prefset) return 0;

	npos = ++cd_playlist_size;   
	new_plist = realloc(cd_playlist, npos*sizeof(u_char));
	if (!new_plist) return 0;
	
	cd_current_prefset->playlist = cd_playlist = new_plist;
	cd_current_prefset->playlist_size = cd_playlist_size = npos;

	while (--npos>pos)  cd_playlist[npos] = cd_playlist[npos-1];
        cd_playlist[pos] = track;
        if (cur_plist_pos < 0) cur_plist_pos = pos;

	return 1;
}

short  cd_delete_playlist_line(short pos)
{	u_char *new_plist;
	short  new_plist_size;

	if (!cd_current_prefset ||
	    pos < 0 ||
	    pos >= cd_playlist_size) return 0;


	new_plist_size = cd_playlist_size-1;
	

	if (new_plist_size <= 0)
	{   new_plist_size = 0; free(cd_playlist);
	    new_plist = NULL;
	}	    
        else	    
	{   new_plist = realloc(cd_playlist, (--cd_playlist_size)*sizeof(u_char));
	    if (new_plist==NULL) return 0;
	}	    
	
	cd_current_prefset->playlist = cd_playlist = new_plist;
	cd_current_prefset->playlist_size = cd_playlist_size = new_plist_size;

	while (pos<cd_playlist_size)
	{  cd_playlist[pos] = cd_playlist[pos+1];
	   pos++; 
	}

        if (cur_plist_pos >= cd_playlist_size) cur_plist_pos = cd_playlist_size-1;

	return 1;
}

/* ===============================================================

		    TRACKS and ARTISTS

   =============================================================== */
   
const char *get_full_track_name(short track_number)
{
    char *track_name, *artist_name;
    static char result[DATA_NAME_SIZE*2+7];
    
    track_name = cdaudio_get_track_name(track_number);
    artist_name = cdaudio_get_track_artist(track_number);
    if (artist_name == NULL || strlen(artist_name) == 0 )
        strcpy(result, track_name);
    else
	sprintf(result, "%s - %s", artist_name, track_name);	

    return result;	
}

char *get_current_artist(short track_number)
{    char *artist_name;

    artist_name = cdaudio_get_track_artist(track_number);

    if (artist_name == NULL || artist_name == "")
	    artist_name = disc_artist;

    return artist_name;
}

/* ===============================================================
	Converts the tilded name into full path.
	------------------------------------------------------------
	Was copied unchanged from my another application: itetris.
	I wonder if it could be done with less effort.
   =============================================================== */

char *get_full_fname(const char *filename)
{
	char *fname;
	char *home = NULL;
	int  l;

	if (!filename) return NULL;

	l = 0;

	if (*filename == '~')
	{  int ul;

	   filename++;

	   fname = strchr(filename, '/');
	   if (!fname) goto Adelante;

	   ul = fname - filename;

	   if (!ul)
        	home = getenv("HOME");   // User home directory
	   else
	   {	struct passwd *pwent;

	      	home = NULL;

		fname = malloc(ul+1);
		if (!fname) goto Adelante;

		memcpy(fname, filename, ul);
		fname[ul] = '\0';
		pwent = getpwnam(fname);
		free(fname);

		if (pwent)
		{  home = pwent->pw_dir;
		   if (home) filename += ul;
		}

      }

	if (home) l=strlen(home);
   }

Adelante:
	l += strlen(filename) + 1;

	fname = (char *) malloc(l);

	if (fname)
	{ if (home)
	  { strcpy(fname, home);
	    strcat(fname, filename);
	  }
	  else
	    strcpy(fname, filename);
	}

	return fname;
}


/* ===============================================================

 		    GENERAL TYPE FUNCTIONS  
		    
   =============================================================== */
void trim(char *line)
{
   /* Getting rid of leading spaces */
    int i = strspn(line, " "); 

    if (i>0) strcpy(line,  line+i);
    
  /* Getting rid of trailing spaces */
    i = strlen(line);
    if (i<=0) return;   /* A patch for a gcc bug */	
    while (--i>=0 && line[i] == ' ');
    line[i+1] = '\0';
}      

/* This is a patch for strtok that is incapable
   of handling delimiter at start of line
   (GNU bug or conceptual issue ?)  */
char *strtokm(char *line, const char *delim)
{   static char *cur_token = NULL;

    if (line != NULL) cur_token = line;
    if (cur_token == NULL) return NULL;
    return strsep(&cur_token, delim);
}

void stupid_beep(void)
{  
    putchar('\a');
    fflush(stdout);
}


/* dev_no is used for audio-devices only and can be set to NULL */
int  ProcessDeviceName(const char *option,
			   const char *type, const char *prefix,
                     char *dev_name,  int *dev_no)
{
     char s;
	
     if (option == NULL) return 0;

     s = *option;

     if (s == '*' ) 
     {   dev_name[0] = '\0';
 	   if(dev_no) *dev_no = DEV_NODEV;
     }	
     else
     if (s == '/')
     {    strcpy(dev_name, option);
	    if(dev_no) *dev_no = DEV_EXPLICIT;
     }	
     else
     if (isdigit(s))
     { 
	  long cardno;
	  if (!prefix) cardno=-1;
	  else
	  {   char *endptr;	
	      cardno = strtol(option, &endptr, 0);
		if (*endptr != '\0') cardno = -1;
	  }
	  if (cardno < 0)
        { char err_mes[513];
		  sprintf (err_mes, "Invalid device name %s\n", option);
		  show_error_message(err_mes);
          return 0;
        }

	  if (dev_no)
		*dev_no = cardno;
	  else
	      sprintf(dev_name, "/dev/%s%li", prefix, cardno);
     }
     else
     {  sprintf(dev_name, "/dev/%s", option);
	  if (dev_no) *dev_no = DEV_EXPLICIT;
     }	

     return 1;
}

/*----------------------------------------*/
/* Writes lines into a file as            */
/*                                        */
/* Header  part-1					*/
/* Header  part-2	etc				*/
/*                                        */
/* N.B Part length should not exceed 80!  */
/*----------------------------------------*/
void write_split_text(FILE *f, char *header, char *text, int part_len)
{
    int len, off;
    char portion[81];
    
    len = strlen(text);
    off = 0;

    portion[part_len] = '\0';
        
    while (1)
    {  if (len - off <= part_len)
       {  fprintf (f, "%s%s\n", header, text+off);
          break;        
       }

       memcpy(portion, text+off, part_len);
       fprintf (f, "%s%s\n", header, portion);
       off += part_len;
    }       	

}

/*
   Substitutes every occurence of 'pattern' in 'source' by 'subst'.
   Returns the result.
 
   Don't ask why recursion was needed: I am just lazy to do otherwise.
char *string_substitute(const char *source,
                        const char *pattern, const char *subst)
{
	char *pat_in_src, *tmp_res, *result;
	int l1, l2;

	pat_in_src = strstr(source, pattern);
	if (!pat_in_src) return strdup(source);

	tmp_res = string_substitute(pat_in_src+strlen(pattern), 
					    pattern, subst);
	if (!tmp_res) return NULL;

	l1 = pat_in_src-source; l2 = strlen(subst);
	result = malloc(l1+l2+strlen(tmp_res)+1);
	if (result)
	{ memcpy(result,  source, l1);
	  memcpy(result+l1, subst, l2);
	  strcpy(result+l1+l2, tmp_res);
	}

	free(tmp_res);	
	return result;
}
*/

/* This "substitution of substitute" works only if 'subst' is not longer
   than 'pattern'.  However is is much more efficient */
char *string_substitute(const char *source,
                        const char *pattern, const char *subst)
{

    char *result, *pat_in_src, *res_pos;
    int  rlen, plen, slen, llen;
    
    rlen = strlen(source);
    res_pos = result = malloc(rlen+1);
    if (!result) return result;   

    plen = strlen(pattern);
    slen = strlen(subst);    

    while ((pat_in_src=strstr(source, pattern)) != NULL) 
    {	
	llen = pat_in_src-source;
	if (llen)
	{   memcpy(res_pos, source, llen);
	    res_pos += llen;
	}
	
	if (slen)
	{   memcpy(res_pos, subst, slen);
	    res_pos += slen; 	
	}		    
	
	source = pat_in_src + plen;
    }   


    strcpy(res_pos, source);
    return realloc(result, strlen(result)+1);

}

