/*====================================================*/
/* Configuration for SADP. Edit to suit your needs.   */
/*----------------------------------------------------*/
/* Conditional operators are needed to automatically  */
/* disable unavailable features. Don't edit them.     */
/* 28-Aug-99                              A.C.E       */
/*====================================================*/

#ifdef HAVE_CONFIG_H
#include "sadp_autoconf.h"
#else
#include "sadp_stdconf.h"
#endif

#ifndef MAKE_PREFIX
#define MAKE_PREFIX  "/usr/local"
#endif

#if (HAVE_SYS_SOUNDCARD_H || \
      HAVE_LINUX_SOUNDCARD_H || \
      HAVE_MACHINE_SOUNDCARD_H)

#if HAVE_LIBM

/* Comment out the following line to disable spectrum analyzer */
#define DSP_SUPPORT

#if HAVE_SYS_MMAN_H
/* Uncomment the following line to enable memory mapping with OSS/LSD */
/* # define MMAP_SUPPORT */
#endif

#if HAVE_ALSA && defined(DSP_SUPPORT)
/* Comment out the following line to disable native ALSA support
   for PCM (DSP). Linux sound driver or OSS will be used instead */
#define ALSA_DSP_SUPPORT
# if HAVE_SYS_MMAN_H
/* Comment out the following line to disable memory mapping with ALSA */
#  define ALSA_MMAP_SUPPORT
# endif  /* HAVE_SYS_MMAN_H */
#endif

#endif   /* HAVE_LIBM */

/* Comment out the following line to disable mixer support */
#define MIXER_SUPPORT 

#if HAVE_ALSA && defined(MIXER_SUPPORT)
/* Comment out the following line to disable native ALSA support
   for mixer. Linux sound driver or OSS will be used instead */
#define ALSA_MIXER_SUPPORT
#endif   /* HAVE_ALSA */

#endif  /* HAVE_..._SOUNDCARD_H */


/* Comment out the next line to disable specific
   SCSI CDROM support. If support is enabled,
   the program will issue a SCSI specific command
   for probing CD, that helps to avoid syslog
   messages comming from the driver. For 
   other drives it simply has no effect */

#define SCSI_SUPPORT

/* This will invoke the universal CD command set for
   probing if media is present (listed in ucdrom.h)
   Though this does not not seems to work with  all
   three drivers, I tested to program with, it may
   be all right test with your driver.
*/
#define UCDROM_SUPPORT

/* This will include support of multi-changer
  (juke box), if the driver agrees 
*/
/* #define CHANGER_SUPPORT */

/* This will include support of
   Medium Catalog Number (MCN) in data base.
   Doesn't appear to be reliable with my CD
   drives, therefore I prefer to avoid it */
/*  #define  MCN_SUPPORT  */

/* This will invoke support of IDE ATAPI and SCSI
   extended  features (including CD-TEXT)
*/
/* #define CD_EXTENSION_SUPPORT */

/*
 This will invoke support of CD-EXTRA
*/
/* #define  CD_EXTRA_SUPPORT */


#if (HAVE_ARPA_INET_H || HAVE_NETDB_H)

/* Comment out next line to disable access to Internet CD databases */
#define RCDDB_SUPPORT

#endif

/* Enables support of interactive icons for X version */
#define ICON_WINDOW_SUPPORT

/* Uncomment if the font used is different from ISO8859-1.
   Currently used in "misc" panel only. */
/* #define NATIONAL_FONT  */


/* Defines main path for SADP CD data base 
   Must ne specified as a non-empty string.
*/
#define DEFAULT_DB_PATH  "~/.sadp"

/* Defines alternative path to SADP CD Data base.
   This can be set to empty string.
*/
#define DEFAULT_DB_ALTPATH  MAKE_PREFIX "/share/sadp"

/* Defines default workman_style data base, this can be 
   commented out to disable workman style data base support
*/
#define DEFAULT_WDB_NAME   "~/.xcddbase"
/* #define DEFAULT_WDB_NAME   "~/.workmandb" */

/* Define root directory for xmcd style data base
   (used also by CDDB, cdcd etc)  */
#define DEFAULT_XMCD_PATH  "/usr/lib/X11/xmcd/cddb"
/* #define DEFAULT_XMCD_PATH  "~/.cddb" */

/* Default compression utility used by SADP CD data base:
	 -1   no compression
          0   bzip2 
	  1   gzip
	  2   compress
*/
#define DEFAULT_ZIP_TYPE  1


/* Sets the default probing mode (0-disabled, 1-enabled) */
#define DEFAULT_PROBE   1


/* Sets the default auto-play mode (0 - off, 1-on) */
#define DEFAULT_AUTOPLAY   0

/* Sets the default loop play (0-off, 1-on) */
#define DEFAULT_LOOPPLAY   0

/* Sets default auto-save options for settings and data */
#define DEFAULT_SAVE_SETTINGS 0
#define DEFAULT_SAVE_DATA 1


/* Time required to get the full disk speed, after it started (sec) */
#define TIME_OUT_START   1

/* Time required to change position of a currently playing disk (sec) */
#define TIME_OUT_REPOSITION  0

/* Time required to open the disk tray (sec) */
#define TIME_OUT_EJECT  2

/* Time required to close the disk tray (sec) */
#define TIME_OUT_LOAD   4 

/* Time between frame shifting in HELP PLAY (millisec)  */
#define TIME_OUT_HELP_ADVANCE   100

/* Duration of track play in INTRO mode (sec) */
#define INTRO_DURATION_SEC 20

/* Duration used in FORWARD and BACK commands (sec) */
#define STEP_DISCRETE  15


/* Default background colour for console version */
/* 0 - black, 1 - red,     2 - green, 3 - brown, */
/* 4 - blue,  5 - magenta, 6 - cyan,  7 -grey    */
#define DEFAULT_BACKGROUND_COLOUR 4

/* Default X font name: foundry-family */
#define DEFAULT_X_FONT   "*-helvetica"

/* Default X font resolution: resx-resy */
#define DEFAULT_X_FONTRES   "75-75"

/* Default colours for X version */
/* You can use any X-type colour name - see XLookupColor man page for details */
#define DEFAULT_XCOLOUR_BKGR     "#0000FF"   /* Background (blue) */
#define DEFAULT_XCOLOUR_FTOP     "#FFE79B"   /* Top foreground (wheat) */
#define DEFAULT_XCOLOUR_FBOTTOM  "#FFFFFF"   /* Bottom foreground (white) */

/* Default spectrum bar width */
#define DEFAULT_BAR_WIDTH   8

/* Default oscilloscope settings */
#define DEFAULT_OBTURATE   0
#define DEFAULT_PIX_WIDTH  3
#define DEFAULT_PIX_HEIGHT 3


/* Tooltiip timeout in seconds */
#define DEFAULT_TOOLTIP_TIMEOUT1   1   /* Delay beforw appearing */
#define DEFAULT_TOOLTIP_TIMEOUT2   7   /* Delay before disappearing */
#define DEFAULT_TOOLTIP_TIMEOUT3   15   /* Delay before reappearing */

/* Uncomment the following line to use only icons from 1.x.x */
/* #define USE_OLD_ICONS */


/* Maximum size of disc and track names */
/* Include extra byte for trailing zero */
/* Should not exceed 73                 */
#define DATA_NAME_SIZE 61

/* Maximum size of disc details         */
/* Include extra byte for trailing zero */
/* Should not exceed 1025               */
#define EXTRA_NAME_SIZE 769

