
/*  U S E R  O B J E C T S  */
/* Generic object */

extern int scf_last_key;
extern int scf_mouse_x, scf_mouse_y;
extern int scf_mouse_state;

typedef struct generic_obj SCF_OBJECT;
typedef struct scf_form_struct SCF_FORM;


/* Types */
typedef enum 
{  SCF_TEXT_TYPE,
   SCF_BUTTON_TYPE,
   SCF_TICK_TYPE,
   SCF_BROWSER_TYPE,
   SCF_INPUT_TYPE
} SCF_OBJTYPE;

typedef enum 
{  SCF_CLICK_EVENT,
   SCF_CHANGE_EVENT,
   SCF_NO_EVENT
} SCF_EVENT;

typedef enum 
{  SCF_LEFT_ALIGN,
   SCF_CENTRE_ALIGN,
   SCF_RIGHT_ALIGN,
} SCF_ALIGN;

typedef void (*SCF_FRAME_DRAWER)(SCF_FORM *frm);
typedef int (*SCF_CALLBACK)(void *obj, SCF_EVENT event, int action);
typedef int (*SCF_HANDLER)(void *obj, SCF_EVENT event);

/* Action: 1 - show, 2 -hide */
typedef void (*SCF_DRAW_ROUTINE)(SCF_OBJECT *, int action);
typedef void (*SCF_ROUTINE)(SCF_OBJECT *);

#define SCF_MAX_SHORTCUTS 4
#define CENTRAL_LOCATION INT_MIN
#define BOTTOM_LOCATION INT_MIN+1


/* Flags */
#define SCF_CASE_SENSITIVE  1  /* Case sensitive shortcuts */
#define SCF_CTRLS_SUBST     2  /* Use ctrl shortcuts with alpha-s */
#define SCF_GETS_FOCUS      4  /* Object can get focus */
#define SCF_OVERLAP   	   0x200  /*	Overlap (for form) */
#define SCF_HIDDEN   	   0x100  /*	Hidden control */
#define SCF_INACTIVE   	   0x400  /*	Inactive input */
#define SCF_FRAME_DRAWN    0x80   /* Set if the frame is drawn */

struct scf_form_struct
{  
   WINDOW   *parent;
   WINDOW   *wnd;
   int	y, x;
   int	hei, wid;
   int	flags;
   char   *caption;
   chtype bkgr_attr, capt_attr, dim_attr;
   chtype frame_attr, frame_char;
   SCF_HANDLER  event_handler;
   SCF_FRAME_DRAWER frame_drawer;
   SCF_OBJECT  *default_obj, *cancel_obj;
   SCF_OBJECT  *focus_obj, *overlap_obj;
   SCF_OBJECT  *cur_browser, *alt_browser;
	
   SCF_OBJECT   *first;
   SCF_OBJECT   *last;
}; 

struct generic_obj
{
   SCF_FORM	 *frm;	
   SCF_OBJECT    *prev;
   SCF_OBJECT    *next;
   SCF_HANDLER  event_handler;
   SCF_CALLBACK  callback_routine;
   SCF_DRAW_ROUTINE   draw_routine;
   SCF_ROUTINE   destroy_routine;
   char          *caption;
   int   y, x;
   int   hei, wid;	
   int   flags, type;
   int   tag, oper; 
   SCF_ALIGN align;
   chtype norm_attr, spec_attr;
   int shortcuts[SCF_MAX_SHORTCUTS];
};

/* ================================================ */
/*                    F O R M                       */
/* ================================================ */

SCF_FORM *scf_create_form(WINDOW *parent,
                          int hei, int wid, int y, int x,
                          const char *caption);

void scf_set_form_window(SCF_FORM *frm, WINDOW *wnd);

void scf_set_form_frame_attr(SCF_FORM *frm, 
                             chtype new_frame_attr, chtype new_frame_chr);
void scf_set_form_attr(SCF_FORM *frm, 
                             chtype new_bkgr_attr, chtype new_capt_attr);
void scf_draw_form_frame(SCF_FORM *frm); 
void scf_set_form_caption(SCF_FORM *frm, const char *caption);
void scf_show_form(SCF_FORM *frm, int status);
void scf_redraw_form(SCF_FORM *frm);
void scf_refresh_form(SCF_FORM *frm);
void scf_destroy_form(SCF_FORM *frm);

int  scf_get_event(SCF_FORM *frm, int (*idle_func)(SCF_FORM *));
int  scf_check_event(SCF_FORM *frm);
int  scf_process_event(SCF_FORM *frm, chtype key);

int  scf_is_form_visible(SCF_FORM *frm); 
void scf_accept_active_browser(SCF_FORM *frm);
void  scf_set_frm_overlap_object(SCF_FORM *frm, SCF_OBJECT *obj);
void scf_invalidate_frames(SCF_FORM *frm);
void  scf_set_focus(SCF_FORM *frm, void *obj);

/* ================================================ */
/*                  O B J E C T                     */
/* ================================================ */
SCF_OBJECT *scf_create_object(SCF_FORM *frm, 
		      int obj_size, int obj_type,
                      int hei, int wid, int y, int x,
                      const char *caption);

void scf_common_draw_routine(SCF_OBJECT *obj, int action);
void scf_common_destroy_routine(SCF_OBJECT *obj);

void scf_show_tagged_objects(SCF_FORM *frm, int tag, int status);

void scf_set_object_caption(void *obj, const char *caption);
void scf_set_object_align(void *obj, SCF_ALIGN align);
void  scf_set_object_attr(void *obj,
                         chtype new_norm_attr, chtype new_spec_attr);
void scf_set_object_callback(void *obj, SCF_CALLBACK callback, int oper);
void  scf_set_object_shortcuts(void *obj, ...);
int  scf_add_object_shortcut(void *obj, int new_shortcut);
void scf_show_object(void *obj, int status);
void scf_draw_object(void *obj);
void scf_destroy_object(void *obj);

int  scf_arrange_bottom_buttons(SCF_FORM *frm, 
                            chtype btn_norm_attr, chtype btn_spec_attr,
			    int tag, int flags,
			    int btn_count, int btnw, ...);
/* void scf_draw_object_frame(SCF_OBJECT *obj); */
void scf_activate_object(void *obj, int status);
SCF_OBJECT *scf_get_next_focus_obj(SCF_FORM *frm, int shift); 

/* ================================================ */
/*                    T E X T                       */
/* ================================================ */
typedef struct 
{
   SCF_OBJECT	obj; 	
   chtype text_attr;
} SCF_TEXT;

SCF_TEXT *scf_create_text(SCF_FORM *frm, 
                      int hei, int wid, int y, int x,
                      const char *caption);

/* ================================================ */
/*                  B U T T O N                     */
/* ================================================ */
typedef struct 
{
   SCF_OBJECT	obj; 	
} SCF_BUTTON; 

SCF_BUTTON *scf_create_button(SCF_FORM *frm, 
                      int hei, int wid, int y, int x,
                      const char *caption, int flags);

/* ================================================ */
/*                    T I C K                       */
/* ================================================ */
typedef struct 
{
   SCF_OBJECT	obj; 	
   chtype on_attr;	
   int  value;	
} SCF_TICK; 

SCF_TICK *scf_create_tick(SCF_FORM *frm, 
                      int hei, int wid, int y, int x,
                      const char *caption, int flags, int value);

int  scf_tick_event_hander(void *tick1, SCF_EVENT evnt);

void scf_set_tick(SCF_TICK *tick, int new_value);
int scf_get_tick_value(SCF_TICK *tick);


/* ================================================ */
/*                  B R O W S E R                   */
/* ================================================ */
typedef struct brow_line
{  char *text;
   struct brow_line *next;
} SCF_BROWSER_LINE;  

typedef struct 
{
   SCF_OBJECT	obj; 	
   chtype capt_attr;	
   int nlines;	
   int eff_hei, eff_wid;
   int top, current;
   SCF_BROWSER_LINE *first;
}  SCF_BROWSER;

SCF_BROWSER *scf_create_browser(SCF_FORM *frm, 
		      int hei, int wid, int y, int x,
                      const char *caption);
SCF_BROWSER_LINE *scf_get_browser_line(SCF_BROWSER *brow, int number);
void scf_draw_browser_routine(SCF_BROWSER *brow, int status);
SCF_BROWSER_LINE *scf_insert_browser_line(SCF_BROWSER *brow,
                     int line_number, char *text);
SCF_BROWSER_LINE *scf_append_browser_line(SCF_BROWSER *brow, char *text);
void   scf_delete_browser_line(SCF_BROWSER *brow, int number);
void   scf_select_browser_line(SCF_BROWSER *brow, int number);
void scf_destroy_browser(SCF_BROWSER *brow);
void scf_clear_browser(SCF_BROWSER *brow);
int  scf_get_browser_linecount(SCF_BROWSER *brow);
int  scf_get_browser_curline(SCF_BROWSER *brow);
int scf_browser_event_handler(void *brow, SCF_EVENT evnt);
void scf_draw_brow_frame(void *obj);
const char *scf_get_browser_text(SCF_BROWSER *brow, int number);
void scf_set_browser_text(SCF_BROWSER *brow, int number, const char *text);

/* ================================================ */
/*                    I N P U T                     */
/* ================================================ */
typedef struct 
{
   SCF_OBJECT	obj; 	
   chtype capt_attr;	
   int eff_hei, eff_wid;
   int top_line, left_col;
   int cur_line, cur_pos;
   int col_count, line_count;	
   char *content;	
}  SCF_INPUT;

SCF_INPUT  *scf_create_input(SCF_FORM *frm, 
                  int hei, int wid, int y, int x,
                  const char *caption,
		      int maxlines, int maxcols);

int scf_input_event_handler(void *brow, SCF_EVENT evnt);
void scf_set_input(SCF_INPUT *inp, char *value);
char *scf_get_input(SCF_INPUT *inp);

