 /* ==========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998 - 2000 Michael Glickman.  xsadp@yahoo.com 
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software.

            Author strongly advices against using this code, or
            a part of it, in an application designed to run  on
            any Microsoft(tm) platfrom.
    ========================================================= */


#include <sys/stat.h>
#include <sys/time.h>
#include <ctype.h>
#include <stdlib.h>
#include <curses.h>
#include <unistd.h>
#include <string.h>
#include <term.h>
#include <math.h>
#include <time.h>
#include <linux/major.h>
#include <linux/cdrom.h>
#include <linux/keyboard.h>

#include "sad.h"
#include "sadp_curses.h"

#if defined(CHANGER_SUPPORT) && defined(CDROM_CHANGER_NSLOTS) && defined(CDROM_SELECT_DISC)
#define USE_CHANGER 1
#endif

int native_getmouse(MEVENT *event);

#if GPM_SUPPORT
int  gpm_getmouse(MEVENT *);
void mouse_gpm_draw(void);
#endif


#define MWND_HEIGHT 9

/*
#define SPEAKER_WIDTH	6
#define SPEAKER_HEIGHT	MWND_HEIGHT
*/

#define MIN_FOURWND_HEIGHT  5
#define MAX_FOURWND_HEIGHT  35

#define VOL_BAR_LENGTH 7
#define VOL_BAR_LEFT   2
#define SLOT_OFFSET_FROM_RIGHT  24

/*
static WINDOW *SpkrWnd[2]={NULL, NULL};
const  int spkr_hei = SPEAKER_HEIGHT-2;
const  int spkr_wid = SPEAKER_WIDTH-2;
*/

#define BAR_X	      12
#define BAR_Y		2

#define TRACK_X	      (MainWndWidth - 9)
#define TRACK_Y		2

struct BTN_INFO
{
   short  y;
   short  x1, x2;
   short  oper;
};


extern short  BkgrColour, ShadColour, BottomColour;
extern short  PlayOptions;
extern short  FourWndCount, CharSet;
extern short  FourInterlace, WaveObturate;
extern MOUSE_SUPPORT_OPTION MouseSupport;

extern HEADER_MODE  HeaderMode;

extern CPLX   *ft_buffer;
extern long   ft_bufsize;
extern int    ft_size;
extern int    abuf_size, bbuf_size;
extern int    MouseX, MouseY;
extern int    audio, mixer;
extern unsigned int stereo, sample_size;
extern signed char *iobuf;
extern short  unsgn_mode;
extern signed short *iobuf16;
extern short  FourGain, WaveVScale;

extern u_char cd_status;
extern u_char track_first, track_last, track_cur;
extern u_long track_time_start, track_time_end;
extern u_long time_start, time_total, time_cur, time_req;
extern short  cur_plist_pos;
extern short  cd_multi_artist;
extern int    cd_slot_count, cd_slot_current;		

extern char   disc_name[], disc_artist[];
extern char   volume, balance;
extern short  AutoPlay, LoopPlay;
extern short  OptionsChanged, DataChanged;
extern short  SaveData, SaveSet, SaveMixer;
extern short  ArtistToggle, ExtraToggle;
extern u_int  MixerDeviceCount;
extern u_int  MixerStereoMask, MixerCurDevMask;
extern u_int  MixerRecmask, MixerRecsrc;
extern u_char MixerCurDevice;

extern double Frames;
extern char   MixerSoundDevice[];

extern PLAY_MODE_TYPE PlayMode;
extern ACCESS_TYPE last_access;

extern char *SadpEpilogue;

int	ScreenW, ScreenH;
short	FourWndMask;
int	MainWndHeight, MainWndLeft, MainWndTop, MainWndWidth;
int	FourWndHeight, FourWndWidth, FourWndTop;
short	IsX, AreColours;
int	ttyno, current_tty, termfd;



MEVENT  LastMouseEvent;
WINDOW	*MainWnd=NULL;
/* WINDOW  *MsgWnd=NULL; */


short	BtnDist, BtnWidth;
chtype	OperNotation[CBUTTONS+HBUTTONS][3];

short	HelpFocus, BottomSection;

WINDOW  *FourWnd[2] = {NULL, NULL};

WINDOW  *OverlapWnd;

chtype cLeftArrow, cRightArrow,  cDownArrow, cUpArrow;
chtype cLeftArrow1, cRightArrow1;
chtype cBlock, cBar, cBullet, cBullet1, cCkboard, cDiamond;
chtype cSpectBright, cSpectDim, cVolBright, cVolDim;

chtype btn_attr, bar_attr;
chtype bkgr_attr, fill_attr, text_attr;
chtype brow_attr, brow_hilite_attr;
chtype help_attr, help_hdr_attr, help_title_attr;
chtype thumb_attr, suspend_attr, msg_attr, dimmed_attr;
chtype side_attr, side_text_attr, side_dim_attr, side_dim2_attr;
chtype spectr1_attr, spectr2_attr, spectr3_attr;

static int    BarLeft, BarLength, TotalX;
static int    Initialized = 0;
static struct BTN_INFO ButtonInfo[CBUTTONS+UBUTTONS];
static short  MiddleEqu, RightEqu, OldPressedButton;
static short  MiddleEquPos, RightEquPos;
static short  SuspendRefresh;

#ifdef DSP_SUPPORT
static short  FourWndEffHeight, FourWndEffWidth;
static short  *FourSignal[] = {NULL, NULL};
#endif

static short  OperStopIndex, OperPlayIndex;
static short  OperModeIndex, OperSaveoIndex;

extern TIME_DISPLAY_MODE_TYPE TimeDisplayMode;
static u_char OldTrackNo = 255;
#ifdef USE_CHANGER
static int    OldSlotNo;
#endif
static void   board_draw(void);
static void   show_stop_button(short ind);
static void   delaunch_message(void);

/* static void show_bottom_header(short section); */

static short  ButtonsToDraw = 0, ButtonsToCheck = 0;
static int    old_progrel, old_progabs;
static long   old_position;

static time_t msg_remove_time;
static short  old_SuspendRefresh;

#ifdef DSP_SUPPORT
static short  spectr_start=0, spectr_inter_mode=0;
static short  gain_x1, gain_x2, gain_y;
static short  interl_x1, interl_x2;
#endif

const char  TimeModeTxt[] = "ELPREMEL%RM%";
const char  PlayModeTxt[] = "NRMLSTRNDINTSNG";
const char  AutoModeTxt[] = " A -A-";
const char  LoopModeTxt[] = " L -L-";
const char  SaveoTxt[] = " ! -!-";
/*
const char  *SectionNames[] = {"Spectrum", "Oscillator"};
                              "Help", "Status", "Misc"}; */


/*
PLATFORM get_platform(void)
{    return PLTF_CURSES; }
*/
static void InitColourAttr(void)
{
      short SpectrColour = COLOR_BLACK;
	short BtnColour = BottomColour;
	short colno = 2;

	if (BkgrColour < 0) BkgrColour = DEFAULT_BACKGROUND_COLOUR;

	if (ShadColour < 0)
         ShadColour = (BkgrColour == COLOR_BLACK) ? COLOR_RED : COLOR_BLACK;

	if (BtnColour < 0)
	{  if (BkgrColour & COLOR_RED)
           BtnColour = COLOR_MAGENTA;
         else
           BtnColour = COLOR_CYAN;
      }

      init_pair(colno, BkgrColour == COLOR_WHITE ? COLOR_BLACK : COLOR_WHITE, BkgrColour );
	bkgr_attr = COLOR_PAIR(colno) ;
	dimmed_attr = bkgr_attr;
	fill_attr = bkgr_attr;
	text_attr = fill_attr | A_BOLD;
	colno++;

      init_pair(colno, COLOR_YELLOW, ShadColour);
	side_dim_attr = COLOR_PAIR(colno);
	side_attr =  side_dim_attr | A_BOLD;
	suspend_attr = side_attr | A_BLINK; 
	colno++;

      init_pair(colno, COLOR_GREEN, ShadColour);
	bar_attr = COLOR_PAIR(colno) | A_BOLD;
	colno++;

      init_pair(colno, COLOR_RED, ShadColour);
	thumb_attr = COLOR_PAIR(colno) | A_BOLD;
	msg_attr = thumb_attr | A_BLINK; 
	colno++;

      init_pair(colno,  BtnColour, ShadColour);
	btn_attr = COLOR_PAIR(colno) | A_BOLD;
	colno++;

      init_pair(colno, COLOR_WHITE, ShadColour);
	side_dim2_attr = COLOR_PAIR(colno);
	side_text_attr = side_dim2_attr | A_BOLD;
	colno++;

      init_pair(colno, COLOR_GREEN, SpectrColour);
	spectr1_attr = COLOR_PAIR(colno);
	colno++;

      init_pair(colno, COLOR_YELLOW, SpectrColour);
	spectr2_attr = COLOR_PAIR(colno) | A_BOLD;
	colno++;

      init_pair(colno, COLOR_RED, SpectrColour);
	spectr3_attr = COLOR_PAIR(colno);
	colno++;

#if NCURSES_VERSION_MAJOR > 3
      init_pair(colno, COLOR_WHITE, BkgrColour);
      brow_attr = COLOR_PAIR(colno) | A_BOLD;
      colno++;

      if (BkgrColour == COLOR_RED || BkgrColour == COLOR_YELLOW)	
	    init_pair(colno, COLOR_GREEN, BkgrColour);
      else	
	    init_pair(colno, COLOR_RED, BkgrColour);

      help_hdr_attr = COLOR_PAIR(colno) | A_BOLD;
      colno++;

      if (BkgrColour == COLOR_RED || BkgrColour == COLOR_YELLOW)	
	      init_pair(colno, COLOR_WHITE, COLOR_GREEN);
	else
      	init_pair(colno, COLOR_WHITE, COLOR_RED);
      brow_hilite_attr = COLOR_PAIR(colno) | A_BOLD;
      colno++;
 
      help_attr = brow_attr;

      init_pair(colno, COLOR_YELLOW, BkgrColour);
      help_title_attr =  COLOR_PAIR(colno) | A_BOLD;
#else
      brow_attr =  text_attr; /*  side_dim_attr; */
      brow_hilite_attr = text_attr;  /* side_attr; */
      help_title_attr = text_attr;
      help_hdr_attr =  fill_attr;
      help_attr = text_attr;
#endif 

/*      init_pair(colno, COLOR_WHITE, BkgrColour);
	dimmed_attr = COLOR_PAIR(colno);
*/


}

static void InitMonoAttr(void)
{

      bkgr_attr = A_NORMAL;
      dimmed_attr = A_DIM;  
      fill_attr =  A_NORMAL;
      text_attr = A_NORMAL;

      side_dim_attr = A_DIM;
      side_attr =  A_BOLD;
      suspend_attr = A_BOLD | A_BLINK;

      bar_attr =  A_NORMAL;

      thumb_attr = A_BOLD;

      btn_attr = A_REVERSE | A_BOLD;

      side_dim2_attr = A_DIM;
      side_text_attr = A_NORMAL;

      spectr1_attr = A_BOLD;
      spectr2_attr =  A_NORMAL;
      spectr3_attr =  A_BOLD ;

      dimmed_attr = A_DIM;

      help_attr = A_NORMAL;
      help_hdr_attr = A_BOLD;
      help_title_attr = A_BOLD;

      brow_attr = A_BOLD;
/*
#ifdef A_UNDERLINE
      brow_hilite_attr = A_BOLD + A_UNDERLINE;
#else
      brow_hilite_attr = A_BOLD;
#endif
*/
      brow_hilite_attr = A_REVERSE | A_BOLD;
}


void SetCharSet(void)
{
   switch(CharSet)
   {
	case 1:
		cLeftArrow = cLeftArrow1 = ACS_LARROW;
		cRightArrow = cRightArrow1 = ACS_RARROW;
		cBullet = cBullet1 =  ACS_BULLET;
		cDiamond =  0x4 | A_ALTCHARSET;
		cDownArrow = (chtype)(31) | A_ALTCHARSET; 
		cUpArrow =  (chtype)(30) | A_ALTCHARSET; 
		cBar = (chtype) '|';
		cBlock = ACS_BLOCK;
		cCkboard =  ACS_CKBOARD;

		cSpectBright = 0xB2 | A_ALTCHARSET; 
		cSpectDim  =  cDiamond; 

		cVolBright = cBlock;
		cVolDim = cCkboard;

		break;

	case 2:
		cLeftArrow =  '<';
		cRightArrow = '>';
		cLeftArrow1 = (chtype) 171 | A_ALTCHARSET; 
		cRightArrow1 = (chtype) 187 | A_ALTCHARSET;
		cBullet =  '=';
		cBullet1 = (chtype)183 | A_ALTCHARSET;  /*  (chtype)176 | A_ALTCHARSET; */
		cDiamond =  ACS_DIAMOND;
		cDownArrow =  (chtype) 'v';
		cUpArrow = (chtype) '^';
		cBar = (chtype) '|';
		cBlock = ACS_CKBOARD;
		cCkboard =  cBlock; /*  '\02' | A_ALTCHARSET;  // ACS_CKBOARD; */

		cSpectBright = cCkboard;
		cSpectDim  =  cDiamond; /* cBullet1; // cCkboard; */

		cVolBright = cBlock;
		cVolDim =  cBullet;

		break;

	case 3:
		cLeftArrow1  = cLeftArrow =  '<';
		cRightArrow1 = cRightArrow = '>';
		cBullet =  '=';
		cBullet1 = 'o';
		cDiamond =  '+';
		cDownArrow =  'v';
		cUpArrow =  '^';
		cBar = '|';
		cBlock = '#';
		cCkboard = '*';

		cSpectBright = cBlock;
		cSpectDim  = 'o';

		cVolBright = cBlock;
		cVolDim = cBullet;

		break;

	case 4:
		cLeftArrow = cLeftArrow1 = ACS_LARROW;
		cRightArrow = cRightArrow1 = ACS_RARROW;
		cBullet = cBullet1 =  ACS_BULLET;
		cDiamond =  ACS_DIAMOND;
		cDownArrow =  ACS_DARROW;
		cUpArrow = ACS_UARROW;
		cBar =  ACS_VLINE;
		cBlock = ACS_BLOCK;
		cCkboard =  ACS_CKBOARD;

		cSpectBright =  ACS_CKBOARD;
		cSpectDim  = ACS_DIAMOND; /*  ACS_BOARD; */

		cVolBright = cBlock;
		cVolDim = cCkboard;

		break;

     }

}

static void InitOperNotation(void)
{


   OperNotation[OPER_PREV][0] = '|';
   OperNotation[OPER_PREV][1] = cLeftArrow;

   OperNotation[OPER_BACK][0] = cLeftArrow1;
   OperNotation[OPER_BACK][1] = cLeftArrow1;

   OperNotation[OPER_FWD][0] = cRightArrow1;
   OperNotation[OPER_FWD][1] = cRightArrow1;

   OperNotation[OPER_NEXT][0] = cRightArrow;
   OperNotation[OPER_NEXT][1] = '|';

   OperNotation[OPER_PLAY][0] = ' ';
   OperNotation[OPER_PLAY][1] = (chtype)'=';
   OperNotation[OPER_PLAY][2] = cRightArrow;;
/*
   OperNotation[OPER_PAUSE][0] = ' ';
   OperNotation[OPER_PAUSE][1] = (chtype)'=' ;
   OperNotation[OPER_PAUSE][2] = ' ';
*/
   OperNotation[OPER_QUIT][0] = ' ';
   OperNotation[OPER_QUIT][1] = 'x';
   OperNotation[OPER_QUIT][2] = ' ';


   OperNotation[OPER_STOP][0] = cDownArrow;
   OperNotation[OPER_STOP][1] = cBullet1;
   OperNotation[OPER_STOP][2] = cUpArrow;

   OperNotation[OPER_NEXT5][0] = cRightArrow;
   OperNotation[OPER_NEXT5][1] = cRightArrow;
   OperNotation[OPER_NEXT5][2] = '|';

   OperNotation[OPER_PREV5][0] = '|';
   OperNotation[OPER_PREV5][1] = cLeftArrow;
   OperNotation[OPER_PREV5][2] = cLeftArrow;

   OperNotation[OPER_STOPQUIT][0] = ' ';
   OperNotation[OPER_STOPQUIT][1] = 'X';
   OperNotation[OPER_STOPQUIT][2] = ' ';

/*
   OperNotation[OPER_HELP][0] = ' ';
   OperNotation[OPER_HELP][1] = '?';
   OperNotation[OPER_HELP][2] = ' ';
*/
   OperNotation[OPER_SUSPEND][0] = ' ';
   OperNotation[OPER_SUSPEND][1] = '*';
   OperNotation[OPER_SUSPEND][2] = ' ';

   OperNotation[OPER_REFRESH][0] = ' ';
   OperNotation[OPER_REFRESH][1] = cDiamond;  /*'-';*/
   OperNotation[OPER_REFRESH][2] = ' ';

   OperNotation[OPER_HELPPREV][0] = cLeftArrow;
   OperNotation[OPER_HELPPREV][1] = cBullet;
   OperNotation[OPER_HELPPREV][2] = cBullet;

   OperNotation[OPER_HELPNEXT][0] = cBullet;
   OperNotation[OPER_HELPNEXT][1] = cBullet;
   OperNotation[OPER_HELPNEXT][2] = cRightArrow;

   OperNotation[OPER_PLAYBACK][0] = ' ' ;
   OperNotation[OPER_PLAYBACK][1] = cLeftArrow;
   OperNotation[OPER_PLAYBACK][2] = ' ';

   OperNotation[OPER_SAVEO][0] = ' ' ;
   OperNotation[OPER_SAVEO][1] = '!' ;
   OperNotation[OPER_SAVEO][2] = ' ';

#ifdef MIXER_SUPPORT
   OperNotation[OPER_MIXERPREV][0] = '<' ; 
   OperNotation[OPER_MIXERPREV][1] = '<' ; 

   OperNotation[OPER_MIXERNEXT][0] = '>' ; 
   OperNotation[OPER_MIXERNEXT][1] = '>' ; 
#endif
};

static int GetTTY(void)
{    struct stat st;
     int rd;		
 
     if (IsX)
     { ttyno = 0; return 1;}

     if (fstat(termfd, &st)) return 0;
     rd = st.st_rdev;

     if ((rd >> 8) != TTY_MAJOR)
     {  char  message[513];
	 
		 sprintf (message, "%d warning: stdout is not a terminal", 
                           (rd>>8));
		 show_error_message(message);  						   
		 ttyno = -1;
         return 1;
     }
     
     ttyno = rd & 0xff;
     return 1;
}     

static int mouse_initialize(void)
{

   if (MouseSupport == MOUSE_NONE) return 0;

#if GPM_SUPPORT
    /* Trying to get GPM mouse support */
   if ( ( MouseSupport == MOUSE_GPM ||
          (MouseSupport == MOUSE_DEFAULT && !IsX)
        ) && mouse_gpm_initialize()
      )
   {    MouseSupport = MOUSE_GPM;
        return 1;
   }
#endif

   /* Trying to get standard mouse support */
   if (MouseSupport != MOUSE_GPM)
   {
     if (mousemask(BUTTON1_PRESSED | BUTTON2_PRESSED | BUTTON3_PRESSED | BUTTON_SHIFT,   /* ALL_MOUSE_EVENTS */
		              NULL))
      {  MouseSupport = MOUSE_NATIVE;
         return 1;
      }	 
			      
   }

   MouseSupport = MOUSE_NONE;
   return 0;


}

#define MIN_SCREEN_WIDTH  64
#define MIN_SCREEN_HEIGHT 24

int screen_initialize(int argc, char *argv[])
{
#ifdef DSP_SUPPORT
    int   i;
#endif
    WINDOW *ScrWnd;


/*  Initialize ncurses */
    ScrWnd =initscr();
    if (!ScrWnd) return 0;

		termfd = cur_term->Filedes;
		IsX = (strncmp(cur_term->type.term_names, "xterm", 5)==0);
		current_tty = 1;

    /* Get dimensions */
     getmaxyx(ScrWnd, ScreenH, ScreenW);

     if (ScreenW < MIN_SCREEN_WIDTH || ScreenH < MIN_SCREEN_HEIGHT)
     {   char err_mes[513];
		 endwin();
  		 sprintf (err_mes, "\a\n"
      			  "Sorry, minimum supported screen size is %dx%d\n"
	              "                 Current screen size is %dx%d\n\n",
			    MIN_SCREEN_WIDTH, MIN_SCREEN_HEIGHT,
			    ScreenW, ScreenH);
		if (IsX)
		  sprintf (err_mes + sizeof(err_mes),
		    "Please, increase X-terminal window size.\n");
  		else
		  sprintf (err_mes + sizeof(err_mes),
	        "Use 'resizecons' or 'SVGATextMode' to increase size.\n");
		show_error_message(err_mes);			
		Initialized = -1;
        return 0;
     }


    AreColours = has_colors() && (BkgrColour >=-1);

    if (AreColours) start_color();
    cbreak(); noecho(); nodelay(stdscr, 1);
    nonl(); /*  intrflush(stdscr, TRUE); */
    meta(stdscr, TRUE);
    keypad(stdscr, TRUE);
    raw();


     GetTTY();	
     if (CharSet == 0) CharSet = IsX ? 2: 1;
     SetCharSet();

     if (ttyno >= 0)	
     { if (curs_set(0) == ERR)
        putp(cursor_invisible);
     }

     if (AreColours)
	 InitColourAttr();
     else
	 InitMonoAttr();

     SuspendRefresh = 0;
     BottomSection = 0;
     OldPressedButton = -1;
     MiddleEqu = -1;
     RightEqu = -1;

     /* Initialize mouse */
     if (ttyno>=0)
	  mouse_initialize();
     else	
	  MouseSupport = MOUSE_NONE;	

     if (IsX) MainWndLeft = 1; else MainWndLeft = ScreenW / 10;
     MainWndHeight = MWND_HEIGHT;
     MainWndWidth = (ScreenW - 2*MainWndLeft);
     if (!(MainWndWidth & 1)) MainWndWidth++;

     FourWndHeight = ScreenH - MWND_HEIGHT -1;  
     if (FourWndCount == 2)
     {
       if(FourWndHeight <= 2*MIN_FOURWND_HEIGHT + 1) FourWndHeight = 1;
       else   FourWndHeight = (FourWndHeight +1) >> 1;
     }


    if (FourWndHeight > MAX_FOURWND_HEIGHT)
                   FourWndHeight = MAX_FOURWND_HEIGHT;

    MainWndTop = (ScreenH - MWND_HEIGHT - FourWndHeight*FourWndCount+1)/ 2;
/*    if (FourWndCount == 1) MainWndTop++; */

    OverlapWnd = NULL;		/* Window for overlaping form */
	
    MainWnd = newwin(MWND_HEIGHT, MainWndWidth, MainWndTop, MainWndLeft);
    if (!MainWnd) return 0;

#ifdef DSP_SUPPORT
    FourWndWidth = MainWndWidth ;

    FourWndEffWidth = FourWndWidth -2;
    FourWndEffHeight = FourWndHeight - 1;

    FourWndMask = (FourWndCount < 2 || FourInterlace) ? 1 : 3;

    for (i=0; i< FourWndCount; i++)
    { FourWndTop = MainWndTop + MWND_HEIGHT + i*FourWndHeight;

      FourWnd[i] = newwin(FourWndHeight, FourWndWidth,
                            FourWndTop,  MainWndLeft);
 	FourSignal[i] = malloc(FourWndEffWidth * sizeof(short));
    }
#endif


    BarLength = MainWndWidth - 2*BAR_X - 14;
    TotalX  =  BarLength/2 + BAR_X + 4;
    BtnDist = (BarLength + 15)/10;
    BtnWidth =  BtnDist - 2;
    if (BtnWidth & 1) BtnWidth--;

/*  RightEquPos = MainWndWidth - 11 - BtnDist;
    MiddleEquPos = RightEquPos - BtnDist; */
    RightEquPos = MainWndWidth - 14 - (BtnWidth/2);
    MiddleEquPos = RightEquPos - BtnDist;

/*    TimeDisplayMode = DM_ELAPSED; */
    old_progabs = old_progrel = -1;

    help_initialize();
    InitOperNotation();


    Initialized = 1;
    board_draw();

/*    if (FourWndCount > 0)
	    show_bottom_header(BottomSection); */

    show_mode(OPER_TIMEDISPLAY); show_mode(OPER_AUTOPLAY);
    show_mode(OPER_LOOPPLAY);
    show_mode(OPER_PLAYMODE);
    show_mode(OPER_SAVEO);


    return  1;
}

int foreground_processing(void)
{
	OPERATION action;
  	
	long timeout;
	long morewait;
	struct timeval break_time, cur_time;

	timeout =  FourWndCount > 0 ? 0 : (TIME_OUT_HELP_ADVANCE) * 250;
      
#ifdef RCDDB_SUPPORT
	rcddb_curs_initialize();
#endif

	while((action = get_action()) != OPER_QUIT)
	{  gettimeofday(&break_time, NULL);
	   time_plus(break_time, timeout);	

	   sound_process();
           cdaudio_operate(action);
	   if (action == OPER_STOPQUIT) break;
	   Frames ++;

	   gettimeofday(&cur_time, NULL);
	   morewait = time_diff(break_time, cur_time);	
	   if (morewait > 0) usleep(morewait);
	}
      

#ifdef RCDDB_SUPPORT
      rcddb_curs_deinitialize();
#endif
	return 1;
}

/* Deinit mouse */
void mouse_deinitialize(void)
{
#if GPM_SUPPORT
    if (MouseSupport == MOUSE_GPM)
                mouse_gpm_deinitialize();
#endif
}


/* Deinit ncurses */
void screen_deinitialize(void)
{ 
#ifdef DSP_SUPPORT
    short i, *p;
    WINDOW *Wnd;
#endif


    help_deinitialize();

#ifdef DSP_SUPPORT
    for (i=0; i<FourWndCount; i++)
    { Wnd = FourWnd[i];
      if (Wnd) delwin(Wnd);

      p = FourSignal[i];
      if (p) free(p);
    }
#endif

    if (MainWnd) 
    {
       delwin(MainWnd);
       MainWnd = NULL;
    }


    if (Initialized > 0)
    {
 	if (ttyno >= 0)
        {  erase();  refresh();		

           if( SaveSet ||
           (  OptionsChanged &&
              ask_save_question("Settings changed. Save now?")
           )
	   ) save_settings();


	   if (curs_set(1) == ERR)
	       putp(cursor_visible);
        }
        else
           fclose(stdout);

        endwin();
	 if (IsX) system("stty sane");
    }

    mouse_deinitialize();

}


static void draw_digit(int digit, int x, int y)
{
   short i, j;
   short digt, mask;
   chtype ch;

   static short texture[10] =
           {075557, 026227, 071747, 071617, 045711,
            074717, 074757, 071111, 075257, 075717};

    digt = texture[digit];
    mask = 0x4000;

    for (j=0; j<5; j++)
    {
       wmove (MainWnd, y+j, x);
       for (i=0; i<3; i++)
       {   ch = (digt & mask) ? cBlock : ' ';
	     waddch(MainWnd, ch | side_attr);
           mask >>= 1;
       }
    }
}


static void draw_track_number(int number)
{   int x = TRACK_X;
    int y = TRACK_Y;


    wattrset(MainWnd, side_attr);
    wmove(MainWnd, y, x);
    draw_digit (number / 10, x, y);
    draw_digit (number % 10, x+4, y);
}


void show_volume(void)
{
   int vol;
   int stereo_support;

   if (MixerDeviceCount == 0) return;

   wattrset(MainWnd, side_text_attr);
   wmove(MainWnd, BAR_Y-1, 2);
   wprintw (MainWnd, "VOL %3d", volume);


   wattrset(MainWnd, side_attr);
   vol = (volume * VOL_BAR_LENGTH) / MAX_VOLUME;
   if (vol > VOL_BAR_LENGTH) vol = VOL_BAR_LENGTH;

   if (vol > 0)
   { wmove(MainWnd, BAR_Y, VOL_BAR_LEFT);
     whline(MainWnd, cVolBright, vol);
   }

   wmove(MainWnd, BAR_Y, VOL_BAR_LEFT+vol);

   vol = VOL_BAR_LENGTH-vol;
   if (vol > 0)
      whline(MainWnd, cVolDim, vol);

   /* ------------------------------------------ */

   stereo_support = (MixerCurDevMask == 0) ||
                           (MixerCurDevMask & MixerStereoMask);



   wattrset(MainWnd, side_text_attr);
   wmove(MainWnd, BAR_Y+1, 2);
   wprintw (MainWnd, "BAL%+4d", (balance-(MAX_BALANCE/2)));


   vol = (balance *  (VOL_BAR_LENGTH-1)) / MAX_BALANCE;
   if (vol >= VOL_BAR_LENGTH) vol = VOL_BAR_LENGTH-1;


   wattrset(MainWnd, stereo_support ? side_attr : side_dim_attr);
   wmove(MainWnd, BAR_Y+2, VOL_BAR_LEFT);

   if (vol > 0)
   {   whline(MainWnd, cVolDim, vol);
       wmove(MainWnd, BAR_Y+2, VOL_BAR_LEFT+vol);
   }

   waddch(MainWnd, cVolBright);

   whline(MainWnd, cVolDim, VOL_BAR_LENGTH-vol-1);

}

void show_mixer_device(void)
{   int  len, j1, j2;

    if (MixerDeviceCount == 0) return;

    wattrset(MainWnd,MixerCurDevMask == 0 ? side_attr : side_text_attr);
    len = strlen(MixerSoundDevice);
    j1 = (5-len) >> 1;
    j2 = 5-len-j1;
    wmove (MainWnd, BAR_Y+4, 3);
    while (--j1>=0) waddch(MainWnd, ' ');
    waddstr(MainWnd, MixerSoundDevice);
    while (--j2>=0) waddch(MainWnd, ' ');

    wattrset(MainWnd, fill_attr);
    wmove(MainWnd, MWND_HEIGHT-1, 3);
/*    wmove(MainWnd, BAR_Y+3, 3);
    wattrset(MainWnd, side_dim2_attr); */
    wprintw(MainWnd, "%02u/%02u", (u_int)(MixerCurDevice+1),
                                  (u_int)MixerDeviceCount);

}



void show_mixer_input(void)
{   char *text;
    chtype attr;

    if (MixerDeviceCount == 0) return;

    if (!(MixerCurDevMask & MixerRecmask))
    {		text = "   ";
		attr = side_dim_attr;
    }
    else
    if (MixerCurDevMask & MixerRecsrc)
    {		text = "ON!";
		attr = side_attr;
    }
    else
    {		text = "OFF";
	      attr = side_dim_attr;
    }

    wattrset(MainWnd, attr);
    mvwaddstr(MainWnd, BAR_Y+5, 4, text);

}

#ifdef USE_CHANGER

void show_changer_button(void)
{
	if (cd_slot_count>1)
	{	
	    /* Draw slot changer control */
	    wmove(MainWnd, MainWndHeight-1, MainWndWidth-SLOT_OFFSET_FROM_RIGHT);
	    wattrset(MainWnd, btn_attr); 
	    waddch(MainWnd, cLeftArrow);
	    wattrset(MainWnd, side_attr); 
	    wprintw(MainWnd, "%02d", cd_slot_current+1);
	    wattrset(MainWnd, btn_attr); 
	    waddch(MainWnd, cRightArrow);
	 }			
	 OldSlotNo = cd_slot_current;
}
#endif

void show_status_message(const char *status, short ind)
{
    int dist, len;

    if (!MainWnd || SuspendRefresh) return;

    len = strlen(status);


    wattrset(MainWnd, fill_attr);
    wmove(MainWnd, MWND_HEIGHT-1, BAR_X);

    dist = 33 - len;
    if (dist < 0) { len = 33; dist=0; } /* dist is redundant */
    else	
    whline(MainWnd, cCkboard, dist);

    if (len > 0)
    { switch(ind)
      {  case -2:
	    wattrset(MainWnd, msg_attr);
            break;

         case -1:   
	    wattrset(MainWnd, suspend_attr);
            break;
      
         default: 
            wattrset(MainWnd, side_attr);
      }      

      wmove(MainWnd, MWND_HEIGHT-1, BAR_X);
	waddch(MainWnd, ' ');
	while(--len>=0) waddch(MainWnd, *status++);	
	waddch(MainWnd, ' ');
      if (OverlapWnd) touchwin(OverlapWnd);	
    }  

    if (ind >= 0) show_stop_button(ind);
}


void show_progress(long elapsed, long duration, int y, int *progress_ptr)
{
    u_char mins, secs, frm;
    int progress, old_progress;
    chtype tattr;
    char text[10];

    if (SuspendRefresh < 0)
    {  if (time(NULL) >= msg_remove_time)
		delaunch_message();
    }


    if (elapsed < 0 || duration == 0)
    {   strcpy(text, "         ");
	  progress = -1;
    }
    else
    {
        if (elapsed > duration) elapsed = duration;


        switch(TimeDisplayMode)
       {  case DM_ELAPSED:
		  time_to_msf(elapsed, &mins, &secs, &frm);
              sprintf(text,"  %02u:%02u.%d",(u_int)mins, (u_int)secs, 10*frm/75);
              break;

          case DM_REMAINED:
		  time_to_msf(duration-elapsed, &mins, &secs, &frm);
              sprintf(text,"<%02u:%02u.%d>",(u_int)mins, (u_int)secs, 10*frm/75);
              break;

          case DM_PROGRESS:
	        progress =  elapsed * 1000 / duration;
              sprintf(text,"   %3u.%01u%%",  progress/10, progress%10 );
              break;

          case DM_PROGREM:
	        progress =  (duration-elapsed) * 1000 / duration;
              sprintf(text," <%d.%01u%%>", (progress/10), progress%10  );
              break;


          default:
		  sprintf (text, "     DM = %d", TimeDisplayMode);
        }

        progress = (u_long) BarLength * elapsed / duration;

     }

     wattrset(MainWnd, text_attr);
     mvwaddstr(MainWnd, y-1, BAR_X + BarLength - strlen(text) + 10 , text);


     old_progress = *progress_ptr;
     if (old_progress > BarLength) printf ("%d", old_progress);

     if (old_progress != progress)
     {
       if (old_progress >= 0 && old_progress < BarLength )
	 {
           wattrset(MainWnd, bar_attr);
           mvwaddch(MainWnd, y, BarLeft + old_progress, cBullet | bar_attr);
       }

	 if (progress >= 0 && progress < BarLength)
       {  tattr =  HelpFocus ? bar_attr : thumb_attr;
	    wattrset(MainWnd, tattr);
	    mvwaddch(MainWnd, y, BarLeft + progress, cBlock | tattr);
       }

       *progress_ptr = progress;  /* Logically, it should be outside if,
						    but it does not work */

    }

}

static void show_track_total(long duration, short y)
{	char text[8];

	u_char mins, secs, frm;


	wattrset(MainWnd, dimmed_attr);

	if (duration < 0)
	   strcpy(text, "       ");
	else
	{  time_to_msf(duration, &mins, &secs, &frm);
	   sprintf(text, "%02u:%02u.%d",(u_int)mins, (u_int)secs,
                                           (u_int)(frm*10/75));
	}

	wmove (MainWnd, y, TotalX);
	waddstr(MainWnd, text);
}


void clear_track_name(void)
{	 int l;
       l = ( MainWndWidth > 64) ? MainWndWidth-2 : 62;

       wmove(MainWnd, 0, (MainWndWidth-l)/2);
	 wattrset(MainWnd, fill_attr);
	 whline(MainWnd, cCkboard, l);

}

void draw_header(void)
{
	const char *header;
	short l;
	chtype attr = side_attr;
	int x;
	char buf[131];


        clear_track_name();

	header = NULL;
	switch (HeaderMode)
	{
	   case HEADER_DISC:
	        if (strlen(disc_artist) > 0)
        	    snprintf(buf, 131, "%s - %s", disc_artist, disc_name);
		else	
		    strcpy(buf, disc_name);

	  	header = buf;
		attr = bar_attr;
		break;


	   case HEADER_TRACK:
		if (track_cur != 0xff)
		    header = get_full_track_name(track_cur);
		attr = side_attr;  
		break;

	    default:
		return;
	}



	if (header== NULL || (l = strlen(header))==0)
						 return;

	x = (MainWndWidth-l-2) >> 1;
	if (x< 1) { x = 1; l = MainWndWidth-2; }

	wmove(MainWnd, 0, x);
	wattrset(MainWnd, attr);
	waddch(MainWnd, ' ');

	/* This will patch a colour bug with waddstr */
	while (--l>=0) waddch(MainWnd, *header++ | attr);
	waddch(MainWnd, ' ');

}

void change_header_mode()
{

     HeaderMode = (HeaderMode+1) % 3;
     draw_header();
     OptionsChanged = 1;
     show_mode(OPER_SAVEO);
}




void show_cd_time(void)
{

    long elapsed, duration;

    if (Initialized<=0) return;

    elapsed = time_cur - track_time_start;
    duration = track_time_end - track_time_start;

    if (track_cur != OldTrackNo 
#ifdef USE_CHANGER
	   ||	 cd_slot_current != OldSlotNo
#endif
	 )
    {  show_track_total(duration, BAR_Y+1);
	 if (OldTrackNo == 0xff
#ifdef USE_CHANGER
	       || cd_slot_current != OldSlotNo
#endif
	    )
       {   show_track_total(time_total-time_start, BAR_Y-1);
	     wattrset(MainWnd, fill_attr);
	     mvwprintw(MainWnd, MWND_HEIGHT-1, MainWndWidth-8,
                            "%02d-%02d", track_first, track_last);
	     if (HeaderMode == HEADER_DISC) draw_header();

           ArtistToggle = cd_multi_artist;

#ifdef USE_CHANGER
	     show_changer_button();
#endif
           if (BottomSection == DATA_FIRST_SECTION)
				 data_draw_fields();

       }



       if (track_cur != 0xff)
       {   draw_track_number(track_cur);
           if (HeaderMode == HEADER_TRACK) draw_header();
           if (!HelpFocus && BottomSection == DATA_FIRST_SECTION)
           {    data_set_browser(0, track_cur-track_first);
                if (PlayMode == PLAY_LIST)
    /*            { if track_cur == cur_plist(cur_plist_pos)) */
                        data_set_browser(1, cur_plist_pos);
    /*              else
                        data_set_playlist(-1); */
                }
		if (OverlapWnd) touchwin(OverlapWnd);
           }

       OldTrackNo = track_cur;
    }


    if (SuspendRefresh > 0)
    {  long absdif = time_cur - old_position;
	 if (absdif < 0) absdif = -absdif;
	 if (absdif < 70) return;
	 old_position = time_cur;
    }

    /* =============================================================== */
    /* Show relative track information */
    if (elapsed < 0) elapsed = 0;		/* Avoid bouncing effect */
    show_progress(elapsed, duration, BAR_Y+2, &old_progrel);


    /* =============================================================== */
    /* Show absolute track information */
    elapsed = time_cur - time_start;
    duration = time_total - time_start;
    if (elapsed < 0) elapsed = 0;		/* Avoid bouncing effect */
    show_progress(elapsed, duration, BAR_Y, &old_progabs);


}


void show_mode(OPERATION which)
{
   char  *tptr, text[4] = "   ";
   struct BTN_INFO *bi;
   chtype attr;
   short ind;
   int w, j;

   attr =  btn_attr;


   switch(which)
   {  case OPER_TIMEDISPLAY:     /* time mode */
           tptr =  (char *)TimeModeTxt + (TimeDisplayMode*3);
           break;

      case OPER_PLAYMODE:        /* play mode */
           tptr = (char *)PlayModeTxt + (PlayMode*3);
           break;

      case OPER_AUTOPLAY:        /* auto */
           tptr = (char *)AutoModeTxt;
           if (AutoPlay)
           { attr = side_attr; tptr+=3; }
           else
             attr = side_dim_attr;
           break;

      case OPER_LOOPPLAY:                 /* loop */
           tptr = (char *)LoopModeTxt;
           if (LoopPlay)
           {attr = side_attr; tptr+=3; }
           else
             attr = side_dim_attr;
           break;

/*       case OPER_SAVEO:  */
        default:                        /* Save options */
           tptr = (char *)SaveoTxt;
           if (OptionsChanged)
           {attr = side_attr; tptr+=3; }
/*           else
             attr = side_dim_attr; */

   }


   memcpy(text, tptr, 3);

   wattrset(MainWnd, attr);

   if (which == OPER_SAVEO) ind = OperSaveoIndex;
                     else   ind = OperModeIndex + (which - OPER_TIMEDISPLAY);

   bi = ButtonInfo + ind;
   wmove (MainWnd, bi->y, bi->x1);

   w = (bi->x2 - bi->x1 - 2) >> 1;
   if (w<0) w= 0;
   for (j=0; j<w; j++) waddch(MainWnd, ' ');
   waddstr(MainWnd, text);
   for (j=0; j<w; j++) waddch(MainWnd, ' ');

   if (which != OPER_SAVEO) show_mode(OPER_SAVEO);

}


void clear_cd_time(void)
{   int i;

    if (Initialized<=0) return;

    show_track_total(-1, BAR_Y-1);
    show_track_total(-1, BAR_Y+1);
    show_progress(-1, -1, BAR_Y, &old_progabs);
    show_progress(-1, -1, BAR_Y+2, &old_progrel);
    clear_track_name();

    if (BottomSection == DATA_FIRST_SECTION)
				 data_draw_fields();

    wattrset(MainWnd, side_attr);
    /* Clean track */
    for (i=1; i<MWND_HEIGHT-1; i++)
    {  wmove(MainWnd, i, TRACK_X-1);
	 whline(MainWnd, ' ' , 9);
    }

    /* Clear tracks total */
    wattrset(MainWnd, fill_attr);
    wmove (MainWnd, MWND_HEIGHT-1, MainWndWidth - 9);
    whline(MainWnd, cCkboard, 8);

    OldTrackNo = 0xff;
}

static void show_stop_button(short ind)
{
	struct BTN_INFO *bi;
	int    lft;
	int    wid;

	bi = (ButtonInfo + OperStopIndex);
	lft = bi->x1;
	wid = (bi->x2 - lft) >> 1;

	wmove(MainWnd,  bi->y, lft);
	wattrset(MainWnd, btn_attr);
	whline(MainWnd, ' ', wid);

	wmove(MainWnd,  bi->y, lft+wid);
	waddch(MainWnd, OperNotation[OPER_STOP][ind]);
      whline(MainWnd, ' ', wid);

	bi = (ButtonInfo + OperPlayIndex);
	lft = bi->x1;
	wid = (bi->x2 - lft) >> 1;

	wmove(MainWnd,  bi->y, lft);
	wattrset(MainWnd, btn_attr);
	whline(MainWnd, ' ', wid);

	wmove(MainWnd,  bi->y, lft+wid);
	waddch(MainWnd, OperNotation[OPER_PLAY][ind]);
      whline(MainWnd, ' ', wid);
}


static void show_button(short i, chtype attr)
{      int j, k, x1, x2;
       struct BTN_INFO *bi = ButtonInfo + i;

       k = bi->oper;
       wattrset(MainWnd, attr);

       if (k==OPER_STOP)
       {  show_stop_button(1);
	    cd_status = 0xf0;
          return;
       }

       x1 = bi->x1;
       wmove(MainWnd, bi->y, x1);

       x1 = bi->x2 - x1;

       if (x1>2) { x2 = (x1-2)>>1; x1 = 2; }
            else   x2 = 0;


	 for (j=0; j < x2; j++) waddch(MainWnd, ' ');
	 for (j=0; j <= x1; j++) waddch(MainWnd, OperNotation[k][j] | attr);
	 for (j=0; j < x2; j++) waddch(MainWnd, ' ');
}


static void show_buttons(void)
{   int i;

/*    wattrset(MainWnd, btn_attr); */
    for (i=0; i< ButtonsToDraw; i++)
			show_button(i, btn_attr);
}


static void arrange_buttons(void)
{
    int x, y;
    short  i;


   /* Bar buttons */
    y = BAR_Y;
    x = BAR_X;
    i = 0;
    wattrset(MainWnd, bar_attr);

    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+2;
    ButtonInfo[i].oper = OPER_PREV5;
    i++;

    x += 4;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+1;
    ButtonInfo[i].oper = OPER_PREV;
    i++;

    x += 3;
    wmove(MainWnd, y, x);
    whline(MainWnd, cBullet, BarLength);

    x += BarLength+1;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+1;
    ButtonInfo[i].oper = OPER_NEXT;
    i++;

    x +=3;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+2;
    ButtonInfo[i].oper = OPER_NEXT5;
    i++;

    y += 2;
    x =  BAR_X;
    OperPlayIndex = i;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+2;
    ButtonInfo[i].oper = OPER_PLAY;
    i++;

    x += 4;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+1;
    ButtonInfo[i].oper = OPER_BACK;
    i++;

    x += 3;
    BarLeft = x;
    wmove(MainWnd, y, x);
    whline(MainWnd,  cBullet, BarLength);

    x += BarLength + 1;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+1;
    ButtonInfo[i].oper = OPER_FWD;
    i++;

    x += 3;
    OperStopIndex = i;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+2;
    ButtonInfo[i].oper = OPER_STOP;  /* OPER_PAUSE; */
    i++;


   /* Bottom buttons */

    y += 2;
    x = BAR_X;

    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_HELPPREV;
    i++;
/*
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_HELP;
    i++;
 */
    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_SAVEO; /* OPER_SUSPEND; */
    OperSaveoIndex = i;
    i++;

    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_REFRESH;
    i++;

    x = BarLeft + BarLength - 2*BtnDist -BtnWidth + 6;
/*
    OperStopIndex = i;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_STOP;
    i++;
*/

    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_QUIT;
    i++;

    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_STOPQUIT;
    i++;


    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_HELPNEXT;
    i++;


#ifdef MIXER_SUPPORT
    /* Mixer buttons */

    if (mixer >= 0)
    {
	    y = BAR_Y + 4;
	    x = 1;
	    ButtonInfo[i].y  = y;
	    ButtonInfo[i].x1 = x;
	    ButtonInfo[i].x2 = x+1;
	    ButtonInfo[i].oper = OPER_MIXERPREV;
	    i++;

	    x += 7;
	    ButtonInfo[i].y  = y;
	    ButtonInfo[i].x1 = x;
	    ButtonInfo[i].x2 = x+1;
	    ButtonInfo[i].oper = OPER_MIXERNEXT;
	    i++;

	    y++;
	    x = 4;
	    ButtonInfo[i].y  = y;
	    ButtonInfo[i].x1 = x;
	    ButtonInfo[i].x2 = x+2;
	    ButtonInfo[i].oper = OPER_INPUT;
	    i++;

    }
    ButtonsToDraw = i -1;
#else

    ButtonsToDraw = i;

#endif

#ifdef USE_CHANGER
    if (cd_slot_count > 1)
    {
	    y = MainWndHeight-1;
	    x = MainWndWidth-SLOT_OFFSET_FROM_RIGHT;

	    ButtonInfo[i].y  = y;
	    ButtonInfo[i].x1 = x;
	    ButtonInfo[i].x2 = x+3;
	    ButtonInfo[i].oper = OPER_CHANGESLOT;
	    i++;					
    }
#endif

    /* User control buttons */
    x = TotalX-(BtnDist*3+BtnWidth)/2+3;
    y = BAR_Y + 4;
    OperModeIndex = i;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_TIMEDISPLAY;
    i++;

    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_AUTOPLAY;
    i++;

    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_LOOPPLAY;
    i++;

    x += BtnDist;
    ButtonInfo[i].y  = y;
    ButtonInfo[i].x1 = x;
    ButtonInfo[i].x2 = x+BtnWidth;
    ButtonInfo[i].oper = OPER_PLAYMODE;
    i++;

    ButtonsToCheck = i;

}
/* Drawing board routine */

#ifdef DSP_SUPPORT
void draw_ampers_text(WINDOW *wnd, char *text)
{ 	char c;

	while ((c = *text++) != 0)
	{ if (c == '&')
	  { c = *text++;
	    waddch(wnd, c | help_title_attr);
	  }
	  else
	    waddch(wnd, c | text_attr);
	}
}

static void draw_spectrum_value_fields(WINDOW *wnd)
{    int gain;	

	gain_y = FourWndHeight-1;
	gain_x1 = FourWndWidth-9;
	gain_x2 = FourWndWidth-4;
  
	gain = (BottomSection == 0) ? FourGain : WaveVScale;
	wmove(wnd, gain_y, gain_x1-6);

	wattrset(wnd, fill_attr);

	if (BottomSection == 0)
	{  waddch(wnd, cCkboard);
	   draw_ampers_text(wnd, "&Gain ");	   
	}
	else 
	   draw_ampers_text(wnd, "Scale ");	   

	wattrset(wnd, btn_attr);
	waddch(wnd, cLeftArrow);	
	wattrset(wnd, side_text_attr);
	wprintw(wnd, " %+2d ",  gain);
	wattrset(wnd, btn_attr);
	waddch(wnd, cRightArrow);	


	interl_x1 = 13;
	interl_x2 = 17;
	gain = (BottomSection == 0) ? FourInterlace : WaveObturate;
	wmove(wnd, gain_y, interl_x1-10);
	wattrset(wnd, fill_attr);

	if (BottomSection == 0)
	   draw_ampers_text(wnd, "&Interlace ");
	else 
	{  waddch(wnd, cCkboard);
	   draw_ampers_text(wnd, "Obturate ");
	}
	wattrset(wnd, btn_attr);
	waddch(wnd, cLeftArrow);	
	wattrset(wnd, side_text_attr);
	wprintw(wnd, " %1d ",  gain);
	wattrset(wnd, btn_attr);
	waddch(wnd, cRightArrow);	

    
}

void draw_gain()
{	WINDOW *wnd;
	int  gain;

	if (BottomSection >= DATA_FIRST_SECTION || FourWndCount <= 0) return;

	gain = (BottomSection > 0) ? WaveVScale : FourGain;  
	wnd = FourWnd[FourWndCount-1];
	wmove(wnd, gain_y, gain_x1+2);
	wattrset(wnd, side_text_attr);
	wprintw(wnd, "%+2d",  gain);
}

void draw_interlace()
{	WINDOW *wnd;
	int  intlace;

	if (BottomSection >= DATA_FIRST_SECTION || FourWndCount <= 0) return;

	intlace = (BottomSection > 0) ? WaveObturate : FourInterlace;  
	wnd = FourWnd[FourWndCount-1];
	wmove(wnd, gain_y, interl_x1+2);
	wattrset(wnd, side_text_attr);
	wprintw(wnd, "%d",  intlace);
}

void init_spectrum_wnd(void)
{
    int i;
    WINDOW  *CurWnd;

     /* Fourier transform window */
     for (i=0; i< FourWndCount; i++)
     { CurWnd = FourWnd[i];
        if (CurWnd)
        {
	    if (AreColours)
	      wbkgd(CurWnd, spectr3_attr );

            werase(CurWnd);            
	    wattrset(CurWnd, fill_attr);
	    wmove(CurWnd, 0, 0);
	    wvline(CurWnd, cCkboard, FourWndHeight);
	    wmove(CurWnd, FourWndHeight-1, 1);
	    whline(CurWnd, cCkboard, FourWndWidth-2);
	    wmove(CurWnd, 0, FourWndWidth-1);
	    wvline(CurWnd, cCkboard, FourWndHeight);

/*          wborder(CurWnd, cCkboard, cCkboard, cCkboard, cCkboard,
                          cCkboard, cCkboard, cCkboard, cCkboard); */
	    if (i==FourWndCount-1) draw_spectrum_value_fields(CurWnd);	
            wnoutrefresh(CurWnd);
        }
     }
     doupdate();
}

int  change_gain(short increm)
{   
    switch(BottomSection)
    { case 0:	
	increm += FourGain;
        if (increm > GAIN_MAX ||
            increm < GAIN_MIN) return 0;	
	FourGain = increm;
	OptionsChanged = 1;
	break;

      case 1:
	increm += WaveVScale;
	if (increm > VSCALE_MAX ||
            increm < VSCALE_MIN) return 0;	
	WaveVScale = increm;
	OptionsChanged = 1;
	break;

      default:
	return 0;   	
    }

    draw_gain();
    return 1;	
}

int  change_interlace(short increm)
{   
    switch(BottomSection)
    { case 0:	
		increm += FourInterlace;
		if (increm > INTERLACE_MAX ||
                increm < INTERLACE_MIN) return 0;	
		FourInterlace = increm;
		spectr_start = 0;
		spectr_inter_mode = 0;
		FourWndMask = (FourWndCount < 2 || FourInterlace) ? 1 : 3;
		OptionsChanged = 1;
		break;

      case 1:
		increm += WaveObturate;
		if (increm > OBTURATE_MAX ||
      	    increm < OBTURATE_MIN) return 0;	
		WaveObturate = increm;
		OptionsChanged = 1;
		break;

      default:
		return 0;   	
    }

    draw_interlace();
    return 1;	
}
#endif


static void board_draw(void)
{   int i;

    refresh();

    wbkgd(MainWnd, bkgr_attr );
    wclear(MainWnd);

    wattrset(MainWnd, fill_attr );

    wborder(MainWnd, cCkboard, cCkboard, cCkboard, cCkboard,
                     cCkboard, cCkboard, cCkboard, cCkboard);

    wmove(MainWnd, 1, 10);
    wvline(MainWnd, cCkboard, MWND_HEIGHT-2);
    wmove(MainWnd, 1, MainWndWidth - 11);
    wvline(MainWnd, cCkboard, MWND_HEIGHT-2);

/*    mvwaddstr(MainWnd, 0, 3, Header); */

    wattrset(MainWnd, text_attr);
    mvwaddstr(MainWnd, BAR_Y-1, BAR_X+4, "TOTAL");
    mvwaddstr(MainWnd, BAR_Y+1, BAR_X+4, "CURRENT");

    if (AreColours)
    {    mvwaddch(MainWnd, BAR_Y, BAR_X+6, cBullet);
         mvwaddch(MainWnd, BAR_Y, BAR_X+7+BarLength, cBullet);
         mvwaddch(MainWnd, BAR_Y+2, BAR_X+6, cBullet);
         mvwaddch(MainWnd, BAR_Y+2, BAR_X+7+BarLength, cBullet);
    }


    /* Draw hole for track display */
    wattrset(MainWnd, side_attr);


    for (i=1; i<MWND_HEIGHT-1; i++)
    {  wmove(MainWnd, i, TRACK_X-1);
	 whline(MainWnd, ' ', 9);
	 wmove(MainWnd,  i, 1);
	 whline(MainWnd, ' ', 9);
    }

#ifdef DSP_SUPPORT
    init_spectrum_wnd();
#endif

    clear_cd_time();

    arrange_buttons();
    show_buttons();

    show_mixer_device();
    show_mixer_input();
#ifdef USE_CHANGER
    show_changer_button();	
#endif
    wnoutrefresh(MainWnd);

    doupdate();

}

#ifdef DSP_SUPPORT
void  draw_wave(void)
{
    int i, j, k;
    int increm = bbuf_size/FourWndWidth;
    int signal;
    static short m =0;
    short hei1;
    WINDOW *CurWnd;
    const int WaveVRes = 1, WaveHRes = 1;
    chtype col_attr;
    short  obturate;

   if (SuspendRefresh > 0 || BottomSection != 1) return;
    increm= FourWndCount;

    hei1 = FourWndHeight - WaveVRes;

    obturate = (cd_status == CDROM_AUDIO_PLAY) ? WaveObturate : 0;

    for (k=0; k<FourWndCount; k++)
    {  CurWnd = FourWnd[k];
	 wattrset(CurWnd, spectr1_attr);
       for (i=0; i<FourWndEffHeight; i++)
	 {  wmove(CurWnd, i, 1);
	    whline(CurWnd, ' ', FourWndEffWidth);
	 }
	 if (obturate) wrefresh(CurWnd);
    }

    if (obturate > 1)
    {  m = (m+1) % obturate;
       if (m) return;
    }


    col_attr = spectr1_attr;
    for (k=0; k<FourWndCount; k++)
    {  CurWnd = FourWnd[k];


       j = k;
       for (i=0; i<FourWndWidth-2; i+=WaveHRes, j+=increm)
       {
/*	  if (sample_size == 8)
             signal = (((unsigned) iobuf[j%bbuf_size] << 8) & 0xffff) - 0x8000; 
	  else
             signal = iobuf16[j%bbuf_size]; */
	  if (sample_size == 8)
	  {    if(unsgn_mode) 
	          signal =  ((((int)iobuf[j%bbuf_size]+128)  << 8 ) & 0xffff) - 0x8000; 
	       else
	          signal = (((int)iobuf[j%bbuf_size] << 8) & 0xffff) - 0x8000;
	  }		  
	  else
	  {   if (unsgn_mode)
	          signal = ((int)iobuf16[j%bbuf_size] & 0xffff) - 0x8000;
	       else		  
	          signal = (int)iobuf16[j%bbuf_size]; 
	  }		  

	  if (WaveVScale > 0)
	  {  signal <<= WaveVScale;
	     if (signal > 0x07fff) signal = 0x07fff;
	     if (signal < -0x08000 ) signal = -0x08000;
	  }
          else
	  if (WaveVScale > 0)
             signal >>= -WaveVScale;

    	  signal = ((~(signal+0x8000) & 0xffff) * hei1) >> 16;

          wmove(CurWnd, signal, i+1);
          waddch(CurWnd, cDiamond | col_attr);
       }

	 wnoutrefresh(CurWnd);
	 col_attr = spectr2_attr;
    }


}


void  draw_spectrum(void)
{
   WINDOW  *CurWnd;
   CPLX value;
   short *SpecVals;
   chtype tp;

   short module, border1, border2;
   short i,j, k, shift;
   CPLX   *bufptr;


   if (SuspendRefresh > 0 || BottomSection > 0) return;
/* if (BottomSection == 1)
   {  draw_wave();  return;   } */

   border1 = FourWndEffHeight/3;
   border2 = FourWndEffHeight-border1;

   shift = spectr_inter_mode ? FourInterlace : 1;


   for (k=0; k<FourWndCount; k++)
   {
      if (!((k+1) & FourWndMask)) continue;

	if ( !(CurWnd = FourWnd[k]) || !(SpecVals = FourSignal[k])) continue;

      bufptr = ft_buffer + k*ft_bufsize;

      for (i=spectr_start; i<FourWndEffWidth; i+=shift)
      {

         ft_process(&value, bufptr, (i+1));

         module = (long)(sqrt(value.r*value.r + value.i*value.i) * FourWndEffHeight) >> (ft_size+10-FourGain);


	 module = FourWndEffHeight-(3*module)/4;
	 if (module <0) module = 0;
	 if (module >FourWndEffHeight) module = FourWndEffHeight;

	 SpecVals[i] = module;
      }



      for (j=0; j<FourWndEffHeight; j++)
      {    wattrset( CurWnd,  (j<border1) ? spectr3_attr:
                   (j<border2) ? spectr2_attr: spectr1_attr);

          wmove(CurWnd, j, 1);
          for (i=0; i<FourWndEffWidth; i++)
          {   module = SpecVals[i];
              tp = (module  >  j) ? ' ':
                   (module ==  j) ? cSpectDim :
                   cSpectBright;
              waddch(CurWnd, tp);
          }

       }

       wnoutrefresh(CurWnd);
    }

     if (FourInterlace > 0)
     {  if (FourWndCount > 1) FourWndMask ^= 11;
	  if (FourWndMask==1 && FourInterlace > 1)
	  {   spectr_start = (spectr_start + 1) % FourInterlace;
            spectr_inter_mode = 1;
	  }
     }

     doupdate();
}
#endif

void redraw_screen(void)
{

    if (BottomSection >= DATA_FIRST_SECTION)
           help_redraw();
    else
    if (SuspendRefresh > 0)
    {	
#ifdef DSP_SUPPORT
         void (*draw_function)(void);
         draw_function = (BottomSection == 0) ? draw_spectrum : draw_wave;

	 SuspendRefresh =0;
	 show_cd_time();
	 (*draw_function)();
	 if (FourWndCount ==2 && FourInterlace > 0)
         {  sound_process();
	    (*draw_function)();
         }
	 SuspendRefresh = 1;
#endif
         touchwin(MainWnd);
/*	 wrefresh(MainWnd);  */
   	 wnoutrefresh(MainWnd);

         doupdate();	
    }
    else
    {
         
         clear();
	 refresh();
	 touchwin(MainWnd);
         wnoutrefresh(MainWnd);
#ifdef DSP_SUPPORT
   	 { WINDOW *wnd;
           int i;
           
	   for (i=0; i<FourWndCount; i++)
           { wnd = FourWnd[i]; 
             if (wnd)
             {  touchwin(wnd);
                wnoutrefresh(wnd);
             }
           }
         }        
#endif	 
         doupdate();
    }

}

void set_suspend_mode(short NewMode)
{
    if (!MainWnd) return;

    if (NewMode > 0)
    {    old_position = time_cur;
	   show_status_message("Suspended", -1);
    }
    else
    	   cd_status = 0xf0;   /* This will force status to be re-displayed*/

    SuspendRefresh = NewMode;

    wrefresh(MainWnd);

}


static void show_pressed_button(int i)
{
    if (i < ButtonsToDraw && i != OperPlayIndex && i != OperStopIndex)
    {
       show_button(i, thumb_attr);
       refresh_output();
       OldPressedButton = i;
    }
}


/*
static void show_button_equivalent(short pos, short i)
{

	wmove(MainWnd, MainWndHeight-1, pos);
	wattrset(MainWnd, fill_attr);

	if (i < 0)
	   whline(MainWnd, cCkboard, BtnWidth);
	else
	{
	   struct BTN_INFO *bi = ButtonInfo + i;
	   short  gap, k;
	   OPERATION oper = bi->oper;
	   chtype elem, midel;

	   midel = (oper == OPER_STOP) ? OperNotation[oper][1] :
	           (oper == OPER_PLAY) ? OperNotation[oper][2] :
 	           (oper == OPER_TIMEDISPLAY) ?  'T' :
 	           (oper == OPER_PLAYMODE) ?  'P' :
 	           (oper == OPER_AUTOPLAY) ?  'A' : '\0';

	   gap =  (BtnWidth - 2) >> 1;
           for (k=0; k<gap; k++) waddch(MainWnd, ' ');

	   for (k=0; k<2; k++)
	   {  if (midel) elem =  k==1 ? midel : ' ';
	      else elem =  OperNotation[oper][k];
	      waddch(MainWnd, elem);
           }
           gap++;
           for (k=0; k<gap; k++) waddch(MainWnd, ' ');
        }

}
*/

static void show_button_equivalent(short pos, short i)
{
	short k;

	wmove(MainWnd, MainWndHeight-1, pos);
	wattrset(MainWnd, fill_attr);

	if (i < 0)
	   k = 0;
	else
	{
	   struct BTN_INFO *bi = ButtonInfo + i;
	   short  len = bi->x2 - bi->x1;
	   OPERATION oper = bi->oper;
	   chtype elem, midel;

	   midel = (oper == OPER_STOP) ? OperNotation[oper][1] :
		     (oper == OPER_PLAY) ? OperNotation[oper][2] :
 	           (oper == OPER_TIMEDISPLAY) ?  'T' :
 	           (oper == OPER_PLAYMODE) ?  'P' :
 	           (oper == OPER_AUTOPLAY) ?  'A' :
 	           (oper == OPER_LOOPPLAY) ?  'L' : '\0';

	   if (len > 2) len = 2;

	   for (k=0; k<=len; k++)
	   {  if (midel) elem =  k==1 ? midel : ' ';
	      else elem =  OperNotation[oper][k];
	      waddch(MainWnd, elem);
           }
        }

        while (k++<3) waddch(MainWnd, cCkboard);

}


static OPERATION mouse_command(void)
{
	int x, y;
	mmask_t btn_state;

	x = LastMouseEvent.x - MainWndLeft - 1;
	y = LastMouseEvent.y - MainWndTop - 1;
	btn_state = LastMouseEvent.bstate;

	if (btn_state & BUTTON1_CLICKED)
	{
	   if (y == 0)
	   {  change_header_mode();
				return OPER_NONE;
	   }

	   if (y == BAR_Y)
	   {  int pos = x - BarLeft;

		 if (pos>=0 && pos < BarLength)
		 {  time_req = time_total * pos / BarLength;
               return OPER_PLAYFROMALIGNED;
		 }

		 pos = x - VOL_BAR_LEFT;
		 if (pos >=0 && pos < VOL_BAR_LENGTH)
		 {  mixer_setvolume (pos * MAX_VOLUME/(VOL_BAR_LENGTH-1), balance);
		    if (SaveMixer) DataChanged = 1; 
        return OPER_SPECIAL;
		 }
  }

	   if (y== BAR_Y+2)
	   {  int pos = x - BarLeft;
	
            if (pos>=0 && pos < BarLength)
            {  long duration = track_time_end - track_time_start;
               time_req = track_time_start + (duration * pos / BarLength);
               return OPER_PLAYFROM;
            }

		pos = x - VOL_BAR_LEFT;
		if (pos >= 0 && pos < VOL_BAR_LENGTH)
		{   mixer_setvolume (volume, pos * MAX_BALANCE/(VOL_BAR_LENGTH-1));
		    if (SaveMixer) DataChanged = 1; 
                return OPER_SPECIAL;
            }
         }

	   if (y == MWND_HEIGHT -1)
	   {  if (x >= RightEquPos && x <= RightEquPos + 2)
		{	RightEqu = -1;
			show_button_equivalent(RightEquPos, -1);
			return OPER_SPECIAL;
		}

		if (x >= MiddleEquPos && x <= MiddleEquPos + 2)
		{	MiddleEqu = -1;
			show_button_equivalent(MiddleEquPos, -1);
			return OPER_SPECIAL;
		}
	   }

#ifdef DSP_SUPPORT
	   if (BottomSection < DATA_FIRST_SECTION && FourWndCount > 0)
	   {  int y1 = LastMouseEvent.y - FourWndTop - 1;
		if (y1 == gain_y)
		{  if (x == gain_x1) change_gain(-1);
		   if (x == gain_x2) change_gain(1);
		   if (x == interl_x1) change_interlace(-1);
		   if (x == interl_x2) change_interlace(1);
		}
	   }
#endif
	
     }

     if (btn_state &
                 (BUTTON1_CLICKED |  BUTTON2_CLICKED | BUTTON3_CLICKED))
     {
	   struct BTN_INFO *bi;
	   int i;

	   for (i=0; i<ButtonsToCheck; i++)
	   {	bi = ButtonInfo + i;

		if (y == bi->y && x >= bi->x1 && x<= bi->x2)
		{
		   if(btn_state & BUTTON3_CLICKED)
		   {	RightEqu = i;
			show_button_equivalent(RightEquPos, i);
		   }
               if(btn_state & BUTTON2_CLICKED)
		   {	MiddleEqu =  i;
			show_button_equivalent(MiddleEquPos, i);
               }
		   if(btn_state & BUTTON1_CLICKED)
  		   {  OPERATION oper;
			show_pressed_button(i);
			oper = bi->oper;
/*
			 if ((oper == OPER_TIMEDISPLAY || oper == OPER_PLAYMODE)
			     && x < (bi->x1 + bi->x2)/2) oper += 1000;
*/
			 if ((oper == OPER_TIMEDISPLAY || oper == OPER_PLAYMODE)
		 	      && (btn_state & BUTTON_SHIFT) )
		            oper += 1000;

#ifdef USE_CHANGER
			 else
			 if ( oper == OPER_CHANGESLOT && 
			     	(x <= bi->x1 || (btn_state & BUTTON_SHIFT))
			    ) oper += 1000;
#endif

		       return oper;
		   }
		   return OPER_NONE;
		}
	   }

     }

  if (btn_state & BUTTON4_CLICKED)		/* wheel1 forward */
	{ if (btn_state & BUTTON_CTRL)
		  btn_state |= BUTTON4_RESERVED_EVENT;
	  else
		  return (btn_state & BUTTON_SHIFT) ? OPER_NEXT : OPER_FWD;
	}
  
  if (btn_state & BUTTON4_RESERVED_EVENT)  /* wheel1 back */
		  	return (btn_state & BUTTON_SHIFT) ? OPER_PREV : OPER_BACK;

  if (btn_state & BUTTON5_CLICKED)		/* wheel2 right */
  { if (btn_state & BUTTON_CTRL)
		 btn_state |= BUTTON5_RESERVED_EVENT;
	 else
		return (btn_state & BUTTON_SHIFT) ? OPER_FWD : OPER_NEXT;
  }
  if (btn_state & BUTTON5_RESERVED_EVENT)  /* wheel2 left */
		  	return (btn_state & BUTTON_SHIFT) ? OPER_BACK : OPER_PREV;


	if((RightEqu >=0) && (btn_state & BUTTON3_CLICKED))
	{  show_pressed_button(RightEqu);
	   return (ButtonInfo + RightEqu)->oper;
	}
	if((MiddleEqu >=0) && (btn_state & BUTTON2_CLICKED))
	{   show_pressed_button(MiddleEqu);
	    return (ButtonInfo + MiddleEqu)->oper;

	}

	return OPER_NONE;

}

short get_mouse_event(void)
{    short rc;

     switch(MouseSupport)
     {

#if GPM_SUPPORT
	  case MOUSE_GPM:
	    rc = gpm_getmouse(&LastMouseEvent);
	    break;
#endif
        case MOUSE_NATIVE:
          rc = native_getmouse(&LastMouseEvent);
	    break;

        default:
          rc = 0;
     }
     return rc;
}

void accept_focus(void)
{

    old_progrel = -1;
    old_progabs = -1;

    show_cd_time();

    if (BottomSection>=DATA_FIRST_SECTION) help_accept_focus();
}
/*
void show_bottom_header(short section)
{   const char *header = SectionNames[section];
    int x = (MainWndWidth - strlen(header))/2;
    int y = FourWndHeight-1;
    WINDOW *wnd = FourWnd[FourWndCount-1];

    wattrset(wnd, fill_attr);
    wmove(wnd, y, x);
    whline(wnd, cCkboard, 8);
    x += (6-strlen(header))>>1;
    wmove(wnd, y, x);
    wattrset(wnd, side_attr);
    wprintw (wnd, " %s ", header);

}
*/

void accept_bottom_section(short new_section)
{   short  old_section = BottomSection;

    BottomSection = new_section;



#ifdef RCDDB_SUPPORT    
   if (old_section == RCDDB_SECTION)
            rcddb_deactivate();
#endif            

    if (new_section >= DATA_FIRST_SECTION)
    {
       if (old_section < DATA_FIRST_SECTION)
                   help_activate();

	 if (new_section >= HELP_FIRST_SECTION)
            help_accept_section(new_section - HELP_FIRST_SECTION);
#ifdef RCDDB_SUPPORT    
	 else
       if (new_section == RCDDB_SECTION)
            rcddb_activate();
#endif            
       else 
            data_accept_section(new_section - DATA_FIRST_SECTION);

    }
    else
    {
       if (old_section >= DATA_FIRST_SECTION)
           help_deactivate();

#ifdef DSP_SUPPORT
      if (FourWndCount > 0)
      {    draw_spectrum_value_fields (FourWnd[FourWndCount-1]);
   	/*  show_bottom_header(new_section); */
      }
#endif
    }

}

OPERATION  get_action(void)
{    int key, keyUC;

     OPERATION oper;

     struct OPER_KEYS
     { int key1; int key2; OPERATION oper; }
     keysOper[] = {{KEY_RIGHT, '6',   OPER_FWD},
                   {KEY_LEFT,  '4',   OPER_BACK},
                   {KEY_UP,    '8',   OPER_PREV},
                   {KEY_DOWN,  '2',   OPER_NEXT},
/*                   {KEY_B2,    '5',   OPER_PAUSE},   */
                   {KEY_IC,    '0',   OPER_STOP},
                   {KEY_PPAGE, '9',   OPER_PREV5},
                   {KEY_NPAGE, '3',   OPER_NEXT5},
                   {KEY_HOME,  '7',   OPER_FIRSTTRACK},
                   {KEY_END,   '1',   OPER_LASTTRACK},
                   { ' ',      '\0',  OPER_PLAY},
                   { 'p',      '\0',  OPER_PLAYMODE},
                   { 'A',      '\0',  OPER_AUTOPLAY},
                   { 'L',      '\0',  OPER_LOOPPLAY},
                   { 't',      '\0',  OPER_TIMEDISPLAY},
                   { KEY_F(1), 'h',   OPER_HELPNEXT},
                   { KEY_F(2), 'H',   OPER_HELPPREV},
                   { '<',      ',',   OPER_MIXERPREV},
                   { '>',      '.',   OPER_MIXERNEXT},
                   { '\'',     '\"',  OPER_INPUT},
                   { 'S',      '*',   OPER_SUSPEND},
                   { 'R',      0x12,  OPER_REFRESH},
                   { 'X',      'Q',   OPER_QUIT},
                   { 'V',    KEY_F(10),   OPER_SAVEO},
                   { 'P',      '\0',  OPER_PLAYMODE+1000},
                   { 'T',      '\0',  OPER_TIMEDISPLAY+1000},
#ifdef USE_CHANGER
			 { 'o',      '\0',  OPER_CHANGESLOT},
			 { 'O',      '\0',  OPER_CHANGESLOT+1000},
#endif
                   { 'Z',      '\0',  OPER_STOPQUIT}
                 },
		 *keysOperPtr;



     oper = OPER_NONE;

		if (!IsX)
		{
			 key = CheckTTY();
		 	if (key != current_tty)
		 	{ current_tty = key;
#ifdef MIXER_SUPPORT
				 if (current_tty) requery_mixer();
#endif
		 	}	
		 	if (!current_tty) return oper;
		}

     if ( OldPressedButton >=0 )
     {
	    show_button(OldPressedButton, btn_attr);
	    OldPressedButton = -1;
     }

     refresh_output();


#if GPM_SUPPORT
     if (MouseSupport == MOUSE_GPM)
        key = gpm_getch();
     else
#endif
        key = getch();

     if (key==KEY_MOUSE && !get_mouse_event())
		  	        key = ERR;

     if (BottomSection >= DATA_FIRST_SECTION)
     {   oper = help_getaction(key);
	   if (oper != OPER_NONE) return oper;
     }

     if (key == ERR)  return OPER_NONE;

     	

     if (key == KEY_BEG) keyUC = key = KEY_B2;
     else
     if ((key == KEY_F(1) && (get_kbd_shift() & 1))
                   || key == KEY_F(13)) keyUC = key = KEY_F(2);
     else	 	 	
     if (key < 0x80 && !strchr("tpho", key)) keyUC = toupper(key);
				              else  keyUC = key;

     switch(keyUC)
     {
	  case KEY_MOUSE:
            oper = mouse_command();
	    if (BottomSection>=HELP_FIRST_SECTION && oper == OPER_NONE) help_getaction(key);
            break;

	  case ']':
	      mixer_changevolume(1, 0);
		if (SaveMixer) DataChanged = 1; 
            oper = OPER_SPECIAL;
            break;

	  case '[':
	 	mixer_changevolume(-1, 0);
		if (SaveMixer) DataChanged = 1; 
            oper = OPER_SPECIAL;
            break;

	  case '}':
		mixer_changevolume(0, 1);
		if (SaveMixer) DataChanged = 1; 
            oper = OPER_SPECIAL;
            break;

	  case '{':
		mixer_changevolume(0, -1);
		if (SaveMixer) DataChanged = 1; 
            oper = OPER_SPECIAL;
            break;

	  case 'D':
	    change_header_mode();
	    break;

#ifdef DSP_SUPPORT
	  case 'G':
	    change_gain(islower(key) ? 1 : -1);
	    break;

	  case 'I':
	    change_interlace(islower(key) ? 1 : -1);
	    break;
#endif

	  default:
	  {   int  count = sizeof(keysOper)/sizeof(struct OPER_KEYS);
	      keysOperPtr = keysOper;
            while (--count>=0)
            { if(keysOperPtr->key1 == keyUC || keysOperPtr->key2 == keyUC)
               { oper = keysOperPtr->oper; break; }
              keysOperPtr++;
            }
        }

     }

     switch(oper)
     {  case OPER_TIMEDISPLAY:
	      TimeDisplayMode = (TimeDisplayMode+1) % TIME_DISPLAY_MODES;
	      OptionsChanged = 1;
		show_mode(OPER_TIMEDISPLAY);
	      oper = OPER_NONE;
     		break;

       case OPER_TIMEDISPLAY+1000:
	      TimeDisplayMode = (TimeDisplayMode + TIME_DISPLAY_MODES - 1)
						 % TIME_DISPLAY_MODES;
	      OptionsChanged = 1;
		show_mode(OPER_TIMEDISPLAY);
	      oper = OPER_NONE;
     		break;

#ifdef USE_CHANGER
	  case OPER_CHANGESLOT:
		if (cd_slot_count > 1) 
		{  select_slot((cd_slot_current+1) % cd_slot_count);
		   show_changer_button();
		}
		oper = OPER_NONE;
		break;

	  case OPER_CHANGESLOT+1000:
		if (cd_slot_count > 1) 
		{  select_slot((cd_slot_current+cd_slot_count-1) % cd_slot_count);
		   show_changer_button();
		}
		oper = OPER_NONE;
		break;
#endif
#ifdef MIXER_SUPPORT
	  case OPER_MIXERNEXT:
     		mixer_accept_next_device();
         	oper = OPER_SPECIAL;
     		break;

	  case OPER_MIXERPREV:
		mixer_accept_prev_device();
		oper = OPER_SPECIAL;
     		break;


	  case OPER_INPUT:
    		mixer_toggleinput();
		oper = OPER_SPECIAL;
		break;
#endif

        case OPER_REFRESH:
            redraw_screen();
/*            if (SuspendRefresh <= 0) launch_message("Refreshed"); */
	    oper = OPER_SPECIAL;
            break;

        case OPER_SUSPEND:
	      if (BottomSection<DATA_FIRST_SECTION ||
                   SuspendRefresh >= 0) set_suspend_mode (SuspendRefresh ^ 1);
	      oper = OPER_SPECIAL;
           break;

        case OPER_HELPNEXT:
        {   short new_section;
  		new_section = (BottomSection + 1) % BOTTOM_SECTIONS;
		if (FourWndCount == 0 && new_section == 1) new_section = 2;
		accept_bottom_section(new_section);
        }
	      oper = OPER_SPECIAL;
		break;

        case OPER_HELPPREV:
        {   short new_section;
  		new_section = (BottomSection + BOTTOM_SECTIONS - 1 ) % BOTTOM_SECTIONS;
		if (FourWndCount == 0 && new_section == 1) new_section = 0;
		accept_bottom_section(new_section);
	  }
	      oper = OPER_SPECIAL;
		break;

       case OPER_SAVEO:
           save_settings();
           show_mode(OPER_SAVEO);
           break;

	  default:				/* To avoid stupid warnings */
     }

     return oper;

}




void refresh_output(void)
{
   if (!MainWnd) return;
   wrefresh(MainWnd);

   if(OverlapWnd) 
	wrefresh(OverlapWnd);

#if GPM_SUPPORT
   if (MouseSupport == MOUSE_GPM)
	   mouse_gpm_drawpointer();
#endif

}


void launch_message(const char *message)
{   
    if (!MainWnd) return;
    
    show_status_message(message, -2);
    old_SuspendRefresh = SuspendRefresh;

    set_suspend_mode(-1);
    msg_remove_time = time(NULL) + 2;
}

void delaunch_message(void)
{
/*   
    if (MsgWnd)
    {   delwin(MsgWnd); 	
        MsgWnd = NULL;
    }

    redraw_screen();	    
*/    
    msg_remove_time = 0;
    set_suspend_mode(old_SuspendRefresh);
}


