#ifndef NCURSES_VERSION_MAJOR
#define NCURSES_VERSION_MAJOR  1
#endif

#define OBTURATE_MIN  0
#define OBTURATE_MAX  4

#ifndef HAVE_CONFIG_H
#include "sadp_gpm_support.h"
#endif

#ifndef BUTTON_CTRL
#define BUTTON_CTRL		000100000000L
#endif
#ifndef BUTTON_SHIFT
#define BUTTON_SHIFT		000200000000L
#endif
#ifndef BUTTON4_CLICKED
#define BUTTON4_CLICKED  000004000000L
#endif
#ifndef BUTTON4_RESERVED_EVENT
#define BUTTON4_RESERVED_EVENT 000040000000L
#endif
#ifndef BUTTON5_CLICKED
#define BUTTON5_CLICKED  001000000000L
#endif
#ifndef BUTTON5_RESERVED_EVENT
#define BUTTON5_RESERVED_EVENT 004000000000L
#endif

/* Screen function */
void init_spectrum_wnd(void);
void draw_header(void);

/* Help functions */
int   help_initialize(void);
int   help_activate(void);
void  help_accept_focus(void);
void  help_deactivate(void);
void  help_accept_section(short new_section);
void  help_deinitialize(void);
void help_redraw(void);

/* Data functions */
void  data_accept_section(short new_section);
void  data_set_browser(int brow, short value);
void  data_draw_fields(void);

int   show_help(void);
OPERATION help_getaction(int key);

int		CheckTTY(void);

typedef enum
 {  MOUSE_NONE, MOUSE_NATIVE, MOUSE_GPM, MOUSE_DEFAULT}
       MOUSE_SUPPORT_OPTION;

typedef enum
 {  HEADER_NONE, HEADER_DISC, HEADER_TRACK }
        HEADER_MODE;

/* Mouse control */
short get_mouse_event(void);

int mouse_gpm_initialize(void);
void mouse_gpm_deinitialize(void);
void mouse_gpm_drawpointer(void);
int gpm_getch(void);


/* General purpose routines */
int curs_yesno(const char *message);
void curs_message(int wid, int msgcount,  char *message, ...);
void load_settings(void);

#ifdef RCDDB_SUPPORT
/* -------------  R C D D B  ------------- */
void rcddb_curs_initialize(void);
void rcddb_curs_deinitialize(void);
void rcddb_activate(void);
void rcddb_deactivate(void);
void rcddb_accept_focus(void);
short rcddb_download_data(void);
void curs_submit_data(void);
OPERATION rcddb_getaction(int key);
#endif

#define DATA_FIRST_SECTION	2
#ifdef RCDDB_SUPPORT
#define DATA_SECTIONS		2
#define RCDDB_SECTION         (DATA_FIRST_SECTION + 1)
#else
#define DATA_SECTIONS		1
#endif
#define HELP_FIRST_SECTION	(DATA_FIRST_SECTION + DATA_SECTIONS)
#define HELP_SECTIONS		3
#define HELP_FIRST_NONSECTION	(HELP_FIRST_SECTION + HELP_SECTIONS)
#define BOTTOM_SECTIONS		HELP_FIRST_NONSECTION

