/*  ========================================================== 
    SING - ALONG DISK PLAYER.
    (C) 1998-1999, Michael Glickman. xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software.

            Author strongly advices against using this code, or
            a part of it, in an application designed to run  on
            any Microsoft(tm) platfrom.
    ========================================================= */
#include <curses.h>
#include <term.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "sad.h"
#include "sadp_curses.h"
#include "sadp_rcddb.h"

#if HAVE_LINUX_VT_H
#include <linux/vt.h>
#elif HAVE_SYS_VT_H
#include <sys/vt.h>
#endif

#define ctrl(x)   ((x) & 31)

extern short  FourWndCount;
extern int  MainWndHeight, MainWndLeft, MainWndTop, MainWndWidth;
extern int  FourWndHeight, FourWndWidth;

extern  int    ScreenW, ScreenH;
extern  short  BkgrColour;
extern  short  BtnDist, BtnWidth;
extern  short  HelpFocus, BottomSection;
extern  short  HeaderMode;      /* 1 - CD + Artist, 2 - Track name */
extern  short  SaveData;
extern  short  QuietMode;


extern  chtype btn_attr, bar_attr;
extern  chtype bkgr_attr, fill_attr, text_attr;

extern  chtype thumb_attr, suspend_attr, dimmed_attr;
extern  chtype side_attr, side_text_attr, side_dim_attr;
extern  chtype spectr1_attr, spectr2_attr, spectr3_attr;
extern  chtype header_attr, brow_attr, brow_hilite_attr;
extern  chtype help_attr, help_hdr_attr, help_title_attr;

extern  chtype cLeftArrow, cRightArrow,  cDownArrow, cUpArrow;
extern  chtype cLeftArrow1, cRightArrow1;
extern  chtype cBlock, cBar, cBullet, cBullet1, cCkboard, cDiamond;
extern  chtype cSpectBright, cSpectDim, cVolBright, cVolDim;
extern  chtype OperNotation[][3];
extern  PLAY_MODE_TYPE  PlayMode;

extern  char   TimeModeTxt[];
extern  char   AutoModeTxt[];
extern  char   PlayModeTxt[];
extern  char   LoopModeTxt[];

extern PREFSET_INFO  *cd_prefsets;
extern PREFSET_INFO  *cd_current_prefset;
extern short	cd_prefset_count;

extern  short  DataChanged;
extern  short  cd_multi_artist;
extern  short  cd_playlist_size;
extern  u_char *cd_playlist;
extern  short  cur_plist_size;
extern  short  cur_plist_pos;
extern  u_char *cur_plist;

extern  WINDOW *MainWnd;
extern  MEVENT  LastMouseEvent;

extern  char   **InfoPages;
extern  short  HelpLineCount, InfoLineCount, MiscLineCount;
extern  short  IsX, AreColours;
extern  int		 ttyno, termfd;

WINDOW *HelpWnd;
int    HelpWndWidth, HelpWndHeight, HelpWndLineWidth;
int    HelpWndLeft, HelpWndTop;
short  ArtistToggle, ExtraToggle;

static  short  HelpWndEffWidth, HelpWndEffHeight, HelpWndEffTop;
static  short  OldMainWndTop = -1;
static  short  PlayAdvance, HelpCurSect = -1, OldBarPos = -1;

static  short  PageWidth, EffPageWidth, LineCount, PageCount;
static  short  TotWidth, LogWidth, InsOvlX;
static  short  HelpBarTop, HelpBarLength, HelpBarLeft;
static  short  HelpPlayInd, HelpPlaybackInd;

static  int    HelpCurPos;
static  int    MainWndTop1;
static  struct timeval TimePlayStart;

extern  char   disc_name[], disc_artist[], disc_extra[];
extern  u_char track_first, track_last, track_cur;
extern  short  no_cd;

extern char    *HelpPages[], *MiscPages[];

static short   DataLineSize, ExtraLineSize, BrowHeight, BrowY, BrowWidth;
static short   DataHdrX, DataLineX, PsetLineWidth, PsetLineX, PsetLineY;
static short   DataScrollX1, DataScrollX2, DataStartY;
static u_short brow_cur_line[2], brow_top_line[2], brow_lines[2];
static short   data_change_prefset(short prefset_number);
static short   data_active_fld = -1, data_active_browser = 0;
static short   InsertMode = 0;
static short   DataFields = 4;
static OPERATION data_getaction(int key);
static short   InputPsetName;

#define HWND_HEIGHT 19
/* #define HWND_WIDTH  64 */

#define HELP_PLAY_TIMEOUT ((TIME_OUT_HELP_ADVANCE) * 1000)

#define DATA_MAX_FIELDS 5
#define HELP_BUTTONS   8
#define BOTTOM_BUTTONS 0

#define SHIFT_MODIFIER 0x4000
#define SHIFT_LEFT  (SHIFT_MODIFIER | KEY_LEFT)
#define SHIFT_RIGHT (SHIFT_MODIFIER | KEY_RIGHT)

/*
#define CTRL_MODIFIER 0x2000
#define CTRL_LEFT   (CTRL_MODIFIER | KEY_LEFT)
#define CTRL_RIGHT  (CTRL_MODIFIER | KEY_RIGHT)
*/

#define has_extra (DataFields >= DATA_MAX_FIELDS)

static struct HELP_SECTION_INFO
{       char   **source;
        char   *name;
        short  page_width;
        short  line_count;
        int    position;
} HelpSectionInfo[HELP_SECTIONS];

static struct DATA_FIELD_INFO
{       char   *name;
        char   *source;
        chtype attr;
        short  offset;
        short  pos;
        short  x, y;
	short  width;	/* Field width */
	short  ssize;   /* Size of source field, ex '\0' */
} DataFieldInfo[DATA_MAX_FIELDS];


static char  **DispPages;

/* Number of bottom buttons in data panel */
#ifdef RCDDB_SUPPORT
#define DATA_BOTTOM_BUTTONS 4
#else
#define DATA_BOTTOM_BUTTONS 2
#endif

/* Total number of buttons in data panel:
       bottom(2 or 4) + transfer (2)  */
#define DATA_BUTTONS (DATA_BOTTOM_BUTTONS + 4)

struct BTN_INFO
{
   short  y;
   short  x1, x2;
   short  oper;
   short  shortcut;
} HelpButtonInfo[HELP_BUTTONS+BOTTOM_BUTTONS],
  DataButtonInfo[DATA_BUTTONS+DATA_MAX_FIELDS];

enum DATA_BUTTON_COMMANDS
{  DATA_SAVE, DATA_RESTORE, DATA_DOWNLOAD, DATA_UPLOAD,
   DATA_ADDLIST, DATA_DELLIST, DATA_PREVSET, DATA_NEXTSET};

enum DATA_INPUT_FIELD
{   INPUT_TITLE, INPUT_ARTIST, INPUT_TRACK, INPUT_EXTRA, INPUT_PSET_NAME};

static const char *DataBtnNames[] =
        { "  Save  ", " Reload "
#ifdef RCDDB_SUPPORT
	, " DnLoad ", " UpLoad "
#endif
};

static const char DataBtnShortcut[] =
      {   'S', 'L'
#ifdef RCDDB_SUPPORT
        , 'D', 'U'
#endif
      };

static void activate_data_fld(short new_field);
static void mark_char(short fld_no, short active);
static void decorate_browser(short brow);
static void data_show_track_in_browser(short brow, short line);
static void draw_toggle_button(int btn_number);
static void show_data_browser(int brow);

static chtype  help_button_char(char *src, int off)
{       int buttonNo, i;
        chtype ret = ' ';

      if (*(src+off) == ' ') goto Uscita;

      buttonNo = atoi(src);
      switch(buttonNo)
      { case 0 ... CBUTTONS+HBUTTONS-1:
          ret = OperNotation[buttonNo][off] | btn_attr;
            break;

        case 40 ... 52:
           {  char *txtptr;

                i = buttonNo - 40;

              if (i<4) txtptr = TimeModeTxt;
              else
              if (i<6) { txtptr = AutoModeTxt; i -= 4; }
              else
	        if(i<11) { txtptr = PlayModeTxt; i -= 6; }
	        else     { txtptr = LoopModeTxt; i -= 11; }

              ret = *(txtptr + 3*i + off) | btn_attr;
           }
           break;

        case 70 ... 73:
           if (off==1)
                ret = OperNotation[OPER_STOP][buttonNo-70];
           ret |= btn_attr;
           break;

        case 75 ... 76:
           ret = OperNotation[buttonNo-75 + OPER_HELPPREV][off] | btn_attr;
           break;

	  case 77 ... 78:
           if (off==1)
              ret = OperNotation[OPER_PLAY][buttonNo-76];
           ret |= btn_attr;
	     break;

        case 80 ... 83:
        case 86 ... 89:
           i = buttonNo - 80;
           ret = ( (i==OPER_STOP && off != 1) ? ' '
                   : OperNotation[i][off] ) | side_attr;
	     break;
	
        case 84:
           if (off==1)
              ret = OperNotation[OPER_PLAY][2] | side_attr;
           ret |= side_attr;
	     break;

	  case 85: 
           if (off==1)
              ret = OperNotation[OPER_PLAYBACK][1] | side_attr;
           ret |= side_attr;

      }


  Uscita:
        return ret;
}


static void help_show_page(long start)
{
    int x, y, ind, off, pageno_pos;
    int offset, pageno;
    char *src, pagenotxt[5];
    chtype typ, attr;
    chtype sep = cBullet | side_text_attr;
    const char *specchr = "%-";
    const char titlechr = '#';

    wattrset(HelpWnd, side_text_attr);
    wmove(HelpWnd, HelpWndEffTop-2, 1);
    whline(HelpWnd, cBullet, HelpWndLineWidth);
    wmove(HelpWnd, HelpWndEffTop + HelpWndEffHeight+1, 1);
    whline(HelpWnd, cBullet, HelpWndLineWidth);

    wattrset(HelpWnd, text_attr);

    pageno = start / PageWidth;
    offset = start % PageWidth;
    start = HelpWndEffHeight * pageno;

    off= PageWidth-offset-3;
    if (off <0)
    { off += PageWidth; pageno++; }
    pageno_pos = off - PageWidth/2 + 2;

    x = 0;
    while(x < HelpWndLineWidth-2)
    {

        if (off > HelpWndLineWidth-2-x) off = HelpWndLineWidth-2-x;
        wmove(HelpWnd, HelpWndEffTop-1, x+3);
        whline(HelpWnd, ' ', off);
        wmove(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3);
        whline(HelpWnd, ' ', off);
        x +=  off;

        if (pageno_pos >= 2)
        {
           sprintf (pagenotxt, " %02d ", pageno+1);
           for (ind = 0; ind < 4; ind++)
           { y = pageno_pos+ind;
             if (y >= 3 && y <= HelpWndLineWidth)
             {
                 mvwaddch(HelpWnd, HelpWndEffTop-2, y,
                          pagenotxt[ind] | side_attr);

                 mvwaddch(HelpWnd, HelpWndEffTop+ HelpWndEffHeight+1, y,
                          pagenotxt[ind] | side_attr);
             }
           }
         }

         pageno = (pageno+1) % PageCount;
         pageno_pos += PageWidth;

         if (x < HelpWndEffWidth)
         {
               mvwaddch(HelpWnd, HelpWndEffTop-1, x+3, sep);
               mvwaddch(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3, sep);
               x++;
         }

         off= PageWidth-1;
   }

    for (y=0; y<HelpWndEffHeight; y++)
    {
         wmove(HelpWnd, y+HelpWndEffTop, 3);

         x = 0; ind = y+start, off = offset;
         src =  ind < LineCount ? DispPages[ind] : NULL;

         if (src && strchr(specchr, *src)) attr = help_hdr_attr;
	 else if (src && *src == titlechr) attr = help_title_attr;
			              else attr = help_attr;

         wattrset(HelpWnd, attr);

         while(x < HelpWndEffWidth)
         {
            if (off >= PageWidth)
            {   ind += HelpWndEffHeight;
                if ((ind - y) >= LineCount) ind = y;
                src = ind < LineCount ? DispPages[ind] : NULL;
                if (src && strchr(specchr, *src))
                                        attr = help_hdr_attr;
	        else if (src && *src == titlechr)
                                        attr = help_title_attr;
                                   else attr = help_attr;
                wattrset(HelpWnd, attr);
                off = 0;
            }

            if (off < EffPageWidth)
            {
                if (!src)
                    typ = ' ';
                else
                if (off==0 && (*src == '%' || *src == titlechr))
                    typ = ' ';
                else
                if (off<3 && isdigit(*src))
                    typ = help_button_char(src, off);
                else
                {   typ = *(src+off) & 0xff;
                    if (typ == '@') typ = cCkboard;
                }
             }
             else
               typ = (off-EffPageWidth) == 2 ? sep : ' ';

             waddch(HelpWnd, typ);
             off++; x++;
         }
    }

}

/*
static void help_show_page(long start)
{
    int x, y, ind, off, pageno_pos;
    int offset, pageno;
    char *src, pagenotxt[5];
    chtype typ;
    chtype sep = cBullet | side_text_attr;


    if (ScreenH < 28)
    { wattrset(HelpWnd, side_text_attr);
      wmove(HelpWnd, HelpWndEffTop-2, 1);
      whline(HelpWnd, cBullet, HelpWndLineWidth);
      wmove(HelpWnd, HelpWndEffTop + HelpWndEffHeight+1, 1);
      whline(HelpWnd, cBullet, HelpWndLineWidth);
    }

    wattrset(HelpWnd, text_attr);

    pageno = start / PageWidth;
    offset = start % PageWidth;
    start = HelpWndEffHeight * pageno;


    off= PageWidth-offset-3;
    if (off <0)
    { off += PageWidth; pageno++; }

    pageno_pos = off - PageWidth/2 + 2;


    x = 0;
    while(x < HelpWndLineWidth-2)
    {

        if (off > HelpWndLineWidth-2-x) off = HelpWndLineWidth-2-x;
        wmove(HelpWnd, HelpWndTop+3, x+3);
        whline(HelpWnd, ' ', off);
        wmove(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3);
        whline(HelpWnd, ' ', off);
        x +=  off;

        if (pageno_pos >= 2)
        {
           sprintf (pagenotxt, " %02d ", pageno+1);
           for (ind = 0; ind < 4; ind++)
           { y = pageno_pos+ind;
             if (y >= 3 && y <= HelpWndLineWidth)
             {
                 mvwaddch(HelpWnd, HelpWndEffTop-2, y,
                          pagenotxt[ind] | bar_attr);

                 mvwaddch(HelpWnd, HelpWndEffTop+ HelpWndEffHeight+1, y,
                          pagenotxt[ind] | bar_attr);
             }
           }
        }

          pageno = (pageno+1) % PageCount;
        pageno_pos += PageWidth;

          if (x < HelpWndEffWidth)
        {
               mvwaddch(HelpWnd, HelpWndEffTop-1, x+3, sep);
               mvwaddch(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3, sep);
                 x++;
        }

          off= PageWidth-1;
   }

    for (y=0; y<HelpWndEffHeight; y++)
    {
         wmove(HelpWnd, y+HelpWndEffTop, 3);

       x = 0; ind = y+start, off = offset;
         src =  ind < LineCount ? DispPages[ind] : NULL;


       while(x < HelpWndEffWidth)
       {
          if (off >= PageWidth)
          {  ind += HelpWndEffHeight;
                 if ((ind - y) >= LineCount) ind = y;
                 src = ind < LineCount ? DispPages[ind] : NULL;
             off = 0;
            }

            if (off < EffPageWidth)
            {
             if (off<3 && src && isdigit(*src))
                typ = help_button_char(src, off);
                 else
                 {   typ = src ? *(src+off) : ' ';
                 if (typ == '@') typ = cBlock;
             }
          }
          else
                typ = (off-EffPageWidth) == 2 ? sep : ' ';

          waddch(HelpWnd, typ);
          off++;
            x++;
       }
    }

}
*/

static void help_show_buttons(void)
{  int i, l, x, l1;
   OPERATION oper;
   struct BTN_INFO *bi;


   wattrset(HelpWnd, side_attr);
   for (i=0; i< (HELP_BUTTONS+BOTTOM_BUTTONS); i++)
   {  bi = (HelpButtonInfo + i);
      oper = bi->oper;

      x = bi->x1;

      l = bi->x2 - x + 1;
      l1 = (l & 1) ? 3 : 2;
      l = (l-l1) >> 1;

      wmove(HelpWnd, bi->y, x);

      for (x=0; x < l; x++) waddch(HelpWnd, ' ');

	if (oper == OPER_PLAY)
	    for (x=0; x<l1; x++)
		    waddch(HelpWnd, x==1 ? OperNotation[oper][2] : ' ');
	else
	      for(x=0; x<l1; x++) waddch(HelpWnd, OperNotation[oper][x]);

      for (x=0; x < l; x++) waddch(HelpWnd, ' ');

   }

}

static void help_arrange_buttons(void)
{
    int x, y;
//    int dist, wid;
    int AfterBar;
    int i;

    i = 0;
    y = HelpBarTop;
    x = 3;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PREV5;
    x += BtnDist;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_PREV;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_BACK;
    x +=  BtnDist-1;

    HelpPlaybackInd = i;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PLAYBACK;
    x +=  BtnDist;

    HelpBarLeft = x;
    wattrset(HelpWnd, bar_attr);
    wmove(HelpWnd, y, x);
    whline(HelpWnd, cBullet, HelpBarLength);
    x += HelpBarLength+1;

    HelpPlayInd = i;
    AfterBar = x;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PLAY;
    x +=  BtnDist;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_FWD;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_NEXT;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_NEXT5;

/*
    y += 2;
    x = 3;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_HELPPREV;


    x +=  2*BtnDist;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_INFO;


    x = HelpWndEffWidth +2 - 2*BtnWidth;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_HELPNEXT;
*/
}


static void draw_help_board(void)
{
    wbkgdset(HelpWnd, bkgr_attr);

    wattrset(HelpWnd, fill_attr);
    wclear(HelpWnd);

    wmove(HelpWnd, 0, 0);
    wvline(HelpWnd, cCkboard, HelpWndHeight-1);
    wmove(HelpWnd, HelpWndHeight-1, 0);
    whline(HelpWnd, cCkboard, HelpWndWidth);
    wmove(HelpWnd, 0, HelpWndWidth-1);
    wvline(HelpWnd, cCkboard, HelpWndHeight-1);

}

static void  help_position(int newpos)
{   int x;

    if (HelpWnd == NULL) return;

    if (OldBarPos >=0)
    {   wattrset(HelpWnd, bar_attr);
        wmove(HelpWnd, HelpBarTop, HelpBarLeft + OldBarPos);
        waddch(HelpWnd, cBullet);
    }

    HelpCurPos = newpos;
    help_show_page(HelpCurPos);

    x =  (HelpBarLength *  HelpCurPos) / LogWidth;
    if (x >=HelpBarLength) x = HelpBarLength-1;
    wattrset(HelpWnd, HelpFocus ? thumb_attr : bar_attr);
    wmove(HelpWnd, HelpBarTop, HelpBarLeft + x);
    waddch(HelpWnd, cBlock);
    OldBarPos = x;

    wrefresh(HelpWnd);

}

static void  help_show_sect_header(void)
{    char *header = HelpSectionInfo[HelpCurSect].name;
     int x = (HelpWndWidth - 8) >> 1;
     int y = HelpWndHeight-1;

     wattrset(HelpWnd, fill_attr);
     wmove(HelpWnd, y, x);
     whline(HelpWnd, cCkboard, 8);
     x += (6-strlen(header))>>1;
     wmove(HelpWnd, y, x);
     wattrset(HelpWnd, bar_attr);
     wprintw (HelpWnd, " %s ", header);
}

void  help_accept_section(short new_section)
{
     if (HelpCurSect >= 0)
            HelpSectionInfo[HelpCurSect].position = HelpCurPos;

     HelpCurSect = new_section;

     draw_help_board();

     DispPages = HelpSectionInfo[HelpCurSect].source;
     EffPageWidth = HelpSectionInfo[HelpCurSect].page_width;
     LineCount = HelpSectionInfo[HelpCurSect].line_count;
     HelpCurPos = HelpSectionInfo[HelpCurSect].position;

     PageWidth = EffPageWidth + 5;
     PageCount = LineCount / HelpWndEffHeight;
     if (LineCount % HelpWndEffHeight) PageCount++;
     TotWidth = PageWidth * PageCount;
     if (TotWidth <= HelpWndLineWidth) LogWidth = TotWidth;
     else    LogWidth = TotWidth - HelpWndEffWidth - 3;


     /* Draw buttons */
     help_arrange_buttons();
     help_show_buttons();

     if (new_section == 1) update_info_page();


     help_show_sect_header();
     HelpFocus = 1;
     accept_focus();
//     help_position(HelpCurPos);


}

void  help_accept_focus(void)
{
   	if (BottomSection >= HELP_FIRST_SECTION)
      {   help_position(HelpCurPos);
            return;
      }    

#ifdef RCDDB_SUPPORT
     if (BottomSection == RCDDB_SECTION)
     {  rcddb_accept_focus();
        return;
     }
#endif
     
      if (HelpFocus && data_active_fld < 0)
                             data_active_fld = 0;

      decorate_browser(0);
      decorate_browser(1);

      if (data_active_fld >= 0)
               mark_char(data_active_fld, HelpFocus);

      if (!HelpFocus)
      {  if (no_cd == 0 && track_cur != 0xff)
             data_set_browser(0, track_cur - track_first);

         if (PlayMode == PLAY_LIST)
             data_set_browser(1, cur_plist_pos);
      }

	show_data_browser(0);
	show_data_browser(1);
      wrefresh(HelpWnd);
}

int help_initialize(void)
{   short y;
	
    if (FourWndCount == 0)
    {
       MainWndTop1 = ScreenH /16-1;
         HelpWndHeight = ScreenH - 2*MainWndTop1  - MainWndHeight;
    }
    else
    {
       MainWndTop1 = MainWndTop;
       HelpWndHeight = FourWndHeight*FourWndCount;
    }

    HelpBarTop = HelpWndHeight - 3;
    HelpWndTop =  MainWndTop1 + MainWndHeight;
    HelpWndWidth = MainWndWidth;
    HelpWndLeft =  MainWndLeft;  // (ScreenW - HelpWndWidth) >> 1;

    HelpWndLineWidth = HelpWndWidth-2;
    HelpWndEffWidth = HelpWndWidth-6;
    HelpWndEffHeight = HelpWndHeight-8;
    HelpWndEffTop = 2;

    HelpBarLength = HelpWndWidth - BtnDist*(HELP_BUTTONS-2) - BtnWidth*2 - 6;

    prepare_info_page();

    HelpSectionInfo[0].source = HelpPages;
    HelpSectionInfo[0].page_width = strlen(HelpPages[0]);
    HelpSectionInfo[0].line_count = HelpLineCount;
    HelpSectionInfo[0].name  = " Help ";
    HelpSectionInfo[0].position  = 0;

    HelpSectionInfo[1].source = InfoPages;
    HelpSectionInfo[1].page_width = INFO_LINE_SIZE;
    HelpSectionInfo[1].line_count = InfoLineCount;
    HelpSectionInfo[1].name  = "Status";
    HelpSectionInfo[1].position  = 0;

    HelpSectionInfo[2].source = MiscPages;
    HelpSectionInfo[2].page_width = 33;
    HelpSectionInfo[2].line_count = MiscLineCount;
    HelpSectionInfo[2].name  = " Misc ";
    HelpSectionInfo[2].position  = 0;

/* ======================================================= */

    DataFields = DATA_MAX_FIELDS;
    if (ScreenH < 28) DataFields--;		
    DataStartY = (ScreenH < 40) ? 0 : 1;

    ExtraLineSize = DataLineSize = HelpWndWidth - 17;
    if (has_extra)
    {  if(ExtraLineSize > (EXTRA_NAME_SIZE-1))
		DataLineSize = ExtraLineSize = (EXTRA_NAME_SIZE-1);
    }	
    else	
    {	 if (DataLineSize > (DATA_NAME_SIZE-1))
	      DataLineSize = (DATA_NAME_SIZE-1);
    }	
    BrowWidth  = (HelpWndWidth - 1)>>1;
	
/*    BrowWidth  = HelpWndWidth - 2; */
    BrowY = DataFields * 2 + DataStartY*2 - 1;
    BrowHeight = HelpWndHeight - BrowY - 2;
    DataHdrX   = ((HelpWndWidth - DataLineSize-8) >> 1) - 2;
    if (has_extra)
    {	  DataLineX   = ((HelpWndWidth - ExtraLineSize-8) >> 1) - 2;
        if (DataLineX < DataHdrX) DataHdrX = DataLineX;
    }
    DataLineX  = (DataHdrX + 8);

    PsetLineX = DataLineX + 10;
    PsetLineWidth = DataLineSize - 10;
/*    if (PsetLineWidth > (PREFSET_NAME_SIZE-1))
                   PsetLineWidth = PREFSET_NAME_SIZE-1; */

#ifdef RCDDB_SUPPORT
    InsOvlX =   BrowWidth - 2; 
#else
    InsOvlX =   BrowWidth + 6; 
#endif
    DataScrollX1 = 4;
    DataScrollX2 = BrowWidth - 4;
    if (DataLineSize & 1) DataLineX--;

    ArtistToggle = 0;
    ExtraToggle = 0;

   
    y = DataStartY;
 		
    DataFieldInfo[INPUT_TITLE].name  = "TITLE:";
    DataFieldInfo[INPUT_TITLE].source  = disc_name;
    DataFieldInfo[INPUT_TITLE].attr  =  bar_attr;
    DataFieldInfo[INPUT_TITLE].offset  = 0;
    DataFieldInfo[INPUT_TITLE].pos  = 0;
    DataFieldInfo[INPUT_TITLE].y  = y;
    y += 2;

    DataFieldInfo[INPUT_ARTIST].name  = "ARTIST:";
    DataFieldInfo[INPUT_ARTIST].source  = disc_artist;
    DataFieldInfo[INPUT_ARTIST].attr  = ArtistToggle ? side_attr : bar_attr;
    DataFieldInfo[INPUT_ARTIST].offset  = 0;
    DataFieldInfo[INPUT_ARTIST].pos  = 0;
    DataFieldInfo[INPUT_ARTIST].y  = y;
    y += 2;

    DataFieldInfo[INPUT_TRACK].name  = "TRACK:";
    DataFieldInfo[INPUT_TRACK].source  = NULL;
    DataFieldInfo[INPUT_TRACK].attr  =  side_attr;
    DataFieldInfo[INPUT_TRACK].offset  = 0;
    DataFieldInfo[INPUT_TRACK].pos  = 0;
    DataFieldInfo[INPUT_TRACK].y  = y;
    y += 2;

    InputPsetName = INPUT_EXTRA;	
    if (has_extra)
    {		
	DataFieldInfo[INPUT_EXTRA].name  = "EXTRA:";
	DataFieldInfo[INPUT_EXTRA].source  = disc_extra;
	DataFieldInfo[INPUT_EXTRA].attr  = ExtraToggle ? side_attr : bar_attr;
	DataFieldInfo[INPUT_EXTRA].offset  = 0;
	DataFieldInfo[INPUT_EXTRA].pos  = 0;
	DataFieldInfo[INPUT_EXTRA].x  = DataLineX;
	DataFieldInfo[INPUT_EXTRA].y  = y;
	DataFieldInfo[INPUT_EXTRA].width = ExtraLineSize;
	DataFieldInfo[INPUT_EXTRA].ssize = EXTRA_NAME_SIZE-1;
	InputPsetName = INPUT_PSET_NAME;
	y += 2;	
    } 


    DataFieldInfo[InputPsetName].name = "PREFERENCE SET:";
    DataFieldInfo[InputPsetName].source  = NULL;
    DataFieldInfo[InputPsetName].attr  = bar_attr;
    DataFieldInfo[InputPsetName].offset  = 0;
    DataFieldInfo[InputPsetName].pos  = 0;
    DataFieldInfo[InputPsetName].y  = y;
    DataFieldInfo[InputPsetName].x  = PsetLineX;
    DataFieldInfo[InputPsetName].width = PsetLineWidth;
    DataFieldInfo[InputPsetName].ssize = PREFSET_NAME_SIZE-1;
    PsetLineY = y;
	

/*    for (y=0; y<InputPsetName; y++) */
    for (y=0; y<INPUT_EXTRA; y++) 
    {   
	DataFieldInfo[y].x  = DataLineX;
	DataFieldInfo[y].width = DataLineSize;
	DataFieldInfo[y].ssize = DATA_NAME_SIZE-1;
    }	

    data_active_fld = -1;
    return 1;
}


int help_activate(void)
{

    if (FourWndCount == 0)
    {  OldMainWndTop = MainWndTop;
       MainWndTop = MainWndTop1;
       mvwin(MainWnd, MainWndTop, MainWndLeft);
    }


    set_suspend_mode(0);

    HelpWnd = newwin(HelpWndHeight, HelpWndWidth, HelpWndTop, HelpWndLeft);
    if (!HelpWnd) return 0;
    
    audio_stop();

    PlayAdvance = 0;

    return 1;
}

void  help_deactivate(void)
{

    delwin(HelpWnd);
    HelpWnd = NULL;

    HelpFocus = 0;

    accept_focus();


#ifdef DSP_SUPPORT
    if (FourWndCount == 0)
    {
#endif
        if (OldMainWndTop >=0)
        {  MainWndTop = OldMainWndTop;
           mvwin(MainWnd, MainWndTop, MainWndLeft);
           redraw_screen();
        }
#ifdef DSP_SUPPORT
    }
    else
        init_spectrum_wnd();
#endif

    audio_reinitialize();
}

void  help_deinitialize(void)
{
    release_info_page();
}

static void  help_advance(int offset)
{
    int newpos = HelpCurPos + offset;
    if (newpos >= TotWidth) newpos -= TotWidth;
    if (newpos < 0) newpos += TotWidth;
    help_position(newpos);
}

static void  help_gotoend(void)
{  int newpos = TotWidth-HelpWndEffWidth-4;
   if (newpos <0) newpos =0;
    help_position(newpos);
}

void  help_stopplay(void)
{
    struct BTN_INFO *bi;
    int  ind, x, y;
    chtype symbol;	

    if (PlayAdvance == 0) return;

    if (PlayAdvance > 0)
    { ind = HelpPlayInd;
      symbol = OperNotation[OPER_PLAY][2];
    }
    else
    { ind = HelpPlaybackInd;
      symbol = OperNotation[OPER_PLAYBACK][1];
    }

    bi = (HelpButtonInfo + ind);
    x = (bi->x1+bi->x2+1)>>1; y= bi->y;

    PlayAdvance = 0;
    wmove(HelpWnd, y, x);
    wattrset(HelpWnd, side_attr);
    waddch(HelpWnd, symbol | side_attr);
    wrefresh(HelpWnd);	
}


static void  help_startplay(OPERATION oper,  short new_advance, short ind, short alt_ind )
 {
      int x, y;
        struct BTN_INFO *bi;

      bi = (HelpButtonInfo + ind);
      x = (bi->x1+bi->x2+1)>>1; y= bi->y;

      wattrset(HelpWnd, side_attr);

      if (PlayAdvance == new_advance)
      {   PlayAdvance = 0;
          wmove(HelpWnd, y, x);
          wattrset(HelpWnd, side_attr);
          waddch(HelpWnd, OperNotation[oper][oper==OPER_PLAY ? 2 : 1] | side_attr);
      }
      else
      {

          wmove(HelpWnd, y, x);

          wattrset(HelpWnd, thumb_attr);
          waddch(HelpWnd, OperNotation[OPER_STOP][1] | thumb_attr);

          if (PlayAdvance != 0)   /* Sorry for redundant repetition */
          {    oper = (OPER_PLAY + OPER_PLAYBACK) - oper;
               bi = (HelpButtonInfo + alt_ind);
               x = (bi->x1+bi->x2+1)>>1; y= bi->y;
               wmove(HelpWnd, y, x);
	         wattrset(HelpWnd, side_attr);
               waddch(HelpWnd, OperNotation[oper][oper==OPER_PLAY ? 2 : 1] | side_attr);
          }

          PlayAdvance = new_advance;
            gettimeofday(&TimePlayStart, NULL);
      }

      wrefresh(HelpWnd);
}



static OPERATION help_mouse_command(void)
{

     if ( (LastMouseEvent.bstate & BUTTON1_CLICKED) ||
          (LastMouseEvent.bstate & BUTTON2_CLICKED) ||
          (LastMouseEvent.bstate & BUTTON3_CLICKED) )
     {   int x, y, i;
         struct BTN_INFO *bi;
         x = LastMouseEvent.x - HelpWndLeft - 1;
         y = LastMouseEvent.y - HelpWndTop - 1;

           if (y!= HelpBarTop) goto AnalButtons;

         i = x - HelpBarLeft;

         if (i>=0 && i < HelpBarLength)
           {

              i = i * LogWidth / (HelpBarLength-1);
              if (i >= LogWidth) i = LogWidth;
            help_position(i);


                PlayAdvance = 0;
            return OPER_NONE;
         }


AnalButtons:
           for (i=0; i< HELP_BUTTONS+BOTTOM_BUTTONS; i++)
         { bi = HelpButtonInfo + i;

           if (y == bi->y && x >= bi->x1 && x<= bi->x2)
                 return bi->oper;
         }

      }

        return OPER_NONE;

}


OPERATION help_getaction(int key)
{

     OPERATION oper = OPER_NONE;
     struct OPER_KEYS
     { int key1; int key2; OPERATION oper; }

     keysOper[] = {{KEY_RIGHT, '6',   OPER_FWD},
                   {KEY_LEFT,  '4',   OPER_BACK},
                   {KEY_UP,    '8',   OPER_PREV},
                   {KEY_DOWN,  '2',   OPER_NEXT},
                   {KEY_B2,    '5',   OPER_STOP},
                   {KEY_IC,    '0',   OPER_STOP},
                   {KEY_HOME,  '7',   OPER_PREV5},
                   {KEY_END,   '1',   OPER_NEXT5},
                   {KEY_BACKSPACE,  '\0',   OPER_PLAYBACK},
                   { ' ',      '\0',  OPER_PLAY},
                   {KEY_PPAGE,  '9',  OPER_HELPPREV},
                   {KEY_NPAGE,  '3',  OPER_HELPNEXT}
/*                   { '?',       '\0',  OPER_QUIT}  */
                  };

    if (BottomSection == DATA_FIRST_SECTION)
                return  data_getaction(key);
#ifdef RCDDB_SUPPORT                
    if (BottomSection == RCDDB_SECTION)
                return  rcddb_getaction(key);
#endif
    if (key == ERR) goto Fine;

    if (key==9)
    {  HelpFocus ^= 1;
       accept_focus();
       oper =OPER_SPECIAL;
       goto Fine;
    }

    if (key == KEY_MOUSE)
           oper = help_mouse_command();
    else
    if (HelpFocus)
    {   int  count = sizeof(keysOper)/sizeof(struct OPER_KEYS);
        struct OPER_KEYS *keysOperPtr = keysOper;
        while (--count>=0)
        { if(keysOperPtr->key1 == key || keysOperPtr->key2 == key)
          { oper = keysOperPtr->oper;
/*          if ((oper == OPER_PLAY) && PlayAdvance) oper = OPER_STOP; */
            break;
          }
          keysOperPtr++;
        }
    }

    switch(oper)
    {
/*
        case OPER_QUIT:
          case OPER_HELP:
              help_deactivate();
            break;
*/
        case OPER_FWD:
                /* PlayAdvance = 0; */
                help_advance(1);
            break;

        case OPER_BACK:
  		    /* PlayAdvance = 0; */
                help_advance(-1);
            break;

        case OPER_NEXT:
                /* PlayAdvance = 0; */
                help_advance(PageWidth);
            break;

        case OPER_PREV:
                /* PlayAdvance = 0; */
                help_advance(-PageWidth);
            break;

        case OPER_NEXT5:
                /* PlayAdvance = 0; */
                help_gotoend();
            break;

        case OPER_PREV5:
                /* PlayAdvance = 0; */
                help_position(0);
            break;

        case OPER_PLAY:
                help_startplay(oper,  1, HelpPlayInd, HelpPlaybackInd);
                break;

        case OPER_PLAYBACK:
                help_startplay(oper,  -1, HelpPlaybackInd, HelpPlayInd);
                break;

        case OPER_STOP:
                help_stopplay();
                break;

        case OPER_HELPNEXT:
                help_accept_section((HelpCurSect + 1) % HELP_SECTIONS);
                break;

        case OPER_HELPPREV:
                help_accept_section((HelpCurSect + HELP_SECTIONS - 1 ) % HELP_SECTIONS);
                break;

        default:
                oper = OPER_NONE;
    }

 Fine:
    if (PlayAdvance != 0)
    {  struct timeval TimeNew;

       gettimeofday(&TimeNew, NULL);

       if (time_diff(TimeNew, TimePlayStart) > HELP_PLAY_TIMEOUT)
       {   help_advance(PlayAdvance);
           TimePlayStart.tv_sec = TimeNew.tv_sec;
           TimePlayStart.tv_usec = TimeNew.tv_usec;
       }
    }

    if (HelpCurSect == 1) update_info_page();

    if (FourWndCount > 0)
            usleep((HELP_PLAY_TIMEOUT)/4);  /* Prevents a noise from speakers,
                                                 due to intensive CPU use */

    if (oper != OPER_NONE) oper = OPER_SPECIAL;
    return oper;

}

void help_redraw(void)
{  clear();
   refresh();
   touchwin(MainWnd);
   wnoutrefresh(MainWnd);
   touchwin(HelpWnd);
   wnoutrefresh(HelpWnd);
   doupdate();
}

static u_short get_track_no(short brow, short line)
{
     if (line >= brow_lines[brow]) return track_last+1;
     return  brow ? cd_playlist[line] : track_first + line;
}

static void show_data_browser_line(u_short line, short x,
                                   int count, char *txts[], chtype attrs[])
{
     int w, i;
     char c, *text;
     chtype attr;		

     w = BrowWidth-3;
     wmove(HelpWnd, line+BrowY+1, x);

     for(i=0; i<count && w>0; i++)
     {  text = txts[i];
	  attr = attrs[i];
        wattrset(HelpWnd,  attr);

	  while(w > 0 && (c=*text++) != '\0')  
	  {   waddch(HelpWnd, (chtype)c | attr);      
            w--;
        }

	  if (w > 0)
	  {   waddch(HelpWnd, (chtype)' ');
	      w--;
	  }
     }	

     wattrset(HelpWnd,  text_attr);
     while(w > 0)
     {  waddch(HelpWnd, (chtype)' ' | text_attr);      
        w--;
     }

}


static void data_show_track_in_browser(short brow, short line)
{
     short   top_line, line_count;
     chtype  attrs[4];
     char    *txts[4];
     int     count;	
     int     x = 2;


     if (brow) x += BrowWidth;

     top_line = brow_top_line[brow];
     line_count = brow_lines[brow];

     if (line < top_line || line >= top_line + BrowHeight) return;

     count = 0;

     if (brow &&  line == line_count-1)
     {   if (no_cd == 0)
	   {	count = 1;
	      attrs[0] = (line == brow_cur_line[brow]) ? brow_attr : fill_attr;
	      txts[0] = "   *** End of list ***";
	   }
     }	
     else
     if (line < line_count)
     {
	   u_short track_no;
	   char trk_no_text[4];
	   chtype h_attr;

	   if (!HelpFocus || data_active_browser != brow)
	       h_attr = (line == brow_cur_line[brow]) ? brow_attr : fill_attr;
	   else
#if NCURSES_VERSION_MAJOR > 3
	   h_attr = (line == brow_cur_line[brow]) ? brow_hilite_attr : -1;
#else	
           h_attr = (line == brow_cur_line[brow]) ? brow_hilite_attr : fill_attr;
#endif
	   track_no = get_track_no(brow, line);
	   sprintf(trk_no_text, "%2u", track_no);

	   txts[0] = trk_no_text;
#if NCURSES_VERSION_MAJOR > 3
	   attrs[0] = h_attr == -1 ? help_title_attr : h_attr;
#else
	   attrs[0] = cdaudio_get_track_skip(track_no) ? fill_attr : text_attr;
#endif	
	   count = 2;


	   if (cd_multi_artist)
	   {  char *artist =cdaudio_get_track_artist(track_no);
		trim(artist);
		if (strlen(artist) > 0)
		{	
			count=4;
			txts[1] = artist;
			attrs[1] =  h_attr == -1 ? help_hdr_attr : h_attr ;
			txts[2] = "-";
			attrs[2] =  h_attr == -1 ? fill_attr : h_attr ;
		}
	   }
	   	
	   txts[count-1] = cdaudio_get_track_name(track_no);

#if NCURSES_VERSION_MAJOR > 3
	   attrs[count-1] =  h_attr == -1 ? 
              (cdaudio_get_track_skip(track_no) ? fill_attr : text_attr)
				   : h_attr;
#else
	   attrs[count-1] =  h_attr;
#endif

     } 

     show_data_browser_line(line-top_line, x, count, txts, attrs);
}

void  data_update_playlist_names(void)
{
	int track_no;
	int i;

	track_no = get_track_no(0, brow_cur_line[0]);

	for (i=0; i< cd_playlist_size; i++)
	{  if (cd_playlist[i] == track_no)
		 data_show_track_in_browser(1, i);
	}
	
}

static void align_brow_top(short brow)
{
     short  line = brow_cur_line[brow];

     if (line < brow_top_line[brow])
                brow_top_line[brow] = line;
     else
     if (line >= brow_top_line[brow] + BrowHeight)
                brow_top_line[brow] = line - BrowHeight+1;

}

static void show_data_browser(int brow)
{
     short i, top_line;

     top_line = brow_top_line[brow];

     for (i=0; i<BrowHeight; i++)
        data_show_track_in_browser(brow, i+top_line);
}


static void data_insert_plist_line(void)
{
    int pos, prefset_no;

    pos = brow_cur_line[1];

    if (!cd_insert_playlist_line(pos,
                    get_track_no(0, brow_cur_line[0])))
			  return;	

    brow_lines[1] = cd_playlist_size+1;

    prefset_no = cd_current_prefset - cd_prefsets;
    if (prefset_no == cd_prefset_count - 1)
	          cd_create_prefset(NULL);

    if (HelpFocus) data_set_browser(1, pos+1);
    show_data_browser(1);
    wrefresh(HelpWnd);

    DataChanged = 1;

    if (PlayMode == PLAY_LIST)
    {   cur_plist_size = cd_playlist_size;
        cur_plist = cd_playlist;
        /* No need top set position! */
    }

}

static void data_delete_plist_line(void)
{
    short pos;

    pos = brow_cur_line[1];

    if (!cd_delete_playlist_line(pos))
			  return;	

	
    if (HelpFocus && pos < cd_playlist_size)
    { short track_no = get_track_no(1, pos);
      data_set_browser(0, track_no-track_first);
    }

    /* No need to realloc */
    brow_lines[1] = cd_playlist_size+1;
    show_data_browser(1);
    wrefresh(HelpWnd);

    DataChanged = 1;

    if (PlayMode == PLAY_LIST)
    {   cur_plist_size = cd_playlist_size;
   /*     cur_plist = cd_playlist; */
        /* No need top set position! */
    }

}

static void show_padded_line(char *text, chtype attr, short width)
{
        int  len, count;

        len = text ? strlen(text) : 0;
        if (len > width) len = width;

        count = len;
        while (--count >= 0) waddch(HelpWnd, *text++ | attr);

        count = width - len;
        while (--count >= 0) waddch(HelpWnd, (chtype)' ' | attr);

}

static void data_draw_single_field(short i)
{
        short  y = DataFieldInfo[i].y;
        short  x = DataFieldInfo[i].x;
        short  w = DataFieldInfo[i].width;
        chtype attr = DataFieldInfo[i].attr;
        short  off  = DataFieldInfo[i].offset;

	if (!AreColours ) attr &= ~A_BOLD;
        wmove(HelpWnd, y, x);
        wattrset(HelpWnd, attr);
        show_padded_line(DataFieldInfo[i].source+off, attr, w);

}

static void data_set_source(short i, short track_no)
{
	int len;
	char *src;

	switch(i)
	{
		case INPUT_TITLE:
		   src = disc_name;
		   break;

		case INPUT_ARTIST:
		   if (ArtistToggle)
		   { src = cdaudio_get_track_artist(track_no);
		     DataFieldInfo[INPUT_ARTIST].attr = side_attr;
               }	
		   else
		   { src = disc_artist;
		     DataFieldInfo[INPUT_ARTIST].attr = bar_attr;
               }	
		   break;

		case INPUT_TRACK:
               src = cdaudio_get_track_name(track_no);
		   DataFieldInfo[INPUT_TRACK].attr =
                     cdaudio_get_track_skip(track_no) ? side_attr : side_dim_attr; 		   
		   break;

		default:  
		   if (i == InputPsetName)
		      src = cd_current_prefset->name;

		   else	         /* case INPUT_EXTRA: */
		   if (ExtraToggle)
		   { src = cdaudio_get_track_extra(track_no);
		      DataFieldInfo[INPUT_EXTRA].attr = side_attr;
                   }	
		   else
		   { src = disc_extra;
		     DataFieldInfo[INPUT_EXTRA].attr = bar_attr;
               }	

       }; /* switch */	

	DataFieldInfo[i].source = src;
	len  = strlen(src);
	if (DataFieldInfo[i].pos > len)
		          DataFieldInfo[i].pos = len;
	data_draw_single_field(i);
      if (data_active_fld == i)
               mark_char(data_active_fld, i);

	wrefresh(HelpWnd);
}

static void show_current_prefset(void)
{ 
	char prefset_no_txt[3];

	if (no_cd || cd_current_prefset == NULL)
	{  strcpy(prefset_no_txt, "  ");
         DataFieldInfo[InputPsetName].source = "";
	}
	else
	{  int  prefset_no =(cd_current_prefset - cd_prefsets) + 1;	  
	   sprintf(prefset_no_txt, "%02d", prefset_no);
         DataFieldInfo[InputPsetName].source = cd_current_prefset->name;
	}

      data_draw_single_field(InputPsetName);

	wmove(HelpWnd, PsetLineY, PsetLineX+PsetLineWidth+2);
	wattrset(HelpWnd, bar_attr);
	waddch(HelpWnd, prefset_no_txt[0] | bar_attr);	
	waddch(HelpWnd, prefset_no_txt[1] | bar_attr);	
}

static void data_draw_info(void)
{       short i;
        static short dumb;

        brow_cur_line[0] = track_cur - track_first;
        brow_cur_line[1] =
            (PlayMode == PLAY_LIST) ? cur_plist_pos : 0;

        dumb = no_cd || track_cur > track_last;

        if (dumb)
        {   brow_lines[0] = 0;
            brow_lines[1] = 1;
        }
        else
        {   brow_lines[0] = track_last - track_first + 1;
            brow_lines[1] = cd_playlist_size+1;
        }

        DataFieldInfo[INPUT_ARTIST].source =
             ArtistToggle ? ( dumb ? "" : cdaudio_get_track_artist(track_cur))
                         :  disc_artist;

        DataFieldInfo[INPUT_TRACK].source = dumb ? ""
                        : cdaudio_get_track_name(track_cur);

	  if (has_extra)
             DataFieldInfo[INPUT_EXTRA].source =
                 ExtraToggle ? ( dumb ? "" : cdaudio_get_track_extra(track_cur))
                             :  disc_extra;

        for (i=0; i<InputPsetName; i++)
        {   if (dumb)
			DataFieldInfo[i].offset =
 			DataFieldInfo[i].pos = 0;
		data_draw_single_field(i);
		draw_toggle_button(i);
        }
	  show_current_prefset();


        for (i=0; i<2; i++)
        {  align_brow_top(i);
           show_data_browser(i);
        }
	
}

void data_draw_fields(void)
{

/*      data_track = track_cur; */


      data_draw_info();
      if(!no_cd) mark_char(data_active_fld, 1);
      wrefresh(HelpWnd);
}

static void data_draw_insert(void)
{
        char *text = InsertMode ? " Ins " : " Ovl ";

        wmove(HelpWnd, HelpWndHeight-1, InsOvlX);
        wattrset(HelpWnd, fill_attr);
        waddstr(HelpWnd, text);

}

static void decorate_browser(short brow)
{       int x, x1;
        static char *brow_names[] = {" Tracks ", " Play List "}; 
        char *name;
        chtype attr;

        x = brow ? BrowWidth : 0;
        attr = side_text_attr;
        if (HelpFocus && brow == data_active_browser)
                         attr = side_attr;

//	if (brow == 0 || no_cd)
	{  name = brow_names[brow];
	   wattrset(HelpWnd, attr);
	   x1 = x + 1 + ((BrowWidth - strlen(name)) >> 1);
	   mvwaddstr(HelpWnd, BrowY, x1, name);
	}
//	else
//	{  DataFieldInfo[InputPsetName].attr = attr;
//	   data_draw_single_field(InputPsetName);
//	}


        wattrset(HelpWnd, btn_attr);
        x1 = x + DataScrollX1;
        mvwaddch(HelpWnd, BrowY, x1, cUpArrow);
        mvwaddch(HelpWnd, HelpWndHeight-1, x1, cDownArrow);

        x1 = x + DataScrollX2;
        mvwaddch(HelpWnd, BrowY, x1, cUpArrow);
        mvwaddch(HelpWnd, HelpWndHeight-1, x1, cDownArrow);
}

static void draw_toggle_button(int btn_number)
{
   	struct BTN_INFO *bi;
        const  char *text;
        char   c;
        chtype attr;
        int   i;
        int   flag;
        static const char *txts[] = {"SNGL", "MULT", "DISC", "TRCK",
                                     "PLAY", "SKIP", "DISC", "TRCK" };


	if (btn_number >= InputPsetName) return;
        
        bi = DataButtonInfo + (DATA_BUTTONS+btn_number);

        if (no_cd || track_cur > track_last)
	  {  attr = btn_attr; 
	     text = "";
           goto DrawIt;
        }

        i = bi->oper-100;
 	  switch(i)
	  {	
           case INPUT_TITLE: 
              flag = cd_multi_artist ? 1 : 0;
	        attr = flag ? thumb_attr : btn_attr;
              break;
              
           case INPUT_ARTIST:
              flag = ArtistToggle;
	        attr = flag ? side_attr : bar_attr;
              break;
              
           case INPUT_TRACK:
		  flag = get_track_no(0, brow_cur_line[0]);
              flag = cdaudio_get_track_skip(flag) ? 1: 0;
	        attr = flag ? side_dim_attr : side_attr;
		  DataFieldInfo[INPUT_TRACK].attr = attr;
		  data_draw_single_field(INPUT_TRACK);
              break;
              
           default:    /* INPUT_EXTRA */
              flag = ExtraToggle;
	        attr = flag ? side_attr : bar_attr;
              break;
        }      

        text = txts[i*2+flag];


   DrawIt:	
        i = bi->x1;
        wmove(HelpWnd, bi->y, i);

        wattrset(HelpWnd, attr);
        i = bi->x2 - i + 1;
        while (--i>=0)
        { c = *text;
          if (c) text++; else c = ' ';
          waddch(HelpWnd, (chtype)c | attr);
        }  

 	 wrefresh(HelpWnd);
        
}

static void data_draw_static(void)
{
        short i, y, x;
        const char *txt;
	char c; 
	short shortcut;
        chtype attr;  

	/* Input fields */
        for (i=0; i<DataFields; i++)
        {
                y = DataFieldInfo[i].y;

		txt = DataFieldInfo[i].name;

		if (txt)
		{  wmove(HelpWnd, y, DataHdrX);
                   wattrset(HelpWnd, text_attr);
                   waddstr(HelpWnd, txt);
		}

                wmove(HelpWnd, y, DataFieldInfo[i].x);
                attr = DataFieldInfo[i].attr;
                wattrset(HelpWnd, attr);
                show_padded_line(DataFieldInfo[i].source, attr, 
                                 DataFieldInfo[i].width);
        }

        /* Separation lines */
	wattrset(HelpWnd, fill_attr);
        wmove(HelpWnd, BrowY, 1);
        whline(HelpWnd, cCkboard, HelpWndWidth-2);

        wmove(HelpWnd, BrowY+1, BrowWidth);
        wvline(HelpWnd, cCkboard, HelpWndHeight-7);

        /* Browsers */
        decorate_browser(0);
        decorate_browser(1);

        /* Buttons */
        y = HelpWndHeight - 1;
        x = 6;

	/*              Bottom buttons   */
        for (i=0; i<DATA_BOTTOM_BUTTONS; i++)
        {   txt = DataBtnNames[i];

/*
            if (i== 0)
            {  x = 6;  attr = btn_attr; }
            else
            if (i== 1)
            {  x = HelpWndWidth-14; attr = btn_attr; }
            else
            if (i== 2)
            {  x = BrowWidth-13;
               attr = SaveData ? side_attr : side_dim_attr;
            }
            wattrset(HelpWnd, attr);
*/
            switch(i)
            {  case 0: x = 6;  break;
 
               case 1: x = HelpWndWidth-14; break;

#ifdef RCDDB_SUPPORT
	       case 2: x = BrowWidth-13; break;

	       case 3: x = BrowWidth +6;  break;
#endif
            }
	
            shortcut =  DataBtnShortcut[i];
            DataButtonInfo[i].shortcut = shortcut - 'A' + 1;
		wmove (HelpWnd, y, x);	

            DataButtonInfo[i].y = y;
            DataButtonInfo[i].x1 = x;

	    /* Draw button */	
	    while ((c = *txt++) != '\0')
            {   if (toupper(c) == shortcut)
                {     attr = thumb_attr;
                      shortcut = '\0';
                }
                else
                      attr = AreColours ? btn_attr : fill_attr;
	        wattrset(HelpWnd, attr); 	
/*		waddch(HelpWnd, (chtype) c + attr);
			 Taken out because of bug in monocrome mode */
		waddch(HelpWnd, (chtype) c);
		x++;
            }

            DataButtonInfo[i].x2 = x-1;
            DataButtonInfo[i].oper = i;
         }

         /*             Transfer buttons */
         wattrset(HelpWnd, btn_attr);

         x = BrowWidth; y = BrowY+2;
         mvwaddch(HelpWnd, y, x, cRightArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = DATA_ADDLIST; 
         DataButtonInfo[i].shortcut = KEY_RIGHT+SHIFT_MODIFIER;
	 i++;

         y = HelpWndHeight-3;
         mvwaddch(HelpWnd, y, x, cLeftArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = DATA_DELLIST; 
         DataButtonInfo[i].shortcut = KEY_LEFT+SHIFT_MODIFIER;
	 i++;


         /*             Prefset buttons */
	 x = DataLineX + DataLineSize + 1;	
	 y = PsetLineY;
	 mvwaddch(HelpWnd, y, x, cLeftArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = DATA_PREVSET; 
         DataButtonInfo[i].shortcut = KEY_F(7);
	 i++;


         x += 3;
         mvwaddch(HelpWnd, y, x, cRightArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = DATA_NEXTSET; 
         DataButtonInfo[i].shortcut = KEY_F(8);



	/* 	       Toggle buttons          */ 	
	if (has_extra)
	    x = DataLineX + ExtraLineSize + 1;  
	else
     	    x = DataLineX + DataLineSize + 1;  
	/*  x -= 3;	 */
      y = x + 3;	/* Right x */
	for (i=0; i<DataFields; i++)
	{		
    	     DataButtonInfo[DATA_BUTTONS+i].y = i*2 + DataStartY;
	     DataButtonInfo[DATA_BUTTONS+i].x1 = x;
	     DataButtonInfo[DATA_BUTTONS+i].x2 = y;
	     DataButtonInfo[DATA_BUTTONS+i].oper = 100 + i;
	     DataButtonInfo[DATA_BUTTONS+i].shortcut = 0;
	     draw_toggle_button(i);
	}
	

}

/* ctrl_no = field number
   active  = 0/1   show as inactive/active field */

void  mark_char(short fld_no, short active)
{       short   x, y, len;
      char      *src;
        chtype attr, c;
        short  pos;

        if (active && !HelpFocus) return;

        pos = DataFieldInfo[fld_no].pos;
      src = DataFieldInfo[fld_no].source;
        len = strlen(src);
        if (pos >= len) { pos = len;
                                DataFieldInfo[fld_no].pos = pos;
                                c = ' ';
                            }
                   else c = *(src+pos);

      if (active && c ==  ' ') c = cDiamond;

        pos -= DataFieldInfo[fld_no].offset;
        if (pos < 0) return;
        x = DataFieldInfo[fld_no].x + pos;
        y = DataFieldInfo[fld_no].y;
	  attr = active ? thumb_attr : DataFieldInfo[fld_no].attr;
        wmove(HelpWnd, y, x);
        wattrset(HelpWnd, attr);
        waddch(HelpWnd, c | attr);

}


static void activate_data_fld(short new_field)
{
        if (data_active_fld >= 0)  /* && data_active_fld != new_field) */
                mark_char(data_active_fld, 0);

        data_active_fld = new_field;

        if (data_active_fld >= 0)
                mark_char(data_active_fld, 1);

}

void  data_accept_section(short new_section)
{

        PlayAdvance = 0;
        draw_help_board();
        brow_top_line[0] = brow_top_line[1] = 0;

        data_draw_static();
        data_draw_insert();

        HelpFocus = 0;

        if (no_cd == 0)
        {
/*           if (brow_cur_line[0] == 0xff) brow_cur_line[0] = track_cur - track_first;
           if (brow_cur_line[1] == 0xff &&  */
           if (data_active_fld < 0) data_active_fld = 0;
           data_draw_info();
           accept_focus();
/*         activate_data_fld(data_active_fld);  */
        }

        wrefresh(HelpWnd);

}

static short adjust_offset(int pos)
{       short off = DataFieldInfo[data_active_fld].offset;
	short wid  = DataFieldInfo[data_active_fld].width;
 
        if (off > pos)
           off = pos;
        else
        if (off+wid <= pos)
           off = pos - wid+2;
        else
           return 0;

      DataFieldInfo[data_active_fld].offset = off;
        return 1;
}


static void advance_data_field(short shift)
{
        short   len;
        char    *src;
        short newpos;

        newpos = DataFieldInfo[data_active_fld].pos + shift;
        src = DataFieldInfo[data_active_fld].source;
        len = strlen(src);

        if (newpos < 0 || newpos > len) return;

        if (adjust_offset(newpos))
                data_draw_single_field(data_active_fld);

        mark_char(data_active_fld, 0);

        DataFieldInfo[data_active_fld].pos = newpos;
        mark_char(data_active_fld, 1);
        wrefresh(HelpWnd);
}

void data_set_browser(int brow, short value)
{
	  if (value < 0 || value >= brow_lines[brow]) return;

        brow_cur_line[brow] = value;
        align_brow_top(brow);
        show_data_browser(brow);

        if (brow == 0)
        {
	     short track_no = get_track_no(brow, brow_cur_line[0]);
	
	     if (ArtistToggle)	
	        data_set_source(INPUT_ARTIST, track_no);

	     data_set_source(INPUT_TRACK, track_no);

	     if (has_extra && ExtraToggle)
		   data_set_source(INPUT_EXTRA, track_no);			

	     draw_toggle_button(INPUT_TRACK);   /* Skip track */
        }

        wrefresh(HelpWnd);
}

static void advance_browser(int brow, short shift)
{
    short new_value = brow_cur_line[brow] + shift;
    short max_value = brow_lines[brow]-1;

    if (new_value < 0) new_value = 0;
    if (new_value > max_value) new_value = max_value;

    data_set_browser(brow, new_value);
}


static void data_perform_button_action(int action)
{
	
        switch (DataButtonInfo[action].oper)
        {
           case DATA_SAVE:
                save_local_db();
                break;

           case DATA_RESTORE:
                read_local_db();
		    if (PlayMode == PLAY_LIST &&
                     cur_plist_pos >= cd_playlist_size)
		    {   cur_plist_pos = cd_playlist_size - 1;
		        if (cur_plist_pos < 0)
			      cdaudio_operate(OPER_STOP);
			  else			  			  
			  {   brow_cur_line[1] = cur_plist_pos;
				align_brow_top(1);
			  }
		    }			
                data_draw_fields();
		    DataChanged = 0;	
	   	    launch_message("Disc data restored");
                break;

#ifdef RCDDB_SUPPORT
/*
           case 2:	// Auto-save 
           {    chtype attr;
                short x, y;
                SaveData ^= 1;
                attr = SaveData ? side_attr : side_dim_attr;
                x = DataButtonInfo[action].x1;
                y = DataButtonInfo[action].y;
                wattrset(HelpWnd, attr);
                mvwaddstr(HelpWnd, y, x, "  Auto  ");
           }
                break;
*/
   	   case DATA_DOWNLOAD:
                if (rcddb_download_data())
                     data_draw_fields();
                break;	

           case DATA_UPLOAD:		/* Submit */
		curs_submit_data();  
   	        break;	
#endif          

           case DATA_ADDLIST:
                data_insert_plist_line();
                break;

           case DATA_DELLIST:
                data_delete_plist_line();
                break;

	     case DATA_PREVSET:
		    data_change_prefset((cd_current_prefset-cd_prefsets)-1);
		    break;

	     case DATA_NEXTSET:
		    data_change_prefset((cd_current_prefset-cd_prefsets)+1);
		    break;
              
           case 100+INPUT_TITLE:
                cd_multi_artist ^= 1;
		    DataChanged = 1;
                draw_toggle_button(INPUT_TITLE);
                if (cd_multi_artist == 0)
                { ArtistToggle = 0;
                  draw_toggle_button(INPUT_ARTIST);
			data_set_source(INPUT_ARTIST, 0);			
                }  
                break;

           case 100+INPUT_ARTIST:
		    if (cd_multi_artist)
		    {
                   ArtistToggle ^= 1;
                   draw_toggle_button(INPUT_ARTIST);
		       data_set_source(INPUT_ARTIST, 
			       ArtistToggle ? get_track_no(0, brow_cur_line[0])
                                    : 0);
		    }	
		    else
			 stupid_beep();
                break;

           case 100+INPUT_TRACK:
		    if (cd_set_track_skipability(get_track_no(0, brow_cur_line[0]), -1))
                {    draw_toggle_button(INPUT_TRACK);
			   data_show_track_in_browser(0, brow_cur_line[0]);
			   data_draw_single_field(INPUT_TRACK);
		    }
                break;

           case 100+INPUT_EXTRA:
                ExtraToggle ^= 1;
                draw_toggle_button(INPUT_EXTRA);
		    data_set_source(INPUT_EXTRA, 
			     ExtraToggle ? get_track_no(0, brow_cur_line[0])
                                    : 0);
                break;

		


     }
}

static void  toggle_toggle_button(void)
{
     if ( data_active_fld >= 0 &&
          (  data_active_fld < INPUT_EXTRA ||
             (data_active_fld == INPUT_EXTRA && has_extra)
          )
        ) data_perform_button_action(DATA_BUTTONS + data_active_fld);

}

static OPERATION data_process_mouse(void)
{   short x, y, pos, i, len;
    OPERATION oper = OPER_NONE;

    x = LastMouseEvent.x - HelpWndLeft - 1;
    y = LastMouseEvent.y - HelpWndTop - 1;

    if ( LastMouseEvent.bstate &
              (BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED) )
    {
           pos = x - DataLineX;

           for (i=0; i<DataFields; i++)
	   {
		if (DataFieldInfo[i].y != y) continue;
 	
		pos = x - DataFieldInfo[i].x;
		if (pos >=0 && pos < DataFieldInfo[i].width)
  		{   len = strlen(DataFieldInfo[i].source);
                    if (pos > len) pos = len;
                    mark_char(data_active_fld, 0);
                    DataFieldInfo[i].pos = pos;
                    data_active_fld = i;
                    mark_char(data_active_fld, 1);
                    if (!HelpFocus)
              	    {  HelpFocus = 1;
                       accept_focus();
                    }
                    oper =  OPER_SPECIAL;
		    goto ExitPoint;	
		}

            }

           pos = x;
           if (pos > 0 && pos < BrowWidth)
           {
               if (y >=BrowY  && y < HelpWndHeight -1)
                {  if (y==BrowY || HelpFocus)
                   {  HelpFocus = 1;
                      data_active_browser = 0;
                      accept_focus();
                   }
                }

               if (y >= (BrowY+1) && y <HelpWndHeight-1)
               {
                        short new_line = brow_top_line[0] + y-BrowY-1;

                        if (new_line < brow_lines[0])
                        {  short old_line = brow_cur_line[0];

                           data_set_browser(0, new_line);

                           if (LastMouseEvent.bstate & BUTTON3_CLICKED)
                                  data_insert_plist_line();
                           else
                           if (!HelpFocus || LastMouseEvent.bstate & BUTTON2_CLICKED ||
                                              old_line == new_line)
                                  cd_playtrack(new_line + track_first, 4);
                        }

                        oper = OPER_SPECIAL;
			goto ExitPoint;
               }
           }

           pos = x - BrowWidth;
           if (pos > 0 && pos < BrowWidth)
           {    if (y >=BrowY  && y < HelpWndHeight - 1)
                {  if (y==BrowY || HelpFocus)
                   {  HelpFocus = 1;
                      data_active_browser = 1;
                      accept_focus();
                   }
                }

                if (y >= (BrowY+1) && y <HelpWndHeight-1)
                {
                       short max_line = brow_lines[1];
                       short new_line = brow_top_line[1] + y - BrowY - 1;

                 /*      if (!HelpFocus && PlayMode == PLAY_LIST) max_line--; */
                       if (new_line < max_line)
                       {
                          short old_line = brow_cur_line[1];

                          data_set_browser(1, new_line);

                          if (LastMouseEvent.bstate & BUTTON3_CLICKED)
                                    data_delete_plist_line();
                          else
                          if (new_line < brow_lines[1]-1 &&
                               ( ! HelpFocus ||
                                 LastMouseEvent.bstate & BUTTON2_CLICKED ||
                                 old_line == new_line
                               )
                            )
                          {     short track_no = get_track_no(1, new_line);
                                short new_line_alt = track_no - track_first;
                                short old_line_alt = brow_cur_line[0];

                                data_set_browser(0, new_line_alt);

                                if (!HelpFocus || old_line_alt == new_line_alt)
                                { if(PlayMode == PLAY_LIST) cur_plist_pos = new_line;
                                    cd_playtrack(track_no, 4);
                                }
                          }


                       }
                        oper = OPER_SPECIAL;
			goto ExitPoint;
               }
           }


           if (oper != OPER_SPECIAL)
           { for (i=0; i<DATA_BUTTONS+DataFields; i++)
                {  if (DataButtonInfo[i].y != y) continue;
                   if (DataButtonInfo[i].x1 <= x && DataButtonInfo[i].x2 >= x) break;
                }
                if (i<DATA_BUTTONS+DataFields)
                {  data_perform_button_action(i);
                   oper = OPER_SPECIAL;
	 	   goto ExitPoint;
                }
           }

    }
    if ( LastMouseEvent.bstate &
              (BUTTON1_CLICKED | BUTTON2_PRESSED | BUTTON3_PRESSED) )
    {      pos = x; i = -1;
           if (pos == DataScrollX1 || pos == DataScrollX2) i=0;
           else
	     { pos -= BrowWidth;	
             if (pos == DataScrollX1 || pos == DataScrollX2) i=1;
           }
	     if (i >= 0)	 
           {   if (y == BrowY && brow_top_line[i] > 0 )
               {  brow_top_line[i]--;
                     if (HelpFocus) data_set_browser(i, brow_cur_line[i]-1);
                               else show_data_browser(i);
                     oper = OPER_SPECIAL;
		     goto ExitPoint;
	         }
               else
               if (y == HelpWndHeight-1 &&
                   brow_top_line[i]+BrowHeight < brow_lines[i])
               {    brow_top_line[i]++;
                    if (HelpFocus) data_set_browser(i, brow_cur_line[i]+1);
                            else show_data_browser(i);
                    oper = OPER_SPECIAL;
		    goto ExitPoint;
               }
            }
    }


ExitPoint:
    if (oper != OPER_NONE)
       wrefresh(HelpWnd);

    return oper;

}

u_short get_kbd_shift(void)
{
#ifdef TIOCLINUX
    	u_char argp = 6;
	if (ioctl(cur_term->Filedes, TIOCLINUX, &argp) >= 0)
	           return (u_short) argp;
#endif
	return 0x8000;
}


static OPERATION  data_process_edit_key(int key)
{
      char      *src;
      short pos, len;
	short     ssz;   /* Source size */

      pos = DataFieldInfo[data_active_fld].pos;
      src = DataFieldInfo[data_active_fld].source;
	ssz = DataFieldInfo[data_active_fld].ssize;
      len = strlen(src);

      if (key == KEY_HOME)
         DataFieldInfo[data_active_fld].pos = pos = 0;
	else
      if (key == KEY_END)
         DataFieldInfo[data_active_fld].pos = pos = len;
	else
      if (key == KEY_NPAGE)
	{  pos += DataFieldInfo[data_active_fld].width;
	   if (pos >= len) pos = len;	
         DataFieldInfo[data_active_fld].pos = pos;
	}
	else
      if (key == KEY_PPAGE)
	{  pos -= DataFieldInfo[data_active_fld].width;
	   if (pos < 0) pos = 0;	
         DataFieldInfo[data_active_fld].pos = pos;
	}
	else
      if (key == KEY_BACKSPACE)
      {  if (--pos >= 0)
         {  strcpy(src+pos, src+pos+1);
                DataFieldInfo[data_active_fld].pos = pos;
                DataChanged = 1;
         }
         else pos = 0;
      }
      else
      if (key == KEY_DC)
      {  strcpy(src+pos, src+pos+1);
         DataFieldInfo[data_active_fld].pos = pos;
         DataChanged = 1;
      }
      else
      if (key <= 0xff && key >= ' ')
      {
         if (InsertMode && len < ssz)
         {  int i = len+1;
            while (i>pos)
             {  *(src+i) = *(src+i-1);
                    i--;
             }
         }

         *(src+pos) = key;
         if (++pos < ssz)
         {  if (pos > len) *(src+pos) = '\0';
            DataFieldInfo[data_active_fld].pos = pos;
         }

         DataChanged = 1;
      }
      else
        return OPER_NONE;


     adjust_offset(pos );

     if (data_active_fld == INPUT_TRACK || 
            (data_active_fld == INPUT_ARTIST && ArtistToggle) )
     {   if (HeaderMode == 2 && brow_cur_line[0] + track_first == track_cur)
                                       draw_header();
         data_show_track_in_browser(0, brow_cur_line[0]);
	   data_update_playlist_names();
     }
     else
     if (HeaderMode == 1 &&
        ( data_active_fld == INPUT_TITLE ||
          data_active_fld == INPUT_ARTIST )
        )  draw_header();

     data_draw_single_field(data_active_fld);
     mark_char(data_active_fld, 1);

     wrefresh(HelpWnd);

     return OPER_SPECIAL;
}



static OPERATION data_getaction(int key)
{   OPERATION oper = OPER_NONE;
    short  brow;
    short shift, ctrl;
    int   i;
    int   key_shifted;

    if (no_cd || track_cur == 0xff || key == ERR) goto Fine;

    if (key == KEY_MOUSE)
    {   oper = data_process_mouse();
        goto Fine;
    }

    shift = get_kbd_shift();
    ctrl =  shift & 4;
    shift = shift & 1;	

    /* Process tab key */
    if (key == 9)
    {  if (HelpFocus)
        {  i = data_active_fld + (shift ? -1 : 1) ;
           if (i >= 0 && i < DataFields)
           {
	      activate_data_fld(i);
	      wrefresh(HelpWnd);
              oper =OPER_SPECIAL;
	      goto Fine;		
           }
	}
     
	i = shift ? (DataFields-1) : 0;
        if (!HelpFocus) data_active_fld = i;
        HelpFocus ^= 1;
        accept_focus();

        oper = OPER_SPECIAL;
        goto Fine;
    }

    /* Process switch panel/browsers key */
    if (key == KEY_F(5) || key == KEY_F(6) || key == KEY_F(17))
    { 
         if (shift || key != KEY_F(5))
 	       data_active_browser ^= 1;
	 else
	       HelpFocus ^= 1;

         accept_focus();
         oper =OPER_SPECIAL;
         goto Fine;
    }

     /* These keys should work no matter where the focus is */	     switch(key)
     {

	case 0x11:    /* Ctrl+Q */
                oper = OPER_QUIT;
		goto Fine;

	case 0x12:    /* Ctrl+R */
        	redraw_screen();
		goto Fine;

        case 0x18:    /* Ctrl+X */
                oper = OPER_STOPQUIT;
		goto Fine;
     }

    /* Alternative shortcuts for prefset keys */
    if (ctrl && !shift)
    {   if (key == KEY_RIGHT) key = KEY_F(8);
        else
        if (key == KEY_LEFT) key = KEY_F(7);
    }

    /* Button keys are also focus-independent */	
    key_shifted = key | (shift ? SHIFT_MODIFIER : 0);    	

    for (i=0; i<DATA_BUTTONS+DataFields &&         	
	  DataButtonInfo[i].shortcut != key_shifted; i++);

    if (i < DATA_BUTTONS+DataFields)
    {   data_perform_button_action(i);
	  oper = OPER_SPECIAL;
	  goto Fine;
    }

    if (!HelpFocus) goto Fine;

    /* Process Tab/Enter key */
    if (key == KEY_ENTER || key == 13)
    {     activate_data_fld((data_active_fld +
                  ( shift ? (DataFields-1) : 1)) % DataFields);
          wrefresh(HelpWnd);
          oper =OPER_SPECIAL;
          goto Fine;
    }


    oper = OPER_SPECIAL;

    brow = data_active_browser ^ shift;

     if(ctrl)
	  oper = data_process_edit_key(key);
     else
     switch(key)
     {
        case KEY_IC:    /* Ins */
		InsertMode ^= 1;
		data_draw_insert();
		wrefresh(HelpWnd);
		break;
       
        case KEY_RIGHT:   /* Right unshifted */
 		advance_data_field(1);
            break;

        case KEY_LEFT:    /* Left unshifted */ 
            advance_data_field(-1);
            break;

        case KEY_HOME:	/* Home */
 		data_set_browser(brow, 0);
            break;

        case KEY_END:	/* End */
            data_set_browser(brow, brow_lines[brow]-1);
            break;

        case KEY_UP:       /* Up  */
            advance_browser(brow, -1);
            break;

        case KEY_DOWN:      /* Down */	
            advance_browser(brow, 1);
            break;

        case KEY_PPAGE:	/* PgUp */
            advance_browser(brow, -BrowHeight);
            break;

        case KEY_NPAGE:	/* PgDn */
            advance_browser(brow, BrowHeight);
            break;

        case KEY_B2:		/* Center or F7 */
        case KEY_F(7):
            if (brow) data_delete_plist_line();
               else data_insert_plist_line();
            break;

	  case 0x14:    /* Ctrl+T */
            toggle_toggle_button();
		goto Fine;

        default:	
           oper = data_process_edit_key(key);
     }

Fine:
     if (FourWndCount > 0)
            usleep((HELP_PLAY_TIMEOUT)/4);  /* Prevents a noise from speakers,
                                                 due to intensive CPU use */

     return oper;
}


short ask_save_question(const char *message)
{  short rc;
	
    if (QuietMode) return 0;
    rc = curs_yesno(message);
    if (MainWnd) redraw_screen();
    return rc;
} 

void show_error_message(const char *message)
{
  fprintf (stderr, "%s\n", message);
}

static short data_change_prefset(short prefset_number)
{
	if (prefset_number < 0
       	|| prefset_number >= cd_prefset_count) return 0;

	cd_accept_prefset(prefset_number);
    
      brow_lines[1] = cd_playlist_size;

	show_current_prefset();	

	brow_lines[1] = cd_playlist_size+1;
	show_data_browser(1);

	data_draw_single_field(INPUT_TRACK);
	draw_toggle_button(INPUT_TRACK);

	if (cur_plist_pos >= 0)
	{   data_set_browser(1, cur_plist_pos);
/*	    if (!HelpFocus && PlayMode == PLAY_LIST)
	      data_set_browser(0, cd_playlist[cur_plist_pos] - track_first);
*/
	} 		

	wrefresh(HelpWnd);
	return 1;    
}              

void  save_local_db(void)    	
{     short prefset_no1, prefset_no2;

      prefset_no1 = cd_current_prefset-cd_prefsets;
      cd_prepare_save_prefsets();
      prefset_no2 = cd_current_prefset-cd_prefsets;
      if (prefset_no2 != prefset_no1)
          data_change_prefset(prefset_no2);
      
      scdb_write();
      launch_message("Disc data saved");
      DataChanged = 0;
}      

int CheckTTY(void)
{
#ifdef VT_GETSTATE
   struct vt_stat vts;

   if (ttyno < 0) return 1;
   ioctl(termfd, VT_GETSTATE, &vts);	
   return (vts.v_active == ttyno) ? 1: 0;
#else
	 return 1;	
#endif
}  

