 /* ========================================================= 
    SING - ALONG DISK PLAYER. 
    (C) 1998 - 2000  Michael Glickman  xsadp@yahoo.com       
    ---------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
 
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ----------------------------------------------------------
    sadp_features.c - started somewhere in January 2000
    
    This code is based on CD-TEXT specification from SCSI Multimedia
    Commands-2 (MMC-2), found at http://www.t10.org and cdda2wav
    source code by Heiko Eissfeldt. Special thanks to Jens Axboe,
    Heiko Eissfeldt & Andreas Mueller for valuable information.
    
    It is much easier to find a skull of a dinosaurus than a CD-TEXT
    or CD_EXTRA compilant disc in Australia. If you have appropriate
    media and drives, as well as willingness to test these features
    in full, uncomment definition of CD_EXTENSION_SUPPORT and/or
    CD_EXTRA_SUPPORT in sadp_config.h, recompile, and see how it 
    goes. See comments in the code. The feedback will be extremely
    helpful.  Cheers.  
    ========================================================= */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>
#include <linux/major.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#include "sad.h"

/* #define  USE_SAMPLE_DATA */

#ifdef USE_SAMPLE_DATA
#include "cdtext_sample.h"
#endif

#if HAVE_SCSI_SCSI_H
#include <scsi/scsi.h>
#endif

#if defined(SCSI_SUPPORT)

#if HAVE_SCSI_SCSI_IOCTL_H
#include <scsi/scsi_ioctl.h>
#endif

#ifndef SCSI_IOCTL_GET_IDLUN
#define SCSI_IOCTL_GET_IDLUN 0x5382
#endif

#ifndef SCSI_IOCTL_GET_BUS_NUMBER
#define SCSI_IOCTL_GET_BUS_NUMBER 0x5386
#endif

/* SG support is not needed if
   CDROM_SEND_PACKET is provided */

#if  defined(CD_EXTENSION_SUPPORT) && \
    !defined(CDROM_SEND_PACKET) && HAVE_SCSI_SG_H
#include <scsi/sg.h>
#endif

#ifndef SG_EMULATED_HOST
#define SG_EMULATED_HOST 0x2203
#endif

static int   scsi_bus, scsi_lun;
static int  scsi_param, scsi_unique_id;

#endif   /* def SCSI_SUPPORT */

#ifndef INQUIRY 
#define INQUIRY  0x12
#endif

#ifndef READ_TOC
#define READ_TOC 0x43
#endif

extern  TRACK_INFO  *trk_info;
extern  u_char dtrack_first, dtrack_last, track_first;
extern  char disc_name[], disc_artist[], disc_extra[];
extern  u_long  dtime_total;
extern  u_long  multisession_addr;
extern  short   cd_multi_artist;

static int  type_confirmed;
extern PLATFORM Platform;
extern char CDDeviceName[];
extern u_char CDDeviceType, CDNodeNumber;

#define CD_DESCRIPTION_SIZE 15
#define CD_MODEL_SIZE 61

char  cd_description[CD_DESCRIPTION_SIZE];
char  cd_model[CD_MODEL_SIZE];
char  sg_name[9];

CDTYPE cd_type;
char *ExtensionType;
static int  cdrom_fd;

#ifdef MCN_SUPPORT
const char *cd_upcode; 
#endif  /* def MCN_SUPPORT */


#if defined(SCSI_SUPPORT)
/* =========================================================================
	Just acknowledges SCSI emulation  (ATAPI)
        ----------------------------------------- */   
static void set_scsi_emulation(void)
{   strcpy(cd_description, "SCSI EMULATION");
    cd_type = CDTYPE_SCSI_EMU;
}
#endif  /* defined(SCSI_SUPPORT) */
/* =========================================================================

		    CD EXTENSION SUPPORT STARTS HERE

  ========================================================================= */

#if defined CD_EXTENSION_SUPPORT

/* #define COMMAND_LENGTH  12 */
#define COMMAND_LENGTH  10

#if defined(CDROM_SEND_PACKET)
#define  HAVE_CD_EXTENSION 
/*========================================================= */ 
/*       In linux 2.3.x it is as simple as that!            */
/*========================================================= */ 
int  send_cd_packet_command(
            const u_char *cmd, u_char *buf, int buflen)
{    
    struct cdrom_generic_command cgc;
    
    memcpy(cgc.cmd, cmd, CDROM_PACKET_SIZE);
    cgc.buffer = buf;
    cgc.buflen = buflen;
    cgc.stat = 0;
    memset(cgc.reserved, 0, 4);
    
    if (ioctl(cdrom_fd, CDROM_SEND_PACKET, &cgc) < 0) return errno;
    return cgc.stat;
    
}       

static void init_extensions(void)
{ 
    ExtensionType = "direct";

}

static void deinit_extensions(void)
{  ;  }

#elif defined(SCSI_SUPPORT)
#define HAVE_CD_EXTENSION 
/* ==================================================== */ 
/*  This huge and ugly equivalent for linux 2.2.0       */
/*  works only with SCSI CD-s, including emulated.      */ 
/*  Indeed the most awkward interface you can imagine.  */
/* ==================================================== */ 
static int sg_fd = -1;

#define HEADER_LENGTH  sizeof(struct sg_header)
#define MAX_SCSI_DEVICES 16

int  send_cd_packet_command(
            const u_char *cmd, u_char *buf, int buflen)
{    

    struct sg_header *sghd;
    int packlen, replen, int_buflen;
    int rc;
    char *int_buffer;
    
    if (sg_fd < 0) return 66;
    
    int_buflen = replen = HEADER_LENGTH + buflen;
    packlen =  HEADER_LENGTH + COMMAND_LENGTH;
    if (int_buflen < packlen) int_buflen = packlen;
        
    int_buffer = malloc(int_buflen);
    if (int_buffer == NULL) return 66;
    
    memset(int_buffer, '\0', HEADER_LENGTH);
    memcpy(int_buffer+HEADER_LENGTH, cmd, COMMAND_LENGTH);
    
    sghd = (struct sg_header *)int_buffer;
    sghd->pack_len = packlen;
    sghd->reply_len = replen;
#if COMMAND_LENGTH >= 12    
    sghd->twelve_byte = 1;
#endif    
        
    if ( write(sg_fd, int_buffer, packlen) != packlen) rc =  errno;
    else
    if ( sghd->result) rc = sghd->result;
    else
    if (read(sg_fd, int_buffer, replen) != replen) rc = errno;
    else
    if ( sghd->result) rc = sghd->result;
    else
    {    
	if (buflen > 0) memcpy(buf, int_buffer + HEADER_LENGTH, buflen);
	rc = 0;
    }

    free(int_buffer);
    	
    return rc;
    
}       


static void open_equivalent_sg(void)
{
    static char devname[] = "/dev/sg00";
    char  *num_pos;
    int   i, bus;	
    int   lun_info[2];	

     if (CDDeviceType != SCSI_CDROM_MAJOR)
     {  sg_fd = -1; return; }	
   
    /* We may have either /dev/sga, /dev/sgb ..
                    or    /dev/sg0, /dev/sg1 .. */

    num_pos = devname + strlen(devname)-2;

    for (i=0; i<MAX_SCSI_DEVICES; i++)
    {	
	sprintf(num_pos, "%d", i);
	sg_fd = open(devname, O_RDWR);
	if (sg_fd < 0 && errno == ENOENT)
	{   *num_pos = 'a' + i;
	    *(num_pos+1) = '\0'; 	
	    sg_fd = open(devname, O_RDWR);
	}	    
	
	if (sg_fd < 0)
	{   char message[513];
	    switch(errno) 
	    {  case ENOENT:
		    sprintf (message, "No generic SCSI device found.\n"
		            "Use 'MAKEDEV sg' or 'mknod' command, e.g.\n\n"
		            "    mknod -m666 /dev/sga c %d 0", SCSI_GENERIC_MAJOR);
		    goto OutOfHere;
	     
		  case EACCES:
		     sprintf (message, "No access to %s\n" 
		            "Log on as root and enable read and write permissions:\n");
		            "    tchmod 666 %s", devname, devname);
		     goto OutOfHere;
	     	     	     
		  case ENODEV:
			 sprintf (message, "SCSI generic device not supported\n"
		                       "Ensure that SG driver is loaded as\n"
		                       "a module or provided by the kernel");
		     goto OutOfHere;

		  default:
		     sprintf (message, "%s error %d:\n%s", devname, errno, strerror(errno));	

	   }		    

	   show_error_message(message);
	   goto OutOfHere;
	}			      
	
	/* We succeeded to open!  See if it is what we are after */

	if( ioctl(sg_fd, SCSI_IOCTL_GET_BUS_NUMBER, &bus) < 0 )
	            bus = -1;

	if (ioctl(sg_fd, SCSI_IOCTL_GET_IDLUN, lun_info) < 0)
 		    lun_info[0] = lun_info[1] = -1;

	if ( bus == scsi_bus && lun_info[0] == scsi_param &&
                 lun_info[1] == scsi_unique_id) break;

	close(sg_fd);
		    
    }
    

OutOfHere:    
    if (i>=8 || sg_fd < 0)
    {   show_error_message("Could not allocate generic SCSI device.\n"
                           "Extended options are disabled.\n");
	if (sg_fd >= 0) close(sg_fd);
	sg_fd = -1;
//	if (Platform == PLTF_CURSES) getchar();
	return;
    }	    

    strcpy(sg_name, devname+5);
	
/* Define if emulation is on */
    if (ioctl(sg_fd, SG_EMULATED_HOST, &bus) >= 0)
    {  type_confirmed = 1;	   	    	
	 if(bus) set_scsi_emulation();
    }	
}  


static void close_equivalent_sg(void)
{
    if (sg_fd >= 0)
    {
      close(sg_fd); sg_fd = -1;
    }
}    

static void init_extensions(void)
{
	
    ExtensionType = "sg device";
    open_equivalent_sg();
}

static void deinit_extensions(void)
{
    close_equivalent_sg();
}

#else   /* DEFINED_SCSI_SUPPORT */
/* No extension */
int  send_cd_packet_command(
            const u_char *cmd, u_char *buf, int buflen)
	{  return 666; }
#endif

#ifdef HAVE_CD_EXTENSION
static int  get_cd_internal_model(void)
{
    /* Sending inquiry command to the device */
    u_char data_flds[COMMAND_LENGTH];
    u_char output[96];
    u_char *iptr, *optr;
    u_char rev;
    
    memset(data_flds, '\0', COMMAND_LENGTH);

    data_flds[0] = INQUIRY;  /* Inquiry code */
    data_flds[1] = scsi_lun;  /* Lun + EPVD */
    data_flds[2] = 0;       /* Page code */
    data_flds[3] = 0;       /* Allocation length MSB */
    data_flds[4] = 96;      /* Allocation length LSB */
    data_flds[5] = 0;       /* Control */

    if  (send_cd_packet_command(data_flds, 
                          output, 96)) return 0;
    
    iptr = output+8;
    optr = cd_model;
    memcpy(optr, iptr, 8);
    iptr += 8; optr += 8;
 
    if (type_confirmed == 0 && cd_type == CDTYPE_SCSI)
    { *optr = '\0';
      if(strstr(cd_model, "IDE"))
	    set_scsi_emulation();
    }
    *optr++ = ' ';

    memcpy(optr, iptr, 16);
    iptr += 16; optr += 16;
    *optr++ = ' ';
    
    memcpy(optr, iptr, 4);
    iptr += 4; optr += 4;
    *optr++ = ' ';

    rev = output[2];
    if (rev > 0)
    	sprintf(optr, "SCSI-%x", rev); 
    else	
	*optr = '\0';
    
    return 1;

}


static short process_cdtext_record(u_char code, u_char track_no, char *data)
{	char *target = NULL;

	if (track_no > 0 && (track_no < dtrack_first || track_no > dtrack_last))
				    return 0;		    


	switch(code)
	{   case 0x80:

		if (track_no == 0)	/* Title */
		    target = disc_name;
		else
		{
		    /* According to MMC spec a single tab can be used
  		       to indicate 'the same as previous' */	
		    if (*data == 9 && track_no > dtrack_first)
		        data = (trk_info+(track_no-1-dtrack_first))->name;
		    target = (trk_info+(track_no-dtrack_first))->name;
		}
	      strcpy(target, "");	
		break;
		
				    
	    case 0x81:			/* Performer */
		if (track_no == 0)
		    target = disc_artist;
		else
		{  
		    if (*data == 9 && track_no > dtrack_first)
		        data = (trk_info+(track_no-1-dtrack_first))->artist;
		    target = (trk_info+(track_no-dtrack_first))->artist;
		    strcpy(target, "");	
		    if ( strlen(data) > 0) cd_multi_artist = 1;
		}		    
	      strcpy(target, "");	
		break;
		
	    case 0x82:			/* Songwriter */
	    case 0x83:			/* Composer */
	    case 0x84:			/* Arranger */
	    case 0x85:			/* Message */
		if (track_no == 0)
		{
		    target = disc_extra;
		    strcpy(target, "");	
		}
		else
		{    target = (trk_info+(track_no-dtrack_first))->extra;

		    /* If track information starts with TAB, copy it
                   from the previous track */	
		    if (*data == 9)
		    { if(track_no > dtrack_first && *target == '\0')
		         data = (trk_info+(track_no-1-dtrack_first))->extra;
			else
			   data = NULL;
		    }	
		}    
		break;

		/* This could be suported in the future.
		   Left commented out currently 	
#ifdef MCN_SUPPORT
	    case 0x8E:			// UPC or ISRC 
		if (track_no == 0) up_code = strdup(data);		
		return 1;
#endif
		*/

	    
	}
	
	if (target && data && strlen(data) > 0)
	{   int l = strlen(target);
    
	    l = strlen(target);
	    if (l>0 && l<(DATA_NAME_SIZE-1))
              { *(target+l) = ' '; l++; }
	    if (l < DATA_NAME_SIZE)
	        strncpy(target+l, data, DATA_NAME_SIZE-l);
	    
	    return 1;
	}	    
	    
	
	return 0;	    
}

short process_cdtext(void)
{
    /* This is going to be a real nightmare.
       Thanks goodness, I am not the first, and hopefully not the last.
       This code is highly influenced by cdda2wav code written by 
       Heiko Eissfeldt. Thanks a lot, Heiko */
       
	u_char data_flds[12];
	u_char header[4];
	int	buffer_size, j;
	u_char	code, track;
	u_char	*buffer, *bufptr, *txtptr;
	u_char	resbuf[DATA_NAME_SIZE], c;
	short		txt_len;
	short		resbuf_pos;
	short	rc;

	u_char  block_no, old_block_no, dbcc;

    /* Heiko couldn't find a better alternative to reading TOC twice -
       once with reduced allocation length to get the size, and second
       time for getting actual data. With SG however you can attempt
       using two reads, but this wouldn't work with CDROM_SEND_PACKET.
       Well, use good old style then ...
    */                
        
#ifndef  USE_SAMPLE_DATA
      memset(data_flds, '\0', COMMAND_LENGTH);
	data_flds[0] = READ_TOC;	/* READ TOC code */
	data_flds[1] = scsi_lun;
	data_flds[2] = 5;	/* Format 101b - CD-TEXT */
 /*	data_flds[6] = 1;	   Starting session in Heiko's code but should
                                   work with zero according to SCSI spec */
	data_flds[8] = 4;	/* LSB allocation length - enough for storing
	                           size and track range (?) */

	/* Go, get the size */					   
      if  (send_cd_packet_command(data_flds, header, 4)) return 0;

	buffer_size = ((header[0] << 8) | header[1]);
	if (buffer_size < 2) return 0;
	
      buffer_size += 2;	/* Allow 2 bytes for length - we get it again! */
	buffer = malloc(buffer_size);
	if (buffer == NULL) return 0;
	
	/* Now get the data */					   
	data_flds[7] = buffer_size >> 8;	/* MSB */
	data_flds[8] = buffer_size & 0xff;	/* LSB */

      if  (send_cd_packet_command(data_flds, buffer, buffer_size))
	{ free(buffer) ; return 0; }
#else
	buffer = malloc(sizeof(cdtext_sample));
	if (!buffer) return 0;
	memcpy(buffer, cdtext_sample, sizeof(cdtext_sample));
#endif 
	
	
	/* Parsing CD-TEXT.................................... */
	/* Can we avoid using the second buffer ? Yes, we can! */	
	/*-----------------------------------------------------*/	
	rc = 0;
	bufptr = buffer;
	buffer_size = (buffer[0] << 8) | buffer[1];  /* Redundant? Don't think so! */
	
				/* Start of descriptor */		
	buffer_size -= 2;			/* Take away session start/end fields */	
	
	resbuf_pos = 0;
	old_block_no = 0xff;
	
	/* each chunk is 18 butes long, the code (byte zero) should be 0x8x */
	for (bufptr = buffer+4; buffer_size >= 18; bufptr += 18, buffer_size -= 18)
	{   code = *bufptr;

	    /* Assuming CD-TEXT data go non-interrupted in consecutive order */	    
	    if ((code & 0x80) != 0x80) continue;
	    
    	    /* We found CD-TEXT! Parse the data */

	    block_no = *(bufptr+3);
	    dbcc = block_no & 0x80;
	    block_no &= 0x70;	/*  0x30 in Heiko's code is probably a mistake */

	    if (block_no != old_block_no)
	    {   if (rc) break;
		resbuf_pos = 0;
		old_block_no = block_no;
	    }

	    if (dbcc) continue;   /* We don't pocess double byte characters as yet */

	    track = *(bufptr+1);	/* Starting track number, if applicable */
	    if (track & 0x80) continue;  /* Ignore extended information */ 	

	    /* Hopefully Heiko's approach of ignoring character position field
	       in favour of null byte separator should be all right */

	    txtptr = bufptr + 4;	/* Text start after ther header */

	    /* Get rid of padding zeroes at end */		
	    for ( txt_len = 11;
                txt_len >= 0 && *(txtptr+txt_len)=='\0'; txt_len--);

	    txt_len++;
	    if(txt_len < 12) txt_len++;  /* Include first padding, if any */ 
                   

	    for (j=0; j<txt_len; j++)
	    {  c = *(txtptr+j); 
	    
	       if (c == '\0')
		 {  resbuf[resbuf_pos] = c;
		    if (process_cdtext_record(code, track, (char *)resbuf)) rc = 1;
		    resbuf_pos = 0;
		    track++;
		 }		    
		 else    
	          if (resbuf_pos < (DATA_NAME_SIZE-1)) 
		          resbuf[resbuf_pos++] = c;
	    }			 
			
	    
	}
	
	free(buffer);
	return rc;
}	

#else
int process_cdtext(void)
{
	return 0;

}
#endif	/* HAVE_CD_EXTENSION */

#endif   /* CD_EXTENSION_SUPPORT */


#if defined(SCSI_SUPPORT)

/* A scsi device can be identified by BUS, CHANNEL, ID and LUN */
/*  ======================================================================
	      This part is needed only  for  S C S I  CDs
    ====================================================================== */
void get_scsi_parameters(void)
{  
	int lun_info[2];		


	if( ioctl(cdrom_fd, SCSI_IOCTL_GET_BUS_NUMBER, &scsi_bus) < 0 )
	            scsi_bus = -1;
	
	if (ioctl(cdrom_fd, SCSI_IOCTL_GET_IDLUN, lun_info) < 0)
 		    lun_info[0] = lun_info[1] = -1;

	scsi_param = lun_info[0];
        scsi_unique_id = lun_info[1];
        scsi_lun = (scsi_param >> 3) & 0xE0;

	if (scsi_param < 0 && scsi_bus < 0 && scsi_unique_id < 0)
		cd_type = CDTYPE_UNKNOWN;
}


/* This part will work, in case nothing else applies */
static char *find_key(char *str, const char *key)
{
    char *ptr = strstr(str, key);
    
    if (ptr)
    {  if (ptr > str) *(ptr-1) = '\0'; 
       ptr += strlen(key);
       ptr += strspn(ptr, " "); 
    }      
    return ptr;
}


static int check_number(char *number, int required)
{
    char *tmp;
    int  n;
    
    n = strtol(number, &tmp, 0);
    return  n == required && (tmp > number);
}    

int  get_scd_model(void)
{
    int id, lun, channel;
    char buf[81], *pat, *outptr;
    FILE *f;

#if defined(HAVE_CD_EXTENSION)
    if (get_cd_internal_model())  return 1;
#endif

    if (scsi_param < 0) return 0;
    
    id = scsi_param & 0xff;
    lun = (scsi_param >> 8) & 0xff;
    channel = (scsi_param >> 16) & 0xff;
    outptr = NULL;	
    
    f = fopen("/proc/scsi/scsi", "r");
    if (!f) return 0;
    
    while (fgets(buf, 81, f))
    {	
   	 pat = find_key(buf, "Host:");
         if (outptr == NULL)
	 {
		if (!pat) continue;
	
		if (memcmp(pat, "scsi", 4) != 0  ||
		     !check_number(pat + 4,  scsi_bus)) continue;

		pat = find_key(pat,"Channel:");
		if (!pat || !check_number(pat, channel))
				    continue;
		pat = find_key(pat, "Id:");
		if (!pat || !check_number(pat, id))
				    continue;
		pat = find_key(pat,"Lun:");
		if (!pat || !check_number(pat, lun))
				    continue;
		outptr = cd_model;
	}
	else
	{
		if (pat) break;

		pat = find_key(buf, "Vendor:");
		if (pat)
		{  memcpy(outptr, pat, 8);
		   pat += 9;
		   outptr += 8;  

		   if (type_confirmed == 0)
		   {   *outptr = '\0';
                       if (strstr(cd_model, "IDE"))
			   set_scsi_emulation();
                   }
		   *outptr++ = ' ';
	
		   pat = find_key(pat, "Model:");
		   if (pat)
		   {  memcpy(outptr, pat, 16);
		      pat += 17; outptr += 16;
		      *outptr++ = ' ';
		   }
		
		   pat = find_key(pat, "Rev:");
		   if (pat)
		   { memcpy(outptr, pat, 4);
		     outptr += 4;
		     *outptr++ = ' ';
		   }
		   
		}
		else
		{  pat = find_key(buf, "ANSI SCSI revision:");
		   if (pat)
		   {  memcpy(outptr, "SCSI-", 5);
		      outptr += 5;
		      if (*pat == '0')
		      {   memcpy(outptr, pat+1, 1);		    
		          outptr++;
		      }
		      else
		      {  memcpy(outptr, pat, 2);
    		         outptr += 2;
		      }			 
		      *outptr++ = ' ';
		   }
		   break;
		}
	}			    	     
    }	     
		     
    fclose(f);

    if (outptr && outptr > cd_model)
    { *--outptr = '\0';
      return 1;
    }

    return 0;


}

#endif /* defined(SCSI_SUPPORT) */


int  get_atapi_model(void)
{ 
       char dev[4];
       char *ptr;
       int l;
       FILE *f;

#if defined(CDROM_SEND_PACKET) && defined(HAVE_CD_EXTENSION)
       if (get_cd_internal_model()) return 1;
#endif    
    
       l = readlink(CDDeviceName, cd_model, CD_MODEL_SIZE);  
       if (l > 0)
       {  cd_model[l] = '\0';
          strcpy(dev, cd_model+l-3);	
          ptr = dev;
       }	  
       else
         ptr = CDDeviceName + strlen(CDDeviceName)-3;


       sprintf (cd_model, "/proc/ide/%s/model", ptr );
    
       f = fopen(cd_model, "r");
       if (f) 
       {  fgets(cd_model, 61, f);
          strtokm(cd_model, "\n");
	  fclose(f);
	  return 1;
       }	       
       
       strcpy(cd_model, "");
       return 0;
}       

#ifdef  CD_EXTRA_SUPPORT
/* ====================================================== */
/*                       CD - EXTRA                       */
/* ====================================================== */
/* The only source of CD_EXTRA information on my disposal */
/* is again cdda2wav program by Heiko Eissfeldt. The ori- */
/* ginal code looks a bit messy. I tried to rewrite it in */
/* the simplest and clearest possible way - had no chance */
/* to test it though. Your feedback is extremely valuable.*/
/* ====================================================== */

/* This macro loads a 4 byte unsigned big-endian value (u_int),
   referenced by (char *)p. Ripped from cdda2wav, and even
   retained the original name.
*/
#define GET_BE_UINT_FROM_CHARP(p) ((unsigned int)((*(p))<<24)|((*(p+1))<<16)|((*(p+2))<<8)|(*(p+3)))


static short process_cdextra_subinfo(u_char *buf, u_long tot_len)
{
	u_int	  info_count;
	u_short id, len, len1, len2;
	static  short  track_no = 0;
	char 	  *target;
	short	  rc = 0;

    /* How about improper XA sector handling this time ? */	
	buf += 44;

    /* Get number of items as 16-bit big-endian */		
	info_count = *buf++ << 8; /* Some compilers don't handle it */
	info_count |= *buf++;	  /* properly as a single instuction */

	tot_len -= 46;

	while (--info_count >= 0 && tot_len> 0 )
	{
	   id  = *buf++ & 0xff;
	   len = *buf++ & 0xff;
	   target = NULL;	

	   switch(id)
	   {  case 1: 		/* Track number */
		    /* Take track_no as an unpacked 2-digit decimal */
		    track_no = (*buf - '0') * 10 + (*(buf+1) - '0');
		    break;

	      case 2:		/* Album title */
		    target = disc_name;
		    strcpy(target, "");
		    break;

	      case 6:		/* Track title */
		    if (track_no >= dtrack_first && track_no <= dtrack_last)
		    {   target = trk_info[track_no-dtrack_first].name;	
			  strcpy(target, "");
		    }	
		    break;

	      case 8:		/* Track/disc artist */
	      case 9:
		    if (track_no == 0)
		    		target = disc_artist;	
		    else
		    if (track_no >= dtrack_first && track_no <= dtrack_last)
		    		target = trk_info[track_no-dtrack_first].artist;	
		    if (id == 8) strcpy(target, "");
		    break;


		case 5:
		case 7:
		case 10 ... 14:
		    if (track_no == 0)
		    		target = disc_extra;	
		    else
		    if (track_no >= dtrack_first && track_no <= dtrack_last)
		    		target = trk_info[track_no-dtrack_first].extra;	
		    break;
			
         }
				

	   if (target)
	   {   len1 = strlen(target);
  	       if (len1 > 0 && len1 < DATA_NAME_SIZE-1)
				 target[len1++] = ' ';
		 len2 = DATA_NAME_SIZE-1-len1;
		 if (len2 > 0)
		 {  if (len2 > len) len2 = len; 
		    memcpy(target, buf+len1, len2);
		    *(target+len1+len2) = '\0';
		 }
		 rc = 1;
	   }
			
         len += (len & 1);   /* allign to 16 bit boundary */
	   buf += len;
	   tot_len -= (2 + len);

	}

	return rc;
}

long read_cd_frames(u_long lba, void *buf, long bufsize)
{
/*
	struct cdrom_read rd_struct;
	rd_struct.cdread_lba = lba_in_question+offset;	
	rd_struct.cdread_bufaddr = buf;
	rd_struct.cdread_buflen = CD_FRAMESIZE;  
     	rd_struct.cdread_lba = lba_in_question+15; 
     	if (ioctl(cdrom_fd, CDROMREADMODE1, &rd_struct) >= 0) 
*/

	lba *= CD_FRAMESIZE;
	if (lseek(cdrom_fd, lba, SEEK_SET) != lba) return -1;

	return read(cdrom_fd, buf, bufsize);
}


short process_cdextra(void)
{	
	u_long	lba_in_question = -1;
	u_long	duration, offset = 0;	
	char	buf[CD_FRAMESIZE], *bufptr;
	u_long	outbuf_size;	
	char	*outbuf;
	short	index;
	short	rc;

    /* The following constants are copied from Heiko's source
       code. Can't see any alternative so far   */
	static const u_long offsets[] = {
		75, 		/* this is observed for 12 cm discs */
		60 };		/*         ...  and for  5 cm discs */

	static const short off_size = sizeof(offsets)/sizeof(u_long);

	if(multisession_addr == 0) return 0;	


      /* We have a chance! */
	duration = dtime_total - multisession_addr;
	lba_in_question = multisession_addr - CD_MSF_OFFSET;	/* start of second session */

	bufptr = (u_char *) buf;	
	    
	/* Try your luck with two offsets */
	for (index=0; index < off_size; index++)
	{
 		offset = offsets[index];	
		if (offset >= duration) break;

		/*	  offset = 41; */
		if (read_cd_frames( lba_in_question+offset, buf, CD_FRAMESIZE)
                         == CD_FRAMESIZE)
		{   /* Another idea from cdda2wav.
	               Patching possibly incorrect XA sector handling by 
                       a CD drive. In order to be consistent, we need to
		       provide same logic for all the following frame.
		       The code does not assume this though. */	

		    bufptr = (u_char *)buf;
		    if (*bufptr == 0) bufptr += 8; 
		    if (memcmp(bufptr, "CD", 2) == 0) break;
		                     /* Found CD-EXTRA! */
		}
		/* else
			perror("Error reading CD-EXTRA: "); */
	}

	if (index >= off_size) return 0;
    
	bufptr += 48;  rc = 0;
	for (; *bufptr != '\0'&& bufptr <= (buf+CD_FRAMESIZE-10); bufptr += 10) 
	{	
		outbuf_size = GET_BE_UINT_FROM_CHARP(bufptr+6);
		outbuf = malloc(outbuf_size);
		if (outbuf == NULL) continue;

		/* Get offset */	
		offset = GET_BE_UINT_FROM_CHARP(bufptr+2);
		if (offset == 0xffffffff) offset = offsets[index] + 1;

		/* Read frame(-s) */	  	  
		if (read_cd_frames(lba_in_question+offset, buf, outbuf_size)
                          == outbuf_size)
	        {  /* Parse CD_EXTRA data */	  	  
		   process_cdextra_subinfo((u_char *)outbuf, duration);
		   free(outbuf);
		   rc = 1;
		}
		else
		{  /* Read error */
		   free(outbuf);
		   break;	
		} 
	}

	return rc;
}

#endif   /* def CDEXTRA_SUPPORT */

/* ======================================================= */
struct CD_TYPE_DESCR
{
	u_char	major;
	u_char	*descr;
	int     cd_type;
};

struct CD_TYPE_DESCR CDDevices[] =
{	{ SCSI_CDROM_MAJOR, "SCSI CD ROM", CDTYPE_SCSI},
	{ CDU31A_CDROM_MAJOR, "CDU31A", CDTYPE_OTHER},
	{ GOLDSTAR_CDROM_MAJOR, "GOLDSTAR", CDTYPE_OTHER},
	{ OPTICS_CDROM_MAJOR, "OPTICS", CDTYPE_OTHER},
	{ SANYO_CDROM_MAJOR, "SANYO", CDTYPE_OTHER},
	{ MITSUMI_X_CDROM_MAJOR, "MITSUMI_X", CDTYPE_OTHER},
	{ MITSUMI_CDROM_MAJOR, "MITSUMI", CDTYPE_OTHER},
	{ CDU535_CDROM_MAJOR, "CDU535", CDTYPE_OTHER},
	{ IDE0_MAJOR, "IDE ATAPI", CDTYPE_ATAPI},
#ifdef IDE1_MAJOR    
	{ IDE1_MAJOR, "IDE ATAPI", CDTYPE_ATAPI},
#endif	
#ifdef IDE2_MAJOR    
	{ IDE2_MAJOR, "IDE ATAPI", CDTYPE_ATAPI},
#endif	
#ifdef IDE3_MAJOR    
	{ IDE3_MAJOR, "IDE ATAPI", CDTYPE_ATAPI},
#endif	
	{ MATSUSHITA_CDROM_MAJOR, "PANASONIC", CDTYPE_OTHER},
	{ MATSUSHITA_CDROM2_MAJOR, "PANASONIC", CDTYPE_OTHER},
	{ MATSUSHITA_CDROM3_MAJOR, "PANASONIC", CDTYPE_OTHER},
	{ MATSUSHITA_CDROM4_MAJOR, "PANASONIC", CDTYPE_OTHER},
	{ AZTECH_CDROM_MAJOR, "AZTECH", CDTYPE_OTHER},
	{ CM206_CDROM_MAJOR, "CM206", CDTYPE_OTHER}
};


static void get_cd_description(void)
{   int i;
    int sz = sizeof(CDDevices) / sizeof(struct CD_TYPE_DESCR);
    struct CD_TYPE_DESCR *st;


    st = CDDevices;
    
    for (i=0; i<sz; i++)
    {   if (st->major == CDDeviceType) break;
	st++;
    }

    if (i<sz)
    {  strncpy(cd_description, st->descr, CD_DESCRIPTION_SIZE);
       cd_type = st->cd_type;
    }   
    else
    {
       snprintf(cd_description, CD_DESCRIPTION_SIZE, "Unknown [%d]", CDDeviceType);
       cd_type = CDTYPE_UNKNOWN;
    }       
}

static void get_cd_model(void)
{
    if (cd_type == CDTYPE_ATAPI && get_atapi_model())
				 return;
#if defined(SCSI_SUPPORT)
    else    
    if ( CDDeviceType == SCSI_CDROM_MAJOR && get_scd_model())
				 return;
#endif

    strcpy(cd_model, "");

}

/* ======================================================= */
void init_features(int cdr_fd)
{

    cdrom_fd = cdr_fd;
    
    get_cd_description();
    strcpy(cd_model, "");
    strcpy(sg_name, "");

    if (cd_type > CDTYPE_ATAPI) return;

    type_confirmed = 0;	
    ExtensionType = "none";

#if defined(SCSI_IOCTL_GET_IDLUN) && defined(SCSI_SUPPORT)
    if (cd_type == CDTYPE_SCSI) 
	get_scsi_parameters();
#endif

/* I submitted the patch to Doug Gilbert, regarding introducing
   SCSI_IOCTL_EMULATED_HOST as opposed to SG_EMULATED_HOST.
   The new ioctl will lie in mid-layer, and will be accessible
   by all SCSI drivers, no only SG. Still no answer from Doug...
   The patch is supplied with the package (not to forget!)
*/   

#if defined(SCSI_SUPPORT) && defined(SCSI_IOCTL_EMULATED_HOST)
    { int emu;
      if (ioctl(cdrom_fd, SCSI_IOCTL_EMULATED_HOST, &emu) >= 0)
      { if (emu) set_scsi_emulation();
        type_confirmed = 1;
      }
    }
#endif	  	

#if defined(HAVE_CD_EXTENSION)
    init_extensions();
#ifdef USE_SAMPLE_DATA
    cdtext_sample[0] = ((sizeof(cdtext_sample)-2) >> 8) & 0xff;   /* Buffer size MSB */
    cdtext_sample[1] =   (sizeof(cdtext_sample)-2) & 0xff;       /* Buffer size LSB */
#endif
#endif	 
   
    get_cd_model();
}        
    

void deinit_features(void)
{
#if defined(HAVE_CD_EXTENSION)
     deinit_extensions();
#endif	 
}

