 /* ==========================================================
    SING - ALONG DISK PLAYER.  (C) 1998, Michael Glickman        
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
    
            You are expected to provide appropriate references
            when using a part of the code in your software. 

		Author strongly advices against using this code, or
		a part of it, in an application designed to run  on
		any Microsoft(tm) platfrom.
    ========================================================= */


#include <sys/types.h>
#include <curses.h>
#include "sad.h"
#include "sadp_curses.h"

#if GPM_SUPPORT
#include <sys/time.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <string.h>

#include <unistd.h>
#include <fcntl.h>
#include <gpm.h>

#if !defined(GPM_EVENT_EXT) || USE_RPM
#define Gpm_EventExt  Gpm_Event
#endif 

#if !defined(GPM_WHEEL) || USE_RPM
#define Gpm_GetEventExt  Gpm_GetEvent
#define Gpm_GetSnapshotExt Gpm_GetSnapshot
#endif

/*static int  gpm_pointer; */
static int IsMouseEvent;

static Gpm_EventExt MouseEvent;    
static mmask_t ButtonMask;

extern int	ScreenW, ScreenH;
extern int	current_tty;
extern int	ttyno;


void mouse_gpm_drawpointer(void)
{
	if (current_tty && ttyno >= 0)
       Gpm_DrawPointer(MouseEvent.x, MouseEvent.y, gpm_consolefd); 
}

void ProceedPressedButtons(int MouseB)
{ 
    mmask_t NewButtonMask = 0;

     if (MouseB & GPM_B_LEFT) 
     {  if (!(ButtonMask & BUTTON1_PRESSED))  NewButtonMask |= BUTTON1_CLICKED;
        NewButtonMask |= BUTTON1_PRESSED;
     }
  	

     if (MouseB & GPM_B_MIDDLE)
     {  if (!(ButtonMask & BUTTON2_PRESSED))  NewButtonMask |= BUTTON2_CLICKED;
        NewButtonMask |= BUTTON2_PRESSED;
     }


     if (MouseB & GPM_B_RIGHT)
     {  if (!(ButtonMask & BUTTON3_PRESSED))  NewButtonMask |= BUTTON3_CLICKED;
        NewButtonMask |= BUTTON3_PRESSED;
     }

     ButtonMask = NewButtonMask;

}

void ProceedReleasedButtons(int MouseB)
{ 
     if (MouseB & GPM_B_LEFT)
        ButtonMask &= ~(BUTTON1_PRESSED | BUTTON1_CLICKED);

     if (MouseB & GPM_B_MIDDLE)
        ButtonMask &= ~(BUTTON2_PRESSED | BUTTON2_CLICKED);

     if (MouseB & GPM_B_RIGHT)
        ButtonMask &= ~(BUTTON3_PRESSED | BUTTON3_CLICKED);

}


void mouse_gpm_deinitialize(void)
{
    while (Gpm_Close()); /* close all the stack */

}


int gpm_getch(void) 
{
   int key;	
	 Gpm_EventExt mevnt;


   key = getch();
   if (key != ERR) return key;
		
   fcntl(gpm_fd, F_SETFL, O_NDELAY );
   IsMouseEvent = (Gpm_GetEventExt(&mevnt) > 0);


   if (IsMouseEvent)
   {
		 memcpy(&MouseEvent, &mevnt, sizeof(Gpm_Event));
     if (MouseEvent.type & GPM_MOVE)
					mouse_gpm_drawpointer();

     if (MouseEvent.type & GPM_UP)
        ProceedReleasedButtons(MouseEvent.buttons);
		 

     ButtonMask &= ~(BUTTON4_CLICKED | BUTTON4_RESERVED_EVENT |
                     BUTTON5_CLICKED | BUTTON5_RESERVED_EVENT);

#if !USE_RPM
# ifdef GPM_FWHEEL
			if (MouseEvent.type & GPM_FWHEEL)
			{	 ButtonMask |= BUTTON4_CLICKED;
				 return KEY_MOUSE;
			}
# endif

# ifdef GPM_BWHEEL
			if (MouseEvent.type & GPM_BWHEEL)
			{	 ButtonMask |= BUTTON4_RESERVED_EVENT;
				 return KEY_MOUSE;
			}
# endif

# ifdef GPM_FWHEEL2
			if (MouseEvent.type & GPM_FWHEEL2)
			{	 ButtonMask |= BUTTON5_CLICKED;
				 return KEY_MOUSE;
			}
# endif

# ifdef GPM_BWHEEL2
			if (MouseEvent.type & GPM_BWHEEL2)
			{	 ButtonMask |= BUTTON5_RESERVED_EVENT;
				 return KEY_MOUSE;
			}
# endif
#endif

     if (MouseEvent.type & GPM_DOWN)
     {	 ProceedPressedButtons(MouseEvent.buttons);
         return KEY_MOUSE;
     }

   }
 
   return ERR;

}		 

int gpm_getmouse(MEVENT *mevent)
{ 
	int bstate;

	mevent->id = gpm_fd;
	mevent->x = MouseEvent.x;
	mevent->y = MouseEvent.y;
	mevent->z = 0;

	bstate = ButtonMask;	  

	if (ButtonMask)
	{  int shift = get_kbd_shift();
	   if (shift & 1) bstate |= BUTTON_SHIFT;		 			   if (shift & 4) bstate |= BUTTON_CTRL;
	}
	mevent->bstate = bstate;	  

	return (ButtonMask != 0);
}	 

int mouse_gpm_initialize(void)
 {   Gpm_Connect conn;


     conn.eventMask=~0 ;
     conn.defaultMask=~GPM_HARD;
     conn.maxMod=~0;
     conn.minMod= 0;
	   
     gpm_mx = ScreenW;
     gpm_my=  ScreenH;

     gpm_visiblepointer = 0;
/*     gpm_pointer = open ("/dev/console", O_RDWR); */
     ButtonMask = 0;
     if (Gpm_Open(&conn, 0) !=-1)
     { 
        Gpm_GetSnapshotExt(&MouseEvent);
			  ProceedPressedButtons(MouseEvent.buttons);
			  IsMouseEvent = 0;
			  return 1;
     }

     return 0;
}

#endif

int native_getmouse(MEVENT *event)
{
    mmask_t bstate;
//    static mmask_t oldstate = 0;
    
    if (getmouse(event) != OK) return 0;


    bstate = event->bstate;
    
    if (bstate & BUTTON1_PRESSED) //  && !(oldstate & BUTTON1_PRESSED))
			     bstate |= BUTTON1_CLICKED;

    if (bstate & BUTTON2_PRESSED) //  && !(oldstate & BUTTON2_PRESSED))
			     bstate |= BUTTON2_CLICKED;
			     
    if (bstate & BUTTON3_PRESSED) //  && !(oldstate & BUTTON3_PRESSED))
			     bstate |= BUTTON3_CLICKED;

#if defined(BUTTON4_PRESSED)
    if (bstate & BUTTON4_PRESSED) //  && !(oldstate & BUTTON4_PRESSED))
			     bstate |= BUTTON4_CLICKED;
#endif
  
//    oldstate = event->bstate;    
    event->bstate = bstate;

    (event->x) ++;
    (event->y) ++;
    
    return 1;
}    	

