 /* ========================================================== 
    SING - ALONG DISK PLAYER. 
    (C) 1998 - 2000   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
  
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ---------------------------------------------------------
    sadp_iconctl.c - started 31-Dec-99,
                  the last day of the millennium ! 	    
    ========================================================= */

#include <forms.h>
#include <sys/time.h>
#include <linux/cdrom.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "sad.h"
#include "sadp_xforms.h"

#ifdef  ICON_WINDOW_SUPPORT


extern	Window	MainWnd, IconWnd;
extern	int 	ScreenW, ScreenH, ScreenD, ScreenVC;
extern  Display *disp;
extern  ICON_STYLE_TYPES IconStyle;
extern  TIME_DISPLAY_MODE_TYPE TimeDisplayMode;
extern  TRACK_INFO  *trk_info;
extern  char disc_name[], disc_artist[], disc_extra[];
extern  short	cd_multi_artist;
extern  Pixmap	IconPmp, DimPmp;

GC	IconGC;
short   IconSpectrY = 15, IconSpectrH = 21;
short 	IconWid = 48, IconHei = 48;
short   HighlightIconButtons = 1;

/*extern  char	*control_xpm[]; */
extern  unsigned char icon_control_bits[];
extern	short  FourWndCount;
extern  u_char  track_cur;
extern  u_char  cd_status;
extern  FL_FORM *MainFrm;
extern  char    IconStyleBG;

static  Pixmap	IconControlBmp;
static  Colormap IconColmap;

extern u_char cd_status;  
extern u_char track_first, track_last, track_cur;
extern u_long track_time_start, track_time_end;
extern u_long time_start, time_total, time_cur, time_req;
extern u_char dtrack_first, dtrack_last;   /* First & last tracks on disk */
extern short  no_cd;
extern short  TooltipTimeout1, TooltipTimeout2, TooltipTimeout3;
extern short  BottomSection;


static  XFontStruct *NormalXfs; 
/* static  XFontStruct *BoldXfs;  */
/* static  int TextHei; */

static  Atom protocols_atom=None, delete_atom=None;
static  short need_init_form, icon_visible;
static  short progind_current;
static  short need_top_clean = 1;
static long last_elapsed = -1;
static int  old_progress[2] = {-1, -1};
static int  old_track_no = -1;


static long bgcol, bgcol1, bgcol2, bgcol3, hicol, hicol1, hicol3, trkcol;
static long topcol, btmcol, leftcol, rightcol;
static u_long icon_nonaudio_fg, icon_nonaudio_bg;
static long topcol, btmcol, leftcol, rightcol;

static Cursor IconNormCursor = None, WaitCursor = None;

static short cur_icon_obj = -1;    /* Current control index  in icon_obj_list  */


#define TrkNoX  33
#define TrkNoY   2
#define TrkNoW  15
#define TrkNoH  10

#define ProgBarY1  0
#define ProgBarY2  3
#define ProgBarX   0
#define ProgBarW   30
#define ProgBarH   2
#define ProgX      0
#define ProgY      7
#define ProgX      0
#define ProgY      7


#define  BottomY    40
#define  StopButtonX 15
#define  PlayButtonX 22
#define  BottomH    7

typedef  struct icon_object_struct icon_obj;
typedef  struct icon_button_struct icon_btn;

typedef  void  (*icon_callback)(icon_obj *is, XEvent *xev);

struct  icon_object_struct
{	int x, y, w, h;
	icon_callback event_proc;
	short  tag, btn_ind;
	char *tooltip;
};		

static  void  icon_progbar_callback(icon_obj *is,  XEvent *xev);
static  void  icon_progind_callback(icon_obj *is,  XEvent *xev);
static  void  icon_bottom_callback(icon_obj *io, XEvent *xev);
static  void  icon_misc_callback(icon_obj *io, XEvent *xev);


icon_obj  icon_obj_list[] = 
{
    /* 0 */
   { ProgBarX, ProgBarY1, ProgBarW, ProgBarH,
     icon_progbar_callback,
     1, -1,
     "Disc Progress Bar: click to change track"
   },
        	
    /* 1 */
   { ProgBarX, ProgBarY2, ProgBarW, ProgBarH,
     icon_progbar_callback,
     0, -1,
     "Track Progress Bar: click to move within current track"
   },
    
    /* 2 */
   { ProgX, ProgY, 4, 5,
     icon_progind_callback,
     -1, -1,
     "Time display mode: click to select previous mode"
   },

    /* 3 */
   { ProgX+4, ProgY, ProgBarW-8, 5,
     icon_progind_callback,
     0, -1,
     "Position Indicator: click to toggle disc/track progress"
   },

    /* 4 */
   { ProgX+ProgBarW-3, ProgY, 4, 5,
     icon_progind_callback,
      1, -1,
     "Time display mode: click to select next mode"
   },

    /* 5 */
   { 7, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_PREV , 1,
     "Previous track/Backward(Shift or Right)/First Track(Ctrl or Middle)"
   },

    /* 6 */
   {14, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_STOP , 2,
     "Stop/Eject/Load"
   },

    /* 7 */
   {21, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_PLAY , 3,
     "Play/Pause/Resume"
   },

    /* 8 */
   {28, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_QUIT, 4,
     "Quit (Use Shift or Right mouse button to quit with stop)"
   },

    /* 9 */
   {35, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_NEXT , 5,
     "Next track/Forward(Shift or Right)/Last Track(Ctrl or Middle)"
   },

#ifdef DSP_SUPPORT
    /* 10 */
   { 0, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_HELPPREV, 0,
     "Previous display page"
   },

    /* 11 */
   {42, BottomY, 6, BottomH,
     icon_bottom_callback,
     OPER_HELPNEXT, 6,
     "Next display page"
   },
#endif

    /* 12 */
   {TrkNoX, TrkNoY, TrkNoW, TrkNoH,
     icon_misc_callback,
     0, -1,
     "Track number, click to show/hide main window"
   }



};

static const int icon_obj_count = sizeof(icon_obj_list)/sizeof(icon_obj);

struct  icon_button_struct
{
	short bmp_index;    /* Index in bitmap */
	short obj_index;    /* Index in icon object struct */
	int   fl_colour;    /* Colour entry in XForms palette */
};		


icon_btn icon_btn_list[] =
    { 
#ifdef DSP_SUPPORT
	{ 0, 10, FL_CYAN },        /* Prev panel */
#else
	{ 8,  0, FL_CYAN },        /* Unused  */
#endif	
	
	{ 1,  5, SADP_YELLOW},     /* Prev track / Back */
	{ 6,  6, FL_DEEPPINK},     /* Stop/Eject/Load */
	{ 10, 7, FL_SPRINGGREEN},  /* Play/Pause/Resume */
	{ 2,  8, FL_DEEPPINK},     /* Quit */
	{ 3,  9, SADP_YELLOW},     /* Next track / Forward */
#ifdef DSP_SUPPORT
	{ 4, 11, FL_CYAN}          /* Next panel */
#else
	{ 8,  0, FL_CYAN}          /* Unused */
#endif	
    };	 

static const int icon_btn_count = sizeof(icon_btn_list)/sizeof(icon_btn);


#define STOP_BTN_INDEX 2
#define STOP_BMP_START 5
#define PLAY_BTN_INDEX 3
#define PLAY_BMP_START 8

static XImage  *nonaudio_img = NULL;     
static XImage  *nodisc_img = NULL;
static Pixmap  msg_bitmap = None;
static int nonaudio_bmp_wid;     
static int nonaudio_bmp_hei;     
static struct timeval next_shift_time, next_msg_time;
static short  shift_key_press, ctrl_key_press;
static short  no_cd_old =  -66;
static u_char nonaudio_old_track = 0xff;
static int   offset=0;

#define SHIFT_STILL_INTERVAL 120000
#define SHIFT_PLAY_INTERVAL   50000

enum MSG_STATE
{   MSG_STATE_NONE,
    MSG_STATE_WAITING,
    MSG_STATE_COMING,
    MSG_STATE_SEEN,
    MSG_STATE_HIDING,	/* Will re-appear */
    MSG_STATE_GOING	/* Won't re-appear */
} msg_state;

enum MSG_TYPE
{   MSG_TYPE_TOOLTIP,
    MSG_TYPE_TRACKNAME,
    MSG_TYPE_OTHER
} msg_type;

short msg_cur_height, msg_cur_wait;
int   msg_offset, msg_width, msg_height, msg_frame_width;
static	short inter_val, inter_val_incr;    /* Guess what: interlace value */

static void launch_icon_message(const char *msg, enum MSG_TYPE new_msg_type);
static void select_nonaudio_colours(void);
static void launch_track_start_message(void);
static short launch_tooltip_message(void);
/* static void  stretch_icon(void); */

#define MSG_MAX_HEIGHT 8            
#define SHIFT_MSG_INTERVAL   80000
#define MAX_INTER_VAL  20

static void show_icon_button(short ind)
{
    int sx, sy; /* Source */
    int tx;     /* Target */
    icon_btn  *icon_btn_ptr;

    unsigned long colour_code;
    int    tmp;

    icon_btn_ptr = icon_btn_list + ind;
    
    sx = icon_btn_ptr->bmp_index * 6;

    if (shift_key_press) sy = 5;
    else
    if (ctrl_key_press) sy = 10;
    else sy = 0;
    
    tx = ind * 7;

    colour_code = fl_getmcolor(icon_btn_ptr->fl_colour, &tmp, &tmp, &tmp);
    XSetBackground(disp, IconGC, colour_code); 

    colour_code = (icon_btn_ptr->obj_index == cur_icon_obj) ? bgcol2 : bgcol;   
    XSetForeground(disp, IconGC, colour_code); 

    XCopyPlane(disp, IconControlBmp, IconWnd, IconGC,
 	       sx, sy, 6, 5, tx, BottomY+1, 1); 
}

static void show_all_icon_buttons(void)
{
    int i, x, y;
    unsigned long sep_col;

    /* Two bottom horizontal lines */
    y = BottomY-1;
    x = IconWid;

    if (shift_key_press) sep_col = hicol1;
    else
    if (ctrl_key_press) sep_col = hicol;
    else sep_col = trkcol;

    XSetForeground(disp, IconGC, bgcol);
    XFillRectangle(disp, IconWnd, IconGC, 0, y, x, IconHei-y);

    XSetForeground(disp, IconGC, sep_col); 

    XDrawLine(disp, IconWnd, IconGC, 0, y, x, y);
    y = BottomY+BottomH;
    XDrawLine(disp, IconWnd, IconGC, 0, y, x, y);


    for (i=0; i<icon_btn_count; i++)
    {
	   if (i>0)
	   {
	      /* Vertical separator */
	      XSetForeground(disp, IconGC, sep_col);
	      x = 7*i-1;	        
	      XDrawLine(disp, IconWnd, IconGC, x, BottomY, x, y);
	   }    	   
           show_icon_button(i);
    }	   

}

void set_icon_stop_button(short ind)
{
    icon_btn  *icon_btn_ptr;

    if (IconGC == None || HighlightIconButtons == 0 || 
        IconWnd == None || IconControlBmp == None) return;
    

     icon_btn_ptr = icon_btn_list + STOP_BTN_INDEX;
     icon_btn_ptr->bmp_index = STOP_BMP_START + ind;
     show_icon_button(STOP_BTN_INDEX);

     icon_btn_ptr = icon_btn_list + PLAY_BTN_INDEX;
     icon_btn_ptr->bmp_index = PLAY_BMP_START + ind;
     icon_btn_ptr->fl_colour = (ind == 2) ? FL_SPRINGGREEN: FL_DEEPPINK;
     show_icon_button(PLAY_BTN_INDEX);

}		

void  clear_icon_top(vold)
{
    XSetForeground(disp, IconGC, bgcol1);
    XFillRectangle(disp, IconWnd, IconGC, 0, 0, IconWid, IconSpectrY);

    /* Clear progress window */
    XSetForeground(disp, IconGC, bgcol);
    XFillRectangle(disp, IconWnd, IconGC, 0, ProgBarY1, ProgBarW+1, ProgY+6);

    /* Clear track number window */
    XSetForeground(disp, IconGC, bgcol);
    XFillRectangle(disp, IconWnd, IconGC, TrkNoX-1, TrkNoY-1, TrkNoW, TrkNoH+2);

	old_track_no = -1;	
	old_progress[0] = old_progress[1] = -1;
}

static void init_icon_window(void)
{
    
    if (IconGC == None || 
        IconWnd == None || IconControlBmp == None) return;

    XSetForeground(disp, IconGC, bgcol1);
    XFillRectangle(disp, IconWnd, IconGC, 0, IconSpectrY, IconWid, IconHei-IconSpectrY-BottomH-2);

    clear_icon_top();
	if (track_cur != 0xff) 
	  draw_icon_track_number(track_cur);
	else
	  clear_icon_time();	  

    show_all_icon_buttons();
    
    cur_icon_obj = -1;
}

/* Called just after the IconWnd was created */
void icon_control_init(void)
{
    XGCValues	xgcv;
    Window parent;
    XClassHint classHint;
    XSetWindowAttributes xwa;
    unsigned long value_mask;
    int    tmp;
    

/*    IconControlPmp = fl_create_from_pixmapdata(MainWnd, control_xpm,
		     &tmp, &tmp, NULL, NULL, NULL, 0);  */
		     
    IconControlBmp = XCreateBitmapFromData(disp, MainWnd, icon_control_bits, 66, 15);
    IconWid = IconHei = 48;

    if (! IconControlBmp) return;

    if (IconStyle == ICONSTYLE_DUAL) {
      need_init_form = 1;
      parent = fl_root;
    } else {
	  need_init_form = 0;
      parent = MainWnd;
    }
/*  Set ion size for main window - doesn't seem to work though
    { XIconSize *std_sizes, *our_sizes;
			int count;

			need_init_form = 0;
      parent = MainWnd;
			if (!XGetIconSizes(disp, fl_root, &std_sizes, &count)) {
				count = 0;
				std_sizes = NULL;
			}
			our_sizes = malloc((count+1) * sizeof(XIconSize));
			if (our_sizes && std_sizes)
	    	memcpy((void *)(our_sizes+1), std_sizes, count*sizeof(XIconSize));
			if(std_sizes) XFree(std_sizes);
			if (our_sizes) {
		 		our_sizes[0].min_width = our_sizes[0].min_height = 48;
		 		our_sizes[0].max_width = our_sizes[0].max_height = 64;
		 		our_sizes[0].width_inc = our_sizes[0].height_inc = 4;
				XSetIconSizes(disp, fl_root, our_sizes, count+1);
				XSetIconSizes(disp, parent, our_sizes, count+1);
				free(out_sizes);
			}		  
    }
*/    
    
    bgcol = fl_getmcolor(SADP_BLACK, &tmp, &tmp, &tmp); 
    hicol = fl_getmcolor(FL_DEEPPINK, &tmp, &tmp, &tmp);
    hicol1 = fl_getmcolor(SADP_YELLOW, &tmp, &tmp, &tmp);
    hicol3 = fl_getmcolor(FL_DARKGOLD, &tmp, &tmp, &tmp);
    trkcol = fl_getmcolor(FL_SPRINGGREEN, &tmp, &tmp, &tmp);
    bgcol1 = fl_getmcolor(FL_COL1, &tmp, &tmp, &tmp);
    bgcol2 = fl_getmcolor(FL_MCOL, &tmp, &tmp, &tmp); 
    bgcol3 = fl_getmcolor(FL_CYAN, &tmp, &tmp, &tmp); 
    topcol = fl_getmcolor(FL_BOTTOM_BCOL, &tmp, &tmp, &tmp); 
    leftcol = fl_getmcolor(FL_RIGHT_BCOL, &tmp, &tmp, &tmp); 
    btmcol = fl_getmcolor(FL_TOP_BCOL, &tmp, &tmp, &tmp); 
    rightcol = fl_getmcolor(FL_LEFT_BCOL, &tmp, &tmp, &tmp); 

    select_nonaudio_colours();

    WaitCursor = XCreateFontCursor(disp, XC_watch);
    IconNormCursor = XCreateFontCursor(disp, XC_top_left_arrow); /* _left_ptr); */


    value_mask = CWBackingStore | CWCursor;
    xwa.backing_store = Always;
    xwa.cursor = IconNormCursor;

    IconColmap = (fl_state+ScreenVC)->colormap;
    if (IconColmap != None) 
    {	xwa.colormap = IconColmap;
		value_mask |= CWColormap;
    }	



    IconWnd = XCreateWindow(disp, parent, 0, ScreenH - IconHei - 110, IconWid, IconHei,
                  1, CopyFromParent, InputOutput, CopyFromParent, value_mask, &xwa);
 
    if (!IconWnd) return;		 

    if (IconStyle == ICONSTYLE_DUAL )
    {	XSizeHints xsh;
    
        XSetTransientForHint(disp, IconWnd, fl_root);
		xsh.min_width = xsh.max_width = IconWid;	
		xsh.min_height = xsh.max_height = IconHei;
 /*	xsh.win_gravity = NorthEastGravity;   */
		xsh.flags = PMinSize | PMaxSize; /* | PWinGravity; */
		XSetWMNormalHints(disp, IconWnd, &xsh);


   /*	XRaiseWindow(disp, IconWnd);	 */
    /*	XReparentWindow(disp, MainWnd, 	IconWnd, 0, 0); */
		
    }	
	
    protocols_atom = XInternAtom(disp, "WM_PROTOCOLS", True);
    delete_atom =  XInternAtom(disp, "WM_DELETE_WINDOW", True);
    if (protocols_atom != None && delete_atom != None)
          XSetWMProtocols(disp, IconWnd, &delete_atom, 1);

    classHint.res_name =  "xsadp";
    classHint.res_class = "XSadp";
    XSetClassHint(disp, IconWnd, &classHint);


    value_mask =  ButtonPressMask | PointerMotionMask |
	          EnterWindowMask | LeaveWindowMask | VisibilityChangeMask; // | StructureNotifyMask | KeyPressMask | ExposureMask); */
    if (IconStyle == ICONSTYLE_DUAL) value_mask |= KeyPressMask; 
    XSelectInput(disp, IconWnd, value_mask);
    xgcv.graphics_exposures = False;
    xgcv.line_style = LineSolid;
    xgcv.line_width = 1;

    NormalXfs = fl_get_fontstruct(FL_NORMAL_STYLE, FL_TINY_SIZE);
/*    BoldXfs = fl_get_fontstruct(FL_BOLD_STYLE, FL_TINY_SIZE); */
    xgcv.font = NormalXfs->fid;    

    IconGC = XCreateGC(disp, IconWnd,
		       GCGraphicsExposures | GCLineWidth | GCLineStyle | GCFont,
		       &xgcv);

/*    stretch_icon(); */

	icon_visible = 0;
    fl_add_event_callback(IconWnd, 0, icon_control_callback, NULL);
    progind_current = 0;


}

void icon_control_deinit(void)
{
    if (IconControlBmp) XFreePixmap(disp, IconControlBmp);
    if (IconGC) XFreeGC(disp, IconGC);
    if (IconNormCursor) XFreeCursor(disp, IconNormCursor);
    if (WaitCursor) XFreeCursor(disp, WaitCursor);
    if (nonaudio_img) XDestroyImage(nonaudio_img);
    if (nodisc_img) XDestroyImage(nodisc_img);
    if (msg_bitmap) XFreePixmap(disp, msg_bitmap);
}

static void draw_icon_digit(short digit, int x, int y, short scale, 
                             long fgcolour, long bgcolour, short *advance)
{
   short i, j;
   int  x2,y2;
   short digt, mask, adv;
   long colour;

   /* Spec "digits":
       space  = 10  colon    = 11
       dot    = 12  per cent = 13
       less   = 14  greater  = 15
       equal  = 16  narrow space = 17
    */
       	       
   static short texture[] =
       {075557, 026227, 071747, 071617, 045711,
        074717, 074757, 071111, 075257, 075717,
	    000000, 004040, 000004, 051245, /* space, colon, dot, % */
	    012421, 042124, 007070, 000000  /* less, greater, =, nar space */
       };

   static short advances[] =
       { 4, 4, 4, 4, 4,
         4, 4, 4, 4, 4,
	    //Special
	     4, 2, 2, 4,
	     4, 4, 4, 2
	   };


    digt = texture[digit];
    mask = 0x4000;

    y2 = y;
    adv = advances[digit];
    for (j=0; j<5; j++)
    {  x2 = x;
       for (i=0; i<3; i++)
       {   colour = (digt & mask) ? fgcolour : bgcolour;
           XSetForeground(disp, IconGC, colour);
           XFillRectangle(disp, IconWnd, IconGC, x2, y2, scale, scale);
           mask >>= 1;
	   x2 += scale;
       }
       
       if (advance)
       {  XSetForeground(disp, IconGC, bgcolour);
          XFillRectangle(disp, IconWnd, IconGC, x2, y2, scale, scale);
       }		  

       y2 += scale;
    }

    if (advance)  *advance = adv;
}

void  draw_icon_char(char c, int x, int y, short scale, 
                             long fgcolour, long bgcolour, short *advance)
{
    short digit;			
    static const char *spec = " :.%<>=-";
    char *pos;
    
    if (c>='0' && c<='9')
	digit = (short) c - '0';
    else
    if ((pos = strchr(spec, c)) != NULL)
          digit = (short)(pos - spec) + 10; 
    else digit = 10;

    draw_icon_digit(digit, x, y, scale, fgcolour, bgcolour, advance);

}

void draw_icon_track_number(short trackno)
{

    if (icon_visible == 0 || trackno == old_track_no) return; 

    draw_icon_digit(trackno/10, TrkNoX, TrkNoY, 2, trkcol, bgcol, NULL);
    draw_icon_digit(trackno%10, TrkNoX+7, TrkNoY, 2, trkcol, bgcol, NULL);

    old_track_no = trackno;

}

static void show_icon_progress_bar(long elapsed, long duration, int y, long colour, int ind)
{    int progress, w, x;

    if (icon_visible == 0) return;
//	if (! win_visibility(IconWnd)) return;
	
    if (duration == 0) progress = 0;
    else progress = (int) ((elapsed * ProgBarW) / duration);    

    if (progress >= ProgBarW) progress = ProgBarW-1;

    if (progress == old_progress[ind]) return;
    old_progress[ind] = progress;
    
    x = ProgBarX;
    if (progress > 0)
    {  XSetForeground(disp, IconGC, colour);
       XFillRectangle(disp, IconWnd, IconGC, x, y, ProgBarW, ProgBarH);
    }   

    x += progress;
    XSetForeground(disp, IconGC, hicol);
    XFillRectangle(disp, IconWnd, IconGC, x, y, 1, ProgBarH);

    x++;
    w = ProgBarW-progress;
    if (w > 0)
    {  XSetForeground(disp, IconGC, colour);
       XFillRectangle(disp, IconWnd, IconGC, x, y, w, ProgBarH);
    }   
    
}

void show_icon_progress(long elapsed, long duration, int ind)
{
    int x;	
    char text[10], *txtp;
    short c, c1;
    u_int progress;
    

//    int  mins, secs, frm;
    u_char  mins, secs, frm;
    long fgcol;


    if (track_cur == 0xff)
    {  if (need_top_clean)
          clear_icon_time();
       return;
    }       		    


        
    last_elapsed = elapsed;
    

    fgcol = fl_getmcolor(ind ? SADP_YELLOW : FL_SPRINGGREEN, &x, &x, &x);

    x = ind ? ProgBarY1: ProgBarY2;	

    show_icon_progress_bar(elapsed, duration, x, fgcol, ind);
    

    if (ind != progind_current) return;


    switch(TimeDisplayMode)
   {  case DM_ELAPSED:   
	    time_to_msf(elapsed, &mins, &secs, &frm);
	    sprintf(text,"=%02u:%02u.%d=",(u_int)mins, (u_int)secs, 10*frm/75);
	    break;

      case DM_REMAINED:  
	    time_to_msf(duration-elapsed, &mins, &secs, &frm);
	    sprintf(text,"<%02u:%02u.%d>",(u_int)mins, (u_int)secs, 10*frm/75);
	    break;

      case DM_PROGRESS:  
	    progress =  elapsed * 1000 / duration;
	    sprintf(text,"=%3u.%01u%%-=",  progress/10, progress%10 );
            break;

      case DM_PROGREM:  
	    progress =  (duration-elapsed) * 1000 / duration;
            sprintf(text,"<%3u.%01u%%->", (progress/10), progress%10  );
            break;


      default:
	    sprintf (text, "     DM = %d", TimeDisplayMode); 
    }

    mins = secs = 0;
    time_to_msf(elapsed, &mins, &secs, &frm);

    txtp = text;
    x=ProgX;

    c = *txtp++;
    if (c == '\0') return;
    
    while(1)
    {	
       c1 = *txtp++;	
       draw_icon_char(c, x, ProgY, 1, fgcol, bgcol, c1=='\0' ? NULL : &c);
       if (c1 == '\0') break;
       x += c;
       c = c1;
    }
    
}

static void icon_progind_callback(icon_obj *io, XEvent *xev)
{
    short tag = io->tag;
    
    if (tag == 0)
       progind_current ^= 1;
    else
       TimeDisplayMode = (TimeDisplayMode+4+tag) % 4;

    show_icon_progress(time_cur, time_total, progind_current);
}

static void icon_progbar_callback(icon_obj *io, XEvent *xev)
{
    long starting_point, duration;
    long progress;    
    OPERATION oper;    
 
    progress = (long)((xev->xbutton).x - io->x); 

    if (io->tag)
    {  starting_point =  time_start;
       duration = time_total - time_start;
       oper = OPER_PLAYFROMALIGNED;
    }
   else
   {  starting_point =  track_time_start;
      duration = track_time_end - track_time_start;
      oper = OPER_PLAYFROM;
   }
   
   time_req = (progress * duration / ProgBarW) + starting_point;
   cdaudio_operate(oper); 
}

static void icon_bottom_callback(icon_obj *io, XEvent *xev)
{
    OPERATION oper;

    oper  = (OPERATION) io->tag;


#ifdef DSP_SUPPORT
    if (oper == OPER_HELPPREV)
    {
       if(BottomSection >= FOLDER_DATA)
            set_bottom_section(FOLDER_WAVE);
       else
       if(BottomSection > 0)
            set_bottom_section(BottomSection-1) ; 
       else
    	    stupid_beep();   
		    
    }
    else
    if (oper == OPER_HELPNEXT)
    {
       if(BottomSection < FOLDER_DATA) set_bottom_section(BottomSection+1); 
       else stupid_beep();   
    }
#else
    if (oper == OPER_HELPPREV || oper == OPER_HELPNEXT);
#endif
    else
    {  if (xev->xbutton.button == Button3 || shift_key_press)
       {  if (oper == OPER_NEXT ) oper = OPER_FWD;
          else
          if (oper == OPER_PREV) oper = OPER_BACK;
	  else
          if (oper == OPER_QUIT) oper = OPER_STOPQUIT;
       }
       else
       if (xev->xbutton.button == Button2 || ctrl_key_press)
       {  if (oper == OPER_NEXT ) oper = OPER_LASTTRACK;
          else
          if (oper == OPER_PREV) oper = OPER_FIRSTTRACK;
       }

       	    
       cdaudio_operate(oper);
    }       

    if (oper == OPER_QUIT || oper == OPER_STOPQUIT)
    { xforms_close_routine(NULL, NULL);
      exit(0);
    }
}

/* Currently works for show/hide main window only */
static  void  icon_misc_callback(icon_obj *io, XEvent *xev)
{

      if (win_visibility(MainWnd))
	  XWithdrawWindow(disp, MainWnd, fl_screen);
      else		 
      if (need_init_form)
      {   fl_show_form_window(MainFrm); 
          need_init_form = 0;
      }
      else	
          XMapWindow (disp, MainWnd);

}


static int check_icon_objects(XEvent *xev)
{
    int x, y, dx, dy, i;
    short old_obj, rc;
    icon_obj *io;    

    rc= 0;
    old_obj = cur_icon_obj;
    cur_icon_obj = -1;

    if (xev->type == LeaveNotify)
	   goto DoppoQuesto;
        
    x = (xev->xbutton).x;
    y = (xev->xbutton).y;

    
    for (i=0; i<icon_obj_count; i++)
    {   io = icon_obj_list+i;  
     
        dx = x - io->x;
	if (dx < 0 || dx >= io->w) continue;
	
        dy = y - io->y;
	if (dy < 0 || dy >= io->h) continue;
    
	cur_icon_obj = i;
	rc = 1;
        break;   
    }	
	
 DoppoQuesto:
    if (old_obj != cur_icon_obj)
    {   
        if (old_obj >= 0)
	{  io = icon_obj_list+old_obj;  
	   y = io->btn_ind;
           if (HighlightIconButtons && y>=0)  show_icon_button(y); 
	}	   

   
    	if (cur_icon_obj >= 0)
	{  io = icon_obj_list+cur_icon_obj;   	
	   y = io->btn_ind;
	   if (HighlightIconButtons && y>=0)  show_icon_button(y); 
	   launch_tooltip_message();
	}	    
	else
	if(msg_type == MSG_TYPE_TOOLTIP)
	/* Hide old tooltip */		    
	{  if (msg_cur_height > 0)
		msg_state = MSG_STATE_GOING;
	    else
	        msg_state = MSG_STATE_NONE;
	}	    

    }	

    return rc;
}

static void implement_cur_object(XEvent *xev)
{
    icon_obj *io;    
    
    if (cur_icon_obj >= 0) 
    { 
        io = icon_obj_list + cur_icon_obj;      
	XDefineCursor(disp, IconWnd, WaitCursor);
	(*(io->event_proc))(io, xev);    
	/* XUndefineCursor(disp, IconWnd); */
	XDefineCursor(disp, IconWnd, IconNormCursor);
    }	

}

static void check_ctrl_key(int new_state)
{
    int ctrl_key_cur;
    short changed = 0;

    ctrl_key_cur = (new_state & ShiftMask) ? 1 : 0;
    if (ctrl_key_cur != shift_key_press)
    {	shift_key_press = ctrl_key_cur;
	changed = 1;
    }

    ctrl_key_cur = (new_state & ControlMask) ? 1 : 0;
    if (ctrl_key_cur != ctrl_key_press)
    {	ctrl_key_press = ctrl_key_cur;
	changed = 1;
    }
    
    if (changed) show_all_icon_buttons();
}

static short check_message_click(XEvent *xev)
{		
    int y;
    
#ifdef DSP_SUPPORT
    if (BottomSection < FOLDER_DATA) return 0;
#endif    
    
    y = (xev->xbutton).y;
    if (y < IconSpectrY ||
        y >= (IconSpectrY + IconSpectrH)) return 0;

    
    if (msg_cur_height <= 0)
    {  
       if (no_cd || track_cur == 0xff) return 0;
       launch_track_start_message();
    }
    else
        msg_state = MSG_STATE_GOING;

    return 1;
}



/* Main routine. Returns non-zero, if event was processed */
int  icon_control_callback(XEvent *xev, void *data)
{ /*  XEvent xev; */	
    short rc = !FL_PREEMPT;    

    if(data == NULL && XFilterEvent(xev, IconWnd)) return rc;   //continue; */
      
    switch(xev->type)
    { 
	/*			  
	  //  case Expose: 
	    {//   XClearWindow(disp, IconWnd);
	         XCopyArea(disp, IconControlPmp, IconWnd, IconGC,
    		       StopButtonX, 0, 5, 9, StopButtonX, BottomY) ;
    	         old_progress[0] = old_progress[1] = -1; 
	  	 show_cd_time();  
	         draw_icon_track_number((short) track_cur); 
            }  */

	  case VisibilityNotify:
		icon_visible = win_visibility(IconWnd);
 	    if (icon_visible) init_icon_window();
		break;

	  case EnterNotify:
		XGrabPointer(disp, IconWnd, False,
      	  ButtonPressMask | PointerMotionMask | LeaveWindowMask,
		  GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	    if(IconColmap != None) 
	      XInstallColormap(disp, IconColmap); 
	    rc = FL_PREEMPT;
	    break;
	    
	  case LeaveNotify:
		XRaiseWindow(disp, IconWnd);
		if(IconColmap != None)
		  XUninstallColormap(disp, IconColmap);
		XUngrabPointer(disp, CurrentTime);    
		/* No need to break here ! */

	  case MotionNotify:
	    check_ctrl_key((xev->xmotion).state);
    	check_icon_objects(xev);
		rc = FL_PREEMPT;
		break;

	  case ClientMessage:
		if ((xev->xclient).message_type == protocols_atom &&
		  (xev->xclient).data.l[0] == delete_atom &&
		  (xev->xclient).format == 32)
		{   cdaudio_operate(OPER_QUIT);
		  xforms_close_routine(NULL, NULL);
	  	  exit(0);
		}		
		rc = FL_PREEMPT;
		break;
	
	  case KeyPress:
	  case KeyRelease:
		if (data != NULL)
		{ KeySym ks;
      	  ks = *(KeySym *)data; 
		  if (ks == XK_Shift_L || ks == XK_Shift_R)
		    shift_key_press = (xev->type == KeyPress) ? 1 : 0;
		  else
		  if (ks == XK_Control_L || ks == XK_Control_R)
		    ctrl_key_press = (xev->type == KeyPress) ? 1 : 0;

		  show_all_icon_buttons();
		  XFlush(disp);
		}
		rc = FL_PREEMPT;
		break;		

	  case ButtonPress:
	    if (!process_imwheel(xev) &&
		  !check_message_click(xev))
		{  check_ctrl_key((xev->xbutton).state);
	  	   implement_cur_object(xev);
		}	       
		rc = FL_PREEMPT;
		break; 	 	

	  case KeymapNotify:
	    rc = FL_PREEMPT;


  }   /* switch */	    	
	
    
    return rc;	/* Prevents processing by XForms */		
}


static void icon_draw_frame(int x1, int y1, int x2, int y2)
{
    
    XSetForeground(disp, IconGC, bgcol);
    XFillRectangle(disp, IconWnd, IconGC, x1+1, y1+1,
                                  x2-x1-1, y2-y1-1);

    XSetForeground(disp, IconGC, topcol);
    XDrawLine(disp, IconWnd, IconGC, x1, y1, x2, y1);
    
    XSetForeground(disp, IconGC, leftcol);
    XDrawLine(disp, IconWnd, IconGC, x1, y1, x1, y2+1);
    
    XSetForeground(disp, IconGC, btmcol);
    XDrawLine(disp, IconWnd, IconGC, x1+1, y2, x2+1, y2);

    XSetForeground(disp, IconGC, rightcol);
    XDrawLine(disp, IconWnd, IconGC, x2, y1, x2, y2);
}    

void clear_icon_spectrum(int ind)
{
    int wid, x;
    
    
    wid = IconWid-4;
    if (FourWndCount > 1) wid = (IconWid-8)/FourWndCount;

    x = (wid+4)*ind+2;


    if (ind > 0)
    { XSetForeground(disp, IconGC, bgcol1);
      XFillRectangle(disp, IconWnd, IconGC, wid+3, IconSpectrY-1,
                  2, IconSpectrH+2);
    
/*      if (nonaudio_img != NULL)
      {  XDestroyImage(nonaudio_img);
	 nonaudio_img = NULL;
      }		   */

      msg_state = MSG_STATE_NONE;
      msg_cur_height = 0;
      if (msg_bitmap != None)
      {  XFreePixmap(disp, msg_bitmap);
         msg_bitmap = None;
      }	  
    }

    icon_draw_frame(x-1, IconSpectrY-1, x+wid, IconSpectrY+IconSpectrH);
    XFlush(disp);
    
}

void clear_icon_time(void)
{
    int x, y, l;
    const char *hdr;
    unsigned long msg_colour;

/*    sprintf (hdr, "xsadp %s", get_sadp_version()); */
    
    XSetForeground(disp, IconGC, bgcol);
    XFillRectangle(disp, IconWnd, IconGC, 0, 0, IconWid, 12);   
    
    XSetBackground(disp, IconGC, bgcol); 

    if (no_cd)
    {  hdr = "No medium"; msg_colour = hicol1;
       need_top_clean = 1;
    }
    else
    {  hdr = "No audio";  msg_colour = trkcol; 
       need_top_clean = 0; 
    }
    
    XSetForeground(disp, IconGC, msg_colour);

    l = strlen(hdr);
    x = (IconWid - XTextWidth(NormalXfs, hdr, l))/2;
    y=8;
    XSetFont(disp, IconGC, NormalXfs->fid);

    XDrawImageString(disp, IconWnd, IconGC, x, y, hdr, l);
   
    old_progress[0] = old_progress[1] = -1; 
    last_elapsed = -1;    
    old_track_no = -1;
}



static char *create_nonaudio_disc_text()
{
    int ln, la, le, l;
    char *text, *disc_extra_subst=NULL;
    if (track_first == 0xff)
	return strdup("= = = No audio tracks ");

    if (strcasecmp(disc_name, "** Unknown **") == 0)
	return strdup("= = = Please, enter disc details ");

    if (disc_extra)
        disc_extra_subst = string_substitute(disc_extra, "\\n", " ");

    ln = strlen(disc_name);
    la = strlen(disc_artist);
    le = disc_extra_subst ? strlen(disc_extra_subst) : 0;
    
    text = malloc(ln + la + le + 17);
    if (text == NULL) goto OutOfHere;
    
    if (la > 0)
    {  sprintf(text, "= = = %s \"%s\" ", disc_artist, disc_name);
       l = la+ln+10;
    }
    else
    {  sprintf(text, "= = = %s ", disc_name);
       l = ln+7;
    }
           
    if (le > 0)
        sprintf (text+l, "%s ", disc_extra_subst);

OutOfHere:
    if (disc_extra_subst) free(disc_extra_subst);	
    return text;
    	
}

static char *create_nonaudio_track_text(int track_no)
{
    int ln, la, le;
    char sample[11];
    char *text, *track_extra_subst = NULL;
    

    TRACK_INFO *ti;
    
    ti = trk_info + track_no - dtrack_first;

    sprintf (sample, "Track %u", (u_int) track_no);
    if (strcasecmp(ti->name, sample) == 0) return NULL;
    
    if (ti->extra)
        track_extra_subst = string_substitute(ti->extra, "\\n", " ");

    ln = strlen(ti->name);
    la = strlen(ti->artist);
    le = track_extra_subst ? strlen(track_extra_subst) : 0;
    
    text = malloc(ln + la + le + 21);
    if (text == NULL) goto OutOfHere;
    
    if (la > 0)
        sprintf(text, "Track %u: %s - \"%s\"", 
                     (u_int) track_no, ti->artist, ti->name);
    else
        sprintf(text, "Track %u: %s", track_no, ti->name);
           
    if (le > 0)
        sprintf (text+strlen(text), " <%s>", track_extra_subst);

OutOfHere:
    if (track_extra_subst) free(track_extra_subst);
    return text;
    	
}

static void select_nonaudio_colours(void)
{
     switch(rand() & 3)
     {  case 0:
	     icon_nonaudio_fg = hicol;
	     icon_nonaudio_bg = hicol1;
	     break;
	 
	case 1:	 
             icon_nonaudio_fg = hicol1;
	     icon_nonaudio_bg = bgcol;
	     break;
	     
	case 2:	 
             icon_nonaudio_fg = hicol3;
	     icon_nonaudio_bg = trkcol;
	     break;
	     
	default:	 
             icon_nonaudio_fg = bgcol;
	     icon_nonaudio_bg = bgcol3;
    }	     

}

static void prepare_icon_nonaudio_image(void)
{
     char   *text; 
     int    text_ascent;
     int l;

     XFontStruct *xfs; 
     Font   text_font;
     XGCValues xgcv;
     Pixmap nonaudio_bmp = None;     
     GC     bmp_gc = None;
     

     if (nonaudio_img != NULL) XDestroyImage(nonaudio_img); 
     nonaudio_img = NULL; 
     
     
     text = create_nonaudio_disc_text();
     if (text==NULL) goto BadLuck;
     
     l = strlen(text);
     
     xfs = fl_get_fontstruct(FL_BOLD_STYLE, FL_SMALL_SIZE);

     text_font = xfs->fid;
     nonaudio_bmp_wid = XTextWidth(xfs, text, l);
     text_ascent = xfs->ascent;
     nonaudio_bmp_hei = text_ascent + xfs->descent + 3;

     nonaudio_bmp = XCreatePixmap(disp, IconWnd, nonaudio_bmp_wid, nonaudio_bmp_hei, 1);
     if (nonaudio_bmp == None) goto BadLuck;
     
     xgcv.font = text_font;
     xgcv.background = 0;
     xgcv.function = GXcopy;
     
     bmp_gc = XCreateGC(disp, nonaudio_bmp,
                       GCFunction | GCBackground | GCFont,
		       &xgcv);
     if(bmp_gc == None) goto BadLuck;

     XSetForeground(disp, bmp_gc, 0);
     XFillRectangle(disp, nonaudio_bmp, bmp_gc, 0, 0, nonaudio_bmp_wid, nonaudio_bmp_hei);

     XSetForeground(disp, bmp_gc, 1);
     XDrawImageString(disp, nonaudio_bmp, bmp_gc, 1, text_ascent, text, l);

     XDrawLine(disp, nonaudio_bmp, bmp_gc, 0, nonaudio_bmp_hei-1,
                     nonaudio_bmp_wid, nonaudio_bmp_hei-1);

     XSetForeground(disp, bmp_gc, 0);
     XDrawLine(disp, nonaudio_bmp, bmp_gc, 0, nonaudio_bmp_hei-2,
                     nonaudio_bmp_wid, nonaudio_bmp_hei-2);
		     
		     

     nonaudio_img = XGetImage(disp, nonaudio_bmp, 0, 0, nonaudio_bmp_wid, 
                                                  nonaudio_bmp_hei, -1, XYPixmap);


BadLuck:
     if (text != NULL) free(text);
     if (nonaudio_bmp != None) XFreePixmap(disp, nonaudio_bmp);
     if (bmp_gc != None) XFreeGC(disp, bmp_gc);
         
}

/*
#define ADD_POINT(pixel, x1, y1)        \
    if (pixel)                          \
    {  fgpoints[fgpcount].x = x1;       \
       fgpoints[fgpcount].y = y1;       \
       fgpcount++;                      \
    } else                              \
    {  bgpoints[bgpcount].x = x1;       \
       bgpoints[bgpcount].y = y1;       \
       bgpcount++;                      \
    }
*/  

static void draw_icon_nonaudio_image(void)
{

     int w, p, q, w1;
     int x, y, y1, y2, d;
     double  R, r, rx, alpha, fi;
     int    starty, height; 
     u_long pixell, pixelr;
     static short old_msg_height = 0;
     
     	
/*     XPoint  fgpoints[50], bgpoints[50];
     int  fgpcount, bgpcount;    */
     
     starty = IconSpectrY + msg_cur_height;
     height = IconSpectrH - msg_cur_height;

     if(nonaudio_img == NULL) return;

     if (msg_cur_height < old_msg_height)
     {
		XSetForeground(disp, IconGC, bgcol1);
        XFillRectangle(disp, IconWnd, IconGC, 1, starty,
	                               IconWid-2, height+2);
     
     }

     old_msg_height = msg_cur_height;    
    
     w = (IconWid-4)/2;
     R = w + msg_cur_height * .02;
     d = sqrt(R*R - w*w);  
     fi = asin(w/R);
     
     r = R-nonaudio_bmp_hei;
     w1 = sqrt(r*r - d*d); 
     
     for (x = 0; x <= w; x++)
     {	
	if (x <=-w1 || x >= w1) y1 = 0;
        else y1 = (int)sqrt(r*r - x*x + 0.5) - d;

	y2 = (int)sqrt(R*R - x*x - 0.5) - d; 
	if (y2 < 0) y2 = 0;
	else
	if (y2 > height) y2 = height;

	XSetForeground(disp, IconGC, hicol);
	for (y= -1; y<y1-1; y++)
	{  XDrawPoint(disp, IconWnd, IconGC, x+w+2, y+starty);     
    	   if (x > 0) XDrawPoint(disp, IconWnd, IconGC, w-x+2, y+starty); 
	}       

	XSetForeground(disp, IconGC, btmcol);
	XDrawPoint(disp, IconWnd, IconGC, x+w+2, starty+y1-1);     
    	if (x > 0) XDrawPoint(disp, IconWnd, IconGC, w-x+2, starty+y1-1); 

 /*	fgpcount = 0; bgpcount = 0;  */	
	for (y= y1; y<=y2; y++)
	{ 
	    pixell =  pixelr = icon_nonaudio_bg;
	    
	    if (inter_val > 0 && (x+y)%MAX_INTER_VAL < inter_val)
	    {
		if (nodisc_img)
		{   pixell = XGetPixel(nodisc_img, w-x+2, y);
		    if (x > 0)
		       pixelr = XGetPixel(nodisc_img, w+x+2, y);
		}		       
	    }	    
	    else		    
	    {   rx = sqrt(x*x + y*y); /* so that r <= rx <= R */

		q = (rx - r); 	 /* 0 <= q <= h */
	    
		if (q >= 0)
		{ 
	           alpha = asin(x/rx);
		   p = (int)((fi-alpha)*r + offset) % nonaudio_bmp_wid;
	           if (XGetPixel(nonaudio_img, p, q)) pixell = icon_nonaudio_fg;
		   if (x > 0)
		   {  p = (int)((fi+alpha)*r + offset) % nonaudio_bmp_wid;
	              if (XGetPixel(nonaudio_img, p, q)) pixelr = icon_nonaudio_fg;	    
		   }    		      
	        }   
	    }		

	    XSetForeground(disp, IconGC, pixell);
	    XDrawPoint(disp, IconWnd, IconGC, w-x+2, y+starty);    

    	    if (x > 0) 
    	    {   XSetForeground(disp, IconGC, pixelr);     
	        XDrawPoint(disp, IconWnd, IconGC, w+x+2, y+starty);     
	    }   

        }	         

/*	XSetForeground(disp, IconGC, hicol);
        XDrawPoints(disp, IconWnd, IconGC, fgpoints, fgpcount, CoordModeOrigin);
	
	XSetForeground(disp, IconGC, hicol1);
        XDrawPoints(disp, IconWnd, IconGC, bgpoints, bgpcount, CoordModeOrigin); */

	XSetForeground(disp, IconGC, topcol);
	XDrawPoint(disp, IconWnd, IconGC, w+x+2, y2+starty+1);     
	if (x > 0) XDrawPoint(disp, IconWnd, IconGC, w-x+2, y2+starty+1);     
     }	
				     
     XFlush(disp);
}


static void set_tooltip_message_wait(short timeout)
{    long cur_interval;
     msg_state = MSG_STATE_WAITING;
     cur_interval = (cd_status==CDROM_AUDIO_PLAY)? SHIFT_PLAY_INTERVAL
	                       : SHIFT_STILL_INTERVAL;
     msg_cur_wait = (long)timeout * 1000000 / cur_interval;
}


static void refresh_icon_message(void)
{
    if (msg_bitmap == None)
    {   msg_state = MSG_STATE_NONE;
        return;
    }	
		    
    if (msg_type == MSG_TYPE_TRACKNAME && no_cd)
	  msg_state = MSG_STATE_GOING;
	
    switch(msg_state)
    {
        case MSG_STATE_WAITING:
	    if (--msg_cur_wait <= 0) 
		    msg_state = MSG_STATE_COMING;
	    break;		    
	
        case MSG_STATE_COMING:
	    if (msg_cur_height >= MSG_MAX_HEIGHT)
	    {	msg_state = MSG_STATE_SEEN;
		msg_offset = 0;
	    }		
	    else		    
	        msg_cur_height++;
	    break;
	    
        case MSG_STATE_SEEN:
	    if (msg_offset >= (msg_width - msg_frame_width))
		msg_state = (msg_type == MSG_TYPE_TOOLTIP) ? 
		                  MSG_STATE_HIDING : MSG_STATE_GOING;
	    else		    
		msg_offset++;
	    break;
	    
        case MSG_STATE_HIDING:
	    if (msg_cur_height <= 0)
		set_tooltip_message_wait(TooltipTimeout3);
	    else
	        msg_cur_height--;
	    break;
	    
        case MSG_STATE_GOING:
	    if (msg_cur_height <= 0)
	    { 
		XFreePixmap(disp, msg_bitmap);
	    	msg_bitmap = None;
	    
	        if (launch_tooltip_message() == 0)
	              msg_state = MSG_STATE_NONE;
		
	    }		
	    else		    
	        msg_cur_height--;
	    break;
	    		
        case MSG_STATE_NONE:
    }	

    if (msg_cur_height > 0)
    {
        XSetForeground(disp, IconGC, (msg_type == MSG_TYPE_TOOLTIP) ? trkcol : hicol1);
		XSetBackground(disp, IconGC, bgcol);
		XCopyPlane(disp, msg_bitmap, IconWnd, IconGC,
	        msg_offset, msg_height - msg_cur_height,
		msg_frame_width, msg_cur_height,
		2, IconSpectrY-1, 1);
     }		
     time_plus(next_msg_time, SHIFT_MSG_INTERVAL);

}

void prepare_icon_message(const char *msg)
{
     XGCValues xgcv;
     GC     bmp_gc = None;
     int    text_ascent, l;

     if (msg_bitmap != None) XFreePixmap(disp, msg_bitmap); 
     msg_bitmap = None;
     

     msg_frame_width = IconWid-4;
     l = strlen(msg);
     msg_width = XTextWidth(NormalXfs, msg, l) + 2*msg_frame_width;
     text_ascent = NormalXfs->ascent;
/*     msg_height = text_ascent + TextXfs->descent;
     if (msg_height > MSG_MAX_HEIGHT) msg_height = MSG_MAX_HEIGHT; */
     msg_height = MSG_MAX_HEIGHT;

     msg_bitmap = XCreatePixmap(disp, IconWnd, msg_width, msg_height, 1);
     if (msg_bitmap == None) goto BadLuck;
     
     xgcv.font = NormalXfs->fid;
     xgcv.foreground = 1;
     xgcv.background = 0;
     xgcv.function = GXcopy;
     
     bmp_gc = XCreateGC(disp, msg_bitmap,
                       GCFunction | GCBackground | GCFont,
		       &xgcv);
     if(bmp_gc == None) goto BadLuck;

     XSetForeground(disp, bmp_gc, 0);
     XFillRectangle(disp, msg_bitmap, bmp_gc, 0, 0, msg_width, msg_height);

     XSetForeground(disp, bmp_gc, 1);
     XDrawImageString(disp, msg_bitmap, bmp_gc, msg_frame_width, text_ascent-1, msg, l);

BadLuck:
     msg_offset = 0;
     if (bmp_gc != None) XFreeGC(disp, bmp_gc);    
}

/*
static void  stretch_icon(void)
{
    XImage *xim_tmp;
    FL_STATE *fls;
    int    swid, shei, sx, sy;
    int    wid, hei;
    short  x, y, x1, y1;
    unsigned long pix;
    
    fls = fl_state + ScreenVC;
    wid = IconWid-4; hei = IconSpectrH;

    x = (ScreenD <= 8 ) ? 8 : ((ScreenD <=16) ? 16 : 32);    
    nodisc_img = XCreateImage(disp, fls->xvinfo->visual, ScreenD, ZPixmap,
                            0,  NULL, wid, hei, x, 0);
    if (nodisc_img == NULL) return;

    if((nodisc_img->data = malloc(hei * nodisc_img->bytes_per_line)) == NULL)
    {    XDestroyImage(nodisc_img);
         nodisc_img = NULL;
	 return;
    }	 

    if (DimPmp == None)
    {  
    
		for (y=0; y<hei; y++)    
        {  for (x=0; x<wid; x++)
	  	   XPutPixel(nodisc_img, x, y, bgcol);
		}	      

		return;	
    }

    if (IconStyleBG == 'r') 	
    {	sx = 0;  swid = 60-sx;
     	sy = 12; shei = 40-sy; 
    }
    else	
    {  	sx = 0;  swid = 58-sx;
        sy = 15; shei = 40-sy;
    }

    xim_tmp = XGetImage(disp, DimPmp, sx, sy, swid, shei, -1, ZPixmap);
    if (xim_tmp == NULL) goto FinitaLaComedia;
    

//    nodisc_img = XCreateImage(disp, fls->xvinfo->visual, xim_tmp->depth, ZPixmap,
//                            0,  NULL, wid, hei, xim_tmp->bitmap_pad, 0);

    
    for (y=0; y<hei; y++)    
    {
       y1 = (int) y * shei / hei;
       if (y1 >= shei) y1 = shei-1; 
       
       for (x=0; x<wid; x++)
       {  x1 = (int) x * swid / wid;	       
		  if (x1 < 0 || x1 >= swid) pix = bgcol;
		  else pix =  XGetPixel(xim_tmp, x1, y1) ;

		  XPutPixel(nodisc_img, x, y, pix); 
       }
    }       	  
       
FinitaLaComedia:    
    if (xim_tmp) XDestroyImage(xim_tmp);    

}

*/

static void launch_icon_message(const char *msg, enum MSG_TYPE new_msg_type )
{
    if ( msg_state != MSG_STATE_NONE && msg_state != MSG_STATE_GOING && 
         msg_state != MSG_STATE_HIDING && new_msg_type < msg_type)  return;

    msg_type = new_msg_type;

    if (msg_state == MSG_STATE_WAITING || 
         msg_state == MSG_STATE_NONE || msg_state == MSG_STATE_GOING ||
	 msg_state == MSG_STATE_HIDING)
    {  if (new_msg_type == MSG_TYPE_TOOLTIP)
	    set_tooltip_message_wait(TooltipTimeout1);
	else	
	    msg_state = MSG_STATE_COMING;
    }              

    prepare_icon_message(msg);
    gettimeofday(&next_msg_time, NULL);

}    

static void launch_track_start_message(void)
{   char *text;

    if (track_cur == 0xff) return;
    
    text = create_nonaudio_track_text(track_cur);
    if (text)
    {   launch_icon_message(text, MSG_TYPE_TRACKNAME);
	free(text);
    }
    nonaudio_old_track = track_cur;
}    

static short launch_tooltip_message(void)
{	
    char *msg;
    icon_obj *io;    

    if (cur_icon_obj < 0 || TooltipTimeout1 > 10)  return 0;

    io = icon_obj_list+cur_icon_obj;  
    msg = malloc(strlen(io->tooltip)+11);
    if (msg == NULL) return 0;
    
    sprintf(msg, "Tooltip: %s", io->tooltip);    
    launch_icon_message(msg, MSG_TYPE_TOOLTIP);
    free(msg);
    return 1;
}

void icon_idle_callback(void)
{
    struct timeval cur_time;
    int need_refresh;   


#ifdef DSP_SUPPORT
    if (BottomSection < FOLDER_DATA) 
    {  msg_state = MSG_STATE_NONE; 
       return;
    }       
#endif

    gettimeofday(&cur_time, NULL);
    
    if(msg_state != MSG_STATE_NONE)
    {   need_refresh = (cur_time.tv_sec > next_msg_time.tv_sec ||
	                ( (cur_time.tv_sec == next_msg_time.tv_sec) &&
	                  (cur_time.tv_usec >= next_msg_time.tv_usec) ));
			 
       if (need_refresh) refresh_icon_message();			 
    }			 
	
    if (no_cd != no_cd_old)
    {
	no_cd_old = no_cd;

	if (no_cd == 0)
    	{
	   inter_val = MAX_INTER_VAL;
	   inter_val_incr = -1;   
	   prepare_icon_nonaudio_image();
	   select_nonaudio_colours();
	   nonaudio_old_track = track_cur;
	   if (track_cur == 0xff) clear_icon_time();
	   offset = 0;
	}
	else
	{		   
	   inter_val = 0;
	   inter_val_incr = 1; 
	}
	      
	need_refresh = 1;
	memcpy(&next_shift_time, &cur_time, sizeof(struct timeval));
    }
    else
    {
        if (no_cd == 0)
	{  if (track_cur != nonaudio_old_track)
		    launch_track_start_message();	
	}
    
	need_refresh = (cur_time.tv_sec > next_shift_time.tv_sec ||
	                 ( (cur_time.tv_sec == next_shift_time.tv_sec) &&
    			   (cur_time.tv_usec >= next_shift_time.tv_usec) ));
    }
			   

    if (!need_refresh) return;
    
    draw_icon_nonaudio_image();
    offset++;
    
    if (inter_val_incr)
    {  inter_val += inter_val_incr;
	if (inter_val <= 0 || inter_val > MAX_INTER_VAL)
	   inter_val_incr = 0;
    }	       
    
    time_plus(next_shift_time, 
	   (inter_val > 0 || cd_status==CDROM_AUDIO_PLAY)? SHIFT_PLAY_INTERVAL
	                     : SHIFT_STILL_INTERVAL);

}

void init_icon_nonaudio(void)
{

    XSetForeground(disp, IconGC, bgcol1);
    XFillRectangle(disp, IconWnd, IconGC, 1, IconSpectrY-1, IconWid-2, IconSpectrH+2);
    gettimeofday(&next_shift_time, NULL);
    offset = 0;

    
    XSetForeground(disp, IconGC, hicol1);
    if (no_cd == 0)
    { inter_val = 0;
      launch_track_start_message();    
    }      

   inter_val_incr = 0;   
   inter_val = (no_cd) ? MAX_INTER_VAL: 0;   
    
   prepare_icon_nonaudio_image();
   nonaudio_old_track = track_cur;
   offset = 0;
   draw_icon_nonaudio_image();

   no_cd_old = no_cd;
}

#endif
