/*  =========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software.

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>

#ifdef X11

#include <forms.h>
#include "sad.h"
#include "sadp_xforms.h"
extern int   xforms_ver, xforms_rev;
extern short  TooltipTimeout1, TooltipTimeout2, TooltipTimeout3;
extern Display	*disp;

static const char *vcnames[] =
 { "StaticGray", "GrayScale", "StaticColor",
   "PseudoColor", "TrueColor", "DirectColor"
 };

#else

#include <term.h>
#include <curses.h>
#include "sad.h"
#include "sadp_curses.h"

extern short  AreColours, CharSet;
extern MOUSE_SUPPORT_OPTION MouseSupport;
extern MOUSE_SUPPORT_OPTION MouseSupportOrig;

static const char *charset_names[] =
 {"PC", "ALT", "ANSI", "ACS"};
static const char *mouse_names[] =
 {"DISABLED", "NCURSES", "GPM"};

#endif

extern int   ScreenW, ScreenH, ScreenD, ScreenVC;
extern char  CDDeviceName[];
extern char  AudioDeviceName[];
extern char  MixerDeviceName[];
extern u_int SamplingRate;
extern u_int sample_size;
extern short unsgn_mode, mmap_active;

extern short FourInterlace;
extern short AutoPlay;
extern short ProbeCD;
extern short SaveSet, SaveData, SaveMixer;

extern short FourWndCount;
extern long  FrameInterval;


#ifdef DEFAULT_WDB_NAME
extern char  *ShortWDBName; 
#endif
#ifdef DEFAULT_XMCD_PATH
extern char  *ShortXMCDPath; 
#endif

extern char *ShortDBPath;
extern char *ShortDBAltPath;

#ifdef CD_EXTENSION_SUPPORT
extern char   *ExtensionType;
#endif

#ifdef MCN_SUPPORT
extern short   UseMCN;
#endif


extern unsigned short stereo_supported;
extern char   cd_description[];
extern char   cd_model[], sg_name[];
extern u_char CDDeviceType, CDNodeNumber;
extern int    TimeoutStart, TimeoutRepos;
extern int    TimeoutEject, TimeoutLoad;
extern int    DurationIntro, DurationAdvance;
extern short  UseLogFile;
extern long   ft_bufsize;
extern long   TimeStart;
extern double Frames;
extern int    abuf_size, nfrags;


#define MAX_LINES 200

char   **InfoPages;
short  InfoLineCount;

static double FramesPerSec;
static int	  EfficLineNo;


static const  char *empty = "";

static const  char *yes = "yes";
static const  char *no =  "no";

const  char *supported = "supported";
const  char *unsupported =  "not supported";




static void  put_line(char *line, const char *buf)
{
    int  len = strlen(buf);

    if (len > INFO_LINE_SIZE) len = INFO_LINE_SIZE;
    memcpy (line, buf, len);
    line += len;

    len = INFO_LINE_SIZE - len;
    if (len > 0)
    {  memset(line, ' ', len);
       line += len;
    }

    *line = '\0';
}

static int  update_line(const char *buf, int lineno)
{
    if (lineno >= InfoLineCount) return 0;
    put_line (InfoPages[lineno], buf);
    return 1;
}

static int  commit_line(const char *buf)
{   char *line;
    if (InfoLineCount >= MAX_LINES) return 0;

    line = malloc(INFO_LINE_SIZE +1);
    if (!line) return 0;

    InfoPages[InfoLineCount++] = line;
    put_line(line, buf);
    return 1;
}

static void put_long_line(const char *header, const char *line, int portion)
{
    int l, s, offset;	
    char buffer[INFO_LINE_SIZE+1];	
    char auxbuf[INFO_LINE_SIZE+1];

    l = strlen(line);    
    if (l <= 0) return;

    memcpy(auxbuf, line, portion);
    auxbuf[portion] = '\0';
    sprintf(buffer,  "    %s %s", header, auxbuf);	
    commit_line(buffer);

    offset = strlen(header) + 5;
/*    offset = INFO_LINE_SIZE-portion; */
    memset(buffer, ' ', offset);

    for (s=portion; s<=l; s+=portion)
    {	if (s+portion > l)	
 	{  memcpy(auxbuf, line+s, l-s);
	   auxbuf[l-s] = '\0';
	}
	else	       
           memcpy(auxbuf, line+s, portion);
	trim(auxbuf);
	if (strlen(auxbuf) <= 0) break;
	strcpy(buffer + offset, auxbuf);		       
	commit_line(buffer);
    }	       
       
}

/* ================================================== */

static void get_cpu_info(void)
{   char CpuType[11];
    char CpuModel [41];
    char buffer[INFO_LINE_SIZE+1];
    double mips, cpuclock;

    if (get_cpu_data(CpuType, CpuModel, &cpuclock, &mips))
    {  commit_line("CPU");
       if (strlen(CpuType)>0)
       { sprintf (buffer, "    Type:    %-10s", CpuType);
         commit_line(buffer);
       }
       if (strlen(CpuModel)>0)
       {  sprintf (buffer, "    Model:   %-15s", CpuModel);
          commit_line(buffer);
       }
       if (cpuclock > 0)
       {   sprintf(buffer, "    Clock:   %.1f MHz", cpuclock);
           commit_line(buffer);
       }
       if (mips > 0)
       {   sprintf(buffer, "    Speed:   %.1f BogoMIPS", mips);
           commit_line(buffer);
       }
       commit_line(empty);
    }
/*
    if (get_cpu_data(CpuType, CpuModel, &mips))
    {  commit_line("CPU");
	 sprintf (buffer, "    Type:   %-10s", CpuType);
       commit_line(buffer);
	 sprintf (buffer, "    Model:  %-15s", CpuModel);
       commit_line(buffer);
	 sprintf(buffer,  "    Speed:  %.1f bogoMIPS", mips);
       commit_line(buffer);
       commit_line(empty);
    }
*/
}

static void get_os_info(void)
{   char OsType[41];
    char OsVersion[41];
    char buffer[81];

    if (get_os_data(OsType, OsVersion))
    {  commit_line("SYSTEM");
	 sprintf (buffer, "    Type:    %s", OsType);
       commit_line(buffer);
	 sprintf (buffer, "    Release: %s", OsVersion);
       commit_line(buffer);
       commit_line(empty);
    }
}

#ifdef X11
static void get_x_info(void)
{
    char buffer[INFO_LINE_SIZE+1];
    char *tchr;
    int	 release;
    int  v1, v2, v3;

    commit_line("X SERVER");

    tchr = ServerVendor(disp);
    if (tchr == NULL) return;

/*    put_long_line("Vendor:  ", tchr, 18);  */
    snprintf(buffer, INFO_LINE_SIZE, "    Vendor:  %s", tchr);
    commit_line(buffer);

    release = VendorRelease(disp);
    v1 = release / 1000;
    release %=1000;
    v2 = release / 100;
    v3 = release % 100;
    if (strstr(tchr, "XFree86"))
       snprintf (buffer, INFO_LINE_SIZE,  "    Release: %d.%d.%d.%d", v1, v2, v3/10, v3%10);
    else	
        snprintf (buffer, INFO_LINE_SIZE,  "    Release: %d.%d.%02d", v1, v2, v3);
    commit_line(buffer);
    commit_line(empty);

}

static void get_xforms_info(void)
{
    char buffer[81];
    commit_line("XForms");
    sprintf (buffer, "    Release:  %d.%2d", xforms_ver, xforms_rev);
    commit_line(buffer);
    commit_line(empty);
}

char *get_font_name(int font_size)
{
   XFontStruct *xfs;
   Atom atm;
   unsigned long value; 

   xfs = fl_get_fontstruct(FL_NORMAL_STYLE, font_size);

   atm = XInternAtom(disp, "FONT", True);
   if (atm != None && XGetFontProperty(xfs, atm, &value))
       return XGetAtomName(disp, (Atom)value);
   	
   return NULL;    
}    

void show_font_name(int font_size, const char *header)
{   char *FontName;
    

    FontName = get_font_name(font_size);
    if (FontName)
    {  put_long_line(header, FontName, 17);	
       XFree(FontName);
    }   
       
}

#else
static void get_curses_info(void)
{    char buffer[81];

#ifdef NCURSES_VERSION
    commit_line("NCURSES");
#ifdef NCURSES_VERSION_PATCH
     sprintf(buffer, "    Compiled:  %s.%d", NCURSES_VERSION, NCURSES_VERSION_PATCH);
#else
     sprintf(buffer, "    Compiled:  %s", NCURSES_VERSION);
#endif
     commit_line(buffer);

#if HAVE_CURSES_VERSION
     { char *ptr =  (char *)curses_version();
	 if (memcmp(ptr, "ncurses", 7) == 0) ptr += 8;
       sprintf(buffer, "    Running:   %s", ptr );
       commit_line(buffer);
     }
#endif 

#endif

    sprintf(buffer,  "    Colours:   %ssupported",
                           AreColours ? "" : "not ");
    commit_line(buffer);
    commit_line(empty);
}
#endif

static void get_sadp_info(void)
{   char buffer[81];
    
    commit_line("SADP");
    sprintf(buffer, "    Release:  %s",  get_sadp_version());
    commit_line(buffer);
#if defined(__DATE__) && defined(__TIME__)
    sprintf(buffer, "    Compiled: %s", __DATE__);
    commit_line(buffer);
    sprintf(buffer, "              %s", __TIME__);
    commit_line(buffer);
#endif
#if defined(__VERSION__)
#if defined(__GNUC__)
    strcpy(buffer, __VERSION__);
    if (isdigit(*buffer))
        sprintf(buffer, "    Compiler: gcc %s", __VERSION__);
    else
#endif
        sprintf(buffer, "    Compiler: %s", __VERSION__);
    
            	
    commit_line(buffer);
#endif

    commit_line(empty);
}

static void get_screen_info(void)
{
    char buffer[81];

#ifdef X11
    commit_line("SCREEN");

    sprintf(buffer,  "    Width:   %d", ScreenW);
    commit_line(buffer);

    sprintf(buffer,  "    Height:  %d", ScreenH);
    commit_line(buffer);

    sprintf(buffer,  "    Depth:   %d bpp", ScreenD);
    commit_line(buffer);

    sprintf(buffer,  "    Visual:  %s", vcnames[ScreenVC]);
    commit_line(buffer);

    commit_line(empty);

#else
    char termname[21];	
    
    commit_line("TTY");
    strncpy(termname, cur_term->type.term_names, 20);
    strtok(termname, "|");
    sprintf(buffer,  "    Type:    %s", termname );
    commit_line(buffer);

    sprintf(buffer,  "    Colums:  %d", ScreenW);
    commit_line(buffer);

    sprintf(buffer,  "    Rows:    %d", ScreenH);
    commit_line(buffer);

    commit_line(empty);
#endif
}


static void get_cd_info(void)
{
    char buffer[81];
    char auxbuf[81];
    char *ptr;
    short s;

    commit_line("CD ROM device");
    sprintf(buffer,  "    Name:   %-20s", CDDeviceName);
    commit_line(buffer);

    s = readlink(CDDeviceName, auxbuf, 40);
    if (s > 0)  auxbuf[s] = '\0';
    else strncpy(auxbuf, CDDeviceName, 40);

    ptr = strrchr(auxbuf, '/');
    if (ptr) ptr++; else ptr = auxbuf;
    sprintf(buffer,  "    Device: %s", ptr);
    commit_line(buffer);

    sprintf(buffer,  "    Node:   %d-%d",
                           (int)CDDeviceType, CDNodeNumber);
    commit_line(buffer);

    if (strlen(cd_description) > 0)
    {  sprintf(buffer,  "    Type:   %s", cd_description);
	 commit_line(buffer);
    }

#if  defined(CD_EXTENSION_SUPPORT)
    if (strlen(sg_name) > 0)	
    {	
       sprintf(buffer,  "    SG dev: %s", sg_name);
       commit_line(buffer);
    }
#endif

    put_long_line("Model: ", cd_model, 15); 	

/*
    s = cd_check_multisession();
    if (s >= 0)
    {  sprintf (buffer, "    XA disk: %s", s ? yes : no);
	 commit_line(buffer);
    }
*/
    commit_line(empty);
}

#if defined(DSP_SUPPORT) || defined(MIXER_SUPPORT)
static void get_sound_driver_info(void)
{
	char buffer[INFO_LINE_SIZE+1];
	char drv_type[16], drv_version[16], alsa_emu[16];
	static const char *header = "SOUND driver";

#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
	short  header_seen = 0;
	if (get_alsa_sound_version(drv_type, drv_version))
	{
		commit_line(header);
		header_seen = 1;
		sprintf(buffer,  "    Type:    %s", drv_type);
		commit_line(buffer);
		sprintf(buffer,  "    Version: %s", drv_version);
		commit_line(buffer);
		commit_line(empty);
	}
#endif
	if (get_sound_version(drv_type, drv_version, alsa_emu) == 0) return;
	
#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
	if (header_seen == 0)
#endif
		commit_line(header);
	sprintf(buffer,  "    Type:    %s", drv_type);
	commit_line(buffer);
	if (strlen(drv_version) > 0)
	{	sprintf(buffer,  "    Version: %s", drv_version);
		commit_line(buffer);
	}
	if (strlen(alsa_emu) > 0)
	{	sprintf(buffer,  "    ALSAemu: %s", alsa_emu);
		commit_line(buffer);
	}
	commit_line(empty);

}
#endif

#ifdef DSP_SUPPORT
static void get_audio_info(void)
{
    char buffer[61];
    char descr1[INFO_LINE_SIZE+1];
    char descr2[INFO_LINE_SIZE+1];
    char devname[21];
    short  node_no;

   commit_line("AUDIO device");
   if (get_audio_name(AudioDeviceName, "dsp", "Audio devices:",
                         devname,   &node_no,  descr1, descr2))
   {
	  put_long_line("Name:  ", AudioDeviceName, 18);

	  if (strcmp(AudioDeviceName+strlen(AudioDeviceName)-strlen(devname),
                   devname))
	  { sprintf(buffer,  "    Device: %s", devname);
	    commit_line(buffer);
	  }

	  sprintf(buffer,  "    Node:   %d-%d", node_no >> 8, node_no & 255);
	  commit_line(buffer);

	  sprintf(buffer,    "    Type:   %s", descr1);
	  commit_line(buffer);

        if (*descr2)
	  { sprintf(buffer,  "            %s", descr2);
	    commit_line(buffer);
        }
    }
    else
	  commit_line("    Disabled");

    commit_line(empty);
}
#endif

#ifdef MIXER_SUPPORT
static void get_mixer_info(void)
{
    char buffer[61];
    char descr1[INFO_LINE_SIZE+1];
    char descr2[INFO_LINE_SIZE+1];
    char devname[21];
    short  node_no;

   commit_line("MIXER device");
   if (get_audio_name(MixerDeviceName, "mixer", "Mixers:",
                         devname,   &node_no,  descr1, descr2))
   {
	  put_long_line("Name:  ", MixerDeviceName, 18);

	  if (strcmp(MixerDeviceName+strlen(MixerDeviceName)-strlen(devname),
                   devname))
	  { sprintf(buffer,  "    Device: %s", devname);
	    commit_line(buffer);
	  }

	  sprintf(buffer,  "    Node:   %d-%d", node_no >> 8, node_no & 255);
	  commit_line(buffer);

	  sprintf(buffer,   "    Type:   %s", descr1);
	  commit_line(buffer);

        if (*descr2)
	  { sprintf(buffer, "            %s", descr2);
	    commit_line(buffer);
        }

    }
    else
	  commit_line("    Disabled");

    commit_line(empty);
}
#endif

void  get_efficiency(char *buffer)
{
    long period = time(NULL) - TimeStart;


    if (Frames > 0 && period > 0) FramesPerSec = Frames / period;
    				else    FramesPerSec = -1;

    sprintf(buffer, "%%   EFFICIENCY: %0.2f fps", FramesPerSec);
}



static void get_parameters(void)
{    char buffer [81];

     commit_line("TIME INTERVALS");
     sprintf(buffer, "    Start:        %2d sec", TimeoutStart);
     commit_line(buffer);
     sprintf(buffer, "    Reposition:   %2d sec", TimeoutRepos);
     commit_line(buffer);
     sprintf(buffer, "    Eject tray:   %2d sec", TimeoutEject);
     commit_line(buffer);
     sprintf(buffer, "    Load tray:    %2d sec", TimeoutLoad);
     commit_line(buffer);
/*     sprintf(buffer, "    Help advance: %d msec", TIME_OUT_HELP_ADVANCE);
     commit_line(buffer);  */
     sprintf(buffer, "    Intro play:   %2d sec",  DurationIntro);
     commit_line(buffer);
     sprintf(buffer, "    Forward/back: %2d sec", DurationAdvance);
     commit_line(buffer);
     commit_line(empty);

#ifdef X11
     if (TooltipTimeout1 <= 10)
     {   commit_line("TOOL TIPS TIMEOUTS");
         sprintf(buffer, "    First appear:%3d sec",  (int)TooltipTimeout1);
	 commit_line(buffer);
         sprintf(buffer, "    Disappear:   %3d sec",  (int)TooltipTimeout2);
         commit_line(buffer);
         sprintf(buffer, "    Next appear: %3d sec",  (int)TooltipTimeout3);
         commit_line(buffer);
     }	 
     else	 
         commit_line("TOOL TIPS ARE DISABLED");

     commit_line(empty);
#endif

#ifdef DSP_SUPPORT
     if (FourWndCount > 0)
     {
	commit_line("SPECTRUM AND OSCILLOSCOPE");
	sprintf(buffer, "    Sample rate: %u Hz",  SamplingRate);
	commit_line(buffer);
	sprintf(buffer, "    Sample size: %u bits",  sample_size);
	commit_line(buffer);
	sprintf(buffer, "    Sample mode: %ssigned", unsgn_mode ? "un" : "");
	commit_line(buffer);
        sprintf(buffer, "    Access mode: %s", mmap_active ? "memory map" : "read");
        commit_line(buffer);
/*       sprintf(buffer, "    Windows:     %d", FourWndCount);
	commit_line(buffer);
	sprintf(buffer, "    Interlace:   %d", FourInterlace);
	commit_line(buffer);	 			*/
	sprintf(buffer, "    Frame size:  %d bytes",  abuf_size);
	commit_line(buffer);
	sprintf(buffer, "    Frames:      %d",  nfrags);
	commit_line(buffer);
	sprintf(buffer, "    Buf size:    %ld bytes", ft_bufsize);
	commit_line(buffer);
	commit_line(empty);
    }
#endif
    commit_line("INTERNAL DATA BASES");
       put_long_line("DB Path:   ", ShortDBPath, 12);	

    if(ShortDBAltPath)
       put_long_line("Altern DB: ", ShortDBAltPath, 12);	

#ifdef DEFAULT_WDB_NAME
    if(ShortWDBName)
       put_long_line("Workman DB:", ShortWDBName, 12);	
#endif
#ifdef DEFAULT_XMCD_PATH
    if(ShortXMCDPath)
       put_long_line("XMCD path: ", ShortXMCDPath, 12);	
#endif
    commit_line(empty);

    commit_line("SUPORTED FEATURES");
    sprintf(buffer, "    SCSI CD:    %s",
#ifdef SCSI_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    UCDROM:     %s",
#ifdef UCDROM_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    MCN:        %s",
#ifdef MCN_SUPPORT
	    	UseMCN ? "active" : "inactive"
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    EXTENSION:  %s",
#ifdef CD_EXTENSION_SUPPORT
		ExtensionType
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    CD-EXTRA:   %s",
#ifdef CD_EXTRA_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    CD CHANGER: %s",
#ifdef CHANGER_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    DSP:        %s",
#ifdef DSP_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);
#ifdef DSP_SUPPORT
    sprintf(buffer, "    ALSA DSP:   %s",
#ifdef ALSA_DSP_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);
#endif

    sprintf(buffer, "    MIXER:      %s",
#ifdef MIXER_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);

#ifdef MIXER_SUPPORT
    sprintf(buffer, "    ALSA MIXER: %s",
#ifdef ALSA_MIXER_SUPPORT
		supported
#else
		unsupported
#endif
    );
    commit_line(buffer);
#endif

    sprintf(buffer, "    RCDDB:      %s",
#ifdef RCDDB_SUPPORT
		supported
#else
		unsupported
#endif
	);
    commit_line(buffer);
    commit_line(empty);


#ifdef X11
    commit_line("FONTS:");

    show_font_name(FL_NORMAL_SIZE, "Normal:");
    show_font_name(FL_SMALL_SIZE,  "Small:");
    commit_line(empty);
#endif

    commit_line("OPTIONS:");
#ifdef RCDDB_SUPPORT
    sprintf(buffer, "    Log file:     %s", UseLogFile ? yes : no);
    commit_line(buffer);
#endif
    sprintf(buffer, "    Probe CD:     %s", ProbeCD ? yes : no);
    commit_line(buffer);
    commit_line    ("    Auto-save");
    sprintf(buffer, "       settings:  %s", SaveSet ? yes : no);
    commit_line(buffer);
    sprintf(buffer, "       data:      %s", SaveData ? yes : no);
    commit_line(buffer);
    commit_line    ("    Save volumes");
    sprintf(buffer, "      with data:  %s", SaveMixer ? yes : no);
    commit_line(buffer);
    commit_line(empty);

#ifndef X11
    commit_line("MISCELLANEOUS:");
    sprintf(buffer, "    Char set:   %d [%s]", CharSet, charset_names[CharSet-1]);
    commit_line(buffer);
    sprintf(buffer, "    Mouse:      %s", mouse_names[MouseSupport] );
    if (MouseSupportOrig == MOUSE_DEFAULT) 
			strcat(buffer, " deflt");	
    commit_line(buffer);
    commit_line(empty);
#endif

    EfficLineNo = InfoLineCount;
    get_efficiency(buffer);
    commit_line(buffer);

}

void update_info_page(void)
{
    char buffer[51];

    get_efficiency(buffer);
    update_line(buffer, EfficLineNo);
}

int  prepare_info_page(void)
{

    InfoPages = (char **)  malloc((MAX_LINES+1) * sizeof(char *));
    if (!InfoPages) return 0;

    InfoLineCount = 0;


#ifdef X11
    commit_line("%       YOUR  COMPUTER");
#else
    commit_line("%        ENVIRONMENT");
#endif
    commit_line(empty);

    get_os_info();
#ifdef X11
    get_x_info();
#endif
    get_cpu_info();
    get_screen_info();

    commit_line("%       PERIPHERALS");
    commit_line(empty);
    get_cd_info();

#if defined(DSP_SUPPORT) || defined(MIXER_SUPPORT)
    get_sound_driver_info();
#endif
#ifdef DSP_SUPPORT 
    get_audio_info();
#endif
#ifdef MIXER_SUPPORT
    get_mixer_info();
#endif

    commit_line("%    SOFTWARE INFORMATION");
    commit_line(empty);

    get_sadp_info();
#ifdef X11
    get_xforms_info();
#else
    get_curses_info();
#endif	

    commit_line("%     PROGRAM SETTINGS");
/*    commit_line("==========");   */
    commit_line(empty);

    get_parameters();

    InfoPages[InfoLineCount] = NULL;
    InfoPages = realloc(InfoPages, (InfoLineCount +1) * sizeof(char *));

    return InfoPages ? 1 : 0;
}

void release_info_page(void)
{
    char **iptr;
    int i;

    if (!(iptr = InfoPages)) return;

    for (i=0; i<InfoLineCount; i++)
			 free(*iptr++);

    free(InfoPages);

}
