/*  =========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
          Sing-Along Disk Player is copyrighted by the author.
          See COPYRIGHT regarding distribution policy and
          conditions of use.

          You are expected to provide appropriate references
          when using a part of the code in your software.

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <values.h>
#include <linux/cdrom.h>
/*
#if HAVE_LINUX_UNISTD_H
#include <linux/unistd.h>
#endif
*/
#include <curses.h>
/* #include <term.h> */

#include "sad.h"
#include "sadp_curses.h"

char  CDDeviceName[81];


/*=============================*/
/*         DSP_SUPPORT         */
#ifdef DSP_SUPPORT
short   FourGain = 0, WaveVScale = 0, UseMMap = 1;
short	FourInterlace = 1;
short	AudioSampleSize = 16;
short   FourWndCount = 2;
u_int   SamplingRate = 11025u;

/*  0 - don't use device number for OSS  */
/* -1 - no audio device */
/* -2 - path specified explicitly */
int   AudioDeviceNumber = 0;
char  AudioDeviceName[101];

#else
short  FourWndCount = 0;
#endif
/*                             */
/*=============================*/

/*=============================*/
/*        MIXER_SUPPORT        */
#ifdef MIXER_SUPPORT
/*  0 - don't use device number for OSS  */
/* -1 - no mixer device */
/* -2 - path specified explicitly */
int   MixerDeviceNumber = 0;
char  MixerDeviceName[101];
#endif
/*                             */
/*=============================*/

short RunBackground;
short QuietMode = 0;
short CharSet = 0;
short BkgrColour = -1, ShadColour = -1, BottomColour=-1;
short FourWndRes = DEFAULT_BAR_WIDTH;
short AutoPlay = DEFAULT_AUTOPLAY;
short LoopPlay = DEFAULT_LOOPPLAY;
short ProbeCD = DEFAULT_PROBE;
short SaveData = DEFAULT_SAVE_DATA;
short SaveSet = DEFAULT_SAVE_SETTINGS;

short WaveObturate = DEFAULT_OBTURATE;
short WaveHRes = DEFAULT_PIX_WIDTH;
short WaveVRes = DEFAULT_PIX_HEIGHT;

/* short LogSuppressed; */

int  TimeoutStart = TIME_OUT_START;
int  TimeoutRepos = TIME_OUT_REPOSITION;
int  TimeoutLoad = TIME_OUT_LOAD;
int  TimeoutEject = TIME_OUT_EJECT;
int  DurationIntro = INTRO_DURATION_SEC;
int  DurationAdvance = STEP_DISCRETE;

char  *AppName;
char  AppVersion[15];

short OptionsChanged=0;
char  BkgrColourName[31];
MOUSE_SUPPORT_OPTION MouseSupport = MOUSE_DEFAULT;
MOUSE_SUPPORT_OPTION MouseSupportOrig = MOUSE_DEFAULT;
PLAY_MODE_TYPE  PlayMode = PLAY_NORMAL;
TIME_DISPLAY_MODE_TYPE TimeDisplayMode = DM_ELAPSED;
HEADER_MODE   HeaderMode = HEADER_TRACK;
OPERATION StartOper = OPER_NONE;
PLATFORM  Platform;


long TimeStart;
double Frames;
SPECTR_DISPLAY_MODE SpectrDisplayMode = SDM_MODULUS;


/*#define  FRAME_INTERVAL 10000l
long FrameInterval; */

char  UserAddr[151];
char  MailServer[151];
char  UserFullName[151];
char  ProxyURL[151];
short UseProxy=0, ProtocolUsed=2;
short UseLogFile = 0;
short ForceReg = 0;

extern short track_start;

extern short   HelpMode;
extern u_char track_cur;
extern u_char cd_status;
extern char  disc_name[], disc_artist[];
extern short  play_finished;
extern short  new_cd_in_db;

static char *PlayModesFull[] =
	{"NORMAL", "LIST", "RANDOM", "INTRO", "SINGLE"};
/*
#if HAVE_LINUX_UNISTD_H
_syscall3(int, syslog, int, type, char *, bufp, int, len);

#define LOG_START 4
#define LOG_END   7
#endif
*/

void TerminationHandler(int code)
{ 


    if (code != SIGKILL) cdaudio_deinitialize();
    sound_terminate();

    screen_deinitialize(); 
/*
#if HAVE_LINUX_UNISTD_H
    if(LogSuppressed)
	  syslog(8, NULL, LOG_END);
#endif
*/


    if (code == 0)
    { /* if (!RunBackground && ! QuietMode)
			print_epilogue(); */
       exit(0);
    }
    else
       exit(16);
}

/*
void ResizeHandler(int code)
{
	int y, x;
	
	fprintf (stderr, "Resize Handler Active\n");

	if (setupterm(NULL, STDIN_FILENO, NULL) == ERR) return;

    // COLS and LINES may very well become macros in future
    // This is why version check is needed   
#if NCURSES_VERSION_MAJOR < 5
    COLS = columns;
    LINES = lines;
#endif
  	
	// This is not provided (as yet ?) even with ncurses 5 
	if (stdscr != NULL)
	{  stdscr->_maxx = columns-1;
	   stdscr->_maxy = lines-1;
	}	

	getmaxyx(stdscr, y, x);

	fflush(stderr);
}

*/

int main(int argc, char *argv[])
{
      int    cd_only;
	u_char old_track;
	long timeout;
	char *trk_name;

#ifdef DSP_SUPPORT
	double mips;
#endif

/*      Platform = get_platform(); */
		Platform = PLTF_CURSES;
	  AppName = "sadp";

		strcpy(CDDeviceName, "/dev/cdrom");

#ifdef DSP_SUPPORT
		if(get_cpu_data(NULL, NULL, NULL, &mips) && mips > 250.0)
              FourInterlace = 0; else FourInterlace = 1;
#endif

#ifdef RCDDB_SUPPORT
      rcddb_initargs();
#endif       
      load_settings();
      if (!process_arguments(argc, argv)) return 16;

      if (StartOper != OPER_NONE) QuietMode = 1;
/*
#if HAVE_LINUX_UNISTD_H
      syslog(8, NULL, LOG_START);	
#endif
*/
      RunBackground = ((Platform != PLTF_XFORMS) || QuietMode) &&
                      ((tcgetpgrp (0) != getpid()) || !isatty(0));
      cd_only = RunBackground || QuietMode;

      if (RunBackground || StartOper == OPER_PLAY ||
               (QuietMode && StartOper == OPER_NONE) ) AutoPlay = 1;
      else
 	      if (StartOper != OPER_NONE) AutoPlay =  0;

      if ( !cdaudio_initialize()
                ||
           (!cd_only &&
		 ( !sound_initialize() || !screen_initialize(argc, argv)))
 	        ||
           !cdaudio_start()
                ||
           (!cd_only && !sound_start())
        )
      {  TerminationHandler(666);
                    return 8;
      }


      signal(SIGTERM, TerminationHandler);
      signal(SIGKILL, TerminationHandler);
/*      signal(SIGWINCH, ResizeHandler); */

      if(StartOper!= OPER_NONE && StartOper != OPER_PLAY)
      {   cdaudio_operate(StartOper);
	    goto FinitaLaComedia;
      }

      if (RunBackground | QuietMode)  goto BackgroundRoutine;

      TimeStart = time(NULL);
      Frames = 0;

	foreground_processing();
	goto FinitaLaComedia;


/* ================================================================ */

BackgroundRoutine:
      if (StartOper == OPER_NONE)
	  printf ("\nSing-Along Disk Player. Version %s (A.C.E '98 - '99)\n",
              get_sadp_version());
      
      check_cd();
      if (cd_status != CDROM_AUDIO_PLAY)
	{  printf ("Could not start play mode (no disk ?)\n\n");
         TerminationHandler(666);
	   return 8;
        }

	if (StartOper != OPER_NONE) goto FinitaLaComedia;

	if (RunBackground && PlayMode == PLAY_NORMAL )
	{
    	    printf ("Playing in background - no need for further intrusion. Bye-bye.\n\n");
	    goto FinitaLaComedia;
	}

	printf ("Running %s. Play mode - %s%s\n",
		 RunBackground ? "in background" : "low profile",
		 PlayModesFull[PlayMode], LoopPlay ? " LOOP" : "" );
	if (new_cd_in_db)
	{  printf ("Title:  %s\n", disc_name);
	   printf ("Artist: %s\n", disc_artist);
	}

	if (RunBackground)
	{   printf ("Enter 'kill %d' to quit\n", getpid());
	    timeout = 1000000;
	}
	else
	{
          fcntl(fileno(stdin), F_SETFL, O_NONBLOCK);
	    printf ("Enter: n - next, p -prev, q - quit, s - stop and quit\n\n");
	    timeout = 250000;
      }

	old_track = 0xff;

      while (1)
      {
	if (!RunBackground)
	{ switch(toupper(getchar()))
	  {
	      case 'S':
		cdaudio_operate(OPER_STOP);
			 /* Has to go further */

	      case 'Q':
		goto FinitaLaComedia;

	     case 'N':
	        cdaudio_operate(OPER_NEXT);
	        break;

	     case 'P':
	       cdaudio_operate(OPER_PREV);
	       break;
	  }
	
	  if (track_cur != old_track)
	  {
	       trk_name = new_cd_in_db ? "" :  cdaudio_get_track_name(track_cur);
               printf ("\rPlaying track %d. %s    ", track_cur, trk_name);
		   old_track = track_cur;
          }
	}
	else	
          if (play_finished) break;

        cdaudio_operate(OPER_NONE);
	usleep(timeout);
     } 


FinitaLaComedia:
    TerminationHandler(0);
    return 0;

}

