 /* =======================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
   
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ----------------------------------------------------------
    sadp_rcddb.c - started in April-99 and left "unattended"
            for 2.5 months. Return on 28-Jun-99 
    ========================================================= */


#include <sys/types.h>
#include <sys/stat.h>

#include "sad.h"
#ifdef RCDDB_SUPPORT

#if HAVE_ARPA_INET_H
#include <arpa/inet.h> 
#endif

#if HAVE_SYS_SOCKET_H 
#include <sys/socket.h> 
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h> 
#endif

#if HAVE_NETDB_H
#include <netdb.h>
#endif

#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
/* #include <linux/cdrom.h> */
#include "sadp_rcddb.h"


/* CDDB defaults */
#define CDDB_PROTOCOL_LEVEL 			3

	
const char  *http_retrieve_prefix = "GET";
const char  *http_submit_prefix = "POST";
const char  *http_suffix = "HTTP/1.0";
const char  *SubmitMode = "submit"; 
/* const char  *SubmitMode = "test"; */

char hello_string[257];

extern u_char dtrack_first, dtrack_last;
extern TRACK_INFO  *trk_info;     
extern char  disc_name[DATA_NAME_SIZE];
extern char  disc_artist[DATA_NAME_SIZE];
extern char  disc_extra[DATA_NAME_SIZE];
extern char **categories;
extern short cd_multi_artist;

extern int  tot_trks;
extern int  tot_duration;

extern const char UserAddr[];
extern const char *AppName;
extern const char AppVersion[];
extern const char ProxyURL[];
extern const char MailServer[];

/* extern short DataChanged; */
extern short UseLogFile;
extern FILE *LogFile;
extern const u_long cddb_disc_id;
extern char   *cdix_index;
extern char   *cdix_query;
extern char   *cddb_query;

static short use_proxy;
static struct sockaddr_in sin;		/* This is a standard structure */
					/* Linux declaration in <linux/in.h> */

const char  *ProtocolNames[] = {"cddbp", "http", "mail" }; 
const char  *RegMailDestinator =  "xsadp@yahoo.com"; 
/* const char  *RegMailDestinator =  "michg";  */
const char  *DataBaseTypes[] = {"CDDB", "CDIX"}; 
const char  *RegMailSubject = "SADP registration form";
const char  *anonym_text = "anonymous";

static char ErrMes[61];
extern char  DiscCategory[15], DefaultCategory[15];  

static char *convert_site_name(char *cddb_style,u_short pr_vers)
{
    char *site, *protocol, *port, *addr, *extra;	
    char converted_name[155];

    /* Data assumed to be right */
    site = strtokm(cddb_style, " ");
    protocol = strtokm(NULL, " "); 
    port = strtokm(NULL, " "); 
    addr = strtokm(NULL, " \r\n");  
    if (strcmp (addr, "-") == 0) addr = "/";	
    extra = strtokm(NULL, "\r\n");
    if (extra == NULL) extra = "";

    sprintf (converted_name, "%s://%s:%s%s, CDDB %u %s",
                   protocol, site, port, addr, (u_int)pr_vers, extra);    
		   
    return strdup(converted_name);		   

}


/* ========================================================*/
/* A clean example of socket programming, can go straight to
   a programming manual... and it can very well be from one
   of those originally. This piece of code successfully travelled
   from one application to another until it got rest here with
   some comments that I put mainly for myself to be sure that I
   have a vague idea of what is going on. */

/* Connects to a inet server, specified by name and port */
/* Returns socket_id, needed for i/o, '-1' if bad luck   */
static int cddb_connect(const char *server_name, u_short port, short verbose)
{
	int sock;
	struct hostent *host;           /* Destination host entry           */
	char message[61];

        if (verbose)
	{ snprintf (message, 61, "Looking up %s:%u",  server_name, (u_int) port);
	  if (!rcddb_message_handler(2, message)) return -1;
	}  
		 
      /*
	This code has been commented out, because gethostbyname  
	can handle both type of addresses (it has been tested).
	------------------------------------------------------
	u_long  serv_addr;	

	host = NULL;

	serv_addr = inet_addr(server_name); / * That shoud be ok * / 	
	if (serv_addr != INADDR_NONE)
	// * If the address is given as IP (e.g. 222.11.111.1), do it straight * /
           host = gethostbyaddr((char *)&serv_addr, sizeof(serv_addr), AF_INET);
	else
	// * If address is given as name (e.g. foo.foo.com),
	                                      try luck with gethostbyname * /
           host = gethostbyname(server_name);
      */  	   

      host = gethostbyname(server_name);
	if (host == NULL) goto HastaLaVista;   /* And system will supply message */

	if (host->h_addrtype != AF_INET) 
	{   strcpy(ErrMes, "Host name could not be resolved!\n");
	    return -1;
	}   	

	/* Now just create a socket, and see how it goes */	   
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0)  goto HastaLaVista; 


	/* Ok, we got the socket. What next?  Connect! */
	/* Hold on, we heed to prepare sockaddr_in */
        memset(&sin,0, sizeof(sin));

	sin.sin_family = AF_INET;	/* Connection type ARPA internet  */
	sin.sin_port = htons(port);	/* Conv port number to big endian */
        memcpy(&sin.sin_addr, host->h_addr, host->h_length);

	if (verbose) 
	{  snprintf (message, 61, "Trying %s", inet_ntoa(sin.sin_addr));
	   if (!rcddb_message_handler(2, message)) return -1;
	}   

	/* That's it. Now - beep, beep, hurrah! */	 
	if (connect(sock, (struct sockaddr *) &sin, sizeof(sin)) >= 0)
	{  if (verbose)
	   {
	       if (!rcddb_message_handler(2, "Connected!")) return -1;
	   }       
	   return sock;
	}   

HastaLaVista:
	strncpy(ErrMes, strerror(errno), 61);
        return -1;    
}	


static int cddb_reconnect(int sock)
{
       if (!rcddb_message_handler(2, "Reconnecting...")) return -1;
       close(sock);
       
       sock = socket(AF_INET, SOCK_STREAM, 0);
       if (sock < 0)  return -1;

       if (connect(sock, (struct sockaddr *) &sin, sizeof(sin)) >= 0)
       {  if (!rcddb_message_handler(2, "Success")) return -1;
	   return sock;
       }   

       strncpy(ErrMes, strerror(errno), 61); 
       return -1;    
}


/************************************************************
    Get a line from the server and returns actual length.
    Hardly needs any comments.		
*************************************************************/
static int cddb_get_server_line(int socket, char *linebuf, int max_len)
{   char inchar;
    int index;

    if (LogFile) fprintf (LogFile, "R: ");    

    for(index=0;;)
    { if (read(socket, &inchar, 1) <= 0)
      { if (index == 0) return -1;
        break;
      }

      if (inchar == '\n') break;
      
      if (LogFile && inchar != '\r') fputc ((int)inchar & 0xff, LogFile);    
      if (index < max_len) linebuf[index++] = inchar;
    }

    if (LogFile) fputc ((int)inchar & 0xff, LogFile);    
    linebuf[index] = '\0';
    return index;
}

void socket_send_line(int socket, const char *line)
{  
     if (LogFile)
	   fprintf(LogFile, "S: %s\n", line);  
     write (socket, line, strlen(line));   
     write (socket, "\r\n", 2);
}	 


static int cddb_send_and_get(const struct site_info *hi,
                             int socket,  char *message,
                             char *reply, int max_len)
{  char outline[501];
			      


    if (hi->pr_type == CDDB_MODE_CDDBP) 
	socket_send_line(socket, message);
    else
    {/*  if (use_proxy) */
	  char c;     
	  char *msgptr = message;
	  while ((c=*msgptr)!='\0')
	  { if (c == ' ') *msgptr = '+';
	    msgptr++;
	  }    

          snprintf (outline, 501, "%s http://%s%s?cmd=%s&%s",
	 		      http_retrieve_prefix, hi->site, hi->addressing,
			      message, hello_string);
     /*
          snprintf (outline, 501, "%s %s?cmd=%s&%s&%s",
	 		      http_prefix, hi->addressing,
			      message, hello_string);
    */   			      
	  socket_send_line(socket, outline);

	  /* Skip HTML header */    
	  while (cddb_get_server_line(socket, outline, 100) >=2);
    }   
    
    return cddb_get_server_line(socket, reply, max_len);
}    



/* Starts CDDB in interactive or HTTP mode. */

static int cddb_start_talking(const struct site_info *hi, 
                              const struct site_info *proxy, char pr_vers)
{
    char reply[6];
    char *buf, *ptr_domain;
    const char *ptr_name;
    char pr_type;
    int socket;		

    pr_type = hi->pr_type;

    use_proxy = (pr_type != CDDB_MODE_CDDBP) && (proxy != NULL); 
    if (!use_proxy) proxy = hi;

       

    /* Establish connection */		
    socket = cddb_connect(proxy->site, proxy->port, 1);
    if (socket < 0) return -1;



    if (pr_type == CDDB_MODE_CDDBP 
        && cddb_get_server_line(socket, reply, 3) < 3)
    {   strcpy(ErrMes, "No reply from server\n");
        return  -1; 
    }


    ptr_name = buf = strdup(UserAddr);
    ptr_domain = strchr(ptr_name, '@');
    if (ptr_domain != NULL)
        *ptr_domain++ = '\0';
    else
    {  
       ptr_name = anonym_text;
       ptr_domain = buf;
    }   
    
       
    if (pr_type == CDDB_MODE_CDDBP) 
    {   /* ============== INTERACTIVE MODE ============== */
    
         snprintf (hello_string, 301, "cddb hello %s %s %s %s", 
                       ptr_name, ptr_domain, AppName, AppVersion);	
         free(buf);		       

          /* Say hello */
         cddb_send_and_get(hi, socket,  hello_string, reply, 3);

         if (reply[0] != '2')
         {   strcpy(ErrMes, "Could not shake hands\n");
             return -1;
         }
      
         /* Set protocol */
         snprintf (hello_string, 301, "proto %d", pr_vers);
         cddb_send_and_get(hi, socket,  hello_string, reply, 3);
         if (reply[0] != '2' && reply[0] != '5')
         { strcpy(ErrMes, "Could not set protocol\n");
           return -1;
         }
    }
    else
    {    	 
         /* ============== HTTP MODE ============== */    
         snprintf (hello_string, 301, "hello=%s+%s+%s+%s&proto=%d %s\r\n", 
                       ptr_name, ptr_domain, AppName, AppVersion,
		           pr_vers, http_suffix);	
         free(buf);		       
    }	 
    return socket;
}

static void cddb_stop_talking(const struct site_info *hi, 
                             int socket)
{			     
    if (hi->pr_type == CDDB_MODE_CDDBP) 
    {  char reply[6];
       cddb_send_and_get(hi, socket, "quit", reply, 3);
    }
    
    close(socket);
}       



/* Retrivers information from CDDB data base */
short cddb_go_get_it(const struct site_info *hi,
                     const struct site_info *proxy)
{ 
    static short rc;
    int socket, i;		
    char reply[129];	
    char message[2048];
    char *name;	
    char *category, *cdiscid;
    short pr_type;


    pr_type = hi->pr_type;
    if (pr_type == CDDB_MODE_MAIL) return 0;
    name = (char *) ProtocolNames[pr_type];    

    if (LogFile)
      fprintf(LogFile, "I: Host %s://%s:%d [CDDB]\n", name,
                           hi->site, hi->port);

    snprintf(message, 129, "%s://%s:%d [CDDB]", name,
			   hi->site, hi->port);
    if (!rcddb_message_handler(1, message)) return 2;

    socket = cddb_start_talking(hi, proxy, hi->pr_vers);
    if (socket < 0) goto OutOfHere;

    rc = 0;

    /* Send disc information */

    sprintf(message,  "Sending disc info(id = %08lx)", cddb_disc_id);
    if (!rcddb_message_handler(2, message)) return 2;
    
    cddb_send_and_get(hi, socket, cddb_query, reply, 128);

    if (reply[0] != '2')
    {  strncpy(ErrMes, reply+4, 61);
       goto OutOfHere;
    }

    if(memcmp(reply, "200", 3) == 0)
    {  /* Exact match - single entry*/
	if (!rcddb_data_handler(0, "Disc search results"))
			    goto OutOfHere;
	if (!rcddb_data_handler(1, "Found exact match:")) 
			    goto OutOfHere;
        category = strtokm(reply+4, " \n");
        cdiscid = strtokm(NULL, " \r\n");
	name = strtokm(NULL, "\n");	/* Should be OK! */
	if (!rcddb_data_handler(2, name)) goto OutOfHere;
	rc = rcddb_data_handler(21, NULL);
	if (rc < 2) 
	{  if (rc == 1) rc = 0; else rc =2;
	   goto NormalReturn;
	}   
    }	
    else
    if(memcmp(reply, "21", 2) == 0)
    { /* Exact/inexact match */
	char categs[12][15];
	char discids[12][9];
	if (!rcddb_data_handler(0, "Disc search results"))
			    goto OutOfHere;
	if (!rcddb_data_handler(1, "Found following matches:")) 
			    goto OutOfHere;
	for (i=0; i<12; i++)
	{ 
    	    if (cddb_get_server_line(socket, reply, 128) < 2) break;
	    if (*reply == '.') break;
	    category = strtokm(reply, " \r\n");
	    strncpy(categs[i], category, 15);
	    cdiscid = strtokm(NULL, " \r\n");
	    strncpy(discids[i], cdiscid, 9);
	    name = strtokm(NULL, "\r\n");
    	    if (!rcddb_data_handler(2, name)) goto OutOfHere;
	}
	    
	if (i==0)
	{  strcpy(ErrMes, "No matches");
	   goto OutOfHere;
	}	   

	rc = rcddb_data_handler(21, NULL);
          /* Returns: 2 - Accept, 1 - Cancel, 0 - Continue */
	if (rc < 2) 
	{  if (rc == 1) rc = 0; else rc =2;
	   goto NormalReturn;
	}   

	rc -= 2;
	category = reply; 
        strcpy(category, categs[rc]);
	
	cdiscid = reply+30;
	strcpy(cdiscid, discids[rc]);
	
    }	
    else
     /* No match */
    {  strncpy(ErrMes, reply+4, 61);
       goto OutOfHere;
    }
    
    if (!rcddb_message_handler(2, "Getting disc data...")) return 2;

    /* Parsing reply */        
    if (hi->pr_type == CDDB_MODE_HTTP &&
        (socket = cddb_reconnect(socket)) < 0 ) return 0;
    
    strncpy(DiscCategory, category, 15);
    sprintf (message, "cddb read %s %s", category, cdiscid); 
    cddb_send_and_get(hi, socket, message, reply, 128);

    if (reply[0] != '2')
    {  strncpy(ErrMes, reply+4, 61);
       goto OutOfHere;
    } 

    clear_disc_tracks();	
    
    while(cddb_get_server_line(socket, message, 256) > 0)
    {    if (*message == '.') break;	
	   if ( process_cddb_line(message, 1) &&	
 	        !rcddb_message_handler(2, message)) return 2;
    }	

/*    DataChanged = 1; */
    rc = 1;

NormalReturn:       
    cddb_stop_talking(hi, socket);
    return rc;
    
OutOfHere:    
    cddb_stop_talking(hi, socket);

    if (strlen(ErrMes) == 0) 
    {
       if (LogFile) fprintf (LogFile, "E: Cancelled\n");   
    }      
    else
    {
       if (LogFile) fprintf (LogFile, "E: %s\n", ErrMes);   
       return rcddb_message_handler(21, ErrMes) ;
    }
    
    return 0;    
   
}





short  cddb_get_sites(struct site_info *hi,
                      const struct site_info *proxy,
                      char **to_sites, u_short *pcount,
		      char **to_categ, u_short *ccount)
{  
   int socket;
   u_short count, pr_vers, i;
   char *ptr;
   short categ_flag;    
   char reply[129];	
   short pr_type;

   strcpy(ErrMes, "");    	
   pr_type = hi->pr_type;
   if (pr_type == CDDB_MODE_MAIL) return 0;
   ptr = (char *) ProtocolNames[pr_type];    

   if (LogFile)
      fprintf(LogFile, "I: Host %s://%s:%d\n", ptr, hi->site, hi->port);

   snprintf(reply, 129, "%s://%s:%d", ptr, hi->site, hi->port);
   if (!rcddb_message_handler(1, reply)) return 2;


   socket = cddb_start_talking(hi, proxy, 3);
   if (socket < 0) goto ErrProcess;

   if (!rcddb_message_handler(2, "Getting protocol version")) 
	           goto ErrProcess;
		      
   reply[0] = '\0';
   cddb_send_and_get(hi, socket, "stat", reply, 60);
   reply[60] = '\0';
   if (reply[0] != '2')
   {  strcpy(ErrMes, "Could not get protocol version");
      goto ErrProcess;
   }

   pr_vers = 1; 
   categ_flag = 0;
   count = *ccount;
   
   while(cddb_get_server_line(socket, reply, 129) > 0)
   {  
      if (*reply == '.') break;	
      if ((ptr = strstr(reply, "max proto:")) != NULL &&
           isdigit(*(ptr+11)) )
             pr_vers =  atoi(ptr+10);
      else		     
      if (memcmp(reply, "Database entries by category", 28) == 0)
      {
          if (!rcddb_message_handler(2, "Getting list of categories") )
	           goto ErrProcess;
          categ_flag = 1;
	  continue;
      }	  	     
      else
      if (categ_flag)
      {  if (reply[0] != ' ' && reply[0] != '\t')
         {  categ_flag = 0;
	    continue;
	 }  
         ptr = reply + strspn(reply, " \t");
         strtokm(ptr, ":");
	 for (i=0; i<count; i++)
	 { if (strcasecmp(to_categ[i], ptr)==0) break; }
	 
         if (i>=count)
	   to_categ[count++] = strdup(ptr);
	     
      }	 
   }
   *ccount = count;
   
   if (pr_vers < 3)            	   
   {  strcpy (ErrMes, "Inadequate protocol version\n");
      goto ErrProcess;
   }

    
   snprintf (reply, 61, "Protocol version %d\n", pr_vers);
   if (!rcddb_message_handler(2, reply)) 
	           goto ErrProcess;
		   

   hi->pr_vers = pr_vers;
   if (hi->pr_type == CDDB_MODE_HTTP &&
        (socket = cddb_reconnect(socket)) < 0 )
	           goto ErrProcess;
	
	    
   reply[0] = '\0';
   if (!rcddb_message_handler(2, "Getting list of sites")) 
	           goto ErrProcess;

   cddb_send_and_get(hi, socket, "sites", reply, 3);
   if (reply[0] != '2')
   {
      strcpy (ErrMes, "Could not get sites\n");
      goto ErrProcess;
   }
    
    count = *pcount;    
    while(cddb_get_server_line(socket, reply, 256) > 0)
    {  
       if (*reply == '.') break;	
       to_sites[count++] = convert_site_name(reply, pr_vers);
    }   	           

    *pcount = count; 


/*
   count = *ccount;
   if (hi->pr_type == CDDB_MODE_HTTP &&
        (socket = cddb_reconnect(socket)) < 0 ) goto DopoQuesto;
	
    ptr = strdup("cddb lscat");
    reply[0] = '\0';
    cddb_send_and_get(hi, socket, ptr, reply, 3);
    free(ptr);
    if (reply[0] == '2')
    { if (!rcddb_message_handler(2, "Getting list of categories") )
	           goto ErrProcess;
	  
      while(cddb_get_server_line(socket, reply, 128) > 0)
      {  
         if (*reply == '.') break;	
	 strtokm(reply, "\r\n");
	 
	 for (i=0; i<count; i++)
	 { if (strcasecmp(to_categ[i], reply)==0) break; }
	 
         if (i>=count) to_categ[count++] = strdup(reply);
      }   	           
    }    

DopoQuesto:    
    *ccount = count;
*/    
    
    cddb_stop_talking(hi, socket);
    return 1;
    
ErrProcess:
    cddb_stop_talking(hi, socket);

    if (strlen(ErrMes) == 0) 
    {
       if (LogFile) fprintf (LogFile, "E: Cancelled\n");   
    }
    else
    {
       if (LogFile) fprintf (LogFile, "E: %s\n", ErrMes);   
       return rcddb_message_handler(21, ErrMes) ;
    }
    
    return 2;    
    
    
    
    
}

/* ================================================================= */	   
/*                       MAIL Processing                             */
/* ================================================================= */	   
#define generic_send_line socket_send_line

static int socket_send_and_get(int socket, char *buf, int max_len)
{   
     socket_send_line(socket, buf);

     return cddb_get_server_line(socket, buf, max_len);

}


int  start_sendmail(void)
{     static const char *paths[] = {"/sbin", "/usr/sbin", "usr/local/sbin",
                                     "/bin", "/usr/bin", "usr/local/bin", NULL };
      const char **pathptr;
      const char *path;			 
      char buf[121];
      FILE *f = NULL;
      int file_descr[2];
      int fork_result;
    
      pathptr = paths;    

      /* Looking for sendmail */
      while((path = *pathptr++) != NULL )
      {  
    	    sprintf(buf, "%s/sendmail", path);
	    f = fopen (buf, "r");
	    if (f) break;
      }	

      if (!f) goto ErrorTrap;

      fclose(f);

      if (pipe(file_descr)) goto ErrorTrap;

      fork_result = fork();

      if (fork_result == 0)
      {  /* Child */
         dup2(file_descr[0], STDIN_FILENO);
         close(file_descr[0]);
         close(file_descr[1]);
         execl(buf, "sendmail", "-t", NULL);
      }	
      else
      if (fork_result != -1) 
      {  /* Parent */
         close(file_descr[0]);
         return file_descr[1];
      }	 


 ErrorTrap:      
      strcpy(ErrMes, "Could not find/open sendmail");
      return -1;
}      


int start_smtp(const char *from_addr, const char *to_addr, short *anonym_flag_ptr)
{    int socket;
     char buf[121];
     const char *ptr;
     const static char *mail_from = "MAIL FROM:";
     short  address_type;   /* 0 - full, 1 -short, 2-anonymous */
     static const char *anonym_name = "anonymous";     
     
     socket = cddb_connect(MailServer, SMTP_DEFAULT_PORT, 0);
     if (socket < 0) goto Common;   /* Error message supplied in sub */

     if (cddb_get_server_line(socket, buf, 4) < 4 || 
         memcmp(buf, "220", 3) != 0) goto BadLuck;

     ptr = strchr(from_addr, '<');
     if (ptr)
     {  address_type=0;  ptr++;  }
     else
     {  address_type = strcmp(from_addr, anonym_name) ? 1: 2;
        ptr = from_addr;
     }	     
          
     snprintf (buf, 121, "HELO %s", ptr);
     strtokm(buf, "@>");
     if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;
     if (memcmp(buf, "250", 3) != 0)
     {  if (address_type != 2)
        {   
	    strcpy(buf, anonym_name);
            if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;
	    address_type = 2;
	}      
        if (memcmp(buf, "250", 3) != 0) goto BadLuck;
     }	

     /* Setting pointer to start of domain name */
     ptr = MailServer;     
    /*  if (memcmp(ptr, "mail.", 5) == 0) ptr+=5;  */

     switch (address_type)
     {  case 0:		/* Name + email */
          sprintf (buf, "%s %s", mail_from, from_addr);
	  break;
	  
        case 1:	  	/* Email only */
          sprintf (buf, "%s <%s>", mail_from, from_addr);
	  break;
	  
	case 2: 	/* Anonymous */	  
	/* New mail servers are more pendantic about 'mail from'. */
          snprintf (buf, 121, "%s <%s@%s>", mail_from, anonym_name, ptr);
	  break;
     }	  
 	 
     if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;

     if (memcmp(buf, "250", 3) != 0)
     {  if (address_type != 2)
        {  
	    address_type = 2;
            snprintf (buf, 121, "%s <%s@%s>", mail_from, anonym_name, ptr);
            if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;
	}      
        if (memcmp(buf, "250", 3) != 0) goto BadLuck;
     }	

     sprintf (buf, "RCPT TO: <%s>", to_addr);
     if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;
     if (memcmp(buf, "250", 3) != 0) goto BadLuck;
    
     strcpy(buf, "DATA");
     if (socket_send_and_get(socket, buf, 121) < 3) goto NoConnection;
/*     if (memcmp(buf, "354", 3) != 0) goto BadLuck; */
     if (anonym_flag_ptr) *anonym_flag_ptr = (address_type == 2); 
    
     return socket;
     
NoConnection:
    strcpy(ErrMes, "Mail server cannot be reached");
    goto Common;
    
BadLuck:
    strncpy(ErrMes, buf, 61);

Common:    
    return -1;

}

short rcddb_sendreg(void)
{
    int socket = -1;
    const char *ptr;
    char buf[121];
    short anonym_flag, smtp;
    int l;
    
    if (strcasecmp(MailServer, "localhost") == 0)
    {   /* Using sendmail */
        smtp = 0;
	socket = start_sendmail();
	anonym_flag = 0;
    }	
    else
    {  /* Using smtp */
        smtp = 1;
	socket = start_smtp(get_mail_fromaddr(),
	                    RegMailDestinator, &anonym_flag);
    }	
    if (socket < 0) goto Common;
	
    snprintf (buf, 121, "From: %s", get_mail_sender());
    generic_send_line(socket, buf);
    	
    snprintf (buf, 121, "To: %s", RegMailDestinator);
    generic_send_line(socket, buf);

    snprintf (buf, 121, "Subject: %s", RegMailSubject);
    generic_send_line(socket, buf);

    generic_send_line(socket, "");

    if (smtp==0)
    {   generic_send_line(socket, "Sent via 'sendmail'");
        generic_send_line(socket, "");
    }
    else
    if (anonym_flag)
    {   generic_send_line(socket, "This is an ANONYMOUS registration");
        generic_send_line(socket, "");
    }

    while((ptr = get_mail_contentline()) != NULL)
           generic_send_line(socket, ptr);

    l = 0;
    while((ptr = get_mail_commentline()) != NULL)
    {  if (l == 0)
       {   generic_send_line(socket, "");
           generic_send_line(socket, "Comments:");
	   l = 1;
       }	   
       generic_send_line(socket, ptr);
    } 

    generic_send_line(socket, "");



    generic_send_line(socket, ".");	/* Terminator */


    if (smtp > 0)
    {  
       strcpy(buf, "QUIT");
       l =  socket_send_and_get(socket, buf, 121);
       if (l < 3) goto NoConnection;
       if (memcmp(buf, "250", 3) != 0)
       { strncpy(ErrMes, buf, 61);
         goto Common;
       }	 
    }
           
    close(socket);

    return 1;

NoConnection:
    strcpy(ErrMes, "Mail server cannot be reached");

Common:
    if (LogFile) fprintf(LogFile, "E: %s\n", ErrMes);  
    show_error_message(ErrMes);        

    if (socket >=0) close(socket);
    return 0;
}


/* ================================================================= */	   

enum XML_STAGE
{  XML_START = 0,
   XML_HEADER = 1,
   XML_CDINFO = 2,
   XML_TRKINFO = 3,	
   XML_TAIL = 4	
};



char *cdi_parse_line(char *line, const char *sample)
{ 
   static char result[DATA_NAME_SIZE];
   char delim[21];
   char *ptrs, *ptre;

   sprintf(delim, "<%s>", sample);
   ptrs = strstr(line,delim);
   if (!ptrs) return NULL;

   ptrs += strlen(delim);	
   sprintf(delim, "</%s>", sample);
   ptre = strstr(ptrs, delim);

   if (ptre)  *ptre = '\0';
       else   strtokm(ptrs, "\r\n");

   strncpy(result, ptrs, DATA_NAME_SIZE);
   convert_str_sequence(result, "&lt;", "<");
   convert_str_sequence(result, "&gt;", ">");
   convert_str_sequence(result, "&amp;", "&");
   convert_str_sequence(result, "&nbsp;", " "); 
   return result;
}
      
   

short cdi_parse_xml(int socket)
{
   char buf[121];
   char *ptr;
   enum XML_STAGE stage;	  
   short trk_no;
   char *termin_pattern = "</SingleArtistCD>";
   char *trk_name_ptr;
   short rc;    
    
   cd_multi_artist = 0;
   stage = XML_START;  
   trk_no = -1;
   rc = 0;


   while(cddb_get_server_line(socket, buf, 121) >= 0)
   {

      if (stage == XML_TAIL || strstr(buf, "</CDInfo>")) break;	
	
      switch(stage)  	
      { case XML_START:	
  	  /* Check for xml header */
	  if (strstr(buf, "not found"))
	  {   rc = rcddb_message_handler(21, "Disc not found") ;
	      goto Ausgang;
	  }       
	  
          if (!strstr(buf, "<?xml"))
          { strcpy(ErrMes, "This does not appear to be an XML file");
            goto Ausgang;
          }
          stage = XML_HEADER;
          break;

	case XML_HEADER:
          /* Look for CDInfo */
      	  if (strstr(buf, "<CDInfo>"))
	     stage = XML_CDINFO; 
	  break;

	case XML_CDINFO:
      	  ptr = cdi_parse_line(buf, "Title");
	  if (ptr)
          {
   	     if (!rcddb_data_handler(0, "Disc search results") ||
    	         !rcddb_data_handler(1, "Found:")) 
	     {  rc = 2;	 goto Ausgang; }

	     strncpy(buf, ptr, DATA_NAME_SIZE);
	     rcddb_data_handler(2, buf);

	     rc = rcddb_data_handler(21, NULL);	
	     
	     /* Returns: 2 - Accept, 1 - Cancel, 0 - Continue */
	     if (rc != 2) 
	     {  if (rc == 1) rc = 0; else rc = 2;
	        goto Ausgang;
	     }	

	     /* Comitted to modify - start with title & extra */
	     strncpy(disc_name, ptr, DATA_NAME_SIZE);
	     strcpy(disc_extra, "");
             break;
          }
	  else
          if (strstr(buf, "<SingleArtistCD>"))
	     stage = XML_TRKINFO;
	  else
	  if (strstr(buf, "<MultipleArtistCD>"))
	  {  termin_pattern = "</MultipleArtistCD>";
	     strcpy(disc_artist, "<Multiple Artist CD>");
	     stage = XML_TRKINFO;
	     cd_multi_artist = 1;
	  }	
	  break;

	case XML_TRKINFO:
      	  ptr = cdi_parse_line(buf, "Artist");
	  if (ptr)
          {
	     if (cd_multi_artist && trk_no >= dtrack_first)
             {  trk_name_ptr = trk_info[trk_no-dtrack_first].artist;
      	        strncpy(trk_name_ptr,  ptr, DATA_NAME_SIZE);
             }
	     else
	        strncpy(disc_artist, ptr, DATA_NAME_SIZE);

	     break;	
          }

	  if (trk_no >= dtrack_first &&
          	(ptr = cdi_parse_line(buf, "Name")))
          {  trk_name_ptr = trk_info[trk_no-dtrack_first].name;
 	     strncpy(trk_name_ptr,  ptr, DATA_NAME_SIZE);

      /*     sprintf(buf, "Track %u: %s", trk_no, trk_name_ptr );   	
             if (!rcddb_message_handler(2, buf))
	     { rc = 2; goto Ausgang; }   */
	     break;
          }

	  /* Those two are taken to the end, because of rude strstr use */
	  ptr = strstr(buf, "Track Num");
	  if (ptr && (ptr = strchr(ptr, '\"')) != NULL)
	  {  strtokm(++ptr, "\"\r\n");
             trk_no = atoi(ptr);
	     if (trk_no >= dtrack_first)
	     {   strcpy(trk_info[trk_no-dtrack_first].name, "");
	         strcpy(trk_info[trk_no-dtrack_first].artist, "");
	     }		 
	     break;	
          }

	  ptr = strstr(buf, termin_pattern);
	  if (ptr) stage = XML_TAIL; 
	  break;     /* Redundant - just kept for accuracy  */
	
	  	  	
	case XML_TAIL:
	  break;  
      } /* switch */
   } /* while */

   if (stage >= XML_TRKINFO)  rc = 1;    

Ausgang:
   return rc;
} 

	 				
    	   
short cdix_go_get_it(const struct site_info *hi,
                     const struct site_info *proxy)
{ 
    static short rc;
    int socket=-1;		
    char message[2048];

    
    if (LogFile)
      fprintf(LogFile, "I: Host http://%s:%d [CDIX]\n", 
                           hi->site, hi->port);

    snprintf(message, 129, "http://%s:%d [CDIX]",
			   hi->site, hi->port);
    if (!rcddb_message_handler(1, message)) return 2;

    if (proxy == NULL) proxy = hi;

    /* Establish connection */		
    socket = cddb_connect(proxy->site, proxy->port, 1);
    if (socket < 0) goto OutOfHere;   


    /* Preparing http query */
    rc = 0;
    
    sprintf(message, "Sending disc index(id = %s)", cdix_index);
    if (!rcddb_message_handler(2, message)) return 2;

    snprintf (message, 2048, "%s http://%s%s?id=%s&%s %s\r\n",
			      http_retrieve_prefix,
	 		      hi->site, hi->addressing, cdix_index,
			      cdix_query, http_suffix);
   if (LogFile)
	   fprintf(LogFile, "S: %s\n", message);  
    socket_send_line(socket, message);
	   
    while (cddb_get_server_line(socket, message, 100) >=2);

    rc =  cdi_parse_xml(socket);
    if (rc != 1) goto OutOfHere;
    
    strcpy(DiscCategory, DefaultCategory);
    close(socket);
/*    DataChanged = 1; */
    return 1;
    
OutOfHere:    
    if (socket >= 0) close(socket);

    if (strlen(ErrMes) == 0) 
    {
       if (LogFile) fprintf (LogFile, "E: Cancelled\n");   
    }      
    else
    {
       if (LogFile) fprintf (LogFile, "E: %s\n", ErrMes);   
       return rcddb_message_handler(21, ErrMes) ;
    }
    
    return rc;    
   
}

/* =================================================================== */
/*                    S U B M I S S I O N                              */
/* =================================================================== */  
short rcddb_submit(const struct site_info *hi,
                  const struct site_info *proxy,
		  char *db_file_name, unsigned long db_file_length)
{
    const char *db_type_text;
    int socket = -1, dbf=-1;
    char buf[121];
    char db_type;
    int pr;
    int l;
    short rc;
    short send_mode;  /* 0-sendmail, 1-smtp, 2-http */
    char *bigbuf = NULL;
        

    pr = hi->pr_type;
    if (pr == CDDB_MODE_CDDBP) return 0;

    rc= 0;
    db_type = hi->db_type;
    db_type_text = DataBaseTypes[(int)db_type];

    dbf = open(db_file_name, O_RDONLY);   
    if (dbf<0) return 0;
        
    if (pr == CDDB_MODE_MAIL)
    {
      if (db_type != 0) return 0;  /* No email submission for CD-INDEX */    
      if (LogFile)
	fprintf(LogFile, "I: Mail address:  %s [%s]\n",
	                            hi->site,  db_type_text);
	  
	snprintf(buf, 121, "mail://%s [%s]", hi->site, db_type_text);
      if (!rcddb_message_handler(1, buf)) goto Disconnect;
    
      if (strcasecmp(MailServer, "localhost") == 0)
       {   /* Using sendmail */
		send_mode = 0;
		socket = start_sendmail();
       }	
       else
       {   /* Using smtp */
		send_mode = 1;
		socket = start_smtp(UserAddr, hi->site, NULL);
		if (socket < 0) goto Common;
       }	


//       snprintf (buf, 121, "From: %s", get_mail_sender());
       snprintf (buf, 121, "From: %s", UserAddr);
       generic_send_line(socket, buf);
    	
       snprintf (buf, 121, "To: %s", hi->site );
       generic_send_line(socket, buf);

       snprintf (buf, 121, "Subject: cddb %s %lx", DiscCategory,
                                               cddb_disc_id);
       generic_send_line(socket, buf);
       
    }
    else    /* CDDB or CDIX HTTP */
    {
        send_mode = 2;
	
        if (LogFile)
	  	   fprintf(LogFile, "I: Host http://%s:%d [%s]\n", 
      	                     hi->site, hi->port, db_type_text);
        snprintf(buf, 121, "http://%s:%d [%s]", 
			   hi->site, hi->port, db_type_text);
        if (!rcddb_message_handler(1, buf)) goto Disconnect;
	
		    
	/* Establish connection */		
	if (proxy == NULL) proxy = hi;
        socket = cddb_connect(proxy->site, proxy->port, 1);
	if (socket < 0) goto Common;

      sprintf (buf, "Sending HTTP header (discid = %lu)", cddb_disc_id);  
      if (!rcddb_message_handler(2, buf)) goto Disconnect;

        /* HTTP query */
        snprintf (buf, 121, "%s http://%s%s %s",
	 		      http_submit_prefix, hi->site, hi->addressing,
			      http_suffix);
        socket_send_line(socket, buf);

        /* HTML header */
	if (db_type == 0)
	{ 
	    /* CDDB */
	    /* N.B. CDDB no longer supports this type of submission
                  This part is preserved as a part of history */
 	    sprintf(buf, "Category: %s", DiscCategory);
          socket_send_line(socket, buf);
          sprintf(buf, "Discid: %lx", cddb_disc_id);
          socket_send_line(socket, buf);
          sprintf(buf, "User-Email: %s", UserAddr);
          socket_send_line(socket, buf);
          sprintf(buf, "Submit-Mode: %s", SubmitMode);
          socket_send_line(socket, buf);
/*        sprintf(buf, "Charset: ISO-8859-1");
	    socket_send_line(socket, buf);  */
	    sprintf(buf, "X-Cddbd-Note: %s related issues: %s", AppName, RegMailDestinator);
          socket_send_line(socket, buf);
	}    
	else 
	{  /* CDINDEX */
	    strcpy(buf, "Connection: Keep-Alive");
          socket_send_line(socket, buf);
	    sprintf(buf, "Host: %s", hi->site);
          socket_send_line(socket, buf);
	    strcpy(buf, "Accept: */*");
          socket_send_line(socket, buf);
	    strcpy(buf, "Content-type: text/plain");
          socket_send_line(socket, buf);
	 }	    
 	 
	   sprintf(buf, "Content-Length: %ld", db_file_length);
         socket_send_line(socket, buf);
    }	

    generic_send_line(socket, "");  /* End of mail/html header */

    bigbuf = malloc(db_file_length);
    if (!bigbuf)
    {  strcpy(ErrMes, "Could not allocate transfer buffer");
       goto Common;
    }
    
    if (read(dbf, bigbuf, db_file_length) != db_file_length)
    {  strcpy(ErrMes, "Error reading data filer");
       goto Common;
    }
    close(dbf); dbf = -1;
    
    sprintf (buf, "Sending disc data");  
    if (!rcddb_message_handler(2, buf)) goto Disconnect;
    
    write(socket, bigbuf, db_file_length);

    if (LogFile)
        fwrite(bigbuf, db_file_length, 1,  LogFile);
             
    free(bigbuf); bigbuf = NULL;
    
    sprintf (buf, "Checking result");  
    if (!rcddb_message_handler(2, buf)) goto Disconnect;

    
    if (pr == CDDB_MODE_MAIL)
    {
      generic_send_line(socket, ".");	/* Terminator */

      if (send_mode > 0)
      {   /* For smtp server only */
          strcpy(buf, "QUIT");
          l =  socket_send_and_get(socket, buf, 121);
          if (l < 3) goto NoConnection;
          if (memcmp(buf, "250", 3) != 0)  
	  {  strncpy(ErrMes, buf, 61);
	     goto Common;
	  }     
      }
    }
    else
    {
       /* HTTP protocol */
        while (cddb_get_server_line(socket, buf, 10) >=2);

	 
        cddb_get_server_line(socket, buf, 121);
        if (memcmp(buf, "200", 3) != 0 && memcmp(buf, "100", 3) != 0)
        {  snprintf (ErrMes, 61, "Error: %s\n", buf);
           if(db_type == 1)
    	        while(cddb_get_server_line(socket, buf, 121) >=2)
           goto Common;
        }   
	  
    }	     
    close(socket); 	  

    rcddb_message_handler(2, "Submitted !");
    return 1;


Disconnect:
    rc = 2;
    goto Common;

NoConnection:
    strcpy(ErrMes, "Server cannot be reached");

Common:
    
    if (LogFile) fprintf(LogFile, "E: %s\n", ErrMes);  

    if (bigbuf) free(bigbuf);
    if (dbf>=0) close(dbf);    
    if (socket >=0) close(socket); 
    return rcddb_message_handler(21, ErrMes) ;
}

/* Returns: zero     - for empty line,
            non-zero - for non-empty line
*/	     
static short check_line_emptiness(const char *line)
{
   int l = strspn(line, " ");
   return  (short)line[l];
}   


/* Returns:  0    - OK,
             1    - No title
	     10+i - Track i name is missing or invalid 
*/	     
short check_cdinfo_completeness(void)
{   int i;
    char trk_name[21];
    
    if(check_line_emptiness(disc_name) == 0 ||
	strstr(disc_name, "* Unknown *"))	    
	    return 1;  /* No title */

    for (i=dtrack_first; i<=dtrack_last; i++)
    {
	strncpy(trk_name, trk_info[i-dtrack_first].name, 21);
	if (check_line_emptiness(trk_name) == 0)
		return 10+i;

	trim(trk_name);
	if (strncasecmp(trk_name, "Track ", 6) == 0 &&				    
	    isdigit(trk_name[6])) return 10+i;
    }    	    

    return 0;
}
  
#endif   /* RCDDB_SUPPORT */
