#define CDDBP_DEFAULT_PORT			8880
#define HTTP_DEFAULT_PORT			80
#define SMTP_DEFAULT_PORT			25

typedef enum 
{  CDDB_MODE_CDDBP = 0,
   CDDB_MODE_HTTP  = 1,
   CDDB_MODE_MAIL  = 2
}  CDDB_MODE;

struct site_info
{  u_short port;   
   char db_type;   /* 0 - CDDB, 1 - CDINDEX */
   char pr_type;   /* 0 - CDDBP, 1 - HTTP */       
   char pr_vers;   /* Protocol version: 3 or 4 */       
   char site[60];
   char addressing[60];
   char extra[60];       
};

short  cddb_get_sites(struct site_info *hi,
                      const struct site_info *proxy,
                      char **to_sites, u_short *pcount,
		      char **to_categ, u_short *ccount);
		     
short cddb_go_get_it(const struct site_info *hi,
                     const struct site_info *proxy);

short cdix_go_get_it(const struct site_info *hi,
                     const struct site_info *proxy);

short rcddb_submit(const struct site_info *hi,
                  const struct site_info *proxy,
			char *db_file_name, unsigned long db_file_length);

short check_cdinfo_completeness(void);
short rcddb_get_disc_data(void);
void  rcddb_guess_config(void);
short refresh_active_sites(void);
short rcddb_submit_data(char **sites);

short rcddb_message_handler(int type, char *message);
short rcddb_data_handler(int type, char *message);
void rcddb_show_message(char *message);

short save_rcddb_config(void);

short rcddb_sendreg(void);

short reg_new(void);
const char *get_mail_fromaddr(void);
const char *get_mail_sender(void);
const char *get_mail_contentline(void);
const char *get_mail_commentline(void);
void trim(char *line);

char *get_cddb_query(void);
short make_xmcd_file(char **file_name_ptr, long *file_length);


char *generate_cdindex(void);
char *get_cdindex_query(void);
void  convert_str_sequence(char *text, const char *ptrn, const char *subst);
short make_xml_file(char **file_name_ptr, long *file_length);


/* Some "imported" programs */
unsigned char *rfc822_binary (void *src,unsigned long srcl,unsigned long *len);

#define SHA_BLOCKSIZE		64
#define SHA_DIGESTSIZE		20

typedef struct {
    u_long digest[5];		/* message digest */
    u_long count_lo, count_hi;	/* 64-bit bit count */
    u_char data[SHA_BLOCKSIZE];	/* SHA data buffer */
    int local;			/* unprocessed amount in data */
} SHA_INFO;

void sha_init(SHA_INFO *);
void sha_update(SHA_INFO *, u_char *, int);
void sha_final(unsigned char [20], SHA_INFO *);

#define SHA_VERSION 1


/*  #define SIZEOF_LONG 4 */

#ifdef WORDS_BIGENDIAN
#  if SIZEOF_LONG == 4
#    define SHA_BYTE_ORDER  4321
#  elif SIZEOF_LONG == 8
#    define SHA_BYTE_ORDER  87654321
#  endif
#else
#  if SIZEOF_LONG == 4
#    define SHA_BYTE_ORDER  1234
#  elif SIZEOF_LONG == 8
#    define SHA_BYTE_ORDER  12345678
#  endif
#endif

