 /* ==========================================================
    SING - ALONG DISC PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
   
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ----------------------------------------------------------
    sadp_rcddbcurses - started 02-Nov-99
    ========================================================= */
#include <curses.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>
#include "sad.h"
#include "sadp_rcddb.h"
#include "sadp_curses.h"
#include "sadp_cursctrls.h"

#ifdef RCDDB_SUPPORT

#define HELP_PLAY_TIMEOUT ((TIME_OUT_HELP_ADVANCE) * 1000)

extern const  char  *ResrcName;
extern char UserAddr[];
extern char *UserAddrReal;
extern char MailServer[];
extern char *AppName;
extern char AppVersion[];
extern char  UserFullName[];
extern char  ProxyURL[];
extern short UseProxy, ProtocolUsed;
extern char  disc_name[DATA_NAME_SIZE];
extern char  disc_artist[DATA_NAME_SIZE]; 
extern u_long disc_revision;
extern char   cd_description[];
extern char   cd_model[];

extern short	SitesChanged, OptionsChanged;
extern short	DataChanged, no_cd;
extern short	FourWndCount, HelpFocus, BottomSection;
extern int		ScreenW, ScreenH;
extern int		MainWndLeft, MainWndWidth;
extern int		HelpWndHeight, HelpWndLeft, HelpWndWidth;

extern char **psites, **asites, *ssites, **categories;
extern char *default_categories[]; 

extern char  *RegMailDestinator;
extern char  *RegMailSubject;

extern char  CDDeviceName[];
extern char  AudioDeviceName[];

extern char  DiscCategory[15], DefaultCategory[15];  
extern const char  *anonym_text;

extern u_char CDDeviceType, CDNodeNumber;

extern u_long cddb_disc_id;
extern short cd_multi_artist;
extern char   *cdix_index;
#ifdef MCN_SUPPORT
extern const char *cd_upcode;   /* MCN (UPC) */
#endif

extern chtype btn_attr, side_attr, side_text_attr, side_dim_attr;
extern chtype bkgr_attr, fill_attr, text_attr, thumb_attr, dimmed_attr;
extern chtype brow_attr, brow_hilite_attr, bar_attr;
extern chtype help_attr, help_hdr_attr, help_title_attr;

extern chtype cCkboard,cBlock; /* cBar, cBullet, cBullet1, cDiamond; */
extern WINDOW  *MainWnd, *HelpWnd, *OverlapWnd;

#if defined(DSP_SUPPORT) && defined(ALSA_DSP_SUPPORT)
extern int alsa_dsp;
extern short mmap_active;
#endif

static SCF_FORM  *MsgForm = NULL;
static SCF_TEXT  *MsgText1 = NULL, *MsgText2 = NULL;

static SCF_FORM  *SelForm = NULL;
static SCF_BROWSER *SelBrowser;

static SCF_FORM  *SubmitForm = NULL;
static SCF_TEXT  *SubmitDiscTitle = NULL;
static SCF_TEXT  *SubmitRevNo = NULL, *SubmitEmail = NULL; 
static SCF_TEXT  *SubmitMultiArtist = NULL;
static SCF_TEXT  *SubmitIndex = NULL, *SubmitDiscId = NULL;
static SCF_TICK  *SubmitSetCatDef = NULL;
static SCF_BUTTON   *SubmitSend = NULL, *SubmitCancel = NULL;
static SCF_BUTTON   *SubmitRemSite = NULL;
static SCF_BROWSER  *SubmitCategs = NULL;
static SCF_BROWSER  *SubmitSites = NULL;
#ifdef MCN_SUPPORT
static SCF_TEXT  *SubmitMCN = NULL;
#endif

static SCF_FORM	 *RcddbForm = NULL;
static SCF_INPUT	 *RcddbUser = NULL;
static SCF_INPUT	 *RcddbProxyAddr = NULL;
static SCF_INPUT	 *RcddbMailAddr = NULL;
static SCF_BUTTON	 *RcddbProxyOn = NULL;
static SCF_BUTTON	 *RcddbGuess = NULL;
static SCF_BROWSER *RcddbSiteList = NULL;
static SCF_BUTTON  *RcddbUp = NULL;
static SCF_BUTTON  *RcddbDelete = NULL;
static SCF_BUTTON  *RcddbDown = NULL;
static SCF_BUTTON  *RcddbProtocol = NULL;
static SCF_BUTTON  *RcddbRefresh = NULL;
static SCF_TEXT    *RcddbCaption = NULL;

static SCF_FORM  *RegForm = NULL;
static SCF_INPUT  *RegSender = NULL;
static SCF_INPUT  *RegServer = NULL;
static SCF_INPUT  *RegComments = NULL;
static SCF_BROWSER  *RegDetails = NULL;
static SCF_TICK  *RegAnonym = NULL;
static SCF_BUTTON *RegCancel = NULL, *RegSend=NULL;


extern  MOUSE_SUPPORT_OPTION MouseSupport;
extern  MEVENT  LastMouseEvent;

static  int submit_process_action(void *obj, SCF_EVENT event, int action);
static  int rcddb_process_action(void *obj, SCF_EVENT event, int action);

static  void rcddb_paint_border(SCF_FORM *frm);


#define MESSAGE_FORM_HEIGHT 12
#define MESSAGE_FORM_WIDTH  46

#define SEL_FORM_HEIGHT 16
#define SEL_FORM_WIDTH  46

enum RCDDB_CONTROL_INDICES
{
    RCDDB_USER,         RCDDB_PROXYON,
    RCDDB_PROXYADDR,    RCDDB_MAILADDR,
    RCDDB_GUESS,        RCDDB_SITELIST,
    RCDDB_HIDDEN,       RCDDB_UP,
    RCDDB_DELETE,		RCDDB_DOWN, 	
    RCDDB_TEXT1,
    RCDDB_PROTCHOICE,   RCDDB_REFRESH
};    
      
/*==============================================================*/
static int  idle_function(SCF_FORM *frm)
{
     if (MainWnd)
     {  cdaudio_operate(OPER_NONE);
	  wrefresh(MainWnd);
	  wrefresh(frm->wnd);
     }
     return 0;
}

static int  idle_function_cd(SCF_FORM *frm)
{
     if (MainWnd)
     {  cdaudio_operate(OPER_NONE);
	  wrefresh(MainWnd);
	  wrefresh(frm->wnd);
	  if (no_cd) return 2;
     }
     return 0;
}


/* Type:
	100 - initilaize
	  0 - show form
	  1 - set header
          2 - set message
	 20 - hide 
	 21 - error - wait for press 
*/	 
#define BOTTOM_TAG1  0x1001
#define BOTTOM_TAG2  0x1002


/* Creates communication forms */
int  create_form_sadp_comm(void)
{
	int wid, hei;
	SCF_OBJECT *obj;

        /* -------------------------- */
        /*       RCDDB section        */ 
        /* -------------------------- */
	RcddbForm = scf_create_form(MainWnd, HelpWndHeight, HelpWndWidth,
                               BOTTOM_LOCATION, HelpWndLeft, 
                               NULL);
	RcddbForm->frame_drawer = rcddb_paint_border;
	scf_set_form_frame_attr(RcddbForm, bkgr_attr, cCkboard);

	scf_create_text(RcddbForm, 1, -1, 1, 2, "User address: ");            
	RcddbUser= scf_create_input(RcddbForm, 1, HelpWndWidth - 26,
         					 1, 16, NULL, 1, 150);            
	if (!RcddbUser) return 0;                                    
	scf_set_object_attr(RcddbUser, side_attr, thumb_attr);
      
	scf_create_text(RcddbForm, 1, -1, 3, 2, "Proxy server: ");            
	RcddbProxyAddr = scf_create_input(RcddbForm, 1, HelpWndWidth - 26,
         					 3, 16, NULL, 1, 150);           

	scf_create_text(RcddbForm, 1, -1, 5, 2, "Mail server:  ");            
 	RcddbMailAddr = scf_create_input(RcddbForm, 1, HelpWndWidth - 26,
         					 5, 16, NULL, 1, 150);            
      
  	RcddbGuess =  scf_create_button(RcddbForm, 1, 7,
                                1, HelpWndWidth - 9, "Guess",
                                 SCF_CTRLS_SUBST); 
	if (!RcddbGuess) return 0;  
	scf_set_object_shortcuts(RcddbGuess, 'G'-'A'+1, 0);
	scf_set_object_callback(RcddbGuess,
                             rcddb_process_action, RCDDB_GUESS);

	RcddbProxyOn = scf_create_button(RcddbForm, 1, 7,
                                 3, HelpWndWidth-9, "Proxy", 
					    SCF_CTRLS_SUBST);
	if (!RcddbProxyOn) return 0;  
	scf_set_object_shortcuts(RcddbProxyOn, 'X'-'A'+1, 0);
	scf_set_object_align(RcddbProxyOn, SCF_CENTRE_ALIGN);
	scf_set_object_callback(RcddbProxyOn,
                             rcddb_process_action, RCDDB_PROXYON);

	RcddbProtocol = scf_create_button(RcddbForm, 1, 7,
                                 5, HelpWndWidth-9,
                                 "HTTP", SCF_CTRLS_SUBST);
	if (!RcddbProtocol) return 0;  
	scf_set_object_shortcuts(RcddbProtocol, 'P'-'A'+1, 0);
	scf_set_object_align(RcddbProtocol, SCF_CENTRE_ALIGN);
	scf_set_object_callback(RcddbProtocol,
                             rcddb_process_action, RCDDB_PROTCHOICE);

	RcddbSiteList = scf_create_browser(RcddbForm,
		 HelpWndHeight-7, HelpWndWidth-10, 7, 0, " Download Sites ");
	if (!RcddbSiteList) return 0;  
	RcddbForm->cur_browser = (SCF_OBJECT *)RcddbSiteList;
	RcddbForm->alt_browser = (SCF_OBJECT *)NULL;

	RcddbUp = scf_create_button(RcddbForm,
		 1,  7, 8, HelpWndWidth-9, "Up", SCF_CTRLS_SUBST);
	scf_set_object_align(RcddbUp, SCF_CENTRE_ALIGN);
	scf_set_object_shortcuts(RcddbUp, 'U'-'A'+1, 0);
	scf_set_object_callback(RcddbUp,
                             rcddb_process_action, RCDDB_UP);

	RcddbDelete = scf_create_button(RcddbForm,
		 1,  7, 10, HelpWndWidth-9, "Delete", SCF_CTRLS_SUBST);
	scf_set_object_align(RcddbDelete, SCF_CENTRE_ALIGN);
	scf_set_object_callback(RcddbDelete,
                             rcddb_process_action, RCDDB_DELETE);
	scf_set_object_shortcuts(RcddbDelete, 'D'-'A'+1, 0);

	RcddbDown = scf_create_button(RcddbForm,
		 1,  7, 12, HelpWndWidth-9, "Down", SCF_CTRLS_SUBST);
	scf_set_object_align(RcddbDown, SCF_CENTRE_ALIGN);
	scf_set_object_callback(RcddbDown,
                             rcddb_process_action, RCDDB_DOWN);
	scf_set_object_shortcuts(RcddbDown, 'W'-'A'+1, 0);

	RcddbRefresh = scf_create_button(RcddbForm,
		 1,  7, -3, -9, "Update", SCF_CTRLS_SUBST);
	scf_set_object_align(RcddbRefresh, SCF_CENTRE_ALIGN);
	scf_set_object_callback(RcddbRefresh,
                             rcddb_process_action, RCDDB_REFRESH);
	scf_set_object_shortcuts(RcddbRefresh, 'T'-'A'+1, 0);

   	RcddbCaption = scf_create_text(RcddbForm, 1, -1,
                            -1, CENTRAL_LOCATION,
                               " Remote data ");
	if (!RcddbCaption) return 0;  
	((SCF_OBJECT *)RcddbCaption)->flags |= SCF_GETS_FOCUS;                        
	scf_set_object_attr(RcddbCaption, bar_attr, bar_attr);

	obj = (SCF_OBJECT *)scf_create_text(RcddbForm, 1, 5, -1, -8, "");            
	scf_set_object_align(obj, SCF_CENTRE_ALIGN);
	scf_set_frm_overlap_object(RcddbForm, obj);

        /* -------------------------- */
        /*       Message form         */ 
        /* -------------------------- */
	MsgForm = scf_create_form(NULL,
	      MESSAGE_FORM_HEIGHT, MESSAGE_FORM_WIDTH,
	      CENTRAL_LOCATION, CENTRAL_LOCATION, NULL);               
	if (!MsgForm) return 0;
            
	MsgText1 = scf_create_text(MsgForm,
              1, MESSAGE_FORM_WIDTH-4, 2, 2, NULL);            
	if (!MsgText1) return 0;
	scf_set_object_attr(MsgText1, help_title_attr, -1);
	scf_set_object_align(MsgText1, SCF_CENTRE_ALIGN);

	MsgText2 = scf_create_text(MsgForm,
             1, MESSAGE_FORM_WIDTH-4,  5, 2, NULL);            
	if (!MsgText2) return 0;
	scf_set_object_attr(MsgText2, help_attr, -1);
	scf_set_object_align(MsgText2, SCF_CENTRE_ALIGN);
	    
	scf_arrange_bottom_buttons(MsgForm,
            btn_attr, thumb_attr,
 	    BOTTOM_TAG1, SCF_CTRLS_SUBST,  
            1, 8, "Cancel", "C\033");

	scf_arrange_bottom_buttons(MsgForm,
	    btn_attr, thumb_attr,
	    BOTTOM_TAG2, SCF_CTRLS_SUBST | SCF_HIDDEN,  
            2, 10, "Continue", "T\015",
            "Cancel", "C\033");

        /* -------------------------- */
        /*       Selection form       */ 
        /* -------------------------- */
	SelForm = scf_create_form(NULL, SEL_FORM_HEIGHT, SEL_FORM_WIDTH,
			 	        CENTRAL_LOCATION, CENTRAL_LOCATION, NULL);               
	if (!SelForm) return 0;;
            
	SelBrowser = scf_create_browser(SelForm,
			 SEL_FORM_HEIGHT-12, SEL_FORM_WIDTH-8, 4, 4, NULL);
    
	SelForm->cur_browser = (SCF_OBJECT *)SelBrowser;
	SelForm->alt_browser = (SCF_OBJECT *)NULL;
	
	scf_arrange_bottom_buttons(SelForm,
            btn_attr, thumb_attr,
 	    BOTTOM_TAG1, SCF_CTRLS_SUBST,  
            1, 8, "Cancel", "C\033");   

	scf_arrange_bottom_buttons(SelForm,
	    btn_attr, thumb_attr,
	    BOTTOM_TAG2, SCF_CTRLS_SUBST | SCF_HIDDEN, 3, 10,
	     "Accept", "A", "Continue", "T", "Cancel", "C" );
		

        /* -------------------------- */
        /*      Submission form       */ 
        /* -------------------------- */

	wid = HelpWndWidth;
	hei = HelpWndHeight;

	SubmitForm = scf_create_form(NULL, hei, wid,
                                          BOTTOM_LOCATION, HelpWndLeft, 
                                          "About to submit data ...");

	SubmitForm->frame_attr = btn_attr;
	SubmitForm->frame_char = cCkboard;
	SubmitForm->capt_attr = btn_attr;

	scf_create_text(SubmitForm, 1, -1, 2, 2, "Title:");
	SubmitDiscTitle = scf_create_text(SubmitForm, 1, wid-12, 2, 10, NULL);
	if (!SubmitDiscTitle) return 0;  
	scf_set_object_align(SubmitDiscTitle, SCF_LEFT_ALIGN);
	scf_set_object_attr(SubmitDiscTitle, help_hdr_attr, -1);

	scf_create_text(SubmitForm, 1, -1, 3, 2, "Email:");
	SubmitEmail = scf_create_text(SubmitForm, 1, wid-25, 3, 10, NULL);
	if (!SubmitEmail) return 0;  
	scf_set_object_attr(SubmitEmail, help_title_attr, -1);
	scf_set_object_align(SubmitEmail, SCF_LEFT_ALIGN);


	scf_create_text(SubmitForm, 1, -1, 3, -16, "Rev #:");
	SubmitRevNo = scf_create_text(SubmitForm, 1, 5, 3, -6, NULL);
	if (!SubmitRevNo) return 0;  
        scf_set_object_attr(SubmitRevNo, help_title_attr, -1);
	scf_set_object_align(SubmitRevNo, SCF_RIGHT_ALIGN);

	SubmitSetCatDef = scf_create_tick(SubmitForm, 1,27, 6, 2, "Set category as default", 
					    SCF_CTRLS_SUBST, 0);
	if (!SubmitSetCatDef) return 0;  
	scf_set_object_shortcuts(SubmitSetCatDef, 'F', 0);
	scf_set_object_align(SubmitSetCatDef, SCF_LEFT_ALIGN);

#ifdef MCN_SUPPORT
	SubmitMCN = scf_create_text(SubmitForm, 1, 19, 6, -35, "");
#endif	

	SubmitMultiArtist = scf_create_text(SubmitForm, 1, 14, 6, -15, NULL);
	if (!SubmitMultiArtist) return 0;  
	scf_set_object_align(SubmitRevNo, SCF_CENTRE_ALIGN);

	scf_create_text(SubmitForm, 1, -1, 4, 2, "Index:");
	SubmitIndex = scf_create_text(SubmitForm, 1, wid-30, 4, 10, NULL);
      scf_set_object_attr(SubmitIndex, help_title_attr, -1);

	scf_create_text(SubmitForm, 1, -1, 4, -16, "ID:");
      SubmitDiscId = scf_create_text(SubmitForm, 1, 10, 4, -12, NULL);
	if (!SubmitDiscId) return 0;  
      scf_set_object_attr(SubmitDiscId, help_title_attr, -1);
	scf_set_object_align(SubmitDiscId, SCF_RIGHT_ALIGN);

	SubmitCategs = scf_create_browser(SubmitForm, hei-8, 16, 8, 0, "Category");
	if (!SubmitCategs) return 0;  

	SubmitSites  = scf_create_browser(SubmitForm, hei-8, wid-15,
                                                 8, 15, " S i t e s ");
	if (!SubmitSites) return 0;  

	SubmitRemSite =  scf_create_button(SubmitForm, 1, 13, -1, 20,
				 "Remove site", SCF_CTRLS_SUBST); 
	if (!SubmitRemSite) return 0;  
	scf_set_object_shortcuts(SubmitRemSite, 'R', 'X', KEY_DC, 0);
	scf_set_object_callback(SubmitRemSite, submit_process_action, 10);

	SubmitSend =  scf_create_button(SubmitForm, 1, 8, -1, -23,
				 "Submit", SCF_CTRLS_SUBST); 
	if (!SubmitSend) return 0;  
	scf_set_object_shortcuts(SubmitSend, 'S', KEY_ENTER, 13, 0);
	scf_set_object_callback(SubmitSend, NULL, 1);
	SubmitForm->default_obj = (SCF_OBJECT *)SubmitSend;

	SubmitCancel =  scf_create_button(SubmitForm, 1, 8, -1, -13,
				 "Cancel", SCF_CTRLS_SUBST); 
	if (!SubmitCancel) return 0;  
	scf_set_object_shortcuts(SubmitCancel, 'C', 27, 0);
	scf_set_object_callback(SubmitCancel, NULL, 2);
	SubmitForm->cancel_obj = (SCF_OBJECT *)SubmitCancel;


	return 1;
}

void show_curs_form(SCF_FORM *frm, int status)
{  scf_show_form(frm, status);
   if (status) OverlapWnd = frm->wnd; 
         else  OverlapWnd = NULL;
} 

short  rcddb_message_handler(int type, char *message)
{	int rc;
	
	rc = 1;        
	if (!MsgForm) return rc;

	switch(type)
	{
		case 0:
		   if (SelForm) show_curs_form(SelForm, 0);	

		   scf_set_form_caption(MsgForm, message);
		   scf_show_tagged_objects(MsgForm, BOTTOM_TAG2, 0);
		   scf_show_tagged_objects(MsgForm, BOTTOM_TAG1, 1);

		   show_curs_form(MsgForm, 1);	
		   break;		    	    

		case 1:
		   if (scf_check_event(MsgForm) > 0) 
		   {	show_curs_form(MsgForm, 0);
			rc = 0;
		   }	
 		   else
		   {	scf_set_object_caption(MsgText1, message);
			scf_set_object_caption(MsgText2, "");
        	   }   
		   break;
            
          
      	case 2:
		   if (scf_check_event(MsgForm) > 0) 
		   {	show_curs_form(MsgForm, 0);
			rc = 0;
		   }	
		   else		
			scf_set_object_caption(MsgText2, message);
		   break;	

		case 20:
		   show_curs_form(MsgForm, 0);
		   break;

		case 21:
		{  int reply;
            
		   if (message)
			scf_set_object_caption(MsgText2, message);
         
		   scf_show_tagged_objects(MsgForm, BOTTOM_TAG1, 0);
		   scf_show_tagged_objects(MsgForm, BOTTOM_TAG2, 1);

		   reply = scf_get_event(MsgForm, idle_function);  
		   if (reply > 1)	/*  Cancel  */
		   {	show_curs_form(MsgForm, 0);
			rc = 2;
		   }
		   else rc = 0;
		}            

	}

	scf_refresh_form(MsgForm);    
	return rc;
    
}




/* Type:
	  0 - show form
	  1 - set header
	  2 - add browser line
	 20 - hide 
	 21 - error - wait for press 
*/	 

short  rcddb_data_handler(int type, char *message)
{
	int rc;

	rc = 1;
	if (!SelForm) return rc;

	switch(type)
	{   case 0:
		if (MsgForm != NULL) show_curs_form(MsgForm, 0);	

		scf_show_tagged_objects(SelForm, BOTTOM_TAG2, 0);
		scf_show_tagged_objects(SelForm, BOTTOM_TAG1, 1);
		scf_set_form_caption(SelForm, message);

		show_curs_form(SelForm, 1);	
		break;		    	    
    
	  case 1:
		if (scf_check_event(SelForm) > 0) 
		{	show_curs_form(SelForm, 0);
			return 0;
		}	
 
		scf_set_object_caption(SelBrowser, message);
        	scf_clear_browser(SelBrowser);
		break;
	  
        case 2:
    	        if (scf_check_event(SelForm) > 0) 
	        {   show_curs_form(SelForm, 0);	
		    return 0;
		}	
        	scf_append_browser_line(SelBrowser, message);
		break;
	  
        case 20:
        	show_curs_form(SelForm, 0);	
		return 0;


	  case 21:
	  {	if (scf_get_browser_linecount(SelBrowser) <= 0) 
			rc = 0;
		else	      
  		{
		    if (scf_get_browser_linecount(SelBrowser) > 1)
                    scf_select_browser_line(SelBrowser, 0);
                        
		    scf_show_tagged_objects(SelForm, BOTTOM_TAG1, 0);
		    scf_show_tagged_objects(SelForm, BOTTOM_TAG2, 1);
                    ((SCF_OBJECT *)SelBrowser)->flags &= SCF_FRAME_DRAWN;
		    scf_draw_object(SelBrowser);
	 	    rc = scf_get_event(SelForm, NULL);
				 /* 1-Accept, 2-Continue, 3-Cancel */

  		    if (rc == 1)  
		    {   /* Accept */
                      rc = scf_get_browser_curline(SelBrowser)+2;
                      if (rc < 2) rc = 2;
		    }    
			else rc = 3-rc;   /* 0 - Cancel, 1 - Continue */
		 }

		 show_curs_form(SelForm, 0);

                 if (rc == 1)
	             rcddb_message_handler(0, NULL); 
  	   } 	/* case 21 */	
	}

	scf_refresh_form(SelForm);			
	return rc;
}


static void  destroy_form_sadp_comm(void)
{
    if (MsgForm) 
    	scf_destroy_form(MsgForm);

    if (SelForm) 
    	scf_destroy_form(SelForm);

    if (SubmitForm) 
    	scf_destroy_form(SubmitForm);

    if (RcddbForm)   
    	scf_destroy_form(RcddbForm);
      
/*    if (RegForm)
      scf_destroy_form(RegForm);  */  
}

static void rcddb_show_sites(void)
{  
    char  **site_name_ptr, *site_name;
    SCF_BROWSER *site_browser;
    
    
    site_browser = RcddbSiteList;
    
    scf_clear_browser(site_browser);
    
    site_name_ptr = asites;    
    while ((site_name = *site_name_ptr++) != NULL)
        scf_append_browser_line(site_browser, site_name);

    if (scf_get_browser_linecount(site_browser) > 0)
        scf_select_browser_line(site_browser, 0);
}    
    
void rcddb_set_proxyaddr_visibility()
{	chtype new_attr;
	scf_show_object(RcddbProxyAddr, UseProxy);	

	new_attr = UseProxy ? side_attr : side_dim_attr; 	 
	scf_set_object_attr(RcddbProxyOn, new_attr, thumb_attr);	
}

void rcddb_accept_protocol(void)
{	chtype new_attr;
	char *caption;
	
	if (ProtocolUsed == 1)
	{  new_attr = bar_attr;
	   caption = "CDBBP";
      }		
	else
	{  ProtocolUsed = 2;
	   new_attr = side_attr;
	   caption = "HTTP";
      }		

	scf_set_object_attr(RcddbProtocol, new_attr, thumb_attr);	
	scf_set_object_caption(RcddbProtocol, caption);	
	scf_draw_object(RcddbProtocol);
	
}

static void rcddb_show_config(void)
{
	scf_set_input(RcddbUser, UserAddr);
	scf_set_input(RcddbProxyAddr, ProxyURL);
	scf_set_input(RcddbMailAddr, MailServer);

	rcddb_accept_protocol();
	rcddb_set_proxyaddr_visibility();
}


void rcddb_curs_initialize(void)
{
    create_form_sadp_comm();
    rcddb_show_config();    
    rcddb_show_sites();
}

void rcddb_curs_deinitialize(void)
{
    if (BottomSection == RCDDB_SECTION)
       	rcddb_deactivate();
    destroy_form_sadp_comm();
}  


void rcddb_paint_border(SCF_FORM *frm)
{    int x, y;
     WINDOW *wnd;
     chtype fchr;	
     
     wnd = frm->wnd;
     if (!wnd) return;

    wbkgd(wnd, frm->bkgr_attr );
     werase(wnd);

     wattrset(wnd, frm->frame_attr);

     fchr = frm->frame_char;

     x = 0; y=0;

     wmove(wnd, y, x);
     wvline(wnd, cCkboard, HelpWndHeight-1);
     
     y = HelpWndHeight-1;
     wmove(wnd, y, x);
     whline(wnd, cCkboard, HelpWndWidth);

     x = HelpWndWidth-1; y=0;
     wmove(wnd, y, x);
     wvline(wnd, cCkboard, HelpWndHeight-1);


}

void rcddb_activate(void)
{
    rcddb_show_config();    
    
    RcddbForm->focus_obj =
       ( HelpFocus ? (SCF_OBJECT *)RcddbUser :
                     (SCF_OBJECT *)RcddbCaption);

    scf_set_form_window(RcddbForm, HelpWnd);

}

static void rcddb_check_and_accept(char *target, SCF_INPUT *source)
{    char *new_target;
     
     new_target = scf_get_input(source);
     trim(new_target);
     if (strcmp(target, new_target))
     {  strncpy(target, new_target, 151);
        OptionsChanged = 1;
     }    	

}

void rcddb_deactivate(void)
{
    rcddb_check_and_accept(UserAddr, RcddbUser);
    rcddb_check_and_accept(ProxyURL, RcddbProxyAddr);
    rcddb_check_and_accept(MailServer, RcddbMailAddr);
    RcddbForm->wnd = NULL;
} 

void rcddb_accept_focus(void)
{  
    
    if(HelpFocus)
    { if( !RcddbForm->focus_obj ||
          RcddbForm->focus_obj == (SCF_OBJECT *)RcddbCaption)
      {  scf_set_focus (RcddbForm, RcddbUser);
         scf_refresh_form (RcddbForm);
      }      
    }  
    else     
    { if(RcddbForm->focus_obj != (SCF_OBJECT *)RcddbCaption)
      { scf_set_focus (RcddbForm, RcddbCaption);
        scf_refresh_form (RcddbForm);
      }      
    }  
} 


static void  rcddb_swap_sites(int from, int new_active)
{

    SCF_BROWSER *brw = RcddbSiteList;
    int start = scf_get_browser_curline(brw);
    char *from_line, *to_line;
    int  lineno;
    
    from += start; 
    
    if (from < 0 || from >= scf_get_browser_linecount(brw)-1) return;
    
    from_line = asites[from];
    to_line = asites[from+1];
    asites[from] = to_line;
    asites[from+1] = from_line;

    scf_set_browser_text(brw, from, to_line);
    scf_set_browser_text(brw, from+1, from_line);

    lineno = start+new_active;
    scf_select_browser_line(brw, lineno);
    
    SitesChanged = 1;
}

void  rcddb_delete_site(void)
{
    SCF_BROWSER *brw = RcddbSiteList;
    short index = scf_get_browser_curline(brw);
    char  *site, **siteptr = asites+index;	

    free(*siteptr);
        
    do *siteptr++ = site = *(siteptr+1);
    while (site != NULL);

    scf_delete_browser_line(brw, index);
    if (index >= scf_get_browser_linecount(brw)) index--;
    
    if (index > 0) scf_select_browser_line(brw, index);
    
    SitesChanged = 1;
    
}      		


static int rcddb_process_action(void *obj, SCF_EVENT evnt, int action)
{
    switch(action)
    { 
/*	case RCDDB_USER:
	    strncpy(UserAddr, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;

	case RCDDB_PROXYADDR:
	    strncpy(ProxyURL, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;

	case RCDDB_MAILADDR:
	    strncpy(MailServer, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;
*/
	case RCDDB_GUESS:
	    rcddb_guess_config();
	    rcddb_show_config();
	    scf_redraw_form(RcddbForm);	
	    OptionsChanged = 1;
	    break;
	     
	case RCDDB_PROXYON:
	    UseProxy = !UseProxy;	
	    rcddb_set_proxyaddr_visibility();
	    scf_redraw_form(RcddbForm);	
	    OptionsChanged = 1;
	    break;

	case RCDDB_PROTCHOICE:
	    ProtocolUsed ^= 3;
	    rcddb_accept_protocol();	
	    scf_refresh_form(RcddbForm);
	    OptionsChanged = 1;
	    break;
  
	case RCDDB_REFRESH:
          if (refresh_active_sites())
		   rcddb_show_sites();
	    scf_refresh_form(RcddbForm);
	    break;

	case RCDDB_UP:
	    rcddb_swap_sites(-1, -1);
	    break;
	
	case RCDDB_DOWN:
	    rcddb_swap_sites(0, 1);
	    break;
	    
	case RCDDB_DELETE:
	    rcddb_delete_site();
	    break;
	     	          
     }

	return -1;	
}    


OPERATION rcddb_getaction(int key)
{
    OPERATION oper;          
    short shift;
    int   rc;
    SCF_OBJECT *obj;


    oper = OPER_NONE;       
    if (key == ERR) goto Fine;   
    shift = get_kbd_shift() & 1;

    switch(key)
    {  case 'Q'-'A'+1:
		oper = OPER_QUIT;
		goto Fine;

	 case 'R'-'A'+1:
		redraw_screen();
		oper = OPER_SPECIAL;
		goto Fine;
    }				


    if (shift)
    switch(key)
    {	 case KEY_DC:
    	      rcddb_delete_site();
            scf_refresh_form(RcddbForm);
   	      oper = OPER_SPECIAL;
            goto Fine;
            
    	 case KEY_DOWN:
            rcddb_swap_sites(0, 1);
            scf_refresh_form(RcddbForm);
   	      oper = OPER_SPECIAL;
            goto Fine;
            
   	 case KEY_UP:
            rcddb_swap_sites(-1, -1);
            scf_refresh_form(RcddbForm);
   	      oper = OPER_SPECIAL;
            goto Fine;
    }


    /* Process tab key */
    if (key == 9)
    {
       if (HelpFocus)
       {  SCF_OBJECT *obj;

          obj = scf_get_next_focus_obj(RcddbForm, shift); 
          if (obj == (SCF_OBJECT *)RcddbCaption)
          {  HelpFocus = 0;
             accept_focus();
          } 
          else
             scf_set_focus(RcddbForm, obj);    
	 }
       else
       {  HelpFocus = 1;
          obj = scf_get_next_focus_obj(RcddbForm, shift); 
          scf_set_focus(RcddbForm, obj);
          accept_focus();
       }
        
   	   scf_refresh_form(RcddbForm);   
   	   oper = OPER_SPECIAL;
         goto Fine;
    }

    /* Process F5 key (toggle focus) */
    if (key == KEY_F(5))
    {
         HelpFocus ^= 1;
         accept_focus();

   	   scf_refresh_form(RcddbForm);   
   	   oper = OPER_SPECIAL;
         goto Fine;
    }		

    if (!HelpFocus && key != KEY_MOUSE && !iscntrl(key)) goto Fine;

    rc = scf_process_event(RcddbForm, key);
    if (rc != 0)
    {  oper=OPER_SPECIAL;
       if (!HelpFocus)
       {  HelpFocus = 1;
          accept_focus();
       }
    }      
    
 /*   
    if (key == KEY_MOUSE)
    {   int new_focus = (scf_mouse_y >= 0) ? 1: 0;
        if (new_focus != HelpFocus) 
        { HelpFocus = new_focus;
          accept_focus();
        }
    }       
*/   

Fine:
     if (FourWndCount > 0)
            usleep((HELP_PLAY_TIMEOUT)/4);
     /*  Prevents a noise from speakers, due to intensive CPU use */

     return oper;
}

/* =========================================================== */
/* 			      D O W N L O A D                        */
/*=============================================================*/
short rcddb_download_data(void)
{ 

    short ret;
/*
     UseProxy = fl_get_button(RcddbControls[RCDDB_PROXYON]);
*/     
     ret = rcddb_get_disc_data();
     return ret;     

}


/* =================================================== */
/*                R E G I S T R A T I O N              */
/* =================================================== */
static short content_lineno = 0;
static short comment_lineno = 0;

int create_reg_form(void)
{	int wid, hei, y, mlines;
	SCF_OBJECT *obj;

	wid = HelpWndWidth;
	hei = ScreenH;

	if (RegForm) scf_destroy_form(RegForm);
      
	RegForm = scf_create_form(NULL, hei, wid,
                                      CENTRAL_LOCATION, HelpWndLeft, 
                                      RegMailSubject);
	if (!RegForm) return 100;                                      
	RegForm->frame_attr = btn_attr;
	RegForm->frame_char = cCkboard;
	RegForm->capt_attr = btn_attr;

	y = 1;
	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, -1, y++, 2,
          "The details provide a feedback needed for SADP development.");
	scf_set_object_attr(obj, help_title_attr, 0);          

	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, -1, y++, 2,
          "This information will not be used for any other purposes.");
	scf_set_object_attr(obj, help_title_attr, 0);          

	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, -1, y, 2, "Press");
	scf_set_object_attr(obj, help_title_attr, 0);          
	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, -1, y, 8, "Anonymous");
	scf_set_object_attr(obj, help_hdr_attr, 0);          
	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, -1, y++, 18,
         				 "to suppress your email address.");
	scf_set_object_attr(obj, help_title_attr, 0);          

	mlines = hei-16;    
	RegDetails = scf_create_browser(RegForm, mlines, wid, y, 0, "Details");
	if (!RegDetails) return 4;  
	y += mlines+1;

	scf_create_text(RegForm, 1, -1, y, 2, "From:");
	RegSender  = scf_create_input(RegForm, 1, wid-12, y++, 10, NULL, 1, 120);
	if (!RegSender) return 8;                                      

	scf_create_text(RegForm, 1, -1, y, 2, "To:");
	scf_create_text(RegForm, 1, -1, y++, 10, RegMailDestinator);

	y++;
	scf_create_text(RegForm, 1, -1, y, 2, "Server:");
	RegServer  = scf_create_input(RegForm, 1, wid-12, y++, 10, NULL, 1, 120);
	if (!RegServer) return 12;                                      

	y ++;
	mlines = 512/(wid-2);
	RegComments = scf_create_input(RegForm, hei-y, wid, y, 0, "Your comments are appreciated", mlines, wid-2);
	if (!RegComments) return 16;  

	RegAnonym =  scf_create_tick(RegForm, 1, 14, -1, 4,
				 "Anonymous", SCF_CTRLS_SUBST, 0); 
	if (!RegAnonym) return 20;  
	scf_set_object_shortcuts(RegAnonym, 1, 0);
	scf_set_object_callback(RegAnonym, NULL, 100);

	obj = (SCF_OBJECT *) scf_create_text(RegForm, 1, 5, -1, 20, NULL);
	scf_set_object_align(obj, SCF_CENTRE_ALIGN);
	scf_set_frm_overlap_object(RegForm, obj);

	RegCancel =  scf_create_button(RegForm, 1, 12, -1, -30,
				 "Don't send", SCF_CTRLS_SUBST); 
	if (!RegCancel) return 24;  
	scf_set_object_shortcuts(RegCancel, 'D'-'A'+1, 27, 0);
	scf_set_object_callback(RegCancel, NULL, 2);
	RegForm->cancel_obj = (SCF_OBJECT *)RegCancel;

	RegSend =  scf_create_button(RegForm, 1, 12, -1, -16,
				 "Send", SCF_CTRLS_SUBST); 
	if (!RegSend) return 28;  
	scf_set_object_shortcuts(RegSend, 'S'-'A'+1, 0);
	scf_set_object_callback(RegSend, NULL, 1);

      return 0;
}

const char *get_mail_fromaddr(void)
{  

   content_lineno = comment_lineno = 0;
   if ( scf_get_tick_value(RegAnonym))
 	return anonym_text;
   else
	return scf_get_input(RegSender);
 
}    

const char *get_mail_sender(void)
{
   content_lineno = comment_lineno = 0;
    return scf_get_input(RegSender);

}

const char *get_mail_contentline(void)
{
   if (content_lineno >= scf_get_browser_linecount(RegDetails))
	    return NULL;
   return scf_get_browser_text(RegDetails, content_lineno++);
	    
}

const char *get_mail_commentline(void)
{ 
    const char *ret;

    if (comment_lineno > 0) return NULL;
   
    comment_lineno++;

    ret = scf_get_input(RegComments);      
    if (*ret == '\0') return NULL;
    
    return ret;
}

/*
static void commit_reg_line(char *line)
{

    scf_append_browser_line(RegDetails, line);
}    


void set_reg_address_label(void)
{  

    if (scf_get_tick_value(RegAnonym))
    {  
       char label[151];
       char *endptr, *dotptr;

       strcpy(label, "sadp_user@darksite");
       dotptr = strrchr(UserAddrReal, '.');
       
       if (dotptr)
       {  
          endptr = UserAddrReal+strlen(UserAddrReal);	
	    if (endptr - dotptr <= 3)   // Country code 
	    { if (*(dotptr - 4) == '.') dotptr -= 4; }
	   
	   strcat(label, dotptr);      
       }	   

       scf_set_input(RegSender, label); 
       scf_activate_object(RegSender, 0);
    }
    else
    { 
       scf_set_input(RegSender, UserAddr);
       scf_activate_object(RegSender, 1);
    }	
     
}

static void fill_reg_form(void)
{ 

    char txt1[61], txt2[61];
    char text[81];   
    double cpuclock, mips; 


    scf_set_input(RegServer, MailServer);
    set_reg_address_label();   
    
    scf_clear_browser(RegDetails);


    snprintf(text, 81, "Application: sadp v. %s", get_sadp_version());
    commit_reg_line(text);

    commit_reg_line("");
    
    get_os_data(txt1, txt2);
    snprintf(text, 81, "System:      %s %s", txt1, txt2);
    commit_reg_line(text);

#if HAVE_CURSES_VERSION
    snprintf(text, 81, "Library:     %s", (char *)curses_version());
    commit_reg_line(text);
#elif defined(NCURSES_VERSION)
    snprintf(text, 81, "Library:     ncurses %s", NCURSES_VERSION);
    commit_reg_line(text);
#endif

    commit_reg_line("");


    if (get_cpu_data(txt1, txt2, &cpuclock, &mips))
    { 
       commit_reg_line("CPU");	
       if (strlen(txt1)>0)
       {  snprintf (text, 81, "    Type:     %s", txt1);	
          commit_reg_line(text);
       }	  
       if (strlen(txt2)>0)
       {  snprintf (text, 81, "    Model:    %s",  txt2);	
          commit_reg_line(text);
       }
       if (cpuclock > 0)	  
       {  snprintf (text, 81, "    Clock:    %.1f MHz", cpuclock);
          commit_reg_line(text);
       }	   
       if (mips > 0)	  
       {  snprintf (text, 81, "    Speed:    %.1f MIPS", mips);	
          commit_reg_line(text);
       }   	  

       commit_reg_line("");
    }


#ifdef DSP_SUPPORT
    if ( get_sound_version(text, txt1, txt2))
    { char text5[81];
	commit_reg_line("SOUND SUPPORT");

	snprintf (text5, 81, "   Driver:    %s %s", text, txt1);
	commit_reg_line(text5);
	if (*txt2 != '\0') 
	{  snprintf (text5, 81, "   ALSA:      %s", txt2);
	   commit_reg_line(text5);
	}
    }

    if (get_audio_name(AudioDeviceName, "dsp", "Audio devices:",
                         txt1, NULL,  txt1, txt2))
    {   snprintf (text, 81, "   Audio:     %s", txt1);	
        commit_reg_line(text);
	  if (*txt2 != '\0')
        {  snprintf (text, 81, "                  %s", txt2);
           commit_reg_line(text);
	  }	
#ifdef ALSA_DSP_SUPPORT
	  if (alsa_dsp)
	 	 snprintf(text, 81, "   Access:    ALSA %s", mmap_active ? "memory map" : "");
	  else
	 	 snprintf(text, 81, "  	Access:    OSS");
        commit_reg_line(text);
#endif	
    }
    else
        commit_reg_line("DSP is unavailable");
				 
#else
    commit_reg_line("NO DSP Support");
#endif    	

    commit_reg_line("");

    commit_reg_line("CD");
//    if (strlen(cd_description) > 0)     
        snprintf(text, 81, "    Type:       %s", cd_description);
//    else
//        snprintf(text, 81, "    Node major: %d", CDDeviceType); 
    commit_reg_line(text);

    if (strlen(cd_model)>0)    
    {    snprintf(text, 81, "    Model:     %s", cd_model);
         commit_reg_line(text);
    }	 

    scf_select_browser_line(RegDetails, 0);

//    RegForm->default_obj = (SCF_OBJECT *)RegSend; 
    RegForm->focus_obj = (SCF_OBJECT *)RegSender;

    RegForm->cur_browser = (SCF_OBJECT *)RegDetails;
    RegForm->alt_browser = (SCF_OBJECT *)RegComments;
    scf_accept_active_browser(RegForm);
}    


short reg_new(void)
{
      short rc;
      int  code;

      rc = 0;
	if (create_reg_form()) goto HastaLaVista;
            
	fill_reg_form();
	scf_show_form(RegForm, 1);
      rc = 1;
    
      while((code = scf_get_event(RegForm, NULL)) != 2)
      { 
         if (code == 100)
             set_reg_address_label();
         else
         if (code == 1)
         {  
            strncpy(MailServer, scf_get_input(RegServer), 151);

	      if (!scf_get_tick_value(RegAnonym))
               strncpy(UserAddr, scf_get_input(RegSender), 151);

            rc = rcddb_sendreg();
  	      break;
         }
     }      
     
     scf_show_form(RegForm, 0);   

HastaLaVista:
     if (RegForm) scf_destroy_form(RegForm);
     RegForm = NULL;
     return rc;
}
*/
/* ============================================================== */


static int submit_process_action(void *obj, SCF_EVENT evnt, int action)
{   int i;


    switch(action)
    {
       case 1:
       {   	/* Submit */
      	char **site_list;
		int nlines;
            const char *new_categ;


		i = scf_get_browser_curline(SubmitCategs);
	        if (i<=0)
		{   curs_message(-1, 1, "Please, select disc category");
                scf_redraw_form(SubmitForm);
		    return 0;	
		}		
	    
		new_categ = scf_get_browser_text(SubmitCategs, i);
		if (strcasecmp(DiscCategory, new_categ))
		{ 	strcpy(DiscCategory, new_categ);
	      	DataChanged = 1;
		}   	

		if (scf_get_tick_value(SubmitSetCatDef) &&
	           strcasecmp(DefaultCategory, new_categ))
		{	strcpy(DefaultCategory, new_categ);
			OptionsChanged = 1;
		}   	   
	       
		nlines = scf_get_browser_linecount(SubmitSites);
		site_list = malloc((nlines+1) * sizeof(char *));

		if (site_list)	      
		{	for (i=0; i<nlines; i++)
			site_list[i] = strdup(scf_get_browser_text(SubmitSites, i));

			site_list[nlines] = NULL;		    
		}

		show_curs_form(SubmitForm, 0);
                          
	    
		if (site_list)	      
		{
			rcddb_submit_data(site_list);
			for (i=0; i<nlines; i++)
				if (site_list[i]) free(site_list[i]);
			free(site_list);		    
		}
       }
            break;      

       case 2:
		show_curs_form(SubmitForm, 0);
            break;
    	    
       case 10:
       	/* Remove site */
            i = scf_get_browser_curline(SubmitSites);
            if (i >= 0)	    
               scf_delete_browser_line(SubmitSites, i);
            return -1;	    
    }	    

    return 1;	    
}


void curs_submit_data(void)
{
    short result;
    char buf[121];
    char **categs, *categ;
    int  action;	

    result = check_cdinfo_completeness();
    if (result != 0)
    {
	if (result == 1)
           strcpy (buf, "Disc title is missing or invalid.");
	else
	     sprintf(buf, "Track %d name is invalid or missing.", 
		    result - 10);
		       
      curs_message(-1, 6, "Submission cannot be performed:        ",
			    "", buf, "",
                      "Please, make sure that disc information",
			    "and track names are correct."
                    );

	return;			
    }
        
    if (DataChanged) save_local_db();

    if (!SubmitForm) return;

    SubmitForm->cur_browser = (SCF_OBJECT *)SubmitCategs;
    SubmitForm->alt_browser = (SCF_OBJECT *)SubmitSites;
    scf_accept_active_browser(SubmitForm);


    categs = categories;
    if (!categs) categs = default_categories; 

    scf_set_tick(SubmitSetCatDef, 1);

    if (categs && SubmitCategs)
    {
       scf_clear_browser(SubmitCategs);
       scf_append_browser_line(SubmitCategs, "[undef]");
       scf_select_browser_line(SubmitCategs, 0);
       while ((categ = *categs++) != NULL)
       {   scf_append_browser_line(SubmitCategs, categ);

           if (strcasecmp(categ, DiscCategory) == 0)
           { scf_select_browser_line(SubmitCategs,
                        scf_get_browser_linecount(SubmitCategs)-1 );	   
	     scf_set_tick(SubmitSetCatDef, 0);
	   }     

       }	     
    }

    categs = (char **) ssites;
    if (categs && SubmitSites)
    {   scf_clear_browser(SubmitSites);
	  while ((categ = *categs++) != NULL)
		scf_append_browser_line(SubmitSites, categ);
    	     
   	  if (SubmitSites->first )
           scf_select_browser_line(SubmitSites, 0); 
    }	
     
    scf_set_object_caption(SubmitDiscTitle, disc_name);

    sprintf(buf, "%lu", disc_revision);
    scf_set_object_caption(SubmitRevNo, buf);

    scf_set_object_caption(SubmitEmail, UserAddr); 

    if (cd_multi_artist)
	{  scf_set_object_caption(SubmitMultiArtist, "Multi-artist");
	   scf_set_object_attr(SubmitMultiArtist, help_hdr_attr, -1);
	}
    else	
	{  scf_set_object_caption(SubmitMultiArtist, "Single artist");
	   scf_set_object_attr(SubmitMultiArtist, help_title_attr, -1);
	}

#ifdef MCN_SUPPORT
    if (cd_upcode == NULL)
	scf_show_object(SubmitMCN, 0);
    else
    {	sprintf (buf, "MCN: %s", cd_upcode);
	scf_set_object_caption(SubmitMCN, buf); 
	scf_show_object(SubmitMCN, 1);
    }	
#endif	

    cddb_disc_id = get_cddb_discid();

    sprintf(buf, "%lu", cddb_disc_id);
    scf_set_object_caption(SubmitDiscId, buf);
    scf_set_object_caption(SubmitIndex, cdix_index);

    show_curs_form(SubmitForm, 1);

    do
    {/*  touchwin(SubmitForm->wnd); */
      scf_refresh_form(SubmitForm);	 
	action=scf_get_event(SubmitForm, idle_function_cd);  
    }	
    while (submit_process_action(NULL, SCF_NO_EVENT, action) <= 0);	

    	
/*    show_curs_form(SubmitForm, 0); */
    redraw_screen();
   
	
} 


void rcddb_show_message(char *message)
{
    curs_message(-1, 1, message);
}

#endif /* RCDDB_SUPPORT */
