 /* =======================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
 
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ----------------------------------------------------------
    sadp_cddbext.c - started 1-Jul-99
    ========================================================= */

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include "sad.h"
#include "sadp_rcddb.h"

#ifdef RCDDB_SUPPORT

short reg_new(void)
{
	return 1;
}

/* Permanent sites */
static const char *default_psites[] = 

{
    "cddbp://freedb.freedb.org:888/, CDDB 3",
    "http://freedb.freedb.org:80/~cddb/cddb.cgi, CDDB 3",
    "http://www.cdindex.org:80/cgi-bin/cdi/xget.pl, CDIX",
    "cddbp://cddb.cddb.com:8880/, CDDB 4", 
    "http://cddb.cddb.com:80/~cddb/cddb.cgi, CDDB 4",  
    NULL             
};

static const char *default_ssites[] = 

{
    "mail://freedb-submit@freedb.org, CDDB",  
    "http://cddb.cddb.com:80/~cddb/submit.cgi, CDDB",  
    "http://www.cdindex.org:80/cgi-bin/cdi/xsubmit.pl, CDIX",
    NULL             
};

const char *default_categories[] = 
{ "blues", "classical", "country", "data", "folk",  
  "jazz", "misc", "newage", "reggae", "rock", "soundtrack", 
   NULL
};


extern short UseProxy, ProtocolUsed;

extern char UserAddr[];
extern char *AppName;
extern char AppVersion[];
extern char ProxyURL[];
extern short ForceReg;
extern char UserFullName[];
extern char MailServer[];

static short default_psites_used = 1;
static short default_ssites_used = 1;

static void free_sites(char **sites);

extern short UseLogFile;
static short new_flg;

char  **psites = NULL,  **asites = NULL, **ssites = NULL;
char  **categories = NULL;
FILE *LogFile = NULL;
short SitesChanged;

u_long cddb_disc_id;
char   *cddb_query;
char   *cdix_query;

char *UserAddrReal = NULL;

extern char  *cdix_index;
extern short DataChanged;
extern char  DiscCategory[15];  

/* ========================================================= */
/*  1-Jul-99 */
static short parse_host_name(const char *host_name_start, struct site_info *result)
{
    int i; 
    char *tmp;
    const u_short def_port[3] = {CDDBP_DEFAULT_PORT,
                                 HTTP_DEFAULT_PORT,
				 SMTP_DEFAULT_PORT};
    char *host_name;
    u_short port;

    host_name = (char *)host_name_start;

    /* Get the site name */
    i = strcspn(host_name, ":/, "); 
    if (i>60)            
    {   char buffer[257];
		sprintf(buffer, "Error parsing '%s'\n:"
      		 "    Can't handle host names with length > 60",  host_name_start);
		show_error_message(buffer);	 
        return 0;
    }

    /* Store  site name */
    tmp = result->site;
    memcpy(tmp, host_name, i);
    *(tmp+i) = '\0';
    host_name += i;
    
    /* Now check the delimiter */
    port = 0;
    if (*host_name == ':')
    {  host_name++;
       port = (u_short) strtol(host_name, &host_name, 10);
    }   
       	 
	 
    if (port <= 0) port = def_port[(short)(result->pr_type)];
    result->port = port;
    
    /* Get the addressing if present */           	      
    tmp = result->addressing;
    *tmp = '\0';

    if ( *host_name == '/')    
    { i = strcspn(host_name, ", ");
      memcpy(tmp, host_name, i);
      *(tmp+i) = '\0';
      host_name += i;
    }  

    if (strchr(", ", *host_name) == NULL) 	
    {   char buffer[257];
		sprintf(buffer, "Error parsing '%s':\n"
                        "    Invalid addressing", host_name_start);
		show_error_message(buffer);	 
        return 0;
    }
    host_name++;    
     
    /* Fill the rest with defaults */ 
    result->db_type = 0;
    result->pr_vers = 3;     
    *(result->extra) = '\0';

    if (*host_name == '\0')  return 1; 


    /* Get DB type */
    host_name += strspn(host_name, " ");
    if (strncasecmp(host_name, "CDI", 3 ) == 0)
           result->db_type = 1;

    host_name += strcspn(host_name, " "); 

    /* Get protocol version */
    host_name += strspn(host_name, " ");
    if (*host_name == '\0')  return 1; 
    i = strtol(host_name, &host_name, 10);
    if (i > 3)  result->pr_vers  = 4;

    /* Get extra */
    host_name += strspn(host_name, " ");
    if (*host_name == '\0')  return 1; 
    tmp = result->extra;
    strncpy(tmp, host_name, 60);
    *(tmp+60) = '\0';
    
    /* Bye bye */
    return 1;
        
}

/*  1-Jul-99 */
static short parse_host_and_protocol(const char *host_name_start, struct site_info *result)
{
    int i; 
    char *host_name;
    char pr_type; 


    /* Bypassing leading spaces */
    
    host_name = (char *)host_name_start + strspn(host_name_start, " ");
    
    /* Find the protocol: http or cddbp*/
    i = strcspn(host_name, ":");
    
    if (i==5 && strncasecmp(host_name, "cddbp", 5) == 0)
        pr_type = CDDB_MODE_CDDBP;
    else
    if (i==4 && strncasecmp(host_name, "http", 4) == 0)
        pr_type = CDDB_MODE_HTTP;
    else	
    if (i==4 && strncasecmp(host_name, "mail", 4) == 0)
        pr_type = CDDB_MODE_MAIL;
    else
    { char buf[121];  
	  sprintf (buf, "Invalid protocol type\n    %s", host_name);
	  show_error_message(buf);
      return 0;
    }
    
    /* Go after : */
    host_name += i+1;   

    /* Skipping double slash */
    if (*host_name == '/') host_name++;
    if (*host_name == '/') host_name++;

    result->pr_type = pr_type;
    return parse_host_name(host_name, result);
        
}

static void  add_site(char ***sites_ptr, char *address, u_short *sites_count)
{   char **sites;
 
    if (*sites_count >= 30) return;    
 
    if ((sites = *sites_ptr) == NULL)
    {   sites = (char **) malloc (sizeof(char *) * 31);
        if (sites == NULL) return;	
        *sites_ptr = sites;
    }

    sites[(*sites_count)++] = strdup(address);    
}

/*  1-Jul-99 */
static void  read_file_sites(FILE *f, char ***rsites_ptr, char ***ssites_ptr, char ***categ_ptr)
{    char buf[257]; 
     u_short rscount, sscount, ctcount, submit;
     char **rsites, **ssites, **categ;
     char *tmp; 
  
    rscount = sscount = ctcount = 0;

    rsites = ssites = categ = NULL;
    
    while (fgets(buf, 257, f) != NULL)
    {
	tmp = strchr(buf, '\n');
	if (tmp != NULL) *tmp = '\0';

	tmp = buf;
	if (strchr("#!", *tmp)) continue;

	if (strncasecmp(buf, "USER", 4) == 0)
	{ /*
	   tmp += 4;
	   tmp += strspn(tmp, "= ");	
	   strtokm(tmp, " ");
	   strcpy(UserAddr, tmp);
	  */ 
	   new_flg = 0;
	   continue;
	}   

	submit = 0;
	if (strncasecmp(buf, "SERVER", 6) == 0)
      {	tmp += 6;
		tmp += strspn(tmp, "= ");
	}
	else
	if (strncasecmp(buf, "SUBMIT", 6) == 0)
        {	
		submit = 1;
		tmp += 6;
		tmp += strspn(tmp, "= ");
	}
	else
	if (strncasecmp(buf, "CATEGORY", 8) == 0)
        {
		submit = 2;
		tmp += 8;
		tmp += strspn(tmp, "= ");
	}


	if (submit == 0)
	{  if (memcmp(tmp, "cddbp:", 6) == 0 ||      
               memcmp(tmp, "http:", 5) == 0)
	     add_site(&rsites, tmp, &rscount);
	}
	else
	if (submit == 1 && ssites_ptr != NULL)
	{  if (memcmp(tmp, "http:", 5) == 0 ||      
               memcmp(tmp, "mail:", 5) == 0)
	     add_site(&ssites, tmp, &sscount);
	}
	else
	if (categ_ptr != NULL)
	     add_site(&categ, tmp, &ctcount);
		       
    }


    if (rsites)
    {  
        rsites[rscount++] = NULL;
        if (rscount < 31)
           rsites = realloc(rsites, sizeof(char *) * rscount);
    }
    *rsites_ptr = rsites;

    if (ssites_ptr != NULL)
    {  if (ssites)
        {  
	    ssites[sscount++] = NULL;
            if (sscount < 31)
	       ssites = realloc(ssites, sizeof(char *) * sscount);
        }
	*ssites_ptr = ssites;
    }	

    if (categ_ptr != NULL)
    {  if (categ)
        {  
	    categ[ctcount++] = NULL;
            if (ctcount < 31)
	       categ = realloc(categ, sizeof(char *) * ctcount);
        }
	*categ_ptr = categ;
    }	

    SitesChanged = 0;
}

/*  13-Jul-99 */
short save_rcddb_config(void)
{
     FILE  *f;
     char  *homedir;
     char  buf[513];
     char  **sites; 
     char  *site;
     time_t t;    
    
     	
	homedir = getenv("HOME");
	if (!homedir) 
	{ show_error_message("No home directory");
	  return 0;
	}
	snprintf (buf, 513, "%s/.sadp/config", homedir);	

	f = fopen(buf, "w+");  
	if (f == NULL) 
	{ 
	  sprintf (buf, "Failed to open ~/.sadp/config:\n%s", strerror(errno));
	  show_error_message(buf);
	  return 0;
	}
    

    fprintf (f, "###############################################\n");
    fprintf (f, "###  RCDDB configuration file               ###\n");
    fprintf (f, "###  Created by (x)sadp version %-10s  ###\n", get_sadp_version());
    fprintf (f, "###-----------------------------------------###\n");
    time(&t); strcpy(buf, ctime(&t)); strtokm(buf, "\r\n");
    fprintf (f, "### Date and time: %-25s###\n", buf);
    fprintf (f, "###############################################\n\n");
    

    fprintf (f, "ACCESS=REMOTE\n");
    if (ProxyURL != NULL) fprintf (f, "PROXY=%s\n", ProxyURL);

    if (new_flg == 0)
	     fprintf (f, "USER=%s\n", UserAddr);
    

    if (asites)
    {    sites = asites;          
         while ((site = *sites++) != NULL)
   	   fprintf (f, "SERVER=%s\n", site);
    }	   
	
    if (categories)
    {    sites = categories;          
         while ((site = *sites++) != NULL)
   	   fprintf (f, "CATEGORY=%s\n", site);
    }	   

    fclose(f);
    SitesChanged = 0;
    return 1;	

}

/*  1-Jul-99 */
short refresh_active_sites(void)
{
    struct site_info hi;
    short mask; 
    struct site_info proxy_inf, *proxy_inf_ptr;
    u_short pscount, new_asites_count, new_cat_count;	
    char **new_asites=NULL;
    char **new_categories=NULL;
    short rc = 0;
    char *psite;
    
    if ((new_flg || ForceReg) && reg_new())
    {  new_flg = 0;
       ForceReg = 0;	
       save_rcddb_config();
    }  

    rcddb_message_handler(0, "Refreshing sites");

    pscount = new_asites_count = new_cat_count = 0;
    new_asites = (char **) malloc (sizeof(char *) * 31);
    if (new_asites == NULL) return 0;

    new_categories = (char **) malloc (sizeof(char *) * 31);

    proxy_inf_ptr = NULL;
    if (UseProxy && parse_host_name(ProxyURL, &proxy_inf))
           proxy_inf_ptr = &proxy_inf;


    while ((psite = psites[pscount++]) != NULL)
    { 
	
       if (!parse_host_and_protocol(psite, &hi)) goto Exit;       	
       
       if (hi.db_type == 0)
       {  mask = 1 << (hi.pr_type); 
          if ((ProtocolUsed & mask) == 0) continue;

          mask = cddb_get_sites(&hi, proxy_inf_ptr,
	                        new_asites, &new_asites_count,
	                        new_categories, &new_cat_count);
       }
       else
          mask = 0;	/* CDINDEX does not support sites */   
	  
       if (mask == 0)
          new_asites[new_asites_count++] = strdup(psite);
       else
       if (mask == 2) break;	  
    }	   
       

    if (new_asites_count > 0) rc = 1;    
    
Exit:
    
    rcddb_message_handler(20, NULL);

    SitesChanged = 1;
     
    if (rc)
    {
        new_asites[new_asites_count] = NULL;
        if (asites) free_sites(asites);
	asites = new_asites;
	if (new_cat_count > 0)
	{  new_categories[new_cat_count] = 0; 
	   if (categories) free(categories);
	   categories = new_categories;
	}
	else
	if (new_categories) free(new_categories);   

	save_rcddb_config();
    }
    else
    {
	if (new_asites) free(new_asites);	
	if (new_categories) free(new_categories);	
    }	
        
    return rc;    		
}

static char *retrieve_ns_info(const char *string, const char *param)
{  
    char *result;

    result =  strstr(string, param);
    if (result == NULL) return result;

	result += strlen(param);
	if (*result++ != '\"') return NULL;
	
    result = strchr(result, ',');
    if (result == NULL) return result; 

    result++;	
    result += strspn(result, " \t");
    if (*result == '\"') result++;	  
    result = strtokm(result, "\"\t\n");
    return result;
}
    
/*  1-Jul-99 */
void rcddb_guess_config(void)
{   FILE *f;
    char buf[1025], *found;
	char proxy_port[5];	
	char proxy_type;	
    const char *search_str1 = "mail.identity.useremail";
    const char *search_str2 = "mail.identity.username"; 
    const char *search_str3 = "network.hosts.smtp_server";  
    const char *search_str4 = "network.proxy.http";  
    const char *search_str5 = "network.proxy.http_port";  
    const char *search_str6 = "network.proxy.type";  
    const char *userdir; 
    struct passwd *pwent;

    gethostname(buf, 151);    
    snprintf(UserAddr, 151, "%s@%s", getlogin(), buf);

    snprintf (AppVersion, 15, "%d.%d.%d", (SADP_VERSION >> 16) & 255,
               (SADP_VERSION >> 8) & 255, SADP_VERSION & 255); 	

    pwent = getpwent();
	proxy_type = 0;

    if (pwent == NULL)
        strncpy(UserFullName, "anonymous", 129);
    else	
        strncpy(UserFullName, pwent->pw_gecos, 129);

    strcpy(MailServer, "localhost");

    strcpy(ProxyURL, "");
    strcpy(proxy_port, "");

    /* Now configure from netscape */
    userdir = getenv("HOME");
    snprintf(buf, 1025, "%s/.netscape/preferences.js", userdir);    
    f = fopen(buf, "r");
    if (f == NULL) return;
    
    while (fgets(buf, 1025, f) != NULL)
    {
	  found = retrieve_ns_info(buf, search_str1);
	  if (found) strncpy(UserAddr, found, 151);

	  found = retrieve_ns_info(buf, search_str2);
	  if (found) strncpy(UserFullName, found, 151);

	  found = retrieve_ns_info(buf, search_str3);
	  if (found) strncpy(MailServer, found, 151);  

	  found = retrieve_ns_info(buf, search_str4);
	  if (found) strncpy(ProxyURL, found, 143);  

	  found = retrieve_ns_info(buf, search_str5);
	  if (found) 
	  {   strncpy(proxy_port, found, 4);
		  proxy_port[4] = '\0';
      }

	  found = retrieve_ns_info(buf, search_str6);
	  if (found) proxy_type = atoi(found);
	  if (proxy_type < 0 || proxy_type > 2) proxy_type = 0;
	  
	}
    fclose(f);

	if (proxy_type == 0)
	  strcpy(ProxyURL, "");
	else
    if (*ProxyURL != '\0')
	{  if (*proxy_port == '\0')
	 	 strcpy(proxy_port, "8080");
  	   sprintf(ProxyURL + strlen(ProxyURL), ":%s", proxy_port);
    }	

	if (proxy_type == 2)
    { 
	   snprintf(buf, 1025, "%s/.netscape/proxyconf", userdir);    
       f = fopen(buf, "r");
       if (f == NULL) return;

	   while (fgets(buf, 1025, f) != NULL)
	   {
      	 found = strstr(buf, "PROXY");
	       if (found == NULL) continue;
      	 found += 5;
	       found += strspn(found, " ");
      	 strtokm(found, ";\r\n");
	       strncpy( ProxyURL, found, 151);
	   }
	   fclose(f);       
    }

    UseProxy = (*ProxyURL != '\0');	    
                     
}

void rcddb_initargs(void)
{
    rcddb_guess_config();
    if (UserAddr)
      UserAddrReal = strdup(UserAddr);
    
}    

/*  1-Jul-99 */
void rcddb_initialize (void)
{   FILE *f;
    char fname[513];
    char *homedir;

    new_flg = 0;
    homedir = getenv("HOME");
    snprintf (fname, 513, "%s/.sadp", homedir);	
    mkdir(fname, 0755);

    /* ------------------------------------ */
    /*           Open log file              */
    /* ------------------------------------ */
    snprintf (fname, 513, "%s/.sadp/log", homedir);	
    if (UseLogFile) LogFile = fopen(fname, "w");
    
        
    /* ------------------------------------ */
    /*         Read premanent sites         */
    /* ------------------------------------ */
    snprintf (fname, 513, "%s/.sadp/sites", homedir);	

    f = fopen(fname, "r");
    if (f == NULL) f = fopen("/etc/rcddb.sites", "r");
    if (f != NULL)
    {   read_file_sites(f, &psites, &ssites, NULL);
        fclose(f);
    }    
    
    default_psites_used = (psites == NULL);
    if(default_psites_used)
       psites = (char **)default_psites;

    default_ssites_used = (ssites == NULL);
    if(default_ssites_used)
       ssites = (char **)default_ssites;

    /* ------------------------------------ */
    /*         Read active sites            */
    /* ------------------------------------ */

    asites = NULL;
    snprintf (fname, 513, "%s/.sadp/config", homedir);	
    f = fopen(fname, "r");

    if (f == NULL) 
    { new_flg = 1; 
      snprintf (fname, 513, "%s/.cddbrc", homedir);	
      f = fopen(fname, "r");
    }  

    if (f == NULL) 
	 asites = psites;
    else	 
    {   read_file_sites(f, &asites, NULL, &categories);
	fclose(f);
    }	

    return;
}


/*  1-Jul-99 */
static void free_sites(char **sites)
{   char *site;

    while((site = *sites) != NULL)
    {   free(site); *sites++ = NULL; }
                      
}	

/*  1-Jul-99 */
void rcddb_terminate(void)
{
   if (asites)
   {  if (SitesChanged && 
           ask_save_question("Sites information changed. Save Now?")
	 ) save_rcddb_config();
      if (asites != psites) free_sites(asites); 
  }       
         
   if (psites && !default_psites_used) free_sites(psites);
   if (LogFile) fclose(LogFile);
   if ( UserAddrReal) free(UserAddrReal);
}

/*  1-Jul-99 */
/*
void read_active_sites(void)
{    
    FILE *f;
    char fname[513];

    snprintf (fname, 513, "%s/.cddbrc", getenv("HOME"));	
    f = fopen(fname, "r");
    if (f == NULL) goto refresh;

    if (asites) free(asites);	
    asites = read_file_sites(f);
    fclose(f);
    if (asites == NULL)	goto refresh;
    return;
    
}
*/

/* =============================================== */
/* 1-Jul-99                                        */
/* site_ind is supposed to be OK (no validation).  */
/* ================================================*/ 
short rcddb_get_disc_data(void)
{    	
    char *site, **sites;
    short mask, rc;
    struct site_info  site_inf, proxy_inf, *proxy_inf_ptr;

	
    if (asites == NULL)
    	refresh_active_sites();


    if ((new_flg || ForceReg) && reg_new())
    {  new_flg = 0;
       ForceReg = 0;
       save_rcddb_config();
    }   	

    sites = asites;
    rc = 0;

    if (UseProxy && parse_host_name(ProxyURL, &proxy_inf))
       proxy_inf_ptr = &proxy_inf;
    else  	    
       proxy_inf_ptr = NULL;

    rcddb_message_handler(0, "Downloading disc data");


    while ((site = *sites++) != NULL)
    { if (!parse_host_and_protocol(site, &site_inf))
	    continue;
      mask = 1 << site_inf.pr_type;
      if (site_inf.db_type == 0) 
      {   if((ProtocolUsed & mask) == 0) continue;
	  if (cddb_disc_id == 0) 
	       cddb_disc_id = get_cddb_discid();
	  if (cddb_query == NULL)
	  {    cddb_query = get_cddb_query();
	       if (cddb_query == NULL) continue;
	  }       
          mask = cddb_go_get_it(&site_inf, proxy_inf_ptr);
      }
      else
     {  if (cdix_query==NULL)
	  {   cdix_query  = get_cdindex_query();
	     if (cdix_query == NULL) continue;
        }	     

        mask = cdix_go_get_it(&site_inf, proxy_inf_ptr);
     }	      

      if (mask) 
      {
	if(mask == 1) rc = 1;
        break; 
      } 
    }
    
//    if (rc == 1 || sites == NULL)
    rcddb_message_handler(20, NULL);
    if (rc) save_local_db();

    if (cddb_query)
    {  free(cddb_query); cddb_query = NULL; }

    if (cdix_query)
    {  free(cdix_query); cdix_query = NULL; }
    
    return rc;  
       
}


short rcddb_submit_data(char **sites)
{
    char *site;
    short res, rc;
    struct site_info  site_inf, proxy_inf, *proxy_inf_ptr;
    char *cddb_data_file = NULL, *cdix_data_file = NULL; 
    u_long cddb_data_length = 0, cdix_data_length = 0;
    
    if ((new_flg || ForceReg) && reg_new())
    {  new_flg = 0;
       ForceReg = 0;
       save_rcddb_config();
    }   	

    rc = 0;

    if (UseProxy && parse_host_name(ProxyURL, &proxy_inf))
       proxy_inf_ptr = &proxy_inf;
    else  	    
       proxy_inf_ptr = NULL;


    rcddb_message_handler(0, "Submitting disc data");

    while ((site = *sites++) != NULL)
    { if (!parse_host_and_protocol(site, &site_inf))
	    continue;


      if (site_inf.db_type == 0) 
      {
	 if (*DiscCategory == '\0') continue;    
	    
         if (cddb_data_file == NULL &&
	      !make_xmcd_file(&cddb_data_file, &cddb_data_length))
         {  rcddb_message_handler(2, "Could not create temporary CDDB file");
	    break; 
         }
 
          res = rcddb_submit(&site_inf,  proxy_inf_ptr,
		    cddb_data_file, cddb_data_length);
      }		    
      else  	  
      {  if (cdix_data_file == NULL &&
	      !make_xml_file(&cdix_data_file, &cdix_data_length))
         {  rcddb_message_handler(2, "Could not create temporary CD-INDEX file");
	    break; 
         }

         res = rcddb_submit(&site_inf,  proxy_inf_ptr,
		    cdix_data_file, cdix_data_length);
      }

      if (res == 2) break;
    }
    
    rcddb_message_handler(20, NULL);
    if (cddb_data_file)
    {  
	remove (cddb_data_file);
        free (cddb_data_file);
    }
    if (cdix_data_file)
    {  
	remove (cdix_data_file);
        free (cdix_data_file);
    }
    return rc;  

}

#endif /* RCDDB_SUPPORT */
