/*  =========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ----------------------------------------------------------
    sadp_cddbext (later sadp_rcddbxforms) - started 1-Jul-99
    ========================================================= */
#include <forms.h>
#include <stdlib.h>
#include <unistd.h>
#include "sadp_xforms.h"
#include "sadp_rcddb.h"
#include "sad.h"

#ifdef RCDDB_SUPPORT

typedef struct {
   FL_FORM   *sadp_comm;
   FL_OBJECT *message_txt;
   FL_OBJECT *header_txt;
   FL_OBJECT *cancel_btn;
   FL_OBJECT *continue_btn;
   
   FL_FORM   *sel_frm;
   FL_OBJECT *sel_title_box;
   FL_OBJECT *sel_selection;
   FL_OBJECT *sel_accept_button;
   FL_OBJECT *sel_decline_button;
   FL_OBJECT *sel_cancel_button;
   
   FL_FORM   *sadp_registration;
   FL_OBJECT *reg_server;
   FL_OBJECT *reg_from;
   FL_OBJECT *reg_to;
   FL_OBJECT *reg_subject;
   FL_OBJECT *reg_content;
   FL_OBJECT *reg_comments;
   FL_OBJECT *reg_anonym;
   FL_OBJECT *reg_send;
   FL_OBJECT *reg_later;

   FL_FORM   *sadp_submit_form;
   FL_OBJECT *submit_title_box;
   FL_OBJECT *submit_category_choice;    
   FL_OBJECT *submit_sites_browser;
   FL_OBJECT *submit_multiartist_box;
   FL_OBJECT *submit_revision_box;
   FL_OBJECT *submit_sender_box;
   FL_OBJECT *submit_index_box;
   FL_OBJECT *submit_discid_box;
#ifdef MCN_SUPPORT
   FL_OBJECT *submit_mcn_label;
   FL_OBJECT *submit_mcn_box;
#endif   
   FL_OBJECT *submit_set_category_box;
} FD_sadp_comm;

static FD_sadp_comm *create_form_sadp_comm(void);
static FD_sadp_comm *xcomm_fd = NULL;
static short CancelReq;

extern FL_FORM *MainFrm;

extern const  char  *ResrcName;
extern char UserAddr[];
extern char *UserAddrReal;
extern char MailServer[];
extern char *AppName;
extern char AppVersion[];
extern char  UserFullName[];
extern char  ProxyURL[];
extern short UseProxy, ProtocolUsed;
extern char  disc_name[DATA_NAME_SIZE];
extern char  disc_artist[DATA_NAME_SIZE]; 
extern u_long disc_revision;
extern char   cd_description[];
extern char   cd_model[];

extern u_long cddb_disc_id;
extern short cd_multi_artist;
extern char   *cdix_index;

extern Window MainWnd;
extern Display	*disp;
extern short   SitesChanged, OptionsChanged;
extern short   DataChanged;

extern FL_OBJECT   *RcddbControls[30];
extern char **psites, **asites, *ssites, **categories;
extern char *default_categories[]; 

extern char  *RegMailDestinator;
extern char  *RegMailSubject;

extern char  CDDeviceName[];
extern char  AudioDeviceName[];

#if defined(DSP_SUPPORT) && defined(ALSA_DSP_SUPPORT)
extern int alsa_dsp;
extern short mmap_active;
#endif

static void set_proxyon_visibility(void);
static void set_proxyaddr_visibility(void);

extern char  DiscCategory[15], DefaultCategory[15];  
extern const char  *anonym_text;

extern u_char CDDeviceType, CDNodeNumber;

#ifdef MCN_SUPPORT
extern const char *cd_upcode;   /* MCN (UPC) */
#endif

/* These are common interface routines */
/* Type:
	  0 - show form
	  1 - set header
          2 - set message
	 20 - hide 
	 21 - error - wait for press 
*/	 

#if FL_INCLUDE_VERSION < 86
static int fl_form_is_visible(FL_FORM *f)
{    return f->visible;    }

#define FL_NORMAL_CHOICE2 FL_NORMAL_CHOICE

#define  fl_show_messages(message)  fl_show_message("", message, "")

#endif
      
static void hide_comm_form(FL_FORM *f)
{
    if (fl_form_is_visible(f))
    {    fl_activate_form(MainFrm);
	 fl_hide_form(f);
/*         fl_winset(MainWnd); */
    }	 
}

short  rcddb_message_handler(int type, char *message)
{
    FL_OBJECT *obj;	
    
    fl_check_forms();

    if (xcomm_fd == NULL) return 1;	/* Ignore */


    switch(type)
    {	case 0:
        {
	    FL_FORM *f;
	    int x, y;


	    f = xcomm_fd->sadp_comm; 
	    if (fl_form_is_visible(f)) fl_hide_form(f); 
	    
	    fl_deactivate_form(MainFrm);
	    x = MainFrm->x + (MainFrm->w - f->w) / 2;
	    y = MainFrm->y + (MainFrm->h - f->h) / 2;
	    fl_set_form_position(f, x, y);     
	    fl_hide_object(xcomm_fd->continue_btn);
	    fl_set_object_size(xcomm_fd->cancel_btn, 243, 21);
	    fl_show_form(f, FL_PLACE_GEOMETRY, FL_TRANSIENT, ResrcName);
	    fl_set_form_title(f, message);
	    CancelReq = 0;
	    fl_activate_form(f);			   
	    fl_raise_form(f);
        }	  
	    break;           
    
       case 1:
          CancelReq = 0;
	    fl_hide_object(xcomm_fd->continue_btn);
	    obj = xcomm_fd->cancel_btn;
	    fl_set_object_size(obj, 246, 21);
	    fl_redraw_object(obj);
	    obj = xcomm_fd->header_txt;
	    fl_set_object_label(obj, message);
	    fl_redraw_object(obj);
	    obj = xcomm_fd->message_txt;
	    fl_set_object_label(obj, "");
	    fl_redraw_object(obj);
	    break;
	  
       case 2:
	    if (CancelReq) 
	    {  hide_comm_form(xcomm_fd->sadp_comm);
	       return 0; 
	    }
	    obj = xcomm_fd->message_txt;
	    fl_set_object_label(obj, message);
	    fl_redraw_object(obj);
	    break;
	  
        case 20:
	    fl_check_forms();
	    hide_comm_form(xcomm_fd->sadp_comm);
	    break;

	case 21:
	    if (message)
	       fl_set_object_label(xcomm_fd->message_txt, message);
	    obj = xcomm_fd->cancel_btn;   
	    fl_set_object_size(obj, 123, 21);
	    fl_show_object(xcomm_fd->continue_btn);
	    while(!CancelReq) fl_check_forms();
	    if (CancelReq == 1)
	       hide_comm_form(xcomm_fd->sadp_comm);

	    return (CancelReq == 1) ? 2 : 0;
	    	    

    }

           return 1;
}

short  rcddb_data_handler(int type, char *message)
{   FL_OBJECT *obj;	
    
    fl_check_forms();

    if (xcomm_fd == NULL) return 1;	/* Ignore */


    switch(type)
    {	case 0:
        {
	    FL_FORM *f;
	    int x, y;


	    f = xcomm_fd->sadp_comm;
	    fl_winhide(f->window);
	    x = f->x; y = f->y;

	    f = xcomm_fd->sel_frm; 
	    if (fl_form_is_visible(f)) fl_hide_form(f);
	    fl_set_form_position(f, x, y);     
	    fl_hide_object(xcomm_fd->sel_accept_button);
	    fl_hide_object(xcomm_fd->sel_decline_button);
	    fl_set_object_size(xcomm_fd->sel_cancel_button, 243, 21);
	    fl_show_form(f, FL_PLACE_GEOMETRY, FL_TRANSIENT, ResrcName);
	    fl_set_form_title(f, message);
	    CancelReq = 0;
	    fl_activate_form(f);			   
        }	  
	    break;           
    
       case 1:
            CancelReq = 0;
	    fl_hide_object(xcomm_fd->sel_accept_button);
	    fl_hide_object(xcomm_fd->sel_decline_button);
	    obj = xcomm_fd->sel_cancel_button;
	    fl_set_object_size(obj, 243, 21);
	    fl_redraw_object(obj);
	    obj = xcomm_fd->sel_title_box;
	    fl_set_object_label(obj, message);
	    fl_redraw_object(obj);
	    obj = xcomm_fd->sel_selection;
	    fl_clear_browser(obj);
	    fl_redraw_object(obj);
	    break;
	  
       case 2:
	    if (CancelReq)
	    { hide_comm_form(xcomm_fd->sel_frm);
	      return 0;
	    }
	    obj = xcomm_fd->sel_selection;
	    fl_add_browser_line(obj, message);
	    fl_redraw_object(obj);
	    break;
	  
        case 20:
	    hide_comm_form(xcomm_fd->sel_frm);
	    break;

	case 21:
	{   int rc;
		
	    obj = xcomm_fd->sel_selection;
	    if (fl_get_browser_maxline(obj) <= 0) 
		rc = 0;
	    else	      
    	    {
		fl_select_browser_line(obj, 1);
		fl_set_object_size(xcomm_fd->sel_cancel_button, 82, 21);
		fl_show_object(xcomm_fd->sel_accept_button);
		fl_show_object(xcomm_fd->sel_decline_button);
		while(!CancelReq) fl_check_forms();
    	        if (CancelReq == 3) rc = fl_get_browser(obj) + 1;
		               else rc = CancelReq -1;
	    }
   	    CancelReq = 0;
	    hide_comm_form(xcomm_fd->sel_frm);
	    fl_winshow(xcomm_fd->sadp_comm->window);
	    fl_redraw_form(xcomm_fd->sadp_comm);
	    return rc;
	}
     }

     return 1;
}


static void rcddb_show_sites(void)
{   FL_OBJECT *site_browser;
    char  **site_name_ptr, *site_name;

    site_browser = RcddbControls[RCDDB_SITELIST];
    
    fl_clear_browser(site_browser);
    
    site_name_ptr = asites;    
    while ((site_name = *site_name_ptr++) != NULL)
        fl_add_browser_line(site_browser, site_name);

    if (fl_get_browser_maxline(site_browser) > 0)
        fl_select_browser_line(site_browser, 1);
}    
    

static void rcddb_show_config(void)
{

    fl_set_input(RcddbControls[RCDDB_USER], UserAddr);

    fl_set_input(RcddbControls[RCDDB_PROXYADDR], ProxyURL);
    fl_set_input(RcddbControls[RCDDB_MAILADDR], MailServer);
    fl_set_choice(RcddbControls[RCDDB_PROTCHOICE], ProtocolUsed);
    fl_set_button(RcddbControls[RCDDB_PROXYON], UseProxy);
    
    set_proxyon_visibility();
    set_proxyaddr_visibility();
}

void rcddb_xforms_initialize(void)
{
    xcomm_fd = create_form_sadp_comm();
    rcddb_show_config();    
    rcddb_show_sites();
    
}

void rcddb_got_focus(void)
{    
    set_proxyon_visibility();
    set_proxyaddr_visibility();
}


void get_rid_of_form(FL_FORM *f)
{
    if (fl_form_is_visible(f))
        fl_hide_form(f);
    fl_free_form(f);
}    	

void rcddb_xforms_deinitialize(void)
{
    if (xcomm_fd)
    {	get_rid_of_form(xcomm_fd->sadp_comm);
	get_rid_of_form(xcomm_fd->sel_frm);
	get_rid_of_form(xcomm_fd->sadp_registration);
	get_rid_of_form(xcomm_fd->sadp_submit_form);
        free(xcomm_fd);
    }	
}


static void rcddb_make_browser_line_visible(FL_OBJECT *brw, int lineno)
{
    int topline = fl_get_browser_topline(brw);

    if (lineno < topline)
         fl_set_browser_topline(brw, lineno);
    else
    { int screenlines = fl_get_browser_screenlines(brw);
      if (lineno >= topline + screenlines)
         fl_set_browser_topline(brw, lineno-screenlines+1);
    }	 
}    

static void  rcddb_swap_sites(short from, short new_active)
{
    FL_OBJECT *brw = RcddbControls[RCDDB_SITELIST];
    short start = fl_get_browser(brw);
    char *from_line, *to_line;
    int  lineno;
    
    from += start; 
    
    if (from < 1 || from >= fl_get_browser_maxline(brw)) return;
    
    from_line = asites[from-1];
    to_line = asites[from];
    asites[from-1] = to_line;
    asites[from] = from_line;

    fl_replace_browser_line(brw, from, to_line);
    fl_replace_browser_line(brw, from+1, from_line);

    lineno = start+new_active;
    fl_select_browser_line(brw, lineno);
     rcddb_make_browser_line_visible(brw, lineno);
    
    SitesChanged = 1;
}

void  rcddb_delete_site(void)
{
    FL_OBJECT *brw = RcddbControls[RCDDB_SITELIST];
    short index = fl_get_browser(brw);
    char  *site, **siteptr = asites+index-1;	
    
    free(*siteptr);

    do *siteptr++ = site = *(siteptr+1);
    while (site != NULL);
    
    fl_delete_browser_line(brw, index);
    if (index > fl_get_browser_maxline(brw)) index--;
    
    if (index > 0) fl_select_browser_line(brw, index);
    SitesChanged = 1;
}      		

static void set_proxyaddr_visibility(void)
{ 

   FL_OBJECT *obj = RcddbControls[RCDDB_PROXYADDR];
/*   if (UseProxy && (ProtocolUsed & 2) ) fl_show_object(obj); */
   if (UseProxy) fl_show_object(obj); 
        else  fl_hide_object(obj);
	
}

static void set_proxyon_visibility(void)
{ 
	;
/*
   FL_OBJECT *obj = RcddbControls[RCDDB_PROXYON];
   if (ProtocolUsed & 2) fl_show_object(obj);
        else  fl_hide_object(obj);
*/	
}

void rcddb_callback(FL_OBJECT *obj, long par)
{
    switch(par)
    { 
	case RCDDB_USER:
	    strncpy(UserAddr, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;

	case RCDDB_PROXYADDR:
	    strncpy(ProxyURL, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;

	case RCDDB_GUESS:
	    rcddb_guess_config();
	    rcddb_show_config();
	    OptionsChanged = 1;
	    break;
	     
	case RCDDB_PROXYON:
	    UseProxy = fl_get_button(RcddbControls[RCDDB_PROXYON]);
	    set_proxyaddr_visibility();
	    OptionsChanged = 1;
	    break;
	    
	case RCDDB_MAILADDR:
	    strncpy(MailServer, fl_get_input(obj), 151);
	    OptionsChanged = 1;
	    break;
	    
	case RCDDB_PROTCHOICE:
	    ProtocolUsed = fl_get_choice(RcddbControls[RCDDB_PROTCHOICE]);
/*	    set_proxyon_visibility();
	    set_proxyaddr_visibility(); */
	    OptionsChanged = 1;
	    break;
	    
	case RCDDB_REFRESH:
	    if (ProtocolUsed && refresh_active_sites())
		     rcddb_show_sites();
	    break;

	case RCDDB_UP:
	    rcddb_swap_sites(-1, -1);
	    break;
	
	case RCDDB_DOWN:
	    rcddb_swap_sites(0, 1);
	    break;
	    
	case RCDDB_DELETE:
	    rcddb_delete_site();
	    break;
	     	          
        case RCDDB_SITELIST:
 	    input_processing(obj);
	    break;
	    

	case RCDDB_HIDDEN:
	{   KeySym key = xforms_get_last_key();
	    if (get_kbd_shift() & ShiftMask)
	    {  par = (key == XK_Down) ? RCDDB_DOWN : RCDDB_UP;       
	       rcddb_callback(obj, par);
	    }
	    else
	    {  int pos;
	       obj = RcddbControls[RCDDB_SITELIST];
	       pos = fl_get_browser(obj);
	       pos += (key == XK_Down) ? 1: -1;
	       if (pos > 0 && pos <= fl_get_browser_maxline(obj))
	       { fl_select_browser_line(obj, pos);    	     			       
		 rcddb_make_browser_line_visible(obj, pos);
	       }	 
	    }
	}

     }
}    

short rcddb_download_data(void)
{    short ret;

     UseProxy = fl_get_button(RcddbControls[RCDDB_PROXYON]);
     
     ret = rcddb_get_disc_data();
     return ret;     

}

static void cancel_button_callback(FL_OBJECT *obj, long par)
{
    CancelReq = par;
}

static short content_lineno = 0;
static short comment_lineno = 0;

const char *get_mail_fromaddr(void)
{  
   content_lineno = comment_lineno = 0;
   if (fl_get_button(xcomm_fd->reg_anonym))
 	return anonym_text;
   else
	return fl_get_input(xcomm_fd->reg_from);
}    

const char *get_mail_sender(void)
{
    content_lineno = comment_lineno = 0;
    return fl_get_input(xcomm_fd->reg_from);
    //	return xcomm_fd->reg_from->label;
}

const char *get_mail_contentline(void)
{   FL_OBJECT *obj = xcomm_fd->reg_content;

    if (++content_lineno > fl_get_browser_maxline(obj))
	    return NULL;

    return fl_get_browser_line(obj, content_lineno);
	    
}

const char *get_mail_commentline(void)
{   const char *ret;

    if (comment_lineno > 0) return NULL;
    
    comment_lineno++;

    ret = fl_get_input(xcomm_fd->reg_comments);      
    if (*ret == '\0') return NULL;
    
    return ret;
}

/*
static void commit_reg_line(char *line)
{

    fl_add_browser_line(xcomm_fd->reg_content, line);
}    



void set_reg_address_label(void)
{   FL_OBJECT *obj;

    obj = xcomm_fd->reg_from;

    if (fl_get_button(xcomm_fd->reg_anonym))
    {  
       char label[151];
       char *endptr, *dotptr;

       strcpy(label, "xsadp_user@darksite");
       dotptr = strrchr(UserAddrReal, '.');
       
       if (dotptr)
       {  
           endptr = UserAddrReal+strlen(UserAddrReal);	
	   if (endptr - dotptr <= 3)   // Country code 
	   { if (*(dotptr - 4) == '.') dotptr -= 4; }
	   
	   strcat(label, dotptr);      
       }	   

       fl_set_input(obj, label); 
       fl_deactivate_object(obj);
    }
    else
    { 
       fl_set_input(obj, UserAddr); //UserAddrReal 
       fl_activate_object(obj);
    }	
}

static void fill_reg_form(void)
{ 
    char txt1[61], txt2[61];
    char text[81];   
    double cpuclock, mips; 
    int	 release;
    int  v1, v2, v3;
    char  *ptr;


    fl_set_input(xcomm_fd->reg_server, MailServer);
    set_reg_address_label();   
    
    fl_clear_browser(xcomm_fd->reg_content);

    snprintf(text, 81, "Application: xsadp v. %s", get_sadp_version());
    commit_reg_line(text);

    
    get_os_data(txt1, txt2);
    snprintf(text, 81, "System:      %s %s", txt1, txt2);
    commit_reg_line(text);
    commit_reg_line("");


    ptr = ServerVendor(disp);
    if (ptr)
    {  commit_reg_line("X Server");
       snprintf(text, 81,  "    Vendor:  %s", ptr);   
//       XFree(ptr); 
       commit_reg_line(text);

       release = VendorRelease(disp);
       v1 = release / 1000; release %=1000;
       v2 = release / 100;   v3 = release % 100;
       snprintf (text,81,  "    Release:  %d.%d.%02d", v1, v2, v3);
       commit_reg_line(text);
       commit_reg_line("");
    }  


    fl_library_version(&v1, &v2); 
    snprintf(text, 81, "XForms:      %d.%d", v1, v2);
    commit_reg_line(text);
    
    commit_reg_line("");

    if (get_cpu_data(txt1, txt2, &cpuclock, &mips))
    { 
       commit_reg_line("CPU");	
       if (strlen(txt1)>0)
       {  snprintf (text, 81, "    Type:     %s", txt1);	
          commit_reg_line(text);
       }	  
       if (strlen(txt2)>0)
       {  snprintf (text, 81, "    Model:    %s",  txt2);	
          commit_reg_line(text);
       }
       if (cpuclock > 0)	  
       {  snprintf (text, 81, "    Clock:    %.1f MHz", cpuclock);
          commit_reg_line(text);
       }	   
       if (mips > 0)	  
       {  snprintf (text, 81, "    Speed:    %.1f MIPS", mips);	
          commit_reg_line(text);
       }   	  

       commit_reg_line("");
    }

#ifdef DSP_SUPPORT
    if ( get_sound_version(text, txt1, txt2))
    { char text5[81];
	commit_reg_line("SOUND SUPPORT");

	snprintf (text5, 81, "   Driver:    %s %s", text, txt1);
	commit_reg_line(text5);
	if (*txt2 != '\0') 
	{  snprintf (text5, 81, "   ALSA:     %s", txt2);
	   commit_reg_line(text5);
	}
    }

    if (get_audio_name(AudioDeviceName, "dsp", "Audio devices:",
                         txt1, NULL,  txt1, txt2))
    {   snprintf (text, 81, "   Audio:     %s", txt1);	
        commit_reg_line(text);
	  if (*txt2 != '\0')
        {  snprintf (text, 81, "                  %s", txt2);
           commit_reg_line(text);
	  }	
#ifdef ALSA_DSP_SUPPORT
	  if (alsa_dsp)
	 	 snprintf(text, 81, "   Access:   ALSA %s", mmap_active ? "memory map" : "");
	  else
	 	 snprintf(text, 81, "   Access:   OSS");
        commit_reg_line(text);
#endif	
    }
    else
        commit_reg_line("DSP is unavailable");
				 
#else
    commit_reg_line("NO DSP Support");
#endif    	

    commit_reg_line("");

    commit_reg_line("CD");

//    if (strlen(cd_description) > 0)     
        snprintf(text, 81, "    Type:       %s", cd_description);
//    else
//        snprintf(text, 81, "    Node major: %d", CDDeviceType); 
    commit_reg_line(text);

    if (strlen(cd_model)>0)    
    {    snprintf(text, 81, "    Model:     %s", cd_model);
         commit_reg_line(text);
    }	 


}    

short reg_new(void)
{   FL_FORM *f;
    FL_OBJECT *obj;
    short rc;
    int x, y;
    

    f = xcomm_fd->sadp_registration; 
    
    fl_deactivate_form(MainFrm);
    x = MainFrm->x + (MainFrm->w - f->w) / 2;
    y = MainFrm->y + (MainFrm->h - f->h) / 2;
    fl_set_form_position(f, x, y);     
    fl_show_form(f, FL_PLACE_GEOMETRY, FL_TRANSIENT, "XSadp");

    fill_reg_form();

    fl_set_form_title(f, "XSADP - Registration");
    fl_activate_form(f);			   

    rc = 0;
    
    while((obj = fl_do_forms()) != xcomm_fd->reg_later)
    { 
       if ( obj == xcomm_fd->reg_anonym)
           set_reg_address_label();
       else	   
       if (obj == xcomm_fd->reg_send)
       {  
          strncpy(MailServer, fl_get_input(xcomm_fd->reg_server), 151);
          fl_set_input(RcddbControls[RCDDB_MAILADDR], MailServer);

	  if (!fl_get_button(xcomm_fd->reg_anonym))
	  { 
            strncpy(UserAddr, fl_get_input(xcomm_fd->reg_from), 151);
	    fl_set_input(RcddbControls[RCDDB_USER], UserAddr);
	  }	    

          rc = rcddb_sendreg();
	  break;
       }
    }      
      
    fl_hide_form(f);   
    fl_activate_form(MainFrm);			   
    
//    return rc;   
    return 1;
}
*/
/* ============================================================== */

void xforms_submit_data(void)
{

    FL_FORM *f;
    FL_OBJECT *obj;
    int x, y;
    short result;
    char buf[121];
    Window wnd;
    char **categs, *categ;

    result = check_cdinfo_completeness();
    if (result != 0)
    {
	if (result == 1)
            strcpy (buf, "Disc title is missing or invalid.");
	else
	    sprintf(buf, "Track %d name is invalid or missing.", 
		    result - 10);
		       
        fl_show_message("Submission cannot be performed:",
                         buf,
			"Please, make sure that disc information and track names are correct.");
	return;			
    }
        
    if (DataChanged) save_local_db();

    f = xcomm_fd->sadp_submit_form; 
    if (fl_form_is_visible(f)) fl_hide_form(f);

    obj = xcomm_fd->submit_category_choice;
    fl_clear_choice(obj);

    fl_addto_choice(obj, "[undef]");
    categs = categories;
    if (!categs) categs = default_categories; 
    fl_set_choice(obj, 1);	   
 
    fl_set_button(xcomm_fd->submit_set_category_box, 1);

    if (categs)
       while ((categ = *categs++) != NULL)
       {   fl_addto_choice(obj, categ);
           if (strcasecmp(categ, DiscCategory) == 0)
           { fl_set_choice(obj, fl_get_choice_maxitems(obj));	   
	     fl_set_button(xcomm_fd->submit_set_category_box, 0);
	   }     
       }	     
    

    obj = xcomm_fd->submit_sites_browser;
    fl_clear_browser(obj);
    categs = (char **) ssites;
    if (categs)
    while ((categ = *categs++) != NULL)
        fl_add_browser_line(obj, categ);
    	     
    if (fl_get_browser_maxline(obj) > 0)
	fl_select_browser_line(obj, 1); 
           	    
    fl_deactivate_form(MainFrm);
    x = MainFrm->x + (MainFrm->w - f->w) / 2;
    y = MainFrm->y + (MainFrm->h - f->h) / 2;
    fl_set_form_position(f, x, y);     

/*
    if (strlen(disc_artist) == 0)
        snprintf(buf, 121, "%s", disc_name);
    else
        snprintf(buf, 121, "%s / %s", disc_artist, disc_name);
	
    fl_set_object_label(xcomm_fd->submit_title_box, buf);
*/    
    fl_set_object_label(xcomm_fd->submit_title_box, disc_name);
    
    fl_set_object_label(xcomm_fd->submit_multiartist_box, 
                cd_multi_artist ? "Multi-artist" : "Single artist");

    sprintf(buf, "%lu", disc_revision);
    fl_set_object_label(xcomm_fd->submit_revision_box, buf);

    cddb_disc_id = get_cddb_discid();
    
    fl_set_object_label(xcomm_fd->submit_sender_box, UserAddr);
    fl_set_object_label(xcomm_fd->submit_index_box, cdix_index);

    sprintf(buf, "%lu", cddb_disc_id);
    fl_set_object_label(xcomm_fd->submit_discid_box, buf);

#ifdef MCN_SUPPORT
    if (cd_upcode == NULL)
    {  fl_hide_object(xcomm_fd->submit_mcn_box);
       fl_hide_object(xcomm_fd->submit_mcn_label);
    }
    else
    {  fl_set_object_label(xcomm_fd->submit_mcn_box, cd_upcode);    
       fl_show_object(xcomm_fd->submit_mcn_box);
       fl_show_object(xcomm_fd->submit_mcn_label);
    }
#endif        

    wnd = fl_show_form(f, FL_PLACE_GEOMETRY, FL_TRANSIENT, ResrcName);
/*    fl_winset(wnd); */
    fl_set_form_title(f, "xsadp: About to submit data...");
    fl_activate_form(f);			   
} 

void rcddb_show_message(char *message)
{
     fl_show_messages(message);
}

void submit_form_callback(FL_OBJECT *obj, long par)
{   int i;

    switch (par)
    {	case 0:
	    break;
	    
	case 1:
	{   FL_OBJECT *obj;	
	    char **site_list;
	    int nlines;
	    
	    const char *new_categ;

	    obj = xcomm_fd->submit_category_choice;	

	    i = fl_get_choice(obj);
	    if (i<=1)
	    {   fl_show_messages("Please, select disc category\n");
		break;
	    }		
	    
	    new_categ = fl_get_choice_text(obj);
	    if (strcasecmp(DiscCategory, new_categ))
	    {  strcpy(DiscCategory, new_categ);
	       DataChanged = 1;
	    }   	

	    if (fl_get_button(xcomm_fd->submit_set_category_box) &&
	           strcasecmp(DefaultCategory, new_categ))
	    {  strcpy(DefaultCategory, new_categ);
	       OptionsChanged = 1;
	    }   	   
	       

	    obj = xcomm_fd->submit_sites_browser;
	    nlines = fl_get_browser_maxline(obj);
	    site_list = malloc((nlines+1) * sizeof(char *));

	    if (site_list)	      
	    {	for (i=0; i<nlines; i++)
		    site_list[i] = strdup(fl_get_browser_line(obj, i+1));

		site_list[nlines] = NULL;		    
	    }
	    hide_comm_form(xcomm_fd->sadp_submit_form);
	    
	    if (site_list)	      
	    {   
	        rcddb_submit_data(site_list);
	    	for (i=0; i<nlines; i++)
		    if (site_list[i]) free(site_list[i]);
		free(site_list);		    
	    }
	}	    
	    break;
	    
	case 2:
	    hide_comm_form(xcomm_fd->sadp_submit_form);
	    break;
	    
	/* Remove site */	    
	case 10:	    
	{   FL_OBJECT *obj;	
	    int nlines;

	    obj = xcomm_fd->submit_sites_browser;
	    i = fl_get_browser(obj);
	    if (i <= 0) break;
	    
	    fl_delete_browser_line(obj, i);
	    nlines = fl_get_browser_maxline(obj);
	    if (i > nlines) i = nlines;
	    if (i>0) fl_select_browser_line(obj, i);
	}	    
	    	    
    }	    
		    
}

/* ============================================================== */
FD_sadp_comm *create_form_sadp_comm(void)
{
  FL_OBJECT *obj;
  FD_sadp_comm *fdui = (FD_sadp_comm *) calloc(1, sizeof(*fdui));

  fdui->sadp_comm = fl_bgn_form(FL_NO_BOX, 309, 135);
  obj = fl_add_box(FL_DOWN_BOX,0,0,306,135,"");
  fdui->message_txt = obj = fl_add_text(FL_NORMAL_TEXT,31,42,246,49,"");
    fl_set_object_boxtype(obj,FL_EMBOSSED_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_WHITE);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->header_txt = obj = fl_add_text(FL_NORMAL_TEXT,31,20,246,22,"");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_MCOL);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->cancel_btn = obj = fl_add_button(FL_NORMAL_BUTTON,31,91,123,21,"Cancel");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_button_shortcut(obj,"Cc",1);
    fl_set_object_callback(obj, cancel_button_callback, 1);
  fdui->continue_btn = obj = fl_add_button(FL_NORMAL_BUTTON,154,91,123,21,"Continue");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, cancel_button_callback, 2);
    fl_set_button_shortcut(obj, "tT", 1);
  fl_end_form();

  fdui->sel_frm = fl_bgn_form(FL_NO_BOX, 309, 135);
  obj = fl_add_box(FL_UP_BOX,0,0,309,135,"");

  fdui->sel_title_box =
    obj = fl_add_box(FL_FRAME_BOX,31,9,246,20,"");
    fl_set_object_color(obj,SADP_BLACK,FL_COL1);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);

  fdui->sel_selection =
    obj = fl_add_browser(FL_HOLD_BROWSER,31,30,246,70,"");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_lalign(obj,FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_FIXEDBOLDITALIC_STYLE);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_browser_vscrollbar(obj, FL_OFF);

  fdui->sel_cancel_button =
    obj = fl_add_button(FL_NORMAL_BUTTON,31,100,82,22,"Cancel");
    fl_set_button_shortcut(obj,"Cc",1);
    fl_set_object_callback(obj, cancel_button_callback, 1);

  fdui->sel_accept_button =
    obj = fl_add_button(FL_RETURN_BUTTON,113,100,82,22,"Accept");
    fl_set_button_shortcut(obj,"Aa",1);
    fl_set_object_callback(obj, cancel_button_callback, 3);

  fdui->sel_decline_button =
    obj = fl_add_button(FL_NORMAL_BUTTON,195,100,82,22,"Continue");
    fl_set_button_shortcut(obj,"tT",1);
    fl_set_object_callback(obj, cancel_button_callback, 2);


  fl_end_form();

  fdui->sadp_registration = fl_bgn_form(FL_NO_BOX, 450, 340);
  obj = fl_add_box(FL_UP_BOX,0,0,450,360,"");

  obj = fl_add_box(FL_EMBOSSED_BOX,20,9,414,70,
          "SADP is going to email a registration form,  containing ONLY the details listed below.\n"
	  "It is essential to ecourage the development  of the player. No part of this information\n"
	  "will be used for any other purpose. Press 'Anonymous' button to suppress your email\n"
	  "address, or you get an opportunity to be notified, when the next release appears.  At\n"
	  "last, you can choose not to send this email.  Your comments are exteremely valuable. ");
 	                   	  
    obj = fl_add_box(FL_NO_BOX,15,88,61,10,"Mail server:");

  fdui->reg_server =     
    obj = fl_add_input(FL_NORMAL_INPUT,20,102, 200,19,"");
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);

  obj = fl_add_box(FL_NO_BOX,15,125,35,10,"From:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->reg_from =     
/*    obj = fl_add_text(FL_NORMAL_TEXT,20,136,200,19,""); */
    obj = fl_add_input(FL_NORMAL_INPUT,20,136,200,19,""); 
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  obj = fl_add_box(FL_NO_BOX,15,159,35,10,"To:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->reg_to =     
    obj = fl_add_text(FL_NORMAL_TEXT,20,170,200,19, RegMailDestinator);
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  obj = fl_add_box(FL_NO_BOX,15,193,48,11,"Subject:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->reg_subject =     
    obj = fl_add_text(FL_NORMAL_TEXT,20,204,200,19, RegMailSubject);
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  fdui->reg_content =     
  obj = fl_add_browser(FL_NORMAL_BROWSER,239,102,194,121,"Content:");
    fl_set_object_lstyle(obj,FL_FIXEDBOLD_STYLE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
  
  fdui->reg_comments =     
    obj = fl_add_input(FL_MULTILINE_INPUT,19,243,414,58,"Comments:");
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
  
  fdui->reg_anonym =     
    obj = fl_add_button(FL_PUSH_BUTTON,19,310,90,20,"Anonymous");
    fl_set_button_shortcut(obj,"^A",1);

  fdui->reg_later =     
    obj = fl_add_button(FL_NORMAL_BUTTON,252,310,90,20,"Don't send");
    fl_set_button_shortcut(obj,"^L",1);

  fdui->reg_send =     
    obj = fl_add_button(FL_NORMAL_BUTTON,344,310,90,20,"Send");
    fl_set_button_shortcut(obj,"^S",1);


  fl_end_form();

/*---------------------------------------*/

  fdui->sadp_submit_form = fl_bgn_form(FL_NO_BOX, 324, 230);
  obj = fl_add_box(FL_UP_BOX,0,0,324,230,"");
    /* Title */
  obj = fl_add_text(FL_NORMAL_TEXT,17,9,35,15,"Title:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->submit_title_box = obj = fl_add_text(FL_NORMAL_TEXT,65,9,237,15,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

    /* Category and revision */
  fdui->submit_category_choice =    
    obj = fl_add_choice(FL_NORMAL_CHOICE2,71,30,74,17,"Category:");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_shortcut(obj, "^G", 1);

  fdui->submit_multiartist_box = obj = fl_add_text(FL_NORMAL_TEXT,213,32,88,15,"0");
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);

    obj = fl_add_text(FL_NORMAL_TEXT,213,51,49,15,"Revision:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  fdui->submit_revision_box = obj = fl_add_text(FL_NORMAL_TEXT,261,51,40,15,"0");
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);

    /* Check bixes */
  fdui->submit_set_category_box =
    obj = fl_add_checkbutton(FL_PUSH_BUTTON,15,51,140,15,"Set category as default");
    fl_set_object_shortcut(obj, "^F", 1);

    /* Sites */
  obj = fl_add_text(FL_NORMAL_TEXT,16,72,43,15,"Sites:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

   /* Remove site */
#if FL_INCLUDE_VERSION < 86
  obj = fl_add_button(FL_NORMAL_BUTTON,22,101,25,25,"y");
#else  
  obj = fl_add_button(FL_NORMAL_BUTTON,22,101,25,25,"@9+");
#endif
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_callback(obj, submit_form_callback, 10);
    fl_set_object_shortcut(obj, "^D^X", 0);
/*
  obj = fl_add_text(FL_NORMAL_TEXT,69,53,235,15,"Click line to select/deselect site.");
    fl_set_object_boxtype(obj,FL_EMBOSSED_BOX);
    fl_set_object_color(obj,FL_DEEPPINK,FL_MCOL);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
*/    
 fdui->submit_sites_browser = 
    obj = fl_add_browser(FL_HOLD_BROWSER,60,72,243,82,"");
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);

    /* Sender */
  obj = fl_add_text(FL_NORMAL_TEXT,18,155,43,15,"Sender:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->submit_sender_box = obj = fl_add_text(FL_NORMAL_TEXT,65,155,300,15,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

    /* Index */
  obj = fl_add_text(FL_NORMAL_TEXT,18,169,43,15,"Index:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->submit_index_box = obj = fl_add_text(FL_NORMAL_TEXT,65,169,300,15,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

    /* Disc id */
  obj = fl_add_text(FL_NORMAL_TEXT,18,183,47,15,"Disc ID:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->submit_discid_box = obj = fl_add_text(FL_NORMAL_TEXT,65,183,150,15,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

#ifdef MCN_SUPPORT
    /* Disc MCN */
  fdui->submit_mcn_label = obj = fl_add_text(FL_NORMAL_TEXT,18,197,43,15,"MCN:");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->submit_mcn_box = obj = fl_add_text(FL_NORMAL_TEXT,65,197,150,15,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
#endif

    /* Buttons */
   obj = fl_add_button(FL_NORMAL_BUTTON,162,192,50,26,"Cancel");
    fl_set_object_callback(obj, submit_form_callback, 2);
    fl_set_object_shortcut(obj, "^C", 1);

    obj = fl_add_button(FL_NORMAL_BUTTON,229,192,74,26,"SUBMIT");
    fl_set_button_shortcut(obj,"^S",1);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, submit_form_callback, 1);

/*---------------------------------------*/
  fl_end_form();

  return fdui;
}



#endif /* RCDDB_SUPPORT */
