/*  ===========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */


#include <linux/major.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <curses.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
/* #include <syslog.h> */
#include "sad.h"

#if HAVE_SYS_MMAN_H && (defined(MMAP_SUPPORT) || defined(ALSA_MMAP_SUPPORT))
#include <sys/mman.h>
# ifndef MAP_FAILED
#  define MAP_FAILED ((void *)(-1))
# endif
#endif


#if defined(MIXER_SUPPORT) || defined(DSP_SUPPORT)

#if HAVE_LINUX_SOUNDCARD_H
#include <linux/soundcard.h>
#elif HAVE_MACHINE_SOUNDCARD_H
#include <machine/soundcard.h>
#elif HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#endif

#if defined(DSP_CAP_TRIGGER) && defined(DSP_CAP_MMAP)
#define USE_MMAP_CAPS  (DSP_CAP_TRIGGER|DSP_CAP_MMAP)
#endif

#if defined(USE_MMAP_CAPS) && defined(MMAP_SUPPORT) && defined(SNDCTL_DSP_GETIPTR) && defined(_POSIX_MAPPED_FILES)
#define USE_MMAP
#define MMAP_OFFSET  0
#endif

#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
#include <linux/asound.h>
#endif

#if defined(ALSA_MIXER_SUPPORT)
#include "sadp_alsawght.h"
#endif

#if defined(ALSA_DSP_SUPPORT)

#if defined(SND_PCM_IOCTL_CAPTURE_INFO)
#   define ALSA_PCM  4
#elif defined(SND_PCM_IOCTL_CHANNEL_INFO) 
#   define ALSA_PCM  5
#   if defined(ALSA_MMAP_SUPPORT) && defined(SND_PCM_MMAP_OFFSET_CONTROL) && \
			 defined(_POSIX_MAPPED_FILES)
#         define USE_ALSA_MMAP
#   endif
#endif

#endif  /* defined(ALSA_DSP_SUPPORT) */


#ifndef AFMT_S16_NE
#  if defined(WORDS_BIGENDIAN) && defined(AFMT_S16_BE)
#     define AFMT_S16_NE AFMT_S16_BE
#  elif !defined(WORDS_BIGENDIAN) && defined(AFMT_S16_LE)
#     define AFMT_S16_NE AFMT_S16_LE
#  endif
#endif

#ifndef AFMT_U16_NE
#  if defined(WORDS_BIGENDIAN) && defined(AFMT_U16_BE)
#     define AFMT_U16_NE AFMT_U16_BE
#  elif !defined(WORDS_BIGENDIAN) && defined(AFMT_U16_LE)
#     define AFMT_U16_NE AFMT_U16_LE
#  endif
#endif


#endif  /* defined(MIXER_SUPPORT) || defined(DSP_SUPPORT) */

unsigned int stereo = 1;
unsigned short stereo_supported = 1;


/*=============================*/
/*         DSP_SUPPORT         */
#ifdef DSP_SUPPORT
int   alsa_dsp, alsa_dsp_version;
extern short  AudioSampleSize;
extern short  UseMMap;
extern u_int  SamplingRate; 
extern int    AudioDeviceNumber;
extern char   AudioDeviceName[];
#endif
/*                             */
/*=============================*/

/*=============================*/
/*        MIXER_SUPPORT        */

#define MIXER_ELEMENT_LENGTH 6
#define CDINT_DEVNO   0xffff

#ifdef MIXER_SUPPORT
int	alsa_mixer, alsa_mix_version;
int	alsa_group_count;

extern int    MixerDeviceNumber;
extern char   MixerDeviceName[];
static int mixer_accept_device(short device);
#endif

extern short  FourWndCount, FourWndMask;
extern short  BottomSection;
extern u_char volume_left, volume_right;
extern PLATFORM  Platform;

int audio = -2;				/* /dev/dsp audio file descriptor */
int mixer = -2;				/* /dev/mixer  file descriptor */

u_int mixer_node = 0;

#if defined (MIXER_SUPPORT) || defined (DSP_SUPPORT)
static char ErrMes[513];
#endif

u_int  MixerCurDevice,  MixerCurDevno;
u_int  MixerStereoMask=0, MixerCurDevMask, MixerRecsrc, MixerRecmask;
u_int  MixerDeviceCount = 0;
char   volume, balance;
char   MixerSoundDevice[MIXER_ELEMENT_LENGTH];

static int get_cdint_volume(int *vol1, int *bal1);
static void add_cdint(void);

#ifdef MIXER_SUPPORT
static char *mixer_devnames[] = SOUND_DEVICE_LABELS;
static char *mixer_devnames1[] = SOUND_DEVICE_NAMES;
/* static u_int MixerRecsrcBackup; */
#endif

#ifdef DSP_SUPPORT
unsigned int sample_size;

static CPLX *roots=NULL;
static int T, T1;

int abuf_size;					/* audio buffer size for I/O */
int bbuf_size;                                  /* current wave size */     
int nfrags=16; 					/* current wave size */     
signed char *iobuf = NULL;			/* allocated I/O buffer */
signed short *iobuf16 = NULL;			/* allocated I/O buffer */

int ft_size;
long ft_bufsize;
CPLX *ft_buffer = NULL;
short unsgn_mode, mmap_active;

#if defined(USE_MMAP) || defined(USE_ALSA_MMAP)  
static void  *mmap_data = NULL;
static int   mmap_curfrg;
static long  mmap_size;
# if defined(USE_ALSA_MMAP)  
static snd_pcm_mmap_control_t *mmap_ctrl = NULL;
# endif
#endif  /* defined(USE_MMAP) || defined(USE_ALSA_MMAP)   */

#endif  /* defined(DSP_SUPPORT) */


struct MIXER_DEVICE_INFO 
{  u_int devno;
   int volume;
   int balance;
#ifdef ALSA_MIXER_SUPPORT
   short weight;	
   snd_mixer_gid_t gid;
#endif
   char elem_name[MIXER_ELEMENT_LENGTH];
} *MixerDevPtr = NULL;

void audio_stop(void);

#if defined(DSP_SUPPORT) || defined(MIXER_SUPPORT)
#define VERSION_CODE(maj,min,rel)  (((maj) << 16) | ((min) << 8) | (rel))
extern int	osversion_code;  

#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
int  get_alsa_sound_version(char  *type_return,
				    char  *version_return)
{
	FILE *f = NULL;
	char buf[121];
	char *pos;
	int rc = 0;

	f = fopen("/proc/asound/version", "r");	
	if (f == NULL) return 0;

	if (fgets(buf, 120, f) == NULL) goto Sortie;

	pos = strstr(buf, "ersion");
	if (pos)
	{  pos += 7;
	   strtokm(pos, " \n\r");
	   strcpy(type_return, "ALSA");
	   strcpy(version_return, pos);		
	   rc = 1;
	}

Sortie:
	if (f) fclose(f);
	return rc;

}
#endif

int get_sound_version(char *type_return,
                      char *version_return,
			    char *alsa_emu_return)
{	char auxbuf[121];
	FILE *f;
	char *delim;

	type_return[0] = version_return[0] =
 			     alsa_emu_return[0] = '\0';

	f = fopen("/proc/sound", "r");

	if (f == NULL) f = fopen("/proc/asound/sndstat", "r");	

	if (f == NULL && osversion_code < VERSION_CODE(2,3,0)
                  && osversion_code > 0)
               f = fopen("/dev/sndstat", "r");
	
	if (f == NULL) goto AskDriver;
	delim = fgets(auxbuf, 120, f);
	fclose(f);
	if (delim == NULL) return 0;
	
	auxbuf[120] = '\0';
	delim = strchr(auxbuf, ':');
	if (delim == NULL) return 0;
	if ((delim - auxbuf) >= 15)  return 0;
	*delim++ = '\0';

	if (strcasecmp(auxbuf, "Sound Driver") == 0)
		strcpy(type_return, "Linux Sound");
	else
		strcpy(type_return, auxbuf);

	strtokm(delim, "(\n\r " );
	strncpy(version_return, delim, 16);

	delim = strtokm(NULL, "\n\r");
	if (delim == NULL) return 1;

	delim = strstr(delim, "ALSA");
	if (delim == NULL) return 1;	 

	delim += 5; strtokm(delim, " ");
	strncpy(alsa_emu_return, delim, 15);

	return 1;

AskDriver:
#ifdef OSS_GETVERSION
	{ int vers, v, m, r;
		int fd;
		fd = audio; if (fd < 0) fd = mixer;
		if (fd >= 0 && ioctl(fd, OSS_GETVERSION, &vers) >= 0)
		{   v = (vers >> 16) & 0xff; 
				m = (vers >> 8) & 0xff;
				r = vers & 0xff;
				sprintf (version_return, "%d.%d.%d", v, m, r);
				strcpy(type_return, "OSS compatible");
				return 1;   
		}
	}
#endif
	return 0;
}

#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
/* node - node number, type - 0 - dsp, 1 - mixer */
static int  get_alsa_device_name(const char *path, short type, short devno, char *target)
{
	char fname[121];
	int fd=-1, result, rc=4;

	snprintf(fname, 121, "%s/controlC%d", path, devno);
	target[0] = '\0';

	fd = open(fname, O_RDONLY, 0);
	if (fd < 0) return 0;

	if (type == 0)
	{  snd_pcm_info_t spi;
	   result = ioctl(fd, SND_CTL_IOCTL_PCM_INFO, &spi);
	   if (result < 0) goto Sortie;
	   strcpy(target, spi.name);
	}
	else
	{  snd_mixer_info_t smi;
	   result = ioctl(fd, SND_CTL_IOCTL_MIXER_INFO, &smi);
	   if (result < 0) goto Sortie;
	   strcpy(target, smi.name);
	}
	   	  				
	rc = 0;

Sortie:
	if (fd >= 0) close(fd);
	return rc;

}
#endif

static int get_oss_mixer_name(char *target)
{ int rc = 4;

#ifdef SOUND_MIXER_INFO
	mixer_info  mi;

	if (mixer < 0)
	{ 	strcpy(target, "Disabled");
			return rc;
	}

	if (mixer >= 0 && ioctl(mixer, SOUND_MIXER_INFO, &mi) >= 0)
	{	 strncpy(target, mi.name, 121);
	   rc = 0;
	}

	if (rc > 0)
	{	strcpy(target, "Unknown");
	  rc = 0;
	}
#endif

	return rc;
}			

static int get_oss_dsp_name(char *target)
{
		if (audio >= 0)
 	  {  strcpy(target, "Unknown");
			 return 0;
		}

		strcpy(target, "Disabled");
	  return 4;
}	                  

static int  get_oss_device_name(const char *section_name, short devno, char *target)
{	short s;
	FILE *f = NULL;
	int  rc = 4;
	char auxbuf[121], *result;

	*target = '\0';

	f = fopen("/proc/sound", "r");
	if (f == NULL) f = fopen("/proc/asound/sndstat", "r");	

	if (f == NULL && osversion_code < VERSION_CODE(2,3,0)
                         && osversion_code > 0)
			f = fopen("/dev/sndstat", "r");

	if (f == NULL) goto Sortie;
		
	s = strlen(section_name);
	while ( (result = fgets(auxbuf, 120, f)) != NULL
	        && strncmp(auxbuf, section_name, s) != 0);
	if (result == NULL) goto Sortie;

      while ((result = fgets(auxbuf, 120, f)) != NULL)
	{  if (!isdigit(*auxbuf)) goto Sortie;
        if ( devno == atoi(auxbuf)) break;
      }
	if (result == NULL) goto Sortie;

      strtokm(auxbuf, "\t\n\r");
      result = strchr(auxbuf, ':');
      if (!result) goto Sortie;

      strncpy(target, result+2, 120);
	
	rc = 0;

Sortie:
	if (f) fclose(f);
	return rc;
}

int get_audio_name(const char *file_name, const char *pattern,
				    const char *section_name,  char  *device_name,
				    short *node_no,  char  *logical_name_start,
				    char  *logical_name_end)
{
	short dn;
	char  auxbuf[121], *devname;
	int   ret_val = 0;
	int   nodn, devtype;	
	int   s;

	if (*file_name == '\0') return 0;

	logical_name_end[0] = device_name[0] = '\0';
	strcpy(logical_name_start, "** undefined **");	

	nodn = 0;	

#ifdef HAVE_ST_RDEV
	{  struct stat stat_info;
	   if ( stat(file_name, &stat_info) == 0)
                nodn = stat_info.st_rdev;
	}
#endif

	if (node_no != NULL)  *node_no = nodn; 	
 
  s = readlink(file_name, auxbuf, 120);
	if (s > 0) auxbuf[s] = '\0';
	else   strncpy(auxbuf, file_name, 120);

	devname = strrchr(auxbuf, '/');
	if (devname)
	{   *devname++ = '\0';
	    strncpy(device_name, devname, 11);
	}
  else
	{  strncpy(device_name, auxbuf, 11);
         auxbuf[0] = '\0';
	}

	devtype = nodn & 0xff; 
  nodn >>= 8;
	if (nodn == SOUND_MAJOR)
	{
		s = strlen(pattern);
		if (memcmp(device_name, pattern, s) != 0) goto Sortie;
		dn = atoi(device_name+s);

		nodn = get_oss_device_name(section_name, dn, auxbuf);

		if (nodn)
		{ if ((devtype & 15) == 0)
	 	     nodn = get_oss_mixer_name(auxbuf);			
      else
	 	     nodn = get_oss_dsp_name(auxbuf);			
    }		
	}
#if defined(ALSA_DSP_SUPPORT) || defined(ALSA_MIXER_SUPPORT)
	else
	if (nodn == 116)
	{	const char *pattern1;
		short type;

		if (strcmp(pattern, "dsp") == 0)
			{ type = 0; pattern1 = "pcmC"; }
		else
      { type = 1; pattern1 = "mixerC"; }

		s = strlen(pattern1);
		if (memcmp(device_name, pattern1, s) != 0) goto Sortie;
		dn = atoi(device_name+s);

		nodn = get_alsa_device_name(auxbuf, type, dn, auxbuf);

  	}
#endif
	else nodn = 66;
		

	if (nodn) goto Sortie;

	devname = auxbuf;
	s = strlen(devname);

	if (s > 18)
	{  memcpy(logical_name_start, devname, 18);

	   if ((dn = s-18) > 18) dn = 18;  s = 18;
	   memcpy(logical_name_end, devname+18, dn);
	}
	else
	{  memcpy(logical_name_start, devname, s);
         dn = 0;
	}

	logical_name_end[dn] = logical_name_start[s] = '\0';;

	ret_val = 1;

Sortie:
	return ret_val;
}
#endif





#ifdef DSP_SUPPORT
#if defined(ALSA_DSP_SUPPORT) && defined(ALSA_PCM)

#ifdef WORDS_BIGENDIAN
static int format_codes_signed[] = {SND_PCM_SFMT_S8, SND_PCM_SFMT_S16_BE};
/*            SND_PCM_SFMT_S24_BE, SND_PCM_SFMT_S32_BE}; */
static int format_codes_unsigned[] = {SND_PCM_SFMT_U8, SND_PCM_SFMT_U16_BE};
/*            SND_PCM_SFMT_U24_BE, SND_PCM_SFMT_U32_BE}; */
#else
static int format_codes_signed[] = {SND_PCM_SFMT_S8, SND_PCM_SFMT_S16_LE};
/*            SND_PCM_SFMT_S24_LE, SND_PCM_SFMT_S32_LE}; */
static int format_codes_unsigned[] = {SND_PCM_SFMT_U8, SND_PCM_SFMT_U16_LE};
/*            SND_PCM_SFMT_U24_LE, SND_PCM_SFMT_U32_LE}; */
#endif		    
		    
#ifdef USE_ALSA_MMAP
/* If I only a vague idea of what is going on there ... */ 
static int map_dsp_alsa(long mmap_size_needed)
{
    mmap_ctrl = (snd_pcm_mmap_control_t *)
                 mmap(NULL, sizeof(snd_pcm_mmap_control_t),
                      PROT_READ, MAP_FILE|MAP_SHARED,
		      audio, SND_PCM_MMAP_OFFSET_CONTROL);

    if (mmap_ctrl == (snd_pcm_mmap_control_t *) MAP_FAILED || 		      
             mmap_ctrl == NULL) goto BadLuck;
	
    mmap_data = mmap(NULL, mmap_size_needed,
                      PROT_READ, MAP_FILE|MAP_SHARED,
		      audio, SND_PCM_MMAP_OFFSET_DATA);
	
    if (mmap_data == (void *) MAP_FAILED || mmap_data == NULL)
    {   munmap((void *)mmap_ctrl, sizeof(snd_pcm_mmap_control_t));
	goto BadLuck;
    }	

    mmap_size = mmap_size_needed;
    mmap_curfrg = 0;
    return 1;
    

BadLuck:    
    snprintf (ErrMes, 121, "Alsa mmap error %d!", errno);
    mmap_ctrl = NULL;
    mmap_data = NULL;
    return 0;
    
}
#endif  /* USE_ALSA_MMAP */

static int init_dsp_alsa(void)
{	 
#if ALSA_PCM == 4
#define ALSA_PCM_INFO    SND_PCM_IOCTL_CAPTURE_INFO	
#define ALSA_PCM_PARAMS  SND_PCM_IOCTL_CAPTURE_PARAMS	
#define ALSA_PCM_SETUP   SND_PCM_IOCTL_CAPTURE_STATUS	
     snd_pcm_format_t  format;
     snd_pcm_capture_info_t info;
     snd_pcm_capture_params_t params;
     snd_pcm_capture_status_t setup;
#else
#define ALSA_PCM_INFO    SND_PCM_IOCTL_CHANNEL_INFO	
#define ALSA_PCM_PARAMS  SND_PCM_IOCTL_CHANNEL_PARAMS	
#define ALSA_PCM_SETUP   SND_PCM_IOCTL_CHANNEL_SETUP	
#define max_channels     max_voices
#define min_channels     min_voices
     snd_pcm_channel_info_t info;
     snd_pcm_channel_params_t params;
     snd_pcm_channel_setup_t setup;
#endif

    
     int format_code, format_mask, i;
     int channels, max_channels, pass;
/*     long fcntl_flags; */

     if (ioctl(audio, SND_PCM_IOCTL_PVERSION, &alsa_dsp_version) < 0)
             return 4;

     if (ioctl(audio, ALSA_PCM_INFO, &info) < 0)
     {   strcpy(ErrMes,"Unable to get audio capture info.");
         return 8;
     }
  
     format_mask = info.formats;  	 

     for (pass=0; pass<2; pass++)
     {
        for (i=2; i>0; i--)   /* Was i=4*/
			 {  sample_size = i<<3;
			    if (pass == 0 && sample_size > AudioSampleSize) continue;

	  		  format_code = format_codes_signed[i-1];
			    if ( format_mask & (1 << format_code))
	  		  {   unsgn_mode = 0; goto FormatOk; }	
	
		        format_code = format_codes_unsigned[i-1];
	  		    if ( format_mask & (1 << format_code))
				 		 {   unsgn_mode = 1; goto FormatOk;  }	
		  	  }

     }	   
     	      
     strcpy(ErrMes,"Unable to find appropriate sample format.");
     return 8;

FormatOk:
     stereo_supported = (info.max_channels >=2);	
     max_channels =  stereo_supported ? 2 : 1;

     channels =  stereo ? 2 : 1;
     if (channels > info.max_channels) channels = info.max_channels; 
     if (channels < info.min_channels) channels = info.min_channels; 
     stereo = (channels >= 2);
     

     if (SamplingRate < info.min_rate) SamplingRate = info.min_rate; 
     if (SamplingRate > info.max_rate) SamplingRate = info.max_rate; 

    /* Setting capture format */

#if ALSA_PCM == 4
	format.format = format_code;
	format.rate = SamplingRate;
	format.channels =  channels;
      if (ioctl(audio, SND_PCM_IOCTL_CAPTURE_FORMAT, &format) < 0)
      {   strcpy(ErrMes, "Unable to set capture format");
          return 8;
      }	 
#else
	params.format.format = format_code;
	params.format.rate = SamplingRate;
	params.format.voices =  channels;
	params.format.interleave = 1;
#endif
	            
	abuf_size = (2048*SamplingRate*(sample_size>>3)*max_channels+48000)/96000;  

	if (abuf_size > info.max_fragment_size)
                          abuf_size = info.max_fragment_size;
	if (abuf_size < info.min_fragment_size)
                          abuf_size = info.min_fragment_size;

    /* Setting capture parameters */
#if ALSA_PCM == 4
	params.fragment_size = abuf_size;
	params.fragments_min = 1;
#else
	params.mode = SND_PCM_MODE_BLOCK;
	params.buf.block.frag_size = abuf_size;
	params.buf.block.frags_min = 4;
	params.buf.block.frags_max = 16;
	
	params.start_mode = SND_PCM_START_GO;
	params.stop_mode = SND_PCM_STOP_ROLLOVER;
#endif

      if (ioctl(audio, ALSA_PCM_PARAMS, &params) < 0)
      {   strcpy(ErrMes, "Unable to set capture parameters");
         return 8;
      }	 

      mmap_active = 0;
      	
#ifdef USE_ALSA_MMAP
      if (UseMMap && (info.flags & SND_PCM_CHNINFO_MMAP) && map_dsp_alsa(info.mmap_size))
                  mmap_active = 1;
#endif              

#if ALSA_PCM != 4     
      if (ioctl(audio, SND_PCM_IOCTL_CHANNEL_PREPARE, 0) < 0) 
      {   strcpy(ErrMes, "Capture prepare command failed");
        	 return 8;
      }	 
#endif
     
      /* Now read the accepted setup */
      if (ioctl(audio, ALSA_PCM_SETUP, &setup) < 0)
      {   strcpy(ErrMes, "Unable to get capture setup");
         return 8;
      }	 

#if ALSA_PCM == 4     
      abuf_size = setup.fragment_size;
      nfrags = setup.fragments;
      SamplingRate = setup.rate;
#else
      abuf_size = setup.buf.block.frag_size;
      nfrags = setup.buf.block.frags;
      SamplingRate = setup.format.rate;
#endif


	/* Establish non-blocking mode */
/*	if ((fcntl_flags = fcntl(audio, F_GETFL))	< 0)
					return 8;
	fcntl_flags |= O_NONBLOCK;
	if (fcntl(audio, F_SETFL, fcntl_flags) < 0)
					return 8;
*/

	/* Go ! */
#if ALSA_PCM != 4
      if (ioctl(audio, SND_PCM_IOCTL_CHANNEL_GO, 0) < 0) 
      {   strcpy(ErrMes, "Capture go command failed");
         return 8;
      }	 
#endif

      return 0;

}
#endif   /* ifdef ALSA_DSP_SUPPORT */

static int init_dsp(void)
{
	int	formats;
	unsigned int tmp;

	sample_size = AudioSampleSize;
	unsgn_mode = 0;

#ifdef SNDCTL_DSP_GETFMTS
	 if (ioctl(audio, SNDCTL_DSP_GETFMTS, &formats) < 0)
/*	 {  //	openlog("SADP", LOG_NDELAY, LOG_KERN); 
	  		syslog(LOG_INFO , "Supported formats are %x", formats); 
	    //  	closelog(); 
 	 } */
#endif
	   formats = ~0;

	while (sample_size >= 8) {
	    tmp = sample_size;

#ifdef WORDS_BIGENDIAN
#	ifdef AFMT_U16_BE
      if (tmp == 16) tmp = AFMT_U16_BE;
#	endif	    
#else
#	ifdef AFMT_U16_LE
      if (tmp == 16) tmp = AFMT_U16_LE;
#	endif	    
#endif
	    if ((formats & tmp) && ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp) >= 0)
	    {   //   unsgn_mode  = (sample_size == 16) ? 1 : 0;
					 unsgn_mode = 1; 
           break;
	    }				    
		 
#ifdef AFMT_U8
	   if (sample_size == 8)    
	   {   tmp = AFMT_U8;
	       if((formats & tmp) && ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp) >= 0)
	           break;
	   }	        
#endif

#ifdef WORDS_BIGENDIAN
#	ifdef AFMT_S16_BE
	   if (sample_size == 16)    
	   {   tmp = AFMT_S16_BE;
	       if((formats & tmp) && ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp) >= 0)
	                break; 
	   }	        
# endif
#else
#	ifdef AFMT_S16_LE
	   if (sample_size == 16)    
	   {   tmp = AFMT_S16_LE;
	       if((formats & tmp) && ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp) >= 0)
	                break; 
	   }	        
# endif
#endif

		 
	   sample_size >>= 1;
	}
	
	if (sample_size < 8)  { 
		 sprintf(ErrMes,"Unable to set audio sample size.");
	   return 8;
	}

	tmp = 1;
	ioctl(audio, SNDCTL_DSP_STEREO, &tmp);
	stereo_supported = (tmp >= 1); 

	if (stereo != tmp)
	  ioctl(audio, SNDCTL_DSP_STEREO, &stereo); 

	tmp = SamplingRate;	
	if ( ioctl(audio,SNDCTL_DSP_SPEED, &tmp) < 0 ) {
		sprintf(ErrMes,"Unable to set audio sampling rate.");
		return 0;
	}
	/* Fixing a bug with i810 */
	if (tmp < 0) tmp = -tmp;
	if (tmp >= 0 && tmp <= 96000) SamplingRate = tmp;	

#ifdef SNDCTL_DSP_SETFRAGMENT
	tmp = stereo_supported ? 2 : 1;
	abuf_size = (2048*SamplingRate*(sample_size>>3)*tmp+48000)/96000;  

	if (abuf_size < 256) abuf_size = 256;
	for(tmp=0;  abuf_size>>=1; tmp++);  
	if (tmp>10) tmp = 10;

	tmp |= 0x7fff0000;
	ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &tmp);
#endif

	if ( ioctl(audio,SNDCTL_DSP_GETBLKSIZE,&abuf_size) < 0 ) {
		sprintf(ErrMes,"Obtaining dsp buffer size.");
		return 8;
	}

	{		audio_buf_info info;
			if (ioctl(audio, SNDCTL_DSP_GETISPACE, &info) < 0)
			{	 sprintf(ErrMes,"Obtaining frames count.");
				 return 8;
			}
			nfrags = info.fragstotal;
	}

	mmap_active = 0;

#if defined(USE_MMAP) && defined(DSP_CAP_MMAP)
	if (UseMMap && ioctl(audio, SNDCTL_DSP_GETCAPS, &formats) >= 0 &&
	               (formats & USE_MMAP_CAPS) == USE_MMAP_CAPS)
	{
	    mmap_size = abuf_size * nfrags;
	    mmap_data = mmap(NULL, mmap_size,
                      PROT_READ, MAP_SHARED,
				      audio, MMAP_OFFSET);
	    mmap_active = (mmap_data != MAP_FAILED) && (mmap_data != NULL);
	    
	    if(mmap_active)
	    {	int i = ~PCM_ENABLE_INPUT;
        	if (ioctl(audio, SNDCTL_DSP_SETTRIGGER, &i) < 0)
		mmap_active = 0;
		i = PCM_ENABLE_INPUT;
		if (ioctl(audio, SNDCTL_DSP_SETTRIGGER, &i) < 0)
				mmap_active = 0;
				
	    } 	
	    mmap_curfrg = 0;
	}
#endif
	return 0;
}	
static void ft_initialize(int power)
{
   CPLX   root_cur, root_prim;
   double re, im;
   int    t;

   T = 1 << power;
   T1 = T-1;

   roots = malloc(sizeof(CPLX) * T);
   roots[0].r = root_cur.r = 1;  // 256;
   roots[0].i = root_cur.i = 0;

   re = cos(2.*M_PI/T);
   root_prim.r = re;  // * 256;
   root_prim.i = -sqrt(1 - re * re);  // * 256;

   for (t=1; t<T; t++)
   {   roots[t].r = root_cur.r = ((re = root_cur.r) * root_prim.r -
                                  (im = root_cur.i) * root_prim.i);        // 256;
       roots[t].i = root_cur.i = (re * root_prim.i + im * root_prim.r);    // 256;
   }
}


void ft_process(CPLX *spectrum, CPLX signal[], int f)
{  int  t;
   CPLX *cpl;
   double re1, re2, im1, im2;     

    
   spectrum->r = 0;
   spectrum->i = 0;

   for (t = 0; t<T; t++)
   { 
      cpl = signal+t; 
      re1 = cpl->r;  im1 = cpl->i;

      cpl = roots+((f*t) & T1);	
      re2 = cpl->r;  im2 = cpl->i;

	spectrum->r += re1*re2 - im1*im2;
	spectrum->i += re1*im2 + im1*re2;
   }
}

static int dsp_reinitialize(void)
{
	static  short  first_open = 1;
	unsigned int tmp;
	int	rc1;

	if (audio == -2) return 0;
	if (audio >= 0) return 1;
	audio = -1;

	if (first_open == 0) goto NonFirst;
	
	alsa_dsp = -1;
	first_open = 0;

	if (AudioDeviceNumber == DEV_EXPLICIT)
	{   audio = open(AudioDeviceName, O_RDONLY);

#ifdef HAVE_ST_RDEV
	    if (audio>=0)
	    {   struct stat stat_info;
	        if ( fstat(audio, &stat_info) == 0)
	           alsa_dsp = (stat_info.st_rdev >> 8) == 116 ? 1: 0; 
	    }		   
#endif
	    goto AnalyseOpenAudio;
	}   	

	/* Open audio by device number */
#if defined(ALSA_DSP_SUPPORT) && defined(ALSA_PCM) 
	/* Try to open as an ALSA device */
	alsa_dsp = 1;
#if ALSA_PCM == 4
	sprintf (AudioDeviceName, "/dev/snd/pcmC%iD0", AudioDeviceNumber);
#else
	sprintf (AudioDeviceName, "/dev/snd/pcmC%iD0c", AudioDeviceNumber);
#endif
	audio =  open(AudioDeviceName, O_RDONLY, 0);
	if (audio >= 0) goto AnalyseOpenAudio;
#endif

  	/* Open as an OSS device */
	strcpy(AudioDeviceName, "/dev/dsp");
	alsa_dsp = 0;
	if (AudioDeviceNumber > 0)	
	    sprintf(AudioDeviceName+8, "%i", AudioDeviceNumber);		
	

NonFirst:	
	audio =  open(AudioDeviceName, O_RDONLY);

AnalyseOpenAudio:
	if ( audio < 0 ) {
	  int error_number = errno;
	  sprintf(ErrMes,"Error opening audio device %s:\n"
				" %s\n\n", AudioDeviceName,
				 strerror(error_number));
	  if (error_number == EACCES)
	  { 
		sprintf(ErrMes+strlen(ErrMes), "%s",  
		  "To get permissions, run, as root, 'chmod 666' "
    	  "for your DSP device, e.g.\n\n"
	  	  "        chmod 666  /dev/dsp\n");
	  }
	  else				 
	  { char *arg = (Platform == PLTF_XFORMS)? "-noadev" : "-A*";
		sprintf(ErrMes+strlen(ErrMes), "Use %s command line argument "
		  "to disable audio support.\n", 
				arg);
	  }		
	  return 0;
	}


#ifdef ALSA_DSP_SUPPORT
	if (alsa_dsp)
	{ 
		rc1 = init_dsp_alsa();
		if (rc1>4 || (rc1 != 0 && alsa_dsp > 0))
						return 0;
	}
	else
#endif
	{	
		rc1 = init_dsp();
		if (rc1 > 0) return 0;
	}	

	ft_size= 0; tmp = abuf_size;
	if (sample_size > 8) tmp >>= 1;
	while (tmp >>= 1) ft_size++;
	if (ft_size > 10) ft_size = 10;
	if (stereo) ft_size--;

  return 1;
}
#endif

#ifdef MIXER_SUPPORT
static const char *MaskError = "Error setting mixer device masks\n";
static const char *ReadError = "Error reading mixer settings\n";
static const char *WriteError = "Error changing mixer settings\n";
static const char *NoMem = "Mixer: memory allocation failure\n";

#ifdef ALSA_MIXER_SUPPORT
static const char *GroupError = "Error setting ALSA mixer groups\n";

static int alsamix_compare_weights(const void *first, const void *second)
{
	return (int) ( ((struct MIXER_DEVICE_INFO *)first)->weight -
                     ((struct MIXER_DEVICE_INFO *)second)->weight );
}

static int init_mixer_alsa(void)
{
	int rc = 8;
	snd_mixer_groups_t groups;
	snd_mixer_group_t group;
	snd_mixer_gid_t   *gids=NULL, *gid;
	int  i;
	unsigned int mask, stereo_flag;
	int  vol, bal, minvol, maxvol;

	char *weight_devname, *gid_devname;	
	mixer_weight_entry *mwe;


	/* Get version - fails for non-alpha device */
	if (ioctl(mixer, SND_MIXER_IOCTL_PVERSION, &alsa_mix_version) < 0 ||
	       (alsa_mix_version & ~0xffffff) != 0)
	{ rc = 4; goto errxit; }

  /* Get number of groups */
	memset(&groups, '\0',  sizeof(groups));	/* Cleaning counters and pointer */
	if (ioctl(mixer, SND_MIXER_IOCTL_GROUPS, &groups) < 0)
	{    strcpy(ErrMes, GroupError); 
 	    goto errxit;
	}

	alsa_group_count = groups.groups_over;
			
  /* Allocate storage for of group ids */
	groups.pgroups = gids = (snd_mixer_gid_t *)
                       malloc(alsa_group_count * sizeof(snd_mixer_gid_t));

	if (!gids) 
	{   strcpy(ErrMes, NoMem);
 	    goto errxit;
	}

	/* Read group ids */
	groups.groups_size = alsa_group_count;
	groups.groups_over = groups.groups = 0;
	if (ioctl(mixer, SND_MIXER_IOCTL_GROUPS, &groups) < 0)
	{   strcpy(ErrMes, GroupError);
 	     goto errxit;
	}

	MixerDevPtr = realloc(MixerDevPtr, (alsa_group_count+1) *
 			           sizeof(struct MIXER_DEVICE_INFO));
	if (!MixerDevPtr) 
	{   strcpy(ErrMes, NoMem);
 	    goto errxit;
	}

	/* Now read device information */
	for (i=0, mask=1; i<alsa_group_count; i++, mask <<= 1)
	{			
		memset(&group, '\0',  sizeof(group));
		gid = gids+i;
		memcpy( &(group.gid), gid, sizeof(snd_mixer_gid_t));
		if (ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group) < 0)
		{	strcpy(ErrMes, ReadError);
			goto errxit;
		}

		if (group.channels== 0 ||
		    (group.caps & SND_MIXER_GRPCAP_VOLUME) == 0) 
						continue;
		
		MixerDevPtr[MixerDeviceCount].devno = i;         

		if (group.caps & SND_MIXER_GRPCAP_CAPTURE) 
		{ 
		    
				MixerRecmask |= mask;
		    if (strcmp(gid->name, SND_MIXER_IN_CD) == 0 &&
                     group.capture != group.channels)
		    {  // Activate CD capture //
				  group.capture = group.channels;
		      if(ioctl(mixer, SND_MIXER_IOCTL_GROUP_WRITE, &group) < 0)
		   	  {	strcpy(ErrMes, WriteError);
						goto errxit;
	 			  }
		      if(ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group) < 0)
		   	  {	strcpy(ErrMes, ReadError);
						goto errxit;
	 			  }
		    }		

		    if (group.capture & 3) MixerRecsrc |= mask;

		}
 		
		stereo_flag = group.channels & 2;
		if (stereo_flag)  MixerStereoMask |= mask;

		minvol = group.min;
		maxvol = group.max - minvol;	 
	      vol =    (group.volume.names.front_left - minvol) * MAX_VOLUME / maxvol;
            
		if (!stereo_flag || vol == 0)
	         bal = MAX_BALANCE/2;
	  else		
	  {	
	     int volr =  (group.volume.names.front_right - minvol) * MAX_VOLUME /maxvol;
	     bal = volr * MAX_BALANCE / (vol + volr);
		   if (volr > vol) vol = volr;
	  } 
	   	
		if (vol > MAX_VOLUME) vol = MAX_VOLUME;
		memcpy(&(MixerDevPtr[MixerDeviceCount].gid), gid,
                                   sizeof(snd_mixer_gid_t));		
		MixerDevPtr[MixerDeviceCount].balance = bal;
		MixerDevPtr[MixerDeviceCount].volume = vol;

		/* try to find weight entry */
		mwe = alsamix_weights;
		gid_devname = gid->name;
		while ((weight_devname = mwe->name) &&
			strcmp(weight_devname, gid_devname)) mwe++;
			
		if (weight_devname)
		{  MixerDevPtr[MixerDeviceCount].weight = mwe->weight;
		   strcpy(MixerDevPtr[MixerDeviceCount].elem_name,
				   mwe->short_name);
	  }
		else
		{  MixerDevPtr[MixerDeviceCount].weight = 0;
		   strncpy(MixerDevPtr[MixerDeviceCount].elem_name,
				 gid_devname,  MIXER_ELEMENT_LENGTH);
			 *(MixerDevPtr[MixerDeviceCount].elem_name+MIXER_ELEMENT_LENGTH-1) = '\0';
		}

	  MixerDeviceCount++;
	}

	free(gids); gids = NULL;

	/* Sort by weight */
	qsort(MixerDevPtr, MixerDeviceCount, sizeof(struct MIXER_DEVICE_INFO),
				 alsamix_compare_weights);	   		   
	
	rc = 0;

errxit:
	if (gids) free(gids);
	return rc;	

}

static int requery_mixer_alsa(void)
{	
  int i, alsa_devno;
  unsigned int stereo_flag;
  snd_mixer_group_t group;
  int  vol, bal, minvol, maxvol;
  struct MIXER_DEVICE_INFO *minf;

  
#ifdef SND_MIXER_READ_REBUILD
  { 
	snd_mixer_read_t	r;
	int	result, need_update = 0;
  
    while ((result = read(mixer, &r, sizeof(r))) > 0) {
	  if (result != sizeof(r)) return 8;
	  need_update = 1;
    }  	

	if (need_update==0) return 0;
  }	
#endif

  MixerRecsrc = 0;

  for (i=0; i<MixerDeviceCount; i++)
  {			
	minf = MixerDevPtr+i;
	alsa_devno = minf->devno;

	if (alsa_devno == CDINT_DEVNO) 
		get_cdint_volume(&vol, &bal);
	else {
	  memset(&group, '\0', sizeof(group));
	  group.gid = minf->gid;
	  if (ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group) < 0) continue;

	  if (group.caps & SND_MIXER_GRPCAP_CAPTURE)  { 
		if (strcmp(group.gid.name, SND_MIXER_IN_CD) == 0 &&
                     group.capture != group.channels)  {
		  // Activate CD capture //
		  group.capture = group.channels;
		  ioctl(mixer, SND_MIXER_IOCTL_GROUP_WRITE, &group);
		  // Fixing a bug in some ALSA releases //
		  ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group);
		}		
		if (group.capture & 3) MixerRecsrc |= (1 << alsa_devno);
	  }
 	
	  minvol = group.min;
	  maxvol = group.max - minvol;	 
	  vol = (group.volume.names.front_left - minvol) * MAX_VOLUME / maxvol;
            
	  stereo_flag = group.channels & 2;
	  if (!stereo_flag || vol == 0)
		bal = MAX_BALANCE/2;
	  else {	
		int volr =  (group.volume.names.front_right - minvol) * MAX_VOLUME /maxvol;
		bal = volr * MAX_BALANCE / (vol + volr);
		if (volr > vol) vol = volr;
	  } 
	  if (vol > MAX_VOLUME) vol = MAX_VOLUME;
	}
		
    minf->balance = bal;
	minf->volume = vol;
		
  }

  return 0;
}


#endif

static int init_mixer_oss(void) { 
  u_int mixer_devmask, mask; 
  char *ptr;
  int  vol, bal;
  int rc = 4;
  u_int i;	

  if (ioctl(mixer, SOUND_MIXER_READ_DEVMASK, &mixer_devmask) == -1 ||
	ioctl(mixer, SOUND_MIXER_READ_STEREODEVS, &MixerStereoMask) == -1 ||
    ioctl(mixer, SOUND_MIXER_READ_RECMASK, &MixerRecmask) == -1 ||
    ioctl(mixer, SOUND_MIXER_READ_RECSRC, &MixerRecsrc) == -1) { 
	strcpy(ErrMes, MaskError);
	goto errxit;
  }			 

  if ((MixerRecmask & SOUND_MASK_CD) && !(MixerRecsrc & SOUND_MASK_CD)) { 
/*	   MixerRecsrcBackup = MixerRecsrc;   */
	MixerRecsrc |= SOUND_MASK_CD;
	if (ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &MixerRecsrc) == -1 ) {
	  strcpy(ErrMes, WriteError);
      goto errxit;
	}
	/* Patching ALSA OSS emulation bug */
	ioctl(mixer, SOUND_MIXER_READ_RECSRC, &MixerRecsrc); 
  }

  MixerDevPtr = malloc((SOUND_MIXER_NRDEVICES +1) *
							 sizeof(struct MIXER_DEVICE_INFO));
  if (!MixerDevPtr) {
  	strcpy(ErrMes, NoMem);
	goto errxit;
  }
  strcpy(ErrMes, ReadError);

  for (i=0, mask=1; i< SOUND_MIXER_NRDEVICES; i++, mask<<=1) {
	if (!(mixer_devmask & mask)) continue;
	MixerDevPtr[MixerDeviceCount].devno = i;         
  	
	if (ioctl(mixer, MIXER_READ(i), &vol) == -1)
	  goto errxit;
             
	if (!(MixerStereoMask & mask) || vol == 0) {
	  bal = MAX_BALANCE/2;
	  vol &= 0xff;
	} else {	
	  int volr = vol >> 8;
      vol &= 0xff;
	  bal = volr * MAX_BALANCE / (vol + volr);
	  if (volr > vol) vol = volr;
	}
	   	
	if (vol > MAX_VOLUME) vol = MAX_VOLUME;
  	MixerDevPtr[MixerDeviceCount].balance = bal;
	MixerDevPtr[MixerDeviceCount].volume = vol;

	/* Define mixer device name */
	ptr = mixer_devnames[i];
	if (strlen(ptr) >= MIXER_ELEMENT_LENGTH)
	  ptr = mixer_devnames1[i];
   
	memcpy(MixerSoundDevice, ptr, MIXER_ELEMENT_LENGTH-1);
	MixerSoundDevice[MIXER_ELEMENT_LENGTH-1] = '\0';
	trim(MixerSoundDevice);
	*MixerSoundDevice = toupper(*MixerSoundDevice);
	strcpy(MixerDevPtr[MixerDeviceCount].elem_name, MixerSoundDevice);

	MixerDeviceCount++;
  }

  rc = 0;

errxit:
  return rc;	
}

static int requery_mixer_oss(void)
{
  u_int mask;
  int  vol, bal;
  u_int i, oss_devno;	

  ioctl(mixer, SOUND_MIXER_READ_RECSRC, &MixerRecsrc);

  if ((MixerRecmask & SOUND_MASK_CD) && !(MixerRecsrc & SOUND_MASK_CD))	{ 
	MixerRecsrc |= SOUND_MASK_CD;
	ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &MixerRecsrc);

	/* Patching ALSA OSS emulation bug */
	ioctl(mixer, SOUND_MIXER_READ_RECSRC, &MixerRecsrc); 
  }

  for (i=0; i< MixerDeviceCount; i++) {
	oss_devno = MixerDevPtr[i].devno;         
	if (oss_devno == CDINT_DEVNO) 
	  get_cdint_volume(&vol, &bal);
	else {	
	  mask = 1 << oss_devno;
	  if (ioctl(mixer, MIXER_READ(oss_devno), &vol) == -1)
		continue;
		
      if (!(MixerStereoMask & mask) || vol == 0) {
		bal = MAX_BALANCE/2;
	  	vol &= 0xff;
	  }  else {
		int volr = vol >> 8;
		vol &= 0xff;
		bal = volr * MAX_BALANCE / (vol + volr);
		if (volr > vol) vol = volr;
	  }
	  if (vol > MAX_VOLUME) vol = MAX_VOLUME;
	}
	MixerDevPtr[i].balance = bal;
	MixerDevPtr[i].volume = vol;
  }

  return 0;
}

int requery_mixer(void)
{
  int rc;
  static int busy = 0;
  

  if (mixer < 0 || busy) return 8;

  busy = 1;
	
#ifdef ALSA_MIXER_SUPPORT
  if(alsa_mixer)
	rc = requery_mixer_alsa();
  else
#endif
	rc = requery_mixer_oss();


  if (rc == 0)
	rc = mixer_accept_device(	MixerCurDevice);

  busy = 0;
  return rc;

}
#endif

static int get_cdint_volume(int *vol1, int *bal1)
{
	int  vol, bal;
	vol = cd_getvolume();

	if (!vol && !MixerDeviceCount)
  { vol = 1;  volume_right = volume_left = 0; }
      
  if (vol)
  {   u_int volume_total;
	
	    bal = 128;
	    volume_total = (u_int) volume_right + (u_int)volume_left;        

	    if (volume_total)
	         bal = (u_int)volume_right * MAX_BALANCE / volume_total;
		
	    vol = (volume_right > volume_left) ? volume_right : volume_left;

	    vol = vol * MAX_VOLUME / 255;
	
	    if (vol > MAX_VOLUME) vol = MAX_VOLUME;
			*vol1 = vol; *bal1 = bal;
			return 0;
	}
	return 4;
}

static void add_cdint(void)
{
  int vol, bal;	
  
  if (get_cdint_volume(&vol, &bal) == 0)
  { if (!MixerDevPtr)	
   	MixerDevPtr = malloc(sizeof(struct MIXER_DEVICE_INFO));
	strcpy(MixerDevPtr[MixerDeviceCount].elem_name, "CDInt");
	MixerDevPtr[MixerDeviceCount].devno = CDINT_DEVNO;
  	MixerDevPtr[MixerDeviceCount].balance = bal;
	MixerDevPtr[MixerDeviceCount].volume = vol;
	MixerDeviceCount++;
  } 
}  

static int mixer_initialize(void)
{
	int rc = 0;

	MixerDeviceCount = 0;

#ifdef MIXER_SUPPORT
	alsa_mixer = -1;
	mixer = -1;
	MixerStereoMask = 0;
	MixerRecmask = 0;
	MixerRecsrc = 0;

	if (MixerDeviceNumber == DEV_NODEV)
	{   MixerDeviceName[0] = '\0';
            goto InitIntCD;
	}

	if (MixerDeviceNumber == DEV_EXPLICIT)
	{   mixer = open(MixerDeviceName, O_RDWR);
#ifdef HAVE_ST_RDEV
	    if (mixer>=0)
	    {   struct stat stat_info;
	        if ( fstat(mixer, &stat_info) == 0)
	           alsa_mixer = (stat_info.st_rdev >> 8) == 116 ? 1: 0; 
	    }		   
#endif
	    goto AnalyseOpenMixer;
	}

	/* Open mixer by device number */
#ifdef ALSA_MIXER_SUPPORT
	/* Try to open as an ALSA device */
	sprintf (MixerDeviceName, "/dev/snd/mixerC%iD0", MixerDeviceNumber);
	mixer =  open(MixerDeviceName, O_RDWR);
	alsa_mixer = 1;
	if (mixer >= 0) goto AnalyseOpenMixer;
#endif

  	/* Open as an OSS device */
      strcpy(MixerDeviceName, "/dev/mixer");
	if (MixerDeviceNumber > 0)	
	    sprintf(MixerDeviceName+10, "%i", MixerDeviceNumber);		
	mixer =  open(MixerDeviceName, O_RDWR);
	alsa_mixer = 0;

AnalyseOpenMixer:
	if (mixer < 0) 
#ifdef DSP_SUPPORT
	{
	   int error_number = errno;
	   if (AudioDeviceName == NULL)  goto InitIntCD;

	   sprintf(ErrMes,"Error opening mixer device %s\n"
		 	  "Message: %s.\n\n", MixerDeviceName,
	 		   strerror(error_number));
      	   if (error_number == EACCES)
  	   {   sprintf(ErrMes+strlen(ErrMes), "%s", 
	       "To get permissions, run, as root, 'chmod 666' "
    	       "for your mixer device, e.g.\n\n"
	         "\t\tchmod 666  /dev/mixer\n");
  	   }
 	   else				 
	   {   char *arg = (Platform == PLTF_XFORMS)? "-nomdev" : "-M*";
	       sprintf(ErrMes+strlen(ErrMes), "Use %s command line argument "
				"to disable mixer support.\n",  arg);
	   }		
	  
	   goto errxit;
	}
#else
	   goto InitIntCD;
#endif


#ifdef ALSA_MIXER_SUPPORT
	if (alsa_mixer)
  	{  int rc1;
	    rc1 = init_mixer_alsa();
	   if (rc1 == 0) goto InitIntCD;
	   if (alsa_mixer > 0 || rc1 > 4) goto errxit;
	}
#endif
	alsa_mixer = 0;
	if(init_mixer_oss()) goto errxit;

InitIntCD:	
#ifdef HAVE_ST_RDEV
    if (mixer >= 0)
    {
       struct stat stat_info;
       if ( fstat(mixer, &stat_info) == 0 )
               mixer_node = stat_info.st_rdev;
    }	       
#endif /* defined (HAVE_ST_RTDEV) */


#endif   /* defined (MIXER_SUPPORT) */
	add_cdint();

  	if (MixerDeviceCount > 0)
    {  MixerDevPtr = realloc(MixerDevPtr,
			     MixerDeviceCount * sizeof(struct MIXER_DEVICE_INFO));	
       rc = 1;
    }
    else
    if (MixerDevPtr)
    {  free(MixerDevPtr);
       MixerDevPtr = NULL;
    } 

    return rc;
#ifdef MIXER_SUPPORT
errxit:
	  show_error_message(ErrMes);
      return rc;
#endif

}

int audio_reinitialize(void)
{    int ret = 1;

#ifdef DSP_SUPPORT
    if (audio < 0) ret = dsp_reinitialize();
#endif

    return ret;
}

int sound_initialize(void) {



#ifdef DSP_SUPPORT
	if (AudioDeviceNumber == DEV_NODEV)
	{	FourWndCount = 0;
	 	AudioDeviceName[0] = '\0';
	}		    
	else
	{
		int buflen;

		audio = -1;
		iobuf = NULL;
		stereo_supported = stereo = (FourWndCount >= 2) ? 1: 0;
		if (!dsp_reinitialize()) goto errxit;

		FourWndCount = stereo ? 2: 1;

		if (mmap_active == 0)
		{ 
		   if ( (iobuf = malloc(abuf_size)) == NULL )
		   {  sprintf(ErrMes,"Unable to allocate audio buffer.");
		       goto errxit;
		   }
			
		   iobuf16 = (signed short *)iobuf;
		}			

		ft_initialize(ft_size);
		ft_bufsize = 1 << ft_size;
		if (sample_size > 8) ft_bufsize <<= 1;
		buflen = ft_bufsize;
	   	if (stereo_supported) buflen <<= 1;
		ft_buffer = malloc( buflen * sizeof(CPLX));
	}
#endif

	return mixer_initialize();


#if defined(DSP_SUPPORT)
errxit:
	show_error_message(ErrMes);
	sound_terminate();
	return 0;
#endif

}

static int mixer_accept_device(short device)
{ 

	MixerCurDevice = device;
	MixerCurDevno = MixerDevPtr[device].devno;

	if (MixerCurDevno == CDINT_DEVNO)
		MixerCurDevMask = 0;
	else
		MixerCurDevMask = 1 << MixerCurDevno;

	strcpy(MixerSoundDevice, MixerDevPtr[device].elem_name);

	volume  = MixerDevPtr[device].volume;
	balance = MixerDevPtr[device].balance;

	show_volume();
	show_mixer_input();
	show_mixer_device();
	return 0;
}

int mixer_accept_next_device(void)
{  	char newdev;

	if (MixerCurDevice == CDINT_DEVNO) return 1;
	newdev = MixerCurDevice + 1;
	if (newdev >= MixerDeviceCount) newdev = 0;
 
	return mixer_accept_device(newdev);
} 	   

int mixer_accept_prev_device(void)
{  	char newdev;

	if (MixerCurDevice == CDINT_DEVNO) return 1;
	newdev = MixerCurDevice - 1;
	if (newdev < 0 ) newdev = MixerDeviceCount - 1;
 
	return mixer_accept_device(newdev);
} 	   


	/*****************************************************
	 * Volume
	 *****************************************************/

short mixer_set_device_volume(short device, u_int new_volume, u_int new_balance)
{   
    u_int vol, volr;
    short success = 0;
    int   devno = 0;  

    if (MixerDeviceCount == 0) return success;	
    if (new_volume > MAX_VOLUME) new_volume = MAX_VOLUME;	

    device &= 0xff;
    
    if (device >= MixerDeviceCount) return success;
    
    devno = MixerDevPtr[device].devno;
    if (devno != CDINT_DEVNO)
    {
        if ((MixerStereoMask & (1<<devno))==0) new_balance = MAX_BALANCE/2;
    }	

    if (new_balance > MAX_BALANCE) new_balance =  MAX_BALANCE;	

    if (new_balance < 50)
    {    vol = new_volume;
			 volr = (new_balance * new_volume) / (MAX_BALANCE - new_balance);
    }
    else
    {   volr = new_volume;
				vol = (MAX_BALANCE - new_balance) * new_volume / new_balance;
    }			

    if (devno == CDINT_DEVNO)
    {   vol = vol * 255 /MAX_VOLUME;
			  volr = volr * 255 /MAX_VOLUME;
			  if (vol > 255) vol = 255; 
			  if (volr > 255) volr = 255; 
	  		success = cd_setvolume(vol, volr);
    } 	 
#ifdef MIXER_SUPPORT
#ifdef ALSA_MIXER_SUPPORT
    else
    if (alsa_mixer)
    {	snd_mixer_group_t group;

			memset(&group, '\0',  sizeof(group));
			memcpy(&(group.gid), &(MixerDevPtr[device].gid), 
		             sizeof(snd_mixer_gid_t));
			success = (ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group) >= 0);
			if (success) 
			{	int minvol, maxvol;
	
				minvol = group.min;
				maxvol = group.max - minvol;	 
				vol = vol * maxvol/MAX_VOLUME;
				if (vol>maxvol) vol = maxvol;
				group.volume.names.front_left =  vol + minvol;

				vol = volr * maxvol/MAX_VOLUME;
				if (vol>maxvol) vol = maxvol;
				group.volume.names.front_right =  vol + minvol;
				success = (ioctl(mixer, SND_MIXER_IOCTL_GROUP_WRITE, &group) >= 0);
			} 

    }				
#endif
    else		
    {   vol |= (volr << 8);


        success = ( ioctl(mixer, MIXER_WRITE(devno), &vol) != -1);
    }
#endif

    if (success)
    {  MixerDevPtr[device].volume = volume = new_volume;
       MixerDevPtr[device].balance = balance = new_balance;
    }
   
   return success;	    
}

void mixer_setvolume(u_int new_volume, u_int new_balance)
{
    if (mixer_set_device_volume(MixerCurDevice, new_volume, new_balance))
	    show_volume();	

}

int mixer_set_volumes(dev_t rtdev, int devices, u_int *volumes, u_int *balances)
{

    short device;
    
    if (mixer < 0) return 0;
    
#ifdef HAVE_ST_RDEV
    {  struct stat stat_info;
       if ( fstat(mixer, &stat_info) == 0 &&
                 stat_info.st_rdev != rtdev) return 0;
    }
#endif

    if (devices > MixerDeviceCount) devices = MixerDeviceCount;
    
    for (device = 0; device < devices; device++)
		mixer_set_device_volume(device, volumes[device], balances[device]);

    return 1;
}


int mixer_get_volumes(u_int *volumes, u_int *balances)
{

    short device;
    
    if (MixerDeviceCount == 0) return 0;	

    for (device = 0; device < MixerDeviceCount; device++)
    {
			volumes[device] = MixerDevPtr[device].volume;
			balances[device] = MixerDevPtr[device].balance;
    }

    return 1;
}



void mixer_changevolume(int volume_inc, int balance_inc)
{  

	int new_volume, new_balance;

  if (MixerDeviceCount == 0) return;	
	new_volume  = (int)volume + volume_inc;
  new_balance = (int)balance + balance_inc; 

  if (new_volume < 0) new_volume = 0;	
  if (new_balance < 0) new_balance = 0;	
   	
  mixer_setvolume((u_int) new_volume, (u_int) new_balance);
}

void mixer_toggleinput(void)
{    

#ifdef MIXER_SUPPORT
	u_int temp; 
	short success;

	if (mixer < 0 || !(MixerRecmask & MixerCurDevMask)) return;

      temp = MixerRecsrc ^ MixerCurDevMask;

#ifdef ALSA_MIXER_SUPPORT
    if (alsa_mixer)
    {	
			snd_mixer_group_t group;

		  memset(&group, '\0',  sizeof(group));
		  memcpy(&(group.gid), &(MixerDevPtr[MixerCurDevice].gid), 
		              sizeof(snd_mixer_gid_t));
	  	success = (ioctl(mixer, SND_MIXER_IOCTL_GROUP_READ, &group) >= 0);
		  if (success) 
		  {	if (temp & MixerCurDevMask)
					group.capture = group.channels;
				else
					group.capture = 0;

				success = (ioctl(mixer, SND_MIXER_IOCTL_GROUP_WRITE, &group) >= 0);
			}	 

	}				
	else	
#endif
	{ 
         success = (ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &temp) != -1);
	   /* Patching ALSA OSS emulation bug */
	   if (success) ioctl(mixer, SOUND_MIXER_READ_RECSRC, &temp);
	}

	if (success)
	{  MixerRecsrc = temp;
 	   show_mixer_input();
	}
#else
	;
#endif
}   

void mixer_deinitialize(void)
{       
    if (MixerDevPtr) free(MixerDevPtr);
    MixerDevPtr = NULL;

    if (mixer >=0) 
    { /*
         if (MixerRecmask & SOUND_MASK_CD) 
            ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &MixerRecsrcBackup);
      */
         close(mixer);
         mixer = -1;	
    }
}




int sound_start(void)
{ 
	
   if (MixerDeviceCount > 0)
  	 return  mixer_accept_device(0) == 0 ? 1: 0;

   MixerCurDevice = -1;	
   return 1;
}

	/*****************************************************
	 * Record :
	 *****************************************************/

void sound_process(void)
{	

#ifdef DSP_SUPPORT
      int i, j;
      int signal;
      
      int increm;

      bbuf_size = 0;

      if (audio < 0 || BottomSection > 1) return;

#ifdef ALSA_DSP_SUPPORT
#ifdef USE_ALSA_MMAP
      if (mmap_active && alsa_dsp > 0)
      {	
		i = (mmap_ctrl->status).frag_io;
	  
		if(mmap_curfrg == i) return;

	  	  bbuf_size = (mmap_ctrl->status).frag_size; 			 
		  iobuf =  mmap_ctrl->fragments[mmap_curfrg].addr + mmap_data;
		  iobuf16 = (signed short *) iobuf;
		  mmap_curfrg = i;

      }
      else
#endif /* def  USE_ALSA_MMAP */
      if (alsa_dsp)
      { 
		    bbuf_size = read(audio, iobuf, abuf_size);
		    if (bbuf_size <= 0) return;
      }	    	    		       
           
      else
#endif /* def  ALSA_DSP_SUPPORT */
#ifdef USE_MMAP
      if (mmap_active && alsa_dsp <= 0)
      {	count_info ci;

				if (ioctl(audio, SNDCTL_DSP_GETIPTR, &ci) >= 0)
				{	 	if (ci.blocks <= 0) return;
						iobuf = mmap_data + mmap_curfrg;  
						iobuf16 = (signed short *) iobuf;
						bbuf_size = abuf_size;	
				 	 	mmap_curfrg = (ci.ptr / abuf_size) * abuf_size; 
				}
      }
		  else
#endif			
      {    audio_buf_info info;
           ioctl(audio, SNDCTL_DSP_GETISPACE, &info);

           i= info.fragments+1;
           bbuf_size = 0;
					 if (i==0) return;	
	
				   while (--i >= 0) 
           {
	    		   if ( (j = read(audio,iobuf,abuf_size)) <= 0 ) break;
			       bbuf_size = j;		       
           }
				 	 if (bbuf_size <= 0) return;
	   
       }	 

       if (sample_size > 8) bbuf_size >>= 1;	

       if (BottomSection == 1)
       {
           draw_wave();   
           return;
       }	   

      if (ft_buffer == NULL) return;
      increm  = (stereo+1);	

      for (i=j=0; i<bbuf_size; i+=increm, j++) 
      {   

        if (FourWndMask & 1)
        {
		  if (sample_size == 8)
		  {  if(unsgn_mode) 
				  signal = ( ((int)iobuf[i] & 0xff) - 0x80) << 5; 
	    	   else
		          signal = (int)iobuf[i] << 5; 
	      }		  
    	  else
		  {  if(unsgn_mode) 
	    	    signal = ((int)iobuf16[i] & 0xffff) - 0x8000;
	      	  else		  
	        	signal = (int)iobuf16[i]; 
		  }		  
	 		    		   
          if (j < ft_bufsize)
          {  ft_buffer[j].r = signal;
             ft_buffer[j].i = 0; /* signal1; */
          }
		/*	volume[0] += signal; */
	  }

      if (FourWndMask & 2)
      {
	 
	    if (sample_size == 8)
	    { if(unsgn_mode) 
	           signal = ( ((int)iobuf[i+1] & 0xff) - 0x80) << 5; 
	        else
	           signal = (int)iobuf[i+1] << 5; 
	    }		  
        else
	    { if(unsgn_mode) 
	           signal = ((int)iobuf16[i+1] & 0xffff) - 0x4000;
	        else		  
	           signal = (int)iobuf16[i+1]; 
	    }		  

		if (j < ft_bufsize) 
        {  ft_buffer[j+ft_bufsize].r = signal;
	       ft_buffer[j+ft_bufsize].i = 0; // signal1;
	    }
		/* volume[1] += signal; */
	  }
  }


/*
#ifdef ALSA_DSP_SUPPORT
	if (alsa_dsp)
		ioctl(audio, SND_PCM_IOCTL_FLUSH_CAPTURE, 0);
#endif
*/

	
     draw_spectrum();   

#endif
    return;
}	


void audio_stop(void)
{
#ifdef DSP_SUPPORT
   if (audio >=0
#ifdef ALSA_DSP_SUPPORT
        && alsa_dsp==0 
#endif
	&& mmap_active==0
		) 
    {  int i, sz;

       ioctl(audio, SNDCTL_DSP_RESET, 0); 
       close(audio);
       sz = ft_bufsize;
       if (stereo) sz <<= 1;
       for (i=0; i<sz; i++)
       { ft_buffer[i].r = 0;
         ft_buffer[i].i = 0;
       }		
       if (BottomSection == 0)
	   draw_spectrum(); 	 
       else
       if (BottomSection == 1)
	   draw_wave(); 	 
           audio = -1;
    }
#endif
    return;	
}


	   


	/*************************************************************
	 * Exit :
	 *************************************************************/
void sound_terminate(void)
{	
#ifdef DSP_SUPPORT
	BottomSection = -1;
	audio_stop();
	if (audio >= 0)
	{  close(audio); audio = -1; }
	
	if(roots) free(roots);  
	roots = NULL;
	if (ft_buffer) free(ft_buffer);
  ft_buffer = NULL;
	
	
#if defined(USE_MMAP) || defined(USE_ALSA_MMAP)
	if (mmap_active)	
	{
			munmap(mmap_data, mmap_size);
	  	mmap_data = NULL;
#  ifdef  USE_ALSA_MMAP
		  if (mmap_ctrl)
		  {   munmap((void *)mmap_ctrl, sizeof(snd_pcm_mmap_control_t));
		  	  mmap_ctrl = NULL;
			}	    
#  endif
	}		
	else
#endif  /*  defined(USE_MMAP) || defined(USE_ALSA_MMAP) */
	if (iobuf) free(iobuf);
	iobuf = NULL;
#endif

#ifdef MIXER_SUPPORT
      if (mixer >=0) mixer_deinitialize();
#endif	
	return;
}



