 /* ========================================================== 
    SING - ALONG DISK PLAYER. 
    (C) 1998 - 2000   Michael Glickman  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
 
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <sys/time.h>
#include <forms.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <linux/cdrom.h>
#include <math.h>
#include "sad.h"
#include "sadp_xforms.h"

#if FL_INCLUDE_VERSION < 88
#define  fl_get_focus_object(frm) (frm)->focusobj    
#endif

#if defined(CHANGER_SUPPORT) && defined(CDROM_CHANGER_NSLOTS) && defined(CDROM_SELECT_DISC)
#define USE_CHANGER 1
#endif

enum OPER_SETTINGS
{   SET_BARWIDTH,
    SET_INTERLACE, 
    SET_GAIN, 
    SET_SPECTRUM_DISPLAY,
    SET_PIXELWIDTH,
    SET_PIXELHEIGHT,
    SET_VSCALE,
    SET_OBTURATE,
    SET_STEREO
};    		



typedef struct {
	FL_FORM	  *mainFrm;
	FL_OBJECT *bkgr_box;
	FL_OBJECT *track_name;
	FL_OBJECT *time_label[2];
	FL_OBJECT *time_current_box[2];
	FL_OBJECT *time_total_box[2];
	FL_OBJECT *progress_bar[2];
	FL_OBJECT *obj_digit[2];
	FL_OBJECT *vol_dial, *bal_dial;
	FL_OBJECT *mixer_sound_device;
	FL_OBJECT *mixer_input_switch;
	FL_OBJECT *cd_status_box;
	FL_OBJECT *first_track_box; 
	FL_OBJECT *last_track_box; 
	FL_OBJECT *time_disp_btn;
	FL_OBJECT *play_mode_btn; 
	FL_OBJECT *auto_play_btn; 
	FL_OBJECT *loop_play_btn; 

	FL_OBJECT *play_btn; 
	FL_OBJECT *prev_btn; 
	FL_OBJECT *stop_btn;
	FL_OBJECT *back_btn; 
	FL_OBJECT *prev5_btn; 
	FL_OBJECT *firsttrack_btn; 
	FL_OBJECT *next5_btn; 
	FL_OBJECT *fwd_btn; 
	FL_OBJECT *next_btn; 
	FL_OBJECT *lasttrack_btn; 

	FL_OBJECT *refresh_btn; 
	FL_OBJECT *suspend_btn; 
	FL_OBJECT *focus_btn; 
	FL_OBJECT *slot_counter_hidden; 
	FL_OBJECT *slot_counter; 

	FL_OBJECT *stop_quit_button;
	FL_OBJECT *quit_button;

	FL_OBJECT *spectrum[2]; 

	FL_OBJECT *set_spect_col_wid;
	FL_OBJECT *set_spect_int; 
	FL_OBJECT *set_spect_gain;
	FL_OBJECT *set_wav_pix_wid;
	FL_OBJECT *set_wav_pix_hei;
	FL_OBJECT *set_wav_vscale;
	FL_OBJECT *set_spectr_dispmod;
	FL_OBJECT *stereoBtn;
	FL_OBJECT *obturateBtn;

	FL_OBJECT *folder_btn[FOLDER_BUTTONS];

	FL_OBJECT *data_browser[2];
	FL_OBJECT *data_title_input;
	FL_OBJECT *data_title_toggle;
	FL_OBJECT *data_artist_input;
	FL_OBJECT *data_artist_toggle;
	FL_OBJECT *data_extra_input;
	FL_OBJECT *data_extra_toggle;
	FL_OBJECT *data_track_input;
	FL_OBJECT *data_track_toggle;
	FL_OBJECT *data_reload_btn;
	FL_OBJECT *data_save_btn;
	FL_OBJECT *active_browser_ptr[2]; 
	FL_OBJECT *data_ins_btn;
	FL_OBJECT *data_del_btn;

	FL_OBJECT *data_prefset_name;
	FL_OBJECT *data_prefset_number;
/*	FL_OBJECT *data_del_prefset_btn;
	FL_OBJECT *data_add_prefset_btn; */

	FL_OBJECT *help_canvas;
	FL_OBJECT *help_slider;

	FL_OBJECT *user_addr;
	int	  time_disp_id, play_mode_id;

} SADP_XFORMS_ALL;

FL_OBJECT *tooltip_text;
FL_FORM   *MainFrm;

#define MAX_WIDTH  800
#define MAX_HEIGHT 600
#define MIN_WIDTH  528
#define MIN_HEIGHT 350  /*   330 */
#define HEIGHT_NOBOTTOM 186


/* SADP_XFORMS_ALL  *create_form(void); */

extern char *digits[], *sadp_icon16[],  *sadp_dim16[], *control_xpm[];
extern char *sadp_icon256[],  *sadp_dim256[];
extern unsigned char spectr_bits[], wave_bits[];
extern unsigned char rcddb_bits[], data_bits[], help_bits[];
extern unsigned char info_bits[], misc_bits[], settings_bits[], none_bits[];
extern unsigned char allbtns_bits[], sadp_icon2c_bits[];
extern SPECTR_DISPLAY_MODE SpectrDisplayMode;	
extern short  Obturate;

extern unsigned int stereo, sample_size;
extern unsigned short stereo_supported;
extern double Frames;

extern u_char cd_status;  
extern u_char track_first, track_last, track_cur;
extern u_long track_time_start, track_time_end;
extern u_long time_start, time_total, time_cur, time_req;
extern int    cd_slot_count, cd_slot_current;		
/* extern char   TimeModeTxt[], AutoModeTxt[],  PlayModeTxt[]; */
extern PLAY_MODE_TYPE PlayMode;
extern TIME_DISPLAY_MODE_TYPE TimeDisplayMode;
extern PLACE_MODE_TYPES PlaceMode;	
extern short  AutoPlay, LoopPlay;
extern short  SaveSet, SaveMixer;

extern PREFSET_INFO  *cd_prefsets;
extern PREFSET_INFO  *cd_current_prefset;
extern short	cd_prefset_count;
extern short	cd_multi_artist;

extern const u_long cddb_disc_id;
extern char   *cdix_index;

extern CPLX   *ft_buffer;
extern long   ft_bufsize;
extern int    ft_size, bbuf_size;

extern char   volume, balance;
extern u_int  MixerDeviceCount;
extern u_int  MixerStereoMask, MixerCurDevMask;
extern u_int  MixerRecmask, MixerRecsrc;
extern u_int  SamplingRate;
extern char   MixerSoundDevice[];

extern short  FourWndCount;
extern int    audio, mixer;
extern short  FourInterlace, FourWndRes;
extern short  WaveHRes, WaveVRes;
extern short  FourGain, WaveVScale;

extern signed char *iobuf;
extern short  unsgn_mode;
extern signed short *iobuf16;
extern char   disc_name[], disc_artist[], disc_extra[];
extern short  cur_plist_pos;
/* extern char   BkgrColourName[31]; */

/* extern XFORMS_BTN_HELP HelpBtnsInfo[]; */

static char    reposition;	 
static u_char OldTrackNo = 0xff;

#ifdef USE_CHANGER
static int    OldSlotNo = -1;
#endif

static short  SuspendRefresh;
static short  BrowTrackNo = 0xff;

static time_t msg_remove_time;
static short  msg_seen;
/* static short  old_SuspendRefresh; */

#ifdef DSP_SUPPORT
static short  FourWndDiscrWid;
static short  InterStart=0, InterCurMode=0;
static short  FourWndWid=230, FourWndHei = 114;
#define FOURWNDRES_THRESHOLD  8
#endif

#ifdef ICON_WINDOW_SUPPORT
ICON_STYLE_TYPES  IconStyle;
void clear_icon_top(void);
#endif

static short audio_supported;
static SADP_XFORMS_ALL  *xforms_fd = NULL;

static long	old_position;
static Pixmap	DigitPmp, TrkPmp[2];
static u_short  ActiveBrowIndex;

static short	WindowResized;

#ifdef DSP_SUPPORT 
static Pixmap 	DimPmp;  /* , BkgrPmp; */
static Pixmap 	StippleBmp;
static FL_OBJECT *SpectrControls[10], *WaveControls[10];
static short	SpectrControlsCount, WaveControlsCount;
#endif

Atom		WMStateAtom;

FL_OBJECT	*DataControls[45];
short		DataControlsCount;

FL_OBJECT	*HelpControls[CBUTTONS+HBUTTONS];
short		HelpControlsCount;

#ifdef RCDDB_SUPPORT
FL_OBJECT	*RcddbControls[30];
short		RcddbControlsCount;
#endif
/* This structure array is filled for top controls 
   that loose shortcut with loosing focus */
/* Flag (binary digits):
    ..............xx - shortcut length: on focus
    ............xx.. - shortcut length: off focus data
    ..........xx.... - shortcut length: off focus help/info
    ........xx...... - shortcut length: off focus rcddb
    xxxxxxxx........ - reserved
*/     
static	struct  
{				
    FL_OBJECT	*obj;
    KeySym	scuts[3];	/* shorcut sequence */
    u_short	flag;
} ManagedCtrlStruct[100];
    
short ManagedCtrlCount;


const  int	 TrackWndWid = 14, TrackWndHei = 24;
const  char      *DefaultAppTitle = "Sing-Along Disc Player";
const  char      *DefaultIconName= "SADP";
const  char      *ResrcName = "xsadp";

char 		*ParGeometry = NULL;
int		xforms_ver, xforms_rev; 
Display		*disp = NULL;
Window		MainWnd = None,  HelpWnd = None;

#ifdef  ICON_WINDOW_SUPPORT
Window		IconWnd = None;
#endif 
int	 	ScreenW, ScreenH, ScreenD, ScreenVC;
short		BottomSection;
char		IconStyleApp, IconStyleBG, IconNameStyle;
FL_OBJECT	*helpSlider,  *helpCanvas;
unsigned long	spectr_colour[4], BgCol;
GC		spectr_gc, xforms_gc;
Pixmap		IconPmp, AllBtns, IconControlPmp;
extern short	DataChanged;
short		OptionsChanged;
extern short	IconWid, IconHei;

FL_OBJECT	*TooltipObject = NULL;
time_t		TooltipTime;
short 		TooltipCurTimeout;
extern short    TooltipTimeout1, TooltipTimeout2, TooltipTimeout3;

extern GC	IconGC;
extern short	IconSpectrY, IconSpectrH;

static const char *TimeDispModesLong[] =
    { "%r1ELAPSED", "%r1REMAINED", "%r1ELAPSED %%", "%r1REMAINED %%"};

const char *TimeDispModesShort[] =
{ "ELPS", "REM", "ELP%", "REM%"};

static const char *PlayModesLong[] =
    { "%r1NORMAL", "%r1PLAY LIST", "%r1RANDOM", "%r1INTRO", "%r1SINGLE"};

const char *PlayModesShort[] =
    { "NORM", "LIST", "RAND", "INTR", "SNGL"};

static const char *stop_labels[] = 
    {"@2eject", "@stop", "@eject"};
    
static const char *stop_tooltips[] = 
    {"Load tray", "Stop play", "Eject"};

static const char *play_labels[] = 
    {"", "@pause", "@play"};
    
static const char *play_tooltips[] = 
    {"<< inactive >>", "Pause", "Play/Resume"};
    
static void btn_callback(FL_OBJECT *obj, long par);
static void focus_btn_callback(FL_OBJECT *obj, long par);
static int  idle_callback_handle(XEvent *xev, void *user_data);
static void paint_new_disc(short track_no);
static void data_set_browser(FL_OBJECT *obj, short newpos);
static void adjust_data_browsers(void);
static void data_show_active_browser(void);
static void data_button_callback(FL_OBJECT *obj,  long par);
static void set_window_titles(void);
static void form_resize_callback(void);
static short change_prefset(short prefset_number);
static int  form_event_callback(FL_FORM *frm, void *vev);
static void data_input_callback(FL_OBJECT *obj,  long par);


#ifdef DSP_SUPPORT
static void clear_spectrum(int i, int win_width, int win_height); 
static void clear_spectrum_wnd(Window win, int width, int height);
/* static void tile_spectrum_pmp(Window win, int fill_type, 
			int left, int top, int width, int height); */
static void settings_callback(FL_OBJECT *obj, long par); 
static void arrange_spectrum_windows(void);
static void accept_resize_spectrum(int win_width, int win_height); 
static short StartFourWndMask;
short FourWndMask;
#endif

KeySym xforms_get_last_key(void)
{
    KeySym key;
#if FL_INCLUDE_VERSION < 86
/* Patch for version 0.81 */
    XEvent *xev = (XEvent *) fl_last_event();

    if (xev->type == KeyPress || xev->type == KeyRelease)
    {  char buf[4];
       
       XLookupString(&(xev->xkey), buf, 4, &key, NULL);
    }
    else key = 0;
#else
    key = fl_mouse_button() - FL_SHORTCUT;
#endif

    return key;
}

u_short get_kbd_shift(void)
{
    const XEvent *xev = fl_last_event();
    int		 type;

    type = xev->type;    
    if  (type == KeyPress || type == KeyRelease)
           return (xev->xkey.state);
	
    return 0;	
}    	    

			    
/* --------------------------------------------------------- */
/*
PLATFORM get_platform(void)
{    return PLTF_XFORMS; }
*/
void show_mode(OPERATION which)
{ 
   const char  *tptr;
   FL_OBJECT *obj;

   switch(which)
   {  case OPER_TIMEDISPLAY:     
	   obj = xforms_fd -> time_disp_btn;
	   tptr = TimeDispModesShort[TimeDisplayMode];
	   break;

      case OPER_AUTOPLAY:	
	   obj = xforms_fd -> auto_play_btn;
           fl_set_object_lcolor(obj, AutoPlay ? FL_SPRINGGREEN : FL_DARKGOLD);   
	   return;	   

      case OPER_LOOPPLAY:	
	   obj = xforms_fd -> loop_play_btn;
           fl_set_object_lcolor(obj, LoopPlay ? FL_SPRINGGREEN : FL_DARKGOLD);   
	   return;	   

      default:	 /* play mode */
	   obj = xforms_fd -> play_mode_btn;
	   tptr = PlayModesShort[PlayMode];
	   break;
	   
   }
   

   fl_redraw_object(obj);
   fl_set_object_label(obj, tptr);   

}


/*================================================*/

/* Needed for campatibility with ncurses */

void refresh_output(void)
{  ; }


void redraw_screen(void)
{

    if (SuspendRefresh)
    { 
	    SuspendRefresh =0;
	    show_cd_time();
	               
#ifdef DSP_SUPPORT	
	    sound_process();
  	    if (BottomSection == FOLDER_SPECTRUM
	              && FourWndCount ==2 && FourInterlace > 0)
	       sound_process();
#endif
	    SuspendRefresh = 1;

    }
    else
        fl_redraw_form(MainFrm);
   
}



void set_suspend_mode(short NewMode)
{   
    if (MainWnd == None) return;

    if (NewMode)
    {    old_position = time_cur;
	 show_status_message("Suspended", -1);
    }
    else
    	 cd_status = 0xf0;   /* This will force status to be re-displayed*/
    
    SuspendRefresh = NewMode;
    if (NewMode != fl_get_button(xforms_fd->suspend_btn))
	     fl_set_button(xforms_fd->suspend_btn, NewMode);

}


#ifdef DSP_SUPPORT
void  draw_wave(void)
{
    int i, j, k, x2, xincr;
    static int m=0;
    long signal, signal1, increm, fgcolour;
    short hei1, hei2;
    short main_need_drawing, icon_need_drawing = 0;
    Window CurWnd;
    int icon_wid = 0;
    
    if (SuspendRefresh) return;

    main_need_drawing = win_visibility(MainWnd);
#ifdef ICON_WINDOW_SUPPORT
    icon_need_drawing = win_visibility(IconWnd);
#endif

    if ((main_need_drawing | icon_need_drawing) == 0) return;

    increm = bbuf_size / FourWndWid;
    
    if (FourWndCount > 1) increm &= ~1;
    if (increm <= 0) increm= FourWndCount;

    hei1 = FourWndHei - WaveVRes;
    hei2 = IconSpectrH - 1;


    icon_wid = IconWid - 4;
    if (FourWndCount > 1) icon_wid = (IconWid-8)/FourWndCount;
    
    if (Obturate) m ^= 1;
    else m = 1;
    
    for (k=0; k<FourWndCount; k++)
    {  CurWnd = fl_get_canvas_id(xforms_fd->spectrum[k]);

       xincr = k*(icon_wid+4);	
       	
       if (m > 0)
       {  fgcolour = spectr_colour[0];
	  if (main_need_drawing)          
	  {     
             XSetForeground(disp, spectr_gc, fgcolour);
             XFillRectangle(disp, CurWnd, spectr_gc, 0, 0,
         	              FourWndWid, FourWndHei);
	  }
#ifdef ICON_WINDOW_SUPPORT
	  if (icon_need_drawing)          
	  {
             XSetForeground(disp, IconGC, fgcolour);
             XFillRectangle(disp, IconWnd, IconGC, xincr+2, IconSpectrY,
         	              icon_wid, IconSpectrH);
	  }
#endif
	  		      
          if (Obturate) continue;
       }	

       fgcolour = spectr_colour[k+2];
       if (main_need_drawing)          
             XSetForeground(disp, spectr_gc, fgcolour);
#ifdef ICON_WINDOW_SUPPORT
       if (icon_need_drawing)          
             XSetForeground(disp, IconGC, fgcolour);
#endif

       j = k;
       x2 = 0;
       
       for (i=0; i<FourWndWid; i+=WaveHRes, j+=increm)
       { 

	  if (sample_size == 8)
	  {    if(unsgn_mode) 
	          signal = (((int)iobuf[j%bbuf_size] << 8) & 0xffff) - 0x8000;
	       else
	          signal =  ((((int)iobuf[j%bbuf_size]+128)  << 8 ) & 0xffff) - 0x8000; 
	  }		  
	  else
	  {   if (unsgn_mode)
	          signal = ((int)iobuf16[j%bbuf_size] & 0xffff) - 0x8000;
	       else		  
	          signal = (int)iobuf16[j%bbuf_size]; 
	  }		  


	  if (WaveVScale > 0)
	  {  signal <<= WaveVScale;
	     if (signal > 0x07fff) signal = 0x07fff;
	     if (signal < -0x08000 ) signal = -0x08000;
	  }
	  else
	  if (WaveVScale > 0)
                 signal >>= -WaveVScale;

	  if (main_need_drawing)
	  {	 
          signal1 = ((~(signal+0x8000) & 0xffff) * hei1) >> 16;
	      XFillRectangle(disp, CurWnd, spectr_gc, i, signal1, 
     	               WaveHRes,  WaveVRes);
	  }
	 
#ifdef ICON_WINDOW_SUPPORT
	  if (icon_need_drawing && x2<icon_wid)
          {   signal1 = ((~(signal+0x8000) & 0xffff) * hei2) >> 16;
/*	      XFillRectangle(disp, IconWnd, IconGC,
	              x2+xincr, IconSpectrY+signal1, 
     	               1,  1); */
	      XDrawPoint(disp, IconWnd, IconGC,
	              x2+xincr+2, IconSpectrY+signal1);
	  }    	   		       
#endif
    
          x2++;		       
       }

    }       		      

}


void  draw_spectrum(void)
{

   Window  CurWnd;  


   CPLX value;	
   double rval;  

   int module, module1=0,from, to1=0, to;
   int  i, j, j1, k, x, shift, step, offx, wid1, add1, gain_scale;
   int threshold, colhei, tothei, gapstart=0;
   CPLX   *bufptr;

   int  x2, wid1a;
   int main_need_drawing;
     
#ifdef ICON_WINDOW_SUPPORT
   int wid1b, x2a=0, colhei2, module2=0;
   int icon_wid = 0, icon_hei= 0;
   int icon_need_drawing;
   int gapstart2=0;
#endif

   if (SuspendRefresh) return;
   
      
   if (BottomSection != FOLDER_SPECTRUM) return;

   main_need_drawing = win_visibility(MainWnd);
#ifdef ICON_WINDOW_SUPPORT
   icon_need_drawing = win_visibility(IconWnd);
   if ((main_need_drawing | icon_need_drawing) == 0) return;
#else
   if (main_need_drawing == 0) return;
#endif
   
          

   tothei = FourWndHei;    
#ifdef ICON_WINDOW_SUPPORT
   icon_hei = IconSpectrH;
#endif
   
   if (SpectrDisplayMode == SDM_COMB)
   {  tothei = (tothei-1)>> 1;
#ifdef ICON_WINDOW_SUPPORT
      icon_hei = (icon_hei-1)>> 1;
      gapstart2 = IconSpectrH - icon_hei;
#endif
      gapstart = FourWndHei - tothei;
   }          

   colhei = tothei/3;
   threshold = tothei * 7/8;
#ifdef ICON_WINDOW_SUPPORT
   colhei2 = icon_hei/3;
#endif

   shift = InterCurMode ? FourInterlace : 1;
   step  = (FourWndRes >> 2);
   if (step == 0) step = 1;        
   step *= shift;
   
   add1 = (step >> 1) + 1;


   offx = (FourWndRes >= FOURWNDRES_THRESHOLD ) ? 1 : 0;
   wid1 = FourWndRes - (offx << 1);
   offx += InterStart*FourWndRes;                   
   wid1a = wid1/10+1;    

#ifdef ICON_WINDOW_SUPPORT
   icon_wid = IconWid - 4;
   if (FourWndCount > 1) icon_wid = (IconWid-8)/FourWndCount;
#endif
                          
  for (k=0; k<FourWndCount; k++)
  {
	if (!((k+1) & FourWndMask)) continue;
    if (main_need_drawing)
    {  CurWnd = fl_get_canvas_id(xforms_fd->spectrum[k]);
       if (!CurWnd) continue; 
    }
    else CurWnd = None;
     
    j1 = add1;
    bufptr = ft_buffer + k*ft_bufsize;

    x = offx;
    x2 = InterStart*wid1a;

      
    for (i=InterStart; i< FourWndDiscrWid; i+=shift)
    { 

  	  ft_process(&value, bufptr, j1);     /* (I+FourInterp+1/2)*step */

	  switch(SpectrDisplayMode)
	   {  case SDM_MODULUS:
	        rval = sqrt(value.r*value.r + value.i*value.i);
		    break;
	    			
		  case SDM_REAL:
	  	    rval = fabs(value.r);
		    break;
	    
	  	  case SDM_IMAG:
	        rval = fabs(value.i);
			break;

		  default:			/* case SDM_COMB: */
	  	    rval = fabs(value.r)/2;
		    break;
	   }
	 

	  gain_scale = ft_size+10-FourGain;
 
	 
	  if (main_need_drawing)
	  {  module = (long)(rval * FourWndHei) >> gain_scale;  /* Was +4 */
		  if (i>InterStart && (module-module1) > threshold) module = module1;
	  	  else module1 = module;
	 
	  	  module = tothei-module;
	  	  if (module <0) module = 0;
	  	  if (module >tothei) module = tothei;

		  from = 0;
		  for (j=0; j<3; j++)
	      {  to = from + colhei;

	       if (module >= from)
	       {  to1 = (module >= to ? to : module);
/*			  tile_spectrum_pmp(CurWnd, 0,  x,  from, wid1, to1-from); */
              XSetForeground(disp, spectr_gc, spectr_colour[0]);
              XFillRectangle(disp, CurWnd, spectr_gc, x, from, 
	 	          wid1, to1 - from);
	          from = to1;
	       }

	       if (from < to)
	       {
/*			  tile_spectrum_pmp(CurWnd, j+1,  x, from, wid1, to-from); */
              XSetForeground(disp, spectr_gc, spectr_colour[j+1]);
              XFillRectangle(disp, CurWnd, spectr_gc, x, from, 
			              wid1, to - from);
	       }
               from = to;
        }	      
	 }


#ifdef ICON_WINDOW_SUPPORT
	 if (icon_need_drawing && x2<icon_wid)
	 {  module = (long)(rval * IconHei) >> gain_scale;
	    if (i>InterStart && (module-module2) > icon_hei) module = module2;
	    else module2 = module;
	 
	    module = icon_hei-module;
	    if (module <0) module = 0;
	    if (module >icon_hei) module = icon_hei;

	    wid1b = wid1a;
	    if (x2 + wid1b > icon_wid) wid1b = icon_wid - x2;
    
	    from = 0;
	    x2a = x2+2;
	    if (k) x2a += icon_wid+4;
	    for (j=0; j<3; j++)
	    {  to = from + colhei2;

	       if (module >= from)
	       { to1 = (module >= to ? to : module);
             XSetForeground(disp, IconGC, spectr_colour[0]);
             XFillRectangle(disp, IconWnd, IconGC, x2a, from+IconSpectrY, 
	 	          wid1b, to1 - from);   // was wid1
	         from = to1;
	       }

	       if (from < to)
	       {
              XSetForeground(disp, IconGC, spectr_colour[j+1]);
              XFillRectangle(disp, IconWnd, IconGC, x2a, from+IconSpectrY, 
	                  wid1b, to - from);   
	       }
           from = to;
        }	      
	 
	 }
#endif
     
         j1 += step; 

         if (SpectrDisplayMode != SDM_COMB) goto Adelante;

	 rval = fabs(value.i)/2;
	 
	 if (main_need_drawing)
	 {  module = (long)(rval * FourWndHei) >> gain_scale;

            if (module <0) module = 0;
            if (module >tothei) module = tothei;
	    from = 0;
	 
	    for (j=0; j<3; j++)
	    {  to = from + colhei;
	    
		  if (module >= from)
		  {  to1 = (module >= to ? to : module);
             XSetForeground(disp, spectr_gc, spectr_colour[3-j]);
             XFillRectangle(disp, CurWnd, spectr_gc, x, gapstart+from, 
             wid1, to1 - from);
             from = to1;
		  }

		  if (to1 < to)
		  { 
		     XSetForeground(disp, spectr_gc, spectr_colour[0]);
		     XFillRectangle(disp, CurWnd, spectr_gc, x, gapstart+to1, 
                             wid1, to - to1);
		  }

                from = to;
        }		
     }	      

#ifdef ICON_WINDOW_SUPPORT
	 if (icon_need_drawing && x2<icon_wid)
	 { 
	    module = (long)(rval * IconHei) >> gain_scale;
            if (module <0) module = 0;
            if (module >tothei) module = tothei;

	    if (x2+wid1a > icon_wid) wid1a = icon_wid - x2;

	    from = 0;
	    x2a = x2+2;
	    if (k) x2a += icon_wid+4;

	    wid1b = wid1a;
	    if (x2 + wid1b > icon_wid) wid1b = icon_wid - x2;
	    
      	    for (j=0; j<3; j++)
	    {
	        to = from + colhei2;
	    
		if (module >= from)
		{ to1 = (module >= to ? to : module);
          XSetForeground(disp, IconGC, spectr_colour[3-j]);
          XFillRectangle(disp, IconWnd, IconGC, x2a, gapstart2+from+IconSpectrY, 
     	          wid1b, to1 - from);
		  from = to1;
	        }

		if (to1 < to)
	        { 
        	  XSetForeground(disp, IconGC, spectr_colour[0]);
              XFillRectangle(disp, IconWnd, IconGC, x2a, gapstart2+to1+IconSpectrY, 
                wid1b, to - to1);
		}
                from = to;
	     }
 
          }	      
#endif
	 
     Adelante: 
	 x2 += shift*wid1a;
         x += FourWndRes*shift;
	 
      }

    

    }

 
     if (FourInterlace > 0)
     {  if (FourWndCount > 1) FourWndMask ^= 11;	
	  if (FourWndMask==1 && FourInterlace > 1)
	  {   InterStart = (InterStart + 1) % FourInterlace;
              InterCurMode = 1;
	  }
     }

}

/* Erases bars, leaving background image intact */
static void erase_spectrum_bars(int i) 
{     Window  win;

      win = fl_get_canvas_id(xforms_fd->spectrum[i]);
      XSetForeground(disp, spectr_gc, spectr_colour[0]); 
      XFillRectangle(disp, win, spectr_gc, 0, 0, FourWndWid, FourWndHei);
      
}

static void settings_callback(FL_OBJECT *obj, long par)
{

    int i;

    
    switch(par)
    {
	case	SET_BARWIDTH:
		FourWndRes = fl_get_counter_value(xforms_fd->set_spect_col_wid);
	        FourWndDiscrWid = (FourWndWid+FourWndRes-1)/FourWndRes;
		if(FourWndRes >= FOURWNDRES_THRESHOLD)
		    for (i=0; i<FourWndCount; i++)  erase_spectrum_bars(i);
			
		break;

	case	SET_BARWIDTH+1000:
		i = xforms_get_last_key();
		/* i = fl_get_button_numb(obj) - FL_SHORTCUT; */
  	        i = (i == XK_w) ? 1 : -1; 		      
		i += FourWndRes;
		if (i >= BAR_MIN_WIDTH && i<= BAR_MAX_WIDTH)
    		{  FourWndRes = i;
	           FourWndDiscrWid = (FourWndWid+FourWndRes-1)/FourWndRes;
	    	   if(FourWndRes >= FOURWNDRES_THRESHOLD)
		     for (i=0; i<FourWndCount; i++)  erase_spectrum_bars(i);
	           fl_set_counter_value(xforms_fd -> set_spect_col_wid, FourWndRes);
		}         
		break;

	case    SET_STEREO:
		if (!stereo_supported) break;
		audio_stop();
	    stereo = fl_get_button(xforms_fd->stereoBtn);
		arrange_spectrum_windows();
	    InterStart = 0; InterCurMode = 0;
	    FourWndMask = StartFourWndMask = stereo ? 3 : 1 ;
	    audio_reinitialize();
		break;

	case SET_INTERLACE:
	    FourInterlace =  fl_get_counter_value(xforms_fd -> set_spect_int);
	    InterStart = 0; InterCurMode = 0;
	    FourWndMask = StartFourWndMask;
		break;
		

	case	SET_INTERLACE+1000:
		i = xforms_get_last_key();
  	        i = (i == XK_i) ? 1 : -1; 		      
		i += FourInterlace;
		if (i >= INTERLACE_MIN && i<= INTERLACE_MAX)
    		{  FourInterlace = i;
    	           InterStart = 0; InterCurMode = 0;
	           FourWndMask = StartFourWndMask;
	           fl_set_counter_value(xforms_fd -> set_spect_int, i);
		}         
		break;

	case	SET_GAIN:
	        FourGain =  fl_get_counter_value(xforms_fd -> set_spect_gain);
		break;

	case	SET_GAIN+1000:
		i = xforms_get_last_key();
  	        i = (i == XK_g) ? 1 : -1; 		      
		i += FourGain;
		if (i >= GAIN_MIN && i<= GAIN_MAX)
    		{  FourGain = i;
	           fl_set_counter_value(xforms_fd -> set_spect_gain, i);
		}         
		break;

	case	SET_VSCALE:
		obj = xforms_fd -> set_wav_vscale;
		i = xforms_get_last_key();
		if (i<=0)
		    /* Mouse click */
		    WaveVScale =  fl_get_counter_value(obj);
		else		    
		{   /* Shortcut */    
		    i = (i == XK_v) ? 1 : -1; 		      
		    i += WaveVScale;
		    if (i >= VSCALE_MIN && i<= VSCALE_MAX)
		    {	WaveVScale = i;
			fl_set_counter_value(obj, i);
		    }         
		}		    
		break;


	case 	SET_PIXELWIDTH:
		obj = xforms_fd -> set_wav_pix_wid;
		i = xforms_get_last_key();
		if (i<=0)
		    /* Mouse click */
                    WaveHRes = fl_get_counter_value(obj);
		else
		{   /* Shortcut */    
		    i = (i == XK_w) ? 1 : -1; 		      
		    i += WaveHRes;
		    if (i >= PIXEL_MIN_WIDTH && i<= PIXEL_MAX_WIDTH)
		    {  WaveHRes = i;
	               fl_set_counter_value(obj, i);
		    }
		}		    
   		break;
		
	case 	SET_PIXELHEIGHT:
		obj = xforms_fd -> set_wav_pix_hei;
		i = xforms_get_last_key();
    		if (i<=0)
	            WaveVRes= fl_get_counter_value(obj);
		else
		{   /* Shortcut */    
		    i = (i == XK_h) ? 1 : -1; 		      
		    i += WaveVRes;
		    if (i >= PIXEL_MIN_HEIGHT && i<= PIXEL_MAX_HEIGHT)
		    {  WaveVRes = i;
	               fl_set_counter_value(obj, i);
		    }
		}    
		break;
		

		
	case	SET_SPECTRUM_DISPLAY:
//		i = xforms_get_last_key();
//		if (i<=0)
		{  SpectrDisplayMode = fl_get_choice(obj);
		   if (SpectrDisplayMode == SDM_COMB)
		   {   for (i=0; i<FourWndCount; i++)    
		         clear_spectrum(i, FourWndWid, FourWndHei);
		   }
		} 
/*		else  			 
		{   i = (i == XK_d) ? 1 : -1; 		      
		    i += SpectrDisplayMode;
		    if (i > 4) i=1; else if (i<1) i=4; 
		    SpectrDisplayMode = i;
		    fl_set_choice(xforms_fd->set_spectr_dispmod, SpectrDisplayMode);
		    if (SpectrDisplayMode == SDM_COMB)
		    {   for (i=0; i<FourWndCount; i++)    
		         clear_spectrum(i, FourWndWid, FourWndHei);
		    }
		}	*/	    			 
		break;

	case    SET_OBTURATE:
	        Obturate = fl_get_button(xforms_fd -> obturateBtn);
		break;
		
		
	default: 
	       return;		
    }		

    OptionsChanged = 1;
}

#endif

static void show_stop_button(short ind)
{  
    FL_OBJECT *obj;
    
    obj =  xforms_fd->stop_btn; 
    

    fl_set_object_label(obj, stop_labels[ind]);
    fl_redraw_object(obj);

    set_tooltip_text(obj, stop_tooltips[ind]);
    if (obj->belowmouse && TooltipTimeout1 <= 10)
	    show_tooltip(obj, 0);

#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None) set_icon_stop_button(ind);		
#endif

    obj =  xforms_fd->play_btn; 
    fl_set_object_label(obj, play_labels[ind]);
    fl_redraw_object(obj);

    set_tooltip_text(obj, play_tooltips[ind]);
    if (obj->belowmouse && TooltipTimeout1 <= 10)
	    show_tooltip(obj, 0);


}


void show_status_message(const char *status, short ind)
{
    FL_OBJECT *obj;


    if ((MainWnd == None)|| SuspendRefresh || msg_seen) return;

    obj = xforms_fd->cd_status_box;

    fl_set_object_lcolor(obj, (ind < 0) ? FL_SPRINGGREEN: SADP_YELLOW);
    fl_set_object_label(obj, status);
    fl_redraw_object(obj);
    XFlush(disp);

    if (ind >= 0) show_stop_button(ind);
}
    
void launch_message(const char *message)
{   
    if (!MainWnd) return;
    
    fl_deactivate_object(xforms_fd->suspend_btn);

    msg_seen = 0;
    show_status_message(message, -2);
/*    old_SuspendRefresh = SuspendRefresh;

    set_suspend_mode(-1); */
    msg_seen = 1;
    msg_remove_time = time(NULL) + 2;
}

void delaunch_message(void)
{
/*   
    if (MsgWnd)
    {   delwin(MsgWnd); 	
        MsgWnd = NULL;
    }

    redraw_screen();	    
    set_suspend_mode(old_SuspendRefresh);
*/    
    msg_remove_time = 0;
    msg_seen = 0;
    cd_status = 0xf0;   /* This will force status to be re-displayed*/
    fl_activate_object(xforms_fd->suspend_btn);
}



void show_volume(void)
{  
    FL_OBJECT *obj;
    int stereo_support;	
    char text[5];

    if (MixerDeviceCount == 0) return; 

    obj =  xforms_fd->vol_dial;
    fl_set_dial_value( obj, volume);
    sprintf (text, "%d", volume);
    fl_set_object_label(obj, text);


   /* ------------------------------------------ */

    obj =  xforms_fd->bal_dial;
    stereo_support = (MixerCurDevMask == 0) ||
                           (MixerCurDevMask & MixerStereoMask);	
    if (stereo_support)
    {	fl_activate_object(obj);
        fl_set_object_color(obj,SADP_BLACK, SADP_YELLOW);
        fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    }	
    else
    {	fl_deactivate_object(obj);
        fl_set_object_color(obj,SADP_BLACK,FL_DARKGOLD);
        fl_set_object_lcolor(obj,FL_DARKGOLD);
	balance = 50;
    }		    			   


    fl_set_dial_value( obj, balance-50); 
    sprintf (text, "%d", balance-50);
    fl_set_object_label(obj, text); 
   	 	
}


void show_mixer_device(void)
{ 
    FL_OBJECT *obj;

    if (MixerDeviceCount == 0) return; 

    obj = xforms_fd->mixer_sound_device;
    fl_set_object_lcolor(obj, (MixerCurDevMask == 0) ? FL_SPRINGGREEN : SADP_YELLOW);
    fl_set_object_label(obj, MixerSoundDevice);


}  


void show_mixer_input(void)
{

#ifdef MIXER_SUPPORT
    FL_OBJECT *obj;
    
    if (mixer < 0 || MixerDeviceCount == 0) return; 
    
    obj = xforms_fd->mixer_input_switch; 

    if (!(MixerCurDevMask & MixerRecmask))
         fl_hide_object(obj);
    else
    {   fl_show_object(obj);

       if (MixerCurDevMask & MixerRecsrc)
       {  fl_set_object_lcolor(obj,FL_SPRINGGREEN);
          fl_set_object_label(obj, "ON");
       }	      
       else	    	
       {  fl_set_object_lcolor(obj,FL_RED);
	  fl_set_object_label(obj, "OFF");
       }	      
    }	
#endif

    return; 
}

/* Called from pre-emptive header */
void input_processing(FL_OBJECT *obj)
{   FL_OBJECT  *focus;

    focus = xforms_fd->focus_btn;
    if (!fl_get_button(focus))
    { fl_set_button(focus, 1);	
      focus_btn_callback(focus, 0);
    } 
    
		
    fl_set_focus_object(MainFrm, obj);
}

/*================================================*/
#ifdef DSP_SUPPORT
void arrange_spectrum_windows(void)
{     FL_OBJECT *right_spectr = NULL , *left_spectr;
      int    eff_wid, new_wid;


  left_spectr  = xforms_fd->spectrum[0];
  right_spectr = xforms_fd->spectrum[1];
      
  eff_wid = right_spectr->x + right_spectr->w - left_spectr->x;
  FourWndHei = MainFrm->h - left_spectr->y - 50;

  if (stereo)
  {
	 new_wid = (eff_wid - 30) >> 1;      
     fl_set_object_size(right_spectr,new_wid, FourWndHei);  
     FourWndCount = 2;
  }
  else
  {
	 if(right_spectr) 
	   fl_hide_object(right_spectr);   /* This will destroy window */
	 new_wid = eff_wid;
     FourWndCount = 1;
  }
  
  fl_set_object_size(left_spectr,new_wid, FourWndHei ); 
	
  accept_resize_spectrum(new_wid, FourWndHei); /* Recreates right window, if needed */

  if (BottomSection < FOLDER_DATA)
	 fl_redraw_form(MainFrm);
}

#endif
/*--------------------------------------------------------*/
/* flag: 0 - hide only, 1 - do all relevant stuff */

static void hide_folder_controls(int old_mode, int new_mode, int flag)
{   short i;	
    FL_OBJECT	**FolderControls, *obj;
    short	FolderControlsCount;


#ifdef DSP_SUPPORT
    if (old_mode <= FOLDER_WAVE)
    {
        if (flag) audio_stop();

	if (new_mode > FOLDER_WAVE)
        {  for (i=0; i<FourWndCount; i++)
    	        fl_hide_object(xforms_fd->spectrum[i]);

#ifdef ICON_WINDOW_SUPPORT
       if (IconWnd != None) init_icon_nonaudio();    
#endif
	}		

	if (old_mode == FOLDER_SPECTRUM)
	{   FolderControls = SpectrControls;
	    FolderControlsCount = SpectrControlsCount;
	}
	else
	{   FolderControls = WaveControls;
	    FolderControlsCount = WaveControlsCount;
	}
	if (new_mode <= FOLDER_WAVE) FolderControlsCount--;
				        /* Avoids hiding 'Stereo' */


    }
    else
#endif
    if (old_mode <= FOLDER_MISC)	    
    {	
	if (old_mode >= FOLDER_HELP && new_mode >= FOLDER_HELP &&
		 new_mode <= FOLDER_MISC) return;

        obj = xforms_fd->focus_btn;
        if (flag)
	{   fl_set_button(obj, 0);
	    help_unprepare_canvas();
	}  
	fl_hide_object(obj);



        if (old_mode == FOLDER_DATA)
	{   FolderControlsCount = DataControlsCount;
    	    FolderControls = DataControls;
	    /* Patching another xforms bug */
	    fl_set_object_label(xforms_fd->data_title_input, "");
	    fl_set_object_label(xforms_fd->data_artist_input, "");
	    fl_set_object_label(xforms_fd->data_track_input, "");
        }
#ifdef RCDDB_SUPPORT	
	else
        if (old_mode == FOLDER_RCDDB)
	{   FolderControls = RcddbControls;
	    FolderControlsCount = RcddbControlsCount;
	}   
#endif
	else
    	{   FolderControls = HelpControls;
	    FolderControlsCount = HelpControlsCount;
	}    
	
    }	    
    else  return;
	

    for (i=0; i<FolderControlsCount; i++)
    {  obj = FolderControls[i];
       fl_hide_object(obj);
    }
    
    XFlush(disp);
}		    


static void show_folder_controls(int old_mode, int new_mode)
{
    FL_OBJECT	**FolderControls, *obj;
    short	FolderControlsCount;
    int i;

    

#ifdef DSP_SUPPORT
    if (new_mode <= FOLDER_WAVE)
    {	if (old_mode > FOLDER_WAVE)
	{   arrange_spectrum_windows();
	    for (i=0; i<FourWndCount; i++)
	    {   obj =  xforms_fd->spectrum[i];
    		fl_show_object(obj);
	    }
	}
	if(FourWndRes >= FOURWNDRES_THRESHOLD ) 
	{   for (i=0; i<FourWndCount; i++)
	        clear_spectrum(i, FourWndWid, FourWndHei);
	}		
	if (new_mode == FOLDER_SPECTRUM)
	{   FolderControls = SpectrControls;
	    FolderControlsCount = SpectrControlsCount;
	}
	else
	{   FolderControls = WaveControls;
	    FolderControlsCount = WaveControlsCount;
	}
	if (old_mode <= FOLDER_WAVE) FolderControlsCount--;
				        /* Avoids showing 'Stereo' */
        audio_reinitialize();	
    }
    else
#endif    
    if (new_mode == FOLDER_DATA)
    {
        obj = xforms_fd->focus_btn;
	fl_set_button(obj, 0);
	if (track_cur == 0xff)
	   fl_hide_object(obj);
	else
	   fl_show_object(obj); 
    
	FolderControlsCount = DataControlsCount;
        FolderControls = DataControls;
    }
#ifdef RCDDB_SUPPORT
    else	
    if (new_mode == FOLDER_RCDDB)
    {   
        obj = xforms_fd->focus_btn;
	fl_set_button(obj, 1);
	fl_show_object(obj); 
    
        FolderControls = RcddbControls;
	FolderControlsCount = RcddbControlsCount;
    
    }
#endif    
    else
    if (new_mode <= FOLDER_MISC)
    {	
	  if (old_mode < FOLDER_HELP || old_mode > FOLDER_MISC)
	  { obj = xforms_fd->focus_btn;
	    fl_set_button(obj, 1);
	    fl_show_object(obj);

        obj = xforms_fd->help_canvas;
	    fl_show_object(obj);
        HelpWnd = fl_get_canvas_id(obj);
	    FolderControlsCount = HelpControlsCount;
	  }    
	  else
	    FolderControlsCount = 0;

	  FolderControls = HelpControls;

	  help_prepare_canvas(new_mode);
  	  fl_set_slider_value(xforms_fd->help_slider, 1);
      help_show_page(0);
    }
    else
	return;
	

    for (i=0; i<FolderControlsCount; i++)
    {   obj = FolderControls[i];
	fl_show_object(obj);
    }	
    
    if (new_mode == FOLDER_DATA)
    {   fl_set_object_label(xforms_fd->data_title_input, "Title:");
        fl_set_object_label(xforms_fd->data_artist_input, "Artist:");
        fl_set_object_label(xforms_fd->data_track_input, "Track:");
    }	 
    
#ifdef RCDDB_SUPPORT
    if (new_mode == FOLDER_RCDDB)
	  rcddb_got_focus();
#endif

}

void set_form_title(void)
{
  char title[141];
  int l1, l2;
     
  if (strcmp(disc_name, "** Unknown **") == 0)
	l1 = 0;
  else
    l1 = strlen(disc_name);
     	     
  l2 = strlen(disc_artist);

  if (l1 || l2)
  {
	strcpy (title, "xsadp: ");
  
    if (l1) {
      strcat(title, disc_name);
      if (l2) {
		strcat (title, " - ");
        strcat (title, disc_artist);
      }
	} else  	 
      strcat(title, disc_artist);
	
  }       
  else
	strcpy(title, DefaultAppTitle);   

  fl_set_form_title(MainFrm, title);   

#ifdef ICON_WINDOW_SUPPORT
  if (IconWnd != None)
	  fl_wintitle(IconWnd, title);
#endif	  

}

void data_browser_callback(FL_OBJECT *obj,  long par)
{
    int has_focus;
    int brow_pos = fl_get_browser(obj);
    char *trk_name;
    short par1 = (short) (par & 1);
    
    has_focus =  fl_get_button(xforms_fd->focus_btn);


    if ((par & 4) == 0 && ActiveBrowIndex != par1)
    {  	ActiveBrowIndex = par1;
	data_show_active_browser();
    }	  
    
    if (par1 == 0)
    {
        if (brow_pos == 0) 
        {   BrowTrackNo = 0xff;
	    trk_name = "";
	}
	else
        {  BrowTrackNo = track_first+brow_pos-1;
           trk_name = cdaudio_get_track_name(BrowTrackNo);
	}   

        fl_set_input(xforms_fd->data_track_input, trk_name); 

	if (fl_get_button(xforms_fd->data_artist_toggle))
	{  trk_name = (brow_pos) ? cdaudio_get_track_artist(BrowTrackNo) : "";
           fl_set_input(xforms_fd->data_artist_input, trk_name); 
	}

	if (fl_get_button(xforms_fd->data_extra_toggle))
	{  trk_name = (brow_pos) ? cdaudio_get_track_extra(BrowTrackNo) : "";
           fl_set_input(xforms_fd->data_extra_input, trk_name); 
	}

        fl_set_button(xforms_fd->data_track_toggle,
	                        cd_track_skipability(BrowTrackNo)); 
	data_input_callback(xforms_fd->data_track_toggle, 112);				
	
        if (!has_focus && BrowTrackNo != 0xff && track_cur != BrowTrackNo)  
               cd_playtrack(BrowTrackNo, 4);


    }
    else
    if (!has_focus)
    {
        BrowTrackNo = atoi(fl_get_browser_line(obj, brow_pos));
        if (par1 > 0 && PlayMode == PLAY_LIST)
               cur_plist_pos =  brow_pos - 1;

	/* This will involve this function recursively with par1=0 */
        data_set_browser(xforms_fd->data_browser[0], BrowTrackNo-track_first+1);
    }	 
        
}


static void data_set_browser(FL_OBJECT *obj, short newpos)
{  short topline;

//   if (fl_get_browser(obj) == newpos) return;    

    topline = fl_get_browser_topline(obj);
    if (newpos < topline)
	fl_set_browser_topline(obj, newpos);
    else
    {   short screen_lines = fl_get_browser_screenlines(obj);
	if (newpos >= topline + screen_lines)
	    fl_set_browser_topline(obj, newpos + 1 - screen_lines);
    }	    
       
   fl_select_browser_line(obj, newpos);
   if (obj->argument == 0)
         data_browser_callback(obj, 4);
}

static void data_advance_browser(short val, u_short shift)
{  FL_OBJECT *obj = xforms_fd->data_browser[ActiveBrowIndex ^ shift];
   short newpos = fl_get_browser(obj) + val;		
   short maxpos = fl_get_browser_maxline(obj);       
   
   if (newpos < 1) newpos = 1;
   if (newpos > maxpos) newpos = maxpos;

   data_set_browser(obj, newpos);
}

/* Adjust browsers with changing current track */
void adjust_data_browsers()
{  
    if (track_cur<= track_last
         && !fl_get_button(xforms_fd->focus_btn) )
    {	data_set_browser(xforms_fd->data_browser[0],
			 track_cur+1-track_first);	
	if (PlayMode == PLAY_LIST)
      	    data_set_browser(xforms_fd->data_browser[1],
 		  	     cur_plist_pos+1);	
    }    	 
}


void data_show_active_browser()
{   int ind = ActiveBrowIndex;

    fl_show_object(xforms_fd->active_browser_ptr[ind]); 
    fl_hide_object(xforms_fd->active_browser_ptr[1-ind]); 

}    

void  save_local_db(void)    	
{     FL_OBJECT *obj;
      short prefset_no1, prefset_no2;

      prefset_no1 = cd_current_prefset-cd_prefsets;
      cd_prepare_save_prefsets();
      prefset_no2 = cd_current_prefset-cd_prefsets;
      obj = xforms_fd->data_prefset_number;
      if (prefset_no2 != prefset_no1)
      {   fl_set_counter_value(obj, prefset_no2+1);
          change_prefset(prefset_no2);
      }
      fl_set_counter_bounds(obj, 1, cd_prefset_count);
      
      scdb_write();
      launch_message("Saved");
      DataChanged = 0;
}      
	   	              
void data_button_callback(FL_OBJECT *obj,  long par)
{

    switch(par)
    { case 0:		/* Reload */
	  if (track_cur != 0xff)
	  {  read_local_db();
	     paint_new_disc(BrowTrackNo);
	     launch_message("Restored");
	  }     
  	  break;
     
      case 1:		/* Save */
     
          if (track_cur != 0xff)
	      save_local_db();
          break;	

#ifdef RCDDB_SUPPORT
      case 2:		/* Download */
	  if (rcddb_download_data())
	       paint_new_disc(BrowTrackNo);
          break;	

      case 3:		/* Submit */
	  xforms_submit_data();
          break;	
#endif

       case 10:		/* Up / Down */  
       {  KeySym key = xforms_get_last_key();
          u_short  shift = get_kbd_shift() & ShiftMask;
	  
          if (key == XK_Up)
	      data_advance_browser(-1, shift);
	  else
	  if (key == XK_Down)   /* Could be avoided */
	      data_advance_browser(1, shift);
       }	      
          break;	

       case 11:		/* PgUp / PgDn	 */   	
       {  int sl = fl_get_browser_screenlines
                  (xforms_fd->data_browser[ActiveBrowIndex]);
          KeySym key = xforms_get_last_key(); 
          u_short  shift = get_kbd_shift() & ShiftMask;
        
	  if ( key == XK_Prior)
	      data_advance_browser(-sl, shift);
	  else	  
	  if ( key == XK_Next)
	      data_advance_browser(sl, shift);
          break;	

       }
	  break;
       case 12:		/* Home / End	 */   	
       {  KeySym key = xforms_get_last_key();
          u_short  shift = get_kbd_shift() & ShiftMask;
          FL_OBJECT *brow = xforms_fd->data_browser[ActiveBrowIndex^shift];       
          if (key == XK_Home)
	      data_set_browser(brow, 1);
	  else	  
          if (key == XK_End)
	      data_set_browser(brow, fl_get_browser_maxline(brow));
          break;	
       }

       case 20:		/* Toggle active */   	
         {  
	    short new_index = ActiveBrowIndex ^ 1;
	    FL_OBJECT *obj = xforms_fd->data_browser[new_index];
	    if (fl_get_browser_maxline(obj) <= 0) break;

	    ActiveBrowIndex = new_index;	       
	    data_show_active_browser();   
	  }       
	  break;
	       
       case 50:
     
       case 51:
        {  int line_no;
	   int prefset_cnt_old;
	   
      /*    u_short  shift = get_kbd_shift() & ShiftMask; */
	   long	 par1 = (par - 50);

 	 /*  if (obj != NULL) par1 |= shift; */
	   
	   obj = xforms_fd->data_browser[1];
	   prefset_cnt_old = cd_prefset_count;
	   if (par1)
	       line_no = delete_play_list_line(obj);
	   else	  
	       line_no = insert_play_list_line(obj, BrowTrackNo);
	          

           data_set_browser(obj, line_no+1-par1);
/*           accept_play_list(obj);     */

	   if(prefset_cnt_old != cd_prefset_count)
	   {   obj = xforms_fd->data_prefset_number;
	       fl_set_counter_bounds(obj, 1, cd_prefset_count);
	   }	       
	}   
	  break;      	       

	case 52:
	  /* A recursive call in a quite non-typical curcumstances */
	  data_button_callback(NULL, ActiveBrowIndex + 50);
	  break;        

	  /* Double click routine */
	/*
	case 54:
	case 55:
	  obj = xforms_fd->focus_btn;
	  if (!fl_get_button(obj, 1))
	  {  fl_set_button(obj, 1);
	     focus_btn_callback(obj, 0);
	  }       
	  data_button_callback(par-4);
	  break;
	*/  
     }

}    		
		    
static short change_prefset(short prefset_number)
{
    FL_OBJECT *obj;
    if (prefset_number < 0
        || prefset_number >= cd_prefset_count) return 0;

    cd_accept_prefset(prefset_number);
    
    obj = xforms_fd->data_browser[1];
    fill_play_list(obj);

    if (cur_plist_pos >= 0)
	data_set_browser(obj, cur_plist_pos+1);

    fl_set_input(xforms_fd->data_prefset_name, cd_current_prefset->name);
    fl_set_button(xforms_fd->data_track_toggle,
	                        cd_track_skipability(BrowTrackNo)); 
    data_input_callback(xforms_fd->data_track_toggle, 112);				

    return 1;    
}              

static void data_prefset_callback(FL_OBJECT *obj,  long par)
{
    KeySym key;
    int prefset_number;
    
    obj = xforms_fd -> data_prefset_number;
    
    prefset_number = fl_get_counter_value(obj) - 1;

    if (par == 102)
    {   key = xforms_get_last_key();
        par = (key == XK_F8) ? 103 : 104;
    }			

    if (par == 103)
    {
	if (prefset_number >= cd_prefset_count-1)    
	{ stupid_beep(); return; }
        
	prefset_number++;
	fl_set_counter_value(obj, prefset_number+1);
    }	
    else
    if (par == 104)
    {   if (prefset_number <= 0) 
        { stupid_beep(); return; }

        prefset_number--;
	fl_set_counter_value(obj, prefset_number+1);
    }    	

    change_prefset(prefset_number);

}

static void data_process_ctrl_t(void)
{	
    FL_OBJECT *obj;
    
    obj = fl_get_focus_object(MainFrm);
    if (obj->objclass != FL_INPUT) return;
    
    switch(obj->argument)
    {
	case 0:
	    obj = xforms_fd->data_title_toggle;
	    break;
	    
	case 1:	    
	    obj = xforms_fd->data_artist_toggle;
	    break;

	case 2:	    
	    obj = xforms_fd->data_track_toggle;
	    break;

	case 3:	    
	    obj = xforms_fd->data_extra_toggle;
	    break;
	    
	    
	default:
	    return;
    }	    	    

    fl_set_button(obj, fl_get_button(obj) ^ 1);
    data_input_callback(obj, obj->argument);

}

static void data_input_callback(FL_OBJECT *obj,  long par)
{   char  *info_data = NULL;
    short bottom_focus;
    short browser_line_change = 0;
    short window_titles_change = 0;
    short form_title_change = 0;
    int   field_size;

    bottom_focus = fl_get_button(xforms_fd->focus_btn);
    field_size = DATA_NAME_SIZE;
    
    switch(par)
    {   case 0:		/* Title */
	  info_data = disc_name;
	  window_titles_change = (IconNameStyle == 'd');
	  form_title_change = 1;
/*	  if (bottom_focus)
	  { strncpy(disc_name, obj_data, DATA_NAME_SIZE);
	    set_form_title();
	    if (IconNameStyle == 'd') 
	      set_window_icon_name(disc_name);
	  }
	  else
	    strncpy(obj_data, disc_name, DATA_NAME_SIZE);
*/       
	  break;
	        
        case 1:			/* Artist */
	   if(fl_get_button(xforms_fd->data_artist_toggle))
	   {  info_data = (char *)cdaudio_get_track_artist(BrowTrackNo);
	      window_titles_change = 1;
	      browser_line_change = 1;
	   }	      
	   else	     
    	   {  info_data = disc_artist;	   
	      form_title_change = 1;
	   }	      
	   
/*
      	  if (bottom_focus)
	  {  strncpy(info_data, data, DATA_NAME_SIZE);

	     set_form_title();
	     if (IconNameStyle == 'a') 
	        set_window_icon_name(disc_artist);
	  }
	  else
	    strncpy(data, info_data, DATA_NAME_SIZE);
*/       
	  break;
	        
	case 2:			/* Track no */
           info_data = (char *)cdaudio_get_track_name(BrowTrackNo);
	   window_titles_change = 1;
	   browser_line_change = 1;
/*
        { char *trk_name_ptr = (char *)cdaudio_get_track_name(BrowTrackNo);
	  if (bottom_focus)
	  {  strncpy(trk_name_ptr, data, DATA_NAME_SIZE);
             fl_set_object_label(xforms_fd->track_name, trk_name_ptr);
	     fl_replace_browser_line(xforms_fd->data_browser[0], 
	                          BrowTrackNo+1-track_first, trk_name_ptr);
  	     if (IconNameStyle == 't' && BrowTrackNo == track_cur)
	         set_window_icon_name(trk_name_ptr);
	  }
	  else
	    strncpy(data, trk_name_ptr, DATA_NAME_SIZE);
	  	 
	}     
*/	
	  break;

        case 3:			/* Extra */
	   info_data = fl_get_button(xforms_fd->data_extra_toggle) ?
		      (char *)cdaudio_get_track_extra(BrowTrackNo) :
		      disc_extra;
	   field_size = EXTRA_NAME_SIZE;		      
	   break;
	   	        
        case 4:			/* Prefset name */
	   info_data =  cd_current_prefset->name;
	   field_size = PREFSET_NAME_SIZE;
	   break;


	case 10:
	case 110:		/* Single/multi artist toggle */
	  cd_multi_artist = fl_get_button(obj);
	  if (cd_multi_artist)
	  {  fl_set_object_label(obj,  "Multi");    
	     fl_set_object_boxtype(obj,FL_DOWN_BOX);
	     obj = xforms_fd->data_artist_toggle;
	     if (!fl_get_button(obj))
	     {    fl_set_button(obj, 1);
		  data_input_callback(obj,  11);
	     }	  
	     fl_activate_object(obj);
	  }
	  else     
	  {  fl_set_object_label(obj,  "Single");    
	     fl_set_object_boxtype(obj,FL_FRAME_BOX);
	     obj = xforms_fd->data_artist_toggle;
	     if (fl_get_button(obj))
	     {    fl_set_button(obj, 0);
		  data_input_callback(obj,  11);
	     }	  
	     fl_deactivate_object(obj);
	  }
	  if (par < 100) DataChanged = 1;
	  return;	 
	 
	 
	case 11:		/* Artist toggle */
	  if (fl_get_button(obj))
	  {  fl_set_object_label(obj,  "Track");    
	     info_data = (char *)cdaudio_get_track_artist(BrowTrackNo);
	  }
	  else     
	  {  fl_set_object_label(obj,  "Disc");    
	     info_data = disc_artist;
	  }
	  bottom_focus = 0;
	  obj = xforms_fd->data_artist_input;
	  break;	  

	case 112:
	case 12:		/* Play/Skip toggle */
	{ int flag = fl_get_button(obj);
	  if (par < 100 &&
	      !cd_set_track_skipability(BrowTrackNo, flag))
	      fl_set_button(obj, 1-flag);
	  else
	  if (flag) 
	  {  fl_set_object_label(obj,  "Skip");    
	     fl_set_object_boxtype(obj,FL_DOWN_BOX);
	  }
	  else     
	  {  fl_set_object_label(obj,  "Play");    
	     fl_set_object_boxtype(obj,FL_FRAME_BOX);
	  }
	}	  
	  return;	  

	case 13:		/* Extra toggle */
	  if (fl_get_button(obj))
	  {  fl_set_object_label(obj,  "Track");    
	     info_data = (char *)cdaudio_get_track_extra(BrowTrackNo);
	  }
	  else     
	  {  fl_set_object_label(obj,  "Disc");    
	     info_data = disc_extra;
	  }
	  bottom_focus = 0;
	  field_size = EXTRA_NAME_SIZE;
	  obj = xforms_fd->data_extra_input;
	  break;	  
	  
	  
       case 20:			/* Ctrl+T */
          data_process_ctrl_t();
	  return;		 
    }
    
    if (!info_data) return;
    
    if (bottom_focus)
    {   strncpy(info_data, (char *) fl_get_input(obj), field_size);
        DataChanged = 1;
	if (browser_line_change)
	{    fl_replace_browser_line(xforms_fd->data_browser[0], 
                  BrowTrackNo+1-track_first, get_full_track_name(BrowTrackNo));
	    correct_play_list(xforms_fd->data_browser[1], BrowTrackNo);
	}	    
	if (window_titles_change) set_window_titles();		
	if (form_title_change) set_form_title();
    }	
    else
	fl_set_input(obj, info_data);
		
}	


static void adjust_shortcuts(int focus)
{   u_int shift = 0;
    u_int  i, j;
    u_int sc_len;
    FL_OBJECT *obj;

    if (focus)
       shift =  (BottomSection == FOLDER_DATA) ? 2 :
#ifdef RCDDB_SUPPORT
		(BottomSection == FOLDER_RCDDB) ? 6 :
#endif		
		                             4;
       
    for (i=0; i<ManagedCtrlCount; i++)       
    {  obj =  ManagedCtrlStruct[i].obj;
       sc_len = ( ManagedCtrlStruct[i].flag >> shift ) & 3;
       fl_set_object_shortcut(obj, "", 0);
       for (j=0; j<sc_len; j++)
           fl_set_object_shortcutkey(obj, ManagedCtrlStruct[i].scuts[j]);
    }            	
}

static void focus_btn_callback(FL_OBJECT *obj, long par)
{   int focus;

    focus = fl_get_button(obj);
    
    if (focus) 
    {
#if FL_INCLUDE_VERSION < 86
      fl_set_object_label(obj, "@#2->");
#else
      fl_set_object_label(obj, "@-22->");
#endif      
      if (BottomSection == FOLDER_DATA &&
          fl_get_focus_object(MainFrm) == NULL)
	     fl_set_focus_object(xforms_fd->mainFrm, xforms_fd->data_title_input);

#ifdef RCDDB_SUPPORT
      if (BottomSection == FOLDER_RCDDB &&
          fl_get_focus_object(MainFrm) == NULL)
	     fl_set_focus_object(MainFrm, xforms_fd->user_addr);
#endif	     
    }
    else 
    {
#if FL_INCLUDE_VERSION < 86
      fl_set_object_label(obj, "@#8->");
#else
      fl_set_object_label(obj, "@-28->");
#endif      
      fl_set_focus_object(MainFrm, NULL);

      if (BottomSection == FOLDER_DATA)
	    adjust_data_browsers();

    }  
    
    adjust_shortcuts(focus);
}


void folder_btn_callback(FL_OBJECT *obj, long par1)
{
    
    static int old_height = 157;
    register long par = par1;
    FL_COORD x, y, w, h, x1, y1, w1, h1, hn; 
    XSizeHints xsh;


    fl_set_focus_object(MainFrm, NULL);
    disable_tooltip();

    if (par < 0)
    {  par = (BottomSection + par + FOLDER_BUTTONS + 2) % FOLDER_BUTTONS;
       if (!audio_supported && par < FOLDER_DATA)
          par = (BottomSection == FOLDER_NONE) ? FOLDER_DATA : FOLDER_NONE;

       obj = xforms_fd->folder_btn[par];
       fl_set_button(xforms_fd->folder_btn[BottomSection], 0);	 
       fl_set_button(obj, 1);	
       
    }   

    if (BottomSection == par) return;

    hide_folder_controls(BottomSection, par, 1);

    if (BottomSection == FOLDER_NONE || par == FOLDER_NONE)
    {	

       fl_get_wingeometry(MainWnd, &x, &y, &w, &h);
       fl_get_object_geometry(obj, &x1, &y1, &w1, &h1);
       hn = y1+h1+2;

       if (par==FOLDER_NONE)
       {   old_height = h-hn;
	   hn += 10;
       }    
      else 
    	   hn += old_height;
       

       if (par == FOLDER_NONE)
       {
	  xsh.max_height = 
          xsh.min_height = hn;  /*HEIGHT_NOBOTTOM; */
       }	  
       else		 
       {
          xsh.max_height = MAX_HEIGHT;
          xsh.min_height = MIN_HEIGHT;
    	  if (hn < MIN_HEIGHT) hn = MIN_HEIGHT;
       }

       	
       if (h!=hn)
          fl_winresize(MainWnd, w, hn);
       	
       if (par1 < 0 && par == FOLDER_NONE )	
       { int x2, y2;
         unsigned keymask;
	 
         fl_get_mouse(&x2, &y2, &keymask);
	 if (y2 >= (y + hn))
	   fl_set_mouse(x + x1+w1/2, y+y1+h1/2);
	      
       }	 	


       xsh.max_width = MAX_WIDTH;
       xsh.min_width  = 491;
       xsh.flags = PMinSize | PMaxSize;
       XSetWMNormalHints(disp, MainWnd, &xsh);

/*       fl_set_object_resize(obj, FL_RESIZE_ALL); */
       	  
    }       

    show_folder_controls(BottomSection,  par);
    
    if (par == FOLDER_DATA)
    {	 fl_set_focus_object(MainFrm, NULL);
	 ActiveBrowIndex= 0;
	 data_show_active_browser();
         adjust_data_browsers();
    }			

    BottomSection = par;

    if (par < FOLDER_DATA || par == FOLDER_NONE)
	   adjust_shortcuts(0);
    else
           focus_btn_callback(xforms_fd->focus_btn, 0);

    fl_redraw_form(MainFrm);

#if FL_INCLUDE_VERSION > 88
   if (BottomSection >= FOLDER_HELP && BottomSection <= FOLDER_MISC)
	     help_refresh_canvas();
#endif

/*    XFlush(disp); */

    
   
}

void set_bottom_section(short NewSection)
{
    if (NewSection<0 || NewSection >= FOLDER_BUTTONS) return;

#if def ICON_WINDOW_SUPPORT
    if (MainWnd == None)
    { 	
#ifdef DSP_SUPPORT
        if (IconWnd != None)
	{ if (BottomSection < FOLDER_DATA &&
	       NewSection >= FOLDER_DATA  ) init_icon_nonaudio();    
	  else
	  if (BottomSection >= FOLDER_DATA &&
	      NewSection < FOLDER_DATA)
	  { int i;
	    for (i=0; i<FourWndCount; i++)               
	        clear_icon_spectrum(i);		
	  }
	}

#endif
	BottomSection = NewSection;
    }
    else       
#endif    
    {   FL_OBJECT *obj = xforms_fd->folder_btn[NewSection];
	fl_set_button(obj, 1);
        folder_btn_callback(obj, obj->argument);
    }	

}



/*
#define SK_LEFT_SHIFT   1
#define SK_RIGHT_SHIFT  2
#define SK_LEFT_W95     4
#define SK_RIGHT_W95    8
#define SK_POPUP       16

static int shift_key(void)
{ // May not work on a non-PC keyboard 

   char keymap[32];
   int ret=0;       
//   int i; 
       	
   XQueryKeymap(disp, keymap);
//	for (i=0; i<32; i++)
//	    printf ("%2x ", keymap[i]);
//	printf ("\n");	    

   if (keymap[6] & 4)     re |= SK_LEFT_SHIFT;
   if (keymap[7] & 0x40)  ret |= SK_RIGHT_SHIFT;
   if (keymap[14] & 8)    ret |= SK_LEFT_W95;
   if (keymap[14] & 0x10) ret |= SK_RIGHT_W95;
   
    return ret;
}   

static int shift_browser_pos(int shift, long key)
{   FL_OBJECT *obj = NULL;	
    if (shift & SK_LEFT_SHIFT) obj = xforms_fd->browser_header;
    else
    if ((shift & SK_RIGHT_SHIFT) || (shift & SK_LEFT_W95))
                 obj = xforms_fd->browser_lines;
    
    if (obj) return advance_browser(obj, key);
    
    return 0;
}
*/

 /* CALLBACK FUNCTIONS  */
#ifdef MIXER_SUPPORT
static void mixer_btn_callback(FL_OBJECT *obj, long par)
{ 

    switch(par)
    {

	  case OPER_MIXERNEXT:
     		mixer_accept_next_device();
     		break;

	  case OPER_MIXERPREV:
		mixer_accept_prev_device();
     		break;

    
	  case OPER_INPUT:
/*     fl_set_button(obj, (MixerCurDevMask & MixerRecsrc) ? 1: 0); */
    		mixer_toggleinput();
		break;

    }
} 
#endif

static void mixer_dial_callback(FL_OBJECT *obj, long par)
{   
    u_char vol = volume;
    u_char bal = balance;

    
    switch(par)
    { case 0:  
	  vol = (u_char) fl_get_dial_value(obj);
	  break;
	  	 
      case 1:	 
	  bal = (u_char) (fl_get_dial_value(obj) + 50);
	  break;
	  
      case 10:
          if (vol > 0) vol--;
	  break;
	  
      case 20:
          if (vol < 100) vol++;
	  break;
	  
      case 11:
          if (bal > 0) bal--;
	  break;
	  
      case 21:
          if (bal < 100) bal++;
	  break;
    }	  
             	  
     mixer_setvolume ( vol, bal);
     if (SaveMixer) DataChanged = 1;
 
}


static void btn_callback(FL_OBJECT *obj, long par)
{ 
    
    cdaudio_operate((OPERATION)par); 
} 

static void xforms_accept_play_mode(void)
{   cd_accept_play_mode();
    if (PlayMode == PLAY_LIST)
        data_set_browser(xforms_fd->data_browser[1],
 		  	     cur_plist_pos+1);	
}

void misc_callback(FL_OBJECT *obj, long par)
{  int i, id;
   
   switch(par)
    { 
    
      case OPER_TIMEDISPLAY-100:
	    TimeDisplayMode = (TimeDisplayMode+7) % 4;
	    par = OPER_TIMEDISPLAY;
	    OptionsChanged = 1;    			     
	    break;
    
      case OPER_TIMEDISPLAY+100:
	    TimeDisplayMode = (TimeDisplayMode+1) % 4;
	    par = OPER_TIMEDISPLAY;
	    OptionsChanged = 1;    			     
	    break;

      case OPER_TIMEDISPLAY:
	    id = xforms_fd->time_disp_id;
	    fl_setpup_selection(id, TimeDisplayMode+1);
	    i = fl_dopup(id) - 1;
	    if (i < 0) return;
	    TimeDisplayMode = i;
	    OptionsChanged = 1;    			     
	    break;  

      case OPER_PLAYMODE-100:
	    PlayMode = (PlayMode+9)% 5;
	    xforms_accept_play_mode();
	    par = OPER_PLAYMODE;
	    OptionsChanged = 1;    			     
	    break;
    
      case OPER_PLAYMODE+100:
	    PlayMode = (PlayMode+1) % 5;
	    xforms_accept_play_mode();
	    par = OPER_PLAYMODE;
	    OptionsChanged = 1;    			     
	    break;

       case OPER_PLAYMODE:	    
	    id = xforms_fd->play_mode_id;
	    fl_setpup_selection(id, PlayMode+1);
	    i = fl_dopup(id) - 1;
	    if (i < 0) return;
	    PlayMode = i;
	    xforms_accept_play_mode();
	    OptionsChanged = 1;    			     
	    break;  
    
       case OPER_REFRESH:	    
            redraw_screen();
	    return;

       case OPER_SUSPEND:
	    set_suspend_mode(fl_get_button(obj));
	    return;
	    
       case OPER_SAVEO:
            save_settings();
	    return;		    

#ifdef USE_CHANGER
       case OPER_CHANGESLOT:
           i = fl_get_counter_value(xforms_fd->slot_counter)-1;
	   if (i==cd_slot_current)
	   { if(i==cd_slot_count-1) i=0;
	     else
	     if(i==0) i=cd_slot_count-1;
             fl_set_counter_value(xforms_fd->slot_counter, i+1);
	   }    	     
	       
	   select_slot(i);
	   return;
	   
       case OPER_CHANGESLOT+100:
           i = fl_get_counter_value(xforms_fd->slot_counter);
	   if (xforms_get_last_key()=='O')
	   { if (i<=1) i = cd_slot_count; else i--; }
	   else
	   { if (i>= cd_slot_count) i=1; else i++; }
	     if (select_slot(i-1))
               fl_set_counter_value(xforms_fd->slot_counter, i);
	   return;
#endif
    }
   
    show_mode (par);
}    	    


#ifdef DSP_SUPPORT

/*
#define SPECTRUM_PATTERN_WIDTH  80
#define SPECTRUM_PATTERN_HEIGHT 132
static int create_spectrum_pmp(void)
{	
  int w, h, w1, h1;


  w = SPECTRUM_PATTERN_WIDTH;
  h = SPECTRUM_PATTERN_HEIGHT; 	
  w1 = 64; h1 = 46;
	
  BkgrPmp = XCreatePixmap(disp, MainWnd, w, h, ScreenD);		
  if (BkgrPmp == None) return 0;

  XSetForeground(disp, spectr_gc, 0);
  XFillRectangle(disp, BkgrPmp, spectr_gc,  0, 0, w, h);

  XCopyArea(disp, DimPmp, BkgrPmp, spectr_gc, 0,0, w1, h1, 0, 0);
  XCopyArea(disp, DimPmp, BkgrPmp, spectr_gc, w1/2,0, w1/2, h1, 0, h/2);
  XCopyArea(disp, DimPmp, BkgrPmp, spectr_gc, 0, 0, w1/2, h1, w-w1/2, h/2);
  return 1;
}


static void tile_spectrum_pmp(Window win, int fill_type, 
			int left, int top, int width, int height)
{
  unsigned long  masks[4] = {0xffff,  0xf800, 0x7e0, 0x1f};
  XGCValues xgcv;
  int  x, y, w, h, w1, h1, x1, y1, bottom, right;
  
//  xgcv.plane_mask = masks[fill_type];
//  XChangeGC(disp, spectr_gc, GCPlaneMask, &xgcv);
  
  bottom = top + height;
  right = left + width;

   for (y = top, y1 = top % SPECTRUM_PATTERN_HEIGHT;
       y<bottom;    y+= h, y1 = 0) {

	h = SPECTRUM_PATTERN_HEIGHT - y1;
	h1 = bottom - y; if (h1 < h) h = h1;
		
	for (x=left, x1 = left % SPECTRUM_PATTERN_WIDTH; 	
		 x < right;  x+= w, x1 = 0) {

	  w = SPECTRUM_PATTERN_WIDTH - x1;
	  w1 = right - x; if (w1 < w) w = w1;

	  XCopyArea(disp, BkgrPmp, win, spectr_gc, x1, y1, w, h, x, y);
	}
  }
  

}			
*/

static void clear_spectrum_wnd(Window win, int win_width, int win_height) 
{     XGCValues xgcv;


      xgcv.foreground = (DimPmp == None) ? BgCol : spectr_colour[0]; 
      xgcv.fill_style = FillSolid;
      XChangeGC(disp, spectr_gc,  GCFillStyle | GCForeground, &xgcv);
      XFillRectangle(disp, win, spectr_gc, 0, 0, win_width, win_height);

      if (DimPmp != None)	
      { int x, y, strt;
        for (y=strt=0; y<win_height; y+=66) 
        { for (x=strt; x<win_width; x+=80)
	    	 XCopyArea(disp, DimPmp, win, spectr_gc, 0,0, 64, 50, x, y);
		  strt = -42-strt;
        }	       
      }	

      if (StippleBmp == None) xgcv.fill_style = FillSolid;
	                   else   xgcv.fill_style = FillStippled;
      xgcv.foreground = spectr_colour[0];
      XChangeGC(disp, spectr_gc, GCFillStyle | GCForeground,  &xgcv);
      XFillRectangle(disp, win, spectr_gc, 0, 0, win_width, win_height);
}

/*
static void clear_spectrum_wnd(Window win, int width, int height)
{
;
//  tile_spectrum_pmp(win, 0, 0, 0, width, height);

}
*/

static void clear_spectrum(int i, int win_width, int win_height) 
{     Window  win;

     	
      win = fl_get_canvas_id(xforms_fd->spectrum[i]);

      clear_spectrum_wnd(win, win_width, win_height);

#ifdef ICON_WINDOW_SUPPORT
      if (IconWnd != None) clear_icon_spectrum(i);		
#endif      

}



static void accept_resize_spectrum(int win_width, int win_height) 
{
    FourWndHei = win_height;


    if (FourWndWid == win_width) return;

    FourWndWid = win_width;

    FourWndDiscrWid = (FourWndWid+FourWndRes-1)/FourWndRes;
     
    if (FourWndCount >= 2)
    {   FL_COORD  x, y, w, h;
		FL_OBJECT *obj = xforms_fd->spectrum[1];

	    fl_get_object_geometry(obj, &x, &y, &w, &h);

	if (w != FourWndWid)
	    fl_hide_object(obj);
	
	{
	    x = MainFrm->w - FourWndWid - 18;
        fl_set_object_geometry(obj, x, y, FourWndWid, h);
	}
	
		if (BottomSection < FOLDER_DATA && !obj->visible)
	      fl_show_object(obj);
    }	
	
    
}    	

static int spectrum_callback(FL_OBJECT *obj, Window win, 
		      int win_width, int win_height,
		      XEvent *xev, void *user_data)
{   int evtype = xev->type;	 		      


    if (evtype != Expose || xev->xexpose.count <= 0 )
    {

//       if (evtype == ConfigureNotify)
//		  accept_resize_spectrum(win_width, win_height);

       clear_spectrum_wnd(win, win_width, win_height);
             
#ifdef ICON_WINDOW_SUPPORT
      if (IconWnd != None) clear_icon_spectrum(obj->argument);		
#endif	  
    }   	
    
    return 0;
}    
#endif

static void progress_bar_callback(FL_OBJECT *obj, long par)
{  long starting_point, duration;
   OPERATION oper;    
   long progress;
 
   progress = (long) fl_get_slider_value(obj); 

   if (par)
   {  starting_point =  time_start;
      duration = time_total - time_start;
      oper = OPER_PLAYFROMALIGNED;
   }
   else
   {  starting_point =  track_time_start;
      duration = track_time_end - track_time_start;
      oper = OPER_PLAYFROM;
   }
   
   time_req = (progress * duration / 100) + starting_point;
   reposition = 1;    
   cdaudio_operate(oper); 
   reposition = 0;    

}


/* ================================================================ */
void show_progress(long elapsed, long duration, int ind)
{
    u_char mins, secs, frm;
    u_int progress; /*, old_progress; */
    char text[14];


    if (duration <= 0)
    {   progress = 0;
        strcpy(text, "");
	goto ShowIt; 
    }
    	
    if (elapsed > duration) elapsed = duration;

         
    switch(TimeDisplayMode)
   {  case DM_ELAPSED:   
	    time_to_msf(elapsed, &mins, &secs, &frm);
	    sprintf(text,"  %02u:%02u.%d",(u_int)mins, (u_int)secs, 10*frm/75);
	    break;

      case DM_REMAINED:  
	    time_to_msf(duration-elapsed, &mins, &secs, &frm);
	    sprintf(text,"<%02u:%02u.%d>",(u_int)mins, (u_int)secs, 10*frm/75);
	    break;

      case DM_PROGRESS:  
	    progress =  elapsed * 1000 / duration;
	    sprintf(text,"   %3u.%01u%%",  progress/10, progress%10 );
            break;

      case DM_PROGREM:  
	    progress =  (duration-elapsed) * 1000 / duration;
            sprintf(text," <%u.%01u%%>", (progress/10), progress%10  );
            break;


      default:
	    sprintf (text, "     DM = %d", TimeDisplayMode); 
    }


    progress = (u_long) 100 * elapsed / duration; 

ShowIt:
    fl_set_object_label(xforms_fd->time_current_box[ind], text);
#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None) show_icon_progress(elapsed, duration, ind);
#endif    
    fl_set_slider_value(xforms_fd->progress_bar[ind], progress); 

}

static void show_track_total(long duration, int ind)
{	char text[8];

	u_char mins, secs, frm;
       

	if (duration < 0)
	   strcpy(text, "       ");
	else
	{  time_to_msf(duration, &mins, &secs, &frm);
	   sprintf(text, "%02u:%02u.%d",(u_int)mins, (u_int)secs,
                                           (u_int)(frm*10/75));
	}

        fl_set_object_label(xforms_fd->time_total_box[ind], text);

}

void draw_digit(short ind, short dig)
{
      XCopyArea(disp, DigitPmp, TrkPmp[ind], spectr_gc, 0,
	                         (9-dig)*21, 11, 21, 3, 3);
      fl_redraw_object(xforms_fd->obj_digit[ind]);		     
}

void draw_track_number(short track)
{
    draw_digit(0, track / 10);
    draw_digit(1, track % 10);
#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None) draw_icon_track_number(track);
#endif    
}    

static void paint_new_disc(short track_no)
{
     FL_OBJECT *obj;
     int  i;

     obj = xforms_fd->data_browser[0];
     
     if (fill_track_list(obj))
     { 
        fl_set_input(xforms_fd->data_title_input,  disc_name);
	fl_set_input(xforms_fd->data_artist_input,  disc_artist);
	fl_set_input(xforms_fd->data_extra_input,  disc_extra);
	fl_set_input(xforms_fd->data_prefset_name,  cd_current_prefset->name);

        if (BottomSection == FOLDER_DATA)
	    fl_show_object(xforms_fd->focus_btn);
        for (i=0; i<DataControlsCount; i++)
           fl_activate_object(DataControls[i]);
	
		data_set_browser(obj, track_no+1-track_first);
        fl_set_button(xforms_fd->data_title_toggle, cd_multi_artist ? 1: 0);
        data_input_callback(xforms_fd->data_title_toggle, 110);
     }
     else
     { 
		fl_set_input(xforms_fd->data_prefset_name,  "");
		fl_set_input(xforms_fd->data_title_input,  "");
		fl_set_input(xforms_fd->data_artist_input,  "");
        data_browser_callback(obj, 4);
        if (BottomSection == FOLDER_DATA)
            fl_hide_object(xforms_fd->focus_btn);
        for (i=0; i<DataControlsCount; i++)
           fl_deactivate_object(DataControls[i]);
     }
     
     obj = xforms_fd->data_browser[1];
     fill_play_list(obj);
     data_set_browser(obj, 1);

    obj = xforms_fd->data_prefset_number;
	fl_set_counter_bounds(obj, 1, cd_prefset_count);
    fl_set_counter_value(obj, 1);
	set_form_title();

#ifdef ICON_WINDOW_SUPPORT
	if (IconWnd != None) clear_icon_top();
#endif
  return;
}

static void accept_new_disc(void)
{    char tmp_tracks[4]; 

#ifdef USE_CHANGER
    { FL_OBJECT *obj = xforms_fd->slot_counter;
      if (obj->visible)
      	fl_set_counter_value(obj, cd_slot_current+1);
      OldSlotNo = cd_slot_current;	
    }
#endif
   
     show_track_total(time_total-time_start, 1);
     sprintf(tmp_tracks, "%02d ", track_first);
     fl_set_object_label(xforms_fd->first_track_box, tmp_tracks);
     sprintf(tmp_tracks, "%02d ", track_last);
     fl_set_object_label(xforms_fd->last_track_box, tmp_tracks);
     fl_show_object(xforms_fd->time_label[0]);
     fl_show_object(xforms_fd->time_label[1]);
     
     paint_new_disc(track_cur);
}


static void set_window_titles(void)
{
    const char *trk_name;
    
    trk_name = get_full_track_name(track_cur);
    fl_set_object_label(xforms_fd->track_name, trk_name);

    if (IconNameStyle == 't')
         trk_name = cdaudio_get_track_name(track_cur);
    else	 
    if (IconNameStyle == 'd') 
         trk_name = disc_name;
    else
    if (IconNameStyle == 'a')
       trk_name = get_current_artist(track_cur);
	  
     
    if (IconNameStyle != 'n' && strlen(trk_name))
	set_window_icon_name(trk_name);
    else 
    { char trk_name1[41];
         sprintf (trk_name1, "%s [%02d]", DefaultIconName, track_cur);
         set_window_icon_name(trk_name1);
    }	  
}    

void show_cd_time(void)
{

    long elapsed, duration;

    if ((MainWnd == None) || reposition) return;

    elapsed = time_cur - track_time_start;
    duration = track_time_end - track_time_start;

    if (track_cur != OldTrackNo 
#ifdef USE_CHANGER    
	    || cd_slot_current != OldSlotNo
#endif	 
	)
    {  show_track_total(duration, 0);  
	  

       if (track_cur != 0xff )
       {
	  
          if (OldTrackNo == 0xff
#ifdef USE_CHANGER    
	    || cd_slot_current != OldSlotNo
#endif	 
	     ) accept_new_disc();

          draw_track_number(track_cur); 
	
	  set_window_titles(); 
       }

       if (BottomSection == FOLDER_DATA) adjust_data_browsers();	   	              
       OldTrackNo = track_cur;
    }

    if (SuspendRefresh)
    {    long absdif = time_cur - old_position;	 	
	 if (absdif < 0) absdif = -absdif;
	 if (absdif < 70) return;
	 old_position = time_cur;
    }

    /* =============================================================== */
    /* Show relative track information */
    if (elapsed < 0) elapsed = 0;		/* Avoid bouncing effect */	
    show_progress(elapsed, duration, 0);

	

    /* =============================================================== */
    /* Show absolute track information */

    elapsed = time_cur - time_start;
    duration = time_total - time_start;
    if (elapsed < 0) elapsed = 0;		
    show_progress(elapsed, duration, 1);


}

void clear_cd_time(void)
{   int i;

    if (MainWnd == None) return;

    for (i=0; i<2; i++)
    {
        fl_set_object_label(xforms_fd->time_current_box[i], "");
        fl_set_object_label(xforms_fd->time_total_box[i], "");
        fl_hide_object(xforms_fd->time_label[i]);
    	fl_set_slider_value(xforms_fd->progress_bar[i], 0); 
    }	

    draw_digit(0, -1);
    draw_digit(1, -1);

    /* Clear tracks total */
    fl_set_object_label(xforms_fd->track_name, "");
    fl_set_object_label(xforms_fd->first_track_box, "");
    fl_set_object_label(xforms_fd->last_track_box, "");
    fl_set_form_title(MainFrm, DefaultAppTitle);   
    set_window_icon_name(DefaultIconName);

#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None) clear_icon_time();
#endif

    fl_clear_browser(xforms_fd->data_browser[0]);
    fl_clear_browser(xforms_fd->data_browser[1]);
    fl_set_input(xforms_fd->data_title_input, "");
    fl_set_input(xforms_fd->data_artist_input, "");
    fl_set_input(xforms_fd->data_track_input, "");
        
    OldTrackNo = 0xff;	 
    
    if (BottomSection == FOLDER_DATA)
    {  FL_OBJECT *obj = xforms_fd->focus_btn;
       if (fl_get_button(obj))
       {  fl_set_button(obj, 0);
          focus_btn_callback(obj, 0);
       }
       fl_hide_object(obj);

    }   	   

   for (i=0; i<DataControlsCount; i++)
       fl_deactivate_object(DataControls[i]);
}



    
void customize_managed_button(FL_OBJECT *obj, u_short flag,
			      KeySym sc1, KeySym sc2, KeySym sc3)
{

    ManagedCtrlStruct[ManagedCtrlCount].obj = obj;				      	
    ManagedCtrlStruct[ManagedCtrlCount].flag  = flag;				      	
    ManagedCtrlStruct[ManagedCtrlCount].scuts[0] = sc1;		      	
    ManagedCtrlStruct[ManagedCtrlCount].scuts[1] = sc2;		      	
    ManagedCtrlStruct[ManagedCtrlCount++].scuts[2] = sc3;		      	
}    


/* Flag: 0,1 - play control button (for historical reasons)
	 2 - help control button (always counted, for show/hide)
	 4 - use East gravity
*/	 
void customize_button(FL_OBJECT *obj, OPERATION oper, int flag)
{
   unsigned gravity;
       
   
   if (flag & 2)
   {  fl_set_object_callback(obj, help_btn_callback, oper);
      fl_set_object_lcolor(obj,FL_WHITE);
      gravity = (flag & 4) ? FL_SouthEast : FL_SouthWest;
      HelpControls[HelpControlsCount++] = obj;
   }
   else    
   {  fl_set_object_callback(obj, btn_callback, oper);
      gravity = (flag & 4) ? FL_NorthEast : FL_NorthWest;
   }
   
   fl_set_object_gravity(obj, gravity, gravity);
                     
   
}


SADP_XFORMS_ALL *create_form(void)
{
  FL_OBJECT *obj;
  SADP_XFORMS_ALL *fdui;
  int dial_boxtype;  
  int stat_box_x;
  int offx, offy;    

  ManagedCtrlCount = 0;

  fdui = (SADP_XFORMS_ALL *) calloc(1, sizeof(SADP_XFORMS_ALL));
  MainFrm = fdui->mainFrm = fl_bgn_form(FL_NO_BOX, 528, 355); 
 
 /* Decorations */
 fdui->bkgr_box =
    obj = fl_add_box(FL_UP_BOX,0,0,528,355,"");     
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_EMBOSSED_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_SouthEast);

/* Background frames - left */
  obj = fl_add_box(FL_DOWN_BOX,14,10,96,141,"");
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);


 fdui->track_name =
  obj = fl_add_box(FL_EMBOSSED_BOX,118,10,291,22,"");
    fl_set_object_lstyle(obj,FL_EMBOSSED_STYLE | FL_TIMESBOLD_STYLE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthEast);



 /* Play buttons */
  fdui->back_btn =    
    obj = fl_add_button(FL_TOUCH_BUTTON,118,84,34,20, "@4fwd");
    set_tooltip(obj, "Back in track");
    customize_button(obj, OPER_BACK, 1);
    customize_managed_button(obj, 3, XK_Left, XK_4, XK_KP_Left); 
				/* 3 - topfocus, 0-data focus, 0 - help focus */

  fdui->prev_btn =    
    obj = fl_add_button(FL_TOUCH_BUTTON,118,48,34,20, "@4next");
    set_tooltip(obj, "Previous track");
    customize_button(obj, OPER_PREV, 1);
    customize_managed_button(obj, 3, XK_Up, XK_8, XK_KP_Up); 

  fdui->prev5_btn =    
    obj = fl_add_button(FL_NORMAL_BUTTON,119,120,34,20,"@4skip");
    set_tooltip(obj, "5 tracks back");
    customize_button(obj, OPER_PREV5, 0);
    customize_managed_button(obj, 3, XK_Prior, XK_9, XK_KP_Prior); 

  fdui->firsttrack_btn =    
    obj = fl_add_button(FL_NORMAL_BUTTON,162,120,34,20,"@first"); 
    set_tooltip(obj, "First track");
    customize_button(obj, OPER_FIRSTTRACK, 1);
    customize_managed_button(obj, 3, XK_Home, XK_7, XK_KP_Home); 

/*
  fdui->pause_btn =  
    obj = fl_add_button(FL_NORMAL_BUTTON,196,120,34,20,"="); 
    set_tooltip(obj, "Pause/Resume");
    customize_button(obj, OPER_PAUSE, 1);
    customize_managed_button(obj, 3, XK_Begin, XK_5, XK_KP_Begin);  */

  fdui->play_btn = 
    obj = fl_add_button(FL_NORMAL_BUTTON,196,120,34,20,"@play"); 
    set_tooltip(obj, "Play");
    customize_button(obj, OPER_PLAY, 1);
    customize_managed_button(obj, 1, XK_space, 0, 0); 
			   /* 1 - topfocus, 0-data focus, 0 - help focus */


  fdui->stop_btn = 
    obj = fl_add_button(FL_NORMAL_BUTTON,230,120,34,20,"@stop");
    set_tooltip(obj, "Stop/Eject/Load");
    customize_button(obj, OPER_STOP, 1);
    customize_managed_button(obj, 3, XK_Insert, XK_0, XK_KP_Insert); 
				/* 3 - topfocus, 0-data focus, 0 - help focus */

 fdui->suspend_btn =
    obj = fl_add_button(FL_PUSH_BUTTON,264,120,34,20,"@suspend");
    set_tooltip(obj, "Suspend");
    fl_set_object_callback(obj,misc_callback,OPER_SUSPEND);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
//  fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_resize(obj,FL_RESIZE_NONE);
    customize_managed_button(obj, 0x22, XK_S, XK_s, 0); 
			   /* 2 - topfocus, 0-data focus, 2 - help focus */

 /* Refresh button */
  fdui->refresh_btn =    
    obj = fl_add_button(FL_NORMAL_BUTTON,298,120,34,20,"@refresh");
    set_tooltip(obj, "Refresh");
    fl_set_object_callback(obj,misc_callback,OPER_REFRESH);
//  fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 0x22, XK_R, XK_r, 0); 
			   /* 2 - topfocus, 0-data focus, 2 - help focus */


  fdui->lasttrack_btn =    
    obj = fl_add_button(FL_NORMAL_BUTTON,332,120,34,20,"@4first");
    set_tooltip(obj, "Last track");
    customize_button(obj, OPER_LASTTRACK, 1);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 3, XK_End, XK_1, XK_KP_End); 
			

  fdui->next5_btn =    
    obj = fl_add_button(FL_NORMAL_BUTTON,374,120,34,20,"@skip");
    set_tooltip(obj, "5 tracks forward");
    customize_button(obj,OPER_NEXT5, 4);
//    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 3, XK_Next, XK_3, XK_KP_Next); 
				/* 3 - topfocus, 0-data focus, 0 - help focus */

  fdui->fwd_btn =    
    obj = fl_add_button(FL_TOUCH_BUTTON,374,84,34,20, "@fwd");
    set_tooltip(obj, "Forward in track");
    customize_button(obj,OPER_FWD, 5);
//    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 3, XK_Right, XK_6, XK_KP_Right); 
    
  fdui->next_btn =    
    obj = fl_add_button(FL_TOUCH_BUTTON,374,48,34,20, "@next"); 
    set_tooltip(obj, "Next track");
    customize_button(obj,OPER_NEXT, 5);
//    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 3, XK_Down, XK_2, XK_KP_Down); 


   /*  - - -  - - - - -  TIME  BOXES   - - -  - - - - -  */

   /*-------------  Upper line -------------*/
  fdui->time_label[1] = 
    obj = fl_add_text(FL_NORMAL_TEXT,162,34,47,14,"DISC:");
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_North);

  fdui->time_total_box[1] = 
    obj = fl_add_text(FL_NORMAL_TEXT,242,34,47,14,"");
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_North, FL_North);

  fdui->time_current_box[1] = 
    obj = fl_add_text(FL_NORMAL_TEXT,315,34,55,14,"");
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->progress_bar[1] = 
    obj = fl_add_slider(FL_HOR_SLIDER,162,48,203,20,"");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_GREEN);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_slider_bounds(obj, 0, 100);
/*    fl_set_slider_return(obj, FL_RETURN_END_CHANGED); */
    fl_set_object_callback(obj,progress_bar_callback,1);
    fl_set_slider_size(obj, 0.09);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthEast);

   /*-------------  Lower line -------------*/
  fdui->time_label[0] = 
    obj = fl_add_text(FL_NORMAL_TEXT,162,70,47,14,"TRACK:");
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_North);

  fdui->time_total_box[0] = 
    obj = fl_add_text(FL_NORMAL_TEXT,242,70,47,14,"");
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_North, FL_North);

  fdui->time_current_box[0] = 
   obj = fl_add_text(FL_NORMAL_TEXT,315,70,55,14,"");
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->progress_bar[0] = 
    obj = fl_add_slider(FL_HOR_SLIDER,162,84,203,20,"");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_GREEN);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_slider_bounds(obj, 0, 100);
/*    fl_set_slider_return(obj, FL_RETURN_END_CHANGED);  */
    fl_set_object_callback(obj,progress_bar_callback,0);
    fl_set_slider_size(obj, 0.09);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthEast);


   /*  - - - - - - - -  MIXER FIELDS  - - -  - - - - -  */
  obj = fl_add_text(FL_NORMAL_TEXT,16,12,91,16,"MIXER");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_MCOL);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

  obj = fl_add_text(FL_NORMAL_TEXT,20,36,44,12,"Vol");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

  obj = fl_add_text(FL_NORMAL_TEXT,61,36,44,12,"Bal");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

#ifdef MIXER_SUPPORT
  if (mixer >= 0)
  {
  obj = fl_add_button(FL_TOUCH_BUTTON,20,120,20,20,"@<");
    fl_set_object_callback(obj,mixer_btn_callback,OPER_MIXERPREV);
    set_tooltip(obj, "Previous mixer device");
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x22, XK_comma, XK_less, 0); 
			   /* 2 - topfocus, 0-data focus, 2 - help focus */

  fdui->mixer_input_switch =
  obj = fl_add_checkbutton(FL_PUSH_BUTTON,40,100,45,16,"");
    fl_set_object_color(obj,SADP_BLACK,FL_SPRINGGREEN);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,mixer_btn_callback,OPER_INPUT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x22, XK_apostrophe, XK_quotedbl, 0); 
			   /* 2 - topfocus, 0-data focus, 2 - help focus */

  obj = fl_add_button(FL_TOUCH_BUTTON,84,120,20,20,"@>");
    set_tooltip(obj, "Next mixer device");
    fl_set_object_callback(obj,mixer_btn_callback,OPER_MIXERNEXT);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x22, XK_greater, XK_period, 0); 
			   /* 2 - topfocus, 0-data focus, 2 - help focus */
  }
#endif    
      

  fdui->mixer_sound_device =
  obj = fl_add_text(FL_NORMAL_TEXT,40,120,44,20,"");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,SADP_BLACK,FL_MCOL);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

//  dial_boxtype = (xforms_version >= 88) ? FL_UP_BOX : FL_DOWN_BOX;
#if FL_INCLUDE_VERSION >= 88
   dial_boxtype = FL_UP_BOX;
#else   
   dial_boxtype = FL_DOWN_BOX;
#endif   

  fdui->vol_dial =
  obj = fl_add_dial(FL_NORMAL_DIAL,20,50,42,42,"");
    set_tooltip(obj, "Volume control");
    fl_set_dial_return(obj, FL_RETURN_CHANGED);
    fl_set_object_boxtype(obj, dial_boxtype);
    fl_set_object_color(obj,SADP_BLACK,SADP_YELLOW);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_dial_bounds(obj, 0, 100);
    fl_set_dial_value(obj, 0);
    fl_set_object_callback(obj,mixer_dial_callback,0);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

  fdui->bal_dial =
  obj = fl_add_dial(FL_NORMAL_DIAL,62,50,42,42,"");
    set_tooltip(obj, "Balance control");
    fl_set_dial_return(obj, FL_RETURN_CHANGED);
    fl_set_object_boxtype(obj, dial_boxtype);
    fl_set_object_color(obj,SADP_BLACK,SADP_YELLOW);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_dial_bounds(obj, -50, 50);
    fl_set_dial_value(obj, 0);
    fl_set_object_callback(obj,mixer_dial_callback,1);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);

    obj = fl_add_button(FL_TOUCH_BUTTON,23,93,6,4,"-");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,mixer_dial_callback,10);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x11, (KeySym) '[', 0, 0); 
			   /* 1 - topfocus, 0-data focus, 1 - help focus */

    obj = fl_add_button(FL_TOUCH_BUTTON,52,93,6,4,"+");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,mixer_dial_callback,20);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x11, (KeySym) ']', 0, 0); 

    obj = fl_add_button(FL_TOUCH_BUTTON,66,93,6,4,"-");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,mixer_dial_callback,11);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x11, (KeySym) '{', 0, 0); 

    obj = fl_add_button(FL_TOUCH_BUTTON,95,93,6,4,"+");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,mixer_dial_callback,21);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    customize_managed_button(obj, 0x11, (KeySym) '}', 0, 0); 

/* ------------------------------------------------------------ */
/*           - - - -  STATUS (RHS) BOXES                       */

/* Status frame (tableau) */
   stat_box_x = 427;    

  obj = fl_add_box(FL_DOWN_BOX,stat_box_x-10,10,96,141,"");
//    fl_set_object_color(obj,FL_DARKVIOLET,FL_COL1);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  obj = fl_add_box(FL_DOWN_BOX,stat_box_x, 36,78,74,"");
  fl_set_object_color(obj,SADP_BLACK,FL_COL1);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->time_disp_btn =
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+7,41,25,8,"");
    set_tooltip(obj, "Time display mode");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, misc_callback, OPER_TIMEDISPLAY);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

   obj = fl_add_button(FL_TOUCH_BUTTON,stat_box_x+7,49,9,8,"<");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, misc_callback, OPER_TIMEDISPLAY-100);
    customize_managed_button(obj, 0x11, XK_T, 0, 0); 

  obj = fl_add_button(FL_TOUCH_BUTTON,stat_box_x+22,49,9,8,">");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, misc_callback, OPER_TIMEDISPLAY+100);
    customize_managed_button(obj, 0x11, XK_t, 0, 0); 

  fdui->play_mode_btn =
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+44,41,25,8,"");
    set_tooltip(obj, "Play mode");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_callback(obj, misc_callback, OPER_PLAYMODE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+44,49,9,8,"<");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_callback(obj, misc_callback, OPER_PLAYMODE-100);
    customize_managed_button(obj, 0x11, XK_P, 0, 0); 

  obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+59,49,9,8,">");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_lcolor(obj,FL_SPRINGGREEN);
    fl_set_object_callback(obj, misc_callback, OPER_PLAYMODE+100);
    customize_managed_button(obj, 0x11, XK_p, 0, 0); 

/* Track Number */
  fdui->obj_digit[0] =
     obj = fl_add_pixmap(FL_NORMAL_PIXMAP,stat_box_x+22,58,TrackWndWid,TrackWndHei,"");
     fl_set_object_lcolor(obj,SADP_BLACK);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->obj_digit[1] =
     obj = fl_add_pixmap(FL_NORMAL_PIXMAP,stat_box_x+37,58,TrackWndWid,TrackWndHei,"");
     fl_set_object_lcolor(obj,SADP_BLACK);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->auto_play_btn =
    obj = fl_add_button(FL_PUSH_BUTTON,stat_box_x+4,64,20,16,"AP");
    set_tooltip(obj, "Auto play On/OFF");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
/*    fl_set_object_align(obj,FL_ALIGN_LEFT | FL_ALIGN_INSIDE); */
    fl_set_object_color(obj,SADP_BLACK, SADP_BLACK);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, btn_callback, OPER_AUTOPLAY);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 0x22, XK_A, XK_a, 0); 

  fdui->loop_play_btn =
    obj = fl_add_button(FL_PUSH_BUTTON,stat_box_x+54,64,20,16,"LO");
    set_tooltip(obj, "Loop play On/OFF");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
/*    fl_set_object_align(obj,FL_ALIGN_CENTER | FL_ALIGN_INSIDE); */
    fl_set_object_color(obj,SADP_BLACK, SADP_BLACK);
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, btn_callback, OPER_LOOPPLAY);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 0x22, XK_L, XK_l, 0); 

/* Total tracks */
  fdui->first_track_box = 
    obj = fl_add_text(FL_NORMAL_TEXT,stat_box_x+5,92,24,12,"");
    fl_set_object_color(obj,SADP_BLACK, SADP_BLACK);
    fl_set_object_lcolor(obj,FL_INDIANRED);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  fdui->last_track_box = 
//    obj = fl_add_text(FL_NORMAL_TEXT,stat_box_x+50,92,24,12,"");
    obj = fl_add_text(FL_NORMAL_TEXT,stat_box_x+54,92,20,12,"");
    fl_set_object_color(obj,SADP_BLACK, SADP_BLACK);
    fl_set_object_lcolor(obj,FL_INDIANRED);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

/* Status box */
  fdui->cd_status_box =
    obj = fl_add_text(FL_NORMAL_TEXT,stat_box_x-2,120,80,20,"");
    fl_set_object_color(obj,SADP_BLACK, SADP_BLACK);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);

  obj = fl_add_text(FL_NORMAL_TEXT,stat_box_x-8,12,91,16,"STATUS");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,SADP_BLACK,SADP_BLACK);
    fl_set_object_lcolor(obj,SADP_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);



  /* - - - - - - - - - FOLDER GROUP - - - - - - - - */
  offx = 14;
  fl_bgn_group();
#ifdef DSP_SUPPORT
  if (!audio_supported) goto FolderNoaudio; 
  fdui->folder_btn[FOLDER_SPECTRUM] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx, 156, 34,20,"");
    set_tooltip(obj, "Spectrum analyser");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_SPECTRUM);
    fl_set_bitmapbutton_data(obj, 11, 10, spectr_bits);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    //    fl_set_button(obj, 1);
    offx += 34;

  fdui->folder_btn[FOLDER_WAVE] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Oscilloscope");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_WAVE);
    fl_set_bitmapbutton_data(obj,11, 10, wave_bits);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;
FolderNoaudio:
#endif
  fdui->folder_btn[FOLDER_DATA] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Disc data");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_DATA);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 11, 10, data_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;

#ifdef RCDDB_SUPPORT
  fdui->folder_btn[FOLDER_RCDDB] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Remote CD data bases");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_RCDDB);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 21, 10, rcddb_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;
#endif

  fdui->folder_btn[FOLDER_HELP] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Help");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_HELP);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 9, 10, help_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;

  fdui->folder_btn[FOLDER_STATUS] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Status information");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_STATUS);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 5, 10, info_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;

  fdui->folder_btn[FOLDER_MISC] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");
    set_tooltip(obj, "Miscellaneous");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_MISC);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 11, 10, misc_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);
    offx += 34;

  fdui->folder_btn[FOLDER_NONE] = 
    obj = fl_add_bitmapbutton(FL_RADIO_BUTTON,offx,156,34,20,"");  /* 218 */
    set_tooltip(obj, "Hide bottom panel");
    fl_set_object_callback(obj, folder_btn_callback, FOLDER_NONE);
    fl_set_object_gravity(obj,FL_NorthWest, FL_NorthWest);
    fl_set_bitmapbutton_data(obj, 3, 1, none_bits);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj, FL_WHITE);

    fl_end_group();

 /* Folder keyboard switch */
    obj = fl_add_button(FL_HIDDEN_BUTTON,0,0,0,0,"");
    fl_set_object_callback(obj, folder_btn_callback, -1);
    fl_set_object_shortcutkey(obj, XK_F1);

 /* Folder keyboard switch back */
    obj = fl_add_button(FL_HIDDEN_BUTTON,0,0,0,0,"");
    fl_set_object_callback(obj, folder_btn_callback, -3);
    fl_set_object_shortcutkey(obj, XK_F2);

   offx = 0;
#ifdef DSP_SUPPORT
   if (!audio_supported) goto NoDspWindows;    

   if (!stereo) { FourWndWid =  495;  FourWndCount=1;}
   offy = 192;
  /* - - - - - - - - - SPECRUM ANALYSER AND OSCILLOSCOPE - - - - - - - - */
   SpectrControlsCount = WaveControlsCount = 0;

   fdui->spectrum[0] = obj = fl_add_canvas(FL_NORMAL_CANVAS,17,offy,
                             FourWndWid, FourWndHei,"");        
   fl_set_object_gravity(obj,FL_NorthWest, FL_South);

   if (stereo_supported)    
   { fdui->spectrum[1] = obj = fl_add_canvas(FL_NORMAL_CANVAS,510-FourWndWid,
                                    offy, FourWndWid, FourWndHei,"");
     fl_set_object_gravity(obj,FL_North, FL_SouthEast);
	 if (FourWndCount < 2)   fl_hide_object(obj);
   }     
   else
	   fdui->spectrum[1] = NULL;

   offy += FourWndHei+14;    

    obj = fl_add_button(FL_HIDDEN_BUTTON, 231, offy+4, 10,10, ""); 
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "Ww", 0);
    fl_set_object_callback(obj, settings_callback, SET_BARWIDTH+1000);
    SpectrControls[SpectrControlsCount++] = obj; 

  fdui->set_spect_col_wid =
    obj = fl_add_counter(FL_SIMPLE_COUNTER,70, offy, 50,20,"Bar width:");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "w", 1);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_bounds(obj, BAR_MIN_WIDTH, BAR_MAX_WIDTH);
    fl_set_counter_step(obj, 1, 4);
    fl_set_object_callback(obj, settings_callback, SET_BARWIDTH);
    SpectrControls[SpectrControlsCount++] = obj;

    obj = fl_add_button(FL_HIDDEN_BUTTON, 170, offy+4, 10,10, ""); 
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "Gg", 0);
    fl_set_object_callback(obj, settings_callback, SET_GAIN+1000);
    SpectrControls[SpectrControlsCount++] = obj; 

  fdui->set_spect_gain = 
    obj = fl_add_counter(FL_SIMPLE_COUNTER, 167, offy, 50,20,"Gain:");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_precision(obj, 0);
    fl_set_object_shortcut(obj, "G", 1);
    fl_set_counter_bounds(obj, GAIN_MIN, GAIN_MAX);
    fl_set_counter_step(obj, 1, 1);
    fl_set_object_callback(obj, settings_callback, SET_GAIN);
    SpectrControls[SpectrControlsCount++] = obj;

    obj = fl_add_button(FL_HIDDEN_BUTTON, 286, offy+4, 10,10, ""); 
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "Ii", 0);
    fl_set_object_callback(obj, settings_callback, SET_INTERLACE+1000);
    SpectrControls[SpectrControlsCount++] = obj; 

  fdui->set_spect_int = 
    obj = fl_add_counter(FL_SIMPLE_COUNTER, 285, offy, 50,20,"Interlace:");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_precision(obj, 0);
    fl_set_object_shortcut(obj, "I", 1);
    fl_set_counter_bounds(obj, INTERLACE_MIN, INTERLACE_MAX);
    fl_set_counter_step(obj, 1, 1);
    fl_set_object_callback(obj, settings_callback, SET_INTERLACE);
    SpectrControls[SpectrControlsCount++] = obj;

/*
    obj = fl_add_button(FL_HIDDEN_BUTTON,
	    stereo_supported ? 355: 418, offy+4, 10,10, ""); 
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_shortcut(obj, "Dd", 0);
    fl_set_object_callback(obj, settings_callback, SET_SPECTRUM_DISPLAY+1000);
    SpectrControls[SpectrControlsCount++] = obj; 
*/
  fdui->set_spectr_dispmod =
    obj = fl_add_choice(FL_NORMAL_CHOICE,
	    stereo_supported ? 383: 442, offy, 60,20, "Disp:");  /*  -59 */
    fl_set_object_shortcut(obj, "Dd", 1);
    fl_set_object_color(obj,FL_COL1, FL_WHITE);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj, settings_callback, SET_SPECTRUM_DISPLAY);
    SpectrControls[SpectrControlsCount++] = obj; 
    fl_addto_choice(obj, "Modulus");
    fl_addto_choice(obj, "Real Part");
    fl_addto_choice(obj, "Imag Part");
    fl_addto_choice(obj, "Combined");


    obj = fl_add_button(FL_HIDDEN_BUTTON,77,offy+4,10,10,"");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "wW", 0);
    fl_set_object_callback(obj, settings_callback, SET_PIXELWIDTH);
    WaveControls[WaveControlsCount++] = obj; 

  fdui->set_wav_pix_wid =
    obj = fl_add_counter(FL_SIMPLE_COUNTER,70,offy,50,20,"Pix width:");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "w", 1);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_bounds(obj, PIXEL_MIN_WIDTH, PIXEL_MAX_WIDTH);
    fl_set_counter_step(obj, 1, 1);
    fl_set_object_callback(obj, settings_callback, SET_PIXELWIDTH);
    WaveControls[WaveControlsCount++] = obj; 


    obj = fl_add_button(FL_HIDDEN_BUTTON,195,offy+4,10,10,"");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "hH", 0);
    fl_set_object_callback(obj, settings_callback, SET_PIXELHEIGHT);
    WaveControls[WaveControlsCount++] = obj; 


  fdui->set_wav_pix_hei =
    obj = fl_add_counter(FL_SIMPLE_COUNTER,191,offy,50,20,"Pix height:");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "h", 0);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_bounds(obj, PIXEL_MIN_HEIGHT, PIXEL_MAX_HEIGHT);
    fl_set_counter_step(obj, 1, 1);
    fl_set_object_callback(obj, settings_callback, SET_PIXELHEIGHT);
    WaveControls[WaveControlsCount++] = obj; 


    obj = fl_add_button(FL_HIDDEN_BUTTON,310,offy+4,10,10,"");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_shortcut(obj, "vV", 0);
    fl_set_object_callback(obj, settings_callback, SET_VSCALE);
    WaveControls[WaveControlsCount++] = obj; 

  fdui->set_wav_vscale =
    obj = fl_add_counter(FL_SIMPLE_COUNTER,305,offy,50,20,"V-scale:");
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_object_shortcut(obj, "V", 0);
    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_bounds(obj, VSCALE_MIN, VSCALE_MAX);
    fl_set_counter_step(obj, 1, 1);
    fl_set_object_callback(obj, settings_callback, SET_VSCALE);
    WaveControls[WaveControlsCount++] = obj; 

  fdui->obturateBtn =
    obj = fl_add_checkbutton(FL_PUSH_BUTTON,
                stereo_supported ? 370 : 432, offy, 100,22,"Obturate");
    fl_set_object_color(obj, FL_COL1, FL_BLACK);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_shortcut(obj, "^O", 1);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj, settings_callback, SET_OBTURATE);
    WaveControls[WaveControlsCount++] = obj; 
 
  if (stereo_supported)
  fdui->stereoBtn =
    obj = fl_add_checkbutton(FL_PUSH_BUTTON, 452, offy, 80,22,"Stereo");
    fl_set_object_color(obj, FL_COL1, FL_BLACK);
    fl_set_object_lcolor(obj,FL_WHITE);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_object_callback(obj, settings_callback, SET_STEREO);
    fl_set_object_shortcut(obj, "^S", 1);
    SpectrControls[SpectrControlsCount++] = obj;
    WaveControls[WaveControlsCount++] = obj; 

NoDspWindows:    
#endif

  /* - - - - - - - - - DATA CONTROLS - - - - - - - - */
   DataControlsCount = 0;
   offy = 196;


 /* These hidden buttons are needed to controls browsers 
    through keyboard                                     */

    /* Browser up /down */
    obj = fl_add_button(FL_HIDDEN_BUTTON,17,offy+3,20,10,""); 
    fl_set_object_callback(obj, data_button_callback, 10);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 
    customize_managed_button(obj, 8, XK_Up, XK_Down, 0); 
		    /* 0 - top focus, 2 -data focus, 0 - help focus */

    /* Browser PgUp/PgDn */
    obj = fl_add_button(FL_HIDDEN_BUTTON,17,offy+3,20,10,"");
    fl_set_object_callback(obj, data_button_callback, 11);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 
    customize_managed_button(obj, 8, XK_Prior, XK_Next, 0);  
		    /* 0 - top focus, 2 -data focus, 0 - help focus */

    /* Browser Home/End */
    obj = fl_add_button(FL_HIDDEN_BUTTON,17,offy+3,20,10,"");
    fl_set_object_callback(obj, data_button_callback, 12);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 
    customize_managed_button(obj, 8, XK_Home, XK_End, 0);  
		    /* 0 - top focus, 2 -data focus, 0 - help focus */

    /* Toggle active browser */
    obj = fl_add_button(FL_HIDDEN_BUTTON,17,offy+3,20,10,"");
    fl_set_object_callback(obj, data_button_callback, 20);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 
    customize_managed_button(obj, 4, XK_F6, 0, 0); 

    /* Double click emulation */
    obj = fl_add_button(FL_HIDDEN_BUTTON,17,offy+3,20,10,"");
    fl_set_object_callback(obj, data_button_callback, 52);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 
    customize_managed_button(obj, 4, XK_Insert, 0, 0);  

 fdui->data_browser[0] =  
    obj = fl_add_browser(FL_HOLD_BROWSER,17,offy,230,85,"Tracks");
    set_tooltip(obj, "Track List");
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_South);
    fl_set_object_callback(obj, data_browser_callback, 0);
    fl_set_browser_dblclick_callback(obj, data_button_callback, 50); 
/*    fl_set_browser_dblclick_callback(obj, data_browser_callback, 8);  */
    DataControls[DataControlsCount++] = obj; 

 fdui->active_browser_ptr[0] = 
    obj = fl_add_box(FL_NO_BOX,123,offy-17,20,20,"@8<");  
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    DataControls[DataControlsCount++] = obj; 

 fdui->data_browser[1] =  
    obj = fl_add_browser(FL_HOLD_BROWSER,283,offy,230,85,"Play list");
    set_tooltip(obj, "Play List");
    fl_set_object_lalign(obj,FL_ALIGN_TOP_RIGHT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_North, FL_SouthEast);
    fl_set_object_callback(obj, data_browser_callback, 1);
    fl_set_browser_dblclick_callback(obj, data_button_callback, 51); 
/*    fl_set_browser_dblclick_callback(obj, data_browser_callback, 9); */
    DataControls[DataControlsCount++] = obj; 

 fdui->active_browser_ptr[1] =
    obj = fl_add_box(FL_NO_BOX,368,offy-17,20,20,"@8<");
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    DataControls[DataControlsCount++] = obj; 

#if FL_INCLUDE_VERSION >= 86
    dial_boxtype = FL_OVAL3D_UPBOX;
#else
    dial_boxtype = FL_UP_BOX;
#endif    

  fdui->data_ins_btn = 
    obj = fl_add_button(FL_NORMAL_BUTTON,255,offy+4,21,21,"@>"); 
    set_tooltip(obj, "Add to play list");
    fl_set_object_boxtype(obj,dial_boxtype);
    fl_set_object_gravity(obj, FL_North, FL_North);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_callback(obj, data_button_callback, 50);

  fdui->data_del_btn = 
    obj = fl_add_button(FL_NORMAL_BUTTON,255,offy+60,21,21,"@<"); 
    set_tooltip(obj, "Delete from play list");
    fl_set_object_boxtype(obj,dial_boxtype);
    fl_set_object_gravity(obj, FL_South, FL_South);  
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_callback(obj, data_button_callback, 51);


 fdui->data_title_input =
     obj = fl_add_input(FL_NORMAL_INPUT,50,285,158,20,"Title:");
//    obj = fl_add_input(FL_NORMAL_INPUT,49,300,198,20,"Title:");
    set_tooltip(obj, "Disc title");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_callback(obj, data_input_callback, 0);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_input_maxchars(obj, DATA_NAME_SIZE);

    obj = fl_add_button(FL_HIDDEN_BUTTON,218,295,20,5,"");
    fl_set_object_gravity(obj, FL_South, FL_South);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_shortcut(obj, "^T", 0);
    fl_set_object_callback(obj, data_input_callback, 20);
    DataControls[DataControlsCount++] = obj; 

 fdui->data_title_toggle =
    obj = fl_add_button(FL_PUSH_BUTTON,208,285,40,20,"Single");
    fl_set_object_gravity(obj, FL_South, FL_South);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    set_tooltip(obj, "Toggle single/multiple artist");
    fl_set_object_callback(obj, data_input_callback, 10);
    DataControls[DataControlsCount++] = obj; 

 fdui->data_artist_input =
    obj = fl_add_input(FL_NORMAL_INPUT,50,306,158,20,"Artist:");
//    obj = fl_add_input(FL_NORMAL_INPUT,314,300,198,20,"Artist:");
    set_tooltip(obj, "Disc/track artist");
//    fl_set_object_lalign(obj,FL_ALIGN_RIGHT);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_callback(obj, data_input_callback, 1);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_input_maxchars(obj, DATA_NAME_SIZE-1);

 fdui->data_artist_toggle =
    obj = fl_add_button(FL_PUSH_BUTTON,208,306,40,20,"Disc");
    fl_set_object_gravity(obj, FL_South, FL_South);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    set_tooltip(obj, "Toggle disc or track specific artist");
    fl_set_object_callback(obj, data_input_callback, 11);
    DataControls[DataControlsCount++] = obj; 


 fdui->data_track_input =
//    obj = fl_add_input(FL_NORMAL_INPUT,314,306,198,20,"Track:");
    obj = fl_add_input(FL_NORMAL_INPUT,50,327,158,20,"Track:");
    set_tooltip(obj, "Selected track name");
    fl_set_object_gravity(obj, FL_SouthWest, FL_South);
    fl_set_object_resize(obj, FL_RESIZE_X);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_callback(obj, data_input_callback, 2);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_input_maxchars(obj, DATA_NAME_SIZE-1);

 fdui->data_track_toggle =
    obj = fl_add_button(FL_PUSH_BUTTON,208,327,40,20,"Play");
    fl_set_object_gravity(obj, FL_South, FL_South);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    set_tooltip(obj, "Toggle play/skip current track");
    fl_set_object_callback(obj, data_input_callback, 12);
    DataControls[DataControlsCount++] = obj; 

 fdui->data_extra_input =
//    obj = fl_add_input(FL_NORMAL_INPUT,49,327,178,20,"Extra:");
    obj = fl_add_input(FL_NORMAL_INPUT,314,306,158,20,"Details:");
    set_tooltip(obj, "Disc/track extra details");
    fl_set_object_gravity(obj, FL_South, FL_SouthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_callback(obj, data_input_callback, 3);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_input_maxchars(obj, EXTRA_NAME_SIZE-1);

 fdui->data_extra_toggle =
//    obj = fl_add_button(FL_PUSH_BUTTON,227,327,20,20,"D");
    obj = fl_add_button(FL_PUSH_BUTTON, 472,306,40,20,"Disc");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    set_tooltip(obj, "Toggle disc or track specific extra details");
    fl_set_object_callback(obj, data_input_callback, 13);
    DataControls[DataControlsCount++] = obj; 


  offx = 159;
  fdui->data_prefset_name = 
    obj = fl_add_input(FL_NORMAL_INPUT,314,285,offx,20,"PrefSet:");
    set_tooltip(obj, "Preference set name");
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_gravity(obj, FL_South, FL_SouthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_callback(obj, data_input_callback, 4);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    DataControls[DataControlsCount++] = obj; 

    obj = fl_add_button(FL_HIDDEN_BUTTON,324+offx,295,5,5,"");
    fl_set_object_shortcutkey(obj, XK_F7);
    fl_set_object_shortcutkey(obj, XK_F8);
    fl_set_object_callback(obj, data_prefset_callback, 102);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    DataControls[DataControlsCount++] = obj; 

  fdui->data_prefset_number = 
    obj = fl_add_counter(FL_SIMPLE_COUNTER,314+offx,285,40,20,"");
    set_tooltip(obj, "Preference set number");
    fl_set_object_callback(obj, data_prefset_callback, 101);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_step(obj, 1, 1);
    fl_set_counter_bounds(obj, 1, 1);
    fl_set_counter_value(obj, 1);
    DataControls[DataControlsCount++] = obj; 




 offx = 301;
 offy = 327;
 fdui->data_reload_btn =
    obj = fl_add_button(FL_NORMAL_BUTTON,offx,offy,53,21,"Reload");
    set_tooltip(obj, "Reload disc data and dicard changes");
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
//    fl_set_object_resize(obj, FL_RESIZE_NONE);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_shortcut(obj, "^L", 1);
    fl_set_object_callback(obj, data_button_callback, 0);
/*    customize_managed_button(obj, 4, (KeySym)('L'-'A'), 0, 0);  */

  fdui->data_save_btn = 
    obj = fl_add_button(FL_NORMAL_BUTTON,
#ifdef RCDDB_SUPPORT
					 offx+53,
#else
					 offx+158,
#endif					 
					      offy,53,21,"Save");
    set_tooltip(obj, "Save disc data");
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
//    fl_set_object_resize(obj, FL_RESIZE_NONE);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_shortcut(obj, "^S", 1);
    fl_set_object_callback(obj, data_button_callback, 1);
/*    customize_managed_button(obj, 4, (KeySym)('S'-'A'), 0, 0);  */


#ifdef RCDDB_SUPPORT
    obj = fl_add_button(FL_NORMAL_BUTTON,offx+106,offy,53,21,"Downld");
    set_tooltip(obj, "Get disc data from remote data bases");
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_shortcut(obj, "^D", 1);
    fl_set_object_callback(obj, data_button_callback, 2);

    obj = fl_add_button(FL_NORMAL_BUTTON,offx+159,offy,53,21,"Upload");
    set_tooltip(obj, "Submit disc data to remote data bases");
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    DataControls[DataControlsCount++] = obj; 
    fl_set_object_shortcut(obj, "^U", 1);
    fl_set_object_callback(obj, data_button_callback, 3);
/*    customize_managed_button(obj, 4, (KeySym)('D'-'A'), 0, 0);  */
#endif

    
  /* - - - - - - - - - RCDDB PANEL - - - - - - - - */
#ifdef RCDDB_SUPPORT
  RcddbControlsCount = 0;
  offx = 4; offy = 178;

  fdui->user_addr =     
    obj = fl_add_input(FL_NORMAL_INPUT,offx+80,offy+10,372,20,"User:   ");
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    set_tooltip(obj, "User and domain name, e.g. bingo@darksite.foo.fo");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    RcddbControls[RcddbControlsCount++] = obj; 
    
  obj = fl_add_checkbutton(FL_PUSH_BUTTON,offx+10,offy+32,60,20,"Proxy:");
    set_tooltip(obj, "Enable/disable use of proxy server");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_input(FL_NORMAL_INPUT,offx+80,offy+32,372,20,"");
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    set_tooltip(obj, "Proxy URL and port, e.g. proxy.darksite.foo.fo:8080");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

    obj = fl_add_input(FL_NORMAL_INPUT,offx+80,offy+54,372,20,"Mail server:   ");
    fl_set_object_color(obj,FL_COL1,FL_YELLOW);
    set_tooltip(obj, "SMTP server and port(optional), e.g. mail.darksite.foo.fo:35 or 'localhost'");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    fl_set_input_return(obj, FL_RETURN_CHANGED);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_button(FL_NORMAL_BUTTON,offx+459,offy+10,50,45,"Guess\n <-");
    fl_set_object_shortcut(obj, "^G", 1);
    set_tooltip(obj, "Auto-identify user name, mail and proxy server");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 


  obj = fl_add_browser(FL_HOLD_BROWSER,offx+80,offy+76,372,93,"");  /* Sites */
    set_tooltip(obj, "List of Download RCDDB sites");
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT); 
    fl_set_object_lstyle(obj,FL_FIXEDBOLD_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_button(FL_HIDDEN_BUTTON,offx+90,offy+95,20,20,"");
    customize_managed_button(obj, 0x80, XK_Up, XK_Down, 0);  
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_button(FL_NORMAL_BUTTON,offx+465,offy+76,40,25,"@#8->");
    set_tooltip(obj, "Raise selected site in the list");
    fl_set_object_boxtype(obj,dial_boxtype);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

#if FL_INCLUDE_VERSION < 86
  obj = fl_add_button(FL_NORMAL_BUTTON,offx+465,offy+110,40,25,"x");
#else  
  obj = fl_add_button(FL_NORMAL_BUTTON,offx+465,offy+110,40,25,"@#9+");
#endif  
    set_tooltip(obj, "Delete selected site from the list");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_East, FL_East);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_button(FL_NORMAL_BUTTON,offx+465,offy+145,40,25,"@#2->");
    set_tooltip(obj, "Lower selected site in the list");
    fl_set_object_boxtype(obj,dial_boxtype);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_text(FL_NORMAL_TEXT,offx+9,offy+83,68,12,"Protocol");
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    RcddbControls[RcddbControlsCount++] = obj; 

  obj = fl_add_choice(FL_NORMAL_CHOICE,offx+15,offy+96,55,20,"");
    set_tooltip(obj, "Select protocol: CDDBP-interactive, HTTP-hypertext");
    fl_set_object_shortcut(obj, "^P", 1);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_addto_choice(obj, "CDDBP");
    fl_addto_choice(obj, "HTTP");
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 
 
  obj = fl_add_button(FL_NORMAL_BUTTON,offx+10,offy+125,63,44,"Update\nstatus");
    set_tooltip(obj, "Download new lists of sites and categories, check protocol version");
    fl_set_object_shortcut(obj, "^U", 1);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
    fl_set_object_callback(obj, rcddb_callback, RcddbControlsCount);
    RcddbControls[RcddbControlsCount++] = obj; 

/*  obj = fl_add_text(FL_NORMAL_TEXT,offx+19, offy+75, 60,12,"Sites -->");
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    RcddbControls[RcddbControlsCount++] = obj;  */
#endif /* RCDDB_SUPPORT */

  /* - - - - - - - - - HELP CONTROLS - - - - - - - - */

  HelpControlsCount = 0;
  offx = 2; 
  offy = 193;  /* 180; */

  fdui->help_canvas = 
    obj = fl_add_canvas(FL_NORMAL_CANVAS,offx+16,offy-5, 490,116,"");  /* 126 */
    HelpControls[HelpControlsCount++] = obj;
    fl_set_object_color(obj, FL_COL1, FL_SPRINGGREEN);
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
    obj->argument = -1;
    helpCanvas = fdui->help_canvas;

    obj = fl_add_button(FL_NORMAL_BUTTON,offx+15,offy+127,34,20,"@first");  /* 66 */
    customize_button(obj, OPER_FIRSTTRACK, 2);
    customize_managed_button(obj, 0x30, XK_Home, XK_7, XK_KP_Home);
		    /* 0 - top focus, 0 -data focus, 3 - help focus */

    obj = fl_add_button(FL_TOUCH_BUTTON,offx+49,offy+127,34,20, "@4next");
    customize_button(obj, OPER_PREV, 2);
    customize_managed_button(obj, 0x30, XK_Up, XK_8, XK_KP_Up);
		    /* 0 - top focus, 0 -data focus, 3 - help focus */

    obj = fl_add_button(FL_TOUCH_BUTTON,offx+83,offy+127,34,20, "@4fwd");
    customize_button(obj, OPER_BACK, 2);
    customize_managed_button(obj, 0x30, XK_Left, XK_4, XK_KP_Left);

    obj = fl_add_button(FL_NORMAL_BUTTON,offx+117,offy+127,34,20,"@4play");
    customize_button(obj, OPER_PLAYBACK, 2);
    customize_managed_button(obj, 0x20, XK_BackSpace, 8, 0);

  fdui->help_slider =  
    obj = fl_add_slider(FL_HOR_SLIDER,164,offy+127,203,20,"");
    obj->argument = -1;
    HelpControls[HelpControlsCount++] = obj;
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthEast);
    fl_set_object_color(obj, SADP_BLACK, FL_WHITE);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
    fl_set_object_callback(obj, help_slider_callback, 0);
    helpSlider = fdui->help_slider;

    obj = fl_add_button(FL_NORMAL_BUTTON,offx+371,offy+127,34,20,"@play");
    customize_button(obj, OPER_PLAY, 6);
    customize_managed_button(obj, 0x10, XK_space, 0, 0);

    obj = fl_add_button(FL_TOUCH_BUTTON,offx+405,offy+127,34,20,"@fwd");
    customize_button(obj, OPER_FWD, 6);
    customize_managed_button(obj, 0x30, XK_Right, XK_6, XK_KP_Right);

    obj = fl_add_button(FL_TOUCH_BUTTON,offx+439,offy+127,34,20,"@next");
    customize_button(obj, OPER_NEXT, 6);
    customize_managed_button(obj, 0x30, XK_Down, XK_2, XK_KP_Down);

    obj = fl_add_button(FL_NORMAL_BUTTON,offx+473,offy+127,34,20,"@4first");
    customize_button(obj, OPER_LASTTRACK, 6);
    customize_managed_button(obj, 0x30, XK_End, XK_1, XK_KP_End);

#ifdef USE_CHANGER
  fdui->slot_counter_hidden =
    obj = fl_add_button(FL_HIDDEN_BUTTON, 335,160, 20,5,"@4first");
    customize_managed_button(obj, 0x22, XK_O, XK_o, 0); 
    fl_set_object_callback(obj,misc_callback,OPER_CHANGESLOT+100);

  fdui->slot_counter =
    obj = fl_add_counter(FL_PUSH_BUTTON,330,156,40,20,"Slot: ");
    set_tooltip(obj, "Slot number");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_callback(obj,misc_callback,OPER_CHANGESLOT);

    fl_set_object_lalign(obj, FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_counter_return(obj, FL_RETURN_CHANGED);
    fl_set_counter_precision(obj, 0);
    fl_set_counter_step(obj, 1, 4);
#endif


  /* - - - - - - - - - FOCUS PANEL SWITCH - - - - - - - - */

  fdui->focus_btn=
#if FL_INCLUDE_VERSION < 86 
    obj = fl_add_button(FL_PUSH_BUTTON,374,156,34,20,"@#8->");
#else
    obj = fl_add_button(FL_PUSH_BUTTON,374,156,34,20,"@-28->");
#endif
    set_tooltip(obj, "Focus");
    fl_set_object_callback(obj, focus_btn_callback, 0);
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
/*    fl_set_object_shortcut(obj, "Ff", 0);  */
    fl_set_object_shortcutkey(obj, XK_F5); 
	    
  /* - - - - - - - - SAVE  OPTIONS - - - - - - */
#if FL_INCLUDE_VERSION >= 86
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x-17,156,34,20,"@saveo");
#else    
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x-17,156,34,20,"Save");
#endif
    set_tooltip(obj, "Save options");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    fl_set_object_callback(obj, misc_callback, OPER_SAVEO);
    fl_set_object_shortcutkey(obj, XK_F10); 
    
  /* - - - - - - - - - QUITING - - - - - - - - */
  fdui->quit_button =  
#if FL_INCLUDE_VERSION < 86
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+18,156,34,20,"x"); 
    fl_set_object_lstyle(obj,FL_BOLD_STYLE); 
#else
    obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+18,156,34,20,"@-3#1+"); 
#endif    
    set_tooltip(obj, "Quit (play continues)");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 0x22, XK_Q, XK_q, 0); 
    obj->argument = OPER_QUIT;

  fdui->stop_quit_button =  
   obj = fl_add_button(FL_NORMAL_BUTTON,stat_box_x+53,156,34,20,"@stopquit");
    set_tooltip(obj, "Stop and quit");
    fl_set_object_gravity(obj,FL_NorthEast, FL_NorthEast);
    customize_managed_button(obj, 0x22, XK_Z, XK_z, 0); 
    obj->argument = OPER_STOPQUIT;

  /* Tooltip text */
  tooltip_text = 
    obj = fl_add_text(FL_NORMAL_TEXT, 20, 20, 100, 18, "");
    fl_set_object_boxtype(obj, FL_FRAME_BOX);
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_align(obj,FL_ALIGN_CENTER);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE | FL_ENGRAVED_STYLE);
    fl_set_object_color(obj, SADP_BLACK, FL_MCOL);
    fl_set_object_lcolor(obj, SADP_YELLOW);
    fl_hide_object(obj);    

  fl_end_form();




  return fdui;
}

static void visualise_tooltip(void)
{  short align; 

   if( TooltipObject == xforms_fd->fwd_btn ||
       TooltipObject == xforms_fd->next_btn) align = -1;
   else       
   if( TooltipObject == xforms_fd->back_btn ||
       TooltipObject == xforms_fd->prev_btn) align = 1;
   else align = 0;      

   show_tooltip(TooltipObject, align);
   TooltipCurTimeout = TooltipTimeout2;
/*   TooltipObject = NULL; */
}	   

static void devisualise_tooltip(void)
{
   hide_tooltip();
   TooltipCurTimeout = TooltipTimeout3;
}	   

static int idle_callback_handle(XEvent *xev, void *user_data)
{  
     time_t cur_time;

     Frames += 1.;
     cur_time = time(NULL);
     
     if (TooltipObject)
     { 	if (cur_time - TooltipTime >= TooltipCurTimeout)
        { if (is_tooltip_on())
             devisualise_tooltip();
          else
       	     visualise_tooltip();
	     
	  TooltipTime = cur_time;     
        } 	        	 
     }

     if (WindowResized)
     {  form_resize_callback();
          WindowResized = 0;
     }	 
		

     if (msg_seen && cur_time >= msg_remove_time)
		delaunch_message();
      
     if (BottomSection <= FOLDER_WAVE)
    	     sound_process();
     else
     if (BottomSection <= FOLDER_MISC)
          help_idle_callback();

#ifdef ICON_WINDOW_SUPPORT     
     if (IconWnd != None)
             icon_idle_callback();
#endif	     	     
     cdaudio_operate(OPER_NONE);   

     return 0;
}


void init_bottom(void)
{
    int fold_index;


#ifdef DSP_SUPPORT
  if (audio_supported)
  {    
    hide_folder_controls(FOLDER_WAVE, FOLDER_SPECTRUM, 0);
    hide_folder_controls(FOLDER_HELP, FOLDER_SPECTRUM, 0);

    if (stereo_supported)
         fl_set_button(xforms_fd -> stereoBtn, stereo);
    fl_set_button(xforms_fd -> obturateBtn, Obturate);
    fl_set_choice(xforms_fd->set_spectr_dispmod, SpectrDisplayMode);

    fl_set_counter_value(xforms_fd -> set_spect_col_wid, FourWndRes);
    fl_set_counter_value(xforms_fd -> set_spect_int, FourInterlace); 
    fl_set_counter_value(xforms_fd -> set_spect_gain, FourGain);
    fl_set_counter_value(xforms_fd -> set_wav_pix_wid, WaveHRes);
    fl_set_counter_value(xforms_fd -> set_wav_pix_hei, WaveVRes);
    fl_set_counter_value(xforms_fd -> set_wav_vscale, WaveVScale);

    fold_index = FOLDER_SPECTRUM; 
  }
  else    
#endif      
  {
     hide_folder_controls(FOLDER_HELP, FOLDER_NONE, 0);
     fold_index = FOLDER_NONE; 
#ifdef ICON_WINDOW_SUPPORT     
     if (IconWnd != None) init_icon_nonaudio();    
#endif     
  }    

    hide_folder_controls(FOLDER_DATA, FOLDER_SPECTRUM, 0);
#ifdef RCDDB_SUPPORT
    hide_folder_controls(FOLDER_RCDDB, FOLDER_SPECTRUM, 0);
#endif    
    BottomSection = fold_index;
    fl_set_button(xforms_fd->folder_btn[fold_index], 1);


}
		    
int screen_initialize(int argc, char *argv[])
{
    int r, g, b;
    int i, id;
    unsigned w, h;
    XGCValues xgcv;
    XWMHints xwmh;
    Pixmap pmp;

    audio_supported = (audio >= 0);
    
    fl_add_symbol("suspend", xforms_draw_suspend, 0);
    fl_add_symbol("refresh", xforms_draw_refresh, 0);
    fl_add_symbol("next",  xforms_draw_next, 0);
    fl_add_symbol("fwd",   xforms_draw_fwd, 0);
    fl_add_symbol("first",   xforms_draw_first, 0);
    fl_add_symbol("skip", xforms_draw_skip, 0);
    fl_add_symbol("stop", xforms_draw_stop, 0);
    fl_add_symbol("eject", xforms_draw_eject, 0);
    fl_add_symbol("stopquit", xforms_draw_stopquit, 0);
    fl_add_symbol("play", xforms_draw_play, 0);
    fl_add_symbol("pause", xforms_draw_pause, 0);
#if FL_INCLUDE_VERSION >= 86
    fl_add_symbol("saveo", xforms_draw_saveo, 0);
#endif
    fl_library_version(&xforms_ver, &xforms_rev);
    fl_app_signal_direct(1);


    xforms_fd = create_form();
    if (xforms_fd == NULL) return 0;


    DataChanged = 0;
    reposition = 0;
    msg_seen = 0;

    xforms_fd->time_disp_id = xforms_fd->play_mode_id = -1;

    BgCol = fl_getmcolor(FL_COL1, &r, &g, &b);
    spectr_colour[0] =fl_getmcolor(SADP_BLACK, &r, &g, &b);
    spectr_colour[1] =fl_getmcolor(FL_RED, &r, &g, &b);
    spectr_colour[2] =fl_getmcolor(SADP_YELLOW, &r, &g, &b);
    spectr_colour[3] =fl_getmcolor(FL_GREEN, &r, &g, &b);

#ifdef DSP_SUPPORT
//    FourWndMask = (FourWndCount < 2 || FourInterlace) ? 1 : 3; 
    FourWndMask = StartFourWndMask = (FourWndCount < 2) ? 1 : 3;
    InterStart = 0; InterCurMode = 0;
    FourWndDiscrWid = (FourWndWid+FourWndRes-1)/FourWndRes;
#endif


    
    if (ParGeometry)
    {   int x, y, w, h;
	int mask;
	
	x = MainFrm->x;	y = MainFrm->y;	
 	w = MainFrm->w;	h = MainFrm->h;	
        
	mask = XParseGeometry(ParGeometry, &x, &y, &w, &h);
        
	if (mask != 0)
	{  if (w < MIN_WIDTH) w = MIN_WIDTH;
  	   if (h < MIN_HEIGHT) h = MIN_HEIGHT;
	   if (w > MAX_WIDTH) w = MAX_WIDTH;
	   if (h > MAX_HEIGHT) h = MAX_HEIGHT;
	   if ((mask & XValue) || (mask & YValue))
	   {
		if (mask & XNegative) x += ScreenW - w-6;
	   	if (mask & YNegative) y += ScreenH - h-28;
    	        fl_set_form_geometry(MainFrm, x, y, w, h);
	   }
	   else	
	        fl_set_form_size(MainFrm, w, h); /* This will allow free placement */
	}       
    }	
    else
    if (  PlaceMode != PLACEMODE_NORMAL)
    {   int x, y, w, h;
	

        w = MainFrm->w; 
        h = MainFrm->h; 
        x = (ScreenW - w) /2; 
        y = (ScreenH - h) /2; 
        fl_set_form_geometry(MainFrm, x, y, w, h);
	
    }
    
    MainWnd = fl_prepare_form_window(MainFrm,
		  FL_PLACE_FREE, FL_FULLBORDER, ResrcName);

    if (MainWnd == None) return 0;

    WMStateAtom = XInternAtom(disp, "WM_STATE", True);

#ifdef DSP_SUPPORT
    if (ParGeometry) arrange_spectrum_windows();
#endif


    xgcv.fill_style = FillSolid;
    spectr_gc = XCreateGC(disp, MainWnd, GCFillStyle, &xgcv);	
    if (spectr_gc == NULL) return 0;

    
    for (i=0; i<2; i++)
    { TrkPmp[i] =  pmp = XCreatePixmap(disp, MainWnd, TrackWndWid, TrackWndHei, ScreenD);
      if (pmp != None)
          XFillRectangle(disp, pmp, spectr_gc, 0, 0, TrackWndWid, TrackWndHei);
    }       


    DigitPmp = fl_create_from_pixmapdata(MainWnd, digits, &w, &h,
    					 NULL, NULL, NULL, 0); 


    if(IconStyleApp == 'c' && 
#ifndef USE_OLD_ICONS    
                              ScreenD >= 8)	
       IconPmp = fl_create_from_pixmapdata(MainWnd, sadp_icon256, &w, &h,
    					 NULL, NULL, NULL, 0); 
    else					 
    if(strchr("cr", IconStyleApp) && 
#endif    
 		              ScreenD >= 4)	
       IconPmp = fl_create_from_pixmapdata(MainWnd, sadp_icon16, &w, &h,
    					 NULL, NULL, NULL, 0); 
    else
    if (IconStyleApp == 'b')					 
       IconPmp = fl_create_from_bitmapdata(MainWnd, sadp_icon2c_bits, 64, 64);  
    else
       IconPmp =  None;

#ifdef DSP_SUPPORT
    DimPmp = None;

    if(ScreenD >=8)
    {
      if (IconStyleBG == 'c') 
#ifndef USE_OLD_ICONS     
        DimPmp = fl_create_from_pixmapdata(MainWnd,  sadp_dim256, &w, &h,
      					 NULL, NULL, NULL, 0); 
      else
      if (IconStyleBG == 'r') 	
#endif
        DimPmp = fl_create_from_pixmapdata(MainWnd, sadp_dim16, &w, &h,
      					 NULL, NULL, NULL, 0); 
    }

	if (DimPmp != None) {
	  char BmpData;

      BmpData= 0xaa;
	  StippleBmp = XCreateBitmapFromData(disp, MainWnd, &BmpData, 8, 1);

  	  if (StippleBmp != None)
      {  xgcv.fill_style = FillStippled;
  	     xgcv.stipple = StippleBmp;
	     XChangeGC(disp, spectr_gc, GCFillStyle | GCStipple, &xgcv);
      }       
    }	  
#endif

/*
#ifdef DSP_SUPPORT
	create_spectrum_pmp();
#endif
*/      	
/*    xwmh.initial_state =  PlaceMode == PLACEMODE_ICON ? IconicState */
/*                            : PlaceMode == PLACEMODE_HIDDEN ? WithdrawnState */
/*                         : PlaceMode == PLACEMODE_MINI ? WithdrawnState */
#ifdef ICON_WINDOW_SUPPORT

    if (IconStyle != ICONSTYLE_STATIC) icon_control_init();
    xwmh.initial_state = NormalState;
#else
    xwmh.initial_state = (PlaceMode == PLACEMODE_ICON) ? IconicState : NormalState; 
#endif
    
    xwmh.flags =  StateHint;

    if (IconPmp)
    {   xwmh.flags |= IconPixmapHint;
        xwmh.icon_pixmap = IconPmp;
    }  	  


#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None && IconStyle != ICONSTYLE_DUAL)  
    {  xwmh.flags |= IconWindowHint | WindowGroupHint; 
       xwmh.icon_window = IconWnd;
       xwmh.window_group = MainWnd;
    }  
#endif
       	   
    XSetWMHints(disp, MainWnd, &xwmh);



    AllBtns = fl_create_from_bitmapdata(MainWnd, allbtns_bits, 16, 242);  

    xforms_fd->time_disp_id = id = fl_newpup(MainWnd);
    fl_addtopup(id, "Time Display%t");
    for (i=0; i<4; i++)
        fl_addtopup(id, TimeDispModesLong[i]);
    fl_setpup_shadow(id, 1);

    xforms_fd->play_mode_id = id = fl_newpup(MainWnd);
    fl_addtopup(id, "Play Mode%t");
    for (i=0; i<5; i++)
        fl_addtopup(id, PlayModesLong[i]);
    fl_setpup_shadow(id, 1);


    for (i=0; i<DataControlsCount; i++)
	fl_deactivate_object(DataControls[i]);
    ActiveBrowIndex = 0;
  

    show_mode(OPER_TIMEDISPLAY); 
    show_mode(OPER_AUTOPLAY);
    show_mode(OPER_LOOPPLAY);
    show_mode(OPER_PLAYMODE); 


    help_xforms_initialize();
    fl_set_idle_callback(idle_callback_handle, NULL);    
    
    return 1;
}


int foreground_processing(void)
{
    FL_OBJECT  *obj;    
    XSizeHints xsh;
    int i;

    old_position = 0;
    SuspendRefresh = 0;
    WindowResized = 0;

#ifdef RCDDB_SUPPORT
    rcddb_xforms_initialize();
#endif
    init_bottom();


/*    fl_register_raw_callback(MainFrm, 
             KeyPressMask | KeyReleaseMask, form_event_callback);    */

    fl_register_raw_callback(MainFrm, FL_ALL_EVENT, form_event_callback);  
    fl_addto_selected_xevent(MainWnd, KeyPressMask | ButtonPressMask | FocusChangeMask | StructureNotifyMask);    
    
    fl_set_atclose(xforms_close_routine, NULL);

#ifdef ICON_WINDOW_SUPPORT
    if (IconStyle == ICONSTYLE_DUAL && IconWnd != None)
           XMapWindow(disp, IconWnd);
     
#endif

#ifdef USE_CHANGER
    if (cd_slot_count > 1)
    {	fl_show_object(xforms_fd->slot_counter);
    	fl_show_object(xforms_fd->slot_counter_hidden);
	fl_set_counter_bounds(xforms_fd->slot_counter, 1, cd_slot_count);
    }
    else
    {	fl_hide_object(xforms_fd->slot_counter);
    	fl_hide_object(xforms_fd->slot_counter_hidden);
    }
#endif
    	
	   


    fl_show_form_window(MainFrm); 

    if (PlaceMode == PLACEMODE_HIDDEN)
	  XWithdrawWindow(disp, MainWnd, fl_screen);
    else	   
    if (PlaceMode == PLACEMODE_ICON) 
          XIconifyWindow(disp, MainWnd, fl_screen);
    
    if (BottomSection == FOLDER_NONE)
    {
	  int w = MainFrm->w;
	  int h = HEIGHT_NOBOTTOM;
          fl_winresize(MainWnd, w, h);	       

	  xsh.max_height = xsh.min_height = h;

    }  	
    else
    {
         if (PlaceMode == PLACEMODE_MAX)
	      fl_winresize(MainWnd, MAX_WIDTH, MAX_HEIGHT);

          xsh.max_height = MAX_HEIGHT;
	  xsh.min_height = MIN_HEIGHT;
    }	  

    xsh.max_width = MAX_WIDTH;
    xsh.min_width = MIN_WIDTH;
    if (xsh.max_width > ScreenW) xsh.max_width = ScreenW;
    if (xsh.max_height > ScreenH) xsh.max_height = ScreenH;
    xsh.flags = PMinSize | PMaxSize;
    XSetWMNormalHints(disp, MainWnd, &xsh);
    
/*    if (BottomSection >= FOLDER_HELP && BottomSection <= FOLDER_MISC)
    {   HelpWnd = fl_get_canvas_id(xforms_fd->help_canvas);
        help_prepare_canvas(BottomSection);
        help_show_page(0);
    }	
    else
*/    
	
    adjust_shortcuts(0);
    
#ifdef DSP_SUPPORT
    for (i=0; i< 2; i++)
    { 
	 obj = xforms_fd->spectrum[i];
	 obj->argument = i;
	 if (obj != None)
	   fl_add_canvas_handler(obj, Expose, spectrum_callback, NULL);
//if (i==0)
//   fl_add_canvas_handler(obj, ConfigureNotify , spectrum_callback, NULL);
    }

    if (FourWndCount < 0)
    {    obj =  xforms_fd->spectrum[0];  
        FourWndHei = MainFrm->h - obj->y - 50;
	FourWndWid = obj->w+20;
        FourWndDiscrWid = (FourWndWid+FourWndRes-1)/FourWndRes;
    }	
#endif
    fl_add_canvas_handler(xforms_fd->help_canvas, Expose, help_canvas_callback, NULL);
//    fl_add_canvas_handler(xforms_fd->help_canvas, ConfigureNotify, help_canvas_callback, NULL);

    for (i=0; i<2; i++)
    	 fl_set_pixmap_pixmap(xforms_fd->obj_digit[i], TrkPmp[i], 0);

/*
#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd != None) fl_activate_event_callbacks(IconWnd);
#endif
*/

    for (;;)
    {   obj =  fl_do_forms();

	  if ( obj == xforms_fd->quit_button ||
		 obj == xforms_fd->stop_quit_button ) 
	   break;	 
    
    }	

    cdaudio_operate(obj->argument);
    return 0;    
	
}    

void screen_deinitialize(void)
{
    int id;

#ifdef RCDDB_SUPPORT
    rcddb_xforms_deinitialize();
#endif    
    
    if (OptionsChanged)
    { if (SaveSet || ask_save_question("Settings changed. Save now ?"))
                    save_settings();
    }		    
    help_xforms_deinitialize();
    	
#ifdef DSP_SUPPORT
    if (DimPmp != None) XFreePixmap(disp, DimPmp);
#endif	
    if (IconPmp != None) XFreePixmap(disp, IconPmp);
    if (DigitPmp != None) XFreePixmap(disp, DigitPmp);
    if (TrkPmp[0] != None) XFreePixmap(disp, TrkPmp[0]);
    if (TrkPmp[1] != None) XFreePixmap(disp, TrkPmp[1]);

    if (ParGeometry) free(ParGeometry);

#ifdef ICON_WINDOW_SUPPORT
    icon_control_deinit();
    if (IconWnd != None) XDestroyWindow(disp, IconWnd);
#endif

    
    if (xforms_fd)
    {  id = xforms_fd->time_disp_id;      
       if ( id>= 0) fl_freepup(id);

        id = xforms_fd->play_mode_id;
        if ( id>= 0) fl_freepup(id);

        fl_finish();
	free (xforms_fd);
    }	
}

int xforms_close_routine(FL_FORM *ign1, void *ign2)
{

    cdaudio_deinitialize();
    sound_terminate();	

    screen_deinitialize();

    return FL_OK;
}    


/*============================================================= */
/*                     Event  Processing                        */
/*============================================================= */
static void form_resize_callback(void)
{
    int x, w;
    FL_OBJECT *obj, *obj1;


#ifdef DSP_SUPPORT
   if (BottomSection < FOLDER_DATA)
		arrange_spectrum_windows();
#endif

   if (BottomSection >= FOLDER_HELP && BottomSection <= FOLDER_MISC)
	  help_prepare_canvas(BottomSection);

    obj  = xforms_fd->data_browser[0];

    obj1 = xforms_fd->data_title_toggle;
    x = obj->x + obj->w - obj1->w;
    fl_set_object_position(obj1, x, obj1->y);

    obj1 = xforms_fd->data_track_toggle;
    fl_set_object_position(obj1, x, obj1->y);
    obj1 = xforms_fd->data_artist_toggle;
    fl_set_object_position(obj1, x, obj1->y);

    
    obj =  xforms_fd->data_artist_input;
    w = x - obj->x;
    fl_set_object_size(obj, w, obj->h);
    
    obj = xforms_fd->data_title_input;
/*    w = obj1->x + obj1->w - obj->x; */
    fl_set_object_size(obj, w, obj->h);
    
    obj = xforms_fd->data_track_input;
    fl_set_object_size(obj, w, obj->h);
	
	XFlush(disp);
}


static int form_event_callback(FL_FORM *frm, void *vev)
{   XEvent *xev = (XEvent *)vev;
    XKeyEvent xkey;
    KeySym ks;
    int  return_val = !FL_PREEMPT; 

    if (xev->type == ConfigureNotify)
    {  if (frm->w != (xev->xconfigure).width ||
	      frm->h != (xev->xconfigure).height) WindowResized  = 1;  
         goto Exodos;
    }	    

    /* Might fix 'put back event' bug */
    if (xev->type == KeymapNotify)
    {  return_val = FL_PREEMPT;
       goto Exodos;
    }      

    if (xev->type == ButtonPress)
	{  if (process_imwheel(xev))
		  return_val = FL_PREEMPT; 
	   goto Exodos;	
	}

#ifdef MIXER_SUPPORT
    if (xev->type == FocusIn)
	{	requery_mixer();
		goto Exodos;	
	}
#endif

    if (xev->type != KeyPress &&
        xev->type != KeyRelease)  goto Exodos;


    xkey = xev->xkey;    
    ks = XLookupKeysym( &xkey, 0);

#ifdef ICON_WINDOW_SUPPORT
    if (IconWnd && 
         (ks == XK_Shift_L || ks == XK_Shift_R ||
	  ks == XK_Control_L || ks == XK_Control_R )
       )		  
    { 

		return_val = icon_control_callback(xev, &ks);
		goto Exodos;
    }
#endif

    if (xev->type != KeyPress) goto Exodos;
    
/*    
    if (ks == XK_Tab)
    {  FL_OBJECT *focus_btn = xforms_fd->focus_btn;
       int focus_state = fl_get_button(focus_btn);
           
       if (xkey.state & ShiftMask)
       { if (BottomSection == FOLDER_DATA && focus_state) 
         {  data_button_callback(NULL, 20);
            return_val = FL_PREEMPT;
	 }
       }	     
       else
       {
         if (focus_btn->visible)
          {
	     fl_set_button(focus_btn, !focus_state);
             focus_btn_callback(focus_btn, 0);
             return_val = FL_PREEMPT;
          }	  
       }
       
       goto Exodos;
    }        
*/
    
    if ( BottomSection == FOLDER_DATA)
    { 
        if(xkey.state & ShiftMask)
        {
	  if (ks == XK_Right || ks == XK_KP_Right) 
	  {
	    data_button_callback(NULL, 50);
	    return_val = FL_PREEMPT;
	  }    
	  else
	  if (ks == XK_Left || ks == XK_KP_Left)
	  { 
	    data_button_callback(NULL, 51);
	    return_val = FL_PREEMPT;
	  }    
	  
	  	    
        } 
	else
        if(xkey.state & ControlMask)
	{
	  if (ks == XK_Right || ks == XK_KP_Right) 
	  {
	    data_prefset_callback(NULL, 103);
	    return_val = FL_PREEMPT;
	  }    
	  else
	  if (ks == XK_Left || ks == XK_KP_Left)
	  { 
	    data_prefset_callback(NULL, 104);
	    return_val = FL_PREEMPT;
	  }    
	}	
    }	

#ifdef RCDDB_SUPPORT
    else
    if ( BottomSection == FOLDER_RCDDB)
    {
        if ((xkey.state & ShiftMask)
	           && (ks == XK_Delete)) 
         {  rcddb_callback(NULL, RCDDB_DELETE);
	    return_val = FL_PREEMPT;
	 }    
    }
#endif	
Exodos:
    return return_val;
}

