  /* =========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.

            You are expected to provide appropriate references
            when using a part of the code in your software.

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#include <forms.h>
#include "sadp_rcddb.h"
#include "sad.h"
#include "sadp_xforms.h"


extern  short	ProbeCD, AutoPlay, LoopPlay;
extern  short	WaveHRes, WaveVRes, WaveVScale, Obturate;
extern  short	FourInterlace, FourWndRes, FourGain;
extern  short	BkgrColour, ShadColour, BottomColour;
extern  short	SaveSet, SaveData, SaveMixer;
extern  short	FourWndCount;
extern  int		ScreenW, ScreenH, ScreenD, ScreenVC;
extern  short	AudioSampleSize, UseMMap;
extern  u_int	SamplingRate;

extern  int	TimeoutStart, TimeoutRepos;
extern  int	TimeoutLoad, TimeoutEject;
extern  char	IconStyleApp, IconStyleBG, IconNameStyle;
extern  char	CDDeviceName[81];
extern  char	AudioDeviceName[101];
extern  char	MixerDeviceName[101];
extern  char	DefaultCategory[15];
extern  int 	AudioDeviceNumber;
extern  int 	MixerDeviceNumber;
extern	int		WheelBtnBack, WheelBtnFwd, WheelBtnPrev, WheelBtnNext;

extern  int 	DurationIntro, DurationAdvance;
extern  char	*Short;
extern  short	OptionsChanged;
extern  short	TooltipTimeout1, TooltipTimeout2, TooltipTimeout3;
extern  short	UseProxy, ProtocolUsed, UseLogFile;
extern  char      UserAddr[], ProxyURL[],	MailServer[];
extern  char 	*ParGeometry;
extern  short 	ForceReg;
extern  short	UseMCN;

extern PLAY_MODE_TYPE	PlayMode;
extern TIME_DISPLAY_MODE_TYPE TimeDisplayMode;
extern SPECTR_DISPLAY_MODE SpectrDisplayMode;
extern PLACE_MODE_TYPES PlaceMode;

extern	Display		*disp;
extern	GC		xforms_gc;

extern char *ShortDBPath;
extern char *ShortDBAltPath;

#ifdef DEFAULT_WDB_NAME
extern char  *ShortWDBName; 
#endif
#ifdef DEFAULT_XMCD_PATH
extern char *ShortXMCDPath;
#endif

static Colormap ColourMap;
const char  *ClassName = "XSadp";
const char *spec_modes = "mric";
const char *play_modes = "nlris";

#ifdef ICON_WINDOW_SUPPORT
extern short	HighlightIconButtons;
extern ICON_STYLE_TYPES  IconStyle;
const char *icon_styles = "sadi";
#endif

const char *place_modes = "nmich";
const char *time_disp_modes = "erpm";
const char *cpref = "/dev/cdrom";



#ifdef DSP_SUPPORT
static int ProcessSamplingRate(const char *option)
{
	long val;
	char *sep;

    val = strtol(option, &sep, 10);
	
	if (*sep == '\0') {
      if (val >= 8000  && val <= 96000) {
		SamplingRate = val;
		return 1;
	  }
	  else if (val >=0 && val <= 2) {
		SamplingRate = 44100 >> val;
    	return 1;
	  }
	}

    show_error_message("To set sampling rate[-srate], use 0, 1, 2\nor a whole number between 8000 and 96000");
    return 0;
}

static int ProcessSampleSize(const char *option)
{
    long val;
	char *sep;

    val = strtol(option, &sep, 10);

    if (val == 8  || val == 16) {
	  AudioSampleSize = val;
	  return 1;
    }	

    show_error_message("Sample size[-ssize] can be equal to 8 or 16\n");
    return 0;	   

}
#endif


static XrmOptionDescRec  xoptions[] =
{
  { "-cdev",    "*.devname.cd",      XrmoptionSepArg,  (XPointer)NULL },
  { "-adev",    "*.devname.dsp",   XrmoptionSepArg,  (XPointer)NULL },
  { "-noadev",  "*.devname.dsp",   XrmoptionNoArg,   (XPointer)"*" },
  { "-mdev",    "*.devname.mix",   XrmoptionSepArg,   (XPointer)NULL },
  { "-nomdev",  "*.devname.mix",   XrmoptionNoArg,   (XPointer)"*" },

  { "-saveset",   "*.autosave.settings", XrmoptionNoArg,  (XPointer)"1"},
  { "-nosaveset", "*.autosave.settings", XrmoptionNoArg,  (XPointer)"0"},


  { "-savedata",   "*.autosave.data",  XrmoptionNoArg,  (XPointer)"1"},
  { "-nosavedata", "*.autosave.data",  XrmoptionNoArg,  (XPointer)"0"},

  { "-savemixer",   "*.autosave.mixer",  XrmoptionNoArg,  (XPointer)"1"},
  { "-nosavemixer", "*.autosave.mixer",  XrmoptionNoArg,  (XPointer)"0"},

  { "-wstate",   "*.wnd.state",        XrmoptionSepArg,  (XPointer)NULL},
#ifdef ICON_WINDOW_SUPPORT
  { "-iconstyle", "*.wnd.iconstyle",   XrmoptionSepArg,   (XPointer)NULL },
  { "-iconbtnhi", "*.wnd.iconbtnhi",   XrmoptionNoArg,   (XPointer)"1"},
  { "-noiconbtnhi", "*.wnd.iconbtnhi",   XrmoptionNoArg, (XPointer)"0"},
#endif
  { "-geom",     "*.geometry",         XrmoptionSepArg,  (XPointer)NULL },
  { "-font",     "*.font.name",        XrmoptionSepArg,  (XPointer)NULL },
  { "-fontres",  "*.font.resolution",  XrmoptionSepArg,  (XPointer)NULL },
  { "-mwbtns",   "*.mwheel.buttons",   XrmoptionSepArg,  (XPointer)NULL },

  { "-probe",   "*.cd.autoprobe",     XrmoptionNoArg,   (XPointer)"1" },
  { "-noprobe", "*.cd.autoprobe",     XrmoptionNoArg,   (XPointer)"0" },
  { "-auto",    "*.cd.autoplay",      XrmoptionNoArg,   (XPointer)"1" },
  { "-noauto",  "*.cd.autoplay",      XrmoptionNoArg,   (XPointer)"0" },
  { "-bgcol",   "*.colour.bg",        XrmoptionSepArg,  (XPointer)NULL },
  { "-topcol",  "*.colour.topfg",     XrmoptionSepArg,  (XPointer)NULL },
  { "-btmcol",  "*.colour.btmfg",     XrmoptionSepArg,  (XPointer)NULL },

  { "-plm",     "*.cd.playmode",       XrmoptionSepArg,  (XPointer)NULL},
  { "-tdm",     "*.timedisplay",      XrmoptionSepArg,  (XPointer)NULL},
  { "-loop",    "*.cd.loopmode",       XrmoptionNoArg,   (XPointer)"1"},
  { "-noloop",  "*.cd.loopmode",       XrmoptionNoArg,   (XPointer)"0"},

#ifdef DSP_SUPPORT
  { "-srate",   "*.samplingrate",     XrmoptionSepArg, (XPointer)NULL },
  { "-ssize",   "*.samplesize",       XrmoptionSepArg, (XPointer)NULL },
  { "-mono",    "*.stereo",           XrmoptionNoArg,  (XPointer)"0"},
  { "-stereo",  "*.stereo",           XrmoptionNoArg,  (XPointer)"1"},
  { "-spi",     "*.spectr.interlace",  XrmoptionSepArg, (XPointer)NULL},
  { "-spg",     "*.spectr.gain",     XrmoptionSepArg, (XPointer)NULL},
  { "-spbw",    "*.spectr.barw",     XrmoptionSepArg, (XPointer)NULL },
  { "-spm",     "*.spectr.mode",     XrmoptionSepArg, (XPointer)NULL },

  { "-wph",     "*.wave.pixheight",   XrmoptionSepArg, (XPointer)NULL },
  { "-wpw",     "*.wave.pixwidth",    XrmoptionSepArg, (XPointer)NULL },
  { "-vscale",  "*.wave.vscale",      XrmoptionSepArg, (XPointer)NULL },
  { "-wob",     "*.wave.obturate",    XrmoptionNoArg,  (XPointer)"1" },
  { "-nowob",   "*.wave.obturate",    XrmoptionNoArg,  (XPointer)"0" },
# if (defined(MMAP_SUPPORT) || defined(ALSA_MMAP_SUPPORT))
  { "-mmap",    "*.mmap",             XrmoptionNoArg,  (XPointer)"1" },
  { "-nommap",  "*.mmap",             XrmoptionNoArg,  (XPointer)"0" },
# endif
#endif

  { "-tstart",  "*.timeout.start",    XrmoptionSepArg, (XPointer)NULL },
  { "-trepos",  "*.timeout.repos",    XrmoptionSepArg, (XPointer)NULL },
  { "-teject",  "*.timeout.eject",    XrmoptionSepArg, (XPointer)NULL },
  { "-tload",   "*.timeout.load",     XrmoptionSepArg, (XPointer)NULL },
  { "-notips",  "*.timeout.tips1",    XrmoptionNoArg,  (XPointer)"11" },
  { "-ttips1",  "*.timeout.tips1",    XrmoptionSepArg, (XPointer)NULL },
  { "-ttips2",  "*.timeout.tips2",    XrmoptionSepArg, (XPointer)NULL },
  { "-ttips3",  "*.timeout.tips3",    XrmoptionSepArg, (XPointer)NULL },

  { "-tstep",   "*.time.step",        XrmoptionSepArg, (XPointer)NULL },
  { "-tintro",  "*.time.intro",       XrmoptionSepArg, (XPointer)NULL },

  { "-aicon",   "*.icontype.app",     XrmoptionSepArg,  (XPointer)NULL },
  { "-noaicon", "*.icontype.app",     XrmoptionNoArg,   (XPointer)"n"  },
  { "-bicon",   "*.icontype.bg",      XrmoptionSepArg,  (XPointer)NULL },
  { "-nobicon", "*.icontype.bg",      XrmoptionNoArg,   (XPointer)"n"  },
  { "-iname",   "*.icontype.name",    XrmoptionSepArg,  (XPointer)NULL },

#ifdef RCDDB_SUPPORT
  { "-user",    "*.rcddb.user",       XrmoptionSepArg,  (XPointer)NULL },
  { "-mail",    "*.rcddb.mail",       XrmoptionSepArg,  (XPointer)NULL },
  { "-proxyaddr", "*.rcddb.proxyaddr",   XrmoptionSepArg,  (XPointer)NULL },
  { "-proxy",   "*.rcddb.proxy",      XrmoptionNoArg,   (XPointer)"1"  },
  { "-noproxy", "*.rcddb.proxy",      XrmoptionNoArg,   (XPointer)"0"  },
  { "-protocol","*.rcddb.protocol",   XrmoptionSepArg,  (XPointer)NULL },
  { "-categ",   "*.rcddb.category",   XrmoptionSepArg,  (XPointer)NULL },
  { "-log",     "*.rcddb.log",        XrmoptionNoArg,   (XPointer)"1"  },
  { "-nolog",   "*.rcddb.log",        XrmoptionNoArg,   (XPointer)"0"  },
  { "-reg",     "registration",       XrmoptionNoArg,   (XPointer)"1"  },
#endif

  { "-dbpath",  "*.database.path",    XrmoptionSepArg,  (XPointer)NULL },
  { "-dbalt",   "*.database.alt",     XrmoptionSepArg,  (XPointer)NULL },
#ifdef MCN_SUPPORT
  { "-mcn",     "*.database.mcn",     XrmoptionNoArg,   (XPointer)"1" },
  { "-nomcn",   "*.database.mcn",     XrmoptionNoArg,   (XPointer)"0" },
#endif
#ifdef DEFAULT_WDB_NAME
  { "-wdbname", "*.database.workman",  XrmoptionSepArg,  (XPointer)NULL },
#endif
#ifdef DEFAULT_XMCD_PATH
  { "-xmcdpath", "*.database.xmcd",  XrmoptionSepArg,  (XPointer)NULL },
#endif
  { "-help",    "help",              XrmoptionNoArg,   (XPointer)"1" }

};

static const short noptions = sizeof(xoptions)/sizeof(XrmOptionDescRec);


/* N.B. *result at start is the default value  */
static void get_char_resource(const char *resname, const char *classname,
			     const char *allowed, char *result)
{   static char deflt[2] = {'\0', '\0'};
    char buf[2];
    char resrc;

    deflt[0] = *result;
    fl_get_resource(resname, classname, FL_STRING, deflt, buf, 2);
    resrc = tolower(buf[0]);
    if (strchr(allowed, resrc)) *result = resrc;
}

static short get_short_resource(const char *resname, const char *classname,
			        short minval, short maxval, short defval)
{   short curval;
    char buf[7];

    sprintf(buf, "%d", defval);

    fl_get_resource(resname, classname, FL_SHORT, buf, &curval, 0);
    if (curval < minval) curval = minval; else
    if (curval > maxval) curval = maxval;
    return curval;
}

static void  show_xforms_help(void);

static void trim_line(char *line)
{  int l = strlen(line);

   while (--l>=0 && isspace(line[l]));

   line[++l] = '\0';
}

#ifdef DSP_SUPPORT
static void set_spectrum_defaults_to_cpu(void)
{

    double mips;

    FourInterlace = 0;
    FourWndRes = DEFAULT_BAR_WIDTH;

    if (get_cpu_data(NULL, NULL, NULL, &mips) && mips > 0)
    { 
       if (mips < 600. && mips > 0.1)
       { FourInterlace = (int)log10(600./mips);
         if (FourInterlace > INTERLACE_MAX) FourInterlace = INTERLACE_MAX;
       }	 
       
       if (mips < 400.)
       {  FourWndRes += (400.-mips)/20.;	       
	  if (FourWndRes > BAR_MAX_WIDTH) FourWndRes = BAR_MAX_WIDTH;
       }	  
	  
    }
}
#endif

static Status get_resource_colour(const char *resname, 
                                const char *default_colour, XColor *xcol_ptr)
{
    char colour_name[256];
    Status rc;
    
    fl_get_resource(resname, ClassName,  FL_STRING, 
                            default_colour, colour_name, 255);
    trim_line(colour_name);  // My function for removing leading and trailing spaces

    rc = XParseColor(disp, ColourMap, colour_name, xcol_ptr);
    if (!rc)
    {  fprintf (stderr, "\nInvalid %s specification: '%s'.\n\tDefault colour '%s' substituted.\n",
                         resname, colour_name,  default_colour);  
       rc = XParseColor(disp, ColourMap, default_colour, xcol_ptr);
    }

    return rc;
}

static void mouse_wheel_options(const char *option)
{
  char r;
	
  r = *option++;
  if (r) {
	if (r >= '3' && r<= '9') WheelBtnBack = Button1 + (r - '1');
	r = *option++;	
  }
  if  (r) {
	if (r >= '3' && r<= '9') WheelBtnFwd  = Button1 + (r - '1');
	r = *option++;	
  }   	  
  if  (r) {
	if (r >= '3' && r<= '9') WheelBtnPrev  = Button1 + (r - '1');
	r = *option++;	
  }   	  
  if  (r) {
	if (r >= '3' && r<= '9') WheelBtnNext  = Button1 + (r - '1');
  }   	  
}

int start_xformsing(int *argc, char *argv[])
{
   int r, g, b;
   char colourname[257];
   char tmp; /*, colour_undef;     */
   FL_STATE *fls;
   char *ptr;
   XColor  xcol;
   char FontName[51];
   char FontRes[11];
   static const char *font_mask = "-%s-%s-r-*-*-*-?-%s-*-*-*-*";
   const char used_cols[] = {FL_SPRINGGREEN, FL_INDIANRED,
		             FL_DEEPPINK, FL_CYAN, 
                             FL_GREEN, FL_RED, FL_DARKGOLD, 0 };
   const char *option;

   for (r=0; r<FL_FREE_COL1; r++)
     if (strchr(used_cols, (char)r) == NULL)
        fl_set_icm_color(r, 0, 0, 0);

  /*  fl_set_icm_color(SADP_BLACK, 0, 0, 0); */
    fl_set_icm_color(SADP_YELLOW, 255, 255, 0);

    ptr = get_full_fname("~/.sadp");
    if (ptr) setenv("XAPPLRESDIR", ptr, 0);


/*    r = *argc; */
    fl_initialize(argc, argv, ClassName, xoptions, noptions);
    g = *argc;
/*    OptionsChanged = (g != r); */

    if (g>1 && g<50)	/* Fixing a bug in XForms or Resource Manager */
    {
       fprintf (stderr, "Unrecognised: ");
       for (r=1; r<g; r++) fprintf(stderr, " %s", argv[r]);
       fprintf (stderr, "\nType 'xsadp -help' to get list of command-line arguments\n");
    }

    disp = fl_get_display();
    if (disp == NULL) return 0;

	/*
    fl_set_resource("flChoice.title", "xsadp");
    fl_set_resource("flQuestion.title", "xsadp");
    fl_set_resource("flAlert.title", "xsadp");
    */
	
    ScreenW = DisplayWidth(disp, fl_screen);
    ScreenH = DisplayHeight(disp, fl_screen);
    ScreenVC = fl_get_vclass();
    fls = fl_state + ScreenVC;
    ScreenD = fls->depth;
    ColourMap = fls->colormap;
    xforms_gc = fls->gc[0];

    if (get_short_resource("help", ClassName, 0, 1, 0))
    {  show_xforms_help();
       return 0;
    }

    if (get_resource_colour("colour.bg", DEFAULT_XCOLOUR_BKGR, &xcol))
    {  r = xcol.red >> 8;
       g = xcol.green >> 8;
       b = xcol.blue >> 8;

       fl_mapcolor(FL_TOP_BCOL, r, g, b);
       fl_mapcolor(FL_LEFT_BCOL, r, g, b);
       fl_mapcolor(FL_BOTTOM_BCOL, r/2, g/2, b/2);
       fl_mapcolor(FL_RIGHT_BCOL, r/2, g/2, b/2);
       fl_mapcolor(FL_COL1, r*2/3, g*2/3, b*2/3);
       fl_mapcolor(FL_YELLOW, r/2, g/2, b/2);
       fl_mapcolor(FL_BLACK, 255, 231, 155);
       r = r*4/3;  g = g*4/3;  b=b*4/3;
       if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;
       fl_mapcolor(FL_MCOL, r, g, b);
    }

    if (get_resource_colour("colour.topfg", DEFAULT_XCOLOUR_FTOP, &xcol))
          fl_mapcolor(FL_BLACK, xcol.red >> 8, xcol.green >> 8, xcol.blue >> 8);

    if (get_resource_colour("colour.btmfg", DEFAULT_XCOLOUR_FBOTTOM, &xcol))
          fl_mapcolor(FL_WHITE, xcol.red >> 8, xcol.green >> 8, xcol.blue >> 8);

    option = fl_get_resource("mwheel.buttons", ClassName, FL_NONE, "4567", NULL, 0);
	mouse_wheel_options(option);

    option = fl_get_resource("devname.cd", ClassName, FL_NONE, cpref, NULL, 0);
    if (! ProcessDeviceName(option, "CD", "cdrom", CDDeviceName, NULL)) return 0;

#ifdef DSP_SUPPORT
    option = fl_get_resource("devname.dsp", ClassName, FL_NONE, "0", NULL, 0);
    if (! ProcessDeviceName(option, "audio", "dsp", AudioDeviceName, &AudioDeviceNumber)) return 0;
#endif
#ifdef MIXER_SUPPORT
    option = fl_get_resource("devname.mix", ClassName, FL_NONE, "0", NULL, 0);
    if (! ProcessDeviceName(option, "mixer", "mixer", MixerDeviceName, &MixerDeviceNumber)) return 0;
#endif

    ProbeCD  =  get_short_resource("cd.autoprobe", ClassName, 0, 1, ProbeCD);
    AutoPlay =  get_short_resource("cd.autoplay", ClassName, 0, 1, AutoPlay);
    LoopPlay =  get_short_resource("cd.loopmode", ClassName, 0, 1, LoopPlay);

    SaveSet  = get_short_resource("autosave.settings", ClassName, 0, 1, 0);
    SaveData = get_short_resource("autosave.data", ClassName, 0, 1, 1);
    SaveMixer = get_short_resource("autosave.mixer", ClassName, 0, 1, 0);

#ifdef DSP_SUPPORT
    sprintf (colourname, "%5u", (unsigned int)SamplingRate);
    option = fl_get_resource("samplingrate", ClassName, FL_NONE, colourname, NULL, 0);
    if (*option != '\0') ProcessSamplingRate(option);

    sprintf (colourname, "%5d", (int) AudioSampleSize);
    option = fl_get_resource("samplesize", ClassName, FL_NONE, colourname, NULL, 0);
    if (*option != '\0') ProcessSampleSize(option);

    set_spectrum_defaults_to_cpu();
       
    FourWndCount = get_short_resource("stereo", ClassName,  0, 1, FourWndCount-1)+1;
    FourInterlace= get_short_resource("spectr.interlace", ClassName,
				    INTERLACE_MIN, INTERLACE_MAX, FourInterlace);
    FourGain = get_short_resource("spectr.gain", ClassName,
				    GAIN_MIN, GAIN_MAX, FourGain);
    FourWndRes = get_short_resource("spectr.barw", ClassName,
				    BAR_MIN_WIDTH, BAR_MAX_WIDTH, FourWndRes);
    WaveVRes =  get_short_resource("wave.pixheight", ClassName,
				    PIXEL_MIN_WIDTH, PIXEL_MAX_WIDTH, WaveVRes);
    WaveHRes =  get_short_resource("wave.pixwidth", ClassName,
				    PIXEL_MIN_HEIGHT, PIXEL_MAX_HEIGHT, WaveHRes);
    WaveVScale = get_short_resource("wave.vscale", ClassName,
				    VSCALE_MIN, VSCALE_MAX, WaveVScale);
    Obturate =  get_short_resource("wave.obturate", ClassName, 0, 1, Obturate);
# if (defined(MMAP_SUPPORT) || defined(ALSA_MMAP_SUPPORT))
    UseMMap  =  get_short_resource("mmap", ClassName, 0, 1, UseMMap);
#endif
    tmp = 'm';
    get_char_resource("spectr.mode", ClassName, spec_modes, &tmp);
    SpectrDisplayMode = strchr(spec_modes, tmp) - spec_modes + 1;
#endif

    TimeoutStart = get_short_resource("timeout.start", ClassName, 0, 20, TimeoutStart); 
    TimeoutRepos = get_short_resource("timeout.repos", ClassName, 0, 20, TimeoutRepos); 
    TimeoutEject  = get_short_resource("timeout.eject", ClassName, 0, 30, TimeoutEject);   
    TimeoutLoad  = get_short_resource("timeout.load", ClassName, 0, 30, TimeoutLoad);   
    TooltipTimeout1 = get_short_resource("timeout.tips1", ClassName, 0, 11, TooltipTimeout1);   
    TooltipTimeout2 = get_short_resource("timeout.tips2", ClassName, 1, 999, TooltipTimeout2);   
    TooltipTimeout3 = get_short_resource("timeout.tips3", ClassName, 1, 999, TooltipTimeout3);   

    DurationIntro = get_short_resource("time.intro", ClassName, 0, 40, (short)DurationIntro) ; //INTRO_DURATION_SEC);
    DurationAdvance = get_short_resource("time.step", ClassName, 0, 30, (short)DurationAdvance);  //STEP_DISCRETE);

    ParGeometry = NULL;
    fl_get_resource("geometry", ClassName, FL_STRING, "", colourname, 255);
    if (strlen(colourname) > 0) ParGeometry = strdup(colourname);

    fl_get_resource("font.name", ClassName,  FL_STRING, DEFAULT_X_FONT, colourname, 50);
    ptr = strchr(colourname, '-');
    if (ptr && (strchr(ptr+1, '-')))
    {  show_error_message("Font format: [foundry-]family, e.g.\n    adobe-courier\n    helvetica");
       strncpy(FontName, DEFAULT_X_FONT, 51);
    }   	
    else 
    if (ptr)
       strncpy(FontName, colourname, 51);
    else
       snprintf (FontName, 51, "*-%s", colourname);	        
    
    fl_get_resource("font.resolution", ClassName,  FL_STRING, DEFAULT_X_FONTRES, colourname, 50);
    
    ptr = strchr(colourname, '-');
    if (ptr && (strchr(ptr+1, '-')))
    {  show_error_message("Font resolution format: [resx-]resy.");
       strncpy(FontRes, DEFAULT_X_FONTRES, 11);
    }   	
    else 
    if (ptr)
       strncpy(FontRes, colourname, 11);
    else
       snprintf (FontRes, 11, "%s-%s", colourname, colourname);	        
        
    snprintf(colourname, 255, font_mask, FontName, "medium", FontRes);
    fl_set_font_name(FL_NORMAL_STYLE, colourname);  	
    snprintf(colourname, 255, font_mask, FontName, "bold", FontRes);
    fl_set_font_name(FL_BOLD_STYLE, colourname);  	
	

    tmp = 'n';
    get_char_resource("cd.playmode", ClassName, play_modes, &tmp);
    PlayMode = strchr(play_modes, tmp) - play_modes;
/*    if (PlayMode >= PLAY_REPEAT) PlayMode++; */
    tmp = 'p';
    get_char_resource("wnd.state", ClassName, place_modes, &tmp);
    PlaceMode = strchr(place_modes, tmp) - place_modes;

#ifdef ICON_WINDOW_SUPPORT
    tmp = 'w';
    get_char_resource("wnd.iconstyle", ClassName, icon_styles, &tmp);
    IconStyle = strchr(icon_styles, tmp) - icon_styles;
    if (IconStyle > ICONSTYLE_DUAL) IconStyle = ICONSTYLE_WINDOW;
    HighlightIconButtons = get_short_resource("wnd.iconbtnhi",
                           ClassName, 0, 1, HighlightIconButtons );   
#endif

    tmp = 'e';
    get_char_resource("timedisplay", ClassName, time_disp_modes, &tmp);
    TimeDisplayMode = strchr(time_disp_modes, tmp) -time_disp_modes;

    IconStyleApp = 'c';
    IconStyleBG = 'c';
#ifdef USE_OLD_ICONS
    get_char_resource("icontype.app", ClassName, "cbn", &IconStyleApp);
    get_char_resource("icontype.bg", ClassName, "cn", &IconStyleBG);
#else
    get_char_resource("icontype.app", ClassName, "cbrn", &IconStyleApp);
    get_char_resource("icontype.bg", ClassName, "crn", &IconStyleBG);
#endif    

    IconNameStyle = 't';
    get_char_resource("icontype.name", ClassName, "tdan", &IconNameStyle);

    ShortDBPath = (char *) fl_get_resource("database.path", ClassName, FL_NONE, ShortDBPath, NULL, 0);
    ShortDBAltPath = (char *) fl_get_resource("database.alt", ClassName, FL_NONE, ShortDBAltPath, NULL, 0);

#ifdef MCN_SUPPORT
    UseMCN = get_short_resource("database.mcn", ClassName, 0, 1, 1);
#endif

#ifdef DEFAULT_WDB_NAME
    ShortWDBName = (char *) fl_get_resource("database.name", ClassName, FL_NONE, ShortWDBName, NULL, 0);
    ShortWDBName = (char *) fl_get_resource("database.workman", ClassName, FL_NONE, ShortWDBName, NULL, 0);
#endif

#ifdef DEFAULT_XMCD_PATH
    ShortXMCDPath = (char *) fl_get_resource("database.xmcd", ClassName, FL_NONE, ShortXMCDPath, NULL, 0);
#endif

#ifdef RCDDB_SUPPORT
    fl_get_resource("rcddb.user", ClassName, FL_STRING, UserAddr, UserAddr, 151);
    fl_get_resource("rcddb.proxyaddr", ClassName, FL_STRING, ProxyURL, ProxyURL, 151);
    fl_get_resource("rcddb.mail", ClassName, FL_STRING, MailServer, MailServer, 151);
    fl_get_resource("rcddb.category", ClassName, FL_STRING, "", DefaultCategory, 15);
    UseProxy = (strlen(ProxyURL) > 0);
    if (UseProxy) 
        UseProxy = get_short_resource("rcddb.proxy", ClassName, 0, 1, UseProxy);
    ProtocolUsed = get_short_resource("rcddb.protocol", ClassName, 1, 2, ProtocolUsed);
    UseLogFile = get_short_resource("rcddb.log", ClassName, 0, 1, UseLogFile);
    ForceReg =  get_short_resource("registration", ClassName, 0, 1, 0);
#endif
    return 1;
}

static void  show_xforms_help(void)
{
    printf ("\nSing-Along Disk Player. Version %s.\n", get_sadp_version());
    printf ("(C) 1998 - 2000  Michael Glickman.   xsadp@yahoo.com\n\n");

    printf ("\t-cdev\t CD device name\n"
#ifdef DSP_SUPPORT
	    "\t-adev\t audio device name\n"
	    "\t-noadev\t disable audio device support\n"
#endif
#ifdef MIXER_SUPPORT
	    "\t-mdev\t mixer device name\n"
	    "\t-nomdev\t disable mixer device support\n"
#endif
	    "\t-probe\t -noprobe   enable/disable auto-probe\n"
	    "\t-auto\t -noauto    enable/disable auto-play\n"
	    "\t-loop\t -noloop    enable/disable loop play\n"
	    "\t-saveset  -nosaveset  enable/disable autosave settings\n"
	    "\t-savedata -nosavedata enable/disable autosave CD data\n"
	    "\t-savemixer -nosavemixer save/don't save mixer settings\n"
	    "\t-bgcol\t background colour\n"
	    "\t-topcol\t top foreground colour\n"
	    "\t-btmcol\t bottom foreground colour\n"
	    "\t-plm\t play mode: N L R I S\n"
	    "\t-tdm\t time display mode: E R P M\n"
/*	    "\t-dbname\t data base file name\n" */
	    "\t-geom\t main window geometry WxH+X+Y\n"
	    "\t-font\t font style (e.g. helvetca,courier,lucida)\n"
	    "\t-fontres\t font resolution resx-resy\n"
		"\t-mwbtns\t mouse extra/wheel buttons"
#ifdef DSP_SUPPORT
	    "\t-stereo\t -mono stereo/mono analyser and mixer \n"
	    "\t-srate\t sampling rate (0-44KHz, 1-22.5KHz, etc) \n"
	    "\t-ssize\t sample size (8 or 16) \n"
	    "\t-spi\t spectrum interlace (0-4) \n"
	    "\t-spg\t spectrum gain (-5 to +5) \n"
	    "\t-spbw\t spectrum bar width (1-30) \n"
	    "\t-spm\t spectrum mode: M R I C\n"
	    "\t-wpw\t oscilloscope pixel width\n"
	    "\t-wph\t oscilloscope pixel height\n"
	    "\t-vscale\t oscilloscope verical scale (-5 to +5)\n"
	    "\t-wob\t enable oscilloscope obturate\n"
	    "\t-nowob\t disable oscilloscope obturate\n"
# if (defined(MMAP_SUPPORT) || defined(ALSA_MMAP_SUPPORT))
	    "\t-nommap\t disable memory map for DSP\n"
# endif
#endif
	    "\t-dbpath\t data base directory path\n"
	    "\t-dbalt\t alternative data base directory path\n"
#ifdef DEFAULT_WDB_NAME
	    "\t-wdbname workman data base file path\n"
#endif
#ifdef DEFAULT_XMCD_PATH
	    "\t-xmcdpath xmcd data base file path\n"
#endif
#ifdef RCDDB_SUPPORT
	    "\t-user\t user address (for RCDDB)\n" 
	    "\t-proxyaddr proxy server URL address\n"
	    "\t-no proxy\t disable proxy server\n"
	    "\t-protocol\t CDDB protocol (1-CDDBP, 2-HTTP)\n"
	    "\t-categ\t default CDDB category\n"
	    "\t-log\t use RCDDB interface log\n"
	    "\t-nolog\t don't use RCDDB interface log\n"
#endif
	    "\t-ttips1\t timeout for tool tip to appear (sec)\n"
	    "\t-ttips2\t timeout for tool tip to disappear (sec)\n"
	    "\t-ttips3\t timeout for tool tip to reappear (sec)\n"
	    "\t-notips\t disable tool tips\n"
	    "\t-tstart\t start play timeout (sec)\n"
	    "\t-trepos\t change position timeout (sec)\n"
	    "\t-teject\t eject tray timeout (sec)\n"
	    "\t-tload\t load tray timeout (sec)\n"
	    "\t-tstep\t fwd/back time interval (sec)\n"
	    "\t-tintro\t intro duration (sec)\n"
	    "\t-wstate\t initial window state:\n"
	    "\t       \t N-normal, M-max, I-icon, C-centre, H-hidden\n"
#ifdef USE_OLD_ICONS	    
	    "\t-aicon\t application icon: C-colour, B-B/W, N-none \n"
	    "\t-bicon\t background icon: C-colour, N-none\n"
#else
	    "\t-aicon\t application icon:\n"
	    "\t      \t C- 256colour, R - 16colour, B - B/W,  N-none\n"
	    "\t-bicon\t background icon: C R N\n"
	    "\t      \t C- 256colour, R - 16colour, N-none\n"
#endif	    
	    "\t-iname\t icon name style:\n"
	    "\t      \t T-track name, D-disc name, A-artist, N-none\n"
#ifdef MCN_SUPPORT
	    "\t-mcn\t   enable MCN support\n"
	    "\t-nomcn\t disable MCN support\n"
#endif
#ifdef ICON_WINDOW_SUPPORT
	    "\t-iconstyle  icon name style: \n"
	    "\t            S - static, A - active, D - dual\n"
	    "\t-iconbtnhi  enable icon button highlight (default)\n"
	    "\t-noiconbtnhi  disable icon button highlight\n"
#endif
	    "\t-help\t this page\n\n");

    printf ("See man page for details.\n");
}


void set_short_resource(char *resname, short value)
{   char buf[6];

    sprintf (buf, "%d", (int)value);
    fl_set_resource(resname, buf);
}

void set_char_resource(const char *resname, const char *modes,  short chr)
{   static char buf[2] = {'\0', '\0'};

    buf[0] = (chr >= strlen(modes)) ? ' ' : modes[chr];
    fl_set_resource(resname, buf);
}


/* I would be happy to use XrmPutFileDatabase,
   but XrmDatabase is out of reach !            */
void save_settings(void)
{
    FILE  *f;
    const char *resname;
    const char *resc;
    char *res;
    char path[513];
    char buf[601];
    time_t t;
    int  l, i;


    const char *xfres[] =  {"visual", "depth", "borderWidth",
                            "privateColormap", "sharedColormap",
 		            "standardColormap" };
    const int xfres_count = sizeof(xfres) / sizeof(char *);


    strcpy(path, getenv("XAPPLRESDIR"));
    l = strlen(path);
    if (path[l-1] != '/')  path[l++] = '/';
    strcpy(path+l, ClassName);

    f = fopen(path, "w+");
    if (!f)
    {
       sprintf(buf, "Failed to open %s:", path);
       perror(buf);
       return;
    }

    fprintf (f, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!|!!\n");
    fprintf (f, "!!! This resource file has been generated by !!!\n");
    fprintf (f, "!!!  Sing-Along Disc Player for X ver %-7s!!!\n", 
                                    get_sadp_version());
    fprintf (f, "!!!------------------------------------------!!!\n");
    time(&t);  strcpy(buf, ctime(&t));   strtokm(buf, "\n");
    fprintf (f, "!!! Created:    %-29s!!!\n", buf );
    fprintf (f, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
    fprintf (f, "\n");

    fprintf (f, "!!!    XForms LIBRARY  STANDARD RESOURCES    !!!\n");

    for (i=0; i<xfres_count; i++)
    {
	resname = xfres[i];
	resc = fl_get_resource(resname, ClassName, FL_NONE, "", NULL, 0);
	if (resc[0] == '\0') continue;
        res = strdup(resc);
	trim_line(res);
	fprintf (f, "%s*%s:\t%s\n", ClassName, resname, res);
    	free(res);
    }

    fprintf (f, "\n");

#ifdef DSP_SUPPORT
    set_short_resource("spectr.interlace", FourInterlace);
    set_short_resource("spectr.gain", FourGain);
    set_short_resource("spectr.barw", FourWndRes);
    set_short_resource("wave.pixheight", WaveVRes);
    set_short_resource("wave.vscale", WaveVScale);
    set_short_resource("wave.pixwidth", WaveHRes);
    set_short_resource("wave.obturate", Obturate);

    if (FourWndCount > 0)
        set_short_resource("stereo",  FourWndCount-1);

    set_char_resource("spectr.mode", spec_modes, SpectrDisplayMode-1);
#endif

    set_short_resource("cd.autoplay",  AutoPlay);
    set_short_resource("cd.loopmode",  LoopPlay);
    set_char_resource("cd.playmode", play_modes, PlayMode);
    set_char_resource("timedisplay", time_disp_modes, TimeDisplayMode);

    set_char_resource("timedisplay", time_disp_modes, TimeDisplayMode);

    
#ifdef RCDDB_SUPPORT
    fl_set_resource("rcddb.user",  UserAddr);
    fl_set_resource("rcddb.proxyaddr", ProxyURL);
    fl_set_resource("rcddb.mail", MailServer);
    fl_set_resource("rcddb.category", DefaultCategory);

    set_short_resource("rcddb.proxy",  UseProxy);
    set_short_resource("rcddb.protocol", ProtocolUsed);
/*    set_short_resource("rcddb.log", UseLogFile); */
#endif


    fprintf (f, "!!!     APPLICATION  SPECIFIC  RESOURCES     !!!\n");
    for (i=0; i<noptions; i++)
    {    /* Preventing duplication and 'help' processing */
        if (xoptions[i].argKind == XrmoptionNoArg &&
              *xoptions[i].value != '0') continue;

        resname =  xoptions[i].specifier+2;
	resc = fl_get_resource(resname, ClassName, FL_NONE, "", NULL, 0);
	if (resc[0] == '\0') continue;

	res = strdup(resc);
	trim_line(res);
	fprintf (f, "%s.%s:\t%s\n", ClassName, resname, res);
	free(res);
    }

    fprintf (f, "\n");
    fclose(f);
    launch_message ("Saved");
    OptionsChanged = 0;
}
