/*  =========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com         
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
    
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdlib.h>
#include <forms.h>
#include "sad.h"
#include "sadp_xforms.h"

/* N.B. 'angle' is ignored */
void xforms_draw_suspend(FL_COORD x, FL_COORD y, 
                         FL_COORD w, FL_COORD h,
		         int angle, FL_COLOR col)
{   int hp, vp;
    FL_POINT p[9];

    hp = ((w - 11) >> 1) + 1;
    vp = (h - 10) >> 1;		      
      
    x += hp; y += vp;
    p[0].x = x+3;  p[0].y = y;
    p[1].x = x+7;  p[1].y = y;
    p[2].x = x+10; p[2].y = y+3;
    p[3].x = x+10; p[3].y = y+6;
    p[4].x = x+7;  p[4].y = y+9;
    p[5].x = x+3;  p[5].y = y+9;
    p[6].x = x;    p[6].y = y+6;
    p[7].x = x;    p[7].y = y+3;
    
    fl_polyl(p, 8, col);
    
    fl_rectf(x +3, y+4, 5, 2, col);
}        
      
/* N.B. 'angle' is ignored */
void xforms_draw_refresh(FL_COORD x, FL_COORD y, 
                         FL_COORD w, FL_COORD h,
		         int angle, FL_COLOR col)
{   int hp, vp;
    FL_POINT p[10];


    hp = ((w - 10) >> 1) + 1;
    vp = (h - 10) >> 1;		      
      
    x += hp; y += vp;

    
    p[0].x = x+7;  p[0].y = y; 
    p[1].x = x+1;  p[1].y = y+6; 
    p[2].x = x+1;  p[2].y = y+7; 
    p[3].x = x;    p[3].y = y+8; 
    p[4].x = x;    p[4].y = y+9; 
    p[5].x = x+1;  p[5].y = y+9; 
    p[6].x = x+2;  p[6].y = y+8; 
    p[7].x = x+3;  p[7].y = y+8; 
    p[8].x = x+9;  p[8].y = y+2; 
    fl_polyl(p, 9, col);


     fl_line(x+7, y+2, x+3, y+6, col); 

    
}        
		      
/* N.B. Works OK for angles 0 and 180 */
void xforms_draw_skip(FL_COORD x, FL_COORD y, 
                      FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    short sign, i;
    FL_POINT p[4];

    h1 = 10;
    w1 = 8;
        
    
    hp = ((w - 3*w1) >> 1)+2;
    vp = ((h - h1) >> 1) ;
    x += hp; y += vp;

    if (angle)  { x+=3*w1 - 5; sign = -1; }
           else { sign = 1; }

    p[0].y = y;
    p[1].y = y + h1;
    p[2].y = y + h1/2;

    i = 2;
    while(--i>=0)
    { p[0].x = x;
      p[1].x = x;
      p[2].x = x + (w1-1)*sign;  
      x += w1*sign;
      fl_polyf(p, 3, col);
    }           

    fl_rectf(x, y+1, 3*sign, h1-1, col);
    

}

/* N.B. Works OK for angles 0 and 180 */
void xforms_draw_next(FL_COORD x, FL_COORD y, 
                      FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    short sign;
    FL_POINT p[4];

    h1 = 10;
    w1 = 9;
        
    
    hp = ((w - 2*w1) >> 1)+3;
    vp = ((h - h1) >> 1) ;
    x += hp; y += vp;

    if (angle)  { x+=w1 + 3; sign = -1; }
           else { sign = 1; }

    p[0].y = y;
    p[1].y = y + h1;
    p[2].y = y + h1/2;

    p[0].x = x;
    p[1].x = x;
    p[2].x = x + (w1-1)*sign;  

    fl_polyf(p, 3, col);
               

    x += w1*sign;
    fl_rectf(x, y+1, 3*sign, h1-1, col);
    

}

/* N.B. Works OK for angles 0 and 180 */
void xforms_draw_fwd(FL_COORD x, FL_COORD y, 
                      FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    short sign, i;
    FL_POINT p[4];
     
    h1 = 10;
    w1 = 9;
        
    
    hp = ((w - 2*w1) >> 1) + 1;
    vp = ((h - h1) >> 1) ;
    x += hp; y += vp;

    if (angle)  { x+=2*w1 -2; sign = -1; }
           else { sign = 1; }

    p[0].y = y;
    p[1].y = y+h1;
    p[2].y = y+h1/2;

    i = 2;
    while (--i >= 0)
    { p[0].x = x;
      p[1].x = x;
      p[2].x = x + (w1-1)*sign;  
      fl_polyf(p, 3, col);
      x += w1*sign;
    }               

}

void xforms_draw_stop(FL_COORD x, FL_COORD y, 
                      FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD s, hp, vp;

    s = 7;
    
    hp = ((w - s) >> 1);
    vp = ((h - s) >> 1) + 1;
    x += hp; y += vp;

    fl_rectf(x, y, s, s, col);

}


void xforms_draw_pause(FL_COORD x, FL_COORD y, 
                       FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD hs, vs, hp, vp;

    vs = 5; hs = 3;
    
    hp = ((w - 2*hs-1) >> 1)+1;
    vp = ((h - vs) >> 1)+1;

    x += hp; y += vp;

    fl_rectf(x, y, hs, vs, col);
    fl_rectf(x+hs+1, y, hs, vs, col);

}


void xforms_draw_saveo(FL_COORD x, FL_COORD y, 
                      FL_COORD w, FL_COORD h,
		      int angle, FL_COLOR col)
{   FL_COORD s, hp, vp;

    s = 9;
    
    hp = ((w - s) >> 1);
    vp = ((h - s) >> 1) + 1;
    x += hp; y += vp;

    fl_rect(x, y, s, s, col);

    x+=2; 
    fl_rectf(x, y, 2, 5, col);

    x+=2; 
    fl_rect(x, y, 3, 4, col);
    

}

void xforms_draw_first( FL_COORD x, FL_COORD y,
		        FL_COORD w, FL_COORD h,
		        int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    FL_POINT p[4];
    short sgn;
     
    h1 = 10;
    w1 = 15;

    hp = ((w - 2*w1) >> 1) + 5;
    vp = ((h - h1) >> 1) -1;

    if (angle > 0)
    { hp = w - hp; sgn = -1;}
    else sgn = 1;
    
    
    x += hp; y += vp;

    p[0].x = x+6*sgn;
    p[0].y = y;

    p[1].x = x;
    p[1].y = y + h1/2 + 1;

    p[2].x = x+6*sgn;
    p[2].y = y + h1+1;
   
    fl_polyf(p, 3, col);

    h1 = h1/3;
    y += h1+1;
    x += 7*sgn;

    if (sgn < 0) x -= 3;

    y++;    
    fl_rectf(x, y, h1, h1, col);
    fl_rectf(x+sgn*(h1+1), y, h1, h1, col);
    fl_rectf(x+2*sgn*(h1+1), y, h1, h1, col);

}

void xforms_draw_stopquit( FL_COORD x, FL_COORD y,
		        FL_COORD w, FL_COORD h,
		        int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
     
    w1 = 12;
    h1 = 9;
        
    
    hp = ((w - 2*w1) >> 1) + 5;
    vp = ((h - h1) >> 1) ;
    x += hp; y += vp;

    fl_rect  (x,    y,   w1,   h1,  col);
    fl_rectf (x+2, y+4, w1-3, h1-7, col);

}

void xforms_draw_play( FL_COORD x, FL_COORD y,
		        FL_COORD w, FL_COORD h,
		        int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    FL_POINT p[4];
    int  sgn;
         
    w1 = 12;
    h1 = 9;
        
    
    hp = ((w - 2*w1) >> 1) + 7;
    vp = ((h - h1) >> 1)+1 ;
    y += vp;

    if (angle > 0)
    { x += w-hp-3; sgn = -1;}
    else 
    { x += hp,  sgn = 1; }

/*
    fl_rectf (x, y, 3, h1, col);
  
    if (sgn > 0) x += 5; else x -= 2;
*/

    x += 2;    
    p[0].x = p[2].x = x;
    p[1].x = x + 7*sgn;
    p[0].y = y-1;
    p[1].y = y+h1/2;
    p[2].y = y+h1;
    
    fl_polyf(p, 3, col);
    
        
}

void xforms_draw_eject( FL_COORD x, FL_COORD y,
		        FL_COORD w, FL_COORD h,
		        int angle, FL_COLOR col)
{   FL_COORD h1, w1, hp, vp;
    FL_POINT p[4];
    int  sgn, x2;
         
    w1 = 12;
    h1 = 9;
        
    hp = ((w - 2*w1) >> 1) + 7;
    vp = ((h - h1) >> 1)+1 ;


    x += hp;

    if (angle ==0)
    { sgn = 1;  y += vp-1; 
      x2 = x+10;
    }  
    else
    { sgn = -1; y += vp+h1;
      x2 = x+11;
    }


    p[0].x = x;
    p[1].x = x+5;
    p[2].x = x2;
    p[0].y = p[2].y = y+6*sgn;
    p[1].y = y; 
    fl_polyf(p, 3, col);

    if (sgn > 0) {  x++; y+=8; }    
	    else y -= 9;
	    
    fl_rectf (x, y, x2-x, 1, col);
    
        
}
