 /* ==========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
 
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <ctype.h>
#include <forms.h>
#include "sad.h"
#include "sadp_xforms.h"


/* XFORMS_BTN_HELP		HelpBtnsInfo[CBUTTONS+HBUTTONS+UBUTTONS+XFBUTTONS]; */

int	    WheelBtnBack = 4,  WheelBtnFwd = 5;
int	    WheelBtnPrev = 6,  WheelBtnNext = 7;

extern  short		DataChanged, SitesChanged;

extern  GC		xforms_gc;
extern	short		BottomSection; 
extern  Atom		WMStateAtom;

extern  const short	HelpWidth, MiscWidth;
extern  const short	HelpLineCount, MiscLineCount, InfoLineCount;
extern  char		*HelpPages[], *MiscPages[], **InfoPages;

extern	Display		*disp;
extern  Window		MainWnd, HelpWnd;
extern  unsigned long	spectr_colour[];
extern	Pixmap		IconPmp, AllBtns;

extern	FL_FORM  	*MainFrm;
extern  FL_OBJECT 	*helpSlider, *helpCanvas;
extern	FL_OBJECT	*HelpControls[CBUTTONS+HBUTTONS]; 
extern	short		HelpControlsCount;

extern  const char	*TimeDispModesShort[], *PlayModesShort[];
extern  long TimeStart;
extern  double Frames;

extern  PREFSET_INFO	*cd_prefsets;
extern  PREFSET_INFO	*cd_current_prefset;
extern  short		cd_prefset_count;
extern  u_char		track_first, track_last;     
extern  short           cd_playlist_size;
extern  u_char		*cd_playlist;
       
extern  short   cur_plist_size, cur_plist_pos;
extern u_char  *cur_plist;

extern  PLAY_MODE_TYPE	PlayMode;


extern  FL_OBJECT	*TooltipObject;
extern  time_t		TooltipTime;
extern	FL_OBJECT	*tooltip_text;
extern  short           TooltipTimeout1, TooltipTimeout2;
extern  short           TooltipCurTimeout;

extern  FL_OBJECT	*DataControls[30];
extern  short		DataControlsCount;


static  GC		HelpGC = None, HelpBmpGC = None;
static  GC		HelpLineGC = None;
static  Font		HelpFont = None, HelpBmpFont = None;
static  char		**DispPages;
static  FL_COORD	HelpWndWid, HelpWndHei;
static  short		HelpWndEffWidth;
static  short 		HelpWndEffHeight, EffPageWidth;

static  short		HelpWndCharHeight, HelpWndCharWidth, HelpWndCharAscent;
static  short 		PageWidth, LineCount, HelpHelpMode;
static  short		PageCount, TotWidth, LogWidth=0;
static  short		HelpWndStartX, HelpWndStartY;
static  short		PlayAdvance;
static  long		PlayPosition, LastHelpPosition = 0;
static  FL_OBJECT	*PlayAdvanceObj;

static  unsigned long	HelpSepCol, HelpActCol, HelpBgCol, HelpPageNoCol;
static  unsigned long	HelpBtnCol, HelpHelpBtnCol, HelpBtnActCol;
static  unsigned long	HelpLowCol, HelpHighCol, HelpStopCol;
static  unsigned long	HelpTimeOut;

static  char	*HelpBuf = NULL;
static  void	help_xforms_playstop(void);
static  struct	timeval TimePlayStart;
static  Pixmap	HelpBmpCanvas;
static  int		HelpBmpCanvWid, HelpBmpCanvHei;

extern	u_char track_first, track_last;     
static void  set_help_controls_tooltips(short advance);

#ifdef  ICON_WINDOW_SUPPORT
extern  Window		IconWnd;
#endif 

const static char *help_tooltips[] =
 {  "First page" ,        /* 0 */
    "Page back" ,         /* 1 */
    "Column back" ,       /* 2 */
    "Play backward" ,     /* 3 */
    "Play forward" ,      /* 4 */
    "Column forward" ,    /* 5 */
    "Page forward" ,      /* 6 */
    "Last page" ,         /* 7 */
    "Stop" ,              /* 8 */
    "Minimum speed",      /* 9 */
    "Reduce speed",       /* 10 */
    "Fine reduce speed",  /* 11 */
    "Fine incease speed", /* 12 */
    "Increase speed",     /* 13 */
    "Maximum speed"       /* 14 */
};

const static short help_arg_list[] =
{ OPER_FIRSTTRACK,  OPER_PREV,  OPER_BACK,  OPER_PLAYBACK,
  OPER_PLAY,         OPER_FWD,  OPER_NEXT,  OPER_LASTTRACK};

const static short help_tooltip_list_still[] =
{ 0,  1,  2,  3, 4,  5,  6,  7};

const static short help_tooltip_list_bplay[] =
{ 14, 13, 12, 8, 4, 11, 10,  9};
  
const static short help_tooltip_list_fplay[] =
{  9, 10, 11, 3, 8, 12, 13, 14};

#define MIN_TIMEOUT 0
#define MAX_TIMEOUT 2000000
#define HELP_SIZE FL_NORMAL_SIZE
#define HELP_BMP_SIZE FL_TINY_SIZE
#define HELP_PLAY_TIMEOUT ((TIME_OUT_HELP_ADVANCE) * 1000)



void help_xforms_initialize(void)
{
    XFontStruct *xfs; 
    XGCValues	xgcv;
    int i;
    char dashes[2];

    xfs = fl_get_fontstruct(FL_FIXEDBOLD_STYLE, HELP_SIZE);
    HelpFont = xfs->fid;
    HelpWndCharWidth = xfs->max_bounds.width;
    HelpWndCharAscent = xfs->ascent;
    HelpWndCharHeight = xfs->ascent + xfs->descent;

    xfs = fl_get_fontstruct(FL_BOLD_STYLE, HELP_BMP_SIZE);
    HelpBmpFont = xfs->fid;
    HelpBmpCanvWid = xfs->max_bounds.width * 4 - 7;
    HelpBmpCanvHei = xfs->ascent + xfs->descent + 3;
    HelpBmpCanvas = XCreatePixmap(disp, MainWnd, HelpBmpCanvWid,
                                        HelpBmpCanvHei, 1);


    HelpBgCol = spectr_colour[0];    
    HelpActCol = fl_getmcolor(FL_WHITE, &i, &i, &i); // spectr_colour[2];    
    HelpSepCol = spectr_colour[3];    
    HelpBtnCol = fl_getmcolor(FL_BLACK, &i, &i, &i);
    HelpLowCol = fl_getmcolor(FL_DARKGOLD, &i, &i, &i);
    HelpHighCol = fl_getmcolor(FL_SPRINGGREEN, &i, &i, &i);
    HelpHelpBtnCol = spectr_colour[3];
    HelpPageNoCol  = fl_getmcolor(FL_DEEPPINK, &i, &i, &i);  //spectr_colour[1];    
    HelpStopCol  = fl_getmcolor(FL_RED, &i, &i, &i); 

    xgcv.background = HelpBgCol;
    xgcv.foreground = HelpActCol;
    xgcv.font = HelpFont;
    xgcv.graphics_exposures = False;
    xgcv.line_style = LineSolid;   // LineOnOffDash;
    xgcv.line_width = HelpWndCharWidth-2;
    HelpGC = XCreateGC(disp, MainWnd,
                       GCBackground | GCForeground |
		       GCFont | GCGraphicsExposures | 
		       GCLineWidth | GCLineStyle,
		       &xgcv);

    xgcv.line_style =  LineOnOffDash;
    xgcv.foreground = HelpSepCol;
    HelpLineGC = XCreateGC(disp, MainWnd,
                       GCBackground | GCForeground |
		       GCFont | GCGraphicsExposures | 
		       GCLineWidth | GCLineStyle,
		       &xgcv);
    dashes[0] = 10; dashes[1] = 3;
    XSetDashes(disp, HelpLineGC, 0, dashes, 2);

    xgcv.background = 0;
    xgcv.foreground = 0xff;  
    xgcv.font = HelpBmpFont; 
    xgcv.graphics_exposures = False;
    HelpBmpGC = XCreateGC(disp, AllBtns,
                       GCBackground | GCForeground | 
		       GCFont | GCGraphicsExposures,
		       &xgcv);

    set_help_controls_tooltips(10);

    
    HelpBuf = NULL;
    LogWidth = 0;

    HelpTimeOut = HELP_PLAY_TIMEOUT;
    prepare_info_page();
        
    PlayAdvance = 0;
}


void help_xforms_deinitialize(void)
{
   if (HelpGC != None)  XFreeGC(disp, HelpGC);
   if (HelpBmpGC != None)  XFreeGC(disp, HelpBmpGC);
   if (HelpLineGC != None)  XFreeGC(disp, HelpLineGC);
   if (HelpBmpCanvas !=None) XFreePixmap(disp, HelpBmpCanvas);
   if (HelpBuf != NULL) free(HelpBuf);
}	

void help_prepare_canvas(int new_mode)
{   int old_log_wid;
    unsigned long bg_colour;

    if (HelpGC == None) return;
    
    
    fl_get_winsize(HelpWnd, &HelpWndWid, &HelpWndHei);

    bg_colour = spectr_colour[0];
    XSetWindowBackground(disp, HelpWnd, bg_colour);

    XSetForeground(disp, HelpGC, bg_colour);
    XFillRectangle(disp, HelpWnd, HelpGC, 0, 0, HelpWndWid + 2, HelpWndHei);
    
    
    HelpWndEffWidth = (short) (HelpWndWid / HelpWndCharWidth);
    HelpWndStartX = (HelpWndWid - HelpWndCharWidth * HelpWndEffWidth) / 2;
    HelpWndEffHeight = (short) (HelpWndHei / HelpWndCharHeight) - 2;
    HelpWndStartY = (HelpWndHei - HelpWndCharHeight * HelpWndEffHeight) / 2;

    HelpHelpMode = new_mode;
    
    switch(new_mode)
    {
       case FOLDER_HELP:
	    EffPageWidth = HelpWidth;
	    LineCount = HelpLineCount;
            DispPages = HelpPages;
	    break;

       case FOLDER_MISC:
	    EffPageWidth = MiscWidth;
	    LineCount = MiscLineCount;
            DispPages = MiscPages;
	    break;

       case FOLDER_STATUS:
	    update_info_page();
	    EffPageWidth = INFO_LINE_SIZE;
	    LineCount = InfoLineCount;
            DispPages = InfoPages;
    }


    PageWidth = EffPageWidth + 2;
    PageCount = LineCount / HelpWndEffHeight;

    HelpBuf = realloc (HelpBuf, PageWidth);
    if (LineCount % HelpWndEffHeight) PageCount++;
    TotWidth = PageWidth * PageCount;

    old_log_wid = LogWidth;
    if (TotWidth <= HelpWndEffWidth - 3) LogWidth = TotWidth;
    else  LogWidth = TotWidth - HelpWndEffWidth - 2;
    fl_set_slider_bounds(helpSlider, 0, LogWidth);

    if (old_log_wid > 0)
    {	long value = (long) fl_get_slider_value(helpSlider);
		value = value * LogWidth / old_log_wid;
		if (value > LogWidth) value = LogWidth;
        fl_set_slider_value(helpSlider, (double)value);
    }	

    LastHelpPosition = 0;
    fl_redraw_object(helpSlider);


}    

void help_unprepare_canvas(void)
{
    if (PlayAdvance) help_xforms_playstop();

    if (HelpHelpMode == FOLDER_STATUS)
    {   TimeStart = time(NULL); Frames = 0.; }

}
static short help_get_index(char *src)
{     int buttonNo;
      short ret = -1;

      buttonNo = atoi(src);
      HelpBtnActCol = HelpBtnCol;
      
      switch(buttonNo)
      { case 0 ... 15:  /* CBUTTONS + HBUTTONS-1: */
          ret = buttonNo;
	    break;
       
        case 16:
	  ret = 21;
	  break;    
       
        case 17 ... 18:
	  ret = buttonNo-1;
	  break;
	       
        case 40 ... 52:
          {  const char *txtptr;  
    	     int i = buttonNo - 40;
	    
	     if (i<4) txtptr = TimeDispModesShort[i];
	     else
	     if (i<6 || i>=11)
	     {  txtptr = (i<6) ?  "AP" : "LO";
		if (i==5 || i==12)
		  HelpBtnActCol = HelpLowCol;
		else  
		  HelpBtnActCol = HelpHighCol;
	     }	
	     else
	          txtptr = PlayModesShort[i-6];
	    
	     ret = 666;
	     XSetForeground(disp, HelpBmpGC, 0);
	     XFillRectangle(disp, HelpBmpCanvas, HelpBmpGC, 0, 0, 
	                           HelpBmpCanvWid, HelpBmpCanvHei);
	     XSetForeground(disp, HelpBmpGC, 1);
    	     XDrawString(disp, HelpBmpCanvas, HelpBmpGC, 0,
	                       HelpWndCharAscent, txtptr, strlen(txtptr));
          }
          break;

/*       case 70 ... 73:  */
/*           ret = buttonNo-70+OPER_STOP; */
       case 70:
            ret = 19;
	    break;
	    
       case 71:
	    ret = OPER_STOP;
	    break;

       case 72:
            ret = 18;    		
	    break;

       case 77:   /* PAUSE */
            ret = OPER_PAUSE;    		
	    break;

       case 78:   /* PLAY */
            ret = OPER_PLAY;    		
	    break;

/*        case 75 ... 76:
	     ret = OperNotation[buttonNo-75 + OPER_HELPPREV][off]| side_attr;
           break;     
*/
        case 79: 
            ret = 20;    		
	    break;


	/* Help buttons */
        case 80 ... 99: 
	    if (buttonNo >= 90)
	    {  ret = buttonNo - 90;
	       HelpBtnActCol = (ret == 7) ? HelpStopCol : HelpHelpBtnCol;
	    }
	    else
	    {  ret = buttonNo - 80;
	       HelpBtnActCol = HelpActCol;
	    }   

	    if (ret>=8 ) ret += 8;
	    if (ret==5) ret = 13; /* OPER_PLAYBACK;  */  
	    
/*           ret = ( (i==OPER_STOP && off != 1) ? ' '
                   : OperNotation[i][off] ) | side_attr;
*/


      }


      return ret;
}



void help_show_page(long start)
{
    int offset, pageno;
    int x, y, x1, y1, ind, pageno_pos, wid, wid1, wid2; 
    unsigned long txtcol;
    char *src, c;

    if (HelpGC == None) return;

    LastHelpPosition = start;

    pageno = start / PageWidth;
    offset = start % PageWidth; 
    EffPageWidth = PageWidth - 2; 
    start = HelpWndEffHeight * pageno;   /* First index in array */

    XSetForeground(disp, HelpGC, spectr_colour[0]);
    XFillRectangle(disp, HelpWnd, HelpGC, 0, 0, HelpWndWid, HelpWndStartY);
    XFillRectangle(disp, HelpWnd, HelpGC, 0, HelpWndHei-HelpWndStartY-1,
            HelpWndWid, HelpWndStartY );


    x= PageWidth-offset-3;
    if (x <0) 
    {   x += PageWidth; pageno++;  }

    pageno_pos = x - PageWidth/2;
    x = 0;

    while (x < HelpWndEffWidth)
    {  
/*        XSetForeground(disp, HelpLineGC, HelpSepCol); */

	x1 = pageno_pos;
	if (x1 > HelpWndEffWidth) x1 = HelpWndEffWidth;

        XDrawLine(disp, HelpWnd, HelpLineGC, 
	          x*HelpWndCharWidth, HelpWndCharHeight/2,
		  x1*HelpWndCharWidth, HelpWndCharHeight/2);

        XDrawLine(disp, HelpWnd, HelpLineGC, 
	          x*HelpWndCharWidth, HelpWndHei - 2- HelpWndCharHeight/2,
		  x1*HelpWndCharWidth,HelpWndHei - 2-HelpWndCharHeight/2);

	sprintf (HelpBuf, "%02d", pageno+1);

        XSetForeground(disp, HelpGC, HelpPageNoCol);
        XDrawImageString(disp, HelpWnd, HelpGC, 
	          (pageno_pos+1)*HelpWndCharWidth, HelpWndCharAscent+1,
		   HelpBuf, 2);

        XDrawImageString(disp, HelpWnd, HelpGC, 
	          (pageno_pos+1)*HelpWndCharWidth, 
		   HelpWndHei-2-HelpWndCharHeight+HelpWndCharAscent+1,
		   HelpBuf, 2);
	x = pageno_pos + 4;
	pageno_pos += PageWidth;
	pageno = (pageno+1) % PageCount;
    }	

    ind = start;
    
    for (x=0; x<HelpWndEffWidth; x+= wid)
    {
    
        wid = PageWidth - offset;
	wid1 = wid - 2;
	if (wid1 < 0) wid1 = 0;

		
	if (x + wid > HelpWndEffWidth) wid = HelpWndEffWidth - x;
	if (wid1 > wid) wid1 = wid;
	
	x1 = x*HelpWndCharWidth + HelpWndStartX;
	y1 = HelpWndCharAscent + HelpWndStartY;

        XSetForeground(disp, HelpGC, HelpActCol);    

        for (y=0; y<HelpWndEffHeight; y++)
	{
	    if (ind < LineCount)
	    {  src = DispPages[ind];
	       c = *src;
	    }
	    else
	    {  src = NULL;
	       c = '\0';
	    }      
	    	    	    
            if (wid1 > 0)	    
	    {  if (src != NULL)
                   memcpy(HelpBuf, src+offset, wid1);
  	       else
	           memset(HelpBuf, ' ', wid1);  
	    }		 

	    if (HelpHelpMode == FOLDER_HELP && offset < 3 && isdigit(c))
		    memset(HelpBuf, ' ', 3-offset);
	    		
	    if (wid > wid1) memset (HelpBuf+wid1, ' ', wid -wid1);


	    
            if (wid > 0)
	    {
    	        if ( ind < LineCount && c != ' ' && !isdigit(c))
		{  txtcol = (c == '%') ? HelpSepCol :
		            (c == '^') ? HelpActCol : HelpBtnCol;    
		   if (!offset && strchr("%#^", c)) *HelpBuf = ' ';
		}
		else      
	           txtcol = HelpActCol;    
	        
	        XSetForeground(disp, HelpGC, txtcol);    
		XDrawImageString(disp, HelpWnd, HelpGC, 
		  	      x1, y1,  HelpBuf, wid); 
			      
	    }		      

    
	    if (HelpHelpMode == FOLDER_MISC && ind < 5)
	    { int off1 = offset*HelpWndCharWidth;
	       
	      if (off1 < 64)
	        {     wid2 =  64-off1;
		      if (x1 + wid2 > HelpWndWid) wid2 =  HelpWndWid - x1;
		      XCopyArea(disp, IconPmp, HelpWnd, HelpGC,  /*spectr_gc, */
	    		        off1, ind*HelpWndCharHeight,
				wid2, HelpWndCharHeight+3,
				x1, y1-HelpWndCharAscent);
	        }		
	    }	

	    if (HelpHelpMode == FOLDER_HELP && offset < 3 && isdigit(c))
	    { 
	       short i = help_get_index(src);

	       int off1 = offset*HelpWndCharWidth;

	       if (i >= 0)
	       { 
	          XSetForeground(disp, HelpGC, HelpBtnActCol);   
		  if (i==666)
		  {   wid2 =  HelpBmpCanvWid-off1;
		      if (x1 + wid2 > HelpWndWid) wid2 =  HelpWndWid - x1;
	              XCopyPlane(disp, HelpBmpCanvas, HelpWnd, HelpGC, /* spectr_gc, */
	        	    off1, 0, wid2, HelpBmpCanvHei,
                    	    x1, y1-HelpWndCharAscent-1, 1);
		  }	    
		  else	    
		  {   wid2 =  16 - off1;
		      if (x1 + 8 + wid2 > HelpWndWid)
		            wid2 =  HelpWndWid - x1 - 8;
		      if (wid2 > 0)	    
	                XCopyPlane(disp, AllBtns, HelpWnd, HelpGC, /* spectr_gc, */
	                    off1, i*11, wid2, 11,
                            x1+6, y1-HelpWndCharAscent, 1);
		  }			
	       }		
	    }
	    

	    y1 += HelpWndCharHeight;
	    ind++;
	}
	
 	if (ind >= LineCount) ind = 0;   /* This will reverse to start of document */
	
	if (wid - wid1 > 1)
	{
	    x1 = (x+wid1+1)*HelpWndCharWidth + HelpWndStartX + 2;
	    
/*	    XSetForeground(disp, HelpLineGC, HelpSepCol);     */
	    XDrawLine(disp, HelpWnd, HelpLineGC, 
	                  x1, HelpWndStartY,
	                  x1, HelpWndStartY + HelpWndEffHeight*HelpWndCharHeight);
	
	}    
	    
        offset = 0;
     }		
	
/*

        while(x < HelpWndEffWidth)
	{ 	 
	    if (off >= PageWidth)
	    {	ind += HelpWndEffHeight;
		if ((ind - y) >= LineCount) ind = y; 
		src = ind < LineCount ? DispPages[ind] : NULL;
		off = 0;
	    }

	    if (off < EffPageWidth)
  	    {
//        	if (off<3 && src && isdigit(*src))
//            	    typ = help_button_char(src, off); 
//		else
		{   typ = src ? *(src+off) : ' '; 
		    if (typ == '@') typ = '#';  //cCkboard;
    		}
	    } 
	    else
        	typ = (off-EffPageWidth) == 2 ? sep : ' ';

          buf[x] = typ;
          off++;
	  x++;	
       } 
       
       buf[x] = 0;
       
       XDrawImageString(disp, HelpWnd, HelpGC, 
                   HelpWndCharWidth,  y*(HelpWndCharHeight),
		   buf, x); 
       
    }
*/    
    XFlush(disp);

}

void help_xforms_advance(void)
{
    long new_slider =  PlayPosition + PlayAdvance;	
    long max_new_slider = LogWidth + HelpWndEffWidth;

    if (new_slider < 0) new_slider = max_new_slider;
    else
    if (new_slider > max_new_slider) new_slider = 0;
    
    PlayPosition = new_slider;

    if (new_slider > LogWidth) new_slider = LogWidth;
    fl_set_slider_value(helpSlider, new_slider);     

    help_show_page(PlayPosition);
}

void change_help_controls_colour(FL_COLOR new_col)
{   int i;

    for (i=0; i<HelpControlsCount; i++)
	fl_set_object_lcolor(HelpControls[i], new_col);

    fl_set_object_color(helpSlider, SADP_BLACK, new_col);
}

void  set_help_controls_tooltips(short advance)
{  FL_OBJECT *obj;
   const short *help_tooltip_list;
   int  arg;
   short i, j, init_mode = 0;
   const char *text;

   if(advance == 1)
	help_tooltip_list = help_tooltip_list_fplay;
   else
   if(advance == -1)
	help_tooltip_list = help_tooltip_list_bplay;
   else
   {
      help_tooltip_list = help_tooltip_list_still;
      init_mode = (advance != 0);
   }      
	
   for (i=0; i<HelpControlsCount; i++)
   {  
      obj = HelpControls[i];
      arg = obj->argument;

      for (j=0; j<8 && help_arg_list[j] != arg; j++);
      if (j >= 8) continue;
    
      text = help_tooltips[*(help_tooltip_list+j)];
      if (init_mode)
          set_tooltip(obj, text);
      else	  
	  set_tooltip_text(obj, text);
   }

}

#if FL_INCLUDE_VERSION > 88
void help_refresh_canvas(void)
{
     help_show_page(LastHelpPosition); 
}
#endif

void help_xforms_playstop(void)
{   int argument; 
    if (PlayAdvance == 0) return;

    argument =  PlayAdvanceObj->argument;   

    fl_set_object_label (PlayAdvanceObj, 
                         argument == OPER_PLAY ? "@play" : "@4play");
    change_help_controls_colour(FL_WHITE);

    if (TooltipTimeout1 <= 10)
    {  set_help_controls_tooltips(0);
       show_tooltip(PlayAdvanceObj, 0);
    }
#if FL_INCLUDE_VERSION > 88
    help_refresh_canvas();
#endif    
    PlayAdvance = 0;			 
}

void help_xforms_playstart(FL_OBJECT *obj, short advance)
{
    
    if (PlayAdvance != 0)
    {  int tmp = PlayAdvance;
       help_xforms_playstop();   /* This will clean PlayAdvance */
       if(tmp == advance)  return;
    }  

    PlayAdvance = advance;
    PlayAdvanceObj = obj;
    PlayPosition = (long)fl_get_slider_value(helpSlider);
    gettimeofday(&TimePlayStart, NULL);
    change_help_controls_colour(FL_GREEN);
    if (TooltipTimeout1 <= 10)
    {  set_help_controls_tooltips(advance);
       show_tooltip(obj, 0);
    }
       
    fl_set_object_lcolor(obj, FL_RED);
    fl_set_object_label(obj, "@stop");
    fl_redraw_object(obj);
/*    printf ("%ld\n", HelpTimeOut); */
    help_xforms_advance();
}


void help_slider_callback(FL_OBJECT *obj, long par)
{
      help_show_page((long)fl_get_slider_value(obj));
}

void help_change_timeout(long par)
{
    long tmp = HelpTimeOut + par * PlayAdvance * 100;
    if (tmp < MIN_TIMEOUT) tmp = MIN_TIMEOUT;
    if (tmp > MAX_TIMEOUT) tmp = MAX_TIMEOUT;
    HelpTimeOut = tmp;
/*    printf ("%ld %ld\n", par, HelpTimeOut); */
}    


void help_btn_callback(FL_OBJECT *obj, long par)
{    long old_slider, new_slider;

     new_slider = old_slider = (long)fl_get_slider_value(helpSlider);	

     switch(par)
     {  case OPER_NEXT:
	    if (PlayAdvance) 
	    { help_change_timeout(-1000); return; }

	    new_slider += PageWidth;
	    if (new_slider > LogWidth) new_slider = LogWidth;
	    break;
	    
        case OPER_PREV:
	    if (PlayAdvance) 
	    { help_change_timeout(1000); return; }

	    new_slider -= PageWidth;
	    if (new_slider < 0) new_slider = 0;
	    break;
	    	         	
        case OPER_FWD:
	    if (PlayAdvance) 
	    { help_change_timeout(-1); return; }

	    new_slider ++;
	    if (new_slider > LogWidth) new_slider = LogWidth;
	    break;

        case OPER_BACK:
	    if (PlayAdvance) 
	    { help_change_timeout(1); return; }
	    
	    new_slider --;
	    if (new_slider < 0) new_slider = 0;
	    break;

        case OPER_FIRSTTRACK:
	    if (PlayAdvance != 0)
	    {  HelpTimeOut = (PlayAdvance > 0) ? MAX_TIMEOUT : MIN_TIMEOUT;
	       return;
	    }   
	    new_slider = 0;
	    break;
	    
        case OPER_LASTTRACK:
	    if (PlayAdvance != 0)
	    {  HelpTimeOut = (PlayAdvance > 0) ? MIN_TIMEOUT : MAX_TIMEOUT;
	       return;
	    }   
	    new_slider = LogWidth;
	    break;
	    
	case OPER_PLAY:
	    help_xforms_playstart(obj, 1);
	    break;
	    
	case OPER_PLAYBACK:
	    help_xforms_playstart(obj, -1);
	    break;
	    
     } 
     
     if (old_slider != new_slider)     
     {    fl_set_slider_value(helpSlider, new_slider);     
          help_show_page(new_slider);
     }
     	  
}

int help_canvas_callback(FL_OBJECT *obj, Window win, 
		      int win_width, int win_height,
		      XEvent *xev, void *user_data)
{


/*    switch(xev->type)
    {	case ConfigureNotify:
	    help_prepare_canvas(BottomSection); 
	    LastHelpPosition = 0;
	    break;
	    
	case Expose:
*/	
	    if (xev->xexpose.count == 0 )
		help_show_page(LastHelpPosition);
    	    
          
    return 0;
}


void help_idle_callback(void)
{
    if (PlayAdvance != 0) 
    {  struct timeval TimeNew;
       long i = win_state(MainWnd);

       if (i == WithdrawnState || i == IconicState) return;
       
       gettimeofday(&TimeNew, NULL);
       
       if (time_diff(TimeNew, TimePlayStart) > HelpTimeOut)
       {   help_xforms_advance();
           TimePlayStart.tv_sec = TimeNew.tv_sec;
           TimePlayStart.tv_usec = TimeNew.tv_usec;
       }
    } 
}


/*==========================================================================*/
/*                        DATA   BASE   PROCESSING                          */
/*==========================================================================*/

int fill_track_list(FL_OBJECT *brow_tracks)
{  u_char trk;

    fl_clear_browser(brow_tracks);
    
    if (track_first == 0xff) return 0;
    
    for(trk = track_first; trk<=track_last; trk++)
       fl_add_browser_line(brow_tracks, get_full_track_name(trk));

    return track_last-track_first+1;
       
}       

int insert_playlist_browser_line(FL_OBJECT *obj, short trk_no)
{	
    char   line_text[DATA_NAME_SIZE+7];
    int	   line_no;    
    
    line_no = fl_get_browser(obj);    

    sprintf(line_text, "%02d. %s", trk_no, get_full_track_name(trk_no));

    fl_insert_browser_line(obj, line_no, line_text);
    if (cur_plist_pos < 0) cur_plist_pos = line_no;
       
    return line_no;	
}

int insert_play_list_line(FL_OBJECT *obj, short trk_no)
{
    int line_no = fl_get_browser(obj);
    int prefset_no;    

    if (cd_insert_playlist_line(line_no-1, trk_no)) 
    {  /*  fill_play_list(obj); */
	 
        insert_playlist_browser_line(obj, trk_no);

	prefset_no = cd_current_prefset - cd_prefsets;
        if (prefset_no == cd_prefset_count - 1)
	     cd_create_prefset(NULL);

	DataChanged = 1;
    }       

    return line_no;	 
}	 

int delete_play_list_line(FL_OBJECT *obj)
{   int line_no = fl_get_browser(obj);
   
    if (cd_delete_playlist_line(line_no-1)) 
    { 	fl_delete_browser_line(obj, line_no);
	DataChanged = 1;
    }	

    return line_no;
}    	

int fill_play_list(FL_OBJECT *brow_playlist)
{ 
    short i;

    fl_clear_browser(brow_playlist);
    if (track_first == 0xff) return 0;

    fl_add_browser_line(brow_playlist, "**** End Of Play List ****");
    fl_select_browser_line(brow_playlist, 1);

    for (i=0; i<cd_playlist_size; i++)
      insert_playlist_browser_line(brow_playlist, cd_playlist[i]);	
 
    fl_select_browser_line(brow_playlist, cd_playlist_size+1);
    return 1;
}

void correct_play_list(FL_OBJECT *brow_playlist, int trk_no)
{
    char   line_text[DATA_NAME_SIZE+7];
    int    line, maxline;
    sprintf(line_text, "%02d. %s", trk_no, get_full_track_name(trk_no));

    maxline = fl_get_browser_maxline(brow_playlist);

    for(line =1; line <= maxline; line++)    
    {  if (memcmp(line_text, fl_get_browser_line(brow_playlist, line), 2) == 0)
	  fl_replace_browser_line(brow_playlist, line, line_text);
    }

}




/* ===================================================== */
/*                    Tool tips, etc           	    	 */    

#if FL_INCLUDE_VERSION < 88
#define u_cdata u_vdata
#endif 

static int obj_prehandler(FL_OBJECT *obj, int event, 
                    FL_COORD mx, FL_COORD my,
		    int key, void *raw_event)
{  
//    printf ("Prehandler %d\n", event);
     
   switch(event)
   { case  FL_ENTER:
     { /*  char *txt; */
     
        if (obj->objclass == FL_BITMAPBUTTON)
	   fl_set_object_color(obj, FL_MCOL, FL_WHITE);

		   
        if (TooltipTimeout1 <= 10)  /* && 
	     (txt = obj->u_cdata) != NULL && strlen(txt)>0 ) */
	{  TooltipCurTimeout = TooltipTimeout1;
           TooltipTime = time(NULL);
           TooltipObject = obj;
	}   
     }	
        break;
      
     case  FL_LEAVE:
        if (obj->objclass == FL_BITMAPBUTTON)
	   fl_set_object_color(obj, FL_COL1, FL_WHITE);

        disable_tooltip();
        break;
	
	
    case FL_PUSH:
	if (obj->objclass == FL_INPUT)
  	      input_processing(obj);
	       
	break; 
	
/*	
     case FL_PUSH: 
        if (key == FL_MIDDLE_MOUSE || key == FL_RIGHT_MOUSE)
	{  if (TooltipObject) visualise_tooltip();
	   return FL_PREEMPT;      
	}      
	break;
	
     case FL_RELEASE: 
        if (key == FL_MIDDLE_MOUSE || key == FL_RIGHT_MOUSE)
	{  disable_tooltip();
	   return FL_PREEMPT;      
	}      
	break;
*/	
   }
   	
   
   return !FL_PREEMPT;      
}      


void set_tooltip(FL_OBJECT *obj, const char *text)
{ 
   fl_set_object_prehandler(obj, obj_prehandler);
   obj->u_cdata = (char *) text;
       
}    

void set_tooltip_text(FL_OBJECT *obj, const char *text)
{   obj->u_cdata = (char *)text; }


void show_tooltip(FL_OBJECT *obj, short align)
{  char *txt = (char *) obj->u_cdata;
   int  wid, hei, winwid;
   int  ox, oy, ow, oh;
   Window  wnd;    

/*   wnd = fl_winget();  */  
   wnd = MainWnd;    
   fl_get_winsize(wnd, &winwid, &hei); 

   fl_get_string_dimension(obj->lstyle, obj->lsize,
                           txt, strlen(txt), &wid, &hei);
   winwid -= 6;
   wid +=26; hei += 4; 	       

   fl_get_object_geometry(obj, &ox, &oy, &ow, &oh);
  
   if (align > 0)
      ox +=  ow-wid;		/* Right align */
   else
   if (align == 0)
      ox += (ow-wid)/2;		/* Centre align */

   if (ox < 6) ox = 6;
   if (ox+wid > winwid) ox = winwid-wid;
  
   oy  -= hei;
   fl_set_object_geometry(tooltip_text, ox, oy, wid, hei);
 
   
   fl_set_object_label(tooltip_text, txt);
   
   fl_show_object(tooltip_text); 
}


void hide_tooltip(void)
{
   fl_hide_object(tooltip_text); 
#if FL_INCLUDE_VERSION > 88   
   if (BottomSection >= FOLDER_HELP && BottomSection <= FOLDER_MISC /* &&
             tooltip_text->y > helpCanvas->y - 50 */)
              help_refresh_canvas();
#endif
}

int is_tooltip_on(void)
{
    return tooltip_text->visible;
}

void disable_tooltip(void)
{
    if (is_tooltip_on()) hide_tooltip(); 
    TooltipObject = NULL; 
}


short ask_save_question(const char *message)
{  
#if FL_INCLUDE_VERSION < 86
    return fl_show_question("", message, "");
#else
    return fl_show_question(message, 1);
#endif

} 

void show_error_message(const char *message)
{
  fl_show_messages(message);
}

/* I wonder why this feature is not supported by XForms library */
void set_window_icon_name(const char *icon_name)
{
  XTextProperty text_prop;
  XStringListToTextProperty((char **)&icon_name, 1, &text_prop); 
  XSetWMIconName(disp, MainWnd, &text_prop);

#ifdef ICON_WINDOW_SUPPORT
  if (IconWnd != None)
	  fl_wintitle(IconWnd, icon_name);
#endif	  
}


/* Yet another function I wish to see in XForms library */
long  win_state(Window wnd)
{   Atom type_ret;
    int  format_ret;
    unsigned long items_count, bytes_rem;
    long  state;
    long  *data;
    
    if (WMStateAtom == None) return -1;

    XGetWindowProperty(disp, wnd,  WMStateAtom, 0, 1,
                            False, WMStateAtom, 
			    &type_ret, &format_ret, 
			    &items_count, &bytes_rem, (u_char **)&data);

    if (type_ret == None) return -1;
    state = *data;
    
    XFree((void *)data);

    return state;
}    
        			    
short  win_visibility(Window wnd)
{  
    XWindowAttributes xwa;
    

    if (wnd != None && XGetWindowAttributes(disp, wnd, &xwa))
	return (xwa.map_state != IsUnmapped);

    return 0;	
}


int process_imwheel(XEvent *xev)
{ XButtonEvent xbtn;
   int btn_no, key_state;
   OPERATION oper = OPER_NONE;
	   
   xbtn = xev->xbutton;
   btn_no = xbtn.button;
   
   key_state = xbtn.state;

   if (btn_no == WheelBtnFwd) {
	 if (key_state & (ShiftMask | Button2Mask))
    	oper = OPER_NEXT;
	 else
		oper = OPER_FWD;
   } else
   if (btn_no == WheelBtnBack) {
	  if (key_state & (ShiftMask | Button2Mask))
  		oper = OPER_PREV;
	  else
		oper = OPER_BACK;
   } else
   if (btn_no == WheelBtnNext) {
	  if (key_state & (ShiftMask | Button2Mask))
    	oper = OPER_FWD;
	  else
		oper = OPER_NEXT;
   } else
   if (btn_no == WheelBtnPrev) {
	  if (key_state & (ShiftMask | Button2Mask))
		oper = OPER_BACK;
	  else
    	oper = OPER_PREV;
   }  		
	   
   if(oper != OPER_NONE)
   {  cdaudio_operate(oper);
      return 1;
   }	   	   

   return 0;
}
