/*  =========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com       
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See COPYRIGHT regarding distribution policy and
            conditions of use.
 
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <linux/cdrom.h>
#include <forms.h>
#include "sad.h"
#include "sadp_xforms.h"

char  CDDeviceName[81];

/*=============================*/
/*         DSP_SUPPORT         */
#ifdef DSP_SUPPORT
short   FourWndCount = 2, UseMMap = 1;
u_int   SamplingRate = 11025u;
short	  AudioSampleSize = 16;
short	  FourGain = 0, WaveVScale = 0;
short	  FourInterlace = 1;

/*  0 - don't use device number for OSS  */
/* -1 - no audio device */
/* -2 - path specified explicitly */
int   AudioDeviceNumber = 0;
char  AudioDeviceName[101];

#else
short  FourWndCount = 0;
#endif
/*                             */
/*=============================*/

/*=============================*/
/*        MIXER_SUPPORT        */
#ifdef MIXER_SUPPORT
/*  0 - don't use device number for OSS  */
/* -1 - no mixer device */
/* -2 - path specified explicitly */
int   MixerDeviceNumber = 0;
char  MixerDeviceName[101];
#endif
/*                             */
/*=============================*/


short RunBackground;
short QuietMode = 0;
short CharSet = 0;
short BkgrColour = -1, ShadColour = -1, BottomColour=-1;
short ForceReg = 0;
short FourWndRes = DEFAULT_BAR_WIDTH;
short AutoPlay = DEFAULT_AUTOPLAY, LoopPlay = DEFAULT_LOOPPLAY;
short ProbeCD = DEFAULT_PROBE;
short SaveSet, SaveData;
short TooltipTimeout1 = DEFAULT_TOOLTIP_TIMEOUT1;
short TooltipTimeout2 = DEFAULT_TOOLTIP_TIMEOUT2;
short TooltipTimeout3 = DEFAULT_TOOLTIP_TIMEOUT3;

short Obturate = DEFAULT_OBTURATE;
short WaveHRes = DEFAULT_PIX_WIDTH;
short WaveVRes = DEFAULT_PIX_HEIGHT;

int  TimeoutStart = TIME_OUT_START;
int  TimeoutRepos = TIME_OUT_REPOSITION;
int  TimeoutEject = TIME_OUT_EJECT;
int  TimeoutLoad = TIME_OUT_LOAD;
int  DurationIntro = INTRO_DURATION_SEC;
int  DurationAdvance = STEP_DISCRETE; 

char  BkgrColourName[31];

char  UserAddr[151];
char  MailServer[151];
char  AppVersion[15];
char  UserFullName[151];
char  ProxyURL[151];
short UseProxy=0, ProtocolUsed=0;
short UseLogFile = 0;
char  *AppName;

PLAY_MODE_TYPE  PlayMode = PLAY_NORMAL;
TIME_DISPLAY_MODE_TYPE TimeDisplayMode = DM_ELAPSED;
PLACE_MODE_TYPES PlaceMode;	
PLATFORM  Platform;

#ifdef ICON_WINDOW_SUPPORT
ICON_STYLE_TYPES IconStyle = ICONSTYLE_WINDOW;
#endif


long TimeStart;
double Frames;
SPECTR_DISPLAY_MODE SpectrDisplayMode = SDM_MODULUS;	


extern short   HelpMode;
extern u_char track_cur;
extern u_char cd_status;
extern short  OptionsChanged;




void TerminationHandler(int code)
{


    if (code != SIGKILL) cdaudio_deinitialize();
    sound_terminate();	

    screen_deinitialize();


    if (code == 0)
    {  if (!RunBackground && ! QuietMode)
			print_epilogue();
       exit(0);
    }
    else   
       exit(16);	
}




int main(int argc, char *argv[])
{

      Platform = PLTF_XFORMS;
      AppName = "xsadp";	

#ifdef RCDDB_SUPPORT
      rcddb_initargs();
#endif


      if (!start_xformsing(&argc, argv))  /* fl_initialize is inside it */
	    return 16;

 
     if ( !cdaudio_initialize() ||
	   !sound_initialize()   || !screen_initialize(argc, argv) ||
           !cdaudio_start()      || !sound_start()
        )
      { 
         OptionsChanged = 0;
         TerminationHandler(666); 
                    return 8;
      }


      signal(SIGTERM, TerminationHandler);
      signal(SIGKILL, TerminationHandler);

      TimeStart = time(NULL);
      Frames = 0;

      foreground_processing();


      TerminationHandler(0);
      return 0;

}

