/*                  -----===== Source for Xtuner =====-----                  */
/*                                                                           */
/*          Copyright (c) Mike Tinnes (tinnes@kitten.ndscs.nodak.edu)        */
/*                                                                           */
/*                original source completed 4-24-96 (ver. 1.00)              */
/*                 current source completed 8-29-96 (ver. 2.0)               */
/*                                                                           */
/*        THIS SOURCE IS PROVIDED UNDER THE GNU GENERAL PUBLIC LICENSE       */
/*                                                                           */
/*  Thanks to Lars Koeller (Lars_Koeller@odie.physik2.uni-rostock.de) for    */
/*  the port to FreeBSD!                                                     */

/* Form definition file generated with fdesign. */
/* Includes */
#ifdef _HAVE_PARAM_H
#  include <sys/param.h>
#endif

#if (defined(BSD) && (BSD >= 199306))
# include <osreldate.h>
#endif

#if (defined(BSD) && (BSD >= 199306))
#  include "/usr/X11/include/X11/forms.h"
#  include <machine/cpufunc.h>
#  include <stdlib.h>
#else
#  include "forms.h"
#  include <asm/io.h>
#endif
#include "xtuner.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* Global defines */
#define FCODE(f)     ((int)(((float)(f)-88.0)*40)+0xf6c)

#if (defined(BSD) && (BSD >= 199306))
#  define OUTW(word,port)  outw(port,word)
#  define OUTB(byte,port)  outb(port,byte)
#else
#  define OUTW(word,port)  outw(word,port)
#  define OUTB(byte,port)  outb(byte,port)
#endif

#define HOMEDIR "/root/.radiorc"
static FD_xtuner * drawui;
static Display *dpy;

int radioflag = OFF;
int setflag = OFF;
int muteflag = OFF;
int autoflag = OFF;
int on_hours;
int on_mins;
int off_hours;
int off_mins;
int set_type;
static float freq = 98.7;
static float vol_level = 0;
unsigned long RPORT = 0x30f;


/* Prototypes */
void radioon(int ch, int p2);
void radiooff(void);
void volumeup(void);
void volumedn(void);
void initialize(int flag);
void write_file(void);
void update(void);
void doexit(void);


/* Defualt presets */
float MemCh[10] =
{
  93.7,
  107.9,
  105.5,
  103.3,
  98.7,
  106.3,
  92.7,
  103.2,
  104.3,
  102.3
};


int main (int argc, char *argv[])
{
#if (defined(BSD) && (BSD >= 199306))
  int fpiopl;
#endif
  
  /* --------------------------------------------------------------------- */

  /* Process command line option */
  if (argc > 1)
  {
    if (argv[1][0] == '-')
    {
      switch (argv[1][1])
      {
        default:
          fprintf(stderr,"Usage: xtuner [-0x30 | -0x20]\n");
          fprintf(stderr,"Which specifies the port for the radio card\n");
          exit(1);
          break;
        case '0':
          if (argv[1][3] == '2')
          {
            RPORT = 0x20f;
            fprintf(stderr,"Port 0x20\n");  
          }
          else if (argv[1][3] == '3')
          {
            fprintf(stderr,"Port 0x30\n");
          }
          else
          {
            fprintf(stderr,"Invalid port number\n");
            exit(1);
            break;
          }
      }   
    }
    else
    {
      fprintf(stderr,"Usage: xtuner [-0x20 | -0x30]\n");
      fprintf(stderr,"Which specifies the port for the radio card\n");
      exit(1);
    }      
  }

  /* -------------------------------------------------------------------- */

#if (defined(BSD) && (BSD >= 199306))
  if( (fpiopl = open( "/dev/io", O_RDONLY ) < 0) ) 
  {
    fprintf(stderr, "XTuner: failed to gain IO privledges.\n");
    exit(1);
  }
#else
  if(ioperm(RPORT,2,1) < 0)
  {
    fprintf(stderr, "Xtuner: failed to gain IO privledges. \n");
    exit(1);
  }
#endif
  initialize(0);
  initialize(1);
 
  dpy = fl_initialize(&argc, argv, 0, 0, 0);
  drawui = create_form_xtuner();
  fl_show_form(drawui->xtuner, FL_PLACE_FREE, FL_FULLBORDER, "Xtuner");
  
  fl_do_forms(); 
  fl_hide_form(drawui->xtuner);
  write_file();
#if (defined(BSD) && (BSD >= 199306))
  close(fpiopl);
#else
  ioperm(RPORT,2,0);
#endif
  return 0;
}

/* ======================================================================= */
FD_xtuner *create_form_xtuner(void)
{
  FL_OBJECT *obj;
  FD_xtuner *fdui = (FD_xtuner *) fl_calloc(1, sizeof(*fdui));
  
  /* ------------------------------------------------------------------ */
  fdui->quitform = fl_bgn_form(FL_UP_BOX, 320, 120);
    fl_add_box(FL_NO_BOX,160,40,0,0,"Do you want to quit?");
    fdui->yes = obj = fl_add_button(FL_NORMAL_BUTTON,40,70,80,30,"Yes");
    fdui->no  = obj = fl_add_button(FL_NORMAL_BUTTON,200,70,80,30,"No");
  fl_end_form();
  
  /* ------------------------------------------------------------------ */
  fdui->quitform2 = fl_bgn_form(FL_UP_BOX, 320, 120);
    fl_add_box(FL_NO_BOX,160,40,0,0,"Play music in background?");
    fdui->sp = obj = fl_add_button(FL_NORMAL_BUTTON,40,70,80,30,"Yes");
    fdui->dp  = obj = fl_add_button(FL_NORMAL_BUTTON,200,70,80,30,"No");
  fl_end_form(); 
   
  /* ------------------------------------------------------------------ */ 
  fdui->set_time = fl_bgn_form(FL_NO_BOX, 170, 130);
    obj = fl_add_box(FL_UP_BOX,0,0,170,130,"");
  fdui->hrs_up = obj = fl_add_button(FL_TOUCH_BUTTON,40,70,20,20,"+");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,do_set_time,0);
  fdui->hrs_dn = obj = fl_add_button(FL_TOUCH_BUTTON,60,70,20,20,"-");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,do_set_time,1);
  fdui->mins_up = obj = fl_add_button(FL_TOUCH_BUTTON,90,70,20,20,"+");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,do_set_time,2);
  fdui->mins_dn = obj = fl_add_button(FL_TOUCH_BUTTON,110,70,20,20,"-");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,do_set_time,3);
  fdui->hours = obj = fl_add_box(FL_FRAME_BOX,40,40,40,30,"");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE);    
  fdui->mins = obj = fl_add_box(FL_FRAME_BOX,90,40,40,30,"");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE);
    fl_set_object_callback(obj,do_set_time,2);
  obj = fl_add_text(FL_NORMAL_TEXT,80,40,10,20,"*");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_BLACK);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_FIXEDBOLD_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,80,50,10,20,"*");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_BLACK);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_FIXEDBOLD_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,50,10,70,20,"Set Time");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
  fdui->done = obj = fl_add_button(FL_NORMAL_BUTTON,40,100,90,20,"Done");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_FIXED_STYLE);  
    
  fl_end_form();
   
  /* ----------------------------------------------------------------- */ 
  fdui->xtuner = fl_bgn_form(FL_NO_BOX, 510, 170);
    obj = fl_add_box(FL_UP_BOX,0,0,510,170,"");
    
  obj = fl_add_text(FL_NORMAL_TEXT,10,80,200,20,"Xtuner by Mike Tinnes");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
  
  fdui->display = obj = fl_add_box(FL_SHADOW_BOX,20,20,250,50,"");
    fl_set_object_boxtype(obj,FL_DOWN_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_GREEN);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,12);
    fl_set_object_lstyle(obj,3);  
  
  fdui->freqdisp = obj = fl_add_text(FL_NORMAL_TEXT,150,25,150,40,"");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_PALEGREEN);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
    
   fdui->timedisp = obj = fl_add_clock(FL_DIGITAL_CLOCK,50,25,100,40,"");
    fl_set_object_boxtype(obj,FL_ROUNDED_BOX);
    fl_set_object_color(obj,FL_BLACK,FL_YELLOW);
    fl_set_object_lcol(obj,FL_YELLOW);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
    
  fdui->pstdisp = obj = fl_add_text(FL_NORMAL_TEXT,240,30,245,35,"");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_RED);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLD_STYLE+FL_SHADOW_STYLE);
    
  fdui->on_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,0,0,"");
    fl_set_object_callback(obj,do_timer,ON);
    
  fdui->off_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,0,0,"");
    fl_set_object_callback(obj,do_timer,OFF);
  
  /* --------- buttons ----------- */   
  fdui->power_but = obj = fl_add_lightbutton(FL_PUSH_BUTTON,430,20,50,30,"");     
    fl_set_object_color(obj,FL_COL1,FL_RED);
    fl_set_object_callback(obj,power,0);
    
  fdui->on_timer_but = obj = fl_add_lightbutton(FL_PUSH_BUTTON,10,120,40,20,"On");
    fl_set_object_callback(obj,set_timer,ON);
  
  fdui->auto_but = obj = fl_add_lightbutton(FL_PUSH_BUTTON,100,120,40,20,"On");
    fl_set_object_callback(obj,set_timer,AUTOON);
    
  obj = fl_add_button(FL_NORMAL_BUTTON,140,120,40,20,"Off");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_callback(obj,set_timer,AUTOOFF);
  
  obj = fl_add_button(FL_NORMAL_BUTTON,50,120,40,20,"Off");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_callback(obj,set_timer,OFF);
    
  fdui->volumedn = obj = fl_add_button(FL_TOUCH_BUTTON,190,120,40,20,"-");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE); 
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,adjust_volume,1);
    
  fdui->volumeup = obj = fl_add_button(FL_TOUCH_BUTTON,230,120,40,20,"+");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE); 
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,adjust_volume,0);
    
  fdui->mute_but = obj = fl_add_lightbutton(FL_PUSH_BUTTON,280,120,40,20,"");
    fl_set_object_callback(obj,mute,0);
  
  obj = fl_add_button(FL_TOUCH_BUTTON,330,120,40,20,"-");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,tuner,0);
    
  obj = fl_add_button(FL_TOUCH_BUTTON,370,120,40,20,"+"); 
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,tuner,2);
    
  obj = fl_add_button(FL_TOUCH_BUTTON,420,120,40,20,"<");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,tuner,1);
    
  obj = fl_add_button(FL_TOUCH_BUTTON,460,120,40,20,">");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,tuner,3);
    
  /* ---------- Text ----------- */
  
  obj = fl_add_text(FL_NORMAL_TEXT,430,50,50,30,"Power");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);  
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
      
  obj = fl_add_text(FL_NORMAL_TEXT,10,140,80,20,"Sleep");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
    
  obj = fl_add_text(FL_NORMAL_TEXT,115,140,50,20,"Alarm");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
    
  obj = fl_add_text(FL_NORMAL_TEXT,190,140,80,20,"Volume");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
  
  obj = fl_add_text(FL_NORMAL_TEXT,330,140,80,20,"Fine");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
      
  obj = fl_add_text(FL_NORMAL_TEXT,420,140,80,20,"Tune");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE);
    
  obj = fl_add_text(FL_NORMAL_TEXT,275,140,50,20,"Mute");
    fl_set_object_lcol(obj,FL_WHITE);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);  
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_SHADOW_STYLE); 

  fdui->presets = fl_bgn_group();
  
  fdui->setmem = obj = fl_add_lightbutton(FL_RADIO_BUTTON,210,80,60,20,"Mem");
    fl_set_object_color(obj,FL_COL1,FL_RED);
    fl_set_object_callback(obj,set_presets,0);
  
  obj = fl_add_button(FL_NORMAL_BUTTON,300,60,30,30,"5");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,5);
    
  obj = fl_add_button(FL_NORMAL_BUTTON,300,20,30,30,"1");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,1);
    
  obj = fl_add_button(FL_NORMAL_BUTTON,330,20,30,30,"2");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,2);
       
  obj = fl_add_button(FL_NORMAL_BUTTON,330,60,30,30,"6"); 
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);  
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,6);
       
  obj = fl_add_button(FL_NORMAL_BUTTON,360,20,30,30,"3"); 
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);  
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,3);  
     
  obj = fl_add_button(FL_NORMAL_BUTTON,360,60,30,30,"7");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);   
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,7);  
     
  obj = fl_add_button(FL_NORMAL_BUTTON,390,20,30,30,"4");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);   
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,4);  
     
  obj = fl_add_button(FL_NORMAL_BUTTON,390,60,30,30,"8");
    fl_set_object_color(obj,FL_COL1,FL_BOTTOM_BCOL);
    fl_set_object_lcol(obj,FL_GREEN);   
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,preset,8); 
      
  fl_end_group();
      
  /* -------- frames --------- */  
  obj = fl_add_frame(FL_UP_FRAME,10,10,270,100,"");
  obj = fl_add_frame(FL_UP_FRAME,290,10,210,100,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,10,120,80,40,"");        
  obj = fl_add_frame(FL_ENGRAVED_FRAME,190,120,80,40,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,330,120,80,40,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,420,120,80,40,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,280,120,40,40,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,100,120,80,40,"");
  
  fl_end_form();
    
  return fdui;

}
/* ======================================================================== */
void r_out(int v, int n)
{
  while (n--)
  {
    if (v&1)
    {
      OUTW(5,RPORT);
      OUTW(5,RPORT);
      OUTW(7,RPORT);
      OUTW(7,RPORT);
    }
    else
    {
      OUTW(1,RPORT);
      OUTW(1,RPORT);
      OUTW(3,RPORT);
      OUTW(3,RPORT);
    }
    v>>=1;
  }
}

/* ======================================================================= */
void mute(FL_OBJECT *ob, long flag)
{   
  if (muteflag)
  {
    muteflag = OFF;
    if (radioflag)
      radioon(FCODE(freq),0xa0);
  }
  else
  {
    muteflag = ON;
    radiooff();
  }
}

/* ======================================================================= */
void power(FL_OBJECT *ob, long flag)
{
  if (radioflag)
  {
    fl_show_form(drawui->quitform,FL_PLACE_MOUSE,FL_TRANSIENT,"");
    while (fl_do_forms() != drawui->no)
    {
      if (drawui->yes)
        doexit();
    }
   
    fl_hide_form(drawui->quitform);
    
    radiooff();
    radioflag = OFF;
    
    fl_set_button(drawui->power_but,0);
    fl_redraw_object(drawui->display);
  }
  else
  {
    if (muteflag == OFF) 
      radioon(FCODE(freq),0xa0);
    
    radioflag = ON;
    update();
  }
}

/* ======================================================================== */
void radioon(int ch, int p2)
{
  update();
 
  r_out(ch,16);
  r_out(p2,8);

  usleep(1000);
  OUTB(0,RPORT);

  usleep(50000);
  OUTB(0xc8,RPORT);
}

/* ====================================================================== */
void radiooff(void)
{ 
  r_out(FCODE(88.0),16);
  r_out(0xa0,8);

  OUTB(0,RPORT);
  OUTB(0xc0,RPORT);
}

/* ======================================================================= */
void preset(FL_OBJECT *ob, long channel)
{
  char str[100];
    
  if (!radioflag)
  {
    return;
  }
  
  if (setflag)
  {
    MemCh[(int)channel-1] = freq;
    write_file();
    setflag = OFF;
    update();
    fl_set_button(drawui->setmem,0);
    return;
  }
  
  freq = MemCh[(int)channel-1];
  sprintf(str, "%d", (int)channel);
  fl_set_object_label(drawui->pstdisp,str);
  update();
  
  if (muteflag == OFF)
    radioon(FCODE(MemCh[(int)channel-1]),0xa0);         
}
/* ======================================================================== */
void adjust_volume(FL_OBJECT *ob, long vol)
{

  if (!radioflag)
  {
    return;
  }
 
  if ((vol == 0) && (vol_level < 15))
  {
    volumeup();
    vol_level++;
  }
  if ((vol == 1) && (vol_level > 0))
  {
    volumedn();
    vol_level--;
  }

}

/* ======================================================================== */
void tuner(FL_OBJECT *ob, long button)
{
  if (!radioflag)
  {
    return;
  }

  switch(button)
  {
    case 0:
      freq -= .025;
      break;
    case 1:
      freq -= 1;
      break;
    case 2:
      freq += .025;
      break;
    case 3:
      freq += 1;
      break;
  }
  if (freq > 107.9)
  {
    freq = 107.9;
  }
  if (freq < 87.9)
  {
    freq = 87.9;
  }
  
  fl_set_object_label(drawui->pstdisp,"");
  update();
  
  if (muteflag == OFF)
    radioon(FCODE(freq),0xa0);
  
} 

/* ======================================================================== */ 
void volumeup(void)
{
  OUTB(0x88,RPORT);
  usleep(100000);
  OUTB(0xc8,RPORT);
}

/* ======================================================================== */
void volumedn(void)
{
  OUTB(0x48,RPORT);
  usleep(100000);
  OUTB(0xc8,RPORT);
}

/* ======================================================================== */
void initialize(int flag)
{
  int i;
  FILE *fdin;

  if (flag == 0)
  {
    for (i=0; i<20; i++)
    {
      volumedn();
      vol_level = 0;
    }
  } 
  
  if (flag == 1)
  {
    if ((fdin = fopen(HOMEDIR, "a+")) == NULL)
    { 
      printf("Error opening file!");
      return;
    } 
    rewind(fdin);

    for (i=0; i<10; i++)
    {
      if(fread(&MemCh[i], sizeof(MemCh[i]), 1, fdin) == 0) 
      {
        fclose(fdin);
        return;
      }
    }       
 
    fclose(fdin);
   
  }
} 

/* ======================================================================= */
void set_presets(FL_OBJECT *ob, long but)
{
  if (!radioflag)
  {
    fl_set_button(drawui->setmem,0);
    return;
  }
  if (setflag)
  {
    setflag = OFF;
    update();
    fl_set_button(drawui->setmem,0);
    return;
  }
 
  setflag = ON;
}

/* ======================================================================== */
void write_file(void)
{
  int i;
  int fd;

  if (fd = open(HOMEDIR, O_RDWR) == -1)
  {
    fl_set_object_label(drawui->display, "Error opening file!");
    return;
  }

  if (write(fd, MemCh, sizeof(MemCh)) == -1)
  {
    fl_set_object_label(drawui->display, "Error writing file!");
    return;
  }
  close(fd);
}

/* ======================================================================= */
void update(void)
{
  char str[100];
  
  fl_redraw_object(drawui->display);
  
  sprintf(str, "%.3f", (float)freq);
  fl_set_object_label(drawui->freqdisp, str);
  fl_redraw_object(drawui->pstdisp);
  
  fl_redraw_object(drawui->freqdisp);
  fl_redraw_object(drawui->timedisp);
  
}

/* ======================================================================= */
void doexit(void)
{
  fl_hide_form(drawui->quitform);
  fl_show_form(drawui->quitform2,FL_PLACE_MOUSE,FL_TRANSIENT,"");
  
  while (fl_do_forms() != drawui->sp)
  { 
    if (drawui->dp)
    radiooff();
    break;
  }
   
  fl_hide_form(drawui->quitform2);
  fl_hide_form(drawui->xtuner);
  
  write_file();
  #if (defined(BSD) && (BSD >= 199306))
    close(fpiopl);
  #else
    ioperm(RPORT,2,0);
  #endif
  exit(0);  
}

/* ======================================================================== */
void do_timer(FL_OBJECT *ob, long status)
{
  if (status == ON)
  {
    if (muteflag == OFF)
      radioon(FCODE(freq),0xa0);
    
    radioflag = ON;  
    update();
    fl_set_button(drawui->auto_but,0);
    fl_set_button(drawui->power_but,1);
  }
  else
  {
    radiooff();
    radioflag = OFF;
    fl_set_button(drawui->on_timer_but,0);
    fl_set_button(drawui->power_but,0);
    fl_redraw_object(drawui->display);
  }
}

/* ======================================================================== */
void set_timer(FL_OBJECT *ob, long status)  
{
  char minute[10];
  char hour[10];
  
  if (status == OFF)
  {
    fl_set_timer(drawui->off_timer,0);
    fl_set_button(drawui->on_timer_but,0);
    return;
  }
  
  if (status == AUTOOFF)
  {
    fl_set_timer(drawui->on_timer,0);
    fl_set_button(drawui->auto_but,0);
    return;
  }
  
  if (status == ON)
    set_type = 0;
  else
    set_type = 4;
    
  fl_show_form(drawui->set_time,FL_PLACE_MOUSE,FL_NOBORDER,"");
  
  if (set_type > 3)
  {      
    sprintf(hour, "%d", on_hours);
    if (on_mins < 10)
      sprintf(minute, "0%d", on_mins);
    else
      sprintf(minute, "%d", on_mins);
  }
  else 
  {    
    sprintf(hour, "%d", off_hours);
    if (off_mins < 10)
      sprintf(minute, "0%d", off_mins);
    else
      sprintf(minute, "%d", off_mins);
  }
  
  fl_set_object_label(drawui->hours,hour);
  fl_set_object_label(drawui->mins,minute);
  
  while(fl_do_forms() != drawui->done)
    ;
    
  fl_hide_form(drawui->set_time);
 
  if ((status == ON) && ((off_hours + off_mins) > 0))
  {
    fl_set_timer(drawui->off_timer,(off_hours*60*60) + off_mins*60);
  }     
  if (status == AUTOON && ((on_hours + on_mins) > 0))
  {
    fl_set_timer(drawui->on_timer,(on_hours*60*60) + on_mins*60);
  }
  
  if ((off_hours + off_mins) == 0)
    fl_set_button(drawui->on_timer_but,0);
  if ((on_hours + on_mins) == 0)    
    fl_set_button(drawui->auto_but,0);
   
}

/* ========================================================================= */
void do_set_time(FL_OBJECT *ob, long type)
{
  char minute[10];
  char hour[10];
  
  type += set_type;
  
  switch (type)
  {
    case 0: off_hours++;
            if (off_hours > 23)
              off_hours = 23;
            break;
    case 1: off_hours--;
            if (off_hours < 0)
              off_hours = 0;
            break;
    case 2: off_mins++;
            if (off_mins > 59)
              off_mins = 59;
            break;
    case 3: off_mins--;
            if (off_mins < 0)
              off_mins = 0;
            break;
    case 4: on_hours++;
            if (on_hours > 23)
              on_hours = 23;
            break;
    case 5: on_hours--;
            if (on_hours < 0)
              on_hours = 0;
            break;
    case 6: on_mins++;
            if (on_mins > 59)
              on_mins = 59;
            break;
    case 7: on_mins--;
            if (on_mins < 0)
              on_mins = 0;
            break;
    default: break;
  }
  
  if (set_type > 3)
  {      
    sprintf(hour, "%d", on_hours);
    if (on_mins < 10)
      sprintf(minute, "0%d", on_mins);
    else
      sprintf(minute, "%d", on_mins);
  }
  else 
  {    
    sprintf(hour, "%d", off_hours);
    if (off_mins < 10)
      sprintf(minute, "0%d", off_mins);
    else
      sprintf(minute, "%d", off_mins);
  }
  
  fl_set_object_label(drawui->hours,hour);
  fl_set_object_label(drawui->mins,minute);
}
