
/* The audio CD-ROM interface routines

   Thanks to cdtools (copyright 1994 thomas insel) for example code
   on managing the CD-ROM.
*/

#include	<sys/types.h>
#include	<sys/file.h>
#include	<sys/ioctl.h>
#include	<stdio.h>
#include	<unistd.h>
#include	<errno.h>
#include	<fcntl.h>
#include	<tcl.h>

#ifdef sun
#  include	<sundev/srreg.h>
#elif defined linux
#  include	<linux/cdrom.h>
#else
#  error Please fix includes for your system in commands.c
#endif

#define DEV_CDROM	"/dev/cdrom"

static int do_play(Tcl_Interp *interp, int argc, char *argv[], int cdfile);
static int do_pause(Tcl_Interp *interp, int argc, char *argv[], int cdfile);
static int do_stop(Tcl_Interp *interp, int argc, char *argv[], int cdfile);
static int do_eject(Tcl_Interp *interp, int argc, char *argv[], int cdfile);
int CDROM_Cmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]);

static char *cdrom_dev;		/* The pathname of the cdrom device */
static int cdrom_fd=(-1);	/* File descriptor to the cdrom device */

int CDROM_Cmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	char  buffer[BUFSIZ];
	char *progname=argv[0];
	char *args[32];

	/* Initialize the CD-ROM, if requested */
	if ( argv[1] && strcmp(argv[1], "init") == 0 ) {
		if ( argv[2] ) {
			if ( ((cdrom_dev=(char *)
					malloc(strlen(argv[2])+1))) == NULL ) {
				Tcl_SetResult(interp, "Out of memory",
								TCL_VOLATILE);
				return(TCL_ERROR);
			}
			strcpy(cdrom_dev, argv[2]);
		} else
			cdrom_dev = DEV_CDROM;

		/* If we have already opened a CD-ROM, close it. */
		if ( cdrom_fd >= 0 ) close(cdrom_fd);

		/* Now open the new CD-ROM device. */
		if ( (cdrom_fd=open(cdrom_dev, O_RDONLY, 0)) < 0 ) {
			sprintf(buffer, "Can't open %s: %s",
						cdrom_dev, strerror(errno));
			Tcl_SetResult(interp, buffer, TCL_VOLATILE);
			return(TCL_ERROR);
		}
		return(TCL_OK);
	}

	/* Make sure we have opened a CD-ROM device */
	if ( cdrom_fd < 0 ) {
		sprintf(buffer, 
			"CD-ROM not initialized with '%s init' command", 
								progname);
		Tcl_SetResult(interp, buffer, TCL_VOLATILE);
		return(TCL_ERROR);
	}
	/* Do we have a command?  If not, return the current cdrom device */
	if ( ! argv[1] ) {
		Tcl_SetResult(interp, cdrom_dev, TCL_VOLATILE);
		return(TCL_OK);
	}
	--argc; ++argv;

	if ( strcmp(argv[0], "play") == 0 )
		return(do_play(interp, argc, argv, cdrom_fd));
	else if ( strcmp(argv[0], "stop") == 0 )
		return(do_stop(interp, argc, argv, cdrom_fd));
	else if ( strcmp(argv[0], "pause") == 0 )
		return(do_pause(interp, argc, argv, cdrom_fd));
	else if ( strcmp(argv[0], "eject") == 0 )
		return(do_eject(interp, argc, argv, cdrom_fd));
	else {
		sprintf(buffer, 
			"Usage: %s [ init | pause | stop | eject | play N ]", 
								progname);
		Tcl_SetResult(interp, buffer, TCL_VOLATILE);
		return(TCL_ERROR);
	}
}
          
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	These routines taken nearly directly from cdtools, written
			by thomas insel, 1994
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
static int do_play(Tcl_Interp *interp, int argc, char *argv[], int cdfile)
{
    char  buffer[BUFSIZ];
    struct cdrom_tochdr tochdr;
    struct cdrom_ti ti;
    struct cdrom_subchnl subchnl;

    subchnl.cdsc_format = CDROM_MSF;

    if ( argc == 1 ) {
        if ( ioctl(cdfile, CDROMSUBCHNL, &subchnl) == -1 ) {
            sprintf(buffer, "%s: ioctl cdromsubchnl: %s", 
						argv[0], strerror(errno));
	    Tcl_SetResult(interp, buffer, TCL_VOLATILE);
            return(TCL_ERROR);
        }
    }

    if ( argc == 1 && subchnl.cdsc_audiostatus == CDROM_AUDIO_PAUSED ) {

        if ( ioctl(cdfile, CDROMRESUME) == -1 ) {
            sprintf(buffer, "%s: ioctl cdromresume: %s", 
						argv[0], strerror(errno));
	    Tcl_SetResult(interp, buffer, TCL_VOLATILE);
            return(TCL_ERROR);
        }

    } else {

        if ( ioctl(cdfile, CDROMREADTOCHDR, &tochdr) == -1 ) {
            sprintf(buffer, "%s: ioctl cdromreadtochdr: %s", 
						argv[0], strerror(errno));
	    Tcl_SetResult(interp, buffer, TCL_VOLATILE);
            return(TCL_ERROR);
        }

        ti.cdti_trk0 = tochdr.cdth_trk0;
        ti.cdti_ind0 = 1;
        ti.cdti_trk1 = tochdr.cdth_trk1;
        ti.cdti_ind1 = 1;

        if ( argc >= 2 ) ti.cdti_trk0 = atoi(argv[1]);
        if ( argc >= 3 ) ti.cdti_trk1 = atoi(argv[1]);
        /* check range */

        if ( ioctl(cdfile, CDROMPLAYTRKIND, &ti) == -1 ) {
            sprintf(buffer, "%s: ioctl cdromplaytrkind: %s", 
						argv[0], strerror(errno));
	    Tcl_SetResult(interp, buffer, TCL_VOLATILE);
            return(TCL_ERROR);
        }

    }

}

static int do_pause(Tcl_Interp *interp, int argc, char *argv[], int cdfile)
{
    char  buffer[BUFSIZ];
    if ( ioctl(cdfile, CDROMPAUSE) == -1 ) {
        sprintf(buffer, "%s: ioctl cdrompause: %s", 
						argv[0], strerror(errno));
	Tcl_SetResult(interp, buffer, TCL_VOLATILE);
        return(TCL_ERROR);
    }

}

static int do_stop(Tcl_Interp *interp, int argc, char *argv[], int cdfile)
{
    char  buffer[BUFSIZ];
    if ( ioctl(cdfile, CDROMSTOP) == -1 ) {
        sprintf(buffer, "%s: ioctl cdromstop: %s", 
						argv[0], strerror(errno));
	Tcl_SetResult(interp, buffer, TCL_VOLATILE);
        return(TCL_ERROR);
    }

}

static int do_eject(Tcl_Interp *interp, int argc, char *argv[], int cdfile)
{
    char  buffer[BUFSIZ];
    if ( ioctl(cdfile, CDROMEJECT) == -1 ) {
        sprintf(buffer, "%s: ioctl cdromeject: %s", 
						argv[0], strerror(errno));
	Tcl_SetResult(interp, buffer, TCL_VOLATILE);
        return(TCL_ERROR);
    }

}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
