
/* My first sound mixer program. :)
   Thanks to xmix for example code on setting volumes.

   This one just modifies the master sound volume.


*/

#include	<sys/types.h>
#include	<stdio.h>
#include	<fcntl.h>
#include	<tcl.h>
#include <linux/soundcard.h>

#define DEV_MIXER		"/dev/mixer"
#define MAX_VOLUME	95
#define MIN_VOLUME	05
#define RIGHT			0x01
#define LEFT			0x02

typedef struct stereovolume
{
	unsigned char left;
	unsigned char right;
} StereoVolume;

extern
 int CDROM_Cmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]);

static int print_usage(char *cmd, Tcl_Interp *interp);
static unsigned char getvolume(char *value);
static void setvolume(int which, unsigned char setting, StereoVolume *volptr);
int VolumeCmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]);

static int mixer_fd;		/* File descriptor to the Sound Mixer device */

int Tkvolume_Init(Tcl_Interp *interp)
{
	char buffer[BUFSIZ];
	extern int errno;

	/*
	 * Add a few application-specific commands to the application's
	 * interpreter.
	 */
	Tcl_CreateCommand(interp, "volume", VolumeCmd,
                                (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "cdrom", CDROM_Cmd,
                                (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

	/* Open the mixer device */
	if ( (mixer_fd=open(DEV_MIXER, O_RDWR, 0)) < 0 ) {
		sprintf(buffer, "Can't open %s: %s", DEV_MIXER,strerror(errno));
		Tcl_SetResult(interp, buffer, TCL_VOLATILE);
		return(TCL_ERROR);
	}
	return(TCL_OK);
}

int VolumeCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	extern int optind;		/* For getopt() */
	extern char *optarg;		/* For getopt() */

	char buffer[BUFSIZ];
	char *progname=argv[0];
	int c;
	unsigned char setting;
	StereoVolume volume;

	if ( ioctl(mixer_fd, MIXER_READ(SOUND_MIXER_VOLUME), &volume) < 0 ) {
		Tcl_SetResult(interp, "Can't obtain current volume settings",
								TCL_VOLATILE);
		return(TCL_ERROR);
	}

	if ( ! argv[1] ) {
		sprintf(buffer, "%d", 
		(((volume.right-MIN_VOLUME)*100)/(MAX_VOLUME-MIN_VOLUME)));
		Tcl_SetResult(interp, buffer, TCL_VOLATILE);
		return(TCL_OK);
	}

	/* Get command line options and set volume */
	optind=1;
	while ( (c=getopt(argc, argv, "hr:l:")) != EOF ) {
		switch (c) {
			case 'r':
			if ( ((setting=getvolume(optarg))) == 0 && 
						(strcmp(optarg, "0") != 0) ) {
				sprintf(buffer,"Bad volume setting: %s", optarg);
				Tcl_SetResult(interp, buffer, TCL_VOLATILE);
				return(TCL_ERROR);
			}
			setvolume(RIGHT, setting, &volume);
			break;
			case 'l':
			if ( ((setting=getvolume(optarg))) == 0 && 
					(strcmp(optarg, "0") != 0) ) {
				sprintf(buffer, "Bad volume setting: %s", 
								optarg);
				Tcl_SetResult(interp, buffer, TCL_VOLATILE);
				return(TCL_ERROR);
			}
			setvolume(LEFT, setting, &volume);
			break;
			default:
			return(print_usage(progname, interp));
		}
	}
	argv += optind;

	if ( argv[0] && argv[1] )
		return(print_usage(progname, interp));
	else if ( argv[0] ) {
		if (((setting=getvolume(argv[0])) == 0)
					 && (strcmp(argv[0], "0") != 0)) {
			sprintf(buffer, "Bad volume setting: %s", argv[0]);
			Tcl_SetResult(interp, buffer, TCL_VOLATILE);
			return(TCL_ERROR);
		}
		setvolume(LEFT|RIGHT, setting, &volume);
	}
	if ( ioctl(mixer_fd, MIXER_WRITE(SOUND_MIXER_VOLUME), &volume) < 0 ) {
		sprintf(buffer, "Can't set current volume settings");
		Tcl_SetResult(interp, buffer, TCL_VOLATILE);
		return(TCL_ERROR);
	}
	return(TCL_OK);
}
          
static unsigned char getvolume(char *value)
{
	unsigned char setting;
	int percentage=0;

	if ( *(value+strlen(value)-1) == '%' ) {
		*(value+strlen(value)-1)='\0';
		++percentage;
	}
	if ( (setting=(unsigned char)atoi(value)) == 0 )
		return(0);

	if ( percentage )
		setting=((((MAX_VOLUME-MIN_VOLUME)*setting)/100)+MIN_VOLUME);
	else if ( setting > MAX_VOLUME )
		setting=MAX_VOLUME;
	else if ( setting < MIN_VOLUME )
		setting=MIN_VOLUME;
	return(setting);
}

static void setvolume(int which, unsigned char setting, StereoVolume *volptr)
{
	if ( setting < MIN_VOLUME )
		setting=MIN_VOLUME;
	if ( setting > MAX_VOLUME )
		setting=MAX_VOLUME;

	if ( which&RIGHT )
		volptr->right=setting;
	if ( which&LEFT )
		volptr->left=setting;
}

static int print_usage(char *cmd, Tcl_Interp *interp)
{
	char buffer[BUFSIZ];
	sprintf(buffer, "Usage: %s [-r volume] [-l volume] master_volume", cmd);
	Tcl_SetResult(interp, buffer, TCL_VOLATILE);
	return(TCL_ERROR);
}
