/*
From chaney@dans.comSun May 28 09:10:00 1995
Date: Sat, 27 May 1995 07:29:19 -0400 (EDT)
From: Dan Chaney <chaney@dans.com>
To: ears-list@ms.uky.edu
Subject: listen.c
*/
/* 
	Tinkerer's toy for ears.  

	This provides a C-front end for the listen program.  

	1. Compile the program			gcc act.c -o act
	2. Train the words listed in README
	3. Issue the command: 			listen | act

	Yes, it's a hack, but it's the result of many 4 AM sleepless nights :)
						chaney@dans.com
*/

#include <stdio.h>


/*  command(word)
    pass token, return the corresponding command to use instead.
    If word not matched, return NULL
*/
char *command(char *word) { 
	char comstring[1024];

	strcpy(comstring,"NULL");
	if (!strcmp(word,"call")) strcpy(comstring, "cu -l /dev/ttyS2 ");
	if (!strcmp(word,"xterm")) strcpy(comstring, "xterm & ");
	if (!strcmp(word,"Mosaic")) strcpy(comstring, "Mosaic & ");
	return(comstring);

} /* end command() */


/*  add_word(sentence, word)
    pass the current sentence and the word to add to it.
    If word is a single character (letter-x), add only the character.
    If word is a space or dash, convert to letter-- or letter-(space)
*/
int add_word(char *sentence, char *aword) {

	if (!strcmp(aword,"space")) strcpy(aword,"letter- ");
	if (!strcmp(aword,"dash")) strcpy(aword,"letter--");
        if (!strncmp(aword,"letter-",7)) {
                sprintf(sentence,"%s%c\0",sentence,aword[7]);
        } else {
                sprintf(sentence,"%s%s \0",sentence,aword);
        }
} /* add_word() */


/*
    del_word(sentence, word)
    pass sentence and word to delete.  del_word() assumes the word to
    delete is at the end of the sentence.  (This should be changed at
    some point to match from the right and delete the first occurance
    found.)
    If word is a single character (letter-x), delete only the character.
    Handle special cases (letter, dash) just as in add_word()
*/
int del_word(char *sentence, char *aword) {

	char sentence2[1024];
	int wordlen, length;

	printf("Old sentence: [%d] [%s] \n",strlen(sentence),sentence);
	wordlen=1+strlen(aword);
	printf("Word to delete: [%s] Length=%d\n",aword, wordlen);
	if (!strncmp(aword,"letter-",7)) {
		printf("\tCorrection, nuking one character\n");
		wordlen=1;
	}

	length=strlen(sentence)-wordlen;

	if (length<1) {	/* Handle 'clear' and 'backspace' on null sentences */
		strcpy(sentence,"");
		strcpy(sentence2,"");
	} else {
		strcpy(sentence2,sentence);
		sentence2[length]='\0';
		sentence[length]='\0';
	}
	printf("Resulting sentence: [%s]\n",sentence2);
	
} /* del_word */

/*
   get_word(word)
   Retrieve []-encased word from stdin (assumed to be output from 'listen')
   Optionally print out ? for sounds not recognized as words.
*/
int get_word(char *aword) {

	int done=0, inword=0;
	int misses=0;
	char c;
	strcpy(aword,"");
	while (!done) {
		c=fgetc(stdin); printf("%c",c); 
		if (c==']') {
			inword=0;
			done=1;
			misses=0;
		}
		/* Comment this out if you DON'T want to see ?'s */
		if (c=='?') printf("?"); fflush(stdout);
		if (c=='[') inword=1;
		else if (inword==1) sprintf(aword,"%s%c\0",aword,c);
	}

} /* end get_word() */	

/*
    process_word(word, sentence)
    pass word, determine type of word:
	- If internal command, perform (clear, execute, show, etc.) and return
	- If external command, convert it to new command string (command())
	- Add word to sentence
    (See README for a more complete list of internals and commands)
*/
int process_word(char *aword, char *sentence) {

	int retval=0; /* If retval != 0 at the end of the function,
			 the word is *NOT* added to the sentence.
			 Retval=1 indicates an internal command was issued
		       */
	char line2[1024];
	char word2[80];
	char *tmp;

	if (!strcmp(aword,"")) {
		printf("process_word: empty string detect");
		return(0);
	}

	printf("Processing: [%s]\n",aword);

	/* Check to see if word has a command() to swap in place of it */
	strcpy(word2,command(aword)); 
	printf("command returned: %s\n",word2);
	if (strcmp(word2,"NULL")) {
		printf("Command replacement: Swapping [%s] for [%s]\n",word2,aword);
		strcpy(aword,word2);
	}
	
	if (!strcmp(aword,"show")) { /* If show, print sentence */
		printf("\nCurrent sentence: [%s] \n",sentence);
		retval=1;
	}	
	
	if (!strcmp(aword,"execute")) { /* If execute, call system */
		printf("Execution requested: %s\n",sentence);
		system(sentence); /* Voice recognition *is* security :) */
		retval=1;
		strcpy(sentence,"");
	}
	
	if (!strcmp(aword,"clear")) { /* Clear out sentence */
		strcpy(sentence,"");
		retval=1;
	}
	
	if (retval==0) add_word(sentence,aword);
	printf("Processed: [%s]\n",aword);
} /* End process_word */
	
main() {
	char lastword[100],word[100];
	char sentence [280];
	char c;	
	int listen=1,done=0, pflag=0;

	printf("Starting up new SR system.\n");
#if 0
	gets(sentence); puts(sentence); /* Print first 2 lines of output */
	gets(sentence); puts(sentence);	/8 From 'listen' program */
#endif	
	/* system("stty raw"); /* Useful for debugging from keyboard */
	strcpy(sentence,"");
	strcpy(word,"");
	while (!done) {
		pflag=0;
		get_word(word); 

		/* Hard-code these here in case something breaks elsewhere */
		if (!strcmp(word,"abort")) { printf("Aborting.\n"); exit(9); }
		if (!strcmp(word,"restart")) { 
			printf("restarting.\n"); 
			execve("listen | act", NULL);
		}	

		/* Move this to process_word when pflag is no longer used */
		if (!strcmp(word,"computer")) { 
			printf("Yes?.\n"); 
			pflag=1;
			system("/usr/local/bin/sbeep");
		 }

		/* Move this to process_word when pflag is no longer used */
		if (!strcmp(word,"backspace"))  {
			printf("* detected request for character removal *\n");
			del_word(sentence, "letter-X");
			pflag=1;
		}

		/* Move this to process_word when pflag is no longer used */
		if (!strcmp(word,"wrong"))  {
			printf("* detected wrong word *\n");
			del_word(sentence, lastword);
			pflag=1;
		}

		/* Move this to process_word when mute is no longer used */
		if (!strcmp(word,"mute")) {
			pflag=1;
			if (listen==1) {
				listen=0;
				printf("Mute on.   Computer is not listening.\n");
			} else {
				listen=1;
				printf("Mute off.  Computer is listening.\n");
			}
		} 

		if (listen==0) printf("Muted.  Did not hear %s\n",word);
	
		if (pflag==0) {	
			printf("---[%s]---\n",word);
			strcpy(lastword,word);
			process_word(word,sentence);
		}
/* Debugging */
printf("\n---------------------------------------------------------------\n");
printf("Sentence: %s\n",sentence);
printf("Word: %s\t\t\tLastword: %s\n",word,lastword);
printf("---------------------------------------------------------------\n");

	}
} /* end main() */
