#!/usr/local/bin/perl 
# ---------------------------------------------------------------------
# From: "Karl J. Runge" <runge@redhook.llnl.gov>:
#
# I've never used a speech recognition program before, pretty fun!
# I even wrote a perl script to let me launch xterm, emacs, xclock, etc,
# via voice. It's a far cry from "Computor, Beam up Capn Kirk!" but what
# can I say.
# ---------------------------------------------------------------------

#---------------------------------------------------------------
# Simple demo of launching applications by voice using ears-0.14
#---------------------------------------------------------------

$dir = '';				# Use this if "listen" is in PATH
#$dir = '/usr2/local+/ears-0.14/';	# otherwise put full path
#----

# Input your List of actions:

$Commands{'xterm'} = 'xterm -geometry %GEOM -bg hotpink </dev/null';
$Commands{'clock'} = 'xclock -geometry %GEOM -bg green';
$Commands{'emacs'} = 'emacs -geometry %GEOM';
$Commands{'calculator'} = 'xcalc -geometry %GEOM';
$Commands{'kittycat'} = 'xneko -geometry %GEOM';

# For example, you have recorded the word "xterm" with train_ears, and
# the listen program returns the string "xterm" when you say it.
#----


				# Simple shifting of position of windows.
$geom_shift = '50';		# This is just a kludge to avoid eclipsing
$geom_start = '100'; 		# windows, by shifting each one over a bit
				# String "%GEOM" in Action is replaced.

#---No need to change stuff below this line-------------------------------

if ( $dir ne "" && $dir !~ /\/$/ ) {	# put trailing slash onto $dir
	$dir .= '/';
}

					# open read pipe from "listen" prgm
open(LISTEN,"${dir}listen|") || die "Cannot open listen program";

select LISTEN; $| = 1;			# make all file handles/pipes unbuffered.
select STDOUT; $| = 1;

$input_string = '';			# string to accumlate input from LISTEN

$count = '0';

# loop and get chars from LISTEN:

for ($i=0; $i < 400; $i++ ) {		# Do finite loop instead of while (1) 

	$from = getc(LISTEN);		# get next char
	print STDOUT $from;		# put it out
	$input_string .= $from;		# accumulate

					# check for match to an action
	foreach $cmd (sort(keys(%Commands))) {
		if ( $input_string =~ /$cmd$/ ) {
			$input_string = '';	# reset
						# compute new geom
			$geom = $geom_start + ${geom_shift}*$count++;
			$geom = "+".$geom."+".$geom;

			$Cmd = $Commands{$cmd};	# get command
			$Cmd =~ s/%GEOM/$geom/;	# regsub geometry
	
			system("$Cmd &");	# launch it
		}
	}
}

exit 0;

__END__

# Template of replacement loop if "listen" output a newline each time
# spit out a response, e.g. "listen -nl". This would be a good deal
# faster than above menthod if one had alot of commands. Also
# avoids the problems have having conflicting words e.g. "xterm" and "term".

while (<LISTEN>) {
	chop( $cmd = $_ );
	if ( $Commands{$cmd} ) {

		$geom = $geom_start + ${geom_shift}*$count++;
		$geom = "+".$geom."+".$geom;

		$Cmd = $Commands{$cmd};	# get command
		$Cmd =~ s/%GEOM/$geom/;	# regsub geometry
	
		system("$Cmd &");	# launch it
	}
}


