#ifndef Cfg_file_h
#define Cfg_file_h

#include <string>
#include <fstream.h>
#include <stdio.h>

class cfg_file
{
private:
  char fn[256], tfn[256];
  fstream fs;
  bool first;

public:

  explicit cfg_file (const string& path) 
  : first(true)
  { 
    strcpy(fn,path.c_str());
    strcpy(tfn,fn);
    strcat(tfn,".tmp");
    fs.open(fn,ios::in); 
  }
  ~cfg_file()
  {
    fs.close();
    if (!first)
    {
      remove (fn);
      rename (tfn,fn);
    }
  }
  
  bool getpair (string& s1, string& s2) 
  { 
    char* p;
    s1 = "";
    fs >> s1 >> ws;
    fs.gets (&p);
    s2 = p ? p : "";
    if (fs.eof() && s2.length()==0) return false;
    return true; 
  }

  bool exists() { return fs? true:false; }

  void write (const string& s1, const string& s2) 
  { 
    if (first) { fs.close(); fs.open(tfn,ios::out|ios::trunc); first=false; }
    fs << s1 << " " << s2 << endl;
  }
};
#endif
