/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation 
#include <fstream.h>
#include "config.h"
#include "cfg_file.h"
#include "messages.h"
#include "others/mystring.h"


config* config::instance_ = 0;  // is a singleton
//------------------------------PUBLICS---------------------------------
bool config::bget (const char* p) const 
{ 
  string s = (*this)[p]; 
  return upcase(s)==messages::InstanceRef().iyes(); 
}

void config::set (const string& s, bool b) 
{ 
  messages& msg = messages::InstanceRef();
  map_[s] = b? msg.iyes() : msg.ino(); 
}

//----------------------------PRIVATES----------------------------------

// Write config file if it doesn't exist.
void config::save_rc (bool force) const
{
  cfg_file cf (rcpath_);
  if (!force)
  {
    if (cf.exists()) return;
    messages& msg = messages::InstanceRef();
    if (msg.yesno(M_Create_Rc,YES,true)<=0)
      throw(fatal_exception());
  }
  SSMap::const_iterator cit_ = map_.begin();
  for ( ; cit_ != map_.end(); cit_++)
    cf.write ((*cit_).first, (*cit_).second);
}

