#pragma interface
#ifndef Config_h
#define Config_h

#include <string>
#include <stdlib.h>
#include <map.h>
#include "exception.h"

typedef map<string, string, less<string> > SSMap;

class config
{
public:
  static config* Instance()    { return instance_; }
  static config& InstanceRef() { return *instance_; }

  bool bget (const char* p)    const;
  void set (const string& s, bool b);
  void set (const string& s1, const string& s2) 
                                     { map_[s1] = s2; }
  
  void set (const string& s1, const char* s2) 
                                     { map_[s1] = string(s2); }
  
  int iget (const char* p)     const { string s = (*this)[p]; 
                                       return atoi(s.c_str()); }
  const string& operator[] (const string& s) 
                               const { SSMap::const_iterator cit_ = map_.find(s);
                                       if (cit_ == map_.end()) 
                                         throw(unknown_config(s)); 
                                       return (*cit_).second; }
  void save()                  const { save_rc (true); }

  const SSMap& map()           const { return map_; }

  const string& pattern_path() const { return pattern_path_; }
  void set_patpath (const string& s) { pattern_path_ = s; }
  const string& pat_type()     const { return pat_type_; }
  void set_pattype (const string& s) { pat_type_ = s; }
  
  bool training_needed()       const { return train_; }

private:
  
  static config* instance_;
  const string home_;
  string pattern_path_, pat_type_, rcpath_;
  bool train_;
  SSMap map_;
  SSMap::const_iterator cit_; 
  
  friend class ConfigProtocol;
  config () { instance_=this; }
  ~config() {}
    
  void set_rcpath (const string& s)  { rcpath_ = s; }
  void save_rc (bool) const;
};

#endif
