#pragma interface
#ifndef Exception_h
#define Exception_h

#include <string>
#include <iostream.h>

class exception
{
public:
  void print() { cerr << "Basic Exception.\n"; }
};

class fatal_exception : public exception
{
public:
  fatal_exception() : s_("") {}
  explicit fatal_exception (char* p) : s_(p) {}
  explicit fatal_exception (const string& s) : s_(s) {}
  void print() const
  { 
    cerr << "Fatal Exception"; 
    if (!s_.empty()) cerr << ": " << s_; 
    cerr << ".\n";
    cerr.flush();
  }
private:
  const string s_;
};

class unknown_config : public fatal_exception
{
public:
  explicit unknown_config (const string& s) : s_(s) {}
  void print() const { cerr << "Unknown config: " << s_ << endl; }
private:
  const string s_;
};

//class bad_sample : public exception {};
//class bad_speech : public exception {};

#define throw(par) Throw(par)
#define try
#define catch if
void Throw (const unknown_config& uc);
void Throw (const fatal_exception& fe);
void Throw (int i);

#endif
