/*
    This file is part of the 'ears' package.
    Copyright (C) 1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include "feature.h"
#include "modules/sample.h"
#include "screen.h"
#include "exception.h"
#include "others/time.h"

struct fvec{
	float *values;
	int length;
	};

extern "C" { void do_rasta (fvec*,fvec**,int*,int,int); }

//-----------------------------FEATURE--------------------------------
feature::feature (const sample &s, const string &type) :
         method_(type), coeff_(8)
{
  if (type == "PLP" || type == "MRASTA") ; // gcc-2.7.2 workaround
  else
    throw(fatal_exception(
    "Sorry, OGI's feature extractors are no longer supported.\n\
    Please use FEATURE MRASTA in ~/.earsrc and do train_ears again.\n"));

  Time t;
  fvec v;
  v.values = new float[v.length=s.len()];
  for (int k=0; k<s.len(); k++)
    v.values[k] = s[k];
  fvec* all[1000];
  int rasta_f = (type == "MRASTA");
  do_rasta (&v, &(all[0]), &nframes_, s.rate(), rasta_f);
  delete v.values;
  if (nframes_<10) 
    throw(fatal_exception("nframes < 10"));
  
  mat_ = new fmat (nframes_, coeff_);
  fmat& m = *mat_;
  for (int k=0; k<nframes_; k++)
    for (int l=0; l<coeff_; l++)
      m[k][l] = ((all[k])->values)[l];

  screen::Instance()->setRastaTime(int((t.stop())/1000.0));
}

feature::~feature() { delete mat_; }

ostream& operator<< (ostream& o, const feature& f)
{
  o << f.coeff_ << " ";
  for (int k=0; k<f.nframes_; k++)
    for (int l=0; l<f.coeff_; l++)
      o << f.mat_->operator[](k)[l] << " ";
  return o;
}

