#pragma interface
#ifndef Feature_h
#define Feature_h

#include <string>
#include "fmat.h"

class feature               // The utterance, stripped to its bare features
{
public:
  feature (const class sample& s, const string& f);
  //PROMISE: Builds a feature out of a sample
  ~feature();
  
  fmat& buffer() const   { return *mat_; }
  int length() const     { return nframes_; }  
  int coeff() const      { return coeff_; }
  friend ostream& operator<< (ostream& o, const feature& f);

private:
  const string method_;
  fmat* mat_;
  int nframes_, coeff_;
};

#endif
