#ifndef Fmat_h
#define Fmat_h

class fmat
{
public:
  fmat() : values_(0), nrows_(0), ncols_(0) {}
  fmat (int r, int c) : nrows_(r), ncols_(c)
  {
    values_ = new float* [nrows_];
    for (int k=0; k<nrows_; k++)
      values_[k] = new float [ncols_];
  }
  
  ~fmat() 
  {
    for (int k=0; k<nrows_; k++)
      delete [] values_[k];
    delete [] values_;
  }  
  
  void init (int r, int c)
  {
    values_ = new float* [nrows_=r];
    for (int k=0; k<nrows_; k++)
      values_[k] = new float [ncols_=c];
  }
  
  float* operator[] (int k) const { return values_[k]; }
  float** buf() const             { return values_; }
  int rows() const                { return nrows_; }
  int cols() const                { return ncols_; }

private:
  float **values_;
  int nrows_, ncols_;
};

#endif
