/*
    This file is part of the 'ears' package.
    Copyright (C) 1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include "info_cfg.h"
#include "others/mystring.h"

//====================================================================
typedef struct cfg_help_entry { char *key,*entry; } che;
static che entries[] = 
{
  { "EARS_PATH"     , "Path of the .ears data directory" },
  { "KEEP_SAMPLES"  , "Whether sound data is saved as raw/*.wav" },
  { "FEATURE"       , "The feature extraction method" },
  { "RECOGNIZER"    , "The recognition method" },
  { "MIN_NUM_WORDS" , "How often each word must be spoken" },
  { "BASENAME"      , "Filename used if no -b option given" },
  { "SOUND_BITS"    , "Sampling resolution" },
  { "SOUND_SPEED"   , "Sampling rate in Hz" },
  { "DEBUG"         , "Gives statistics inside 'listen' program" },
  { "NEWLINE"       , "Outputs NL after each word (text-only)" },
  { "TEST"          , "The input to 'listen' comes from test/*" },
  { "NOCURSES"      , "Programs don't use fancy graphics" },
  { "EXECUTE"       , "'listen' calls system() with word entry" }
};

void InfoCfg::build_help()
{
  for (unsigned k=0; k<sizeof(entries)/sizeof(che); k++)
    helpmap_[entries[k].key] = entries[k].entry;
}

//--------------------------------------------------------------
void InfoCfg::build_list()
{
  int maxk=0, maxv=0;
  SSMap::const_iterator cit_ = mapp_.begin();
  for (; cit_ != mapp_.end(); cit_++)
  {
    if ((*cit_).first.length() > maxk)
      maxk = (*cit_).first.length();
    if ((*cit_).second.length() > maxv)
      maxv = (*cit_).second.length();
  }

  string spaces = replicate(' ',60);           // not good
  cit_ = mapp_.begin();
  list_.erase (list_.begin(), list_.end());
  for (; cit_ != mapp_.end(); cit_++)
  {
    string line = (*cit_).first + spaces;
    capitalize(line);
    line[maxk+1] = ':';
    string l = line.substr(0,maxk+1);
    l += " ";
    l += (*cit_).second;
    list_.push_back(l);
  }
}

const string& InfoCfg::strings_key (int i) const
{
  int k;
  SSMap::const_iterator cit_ = mapp_.begin();
  for (k=0; (k!=i && cit_ != mapp_.end()); cit_++,k++) ;
  if (k!=i) return errstr_;
  return (*cit_).first;
}

const string& InfoCfg::strings_value (int i) const
{
  int k;
  SSMap::const_iterator cit_ = mapp_.begin();
  for (k=0; (k!=i && cit_ != mapp_.end()); cit_++,k++) ;
  if (k!=i) return errstr_;
  return (*cit_).second;
}
