#ifndef InfoCfg_h
#define InfoCfg_h
#pragma interface

#include <string>
#include <list.h>
#include <map.h>

typedef map<string, string, less<string> > SSMap;
typedef list<string> SList;

class InfoCfg
{
public:
  InfoCfg (const SSMap& m) : mapp_(m), errstr_("Error")
                               { build_help(); }
  ~InfoCfg()                   { }

  int size() const             { return helpmap_.size(); }
  const SList& contents()      { build_list(); return list_; }
  const SSMap& strings() const { return helpmap_; }
  const string& strings_key (int) const;
  const string& strings_value (int) const;

private:
  const SSMap& mapp_;
  const string errstr_;
  SSMap helpmap_;
  SList list_;
  
  void build_help();
  const string& get_help (const string&) const;
  void build_list();
  void build_strings();
};


#endif
