/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include <string>
#include <stream.h>
#include "lscreen.h"

lscreen::lscreen() : screen("listen"), debug_f_(false)
{
}

lscreen::~lscreen()
{
  close();
}

void lscreen::init (bool b) 
{ 
  debug_f_=b; 
  debug_l_.push_back("");
  debug_l_.push_back("----------------------         ");
  debug_l_.push_back("");
  debug_l_.push_back("");
  debug_l_.push_back("");
  debug_l_.push_back("");
  debug_l_.push_back("");
  debug_l_.push_back("");

  if (b)
  {
    debug_w_ = ui_->makeInfow ("Recognition stats");
    ui_->infow_fill (debug_w_, debug_l_);
  }
}

void lscreen::redraw_debug_info (SList& l)
{
  if (!debug_f_) return;
  
  string s = "Pure Rasta time: ";
  s += dec(RastaTime_);
  s += " ms";
  l.push_back (s);
  ui_->infow_fill (debug_w_, l, true);
}

void lscreen::close()
{
  ui_->close_all_wins();
  screen::close();
}

void lscreen::show_menu()
{
  menu_l_.push_back("F1      - Help");
  menu_l_.push_back("F2      - Toggle debug");
  menu_l_.push_back("Return  - Listen");
  menu_l_.push_back("F10/Esc - Quit");

  menu_w_ = ui_->makeInfow("");
  ui_->infow_fill (menu_w_, menu_l_);
}

//--------------------------------------------------------------

void lscreen::toggle_debug()
{
  if (debug_f_) ui_->infow_close (debug_w_);
  else { debug_w_ = ui_->makeInfow ("Recognition stats");
         ui_->infow_fill (debug_w_, debug_l_); }
  debug_f_ = !debug_f_;
}