#ifndef Lscreen_h
#define Lscreen_h
#pragma interface

#include "screen.h"

typedef list<string> SList;

class lscreen : public screen        // main screen of the listen program
{
public:
  lscreen();   // init and draw screen
  virtual ~lscreen();  // clear screen, reset state as was before
  virtual void close();
  void init (bool);
  void show_menu();  
  void redraw_debug_info (SList&);

  void help() { ui_->show_file ("HELP.listen"); }
  void toggle_debug();

private:
  bool debug_f_;
  win_hdl menu_w_, debug_w_;
  SList menu_l_, debug_l_;
};

#endif
