/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// Special thanks to Patrick D'Cruze for his Locale Tutorial

#pragma implementation 
#include <stdlib.h>
#include <stdio.h>
#include <stream.h>
#include <strstream.h>
#include <ctype.h>
#include "messages.h"
#include "screen.h"
#include "exception.h"

#ifdef NLS
#include <locale.h>
#include <nl_types.h>
static nl_catd catfd = (-1);
#endif

messages* messages::instance_ = 0;  // is a singleton

// A pathetic attempt to internationalization
//--------------------------PUBLICS--------------------------------------

messages::messages ()
{
#ifdef NLS
  setlocale (LC_MESSAGES, "");
  catfd = catopen ("ears", MCLoadAll);
#endif
  instance_ = this;
}

// Outputs a string (number m) and waits until one of Yes/No is
// answered, or Ja/Nein, or Oui/Non, or Da/Nyet, if you prefer.

int messages::yesno (int m, int deflt, bool bailout)
{
  char yn[8];
//  ostrstream f(yn,8);
//  f.form("[%c/%c]",yes()[0],no()[0]);
  sprintf(yn,"[%c/%c]",yes()[0],no()[0]);
  yn[5] = '\0';  // strstream or form bug?  it appends newline
  if (deflt==YES) { yn[1]=toupper(yn[1]); yn[3]=tolower(yn[3]); }
  else            { yn[1]=tolower(yn[1]); yn[3]=toupper(yn[3]); }

  string s;
  s = s + "--> " + get(MST,m) + " " + yn + " ";
  char allowed_keys[8];
  allowed_keys[0]=tolower(yes()[0]);
  allowed_keys[1]=tolower(no()[0]);
  allowed_keys[2]=toupper(yes()[0]);
  allowed_keys[3]=toupper(no()[0]);
  allowed_keys[4]=0x0a;
  allowed_keys[5]=0;
  int key = screen::InstanceRef().query (s, allowed_keys);

  if (key==0x03) { throw(fatal_exception("Control-C pressed.")); }
  if (key==0x1b) 
    if (bailout) throw(fatal_exception("Escape pressed.")); 
    else         return -1;
  if (key==0x0a || key==0x0d) return deflt;
  if (tolower(key)==tolower(yes()[0])) return YES;
  if (tolower(key)==tolower(no ()[0])) return NO;

  return deflt; // not reached
}

void messages::note (const string& text) const 
{ screen::InstanceRef().note(text); }

// Interface to the catalog, or a simple lookup.
const char *messages::get (int set, int msg) const
{
#ifdef NLS
  return catgets (catfd, set, msg, MS[set][msg]);
#else
  return MS[set][msg];
#endif
}
