#pragma interface
#ifndef Messages_h
#define Messages_h

#include <string>
#include "texts.h"

class messages
{
  friend class TrainEarsProtocol;
  friend class ListenProtocol;

public:
  static messages* Instance()    { return instance_; }
  static messages& InstanceRef() { return *instance_; }

  int yesno (int, int=YES, bool=false);
  void note (const string&) const;
  const char* get (int, int) const;

  const char* no()   { return get(MST,M_No); }
  const char* yes()  { return get(MST,M_Yes); }
  const char* ino()  { return "NO"; }
  const char* iyes() { return "YES"; }
  
private:
  messages ();
  ~messages () {}
  static messages* instance_;
};

#endif
