#ifndef Myrandom_h
#define Myrandom_h
/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#include <stddef.h>
#include "others/time.h"

class __random_generator {
protected:
    unsigned long table[55];
    size_t index1;
    size_t index2;
public:
    unsigned long operator()(unsigned long limit) {
	index1 = (index1 + 1) % 55;
	index2 = (index2 + 1) % 55;
	table[index1] = table[index1] - table[index2];
	return table[index1] % limit;
    }
    inline void seed(unsigned long j);
    __random_generator(unsigned long j) { seed(j); }
};

inline void __random_generator::seed(unsigned long j) {
    unsigned long k = 1;
    table[54] = j;
    for (size_t i = 0; i < 54; i++) {
        size_t ii = 21 * i % 55;
        table[ii] = k;
        k = j - k;
        j = table[ii];
    }
    for (int loop = 0; loop < 4; loop++) {
        for (size_t i = 0; i < 55; i++)
            table[i] = table[i] - table[(1 + i + 30) % 55];
    }
    index1 = 0;
    index2 = 31;
}

class RandomInteger
{
public:
  RandomInteger (int from, int to) : from_(from), range_(to-from+1)
                   { r_ = new __random_generator (t_.seed()); }
  ~RandomInteger() { delete r_; }
  int operator()() { return (*r_)(range_) + from_; }

private:
  __random_generator* r_;
  Time t_;
  const from_,range_;
};

#endif