#ifndef ConfigProtocol_h
#define ConfigProtocol_h
#pragma interface

#include <string>
#include "protocol.h"

class ConfigProtocol : public Protocol
{
public:
  ConfigProtocol (int, char**, bool);
  virtual ~ConfigProtocol()                  {}
  virtual void start();

private:
  int argc_;
  char **argv_;
  bool strict_;
  string home_;
  
  void init (int,char**,bool); 
  void check_libs (string);
  void get_major_minor (string, int&, int&, int&);
  void set_default();
  void rc_file();
  void options();
  void tinyoptions();
  void make_paths();
  void upcase_entries();
  void globals();
  void usage (char*);
  void tinyusage (char*);
};

#endif
