/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include <string>
#include <stdio.h>
#include <fstream.h>
#include "config.h"
#include "pr_config.h"
#include "messages.h"
#include "words.h"
#include "pr_recording.h"
#include "pr_listen.h"
#include "modules/recognizer.h"
#include "listen.h"
#include "exception.h"
#include "lscreen.h"
#include "sound.h"

ListenProtocol::ListenProtocol (int i, char** p) 
: argc_(i), argv_(p)
{
}

void ListenProtocol::start()
{
  lscreen lscr;
  messages msg;

  { ConfigProtocol P (argc_, argv_, true); P.start(); }
  config& cfg = config::InstanceRef();

  lscr.change_to_gui_if_possible();

  words wrd;
  wrd.try_to_load (cfg["BASENAME"], cfg["EARS_PATH"]);
  if (wrd.not_loaded())
  {
    string t = "Words file not found: ";
    t += cfg["BASENAME"];
    t += ".words";
    throw(fatal_exception(t));
  }

  Sound sound (cfg.iget("SOUND_SPEED"), cfg.iget("SOUND_BITS"));

  bool debug = cfg.bget("DEBUG");
  lscr.show_menu();
  lscr.init (debug); 
  
  key_type key;
  while ((key = lscr.getkey()) != 0)  // if gui_type==uiRaw, returns RET+ESC
  {
    switch (key)
    {
    case 0x03: throw(fatal_exception("Control-C pressed.")); 

    case 0x0112:
    case 0x1b:   
      return;
    
    case 0x0109: 
      lscr.help();   
      break;
      
    case 0x010a:
      debug = !debug;
      lscr.toggle_debug();
      cfg.set ("DEBUG",debug);
      break;
      
    case 0x0d:
      string rfn = cfg["EARS_PATH"]+"/"+cfg["BASENAME"]+"."+cfg["RECOGNIZER"];
      ifstream rf (rfn.c_str());
      if (rf.bad()) 
      {
        string t = "No net file ";
        t = t + rfn + " found.  Did you run train_ears?";
        lscr.note(t);
        break;
      }

      recognizer recog (cfg["RECOGNIZER"],cfg.bget("DEBUG"));
      rf >> recog;

      lscr.recw_open();
      string empty="\n";
      lscr.recw_speak(empty);

      while(1)
      {
        RecordingProtocol P;
        P.start();
        if (!lscr.recw_again()) 
        { 
          lscr.recw_close(); 
          break; 
        }
        result guess (wrd, recog << P.getPattern(), false);
        lscr.recw_result(guess.contents());
        lscr.redraw_debug_info (recog.deb_info());
        if (cfg.bget("EXECUTE"))
        {
          sound.deaf_mic();
          system (guess.contents().c_str());
          sound.full_mic();
        }
      }
    }
  }
}

