/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include "pr_rec_aw.h"
#include <stdlib.h>
#include <dirent.h>
#include <stream.h>
#include <fstream.h>
#include "config.h"
#include "words.h"
#include "pr_recording.h"
#include "modules/pattern.h"
#include "modules/sample.h"
#include "screen.h"
#include "sound.h"

//---------------------------PUBLICS-------------------------------------
void RecordingAllWordsProtocol::start()
{
  config& cfg = config::InstanceRef();
  screen& scr = screen::InstanceRef();
  scr.recw_open();
  stopped_ = false;

  while (true)
  {
    string str = words::Instance()->rnd_missing();
    if (str.length() == 0) break;
    scr.recw_speak(str);

    RecordingProtocol P;
    P.start();
    if (!scr.recw_again()) { stopped_=true; break; }

    string fn = getnextfilename(str);
    string pfn = cfg.pattern_path() + "/" + fn;
    ofstream patfile (pfn.c_str());
    patfile << P.getPattern();

    if (cfg.bget("KEEP_SAMPLES"))
    {
      string sfn = cfg["EARS_PATH"] + "/raw/" + fn;
      Sound::Instance()->save_sample (P.sample(), sfn);
    }
    
    scr.recw_ok();
  }
  scr.recw_close();
}

//------------------------------PRIVATES-------------------------------
const string RecordingAllWordsProtocol::getnextfilename (const string& str)
{
  string path = config::InstanceRef().pattern_path();
  DIR* dp = opendir(path.c_str());
  struct dirent *p;
  int max=0;

  while ((p=readdir(dp))!=0)
  {
    string fn = p->d_name;
    string label = fn.substr(0,fn.find("."));
    if (str == label)
    {
      string nr = fn.substr(fn.find(".")+1);
      int c = atoi(nr.c_str());
      if (c>max) max=c;
    }
  }
  closedir(dp);
  string s = str + "." + dec(max+1);
  return s;
}

