/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include <stream.h>
#include "modules/sample.h"
#include "modules/pattern.h"
#include "config.h"
#include "time.h"
#include "pr_recording.h"
#include "speechstream.h"
#include "feature.h"
#include "exception.h"
#include "screen.h"

//---------------------------PUBLICS-------------------------------------
RecordingProtocol::RecordingProtocol () : sample_(0), pat_(0)
{
  config& cfg = config::InstanceRef();
  speech_ = new speechstream 
           (cfg.iget("SOUND_SPEED"), cfg.iget("SOUND_BITS"));
}

RecordingProtocol::~RecordingProtocol() 
{ 
  delete speech_; 
  delete pat_;
}

void RecordingProtocol::start()
{
  extern int bad_sample, bad_speech;
  speechstream& speech = *speech_;
  static class sample sam;
  sample_ = &sam;

  while (1)
  {
    speech >> sam; 
    if (!bad_sample && !bad_speech) break;
    if (bad_sample!=-1) continue; 
    else                throw(-1); 
  }
  
  if (!screen::InstanceRef().recw_again()) 
    { pat_ = new pattern; return; } // when do we finally use exceptions?  sigh

  config& cfg = config::InstanceRef();
  feature fea (sam, cfg["FEATURE"]);
  pat_ = new pattern (fea, cfg["RECOGNIZER"]);
}
